// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagent

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagent/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates an alias of a flow for deployment. For more information, see [Deploy a flow in Amazon Bedrock] in the
// Amazon Bedrock User Guide.
//
// [Deploy a flow in Amazon Bedrock]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-deploy.html
func (c *Client) CreateFlowAlias(ctx context.Context, params *CreateFlowAliasInput, optFns ...func(*Options)) (*CreateFlowAliasOutput, error) {
	if params == nil {
		params = &CreateFlowAliasInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateFlowAlias", params, optFns, c.addOperationCreateFlowAliasMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateFlowAliasOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateFlowAliasInput struct {

	// The unique identifier of the flow for which to create an alias.
	//
	// This member is required.
	FlowIdentifier *string

	// A name for the alias.
	//
	// This member is required.
	Name *string

	// Contains information about the version to which to map the alias.
	//
	// This member is required.
	RoutingConfiguration []types.FlowAliasRoutingConfigurationListItem

	// A unique, case-sensitive identifier to ensure that the API request completes no
	// more than one time. If this token matches a previous request, Amazon Bedrock
	// ignores the request, but does not return an error. For more information, see [Ensuring idempotency].
	//
	// [Ensuring idempotency]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
	ClientToken *string

	// The configuration that specifies how nodes in the flow are executed in parallel.
	ConcurrencyConfiguration *types.FlowAliasConcurrencyConfiguration

	// A description for the alias.
	Description *string

	// Any tags that you want to attach to the alias of the flow. For more
	// information, see [Tagging resources in Amazon Bedrock].
	//
	// [Tagging resources in Amazon Bedrock]: https://docs.aws.amazon.com/bedrock/latest/userguide/tagging.html
	Tags map[string]string

	noSmithyDocumentSerde
}

type CreateFlowAliasOutput struct {

	// The Amazon Resource Name (ARN) of the alias.
	//
	// This member is required.
	Arn *string

	// The time at which the alias was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The unique identifier of the flow that the alias belongs to.
	//
	// This member is required.
	FlowId *string

	// The unique identifier of the alias.
	//
	// This member is required.
	Id *string

	// The name of the alias.
	//
	// This member is required.
	Name *string

	// Contains information about the version that the alias is mapped to.
	//
	// This member is required.
	RoutingConfiguration []types.FlowAliasRoutingConfigurationListItem

	// The time at which the alias of the flow was last updated.
	//
	// This member is required.
	UpdatedAt *time.Time

	// The configuration that specifies how nodes in the flow are executed in parallel.
	ConcurrencyConfiguration *types.FlowAliasConcurrencyConfiguration

	// The description of the alias.
	Description *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateFlowAliasMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateFlowAlias{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateFlowAlias{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateFlowAlias"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateFlowAliasMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateFlowAliasValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateFlowAlias(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateFlowAlias struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateFlowAlias) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateFlowAlias) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateFlowAliasInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateFlowAliasInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateFlowAliasMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateFlowAlias{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateFlowAlias(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateFlowAlias",
	}
}
