// Code generated by smithy-go-codegen DO NOT EDIT.

package b2bi

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/b2bi/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a partnership between a customer and a trading partner, based on the
// supplied parameters. A partnership represents the connection between you and
// your trading partner. It ties together a profile and one or more trading
// capabilities.
func (c *Client) CreatePartnership(ctx context.Context, params *CreatePartnershipInput, optFns ...func(*Options)) (*CreatePartnershipOutput, error) {
	if params == nil {
		params = &CreatePartnershipInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreatePartnership", params, optFns, c.addOperationCreatePartnershipMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreatePartnershipOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreatePartnershipInput struct {

	// Specifies a list of the capabilities associated with this partnership.
	//
	// This member is required.
	Capabilities []string

	// Specifies the email address associated with this trading partner.
	//
	// This member is required.
	Email *string

	// Specifies a descriptive name for the partnership.
	//
	// This member is required.
	Name *string

	// Specifies the unique, system-generated identifier for the profile connected to
	// this partnership.
	//
	// This member is required.
	ProfileId *string

	// Specify the structure that contains the details for the associated capabilities.
	CapabilityOptions *types.CapabilityOptions

	// Reserved for future use.
	ClientToken *string

	// Specifies the phone number associated with the partnership.
	Phone *string

	// Specifies the key-value pairs assigned to ARNs that you can use to group and
	// search for resources by type. You can attach this metadata to resources
	// (capabilities, partnerships, and so on) for any purpose.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreatePartnershipOutput struct {

	// Returns a timestamp for creation date and time of the partnership.
	//
	// This member is required.
	CreatedAt *time.Time

	// Returns an Amazon Resource Name (ARN) for a specific Amazon Web Services
	// resource, such as a capability, partnership, profile, or transformer.
	//
	// This member is required.
	PartnershipArn *string

	// Returns the unique, system-generated identifier for a partnership.
	//
	// This member is required.
	PartnershipId *string

	// Returns the unique, system-generated identifier for the profile connected to
	// this partnership.
	//
	// This member is required.
	ProfileId *string

	// Returns one or more capabilities associated with this partnership.
	Capabilities []string

	// Returns the structure that contains the details for the associated capabilities.
	CapabilityOptions *types.CapabilityOptions

	// Returns the email address associated with this trading partner.
	Email *string

	// Returns a descriptive name for the partnership.
	Name *string

	// Returns the phone number associated with the partnership.
	Phone *string

	// Returns the unique, system-generated identifier for a trading partner.
	TradingPartnerId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreatePartnershipMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreatePartnership{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreatePartnership{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreatePartnership"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreatePartnershipMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreatePartnershipValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreatePartnership(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptExecution(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSerialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterSigning(stack, options); err != nil {
		return err
	}
	if err = addInterceptTransmit(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeDeserialization(stack, options); err != nil {
		return err
	}
	if err = addInterceptAfterDeserialization(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreatePartnership struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreatePartnership) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreatePartnership) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreatePartnershipInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreatePartnershipInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreatePartnershipMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreatePartnership{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreatePartnership(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreatePartnership",
	}
}
