// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A complex structure that lists an autoshift that is currently active for a
// managed resource and information about the autoshift.
//
// For more information, see [How zonal autoshift and practice runs work] in the Amazon Application Recovery Controller
// Developer Guide.
//
// [How zonal autoshift and practice runs work]: https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.html
type AutoshiftInResource struct {

	// The appliedStatus field specifies which application traffic shift is in effect
	// for a resource when there is more than one active traffic shift. There can be
	// more than one application traffic shift in progress at the same time - that is,
	// practice run zonal shifts, customer-initiated zonal shifts, or an autoshift. The
	// appliedStatus field for a shift that is in progress for a resource can have one
	// of two values: APPLIED or NOT_APPLIED . The zonal shift or autoshift that is
	// currently in effect for the resource has an appliedStatus set to APPLIED .
	//
	// The overall principle for precedence is that zonal shifts that you start as a
	// customer take precedence autoshifts, which take precedence over practice runs.
	// That is, customer-initiated zonal shifts > autoshifts > practice run zonal
	// shifts.
	//
	// For more information, see [How zonal autoshift and practice runs work] in the Amazon Application Recovery Controller
	// Developer Guide.
	//
	// [How zonal autoshift and practice runs work]: https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.html
	//
	// This member is required.
	AppliedStatus AutoshiftAppliedStatus

	// The Availability Zone (for example, use1-az1 ) that traffic is shifted away from
	// for a resource, when Amazon Web Services starts an autoshift. Until the
	// autoshift ends, traffic for the resource is instead directed to other
	// Availability Zones in the Amazon Web Services Region. An autoshift can end for a
	// resource, for example, when Amazon Web Services ends the autoshift for the
	// Availability Zone or when you disable zonal autoshift for the resource.
	//
	// This member is required.
	AwayFrom *string

	// The time (UTC) when the autoshift started.
	//
	// This member is required.
	StartTime *time.Time

	noSmithyDocumentSerde
}

// Information about an autoshift. Amazon Web Services starts an autoshift to
// temporarily move traffic for a resource away from an Availability Zone in an
// Amazon Web Services Region when Amazon Web Services determines that there's an
// issue in the Availability Zone that could potentially affect customers. You can
// configure zonal autoshift in ARC for managed resources in your Amazon Web
// Services account in a Region. Supported Amazon Web Services resources are
// automatically registered with ARC.
//
// Autoshifts are temporary. When the Availability Zone recovers, Amazon Web
// Services ends the autoshift, and traffic for the resource is no longer directed
// to the other Availability Zones in the Region.
//
// You can stop an autoshift for a resource by disabling zonal autoshift.
type AutoshiftSummary struct {

	// The Availability Zone (for example, use1-az1 ) that traffic is shifted away from
	// for a resource when Amazon Web Services starts an autoshift. Until the autoshift
	// ends, traffic for the resource is instead directed to other Availability Zones
	// in the Amazon Web Services Region. An autoshift can end for a resource, for
	// example, when Amazon Web Services ends the autoshift for the Availability Zone
	// or when you disable zonal autoshift for the resource.
	//
	// This member is required.
	AwayFrom *string

	// The time (in UTC) when the autoshift started.
	//
	// This member is required.
	StartTime *time.Time

	// The status for an autoshift.
	//
	// This member is required.
	Status AutoshiftExecutionStatus

	// The time (in UTC) when the autoshift ended.
	EndTime *time.Time

	noSmithyDocumentSerde
}

// A control condition is an alarm that you specify for a practice run. When you
// configure practice runs with zonal autoshift for a resource, you specify Amazon
// CloudWatch alarms, which you create in CloudWatch to use with the practice run.
// The alarms that you specify are an outcome alarm, to monitor application health
// during practice runs and, optionally, a blocking alarm, to block practice runs
// from starting or to interrupt a practice run in progress.
//
// Control condition alarms do not apply for autoshifts.
//
// For more information, see [Considerations when you configure zonal autoshift] in the Amazon Application Recovery Controller
// Developer Guide.
//
// [Considerations when you configure zonal autoshift]: https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.considerations.html
type ControlCondition struct {

	// The Amazon Resource Name (ARN) for an Amazon CloudWatch alarm that you specify
	// as a control condition for a practice run.
	//
	// This member is required.
	AlarmIdentifier *string

	// The type of alarm specified for a practice run. You can only specify Amazon
	// CloudWatch alarms for practice runs, so the only valid value is CLOUDWATCH .
	//
	// This member is required.
	Type ControlConditionType

	noSmithyDocumentSerde
}

// A complex structure for a managed resource in an Amazon Web Services account
// with information about zonal shifts and autoshifts.
//
// You can start a zonal shift in ARC for a managed resource to temporarily move
// traffic for the resource away from an Availability Zone in an Amazon Web
// Services Region. You can also configure zonal autoshift for a managed resource.
//
// At this time, managed resources are Amazon EC2 Auto Scaling groups, Amazon
// Elastic Kubernetes Service, Network Load Balancers, and Application Load
// Balancer.
type ManagedResourceSummary struct {

	// The Availability Zones that a resource is deployed in.
	//
	// This member is required.
	AvailabilityZones []string

	// A collection of key-value pairs that indicate whether resources are active in
	// Availability Zones or not. The key name is the Availability Zone where the
	// resource is deployed. The value is 1 or 0.
	AppliedWeights map[string]float32

	// The Amazon Resource Name (ARN) for the managed resource.
	Arn *string

	// An array of the autoshifts that have been completed for a resource.
	Autoshifts []AutoshiftInResource

	// The name of the managed resource.
	Name *string

	// This status tracks whether a practice run configuration exists for a resource.
	// When you configure a practice run for a resource so that a practice run
	// configuration exists, ARC sets this value to ENABLED . If a you have not
	// configured a practice run for the resource, or delete a practice run
	// configuration, ARC sets the value to DISABLED .
	//
	// ARC updates this status; you can't set a practice run status to ENABLED or
	// DISABLED .
	PracticeRunStatus ZonalAutoshiftStatus

	// The status of autoshift for a resource. When you configure zonal autoshift for
	// a resource, you can set the value of the status to ENABLED or DISABLED .
	ZonalAutoshiftStatus ZonalAutoshiftStatus

	// An array of the zonal shifts for a resource.
	ZonalShifts []ZonalShiftInResource

	noSmithyDocumentSerde
}

// A practice run configuration for a resource includes the Amazon CloudWatch
// alarms that you've specified for a practice run, as well as any blocked dates or
// blocked windows for the practice run. When a resource has a practice run
// configuration, ARC shifts traffic for the resource weekly for practice runs.
//
// Practice runs are required for zonal autoshift. The zonal shifts that ARC
// starts for practice runs help you to ensure that shifting away traffic from an
// Availability Zone during an autoshift is safe for your application.
//
// You can update or delete a practice run configuration. Before you delete a
// practice run configuration, you must disable zonal autoshift for the resource. A
// practice run configuration is required when zonal autoshift is enabled.
type PracticeRunConfiguration struct {

	//  Outcome alarms for practice runs are alarms that you specify that end a
	// practice run when one or more of the alarms is in an ALARM state.
	//
	// This member is required.
	OutcomeAlarms []ControlCondition

	// An array of one or more windows of days and times that you can allow ARC to
	// start practice runs for a resource.
	//
	// For example, say you want to allow practice runs only on Wednesdays and Fridays
	// from noon to 5 p.m. For this scenario, you could set the following recurring
	// days and times as allowed windows, for example: Wed-12:00-Wed:17:00
	// Fri-12:00-Fri:17:00 .
	//
	// The allowedWindows have to start and end on the same day. Windows that span
	// multiple days aren't supported.
	AllowedWindows []string

	// An array of one or more dates that you can specify when Amazon Web Services
	// does not start practice runs for a resource.
	//
	// Specify blocked dates, in UTC, in the format YYYY-MM-DD , separated by spaces.
	BlockedDates []string

	// An array of one or more windows of days and times that you can block ARC from
	// starting practice runs for a resource.
	//
	// Specify the blocked windows in UTC, using the format DAY:HH:MM-DAY:HH:MM ,
	// separated by spaces. For example, MON:18:30-MON:19:30 TUE:18:30-TUE:19:30 .
	//
	// The blockedWindows have to start and end on the same day. Windows that span
	// multiple days aren't supported.
	BlockedWindows []string

	//  Blocking alarms for practice runs are optional alarms that you can specify
	// that block practice runs when one or more of the alarms is in an ALARM state.
	BlockingAlarms []ControlCondition

	noSmithyDocumentSerde
}

// A complex structure that lists the zonal shifts for a managed resource and
// their statuses for the resource.
type ZonalShiftInResource struct {

	// The appliedStatus field specifies which application traffic shift is in effect
	// for a resource when there is more than one active traffic shift. There can be
	// more than one application traffic shift in progress at the same time - that is,
	// practice run zonal shifts, customer-initiated zonal shifts, or an autoshift. The
	// appliedStatus field for a shift that is in progress for a resource can have one
	// of two values: APPLIED or NOT_APPLIED . The zonal shift or autoshift that is
	// currently in effect for the resource has an appliedStatus set to APPLIED .
	//
	// The overall principle for precedence is that zonal shifts that you start as a
	// customer take precedence autoshifts, which take precedence over practice runs.
	// That is, customer-initiated zonal shifts > autoshifts > practice run zonal
	// shifts.
	//
	// For more information, see [How zonal autoshift and practice runs work] in the Amazon Application Recovery Controller
	// Developer Guide.
	//
	// [How zonal autoshift and practice runs work]: https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.how-it-works.html
	//
	// This member is required.
	AppliedStatus AppliedStatus

	// The Availability Zone (for example, use1-az1 ) that traffic is moved away from
	// for a resource when you start a zonal shift. Until the zonal shift expires or
	// you cancel it, traffic for the resource is instead moved to other Availability
	// Zones in the Amazon Web Services Region.
	//
	// This member is required.
	AwayFrom *string

	// A comment that you enter for a customer-initiated zonal shift. Only the latest
	// comment is retained; no comment history is maintained. That is, a new comment
	// overwrites any existing comment string.
	//
	// This member is required.
	Comment *string

	// The expiry time (expiration time) for a customer-initiated zonal shift. A zonal
	// shift is temporary and must be set to expire when you start the zonal shift. You
	// can initially set a zonal shift to expire in a maximum of three days (72 hours).
	// However, you can update a zonal shift to set a new expiration at any time.
	//
	// When you start a zonal shift, you specify how long you want it to be active,
	// which ARC converts to an expiry time (expiration time). You can cancel a zonal
	// shift when you're ready to restore traffic to the Availability Zone, or just
	// wait for it to expire. Or you can update the zonal shift to specify another
	// length of time to expire in.
	//
	// This member is required.
	ExpiryTime *time.Time

	// The identifier for the resource to include in a zonal shift. The identifier is
	// the Amazon Resource Name (ARN) for the resource.
	//
	// Amazon Application Recovery Controller currently supports enabling the
	// following resources for zonal shift and zonal autoshift:
	//
	// [Amazon EC2 Auto Scaling groups]
	//
	// [Amazon Elastic Kubernetes Service]
	//
	// [Application Load Balancer]
	//
	// [Network Load Balancer]
	//
	// [Amazon EC2 Auto Scaling groups]: https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.ec2-auto-scaling-groups.html
	// [Amazon Elastic Kubernetes Service]: https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.eks.html
	// [Application Load Balancer]: https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.app-load-balancers.html
	// [Network Load Balancer]: https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.network-load-balancers.html
	//
	// This member is required.
	ResourceIdentifier *string

	// The time (UTC) when the zonal shift starts.
	//
	// This member is required.
	StartTime *time.Time

	// The identifier of a zonal shift.
	//
	// This member is required.
	ZonalShiftId *string

	// The outcome, or end state, returned for a practice run. The following values
	// can be returned:
	//
	//   - PENDING: Outcome value when a practice run is in progress.
	//
	//   - SUCCEEDED: Outcome value when the outcome alarm specified for the practice
	//   run configuration does not go into an ALARM state during the practice run, and
	//   the practice run was not interrupted before it completed the expected 30 minute
	//   zonal shift.
	//
	//   - INTERRUPTED: Outcome value when the practice run was stopped before the
	//   expected 30 minute zonal shift duration, or there was another problem with the
	//   practice run that created an inconclusive outcome.
	//
	//   - FAILED: Outcome value when the outcome alarm specified for the practice run
	//   configuration goes into an ALARM state during the practice run, and the
	//   practice run was not interrupted before it completed.
	//
	//   - CAPACITY_CHECK_FAILED: The check for balanced capacity across Availability
	//   Zones for your load balancing and Auto Scaling group resources failed.
	//
	// For more information about practice run outcomes, see [Considerations when you configure zonal autoshift] in the Amazon
	// Application Recovery Controller Developer Guide.
	//
	// [Considerations when you configure zonal autoshift]: https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.configure.html
	PracticeRunOutcome PracticeRunOutcome

	// Defines the zonal shift type.
	ShiftType ShiftType

	noSmithyDocumentSerde
}

// Lists information about zonal shifts in Amazon Application Recovery Controller,
// including zonal shifts that you start yourself and zonal shifts that ARC starts
// on your behalf for practice runs with zonal autoshift.
//
// Zonal shifts are temporary, including customer-initiated zonal shifts and the
// zonal autoshift practice run zonal shifts that ARC starts weekly, on your
// behalf. A zonal shift that a customer starts can be active for up to three days
// (72 hours). A practice run zonal shift has a 30 minute duration.
type ZonalShiftSummary struct {

	// The Availability Zone (for example, use1-az1 ) that traffic is moved away from
	// for a resource when you start a zonal shift. Until the zonal shift expires or
	// you cancel it, traffic for the resource is instead moved to other Availability
	// Zones in the Amazon Web Services Region.
	//
	// This member is required.
	AwayFrom *string

	// A comment that you enter about the zonal shift. Only the latest comment is
	// retained; no comment history is maintained. That is, a new comment overwrites
	// any existing comment string.
	//
	// This member is required.
	Comment *string

	// The expiry time (expiration time) for a customer-initiated zonal shift. A zonal
	// shift is temporary and must be set to expire when you start the zonal shift. You
	// can initially set a zonal shift to expire in a maximum of three days (72 hours).
	// However, you can update a zonal shift to set a new expiration at any time.
	//
	// When you start a zonal shift, you specify how long you want it to be active,
	// which ARC converts to an expiry time (expiration time). You can cancel a zonal
	// shift when you're ready to restore traffic to the Availability Zone, or just
	// wait for it to expire. Or you can update the zonal shift to specify another
	// length of time to expire in.
	//
	// This member is required.
	ExpiryTime *time.Time

	// The identifier for the resource to include in a zonal shift. The identifier is
	// the Amazon Resource Name (ARN) for the resource.
	//
	// Amazon Application Recovery Controller currently supports enabling the
	// following resources for zonal shift and zonal autoshift:
	//
	// [Amazon EC2 Auto Scaling groups]
	//
	// [Amazon Elastic Kubernetes Service]
	//
	// [Application Load Balancers]
	//
	// [Network Load Balancers]
	//
	// [Network Load Balancers]: https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.network-load-balancers.html
	// [Amazon EC2 Auto Scaling groups]: https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.ec2-auto-scaling-groups.html
	// [Amazon Elastic Kubernetes Service]: https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.eks.html
	// [Application Load Balancers]: https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-shift.resource-types.app-load-balancers.html
	//
	// This member is required.
	ResourceIdentifier *string

	// The time (UTC) when the zonal shift starts.
	//
	// This member is required.
	StartTime *time.Time

	// A status for a zonal shift.
	//
	// The Status for a zonal shift can have one of the following values:
	//
	//   - ACTIVE: The zonal shift has been started and is active.
	//
	//   - EXPIRED: The zonal shift has expired (the expiry time was exceeded).
	//
	//   - CANCELED: The zonal shift was canceled.
	//
	// This member is required.
	Status ZonalShiftStatus

	// The identifier of a zonal shift.
	//
	// This member is required.
	ZonalShiftId *string

	// The outcome, or end state, of a practice run. The following values can be
	// returned:
	//
	//   - PENDING: Outcome value when the practice run is in progress.
	//
	//   - SUCCEEDED: Outcome value when the outcome alarm specified for the practice
	//   run configuration does not go into an ALARM state during the practice run, and
	//   the practice run was not interrupted before it completed.
	//
	//   - INTERRUPTED: Outcome value when the practice run did not run for the
	//   expected 30 minutes or there was another problem with the practice run that
	//   created an inconclusive outcome.
	//
	//   - FAILED: Outcome value when the outcome alarm specified for the practice run
	//   configuration goes into an ALARM state during the practice run, and the
	//   practice run was not interrupted before it completed.
	//
	//   - CAPACITY_CHECK_FAILED: The check for balanced capacity across Availability
	//   Zones for your load balancing and Auto Scaling group resources failed.
	//
	// For more information about practice run outcomes, see [Considerations when you configure zonal autoshift] in the Amazon
	// Application Recovery Controller Developer Guide.
	//
	// [Considerations when you configure zonal autoshift]: https://docs.aws.amazon.com/r53recovery/latest/dg/arc-zonal-autoshift.configure.html
	PracticeRunOutcome PracticeRunOutcome

	// Defines the zonal shift type.
	ShiftType ShiftType

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
