// Code generated by smithy-go-codegen DO NOT EDIT.

package sagemaker

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/sagemaker/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Create compute allocation definition. This defines how compute is allocated,
// shared, and borrowed for specified entities. Specifically, how to lend and
// borrow idle compute and assign a fair-share weight to the specified entities.
func (c *Client) CreateComputeQuota(ctx context.Context, params *CreateComputeQuotaInput, optFns ...func(*Options)) (*CreateComputeQuotaOutput, error) {
	if params == nil {
		params = &CreateComputeQuotaInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateComputeQuota", params, optFns, c.addOperationCreateComputeQuotaMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateComputeQuotaOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateComputeQuotaInput struct {

	// ARN of the cluster.
	//
	// This member is required.
	ClusterArn *string

	// Configuration of the compute allocation definition. This includes the resource
	// sharing option, and the setting to preempt low priority tasks.
	//
	// This member is required.
	ComputeQuotaConfig *types.ComputeQuotaConfig

	// The target entity to allocate compute resources to.
	//
	// This member is required.
	ComputeQuotaTarget *types.ComputeQuotaTarget

	// Name to the compute allocation definition.
	//
	// This member is required.
	Name *string

	// The state of the compute allocation being described. Use to enable or disable
	// compute allocation.
	//
	// Default is Enabled .
	ActivationState types.ActivationState

	// Description of the compute allocation definition.
	Description *string

	// Tags of the compute allocation definition.
	Tags []types.Tag

	noSmithyDocumentSerde
}

type CreateComputeQuotaOutput struct {

	// ARN of the compute allocation definition.
	//
	// This member is required.
	ComputeQuotaArn *string

	// ID of the compute allocation definition.
	//
	// This member is required.
	ComputeQuotaId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateComputeQuotaMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateComputeQuota{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateComputeQuota{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateComputeQuota"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpCreateComputeQuotaValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateComputeQuota(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateComputeQuota(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateComputeQuota",
	}
}
