// Code generated by smithy-go-codegen DO NOT EDIT.

package resourcegroups

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/resourcegroups/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns the status of the last grouping or ungrouping action for each resource
// in the specified application group.
func (c *Client) ListGroupingStatuses(ctx context.Context, params *ListGroupingStatusesInput, optFns ...func(*Options)) (*ListGroupingStatusesOutput, error) {
	if params == nil {
		params = &ListGroupingStatusesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListGroupingStatuses", params, optFns, c.addOperationListGroupingStatusesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListGroupingStatusesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListGroupingStatusesInput struct {

	// The application group identifier, expressed as an Amazon resource name (ARN) or
	// the application group name.
	//
	// This member is required.
	Group *string

	// The filter name and value pair that is used to return more specific results
	// from a list of resources.
	Filters []types.ListGroupingStatusesFilter

	// The maximum number of resources and their statuses returned in the response.
	MaxResults *int32

	// The parameter for receiving additional results if you receive a NextToken
	// response in a previous request. A NextToken response indicates that more output
	// is available. Set this parameter to the value provided by a previous call's
	// NextToken response to indicate where the output should continue from.
	NextToken *string

	noSmithyDocumentSerde
}

type ListGroupingStatusesOutput struct {

	// The application group identifier, expressed as an Amazon resource name (ARN) or
	// the application group name.
	Group *string

	// Returns details about the grouping or ungrouping status of the resources in the
	// specified application group.
	GroupingStatuses []types.GroupingStatusesItem

	// If present, indicates that more output is available than is included in the
	// current response. Use this value in the NextToken request parameter in a
	// subsequent call to the operation to get the next part of the output. You should
	// repeat this until the NextToken response element comes back as null .
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListGroupingStatusesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListGroupingStatuses{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListGroupingStatuses{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListGroupingStatuses"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListGroupingStatusesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListGroupingStatuses(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListGroupingStatusesPaginatorOptions is the paginator options for
// ListGroupingStatuses
type ListGroupingStatusesPaginatorOptions struct {
	// The maximum number of resources and their statuses returned in the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListGroupingStatusesPaginator is a paginator for ListGroupingStatuses
type ListGroupingStatusesPaginator struct {
	options   ListGroupingStatusesPaginatorOptions
	client    ListGroupingStatusesAPIClient
	params    *ListGroupingStatusesInput
	nextToken *string
	firstPage bool
}

// NewListGroupingStatusesPaginator returns a new ListGroupingStatusesPaginator
func NewListGroupingStatusesPaginator(client ListGroupingStatusesAPIClient, params *ListGroupingStatusesInput, optFns ...func(*ListGroupingStatusesPaginatorOptions)) *ListGroupingStatusesPaginator {
	if params == nil {
		params = &ListGroupingStatusesInput{}
	}

	options := ListGroupingStatusesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListGroupingStatusesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListGroupingStatusesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListGroupingStatuses page.
func (p *ListGroupingStatusesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListGroupingStatusesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListGroupingStatuses(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListGroupingStatusesAPIClient is a client that implements the
// ListGroupingStatuses operation.
type ListGroupingStatusesAPIClient interface {
	ListGroupingStatuses(context.Context, *ListGroupingStatusesInput, ...func(*Options)) (*ListGroupingStatusesOutput, error)
}

var _ ListGroupingStatusesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListGroupingStatuses(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListGroupingStatuses",
	}
}
