// Code generated by smithy-go-codegen DO NOT EDIT.

package pinpointsmsvoicev2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/pinpointsmsvoicev2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describes the specified configuration sets or all in your account.
//
// If you specify configuration set names, the output includes information for
// only the specified configuration sets. If you specify filters, the output
// includes information for only those configuration sets that meet the filter
// criteria. If you don't specify configuration set names or filters, the output
// includes information for all configuration sets.
//
// If you specify a configuration set name that isn't valid, an error is returned.
func (c *Client) DescribeConfigurationSets(ctx context.Context, params *DescribeConfigurationSetsInput, optFns ...func(*Options)) (*DescribeConfigurationSetsOutput, error) {
	if params == nil {
		params = &DescribeConfigurationSetsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeConfigurationSets", params, optFns, c.addOperationDescribeConfigurationSetsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeConfigurationSetsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeConfigurationSetsInput struct {

	// An array of strings. Each element can be either a ConfigurationSetName or
	// ConfigurationSetArn.
	ConfigurationSetNames []string

	// An array of filters to apply to the results that are returned.
	Filters []types.ConfigurationSetFilter

	// The maximum number of results to return per each request.
	MaxResults *int32

	// The token to be used for the next set of paginated results. You don't need to
	// supply a value for this field in the initial request.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeConfigurationSetsOutput struct {

	// An array of ConfigurationSets objects.
	ConfigurationSets []types.ConfigurationSetInformation

	// The token to be used for the next set of paginated results. If this field is
	// empty then there are no more results.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeConfigurationSetsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpDescribeConfigurationSets{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpDescribeConfigurationSets{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeConfigurationSets"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpDescribeConfigurationSetsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeConfigurationSets(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// DescribeConfigurationSetsPaginatorOptions is the paginator options for
// DescribeConfigurationSets
type DescribeConfigurationSetsPaginatorOptions struct {
	// The maximum number of results to return per each request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeConfigurationSetsPaginator is a paginator for DescribeConfigurationSets
type DescribeConfigurationSetsPaginator struct {
	options   DescribeConfigurationSetsPaginatorOptions
	client    DescribeConfigurationSetsAPIClient
	params    *DescribeConfigurationSetsInput
	nextToken *string
	firstPage bool
}

// NewDescribeConfigurationSetsPaginator returns a new
// DescribeConfigurationSetsPaginator
func NewDescribeConfigurationSetsPaginator(client DescribeConfigurationSetsAPIClient, params *DescribeConfigurationSetsInput, optFns ...func(*DescribeConfigurationSetsPaginatorOptions)) *DescribeConfigurationSetsPaginator {
	if params == nil {
		params = &DescribeConfigurationSetsInput{}
	}

	options := DescribeConfigurationSetsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeConfigurationSetsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeConfigurationSetsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeConfigurationSets page.
func (p *DescribeConfigurationSetsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeConfigurationSetsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.DescribeConfigurationSets(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// DescribeConfigurationSetsAPIClient is a client that implements the
// DescribeConfigurationSets operation.
type DescribeConfigurationSetsAPIClient interface {
	DescribeConfigurationSets(context.Context, *DescribeConfigurationSetsInput, ...func(*Options)) (*DescribeConfigurationSetsOutput, error)
}

var _ DescribeConfigurationSetsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opDescribeConfigurationSets(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeConfigurationSets",
	}
}
