// Code generated by smithy-go-codegen DO NOT EDIT.

package partnercentralselling

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/partnercentralselling/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	This action creates an invitation from a sender to a single receiver to join
//
// an engagement.
func (c *Client) CreateEngagementInvitation(ctx context.Context, params *CreateEngagementInvitationInput, optFns ...func(*Options)) (*CreateEngagementInvitationOutput, error) {
	if params == nil {
		params = &CreateEngagementInvitationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateEngagementInvitation", params, optFns, c.addOperationCreateEngagementInvitationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateEngagementInvitationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateEngagementInvitationInput struct {

	//  Specifies the catalog related to the engagement. Accepted values are AWS and
	// Sandbox , which determine the environment in which the engagement is managed.
	//
	// This member is required.
	Catalog *string

	//  Specifies a unique, client-generated UUID to ensure that the request is
	// handled exactly once. This token helps prevent duplicate invitation creations.
	//
	// This member is required.
	ClientToken *string

	//  The unique identifier of the Engagement associated with the invitation. This
	// parameter ensures the invitation is created within the correct Engagement
	// context.
	//
	// This member is required.
	EngagementIdentifier *string

	//  The Invitation object all information necessary to initiate an engagement
	// invitation to a partner. It contains a personalized message from the sender, the
	// invitation's receiver, and a payload. The Payload can be the
	// OpportunityInvitation , which includes detailed structures for sender contacts,
	// partner responsibilities, customer information, and project details.
	//
	// This member is required.
	Invitation *types.Invitation

	noSmithyDocumentSerde
}

type CreateEngagementInvitationOutput struct {

	//  The Amazon Resource Name (ARN) that uniquely identifies the engagement
	// invitation.
	//
	// This member is required.
	Arn *string

	//  Unique identifier assigned to the newly created engagement invitation.
	//
	// This member is required.
	Id *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateEngagementInvitationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateEngagementInvitation{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateEngagementInvitation{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateEngagementInvitation"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateEngagementInvitationMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateEngagementInvitationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateEngagementInvitation(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateEngagementInvitation struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateEngagementInvitation) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateEngagementInvitation) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateEngagementInvitationInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateEngagementInvitationInput ")
	}

	if input.ClientToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateEngagementInvitationMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateEngagementInvitation{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateEngagementInvitation(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateEngagementInvitation",
	}
}
