// Code generated by smithy-go-codegen DO NOT EDIT.

package outposts

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/outposts/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Starts the specified capacity task. You can have one active capacity task for
// each order and each Outpost.
func (c *Client) StartCapacityTask(ctx context.Context, params *StartCapacityTaskInput, optFns ...func(*Options)) (*StartCapacityTaskOutput, error) {
	if params == nil {
		params = &StartCapacityTaskInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartCapacityTask", params, optFns, c.addOperationStartCapacityTaskMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartCapacityTaskOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartCapacityTaskInput struct {

	// The instance pools specified in the capacity task.
	//
	// This member is required.
	InstancePools []types.InstanceTypeCapacity

	// The ID or ARN of the Outposts associated with the specified capacity task.
	//
	// This member is required.
	OutpostIdentifier *string

	// The ID of the Outpost asset. An Outpost asset can be a single server within an
	// Outposts rack or an Outposts server configuration.
	AssetId *string

	// You can request a dry run to determine if the instance type and instance size
	// changes is above or below available instance capacity. Requesting a dry run does
	// not make any changes to your plan.
	DryRun bool

	// List of user-specified running instances that must not be stopped in order to
	// free up the capacity needed to run the capacity task.
	InstancesToExclude *types.InstancesToExclude

	// The ID of the Amazon Web Services Outposts order associated with the specified
	// capacity task.
	OrderId *string

	// Specify one of the following options in case an instance is blocking the
	// capacity task from running.
	//
	//   - WAIT_FOR_EVACUATION - Checks every 10 minutes over 48 hours to determine if
	//   instances have stopped and capacity is available to complete the task.
	//
	//   - FAIL_TASK - The capacity task fails.
	TaskActionOnBlockingInstances types.TaskActionOnBlockingInstances

	noSmithyDocumentSerde
}

type StartCapacityTaskOutput struct {

	// The ID of the asset. An Outpost asset can be a single server within an Outposts
	// rack or an Outposts server configuration.
	AssetId *string

	// ID of the capacity task that you want to start.
	CapacityTaskId *string

	// Status of the specified capacity task.
	CapacityTaskStatus types.CapacityTaskStatus

	// Date that the specified capacity task ran successfully.
	CompletionDate *time.Time

	// Date that the specified capacity task was created.
	CreationDate *time.Time

	// Results of the dry run showing if the specified capacity task is above or below
	// the available instance capacity.
	DryRun bool

	// Reason that the specified capacity task failed.
	Failed *types.CapacityTaskFailure

	// User-specified instances that must not be stopped in order to free up the
	// capacity needed to run the capacity task.
	InstancesToExclude *types.InstancesToExclude

	// Date that the specified capacity task was last modified.
	LastModifiedDate *time.Time

	// ID of the Amazon Web Services Outposts order of the host associated with the
	// capacity task.
	OrderId *string

	// ID of the Outpost associated with the capacity task.
	OutpostId *string

	// List of the instance pools requested in the specified capacity task.
	RequestedInstancePools []types.InstanceTypeCapacity

	// User-specified option in case an instance is blocking the capacity task from
	// running.
	//
	//   - WAIT_FOR_EVACUATION - Checks every 10 minutes over 48 hours to determine if
	//   instances have stopped and capacity is available to complete the task.
	//
	//   - FAIL_TASK - The capacity task fails.
	TaskActionOnBlockingInstances types.TaskActionOnBlockingInstances

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartCapacityTaskMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpStartCapacityTask{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpStartCapacityTask{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "StartCapacityTask"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpStartCapacityTaskValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartCapacityTask(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartCapacityTask(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "StartCapacityTask",
	}
}
