// Code generated by smithy-go-codegen DO NOT EDIT.

package kinesis

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/kinesis/types"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Gets an Amazon Kinesis shard iterator. A shard iterator expires 5 minutes after
// it is returned to the requester.
//
// When invoking this API, you must use either the StreamARN or the StreamName
// parameter, or both. It is recommended that you use the StreamARN input
// parameter when you invoke this API.
//
// A shard iterator specifies the shard position from which to start reading data
// records sequentially. The position is specified using the sequence number of a
// data record in a shard. A sequence number is the identifier associated with
// every record ingested in the stream, and is assigned when a record is put into
// the stream. Each stream has one or more shards.
//
// You must specify the shard iterator type. For example, you can set the
// ShardIteratorType parameter to read exactly from the position denoted by a
// specific sequence number by using the AT_SEQUENCE_NUMBER shard iterator type.
// Alternatively, the parameter can read right after the sequence number by using
// the AFTER_SEQUENCE_NUMBER shard iterator type, using sequence numbers returned
// by earlier calls to PutRecord, PutRecords, GetRecords, or DescribeStream. In the request, you can specify the shard
// iterator type AT_TIMESTAMP to read records from an arbitrary point in time,
// TRIM_HORIZON to cause ShardIterator to point to the last untrimmed record in
// the shard in the system (the oldest data record in the shard), or LATEST so
// that you always read the most recent data in the shard.
//
// When you read repeatedly from a stream, use a GetShardIterator request to get the first shard
// iterator for use in your first GetRecordsrequest and for subsequent reads use the shard
// iterator returned by the GetRecordsrequest in NextShardIterator . A new shard iterator is
// returned by every GetRecordsrequest in NextShardIterator , which you use in the
// ShardIterator parameter of the next GetRecords request.
//
// If a GetShardIterator request is made too often, you receive a
// ProvisionedThroughputExceededException . For more information about throughput
// limits, see GetRecords, and [Streams Limits] in the Amazon Kinesis Data Streams Developer Guide.
//
// If the shard is closed, GetShardIterator returns a valid iterator for the last sequence number
// of the shard. A shard can be closed as a result of using SplitShardor MergeShards.
//
// GetShardIteratorhas a limit of five transactions per second per account per open shard.
//
// [Streams Limits]: https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html
func (c *Client) GetShardIterator(ctx context.Context, params *GetShardIteratorInput, optFns ...func(*Options)) (*GetShardIteratorOutput, error) {
	if params == nil {
		params = &GetShardIteratorInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetShardIterator", params, optFns, c.addOperationGetShardIteratorMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetShardIteratorOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Represents the input for GetShardIterator .
type GetShardIteratorInput struct {

	// The shard ID of the Kinesis Data Streams shard to get the iterator for.
	//
	// This member is required.
	ShardId *string

	// Determines how the shard iterator is used to start reading data records from
	// the shard.
	//
	// The following are the valid Amazon Kinesis shard iterator types:
	//
	//   - AT_SEQUENCE_NUMBER - Start reading from the position denoted by a specific
	//   sequence number, provided in the value StartingSequenceNumber .
	//
	//   - AFTER_SEQUENCE_NUMBER - Start reading right after the position denoted by a
	//   specific sequence number, provided in the value StartingSequenceNumber .
	//
	//   - AT_TIMESTAMP - Start reading from the position denoted by a specific time
	//   stamp, provided in the value Timestamp .
	//
	//   - TRIM_HORIZON - Start reading at the last untrimmed record in the shard in
	//   the system, which is the oldest data record in the shard.
	//
	//   - LATEST - Start reading just after the most recent record in the shard, so
	//   that you always read the most recent data in the shard.
	//
	// This member is required.
	ShardIteratorType types.ShardIteratorType

	// The sequence number of the data record in the shard from which to start
	// reading. Used with shard iterator type AT_SEQUENCE_NUMBER and
	// AFTER_SEQUENCE_NUMBER.
	StartingSequenceNumber *string

	// The ARN of the stream.
	StreamARN *string

	// The name of the Amazon Kinesis data stream.
	StreamName *string

	// The time stamp of the data record from which to start reading. Used with shard
	// iterator type AT_TIMESTAMP. A time stamp is the Unix epoch date with precision
	// in milliseconds. For example, 2016-04-04T19:58:46.480-00:00 or 1459799926.480 .
	// If a record with this exact time stamp does not exist, the iterator returned is
	// for the next (later) record. If the time stamp is older than the current trim
	// horizon, the iterator returned is for the oldest untrimmed data record
	// (TRIM_HORIZON).
	Timestamp *time.Time

	noSmithyDocumentSerde
}

func (in *GetShardIteratorInput) bindEndpointParams(p *EndpointParameters) {

	p.StreamARN = in.StreamARN
	p.OperationType = ptr.String("data")
}

// Represents the output for GetShardIterator .
type GetShardIteratorOutput struct {

	// The position in the shard from which to start reading data records
	// sequentially. A shard iterator specifies this position using the sequence number
	// of a data record in a shard.
	ShardIterator *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetShardIteratorMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpGetShardIterator{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpGetShardIterator{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetShardIterator"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetShardIteratorValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetShardIterator(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetShardIterator(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetShardIterator",
	}
}
