// Code generated by smithy-go-codegen DO NOT EDIT.

package ivsrealtime

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ivsrealtime/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets summary information about all Compositions in your account, in the AWS
// region where the API request is processed.
func (c *Client) ListCompositions(ctx context.Context, params *ListCompositionsInput, optFns ...func(*Options)) (*ListCompositionsOutput, error) {
	if params == nil {
		params = &ListCompositionsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListCompositions", params, optFns, c.addOperationListCompositionsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListCompositionsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListCompositionsInput struct {

	// Filters the Composition list to match the specified EncoderConfiguration
	// attached to at least one of its output.
	FilterByEncoderConfigurationArn *string

	// Filters the Composition list to match the specified Stage ARN.
	FilterByStageArn *string

	// Maximum number of results to return. Default: 100.
	MaxResults *int32

	// The first Composition to retrieve. This is used for pagination; see the
	// nextToken response field.
	NextToken *string

	noSmithyDocumentSerde
}

type ListCompositionsOutput struct {

	// List of the matching Compositions (summary information only).
	//
	// This member is required.
	Compositions []types.CompositionSummary

	// If there are more compositions than maxResults , use nextToken in the request
	// to get the next set.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListCompositionsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListCompositions{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListCompositions{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListCompositions"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListCompositions(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListCompositionsPaginatorOptions is the paginator options for ListCompositions
type ListCompositionsPaginatorOptions struct {
	// Maximum number of results to return. Default: 100.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListCompositionsPaginator is a paginator for ListCompositions
type ListCompositionsPaginator struct {
	options   ListCompositionsPaginatorOptions
	client    ListCompositionsAPIClient
	params    *ListCompositionsInput
	nextToken *string
	firstPage bool
}

// NewListCompositionsPaginator returns a new ListCompositionsPaginator
func NewListCompositionsPaginator(client ListCompositionsAPIClient, params *ListCompositionsInput, optFns ...func(*ListCompositionsPaginatorOptions)) *ListCompositionsPaginator {
	if params == nil {
		params = &ListCompositionsInput{}
	}

	options := ListCompositionsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListCompositionsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListCompositionsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListCompositions page.
func (p *ListCompositionsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListCompositionsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListCompositions(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListCompositionsAPIClient is a client that implements the ListCompositions
// operation.
type ListCompositionsAPIClient interface {
	ListCompositions(context.Context, *ListCompositionsInput, ...func(*Options)) (*ListCompositionsOutput, error)
}

var _ ListCompositionsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListCompositions(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListCompositions",
	}
}
