// Code generated by smithy-go-codegen DO NOT EDIT.

package healthlake

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/healthlake/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Lists all FHIR export jobs associated with an account and their statuses.
func (c *Client) ListFHIRExportJobs(ctx context.Context, params *ListFHIRExportJobsInput, optFns ...func(*Options)) (*ListFHIRExportJobsOutput, error) {
	if params == nil {
		params = &ListFHIRExportJobsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListFHIRExportJobs", params, optFns, c.addOperationListFHIRExportJobsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListFHIRExportJobsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListFHIRExportJobsInput struct {

	//  This parameter limits the response to the export job with the specified data
	// store ID.
	//
	// This member is required.
	DatastoreId *string

	//  This parameter limits the response to the export job with the specified job
	// name.
	JobName *string

	//  This parameter limits the response to the export jobs with the specified job
	// status.
	JobStatus types.JobStatus

	//  This parameter limits the number of results returned for a ListFHIRExportJobs
	// to a maximum quantity specified by the user.
	MaxResults *int32

	//  A pagination token used to identify the next page of results to return for a
	// ListFHIRExportJobs query.
	NextToken *string

	//  This parameter limits the response to FHIR export jobs submitted after a user
	// specified date.
	SubmittedAfter *time.Time

	//  This parameter limits the response to FHIR export jobs submitted before a user
	// specified date.
	SubmittedBefore *time.Time

	noSmithyDocumentSerde
}

type ListFHIRExportJobsOutput struct {

	//  The properties of listed FHIR export jobs, including the ID, ARN, name, and
	// the status of the job.
	//
	// This member is required.
	ExportJobPropertiesList []types.ExportJobProperties

	//  A pagination token used to identify the next page of results to return for a
	// ListFHIRExportJobs query.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListFHIRExportJobsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListFHIRExportJobs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListFHIRExportJobs{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListFHIRExportJobs"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListFHIRExportJobsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListFHIRExportJobs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

// ListFHIRExportJobsPaginatorOptions is the paginator options for
// ListFHIRExportJobs
type ListFHIRExportJobsPaginatorOptions struct {
	//  This parameter limits the number of results returned for a ListFHIRExportJobs
	// to a maximum quantity specified by the user.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListFHIRExportJobsPaginator is a paginator for ListFHIRExportJobs
type ListFHIRExportJobsPaginator struct {
	options   ListFHIRExportJobsPaginatorOptions
	client    ListFHIRExportJobsAPIClient
	params    *ListFHIRExportJobsInput
	nextToken *string
	firstPage bool
}

// NewListFHIRExportJobsPaginator returns a new ListFHIRExportJobsPaginator
func NewListFHIRExportJobsPaginator(client ListFHIRExportJobsAPIClient, params *ListFHIRExportJobsInput, optFns ...func(*ListFHIRExportJobsPaginatorOptions)) *ListFHIRExportJobsPaginator {
	if params == nil {
		params = &ListFHIRExportJobsInput{}
	}

	options := ListFHIRExportJobsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListFHIRExportJobsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListFHIRExportJobsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListFHIRExportJobs page.
func (p *ListFHIRExportJobsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListFHIRExportJobsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListFHIRExportJobs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListFHIRExportJobsAPIClient is a client that implements the ListFHIRExportJobs
// operation.
type ListFHIRExportJobsAPIClient interface {
	ListFHIRExportJobs(context.Context, *ListFHIRExportJobsInput, ...func(*Options)) (*ListFHIRExportJobsOutput, error)
}

var _ ListFHIRExportJobsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListFHIRExportJobs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListFHIRExportJobs",
	}
}
