// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// Access to a resource was denied.
type AccessDeniedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AccessDeniedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AccessDeniedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AccessDeniedException"
	}
	return *e.ErrorCodeOverride
}
func (e *AccessDeniedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A resource to be created or added already exists.
type AlreadyExistsException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *AlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AlreadyExistsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AlreadyExistsException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AlreadyExistsException"
	}
	return *e.ErrorCodeOverride
}
func (e *AlreadyExistsException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An exception thrown when you try to stop a task run when there is no task
// running.
type ColumnStatisticsTaskNotRunningException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ColumnStatisticsTaskNotRunningException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ColumnStatisticsTaskNotRunningException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ColumnStatisticsTaskNotRunningException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ColumnStatisticsTaskNotRunningException"
	}
	return *e.ErrorCodeOverride
}
func (e *ColumnStatisticsTaskNotRunningException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// An exception thrown when you try to start another job while running a column
// stats generation job.
type ColumnStatisticsTaskRunningException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ColumnStatisticsTaskRunningException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ColumnStatisticsTaskRunningException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ColumnStatisticsTaskRunningException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ColumnStatisticsTaskRunningException"
	}
	return *e.ErrorCodeOverride
}
func (e *ColumnStatisticsTaskRunningException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// An exception thrown when you try to stop a task run.
type ColumnStatisticsTaskStoppingException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ColumnStatisticsTaskStoppingException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ColumnStatisticsTaskStoppingException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ColumnStatisticsTaskStoppingException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ColumnStatisticsTaskStoppingException"
	}
	return *e.ErrorCodeOverride
}
func (e *ColumnStatisticsTaskStoppingException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// Two processes are trying to modify a resource simultaneously.
type ConcurrentModificationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ConcurrentModificationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ConcurrentModificationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ConcurrentModificationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ConcurrentModificationException"
	}
	return *e.ErrorCodeOverride
}
func (e *ConcurrentModificationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Too many jobs are being run concurrently.
type ConcurrentRunsExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ConcurrentRunsExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ConcurrentRunsExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ConcurrentRunsExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ConcurrentRunsExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *ConcurrentRunsExceededException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A specified condition was not satisfied.
type ConditionCheckFailureException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ConditionCheckFailureException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ConditionCheckFailureException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ConditionCheckFailureException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ConditionCheckFailureException"
	}
	return *e.ErrorCodeOverride
}
func (e *ConditionCheckFailureException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The CreatePartitions API was called on a table that has indexes enabled.
type ConflictException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ConflictException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ConflictException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ConflictException"
	}
	return *e.ErrorCodeOverride
}
func (e *ConflictException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified crawler is not running.
type CrawlerNotRunningException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CrawlerNotRunningException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CrawlerNotRunningException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CrawlerNotRunningException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CrawlerNotRunningException"
	}
	return *e.ErrorCodeOverride
}
func (e *CrawlerNotRunningException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation cannot be performed because the crawler is already running.
type CrawlerRunningException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CrawlerRunningException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CrawlerRunningException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CrawlerRunningException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CrawlerRunningException"
	}
	return *e.ErrorCodeOverride
}
func (e *CrawlerRunningException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified crawler is stopping.
type CrawlerStoppingException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *CrawlerStoppingException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *CrawlerStoppingException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *CrawlerStoppingException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "CrawlerStoppingException"
	}
	return *e.ErrorCodeOverride
}
func (e *CrawlerStoppingException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A specified entity does not exist
type EntityNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	FromFederationSource *bool

	noSmithyDocumentSerde
}

func (e *EntityNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *EntityNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *EntityNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "EntityNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *EntityNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A federated resource already exists.
type FederatedResourceAlreadyExistsException struct {
	Message *string

	ErrorCodeOverride *string

	AssociatedGlueResource *string

	noSmithyDocumentSerde
}

func (e *FederatedResourceAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FederatedResourceAlreadyExistsException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FederatedResourceAlreadyExistsException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "FederatedResourceAlreadyExistsException"
	}
	return *e.ErrorCodeOverride
}
func (e *FederatedResourceAlreadyExistsException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// A federation source failed.
type FederationSourceException struct {
	Message *string

	ErrorCodeOverride *string

	FederationSourceErrorCode FederationSourceErrorCode

	noSmithyDocumentSerde
}

func (e *FederationSourceException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FederationSourceException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FederationSourceException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "FederationSourceException"
	}
	return *e.ErrorCodeOverride
}
func (e *FederationSourceException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A federation source failed, but the operation may be retried.
type FederationSourceRetryableException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *FederationSourceRetryableException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *FederationSourceRetryableException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *FederationSourceRetryableException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "FederationSourceRetryableException"
	}
	return *e.ErrorCodeOverride
}
func (e *FederationSourceRetryableException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// An encryption operation failed.
type GlueEncryptionException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *GlueEncryptionException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *GlueEncryptionException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *GlueEncryptionException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "GlueEncryptionException"
	}
	return *e.ErrorCodeOverride
}
func (e *GlueEncryptionException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The same unique identifier was associated with two different records.
type IdempotentParameterMismatchException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *IdempotentParameterMismatchException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IdempotentParameterMismatchException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IdempotentParameterMismatchException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "IdempotentParameterMismatchException"
	}
	return *e.ErrorCodeOverride
}
func (e *IdempotentParameterMismatchException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The blueprint is in an invalid state to perform a requested operation.
type IllegalBlueprintStateException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *IllegalBlueprintStateException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IllegalBlueprintStateException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IllegalBlueprintStateException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "IllegalBlueprintStateException"
	}
	return *e.ErrorCodeOverride
}
func (e *IllegalBlueprintStateException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The session is in an invalid state to perform a requested operation.
type IllegalSessionStateException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *IllegalSessionStateException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IllegalSessionStateException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IllegalSessionStateException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "IllegalSessionStateException"
	}
	return *e.ErrorCodeOverride
}
func (e *IllegalSessionStateException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The workflow is in an invalid state to perform a requested operation.
type IllegalWorkflowStateException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *IllegalWorkflowStateException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IllegalWorkflowStateException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IllegalWorkflowStateException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "IllegalWorkflowStateException"
	}
	return *e.ErrorCodeOverride
}
func (e *IllegalWorkflowStateException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The requested operation conflicts with another operation.
type IntegrationConflictOperationFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *IntegrationConflictOperationFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IntegrationConflictOperationFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IntegrationConflictOperationFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "IntegrationConflictOperationFault"
	}
	return *e.ErrorCodeOverride
}
func (e *IntegrationConflictOperationFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified integration could not be found.
type IntegrationNotFoundFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *IntegrationNotFoundFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IntegrationNotFoundFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IntegrationNotFoundFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "IntegrationNotFoundFault"
	}
	return *e.ErrorCodeOverride
}
func (e *IntegrationNotFoundFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The data processed through your integration exceeded your quota.
type IntegrationQuotaExceededFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *IntegrationQuotaExceededFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *IntegrationQuotaExceededFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *IntegrationQuotaExceededFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "IntegrationQuotaExceededFault"
	}
	return *e.ErrorCodeOverride
}
func (e *IntegrationQuotaExceededFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An internal server error occurred.
type InternalServerException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InternalServerException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InternalServerException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InternalServerException"
	}
	return *e.ErrorCodeOverride
}
func (e *InternalServerException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// An internal service error occurred.
type InternalServiceException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InternalServiceException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InternalServiceException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InternalServiceException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InternalServiceException"
	}
	return *e.ErrorCodeOverride
}
func (e *InternalServiceException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// The input provided was not valid.
type InvalidInputException struct {
	Message *string

	ErrorCodeOverride *string

	FromFederationSource *bool

	noSmithyDocumentSerde
}

func (e *InvalidInputException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidInputException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidInputException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidInputException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidInputException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The integration is in an invalid state.
type InvalidIntegrationStateFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidIntegrationStateFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidIntegrationStateFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidIntegrationStateFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidIntegrationStateFault"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidIntegrationStateFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// An error that indicates your data is in an invalid state.
type InvalidStateException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidStateException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidStateException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidStateException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InvalidStateException"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidStateException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The KMS key specified is not accessible.
type KMSKeyNotAccessibleFault struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *KMSKeyNotAccessibleFault) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *KMSKeyNotAccessibleFault) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *KMSKeyNotAccessibleFault) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "KMSKeyNotAccessibleFault"
	}
	return *e.ErrorCodeOverride
}
func (e *KMSKeyNotAccessibleFault) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The machine learning transform is not ready to run.
type MLTransformNotReadyException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *MLTransformNotReadyException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *MLTransformNotReadyException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *MLTransformNotReadyException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "MLTransformNotReadyException"
	}
	return *e.ErrorCodeOverride
}
func (e *MLTransformNotReadyException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// There is no applicable schedule.
type NoScheduleException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *NoScheduleException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *NoScheduleException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *NoScheduleException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "NoScheduleException"
	}
	return *e.ErrorCodeOverride
}
func (e *NoScheduleException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation is not available in the region.
type OperationNotSupportedException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OperationNotSupportedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OperationNotSupportedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OperationNotSupportedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OperationNotSupportedException"
	}
	return *e.ErrorCodeOverride
}
func (e *OperationNotSupportedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation timed out.
type OperationTimeoutException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *OperationTimeoutException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *OperationTimeoutException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *OperationTimeoutException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "OperationTimeoutException"
	}
	return *e.ErrorCodeOverride
}
func (e *OperationTimeoutException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation timed out.
type PermissionTypeMismatchException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *PermissionTypeMismatchException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *PermissionTypeMismatchException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *PermissionTypeMismatchException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "PermissionTypeMismatchException"
	}
	return *e.ErrorCodeOverride
}
func (e *PermissionTypeMismatchException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The resource could not be found.
type ResourceNotFoundException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceNotFoundException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceNotFoundException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceNotFoundException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceNotFoundException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A resource was not ready for a transaction.
type ResourceNotReadyException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceNotReadyException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceNotReadyException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceNotReadyException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceNotReadyException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceNotReadyException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A resource numerical limit was exceeded.
type ResourceNumberLimitExceededException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ResourceNumberLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ResourceNumberLimitExceededException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ResourceNumberLimitExceededException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ResourceNumberLimitExceededException"
	}
	return *e.ErrorCodeOverride
}
func (e *ResourceNumberLimitExceededException) ErrorFault() smithy.ErrorFault {
	return smithy.FaultClient
}

// The specified scheduler is not running.
type SchedulerNotRunningException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SchedulerNotRunningException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SchedulerNotRunningException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SchedulerNotRunningException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SchedulerNotRunningException"
	}
	return *e.ErrorCodeOverride
}
func (e *SchedulerNotRunningException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified scheduler is already running.
type SchedulerRunningException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SchedulerRunningException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SchedulerRunningException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SchedulerRunningException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SchedulerRunningException"
	}
	return *e.ErrorCodeOverride
}
func (e *SchedulerRunningException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified scheduler is transitioning.
type SchedulerTransitioningException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *SchedulerTransitioningException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *SchedulerTransitioningException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *SchedulerTransitioningException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "SchedulerTransitioningException"
	}
	return *e.ErrorCodeOverride
}
func (e *SchedulerTransitioningException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The target resource could not be found.
type TargetResourceNotFound struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *TargetResourceNotFound) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TargetResourceNotFound) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TargetResourceNotFound) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TargetResourceNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *TargetResourceNotFound) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The throttling threshhold was exceeded.
type ThrottlingException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ThrottlingException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ThrottlingException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ThrottlingException"
	}
	return *e.ErrorCodeOverride
}
func (e *ThrottlingException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// A value could not be validated.
type ValidationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ValidationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ValidationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ValidationException"
	}
	return *e.ErrorCodeOverride
}
func (e *ValidationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// There was a version conflict.
type VersionMismatchException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *VersionMismatchException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *VersionMismatchException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *VersionMismatchException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "VersionMismatchException"
	}
	return *e.ErrorCodeOverride
}
func (e *VersionMismatchException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
