// Code generated by smithy-go-codegen DO NOT EDIT.

package gamelift

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/gamelift/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the properties of a managed container fleet. Depending on the
// properties being updated, this operation might initiate a fleet deployment. You
// can track deployments for a fleet using [https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetDeployment.html].
//
// # Request options
//
// As with CreateContainerFleet, many fleet properties use common defaults or are
// calculated based on the fleet's container group definitions.
//
//   - Update fleet properties that result in a fleet deployment. Include only
//     those properties that you want to change. Specify deployment configuration
//     settings.
//
//   - Update fleet properties that don't result in a fleet deployment. Include
//     only those properties that you want to change.
//
// Changes to the following properties initiate a fleet deployment:
//
//   - GameServerContainerGroupDefinition
//
//   - PerInstanceContainerGroupDefinition
//
//   - GameServerContainerGroupsPerInstance
//
//   - InstanceInboundPermissions
//
//   - InstanceConnectionPortRange
//
//   - LogConfiguration
//
// # Results
//
// If successful, this operation updates the container fleet resource, and might
// initiate a new deployment of fleet resources using the deployment configuration
// provided. A deployment replaces existing fleet instances with new instances that
// are deployed with the updated fleet properties. The fleet is placed in UPDATING
// status until the deployment is complete, then return to ACTIVE .
//
// You can have only one update deployment active at a time for a fleet. If a
// second update request initiates a deployment while another deployment is in
// progress, the first deployment is cancelled.
//
// [https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetDeployment.html]: https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetDeployment.html
func (c *Client) UpdateContainerFleet(ctx context.Context, params *UpdateContainerFleetInput, optFns ...func(*Options)) (*UpdateContainerFleetOutput, error) {
	if params == nil {
		params = &UpdateContainerFleetInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateContainerFleet", params, optFns, c.addOperationUpdateContainerFleetMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateContainerFleetOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateContainerFleetInput struct {

	// A unique identifier for the container fleet to update. You can use either the
	// fleet ID or ARN value.
	//
	// This member is required.
	FleetId *string

	// Instructions for how to deploy updates to a container fleet, if the fleet
	// update initiates a deployment. The deployment configuration lets you determine
	// how to replace fleet instances and what actions to take if the deployment fails.
	DeploymentConfiguration *types.DeploymentConfiguration

	// A meaningful description of the container fleet.
	Description *string

	// The name or ARN value of a new game server container group definition to deploy
	// on the fleet. If you're updating the fleet to a specific version of a container
	// group definition, use the ARN value and include the version number. If you're
	// updating the fleet to the latest version of a container group definition, you
	// can use the name value. You can't remove a fleet's game server container group
	// definition, you can only update or replace it with another definition.
	//
	// Update a container group definition by calling [UpdateContainerGroupDefinition]. This operation creates a [ContainerGroupDefinition]
	// resource with an incremented version.
	//
	// [ContainerGroupDefinition]: https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html
	// [UpdateContainerGroupDefinition]: https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateContainerGroupDefinition.html
	GameServerContainerGroupDefinitionName *string

	// The number of times to replicate the game server container group on each fleet
	// instance. By default, Amazon GameLift calculates the maximum number of game
	// server container groups that can fit on each instance. You can remove this
	// property value to use the calculated value, or set it manually. If you set this
	// number manually, Amazon GameLift uses your value as long as it's less than the
	// calculated maximum.
	GameServerContainerGroupsPerInstance *int32

	// A policy that limits the number of game sessions that each individual player
	// can create on instances in this fleet. The limit applies for a specified span of
	// time.
	GameSessionCreationLimitPolicy *types.GameSessionCreationLimitPolicy

	// A revised set of port numbers to open on each fleet instance. By default,
	// Amazon GameLift calculates an optimal port range based on your fleet
	// configuration. If you previously set this parameter manually, you can't reset
	// this to use the calculated settings.
	InstanceConnectionPortRange *types.ConnectionPortRange

	// A set of ports to add to the container fleet's inbound permissions.
	InstanceInboundPermissionAuthorizations []types.IpPermission

	// A set of ports to remove from the container fleet's inbound permissions.
	InstanceInboundPermissionRevocations []types.IpPermission

	// The method for collecting container logs for the fleet.
	LogConfiguration *types.LogConfiguration

	// The name of an Amazon Web Services CloudWatch metric group to add this fleet
	// to.
	MetricGroups []string

	// The game session protection policy to apply to all new game sessions that are
	// started in this fleet. Game sessions that already exist are not affected.
	NewGameSessionProtectionPolicy types.ProtectionPolicy

	// The name or ARN value of a new per-instance container group definition to
	// deploy on the fleet. If you're updating the fleet to a specific version of a
	// container group definition, use the ARN value and include the version number. If
	// you're updating the fleet to the latest version of a container group definition,
	// you can use the name value.
	//
	// Update a container group definition by calling [UpdateContainerGroupDefinition]. This operation creates a [ContainerGroupDefinition]
	// resource with an incremented version.
	//
	// To remove a fleet's per-instance container group definition, leave this
	// parameter empty and use the parameter RemoveAttributes .
	//
	// [ContainerGroupDefinition]: https://docs.aws.amazon.com/gamelift/latest/apireference/API_ContainerGroupDefinition.html
	// [UpdateContainerGroupDefinition]: https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateContainerGroupDefinition.html
	PerInstanceContainerGroupDefinitionName *string

	// If set, this update removes a fleet's per-instance container group definition.
	// You can't remove a fleet's game server container group definition.
	RemoveAttributes []types.ContainerFleetRemoveAttribute

	noSmithyDocumentSerde
}

type UpdateContainerFleetOutput struct {

	// A collection of container fleet objects for all fleets that match the request
	// criteria.
	ContainerFleet *types.ContainerFleet

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateContainerFleetMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpUpdateContainerFleet{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpUpdateContainerFleet{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateContainerFleet"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateContainerFleetValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateContainerFleet(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateContainerFleet(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateContainerFleet",
	}
}
