// Code generated by smithy-go-codegen DO NOT EDIT.

package fsx

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/fsx/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpAssociateFileSystemAliases struct {
}

func (*validateOpAssociateFileSystemAliases) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAssociateFileSystemAliases) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AssociateFileSystemAliasesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAssociateFileSystemAliasesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCancelDataRepositoryTask struct {
}

func (*validateOpCancelDataRepositoryTask) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCancelDataRepositoryTask) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CancelDataRepositoryTaskInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCancelDataRepositoryTaskInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCopyBackup struct {
}

func (*validateOpCopyBackup) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCopyBackup) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CopyBackupInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCopyBackupInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCopySnapshotAndUpdateVolume struct {
}

func (*validateOpCopySnapshotAndUpdateVolume) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCopySnapshotAndUpdateVolume) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CopySnapshotAndUpdateVolumeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCopySnapshotAndUpdateVolumeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateBackup struct {
}

func (*validateOpCreateBackup) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateBackup) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateBackupInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateBackupInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateDataRepositoryAssociation struct {
}

func (*validateOpCreateDataRepositoryAssociation) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateDataRepositoryAssociation) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateDataRepositoryAssociationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateDataRepositoryAssociationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateDataRepositoryTask struct {
}

func (*validateOpCreateDataRepositoryTask) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateDataRepositoryTask) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateDataRepositoryTaskInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateDataRepositoryTaskInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateFileCache struct {
}

func (*validateOpCreateFileCache) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateFileCache) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateFileCacheInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateFileCacheInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateFileSystemFromBackup struct {
}

func (*validateOpCreateFileSystemFromBackup) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateFileSystemFromBackup) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateFileSystemFromBackupInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateFileSystemFromBackupInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateFileSystem struct {
}

func (*validateOpCreateFileSystem) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateFileSystem) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateFileSystemInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateFileSystemInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateSnapshot struct {
}

func (*validateOpCreateSnapshot) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateSnapshot) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateSnapshotInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateSnapshotInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateStorageVirtualMachine struct {
}

func (*validateOpCreateStorageVirtualMachine) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateStorageVirtualMachine) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateStorageVirtualMachineInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateStorageVirtualMachineInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateVolumeFromBackup struct {
}

func (*validateOpCreateVolumeFromBackup) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateVolumeFromBackup) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateVolumeFromBackupInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateVolumeFromBackupInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateVolume struct {
}

func (*validateOpCreateVolume) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateVolume) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateVolumeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateVolumeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteBackup struct {
}

func (*validateOpDeleteBackup) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteBackup) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteBackupInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteBackupInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteDataRepositoryAssociation struct {
}

func (*validateOpDeleteDataRepositoryAssociation) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteDataRepositoryAssociation) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteDataRepositoryAssociationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteDataRepositoryAssociationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteFileCache struct {
}

func (*validateOpDeleteFileCache) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteFileCache) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteFileCacheInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteFileCacheInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteFileSystem struct {
}

func (*validateOpDeleteFileSystem) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteFileSystem) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteFileSystemInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteFileSystemInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteSnapshot struct {
}

func (*validateOpDeleteSnapshot) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteSnapshot) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteSnapshotInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteSnapshotInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteStorageVirtualMachine struct {
}

func (*validateOpDeleteStorageVirtualMachine) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteStorageVirtualMachine) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteStorageVirtualMachineInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteStorageVirtualMachineInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteVolume struct {
}

func (*validateOpDeleteVolume) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteVolume) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteVolumeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteVolumeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeFileSystemAliases struct {
}

func (*validateOpDescribeFileSystemAliases) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeFileSystemAliases) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeFileSystemAliasesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeFileSystemAliasesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDisassociateFileSystemAliases struct {
}

func (*validateOpDisassociateFileSystemAliases) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDisassociateFileSystemAliases) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DisassociateFileSystemAliasesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDisassociateFileSystemAliasesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpReleaseFileSystemNfsV3Locks struct {
}

func (*validateOpReleaseFileSystemNfsV3Locks) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpReleaseFileSystemNfsV3Locks) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ReleaseFileSystemNfsV3LocksInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpReleaseFileSystemNfsV3LocksInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRestoreVolumeFromSnapshot struct {
}

func (*validateOpRestoreVolumeFromSnapshot) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRestoreVolumeFromSnapshot) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RestoreVolumeFromSnapshotInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRestoreVolumeFromSnapshotInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartMisconfiguredStateRecovery struct {
}

func (*validateOpStartMisconfiguredStateRecovery) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartMisconfiguredStateRecovery) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartMisconfiguredStateRecoveryInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartMisconfiguredStateRecoveryInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateDataRepositoryAssociation struct {
}

func (*validateOpUpdateDataRepositoryAssociation) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateDataRepositoryAssociation) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateDataRepositoryAssociationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateDataRepositoryAssociationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateFileCache struct {
}

func (*validateOpUpdateFileCache) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateFileCache) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateFileCacheInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateFileCacheInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateFileSystem struct {
}

func (*validateOpUpdateFileSystem) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateFileSystem) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateFileSystemInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateFileSystemInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateSnapshot struct {
}

func (*validateOpUpdateSnapshot) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateSnapshot) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateSnapshotInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateSnapshotInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateStorageVirtualMachine struct {
}

func (*validateOpUpdateStorageVirtualMachine) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateStorageVirtualMachine) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateStorageVirtualMachineInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateStorageVirtualMachineInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateVolume struct {
}

func (*validateOpUpdateVolume) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateVolume) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateVolumeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateVolumeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpAssociateFileSystemAliasesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAssociateFileSystemAliases{}, middleware.After)
}

func addOpCancelDataRepositoryTaskValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCancelDataRepositoryTask{}, middleware.After)
}

func addOpCopyBackupValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCopyBackup{}, middleware.After)
}

func addOpCopySnapshotAndUpdateVolumeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCopySnapshotAndUpdateVolume{}, middleware.After)
}

func addOpCreateBackupValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateBackup{}, middleware.After)
}

func addOpCreateDataRepositoryAssociationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateDataRepositoryAssociation{}, middleware.After)
}

func addOpCreateDataRepositoryTaskValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateDataRepositoryTask{}, middleware.After)
}

func addOpCreateFileCacheValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateFileCache{}, middleware.After)
}

func addOpCreateFileSystemFromBackupValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateFileSystemFromBackup{}, middleware.After)
}

func addOpCreateFileSystemValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateFileSystem{}, middleware.After)
}

func addOpCreateSnapshotValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateSnapshot{}, middleware.After)
}

func addOpCreateStorageVirtualMachineValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateStorageVirtualMachine{}, middleware.After)
}

func addOpCreateVolumeFromBackupValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateVolumeFromBackup{}, middleware.After)
}

func addOpCreateVolumeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateVolume{}, middleware.After)
}

func addOpDeleteBackupValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteBackup{}, middleware.After)
}

func addOpDeleteDataRepositoryAssociationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteDataRepositoryAssociation{}, middleware.After)
}

func addOpDeleteFileCacheValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteFileCache{}, middleware.After)
}

func addOpDeleteFileSystemValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteFileSystem{}, middleware.After)
}

func addOpDeleteSnapshotValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteSnapshot{}, middleware.After)
}

func addOpDeleteStorageVirtualMachineValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteStorageVirtualMachine{}, middleware.After)
}

func addOpDeleteVolumeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteVolume{}, middleware.After)
}

func addOpDescribeFileSystemAliasesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeFileSystemAliases{}, middleware.After)
}

func addOpDisassociateFileSystemAliasesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDisassociateFileSystemAliases{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpReleaseFileSystemNfsV3LocksValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpReleaseFileSystemNfsV3Locks{}, middleware.After)
}

func addOpRestoreVolumeFromSnapshotValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRestoreVolumeFromSnapshot{}, middleware.After)
}

func addOpStartMisconfiguredStateRecoveryValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartMisconfiguredStateRecovery{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateDataRepositoryAssociationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateDataRepositoryAssociation{}, middleware.After)
}

func addOpUpdateFileCacheValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateFileCache{}, middleware.After)
}

func addOpUpdateFileSystemValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateFileSystem{}, middleware.After)
}

func addOpUpdateSnapshotValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateSnapshot{}, middleware.After)
}

func addOpUpdateStorageVirtualMachineValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateStorageVirtualMachine{}, middleware.After)
}

func addOpUpdateVolumeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateVolume{}, middleware.After)
}

func validateAutocommitPeriod(v *types.AutocommitPeriod) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AutocommitPeriod"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCompletionReport(v *types.CompletionReport) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CompletionReport"}
	if v.Enabled == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Enabled"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCreateFileCacheDataRepositoryAssociations(v []types.FileCacheDataRepositoryAssociation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateFileCacheDataRepositoryAssociations"}
	for i := range v {
		if err := validateFileCacheDataRepositoryAssociation(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCreateFileCacheLustreConfiguration(v *types.CreateFileCacheLustreConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateFileCacheLustreConfiguration"}
	if v.PerUnitStorageThroughput == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PerUnitStorageThroughput"))
	}
	if len(v.DeploymentType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("DeploymentType"))
	}
	if v.MetadataConfiguration == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MetadataConfiguration"))
	} else if v.MetadataConfiguration != nil {
		if err := validateFileCacheLustreMetadataConfiguration(v.MetadataConfiguration); err != nil {
			invalidParams.AddNested("MetadataConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCreateFileSystemLustreConfiguration(v *types.CreateFileSystemLustreConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateFileSystemLustreConfiguration"}
	if v.LogConfiguration != nil {
		if err := validateLustreLogCreateConfiguration(v.LogConfiguration); err != nil {
			invalidParams.AddNested("LogConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.MetadataConfiguration != nil {
		if err := validateCreateFileSystemLustreMetadataConfiguration(v.MetadataConfiguration); err != nil {
			invalidParams.AddNested("MetadataConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCreateFileSystemLustreMetadataConfiguration(v *types.CreateFileSystemLustreMetadataConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateFileSystemLustreMetadataConfiguration"}
	if len(v.Mode) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Mode"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCreateFileSystemOntapConfiguration(v *types.CreateFileSystemOntapConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateFileSystemOntapConfiguration"}
	if len(v.DeploymentType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("DeploymentType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCreateFileSystemOpenZFSConfiguration(v *types.CreateFileSystemOpenZFSConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateFileSystemOpenZFSConfiguration"}
	if len(v.DeploymentType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("DeploymentType"))
	}
	if v.ThroughputCapacity == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ThroughputCapacity"))
	}
	if v.RootVolumeConfiguration != nil {
		if err := validateOpenZFSCreateRootVolumeConfiguration(v.RootVolumeConfiguration); err != nil {
			invalidParams.AddNested("RootVolumeConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCreateFileSystemWindowsConfiguration(v *types.CreateFileSystemWindowsConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateFileSystemWindowsConfiguration"}
	if v.SelfManagedActiveDirectoryConfiguration != nil {
		if err := validateSelfManagedActiveDirectoryConfiguration(v.SelfManagedActiveDirectoryConfiguration); err != nil {
			invalidParams.AddNested("SelfManagedActiveDirectoryConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.ThroughputCapacity == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ThroughputCapacity"))
	}
	if v.AuditLogConfiguration != nil {
		if err := validateWindowsAuditLogCreateConfiguration(v.AuditLogConfiguration); err != nil {
			invalidParams.AddNested("AuditLogConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCreateOntapVolumeConfiguration(v *types.CreateOntapVolumeConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateOntapVolumeConfiguration"}
	if v.StorageVirtualMachineId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StorageVirtualMachineId"))
	}
	if v.SnaplockConfiguration != nil {
		if err := validateCreateSnaplockConfiguration(v.SnaplockConfiguration); err != nil {
			invalidParams.AddNested("SnaplockConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCreateOpenZFSOriginSnapshotConfiguration(v *types.CreateOpenZFSOriginSnapshotConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateOpenZFSOriginSnapshotConfiguration"}
	if v.SnapshotARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SnapshotARN"))
	}
	if len(v.CopyStrategy) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("CopyStrategy"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCreateOpenZFSVolumeConfiguration(v *types.CreateOpenZFSVolumeConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateOpenZFSVolumeConfiguration"}
	if v.ParentVolumeId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ParentVolumeId"))
	}
	if v.OriginSnapshot != nil {
		if err := validateCreateOpenZFSOriginSnapshotConfiguration(v.OriginSnapshot); err != nil {
			invalidParams.AddNested("OriginSnapshot", err.(smithy.InvalidParamsError))
		}
	}
	if v.NfsExports != nil {
		if err := validateOpenZFSNfsExports(v.NfsExports); err != nil {
			invalidParams.AddNested("NfsExports", err.(smithy.InvalidParamsError))
		}
	}
	if v.UserAndGroupQuotas != nil {
		if err := validateOpenZFSUserAndGroupQuotas(v.UserAndGroupQuotas); err != nil {
			invalidParams.AddNested("UserAndGroupQuotas", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCreateSnaplockConfiguration(v *types.CreateSnaplockConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateSnaplockConfiguration"}
	if v.AutocommitPeriod != nil {
		if err := validateAutocommitPeriod(v.AutocommitPeriod); err != nil {
			invalidParams.AddNested("AutocommitPeriod", err.(smithy.InvalidParamsError))
		}
	}
	if v.RetentionPeriod != nil {
		if err := validateSnaplockRetentionPeriod(v.RetentionPeriod); err != nil {
			invalidParams.AddNested("RetentionPeriod", err.(smithy.InvalidParamsError))
		}
	}
	if len(v.SnaplockType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("SnaplockType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateCreateSvmActiveDirectoryConfiguration(v *types.CreateSvmActiveDirectoryConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateSvmActiveDirectoryConfiguration"}
	if v.NetBiosName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("NetBiosName"))
	}
	if v.SelfManagedActiveDirectoryConfiguration != nil {
		if err := validateSelfManagedActiveDirectoryConfiguration(v.SelfManagedActiveDirectoryConfiguration); err != nil {
			invalidParams.AddNested("SelfManagedActiveDirectoryConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDeleteFileSystemLustreConfiguration(v *types.DeleteFileSystemLustreConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteFileSystemLustreConfiguration"}
	if v.FinalBackupTags != nil {
		if err := validateTags(v.FinalBackupTags); err != nil {
			invalidParams.AddNested("FinalBackupTags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDeleteFileSystemOpenZFSConfiguration(v *types.DeleteFileSystemOpenZFSConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteFileSystemOpenZFSConfiguration"}
	if v.FinalBackupTags != nil {
		if err := validateTags(v.FinalBackupTags); err != nil {
			invalidParams.AddNested("FinalBackupTags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDeleteFileSystemWindowsConfiguration(v *types.DeleteFileSystemWindowsConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteFileSystemWindowsConfiguration"}
	if v.FinalBackupTags != nil {
		if err := validateTags(v.FinalBackupTags); err != nil {
			invalidParams.AddNested("FinalBackupTags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateDeleteVolumeOntapConfiguration(v *types.DeleteVolumeOntapConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteVolumeOntapConfiguration"}
	if v.FinalBackupTags != nil {
		if err := validateTags(v.FinalBackupTags); err != nil {
			invalidParams.AddNested("FinalBackupTags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateFileCacheDataRepositoryAssociation(v *types.FileCacheDataRepositoryAssociation) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "FileCacheDataRepositoryAssociation"}
	if v.FileCachePath == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FileCachePath"))
	}
	if v.DataRepositoryPath == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataRepositoryPath"))
	}
	if v.NFS != nil {
		if err := validateFileCacheNFSConfiguration(v.NFS); err != nil {
			invalidParams.AddNested("NFS", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateFileCacheLustreMetadataConfiguration(v *types.FileCacheLustreMetadataConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "FileCacheLustreMetadataConfiguration"}
	if v.StorageCapacity == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StorageCapacity"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateFileCacheNFSConfiguration(v *types.FileCacheNFSConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "FileCacheNFSConfiguration"}
	if len(v.Version) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Version"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateLustreLogCreateConfiguration(v *types.LustreLogCreateConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "LustreLogCreateConfiguration"}
	if len(v.Level) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Level"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpenZFSClientConfiguration(v *types.OpenZFSClientConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OpenZFSClientConfiguration"}
	if v.Clients == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Clients"))
	}
	if v.Options == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Options"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpenZFSClientConfigurations(v []types.OpenZFSClientConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OpenZFSClientConfigurations"}
	for i := range v {
		if err := validateOpenZFSClientConfiguration(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpenZFSCreateRootVolumeConfiguration(v *types.OpenZFSCreateRootVolumeConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OpenZFSCreateRootVolumeConfiguration"}
	if v.NfsExports != nil {
		if err := validateOpenZFSNfsExports(v.NfsExports); err != nil {
			invalidParams.AddNested("NfsExports", err.(smithy.InvalidParamsError))
		}
	}
	if v.UserAndGroupQuotas != nil {
		if err := validateOpenZFSUserAndGroupQuotas(v.UserAndGroupQuotas); err != nil {
			invalidParams.AddNested("UserAndGroupQuotas", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpenZFSNfsExport(v *types.OpenZFSNfsExport) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OpenZFSNfsExport"}
	if v.ClientConfigurations == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ClientConfigurations"))
	} else if v.ClientConfigurations != nil {
		if err := validateOpenZFSClientConfigurations(v.ClientConfigurations); err != nil {
			invalidParams.AddNested("ClientConfigurations", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpenZFSNfsExports(v []types.OpenZFSNfsExport) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OpenZFSNfsExports"}
	for i := range v {
		if err := validateOpenZFSNfsExport(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpenZFSUserAndGroupQuotas(v []types.OpenZFSUserOrGroupQuota) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OpenZFSUserAndGroupQuotas"}
	for i := range v {
		if err := validateOpenZFSUserOrGroupQuota(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpenZFSUserOrGroupQuota(v *types.OpenZFSUserOrGroupQuota) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "OpenZFSUserOrGroupQuota"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.Id == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Id"))
	}
	if v.StorageCapacityQuotaGiB == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StorageCapacityQuotaGiB"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateRetentionPeriod(v *types.RetentionPeriod) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RetentionPeriod"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSelfManagedActiveDirectoryConfiguration(v *types.SelfManagedActiveDirectoryConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SelfManagedActiveDirectoryConfiguration"}
	if v.DomainName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DomainName"))
	}
	if v.UserName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UserName"))
	}
	if v.Password == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Password"))
	}
	if v.DnsIps == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DnsIps"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSnaplockRetentionPeriod(v *types.SnaplockRetentionPeriod) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SnaplockRetentionPeriod"}
	if v.DefaultRetention == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DefaultRetention"))
	} else if v.DefaultRetention != nil {
		if err := validateRetentionPeriod(v.DefaultRetention); err != nil {
			invalidParams.AddNested("DefaultRetention", err.(smithy.InvalidParamsError))
		}
	}
	if v.MinimumRetention == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MinimumRetention"))
	} else if v.MinimumRetention != nil {
		if err := validateRetentionPeriod(v.MinimumRetention); err != nil {
			invalidParams.AddNested("MinimumRetention", err.(smithy.InvalidParamsError))
		}
	}
	if v.MaximumRetention == nil {
		invalidParams.Add(smithy.NewErrParamRequired("MaximumRetention"))
	} else if v.MaximumRetention != nil {
		if err := validateRetentionPeriod(v.MaximumRetention); err != nil {
			invalidParams.AddNested("MaximumRetention", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTag(v *types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Tag"}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTags(v []types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Tags"}
	for i := range v {
		if err := validateTag(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateUpdateFileSystemLustreConfiguration(v *types.UpdateFileSystemLustreConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateFileSystemLustreConfiguration"}
	if v.LogConfiguration != nil {
		if err := validateLustreLogCreateConfiguration(v.LogConfiguration); err != nil {
			invalidParams.AddNested("LogConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateUpdateFileSystemWindowsConfiguration(v *types.UpdateFileSystemWindowsConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateFileSystemWindowsConfiguration"}
	if v.AuditLogConfiguration != nil {
		if err := validateWindowsAuditLogCreateConfiguration(v.AuditLogConfiguration); err != nil {
			invalidParams.AddNested("AuditLogConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateUpdateOntapVolumeConfiguration(v *types.UpdateOntapVolumeConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateOntapVolumeConfiguration"}
	if v.SnaplockConfiguration != nil {
		if err := validateUpdateSnaplockConfiguration(v.SnaplockConfiguration); err != nil {
			invalidParams.AddNested("SnaplockConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateUpdateOpenZFSVolumeConfiguration(v *types.UpdateOpenZFSVolumeConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateOpenZFSVolumeConfiguration"}
	if v.NfsExports != nil {
		if err := validateOpenZFSNfsExports(v.NfsExports); err != nil {
			invalidParams.AddNested("NfsExports", err.(smithy.InvalidParamsError))
		}
	}
	if v.UserAndGroupQuotas != nil {
		if err := validateOpenZFSUserAndGroupQuotas(v.UserAndGroupQuotas); err != nil {
			invalidParams.AddNested("UserAndGroupQuotas", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateUpdateSnaplockConfiguration(v *types.UpdateSnaplockConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateSnaplockConfiguration"}
	if v.AutocommitPeriod != nil {
		if err := validateAutocommitPeriod(v.AutocommitPeriod); err != nil {
			invalidParams.AddNested("AutocommitPeriod", err.(smithy.InvalidParamsError))
		}
	}
	if v.RetentionPeriod != nil {
		if err := validateSnaplockRetentionPeriod(v.RetentionPeriod); err != nil {
			invalidParams.AddNested("RetentionPeriod", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateWindowsAuditLogCreateConfiguration(v *types.WindowsAuditLogCreateConfiguration) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "WindowsAuditLogCreateConfiguration"}
	if len(v.FileAccessAuditLogLevel) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("FileAccessAuditLogLevel"))
	}
	if len(v.FileShareAccessAuditLogLevel) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("FileShareAccessAuditLogLevel"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAssociateFileSystemAliasesInput(v *AssociateFileSystemAliasesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AssociateFileSystemAliasesInput"}
	if v.FileSystemId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FileSystemId"))
	}
	if v.Aliases == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Aliases"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCancelDataRepositoryTaskInput(v *CancelDataRepositoryTaskInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CancelDataRepositoryTaskInput"}
	if v.TaskId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TaskId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCopyBackupInput(v *CopyBackupInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CopyBackupInput"}
	if v.SourceBackupId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceBackupId"))
	}
	if v.Tags != nil {
		if err := validateTags(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCopySnapshotAndUpdateVolumeInput(v *CopySnapshotAndUpdateVolumeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CopySnapshotAndUpdateVolumeInput"}
	if v.VolumeId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VolumeId"))
	}
	if v.SourceSnapshotARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceSnapshotARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateBackupInput(v *CreateBackupInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateBackupInput"}
	if v.Tags != nil {
		if err := validateTags(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateDataRepositoryAssociationInput(v *CreateDataRepositoryAssociationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateDataRepositoryAssociationInput"}
	if v.FileSystemId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FileSystemId"))
	}
	if v.DataRepositoryPath == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DataRepositoryPath"))
	}
	if v.Tags != nil {
		if err := validateTags(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateDataRepositoryTaskInput(v *CreateDataRepositoryTaskInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateDataRepositoryTaskInput"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if v.FileSystemId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FileSystemId"))
	}
	if v.Report == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Report"))
	} else if v.Report != nil {
		if err := validateCompletionReport(v.Report); err != nil {
			invalidParams.AddNested("Report", err.(smithy.InvalidParamsError))
		}
	}
	if v.Tags != nil {
		if err := validateTags(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateFileCacheInput(v *CreateFileCacheInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateFileCacheInput"}
	if len(v.FileCacheType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("FileCacheType"))
	}
	if v.FileCacheTypeVersion == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FileCacheTypeVersion"))
	}
	if v.StorageCapacity == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StorageCapacity"))
	}
	if v.SubnetIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SubnetIds"))
	}
	if v.Tags != nil {
		if err := validateTags(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if v.LustreConfiguration != nil {
		if err := validateCreateFileCacheLustreConfiguration(v.LustreConfiguration); err != nil {
			invalidParams.AddNested("LustreConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.DataRepositoryAssociations != nil {
		if err := validateCreateFileCacheDataRepositoryAssociations(v.DataRepositoryAssociations); err != nil {
			invalidParams.AddNested("DataRepositoryAssociations", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateFileSystemFromBackupInput(v *CreateFileSystemFromBackupInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateFileSystemFromBackupInput"}
	if v.BackupId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BackupId"))
	}
	if v.SubnetIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SubnetIds"))
	}
	if v.Tags != nil {
		if err := validateTags(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if v.WindowsConfiguration != nil {
		if err := validateCreateFileSystemWindowsConfiguration(v.WindowsConfiguration); err != nil {
			invalidParams.AddNested("WindowsConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.LustreConfiguration != nil {
		if err := validateCreateFileSystemLustreConfiguration(v.LustreConfiguration); err != nil {
			invalidParams.AddNested("LustreConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.OpenZFSConfiguration != nil {
		if err := validateCreateFileSystemOpenZFSConfiguration(v.OpenZFSConfiguration); err != nil {
			invalidParams.AddNested("OpenZFSConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateFileSystemInput(v *CreateFileSystemInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateFileSystemInput"}
	if len(v.FileSystemType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("FileSystemType"))
	}
	if v.SubnetIds == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SubnetIds"))
	}
	if v.Tags != nil {
		if err := validateTags(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if v.WindowsConfiguration != nil {
		if err := validateCreateFileSystemWindowsConfiguration(v.WindowsConfiguration); err != nil {
			invalidParams.AddNested("WindowsConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.LustreConfiguration != nil {
		if err := validateCreateFileSystemLustreConfiguration(v.LustreConfiguration); err != nil {
			invalidParams.AddNested("LustreConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.OntapConfiguration != nil {
		if err := validateCreateFileSystemOntapConfiguration(v.OntapConfiguration); err != nil {
			invalidParams.AddNested("OntapConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.OpenZFSConfiguration != nil {
		if err := validateCreateFileSystemOpenZFSConfiguration(v.OpenZFSConfiguration); err != nil {
			invalidParams.AddNested("OpenZFSConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateSnapshotInput(v *CreateSnapshotInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateSnapshotInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.VolumeId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VolumeId"))
	}
	if v.Tags != nil {
		if err := validateTags(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateStorageVirtualMachineInput(v *CreateStorageVirtualMachineInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateStorageVirtualMachineInput"}
	if v.ActiveDirectoryConfiguration != nil {
		if err := validateCreateSvmActiveDirectoryConfiguration(v.ActiveDirectoryConfiguration); err != nil {
			invalidParams.AddNested("ActiveDirectoryConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.FileSystemId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FileSystemId"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Tags != nil {
		if err := validateTags(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateVolumeFromBackupInput(v *CreateVolumeFromBackupInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateVolumeFromBackupInput"}
	if v.BackupId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BackupId"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.OntapConfiguration != nil {
		if err := validateCreateOntapVolumeConfiguration(v.OntapConfiguration); err != nil {
			invalidParams.AddNested("OntapConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.Tags != nil {
		if err := validateTags(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateVolumeInput(v *CreateVolumeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateVolumeInput"}
	if len(v.VolumeType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("VolumeType"))
	}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.OntapConfiguration != nil {
		if err := validateCreateOntapVolumeConfiguration(v.OntapConfiguration); err != nil {
			invalidParams.AddNested("OntapConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.Tags != nil {
		if err := validateTags(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if v.OpenZFSConfiguration != nil {
		if err := validateCreateOpenZFSVolumeConfiguration(v.OpenZFSConfiguration); err != nil {
			invalidParams.AddNested("OpenZFSConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteBackupInput(v *DeleteBackupInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteBackupInput"}
	if v.BackupId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("BackupId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteDataRepositoryAssociationInput(v *DeleteDataRepositoryAssociationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteDataRepositoryAssociationInput"}
	if v.AssociationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssociationId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteFileCacheInput(v *DeleteFileCacheInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteFileCacheInput"}
	if v.FileCacheId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FileCacheId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteFileSystemInput(v *DeleteFileSystemInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteFileSystemInput"}
	if v.FileSystemId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FileSystemId"))
	}
	if v.WindowsConfiguration != nil {
		if err := validateDeleteFileSystemWindowsConfiguration(v.WindowsConfiguration); err != nil {
			invalidParams.AddNested("WindowsConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.LustreConfiguration != nil {
		if err := validateDeleteFileSystemLustreConfiguration(v.LustreConfiguration); err != nil {
			invalidParams.AddNested("LustreConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.OpenZFSConfiguration != nil {
		if err := validateDeleteFileSystemOpenZFSConfiguration(v.OpenZFSConfiguration); err != nil {
			invalidParams.AddNested("OpenZFSConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteSnapshotInput(v *DeleteSnapshotInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteSnapshotInput"}
	if v.SnapshotId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SnapshotId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteStorageVirtualMachineInput(v *DeleteStorageVirtualMachineInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteStorageVirtualMachineInput"}
	if v.StorageVirtualMachineId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StorageVirtualMachineId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteVolumeInput(v *DeleteVolumeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteVolumeInput"}
	if v.VolumeId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VolumeId"))
	}
	if v.OntapConfiguration != nil {
		if err := validateDeleteVolumeOntapConfiguration(v.OntapConfiguration); err != nil {
			invalidParams.AddNested("OntapConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeFileSystemAliasesInput(v *DescribeFileSystemAliasesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeFileSystemAliasesInput"}
	if v.FileSystemId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FileSystemId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDisassociateFileSystemAliasesInput(v *DisassociateFileSystemAliasesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DisassociateFileSystemAliasesInput"}
	if v.FileSystemId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FileSystemId"))
	}
	if v.Aliases == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Aliases"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceARN"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpReleaseFileSystemNfsV3LocksInput(v *ReleaseFileSystemNfsV3LocksInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ReleaseFileSystemNfsV3LocksInput"}
	if v.FileSystemId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FileSystemId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRestoreVolumeFromSnapshotInput(v *RestoreVolumeFromSnapshotInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RestoreVolumeFromSnapshotInput"}
	if v.VolumeId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VolumeId"))
	}
	if v.SnapshotId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SnapshotId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartMisconfiguredStateRecoveryInput(v *StartMisconfiguredStateRecoveryInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartMisconfiguredStateRecoveryInput"}
	if v.FileSystemId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FileSystemId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceARN"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	} else if v.Tags != nil {
		if err := validateTags(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceARN == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceARN"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateDataRepositoryAssociationInput(v *UpdateDataRepositoryAssociationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateDataRepositoryAssociationInput"}
	if v.AssociationId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssociationId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateFileCacheInput(v *UpdateFileCacheInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateFileCacheInput"}
	if v.FileCacheId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FileCacheId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateFileSystemInput(v *UpdateFileSystemInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateFileSystemInput"}
	if v.FileSystemId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("FileSystemId"))
	}
	if v.WindowsConfiguration != nil {
		if err := validateUpdateFileSystemWindowsConfiguration(v.WindowsConfiguration); err != nil {
			invalidParams.AddNested("WindowsConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.LustreConfiguration != nil {
		if err := validateUpdateFileSystemLustreConfiguration(v.LustreConfiguration); err != nil {
			invalidParams.AddNested("LustreConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateSnapshotInput(v *UpdateSnapshotInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateSnapshotInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.SnapshotId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SnapshotId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateStorageVirtualMachineInput(v *UpdateStorageVirtualMachineInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateStorageVirtualMachineInput"}
	if v.StorageVirtualMachineId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StorageVirtualMachineId"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateVolumeInput(v *UpdateVolumeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateVolumeInput"}
	if v.VolumeId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VolumeId"))
	}
	if v.OntapConfiguration != nil {
		if err := validateUpdateOntapVolumeConfiguration(v.OntapConfiguration); err != nil {
			invalidParams.AddNested("OntapConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if v.OpenZFSConfiguration != nil {
		if err := validateUpdateOpenZFSVolumeConfiguration(v.OpenZFSConfiguration); err != nil {
			invalidParams.AddNested("OpenZFSConfiguration", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
