// Code generated by smithy-go-codegen DO NOT EDIT.

package datazone

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/datazone/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Updates a project profile.
func (c *Client) UpdateProjectProfile(ctx context.Context, params *UpdateProjectProfileInput, optFns ...func(*Options)) (*UpdateProjectProfileOutput, error) {
	if params == nil {
		params = &UpdateProjectProfileInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateProjectProfile", params, optFns, c.addOperationUpdateProjectProfileMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateProjectProfileOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateProjectProfileInput struct {

	// The ID of the domain where a project profile is to be updated.
	//
	// This member is required.
	DomainIdentifier *string

	// The ID of a project profile that is to be updated.
	//
	// This member is required.
	Identifier *string

	// The description of a project profile.
	Description *string

	// The ID of the domain unit where a project profile is to be updated.
	DomainUnitIdentifier *string

	// The environment configurations of a project profile.
	EnvironmentConfigurations []types.EnvironmentConfiguration

	// The name of a project profile.
	Name *string

	// The status of a project profile.
	Status types.Status

	noSmithyDocumentSerde
}

type UpdateProjectProfileOutput struct {

	// The user who created a project profile.
	//
	// This member is required.
	CreatedBy *string

	// The ID of the domain where project profile is to be updated.
	//
	// This member is required.
	DomainId *string

	// The ID of the project profile.
	//
	// This member is required.
	Id *string

	// The name of the project profile.
	//
	// This member is required.
	Name *string

	// The timestamp at which a project profile is created.
	CreatedAt *time.Time

	// The description of a project profile.
	Description *string

	// The domain unit ID of the project profile to be updated.
	DomainUnitId *string

	// The environment configurations of a project profile.
	EnvironmentConfigurations []types.EnvironmentConfiguration

	// The timestamp at which a project profile was last updated.
	LastUpdatedAt *time.Time

	// The status of the project profile.
	Status types.Status

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateProjectProfileMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateProjectProfile{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateProjectProfile{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateProjectProfile"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateProjectProfileValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateProjectProfile(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateProjectProfile(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateProjectProfile",
	}
}
