// Code generated by smithy-go-codegen DO NOT EDIT.

package bcmpricingcalculator

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bcmpricingcalculator/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves details of a specific workload estimate.
func (c *Client) GetWorkloadEstimate(ctx context.Context, params *GetWorkloadEstimateInput, optFns ...func(*Options)) (*GetWorkloadEstimateOutput, error) {
	if params == nil {
		params = &GetWorkloadEstimateInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetWorkloadEstimate", params, optFns, c.addOperationGetWorkloadEstimateMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetWorkloadEstimateOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetWorkloadEstimateInput struct {

	//  The unique identifier of the workload estimate to retrieve.
	//
	// This member is required.
	Identifier *string

	noSmithyDocumentSerde
}

// Mixin for common fields returned by CRUD APIs
type GetWorkloadEstimateOutput struct {

	//  The unique identifier of the retrieved workload estimate.
	//
	// This member is required.
	Id *string

	//  The currency of the estimated cost.
	CostCurrency types.CurrencyCode

	//  The timestamp when the workload estimate was created.
	CreatedAt *time.Time

	//  The timestamp when the workload estimate will expire.
	ExpiresAt *time.Time

	//  An error message if the workload estimate retrieval failed.
	FailureMessage *string

	//  The name of the retrieved workload estimate.
	Name *string

	//  The timestamp of the pricing rates used for the estimate.
	RateTimestamp *time.Time

	//  The type of pricing rates used for the estimate.
	RateType types.WorkloadEstimateRateType

	//  The current status of the workload estimate.
	Status types.WorkloadEstimateStatus

	//  The total estimated cost for the workload.
	TotalCost *float64

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetWorkloadEstimateMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetWorkloadEstimate{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetWorkloadEstimate{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetWorkloadEstimate"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetWorkloadEstimateValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetWorkloadEstimate(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetWorkloadEstimate(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetWorkloadEstimate",
	}
}
