// Code generated by smithy-go-codegen DO NOT EDIT.

package servicecatalogappregistry

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/servicecatalogappregistry/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets the resource associated with the application.
func (c *Client) GetAssociatedResource(ctx context.Context, params *GetAssociatedResourceInput, optFns ...func(*Options)) (*GetAssociatedResourceOutput, error) {
	if params == nil {
		params = &GetAssociatedResourceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetAssociatedResource", params, optFns, c.addOperationGetAssociatedResourceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetAssociatedResourceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetAssociatedResourceInput struct {

	// The name, ID, or ARN of the application.
	//
	// This member is required.
	Application *string

	// The name or ID of the resource associated with the application.
	//
	// This member is required.
	Resource *string

	// The type of resource associated with the application.
	//
	// This member is required.
	ResourceType types.ResourceType

	// The maximum number of results to return. If the parameter is omitted, it
	// defaults to 25. The value is optional.
	MaxResults *int32

	// A unique pagination token for each page of results. Make the call again with
	// the returned token to retrieve the next page of results.
	NextToken *string

	// States whether an application tag is applied, not applied, in the process of
	// being applied, or skipped.
	ResourceTagStatus []types.ResourceItemStatus

	noSmithyDocumentSerde
}

type GetAssociatedResourceOutput struct {

	// The result of the application that's tag applied to a resource.
	ApplicationTagResult *types.ApplicationTagResult

	// Determines whether an application tag is applied or skipped.
	Options []types.AssociationOption

	// The resource associated with the application.
	Resource *types.Resource

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetAssociatedResourceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetAssociatedResource{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetAssociatedResource{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetAssociatedResource"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetAssociatedResourceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetAssociatedResource(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetAssociatedResource(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetAssociatedResource",
	}
}
