// Code generated by smithy-go-codegen DO NOT EDIT.

package servicecatalog

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Disassociates the specified self-service action association from the specified
// provisioning artifact.
func (c *Client) DisassociateServiceActionFromProvisioningArtifact(ctx context.Context, params *DisassociateServiceActionFromProvisioningArtifactInput, optFns ...func(*Options)) (*DisassociateServiceActionFromProvisioningArtifactOutput, error) {
	if params == nil {
		params = &DisassociateServiceActionFromProvisioningArtifactInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DisassociateServiceActionFromProvisioningArtifact", params, optFns, c.addOperationDisassociateServiceActionFromProvisioningArtifactMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DisassociateServiceActionFromProvisioningArtifactOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DisassociateServiceActionFromProvisioningArtifactInput struct {

	// The product identifier. For example, prod-abcdzk7xy33qa .
	//
	// This member is required.
	ProductId *string

	// The identifier of the provisioning artifact. For example, pa-4abcdjnxjj6ne .
	//
	// This member is required.
	ProvisioningArtifactId *string

	// The self-service action identifier. For example, act-fs7abcd89wxyz .
	//
	// This member is required.
	ServiceActionId *string

	// The language code.
	//   - jp - Japanese
	//   - zh - Chinese
	AcceptLanguage *string

	// A unique identifier that you provide to ensure idempotency. If multiple
	// requests from the same Amazon Web Services account use the same idempotency
	// token, the same response is returned for each repeated request.
	IdempotencyToken *string

	noSmithyDocumentSerde
}

type DisassociateServiceActionFromProvisioningArtifactOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDisassociateServiceActionFromProvisioningArtifactMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpDisassociateServiceActionFromProvisioningArtifact{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpDisassociateServiceActionFromProvisioningArtifact{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DisassociateServiceActionFromProvisioningArtifact"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opDisassociateServiceActionFromProvisioningArtifactMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpDisassociateServiceActionFromProvisioningArtifactValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDisassociateServiceActionFromProvisioningArtifact(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpDisassociateServiceActionFromProvisioningArtifact struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpDisassociateServiceActionFromProvisioningArtifact) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpDisassociateServiceActionFromProvisioningArtifact) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*DisassociateServiceActionFromProvisioningArtifactInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *DisassociateServiceActionFromProvisioningArtifactInput ")
	}

	if input.IdempotencyToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.IdempotencyToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opDisassociateServiceActionFromProvisioningArtifactMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpDisassociateServiceActionFromProvisioningArtifact{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opDisassociateServiceActionFromProvisioningArtifact(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DisassociateServiceActionFromProvisioningArtifact",
	}
}
