// Code generated by smithy-go-codegen DO NOT EDIT.

package s3control

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	s3controlcust "github.com/aws/aws-sdk-go-v2/service/s3control/internal/customizations"
	"github.com/aws/aws-sdk-go-v2/service/s3control/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"strings"
)

// Returns a temporary access credential from S3 Access Grants to the grantee or
// client application. The temporary credential (https://docs.aws.amazon.com/STS/latest/APIReference/API_Credentials.html)
// is an Amazon Web Services STS token that grants them access to the S3 data.
// Permissions You must have the s3:GetDataAccess permission to use this
// operation. Additional Permissions The IAM role that S3 Access Grants assumes
// must have the following permissions specified in the trust policy when
// registering the location: sts:AssumeRole , for directory users or groups
// sts:SetContext , and for IAM users or roles sts:SourceIdentity .
func (c *Client) GetDataAccess(ctx context.Context, params *GetDataAccessInput, optFns ...func(*Options)) (*GetDataAccessOutput, error) {
	if params == nil {
		params = &GetDataAccessInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetDataAccess", params, optFns, c.addOperationGetDataAccessMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetDataAccessOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetDataAccessInput struct {

	// The ID of the Amazon Web Services account that is making this request.
	//
	// This member is required.
	AccountId *string

	// The type of permission granted to your S3 data, which can be set to one of the
	// following values:
	//   - READ – Grant read-only access to the S3 data.
	//   - WRITE – Grant write-only access to the S3 data.
	//   - READWRITE – Grant both read and write access to the S3 data.
	//
	// This member is required.
	Permission types.Permission

	// The S3 URI path of the data to which you are requesting temporary access
	// credentials. If the requesting account has an access grant for this data, S3
	// Access Grants vends temporary access credentials in the response.
	//
	// This member is required.
	Target *string

	// The session duration, in seconds, of the temporary access credential that S3
	// Access Grants vends to the grantee or client application. The default value is 1
	// hour, but the grantee can specify a range from 900 seconds (15 minutes) up to
	// 43200 seconds (12 hours). If the grantee requests a value higher than this
	// maximum, the operation fails.
	DurationSeconds *int32

	// The scope of the temporary access credential that S3 Access Grants vends to the
	// grantee or client application.
	//   - Default – The scope of the returned temporary access token is the scope of
	//   the grant that is closest to the target scope.
	//   - Minimal – The scope of the returned temporary access token is the same as
	//   the requested target scope as long as the requested scope is the same as or a
	//   subset of the grant scope.
	Privilege types.Privilege

	// The type of Target . The only possible value is Object . Pass this value if the
	// target data that you would like to access is a path to an object. Do not pass
	// this value if the target data is a bucket or a bucket and a prefix.
	TargetType types.S3PrefixType

	noSmithyDocumentSerde
}

func (in *GetDataAccessInput) bindEndpointParams(p *EndpointParameters) {
	p.AccountId = in.AccountId
	p.RequiresAccountId = ptr.Bool(true)
}

type GetDataAccessOutput struct {

	// The temporary credential token that S3 Access Grants vends.
	Credentials *types.Credentials

	// The S3 URI path of the data to which you are being granted temporary access
	// credentials.
	MatchedGrantTarget *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetDataAccessMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestxml_serializeOpGetDataAccess{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestxml_deserializeOpGetDataAccess{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetDataAccess"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = s3controlcust.AddUpdateOutpostARN(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddContentChecksumMiddleware(stack); err != nil {
		return err
	}
	if err = addEndpointPrefix_opGetDataAccessMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetDataAccessValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetDataAccess(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addMetadataRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addGetDataAccessUpdateEndpoint(stack, options); err != nil {
		return err
	}
	if err = addStashOperationInput(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = v4.AddContentSHA256HeaderMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = s3controlcust.AddDisableHostPrefixMiddleware(stack); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opGetDataAccessMiddleware struct {
}

func (*endpointPrefix_opGetDataAccessMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opGetDataAccessMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	opaqueInput := getOperationInput(ctx)
	input, ok := opaqueInput.(*GetDataAccessInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input type %T", opaqueInput)
	}

	var prefix strings.Builder
	if input.AccountId == nil {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("AccountId forms part of the endpoint host and so may not be nil")}
	} else if !smithyhttp.ValidHostLabel(*input.AccountId) {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("AccountId forms part of the endpoint host and so must match \"[a-zA-Z0-9-]{1,63}\", but was \"%s\"", *input.AccountId)}
	} else {
		prefix.WriteString(*input.AccountId)
	}
	prefix.WriteString(".")
	req.URL.Host = prefix.String() + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opGetDataAccessMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opGetDataAccessMiddleware{}, "ResolveEndpointV2", middleware.After)
}

func newServiceMetadataMiddleware_opGetDataAccess(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetDataAccess",
	}
}

func copyGetDataAccessInputForUpdateEndpoint(params interface{}) (interface{}, error) {
	input, ok := params.(*GetDataAccessInput)
	if !ok {
		return nil, fmt.Errorf("expect *GetDataAccessInput type, got %T", params)
	}
	cpy := *input
	return &cpy, nil
}
func (in *GetDataAccessInput) copy() interface{} {
	v := *in
	return &v
}
func backFillGetDataAccessAccountID(input interface{}, v string) error {
	in := input.(*GetDataAccessInput)
	if in.AccountId != nil {
		if !strings.EqualFold(*in.AccountId, v) {
			return fmt.Errorf("error backfilling account id")
		}
		return nil
	}
	in.AccountId = &v
	return nil
}
func addGetDataAccessUpdateEndpoint(stack *middleware.Stack, options Options) error {
	return s3controlcust.UpdateEndpoint(stack, s3controlcust.UpdateEndpointOptions{
		Accessor: s3controlcust.UpdateEndpointParameterAccessor{GetARNInput: nopGetARNAccessor,
			BackfillAccountID: nopBackfillAccountIDAccessor,
			GetOutpostIDInput: nopGetOutpostIDFromInput,
			UpdateARNField:    nopSetARNAccessor,
			CopyInput:         copyGetDataAccessInputForUpdateEndpoint,
		},
		EndpointResolver:        options.EndpointResolver,
		EndpointResolverOptions: options.EndpointOptions,
		UseARNRegion:            options.UseARNRegion,
	})
}
