// Code generated by smithy-go-codegen DO NOT EDIT.

package entityresolution

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/entityresolution/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of all the MatchingWorkflows that have been created for an
// Amazon Web Services account.
func (c *Client) ListMatchingWorkflows(ctx context.Context, params *ListMatchingWorkflowsInput, optFns ...func(*Options)) (*ListMatchingWorkflowsOutput, error) {
	if params == nil {
		params = &ListMatchingWorkflowsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListMatchingWorkflows", params, optFns, c.addOperationListMatchingWorkflowsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListMatchingWorkflowsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListMatchingWorkflowsInput struct {

	// The maximum number of objects returned per page.
	MaxResults *int32

	// The pagination token from the previous API call.
	NextToken *string

	noSmithyDocumentSerde
}

type ListMatchingWorkflowsOutput struct {

	// The pagination token from the previous API call.
	NextToken *string

	// A list of MatchingWorkflowSummary objects, each of which contain the fields
	// WorkflowName , WorkflowArn , CreatedAt , and UpdatedAt .
	WorkflowSummaries []types.MatchingWorkflowSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListMatchingWorkflowsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListMatchingWorkflows{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListMatchingWorkflows{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListMatchingWorkflows"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListMatchingWorkflows(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListMatchingWorkflowsAPIClient is a client that implements the
// ListMatchingWorkflows operation.
type ListMatchingWorkflowsAPIClient interface {
	ListMatchingWorkflows(context.Context, *ListMatchingWorkflowsInput, ...func(*Options)) (*ListMatchingWorkflowsOutput, error)
}

var _ ListMatchingWorkflowsAPIClient = (*Client)(nil)

// ListMatchingWorkflowsPaginatorOptions is the paginator options for
// ListMatchingWorkflows
type ListMatchingWorkflowsPaginatorOptions struct {
	// The maximum number of objects returned per page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListMatchingWorkflowsPaginator is a paginator for ListMatchingWorkflows
type ListMatchingWorkflowsPaginator struct {
	options   ListMatchingWorkflowsPaginatorOptions
	client    ListMatchingWorkflowsAPIClient
	params    *ListMatchingWorkflowsInput
	nextToken *string
	firstPage bool
}

// NewListMatchingWorkflowsPaginator returns a new ListMatchingWorkflowsPaginator
func NewListMatchingWorkflowsPaginator(client ListMatchingWorkflowsAPIClient, params *ListMatchingWorkflowsInput, optFns ...func(*ListMatchingWorkflowsPaginatorOptions)) *ListMatchingWorkflowsPaginator {
	if params == nil {
		params = &ListMatchingWorkflowsInput{}
	}

	options := ListMatchingWorkflowsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListMatchingWorkflowsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListMatchingWorkflowsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListMatchingWorkflows page.
func (p *ListMatchingWorkflowsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListMatchingWorkflowsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListMatchingWorkflows(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListMatchingWorkflows(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListMatchingWorkflows",
	}
}
