// Code generated by smithy-go-codegen DO NOT EDIT.

package cleanroomsml

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cleanroomsml/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Returns information about an audience generation job.
func (c *Client) GetAudienceGenerationJob(ctx context.Context, params *GetAudienceGenerationJobInput, optFns ...func(*Options)) (*GetAudienceGenerationJobOutput, error) {
	if params == nil {
		params = &GetAudienceGenerationJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetAudienceGenerationJob", params, optFns, c.addOperationGetAudienceGenerationJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetAudienceGenerationJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetAudienceGenerationJobInput struct {

	// The Amazon Resource Name (ARN) of the audience generation job that you are
	// interested in.
	//
	// This member is required.
	AudienceGenerationJobArn *string

	noSmithyDocumentSerde
}

type GetAudienceGenerationJobOutput struct {

	// The Amazon Resource Name (ARN) of the audience generation job.
	//
	// This member is required.
	AudienceGenerationJobArn *string

	// The Amazon Resource Name (ARN) of the configured audience model used for this
	// audience generation job.
	//
	// This member is required.
	ConfiguredAudienceModelArn *string

	// The time at which the audience generation job was created.
	//
	// This member is required.
	CreateTime *time.Time

	// The name of the audience generation job.
	//
	// This member is required.
	Name *string

	// The status of the audience generation job.
	//
	// This member is required.
	Status types.AudienceGenerationJobStatus

	// The most recent time at which the audience generation job was updated.
	//
	// This member is required.
	UpdateTime *time.Time

	// The identifier of the collaboration that this audience generation job is
	// associated with.
	CollaborationId *string

	// The description of the audience generation job.
	Description *string

	// Configure whether the seed users are included in the output audience. By
	// default, Clean Rooms ML removes seed users from the output audience. If you
	// specify TRUE , the seed users will appear first in the output. Clean Rooms ML
	// does not explicitly reveal whether a user was in the seed, but the recipient of
	// the audience will know that the first minimumSeedSize count of users are from
	// the seed.
	IncludeSeedInOutput *bool

	// The relevance scores for different audience sizes.
	Metrics *types.AudienceQualityMetrics

	// The seed audience that was used for this audience generation job. This field
	// will be null if the account calling the API is the account that started this
	// audience generation job.
	SeedAudience *types.AudienceGenerationJobDataSource

	// The AWS account that started this audience generation job.
	StartedBy *string

	// Details about the status of the audience generation job.
	StatusDetails *types.StatusDetails

	// The tags that are associated to this audience generation job.
	Tags map[string]string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetAudienceGenerationJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetAudienceGenerationJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetAudienceGenerationJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetAudienceGenerationJob"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetAudienceGenerationJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetAudienceGenerationJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetAudienceGenerationJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetAudienceGenerationJob",
	}
}
