// Code generated by smithy-go-codegen DO NOT EDIT.

package snowball

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/snowball/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"path"
)

type awsAwsjson11_serializeOpCancelCluster struct {
}

func (*awsAwsjson11_serializeOpCancelCluster) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCancelCluster) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelClusterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSIESnowballJobManagementService.CancelCluster")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCancelClusterInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCancelJob struct {
}

func (*awsAwsjson11_serializeOpCancelJob) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCancelJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CancelJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSIESnowballJobManagementService.CancelJob")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCancelJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateAddress struct {
}

func (*awsAwsjson11_serializeOpCreateAddress) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateAddress) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAddressInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSIESnowballJobManagementService.CreateAddress")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateAddressInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateCluster struct {
}

func (*awsAwsjson11_serializeOpCreateCluster) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateCluster) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateClusterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSIESnowballJobManagementService.CreateCluster")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateClusterInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateJob struct {
}

func (*awsAwsjson11_serializeOpCreateJob) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSIESnowballJobManagementService.CreateJob")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateLongTermPricing struct {
}

func (*awsAwsjson11_serializeOpCreateLongTermPricing) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateLongTermPricing) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateLongTermPricingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSIESnowballJobManagementService.CreateLongTermPricing")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateLongTermPricingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpCreateReturnShippingLabel struct {
}

func (*awsAwsjson11_serializeOpCreateReturnShippingLabel) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpCreateReturnShippingLabel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateReturnShippingLabelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSIESnowballJobManagementService.CreateReturnShippingLabel")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentCreateReturnShippingLabelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeAddress struct {
}

func (*awsAwsjson11_serializeOpDescribeAddress) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeAddress) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAddressInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSIESnowballJobManagementService.DescribeAddress")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeAddressInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeAddresses struct {
}

func (*awsAwsjson11_serializeOpDescribeAddresses) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeAddresses) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeAddressesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSIESnowballJobManagementService.DescribeAddresses")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeAddressesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeCluster struct {
}

func (*awsAwsjson11_serializeOpDescribeCluster) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeCluster) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeClusterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSIESnowballJobManagementService.DescribeCluster")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeClusterInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeJob struct {
}

func (*awsAwsjson11_serializeOpDescribeJob) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSIESnowballJobManagementService.DescribeJob")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpDescribeReturnShippingLabel struct {
}

func (*awsAwsjson11_serializeOpDescribeReturnShippingLabel) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpDescribeReturnShippingLabel) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeReturnShippingLabelInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSIESnowballJobManagementService.DescribeReturnShippingLabel")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentDescribeReturnShippingLabelInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetJobManifest struct {
}

func (*awsAwsjson11_serializeOpGetJobManifest) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetJobManifest) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetJobManifestInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSIESnowballJobManagementService.GetJobManifest")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetJobManifestInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetJobUnlockCode struct {
}

func (*awsAwsjson11_serializeOpGetJobUnlockCode) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetJobUnlockCode) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetJobUnlockCodeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSIESnowballJobManagementService.GetJobUnlockCode")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetJobUnlockCodeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetSnowballUsage struct {
}

func (*awsAwsjson11_serializeOpGetSnowballUsage) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetSnowballUsage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSnowballUsageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSIESnowballJobManagementService.GetSnowballUsage")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetSnowballUsageInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpGetSoftwareUpdates struct {
}

func (*awsAwsjson11_serializeOpGetSoftwareUpdates) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpGetSoftwareUpdates) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSoftwareUpdatesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSIESnowballJobManagementService.GetSoftwareUpdates")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentGetSoftwareUpdatesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListClusterJobs struct {
}

func (*awsAwsjson11_serializeOpListClusterJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListClusterJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListClusterJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSIESnowballJobManagementService.ListClusterJobs")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListClusterJobsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListClusters struct {
}

func (*awsAwsjson11_serializeOpListClusters) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListClusters) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListClustersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSIESnowballJobManagementService.ListClusters")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListClustersInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListCompatibleImages struct {
}

func (*awsAwsjson11_serializeOpListCompatibleImages) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListCompatibleImages) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListCompatibleImagesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSIESnowballJobManagementService.ListCompatibleImages")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListCompatibleImagesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListJobs struct {
}

func (*awsAwsjson11_serializeOpListJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSIESnowballJobManagementService.ListJobs")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListJobsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListLongTermPricing struct {
}

func (*awsAwsjson11_serializeOpListLongTermPricing) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListLongTermPricing) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListLongTermPricingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSIESnowballJobManagementService.ListLongTermPricing")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListLongTermPricingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpListServiceVersions struct {
}

func (*awsAwsjson11_serializeOpListServiceVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpListServiceVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListServiceVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSIESnowballJobManagementService.ListServiceVersions")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentListServiceVersionsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateCluster struct {
}

func (*awsAwsjson11_serializeOpUpdateCluster) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateCluster) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateClusterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSIESnowballJobManagementService.UpdateCluster")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateClusterInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateJob struct {
}

func (*awsAwsjson11_serializeOpUpdateJob) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSIESnowballJobManagementService.UpdateJob")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateJobInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateJobShipmentState struct {
}

func (*awsAwsjson11_serializeOpUpdateJobShipmentState) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateJobShipmentState) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateJobShipmentStateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSIESnowballJobManagementService.UpdateJobShipmentState")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateJobShipmentStateInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson11_serializeOpUpdateLongTermPricing struct {
}

func (*awsAwsjson11_serializeOpUpdateLongTermPricing) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson11_serializeOpUpdateLongTermPricing) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateLongTermPricingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.1")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("AWSIESnowballJobManagementService.UpdateLongTermPricing")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson11_serializeOpDocumentUpdateLongTermPricingInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsAwsjson11_serializeDocumentAddress(v *types.Address, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AddressId != nil {
		ok := object.Key("AddressId")
		ok.String(*v.AddressId)
	}

	if v.City != nil {
		ok := object.Key("City")
		ok.String(*v.City)
	}

	if v.Company != nil {
		ok := object.Key("Company")
		ok.String(*v.Company)
	}

	if v.Country != nil {
		ok := object.Key("Country")
		ok.String(*v.Country)
	}

	if v.IsRestricted {
		ok := object.Key("IsRestricted")
		ok.Boolean(v.IsRestricted)
	}

	if v.Landmark != nil {
		ok := object.Key("Landmark")
		ok.String(*v.Landmark)
	}

	if v.Name != nil {
		ok := object.Key("Name")
		ok.String(*v.Name)
	}

	if v.PhoneNumber != nil {
		ok := object.Key("PhoneNumber")
		ok.String(*v.PhoneNumber)
	}

	if v.PostalCode != nil {
		ok := object.Key("PostalCode")
		ok.String(*v.PostalCode)
	}

	if v.PrefectureOrDistrict != nil {
		ok := object.Key("PrefectureOrDistrict")
		ok.String(*v.PrefectureOrDistrict)
	}

	if v.StateOrProvince != nil {
		ok := object.Key("StateOrProvince")
		ok.String(*v.StateOrProvince)
	}

	if v.Street1 != nil {
		ok := object.Key("Street1")
		ok.String(*v.Street1)
	}

	if v.Street2 != nil {
		ok := object.Key("Street2")
		ok.String(*v.Street2)
	}

	if v.Street3 != nil {
		ok := object.Key("Street3")
		ok.String(*v.Street3)
	}

	return nil
}

func awsAwsjson11_serializeDocumentDependentService(v *types.DependentService, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ServiceName) > 0 {
		ok := object.Key("ServiceName")
		ok.String(string(v.ServiceName))
	}

	if v.ServiceVersion != nil {
		ok := object.Key("ServiceVersion")
		if err := awsAwsjson11_serializeDocumentServiceVersion(v.ServiceVersion, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentDependentServiceList(v []types.DependentService, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentDependentService(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentDeviceConfiguration(v *types.DeviceConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SnowconeDeviceConfiguration != nil {
		ok := object.Key("SnowconeDeviceConfiguration")
		if err := awsAwsjson11_serializeDocumentSnowconeDeviceConfiguration(v.SnowconeDeviceConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentEc2AmiResource(v *types.Ec2AmiResource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AmiId != nil {
		ok := object.Key("AmiId")
		ok.String(*v.AmiId)
	}

	if v.SnowballAmiId != nil {
		ok := object.Key("SnowballAmiId")
		ok.String(*v.SnowballAmiId)
	}

	return nil
}

func awsAwsjson11_serializeDocumentEc2AmiResourceList(v []types.Ec2AmiResource, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentEc2AmiResource(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentEKSOnDeviceServiceConfiguration(v *types.EKSOnDeviceServiceConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EKSAnywhereVersion != nil {
		ok := object.Key("EKSAnywhereVersion")
		ok.String(*v.EKSAnywhereVersion)
	}

	if v.KubernetesVersion != nil {
		ok := object.Key("KubernetesVersion")
		ok.String(*v.KubernetesVersion)
	}

	return nil
}

func awsAwsjson11_serializeDocumentEventTriggerDefinition(v *types.EventTriggerDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EventResourceARN != nil {
		ok := object.Key("EventResourceARN")
		ok.String(*v.EventResourceARN)
	}

	return nil
}

func awsAwsjson11_serializeDocumentEventTriggerDefinitionList(v []types.EventTriggerDefinition, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentEventTriggerDefinition(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentINDTaxDocuments(v *types.INDTaxDocuments, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.GSTIN != nil {
		ok := object.Key("GSTIN")
		ok.String(*v.GSTIN)
	}

	return nil
}

func awsAwsjson11_serializeDocumentJobResource(v *types.JobResource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Ec2AmiResources != nil {
		ok := object.Key("Ec2AmiResources")
		if err := awsAwsjson11_serializeDocumentEc2AmiResourceList(v.Ec2AmiResources, ok); err != nil {
			return err
		}
	}

	if v.LambdaResources != nil {
		ok := object.Key("LambdaResources")
		if err := awsAwsjson11_serializeDocumentLambdaResourceList(v.LambdaResources, ok); err != nil {
			return err
		}
	}

	if v.S3Resources != nil {
		ok := object.Key("S3Resources")
		if err := awsAwsjson11_serializeDocumentS3ResourceList(v.S3Resources, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentJobStateList(v []types.JobState, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson11_serializeDocumentKeyRange(v *types.KeyRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BeginMarker != nil {
		ok := object.Key("BeginMarker")
		ok.String(*v.BeginMarker)
	}

	if v.EndMarker != nil {
		ok := object.Key("EndMarker")
		ok.String(*v.EndMarker)
	}

	return nil
}

func awsAwsjson11_serializeDocumentLambdaResource(v *types.LambdaResource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EventTriggers != nil {
		ok := object.Key("EventTriggers")
		if err := awsAwsjson11_serializeDocumentEventTriggerDefinitionList(v.EventTriggers, ok); err != nil {
			return err
		}
	}

	if v.LambdaArn != nil {
		ok := object.Key("LambdaArn")
		ok.String(*v.LambdaArn)
	}

	return nil
}

func awsAwsjson11_serializeDocumentLambdaResourceList(v []types.LambdaResource, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentLambdaResource(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentNFSOnDeviceServiceConfiguration(v *types.NFSOnDeviceServiceConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StorageLimit != 0 {
		ok := object.Key("StorageLimit")
		ok.Integer(v.StorageLimit)
	}

	if len(v.StorageUnit) > 0 {
		ok := object.Key("StorageUnit")
		ok.String(string(v.StorageUnit))
	}

	return nil
}

func awsAwsjson11_serializeDocumentNotification(v *types.Notification, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobStatesToNotify != nil {
		ok := object.Key("JobStatesToNotify")
		if err := awsAwsjson11_serializeDocumentJobStateList(v.JobStatesToNotify, ok); err != nil {
			return err
		}
	}

	if v.NotifyAll {
		ok := object.Key("NotifyAll")
		ok.Boolean(v.NotifyAll)
	}

	if v.SnsTopicARN != nil {
		ok := object.Key("SnsTopicARN")
		ok.String(*v.SnsTopicARN)
	}

	return nil
}

func awsAwsjson11_serializeDocumentOnDeviceServiceConfiguration(v *types.OnDeviceServiceConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EKSOnDeviceService != nil {
		ok := object.Key("EKSOnDeviceService")
		if err := awsAwsjson11_serializeDocumentEKSOnDeviceServiceConfiguration(v.EKSOnDeviceService, ok); err != nil {
			return err
		}
	}

	if v.NFSOnDeviceService != nil {
		ok := object.Key("NFSOnDeviceService")
		if err := awsAwsjson11_serializeDocumentNFSOnDeviceServiceConfiguration(v.NFSOnDeviceService, ok); err != nil {
			return err
		}
	}

	if v.TGWOnDeviceService != nil {
		ok := object.Key("TGWOnDeviceService")
		if err := awsAwsjson11_serializeDocumentTGWOnDeviceServiceConfiguration(v.TGWOnDeviceService, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3Resource(v *types.S3Resource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketArn != nil {
		ok := object.Key("BucketArn")
		ok.String(*v.BucketArn)
	}

	if v.KeyRange != nil {
		ok := object.Key("KeyRange")
		if err := awsAwsjson11_serializeDocumentKeyRange(v.KeyRange, ok); err != nil {
			return err
		}
	}

	if v.TargetOnDeviceServices != nil {
		ok := object.Key("TargetOnDeviceServices")
		if err := awsAwsjson11_serializeDocumentTargetOnDeviceServiceList(v.TargetOnDeviceServices, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentS3ResourceList(v []types.S3Resource, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentS3Resource(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentServiceVersion(v *types.ServiceVersion, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Version != nil {
		ok := object.Key("Version")
		ok.String(*v.Version)
	}

	return nil
}

func awsAwsjson11_serializeDocumentSnowconeDeviceConfiguration(v *types.SnowconeDeviceConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.WirelessConnection != nil {
		ok := object.Key("WirelessConnection")
		if err := awsAwsjson11_serializeDocumentWirelessConnection(v.WirelessConnection, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentTargetOnDeviceService(v *types.TargetOnDeviceService, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ServiceName) > 0 {
		ok := object.Key("ServiceName")
		ok.String(string(v.ServiceName))
	}

	if len(v.TransferOption) > 0 {
		ok := object.Key("TransferOption")
		ok.String(string(v.TransferOption))
	}

	return nil
}

func awsAwsjson11_serializeDocumentTargetOnDeviceServiceList(v []types.TargetOnDeviceService, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson11_serializeDocumentTargetOnDeviceService(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson11_serializeDocumentTaxDocuments(v *types.TaxDocuments, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IND != nil {
		ok := object.Key("IND")
		if err := awsAwsjson11_serializeDocumentINDTaxDocuments(v.IND, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeDocumentTGWOnDeviceServiceConfiguration(v *types.TGWOnDeviceServiceConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.StorageLimit != 0 {
		ok := object.Key("StorageLimit")
		ok.Integer(v.StorageLimit)
	}

	if len(v.StorageUnit) > 0 {
		ok := object.Key("StorageUnit")
		ok.String(string(v.StorageUnit))
	}

	return nil
}

func awsAwsjson11_serializeDocumentWirelessConnection(v *types.WirelessConnection, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IsWifiEnabled {
		ok := object.Key("IsWifiEnabled")
		ok.Boolean(v.IsWifiEnabled)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCancelClusterInput(v *CancelClusterInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterId != nil {
		ok := object.Key("ClusterId")
		ok.String(*v.ClusterId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCancelJobInput(v *CancelJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobId != nil {
		ok := object.Key("JobId")
		ok.String(*v.JobId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateAddressInput(v *CreateAddressInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Address != nil {
		ok := object.Key("Address")
		if err := awsAwsjson11_serializeDocumentAddress(v.Address, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateClusterInput(v *CreateClusterInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AddressId != nil {
		ok := object.Key("AddressId")
		ok.String(*v.AddressId)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.ForwardingAddressId != nil {
		ok := object.Key("ForwardingAddressId")
		ok.String(*v.ForwardingAddressId)
	}

	if len(v.JobType) > 0 {
		ok := object.Key("JobType")
		ok.String(string(v.JobType))
	}

	if v.KmsKeyARN != nil {
		ok := object.Key("KmsKeyARN")
		ok.String(*v.KmsKeyARN)
	}

	if v.Notification != nil {
		ok := object.Key("Notification")
		if err := awsAwsjson11_serializeDocumentNotification(v.Notification, ok); err != nil {
			return err
		}
	}

	if v.OnDeviceServiceConfiguration != nil {
		ok := object.Key("OnDeviceServiceConfiguration")
		if err := awsAwsjson11_serializeDocumentOnDeviceServiceConfiguration(v.OnDeviceServiceConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.RemoteManagement) > 0 {
		ok := object.Key("RemoteManagement")
		ok.String(string(v.RemoteManagement))
	}

	if v.Resources != nil {
		ok := object.Key("Resources")
		if err := awsAwsjson11_serializeDocumentJobResource(v.Resources, ok); err != nil {
			return err
		}
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	if len(v.ShippingOption) > 0 {
		ok := object.Key("ShippingOption")
		ok.String(string(v.ShippingOption))
	}

	if len(v.SnowballType) > 0 {
		ok := object.Key("SnowballType")
		ok.String(string(v.SnowballType))
	}

	if v.TaxDocuments != nil {
		ok := object.Key("TaxDocuments")
		if err := awsAwsjson11_serializeDocumentTaxDocuments(v.TaxDocuments, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateJobInput(v *CreateJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AddressId != nil {
		ok := object.Key("AddressId")
		ok.String(*v.AddressId)
	}

	if v.ClusterId != nil {
		ok := object.Key("ClusterId")
		ok.String(*v.ClusterId)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.DeviceConfiguration != nil {
		ok := object.Key("DeviceConfiguration")
		if err := awsAwsjson11_serializeDocumentDeviceConfiguration(v.DeviceConfiguration, ok); err != nil {
			return err
		}
	}

	if v.ForwardingAddressId != nil {
		ok := object.Key("ForwardingAddressId")
		ok.String(*v.ForwardingAddressId)
	}

	if len(v.JobType) > 0 {
		ok := object.Key("JobType")
		ok.String(string(v.JobType))
	}

	if v.KmsKeyARN != nil {
		ok := object.Key("KmsKeyARN")
		ok.String(*v.KmsKeyARN)
	}

	if v.LongTermPricingId != nil {
		ok := object.Key("LongTermPricingId")
		ok.String(*v.LongTermPricingId)
	}

	if v.Notification != nil {
		ok := object.Key("Notification")
		if err := awsAwsjson11_serializeDocumentNotification(v.Notification, ok); err != nil {
			return err
		}
	}

	if v.OnDeviceServiceConfiguration != nil {
		ok := object.Key("OnDeviceServiceConfiguration")
		if err := awsAwsjson11_serializeDocumentOnDeviceServiceConfiguration(v.OnDeviceServiceConfiguration, ok); err != nil {
			return err
		}
	}

	if len(v.RemoteManagement) > 0 {
		ok := object.Key("RemoteManagement")
		ok.String(string(v.RemoteManagement))
	}

	if v.Resources != nil {
		ok := object.Key("Resources")
		if err := awsAwsjson11_serializeDocumentJobResource(v.Resources, ok); err != nil {
			return err
		}
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	if len(v.ShippingOption) > 0 {
		ok := object.Key("ShippingOption")
		ok.String(string(v.ShippingOption))
	}

	if len(v.SnowballCapacityPreference) > 0 {
		ok := object.Key("SnowballCapacityPreference")
		ok.String(string(v.SnowballCapacityPreference))
	}

	if len(v.SnowballType) > 0 {
		ok := object.Key("SnowballType")
		ok.String(string(v.SnowballType))
	}

	if v.TaxDocuments != nil {
		ok := object.Key("TaxDocuments")
		if err := awsAwsjson11_serializeDocumentTaxDocuments(v.TaxDocuments, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateLongTermPricingInput(v *CreateLongTermPricingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IsLongTermPricingAutoRenew != nil {
		ok := object.Key("IsLongTermPricingAutoRenew")
		ok.Boolean(*v.IsLongTermPricingAutoRenew)
	}

	if len(v.LongTermPricingType) > 0 {
		ok := object.Key("LongTermPricingType")
		ok.String(string(v.LongTermPricingType))
	}

	if len(v.SnowballType) > 0 {
		ok := object.Key("SnowballType")
		ok.String(string(v.SnowballType))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentCreateReturnShippingLabelInput(v *CreateReturnShippingLabelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobId != nil {
		ok := object.Key("JobId")
		ok.String(*v.JobId)
	}

	if len(v.ShippingOption) > 0 {
		ok := object.Key("ShippingOption")
		ok.String(string(v.ShippingOption))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeAddressesInput(v *DescribeAddressesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeAddressInput(v *DescribeAddressInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AddressId != nil {
		ok := object.Key("AddressId")
		ok.String(*v.AddressId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeClusterInput(v *DescribeClusterInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterId != nil {
		ok := object.Key("ClusterId")
		ok.String(*v.ClusterId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeJobInput(v *DescribeJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobId != nil {
		ok := object.Key("JobId")
		ok.String(*v.JobId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentDescribeReturnShippingLabelInput(v *DescribeReturnShippingLabelInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobId != nil {
		ok := object.Key("JobId")
		ok.String(*v.JobId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetJobManifestInput(v *GetJobManifestInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobId != nil {
		ok := object.Key("JobId")
		ok.String(*v.JobId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetJobUnlockCodeInput(v *GetJobUnlockCodeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobId != nil {
		ok := object.Key("JobId")
		ok.String(*v.JobId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentGetSnowballUsageInput(v *GetSnowballUsageInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	return nil
}

func awsAwsjson11_serializeOpDocumentGetSoftwareUpdatesInput(v *GetSoftwareUpdatesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobId != nil {
		ok := object.Key("JobId")
		ok.String(*v.JobId)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListClusterJobsInput(v *ListClusterJobsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterId != nil {
		ok := object.Key("ClusterId")
		ok.String(*v.ClusterId)
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListClustersInput(v *ListClustersInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListCompatibleImagesInput(v *ListCompatibleImagesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListJobsInput(v *ListJobsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListLongTermPricingInput(v *ListLongTermPricingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentListServiceVersionsInput(v *ListServiceVersionsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DependentServices != nil {
		ok := object.Key("DependentServices")
		if err := awsAwsjson11_serializeDocumentDependentServiceList(v.DependentServices, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if len(v.ServiceName) > 0 {
		ok := object.Key("ServiceName")
		ok.String(string(v.ServiceName))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateClusterInput(v *UpdateClusterInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AddressId != nil {
		ok := object.Key("AddressId")
		ok.String(*v.AddressId)
	}

	if v.ClusterId != nil {
		ok := object.Key("ClusterId")
		ok.String(*v.ClusterId)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.ForwardingAddressId != nil {
		ok := object.Key("ForwardingAddressId")
		ok.String(*v.ForwardingAddressId)
	}

	if v.Notification != nil {
		ok := object.Key("Notification")
		if err := awsAwsjson11_serializeDocumentNotification(v.Notification, ok); err != nil {
			return err
		}
	}

	if v.OnDeviceServiceConfiguration != nil {
		ok := object.Key("OnDeviceServiceConfiguration")
		if err := awsAwsjson11_serializeDocumentOnDeviceServiceConfiguration(v.OnDeviceServiceConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Resources != nil {
		ok := object.Key("Resources")
		if err := awsAwsjson11_serializeDocumentJobResource(v.Resources, ok); err != nil {
			return err
		}
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	if len(v.ShippingOption) > 0 {
		ok := object.Key("ShippingOption")
		ok.String(string(v.ShippingOption))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateJobInput(v *UpdateJobInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AddressId != nil {
		ok := object.Key("AddressId")
		ok.String(*v.AddressId)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.ForwardingAddressId != nil {
		ok := object.Key("ForwardingAddressId")
		ok.String(*v.ForwardingAddressId)
	}

	if v.JobId != nil {
		ok := object.Key("JobId")
		ok.String(*v.JobId)
	}

	if v.Notification != nil {
		ok := object.Key("Notification")
		if err := awsAwsjson11_serializeDocumentNotification(v.Notification, ok); err != nil {
			return err
		}
	}

	if v.OnDeviceServiceConfiguration != nil {
		ok := object.Key("OnDeviceServiceConfiguration")
		if err := awsAwsjson11_serializeDocumentOnDeviceServiceConfiguration(v.OnDeviceServiceConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Resources != nil {
		ok := object.Key("Resources")
		if err := awsAwsjson11_serializeDocumentJobResource(v.Resources, ok); err != nil {
			return err
		}
	}

	if v.RoleARN != nil {
		ok := object.Key("RoleARN")
		ok.String(*v.RoleARN)
	}

	if len(v.ShippingOption) > 0 {
		ok := object.Key("ShippingOption")
		ok.String(string(v.ShippingOption))
	}

	if len(v.SnowballCapacityPreference) > 0 {
		ok := object.Key("SnowballCapacityPreference")
		ok.String(string(v.SnowballCapacityPreference))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateJobShipmentStateInput(v *UpdateJobShipmentStateInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JobId != nil {
		ok := object.Key("JobId")
		ok.String(*v.JobId)
	}

	if len(v.ShipmentState) > 0 {
		ok := object.Key("ShipmentState")
		ok.String(string(v.ShipmentState))
	}

	return nil
}

func awsAwsjson11_serializeOpDocumentUpdateLongTermPricingInput(v *UpdateLongTermPricingInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IsLongTermPricingAutoRenew != nil {
		ok := object.Key("IsLongTermPricingAutoRenew")
		ok.Boolean(*v.IsLongTermPricingAutoRenew)
	}

	if v.LongTermPricingId != nil {
		ok := object.Key("LongTermPricingId")
		ok.String(*v.LongTermPricingId)
	}

	if v.ReplacementJob != nil {
		ok := object.Key("ReplacementJob")
		ok.String(*v.ReplacementJob)
	}

	return nil
}
