// Code generated by smithy-go-codegen DO NOT EDIT.

package scheduler

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/scheduler/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves the specified schedule.
func (c *Client) GetSchedule(ctx context.Context, params *GetScheduleInput, optFns ...func(*Options)) (*GetScheduleOutput, error) {
	if params == nil {
		params = &GetScheduleInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetSchedule", params, optFns, c.addOperationGetScheduleMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetScheduleOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetScheduleInput struct {

	// The name of the schedule to retrieve.
	//
	// This member is required.
	Name *string

	// The name of the schedule group associated with this schedule. If you omit this,
	// EventBridge Scheduler assumes that the schedule is associated with the default
	// group.
	GroupName *string

	noSmithyDocumentSerde
}

type GetScheduleOutput struct {

	// The Amazon Resource Name (ARN) of the schedule.
	Arn *string

	// The time at which the schedule was created.
	CreationDate *time.Time

	// The description of the schedule.
	Description *string

	// The date, in UTC, before which the schedule can invoke its target. Depending on
	// the schedule's recurrence expression, invocations might stop on, or before, the
	// EndDate you specify. EventBridge Scheduler ignores EndDate for one-time
	// schedules.
	EndDate *time.Time

	// Allows you to configure a time window during which EventBridge Scheduler invokes
	// the schedule.
	FlexibleTimeWindow *types.FlexibleTimeWindow

	// The name of the schedule group associated with this schedule.
	GroupName *string

	// The ARN for a customer managed KMS Key that is be used to encrypt and decrypt
	// your data.
	KmsKeyArn *string

	// The time at which the schedule was last modified.
	LastModificationDate *time.Time

	// The name of the schedule.
	Name *string

	// The expression that defines when the schedule runs. The following formats are
	// supported.
	//
	// * at expression - at(yyyy-mm-ddThh:mm:ss)
	//
	// * rate expression -
	// rate(unit value)
	//
	// * cron expression - cron(fields)
	//
	// You can use at expressions
	// to create one-time schedules that invoke a target once, at the time and in the
	// time zone, that you specify. You can use rate and cron expressions to create
	// recurring schedules. Rate-based schedules are useful when you want to invoke a
	// target at regular intervals, such as every 15 minutes or every five days.
	// Cron-based schedules are useful when you want to invoke a target periodically at
	// a specific time, such as at 8:00 am (UTC+0) every 1st day of the month. A cron
	// expression consists of six fields separated by white spaces: (minutes hours
	// day_of_month month day_of_week year). A rate expression consists of a value as a
	// positive integer, and a unit with the following options: minute | minutes | hour
	// | hours | day | days For more information and examples, see Schedule types on
	// EventBridge Scheduler
	// (https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html) in
	// the EventBridge Scheduler User Guide.
	ScheduleExpression *string

	// The timezone in which the scheduling expression is evaluated.
	ScheduleExpressionTimezone *string

	// The date, in UTC, after which the schedule can begin invoking its target.
	// Depending on the schedule's recurrence expression, invocations might occur on,
	// or after, the StartDate you specify. EventBridge Scheduler ignores StartDate for
	// one-time schedules.
	StartDate *time.Time

	// Specifies whether the schedule is enabled or disabled.
	State types.ScheduleState

	// The schedule target.
	Target *types.Target

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetScheduleMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetSchedule{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetSchedule{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetScheduleValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetSchedule(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetSchedule(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "scheduler",
		OperationName: "GetSchedule",
	}
}
