// Code generated by smithy-go-codegen DO NOT EDIT.

package s3control

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/s3control/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyxml "github.com/aws/smithy-go/encoding/xml"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsRestxml_serializeOpCreateAccessPoint struct {
}

func (*awsRestxml_serializeOpCreateAccessPoint) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpCreateAccessPoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAccessPointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/accesspoint/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsCreateAccessPointInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "CreateAccessPointRequest",
		},
		Attr: rootAttr,
	}
	root.Attr = append(root.Attr, smithyxml.NewNamespaceAttribute("", "http://awss3control.amazonaws.com/doc/2018-08-20/"))
	if err := awsRestxml_serializeOpDocumentCreateAccessPointInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsCreateAccessPointInput(v *CreateAccessPointInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

func awsRestxml_serializeOpDocumentCreateAccessPointInput(v *CreateAccessPointInput, value smithyxml.Value) error {
	defer value.Close()
	if v.Bucket != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Bucket",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Bucket)
	}
	if v.BucketAccountId != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "BucketAccountId",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.BucketAccountId)
	}
	if v.PublicAccessBlockConfiguration != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "PublicAccessBlockConfiguration",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentPublicAccessBlockConfiguration(v.PublicAccessBlockConfiguration, el); err != nil {
			return err
		}
	}
	if v.VpcConfiguration != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "VpcConfiguration",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentVpcConfiguration(v.VpcConfiguration, el); err != nil {
			return err
		}
	}
	return nil
}

type awsRestxml_serializeOpCreateAccessPointForObjectLambda struct {
}

func (*awsRestxml_serializeOpCreateAccessPointForObjectLambda) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpCreateAccessPointForObjectLambda) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateAccessPointForObjectLambdaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/accesspointforobjectlambda/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsCreateAccessPointForObjectLambdaInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "CreateAccessPointForObjectLambdaRequest",
		},
		Attr: rootAttr,
	}
	root.Attr = append(root.Attr, smithyxml.NewNamespaceAttribute("", "http://awss3control.amazonaws.com/doc/2018-08-20/"))
	if err := awsRestxml_serializeOpDocumentCreateAccessPointForObjectLambdaInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsCreateAccessPointForObjectLambdaInput(v *CreateAccessPointForObjectLambdaInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

func awsRestxml_serializeOpDocumentCreateAccessPointForObjectLambdaInput(v *CreateAccessPointForObjectLambdaInput, value smithyxml.Value) error {
	defer value.Close()
	if v.Configuration != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Configuration",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentObjectLambdaConfiguration(v.Configuration, el); err != nil {
			return err
		}
	}
	return nil
}

type awsRestxml_serializeOpCreateBucket struct {
}

func (*awsRestxml_serializeOpCreateBucket) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpCreateBucket) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateBucketInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/bucket/{Bucket}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsCreateBucketInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.CreateBucketConfiguration != nil {
		if !restEncoder.HasHeader("Content-Type") {
			ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CreateBucketConfiguration",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://awss3control.amazonaws.com/doc/2018-08-20/"))
		if err := awsRestxml_serializeDocumentCreateBucketConfiguration(input.CreateBucketConfiguration, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsCreateBucketInput(v *CreateBucketInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.ACL) > 0 {
		locationName := "X-Amz-Acl"
		encoder.SetHeader(locationName).String(string(v.ACL))
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.GrantFullControl != nil && len(*v.GrantFullControl) > 0 {
		locationName := "X-Amz-Grant-Full-Control"
		encoder.SetHeader(locationName).String(*v.GrantFullControl)
	}

	if v.GrantRead != nil && len(*v.GrantRead) > 0 {
		locationName := "X-Amz-Grant-Read"
		encoder.SetHeader(locationName).String(*v.GrantRead)
	}

	if v.GrantReadACP != nil && len(*v.GrantReadACP) > 0 {
		locationName := "X-Amz-Grant-Read-Acp"
		encoder.SetHeader(locationName).String(*v.GrantReadACP)
	}

	if v.GrantWrite != nil && len(*v.GrantWrite) > 0 {
		locationName := "X-Amz-Grant-Write"
		encoder.SetHeader(locationName).String(*v.GrantWrite)
	}

	if v.GrantWriteACP != nil && len(*v.GrantWriteACP) > 0 {
		locationName := "X-Amz-Grant-Write-Acp"
		encoder.SetHeader(locationName).String(*v.GrantWriteACP)
	}

	if v.ObjectLockEnabledForBucket {
		locationName := "X-Amz-Bucket-Object-Lock-Enabled"
		encoder.SetHeader(locationName).Boolean(v.ObjectLockEnabledForBucket)
	}

	if v.OutpostId != nil && len(*v.OutpostId) > 0 {
		locationName := "X-Amz-Outpost-Id"
		encoder.SetHeader(locationName).String(*v.OutpostId)
	}

	return nil
}

type awsRestxml_serializeOpCreateJob struct {
}

func (*awsRestxml_serializeOpCreateJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpCreateJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsCreateJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "CreateJobRequest",
		},
		Attr: rootAttr,
	}
	root.Attr = append(root.Attr, smithyxml.NewNamespaceAttribute("", "http://awss3control.amazonaws.com/doc/2018-08-20/"))
	if err := awsRestxml_serializeOpDocumentCreateJobInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsCreateJobInput(v *CreateJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	return nil
}

func awsRestxml_serializeOpDocumentCreateJobInput(v *CreateJobInput, value smithyxml.Value) error {
	defer value.Close()
	if v.ClientRequestToken != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ClientRequestToken",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ClientRequestToken)
	}
	if v.ConfirmationRequired != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ConfirmationRequired",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.ConfirmationRequired)
	}
	if v.Description != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Description",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Description)
	}
	if v.Manifest != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Manifest",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentJobManifest(v.Manifest, el); err != nil {
			return err
		}
	}
	if v.ManifestGenerator != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ManifestGenerator",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentJobManifestGenerator(v.ManifestGenerator, el); err != nil {
			return err
		}
	}
	if v.Operation != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Operation",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentJobOperation(v.Operation, el); err != nil {
			return err
		}
	}
	if v.Priority != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Priority",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.Priority)
	}
	if v.Report != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Report",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentJobReport(v.Report, el); err != nil {
			return err
		}
	}
	if v.RoleArn != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "RoleArn",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.RoleArn)
	}
	if v.Tags != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Tags",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentS3TagSet(v.Tags, el); err != nil {
			return err
		}
	}
	return nil
}

type awsRestxml_serializeOpCreateMultiRegionAccessPoint struct {
}

func (*awsRestxml_serializeOpCreateMultiRegionAccessPoint) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpCreateMultiRegionAccessPoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateMultiRegionAccessPointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/async-requests/mrap/create")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsCreateMultiRegionAccessPointInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "CreateMultiRegionAccessPointRequest",
		},
		Attr: rootAttr,
	}
	root.Attr = append(root.Attr, smithyxml.NewNamespaceAttribute("", "http://awss3control.amazonaws.com/doc/2018-08-20/"))
	if err := awsRestxml_serializeOpDocumentCreateMultiRegionAccessPointInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsCreateMultiRegionAccessPointInput(v *CreateMultiRegionAccessPointInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	return nil
}

func awsRestxml_serializeOpDocumentCreateMultiRegionAccessPointInput(v *CreateMultiRegionAccessPointInput, value smithyxml.Value) error {
	defer value.Close()
	if v.ClientToken != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ClientToken",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ClientToken)
	}
	if v.Details != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Details",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentCreateMultiRegionAccessPointInput(v.Details, el); err != nil {
			return err
		}
	}
	return nil
}

type awsRestxml_serializeOpDeleteAccessPoint struct {
}

func (*awsRestxml_serializeOpDeleteAccessPoint) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteAccessPoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAccessPointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/accesspoint/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteAccessPointInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteAccessPointInput(v *DeleteAccessPointInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpDeleteAccessPointForObjectLambda struct {
}

func (*awsRestxml_serializeOpDeleteAccessPointForObjectLambda) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteAccessPointForObjectLambda) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAccessPointForObjectLambdaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/accesspointforobjectlambda/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteAccessPointForObjectLambdaInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteAccessPointForObjectLambdaInput(v *DeleteAccessPointForObjectLambdaInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpDeleteAccessPointPolicy struct {
}

func (*awsRestxml_serializeOpDeleteAccessPointPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteAccessPointPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAccessPointPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/accesspoint/{Name}/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteAccessPointPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteAccessPointPolicyInput(v *DeleteAccessPointPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpDeleteAccessPointPolicyForObjectLambda struct {
}

func (*awsRestxml_serializeOpDeleteAccessPointPolicyForObjectLambda) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteAccessPointPolicyForObjectLambda) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteAccessPointPolicyForObjectLambdaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/accesspointforobjectlambda/{Name}/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteAccessPointPolicyForObjectLambdaInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteAccessPointPolicyForObjectLambdaInput(v *DeleteAccessPointPolicyForObjectLambdaInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpDeleteBucket struct {
}

func (*awsRestxml_serializeOpDeleteBucket) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteBucket) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBucketInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/bucket/{Bucket}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteBucketInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteBucketInput(v *DeleteBucketInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpDeleteBucketLifecycleConfiguration struct {
}

func (*awsRestxml_serializeOpDeleteBucketLifecycleConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteBucketLifecycleConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBucketLifecycleConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/bucket/{Bucket}/lifecycleconfiguration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteBucketLifecycleConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteBucketLifecycleConfigurationInput(v *DeleteBucketLifecycleConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpDeleteBucketPolicy struct {
}

func (*awsRestxml_serializeOpDeleteBucketPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteBucketPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBucketPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/bucket/{Bucket}/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteBucketPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteBucketPolicyInput(v *DeleteBucketPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpDeleteBucketTagging struct {
}

func (*awsRestxml_serializeOpDeleteBucketTagging) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteBucketTagging) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteBucketTaggingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/bucket/{Bucket}/tagging")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteBucketTaggingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteBucketTaggingInput(v *DeleteBucketTaggingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpDeleteJobTagging struct {
}

func (*awsRestxml_serializeOpDeleteJobTagging) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteJobTagging) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteJobTaggingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/jobs/{JobId}/tagging")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteJobTaggingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteJobTaggingInput(v *DeleteJobTaggingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member JobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("JobId").String(*v.JobId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpDeleteMultiRegionAccessPoint struct {
}

func (*awsRestxml_serializeOpDeleteMultiRegionAccessPoint) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteMultiRegionAccessPoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteMultiRegionAccessPointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/async-requests/mrap/delete")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteMultiRegionAccessPointInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "DeleteMultiRegionAccessPointRequest",
		},
		Attr: rootAttr,
	}
	root.Attr = append(root.Attr, smithyxml.NewNamespaceAttribute("", "http://awss3control.amazonaws.com/doc/2018-08-20/"))
	if err := awsRestxml_serializeOpDocumentDeleteMultiRegionAccessPointInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteMultiRegionAccessPointInput(v *DeleteMultiRegionAccessPointInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	return nil
}

func awsRestxml_serializeOpDocumentDeleteMultiRegionAccessPointInput(v *DeleteMultiRegionAccessPointInput, value smithyxml.Value) error {
	defer value.Close()
	if v.ClientToken != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ClientToken",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ClientToken)
	}
	if v.Details != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Details",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentDeleteMultiRegionAccessPointInput(v.Details, el); err != nil {
			return err
		}
	}
	return nil
}

type awsRestxml_serializeOpDeletePublicAccessBlock struct {
}

func (*awsRestxml_serializeOpDeletePublicAccessBlock) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeletePublicAccessBlock) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeletePublicAccessBlockInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/configuration/publicAccessBlock")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeletePublicAccessBlockInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeletePublicAccessBlockInput(v *DeletePublicAccessBlockInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	return nil
}

type awsRestxml_serializeOpDeleteStorageLensConfiguration struct {
}

func (*awsRestxml_serializeOpDeleteStorageLensConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteStorageLensConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteStorageLensConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/storagelens/{ConfigId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteStorageLensConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteStorageLensConfigurationInput(v *DeleteStorageLensConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.ConfigId == nil || len(*v.ConfigId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ConfigId must not be empty")}
	}
	if v.ConfigId != nil {
		if err := encoder.SetURI("ConfigId").String(*v.ConfigId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpDeleteStorageLensConfigurationTagging struct {
}

func (*awsRestxml_serializeOpDeleteStorageLensConfigurationTagging) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDeleteStorageLensConfigurationTagging) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteStorageLensConfigurationTaggingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/storagelens/{ConfigId}/tagging")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDeleteStorageLensConfigurationTaggingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDeleteStorageLensConfigurationTaggingInput(v *DeleteStorageLensConfigurationTaggingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.ConfigId == nil || len(*v.ConfigId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ConfigId must not be empty")}
	}
	if v.ConfigId != nil {
		if err := encoder.SetURI("ConfigId").String(*v.ConfigId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpDescribeJob struct {
}

func (*awsRestxml_serializeOpDescribeJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDescribeJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/jobs/{JobId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDescribeJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDescribeJobInput(v *DescribeJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member JobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("JobId").String(*v.JobId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpDescribeMultiRegionAccessPointOperation struct {
}

func (*awsRestxml_serializeOpDescribeMultiRegionAccessPointOperation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpDescribeMultiRegionAccessPointOperation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeMultiRegionAccessPointOperationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/async-requests/mrap/{RequestTokenARN+}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsDescribeMultiRegionAccessPointOperationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsDescribeMultiRegionAccessPointOperationInput(v *DescribeMultiRegionAccessPointOperationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.RequestTokenARN == nil || len(*v.RequestTokenARN) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member RequestTokenARN must not be empty")}
	}
	if v.RequestTokenARN != nil {
		if err := encoder.SetURI("RequestTokenARN").String(*v.RequestTokenARN); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetAccessPoint struct {
}

func (*awsRestxml_serializeOpGetAccessPoint) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetAccessPoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAccessPointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/accesspoint/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetAccessPointInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetAccessPointInput(v *GetAccessPointInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetAccessPointConfigurationForObjectLambda struct {
}

func (*awsRestxml_serializeOpGetAccessPointConfigurationForObjectLambda) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetAccessPointConfigurationForObjectLambda) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAccessPointConfigurationForObjectLambdaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/accesspointforobjectlambda/{Name}/configuration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetAccessPointConfigurationForObjectLambdaInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetAccessPointConfigurationForObjectLambdaInput(v *GetAccessPointConfigurationForObjectLambdaInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetAccessPointForObjectLambda struct {
}

func (*awsRestxml_serializeOpGetAccessPointForObjectLambda) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetAccessPointForObjectLambda) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAccessPointForObjectLambdaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/accesspointforobjectlambda/{Name}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetAccessPointForObjectLambdaInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetAccessPointForObjectLambdaInput(v *GetAccessPointForObjectLambdaInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetAccessPointPolicy struct {
}

func (*awsRestxml_serializeOpGetAccessPointPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetAccessPointPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAccessPointPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/accesspoint/{Name}/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetAccessPointPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetAccessPointPolicyInput(v *GetAccessPointPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetAccessPointPolicyForObjectLambda struct {
}

func (*awsRestxml_serializeOpGetAccessPointPolicyForObjectLambda) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetAccessPointPolicyForObjectLambda) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAccessPointPolicyForObjectLambdaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/accesspointforobjectlambda/{Name}/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetAccessPointPolicyForObjectLambdaInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetAccessPointPolicyForObjectLambdaInput(v *GetAccessPointPolicyForObjectLambdaInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetAccessPointPolicyStatus struct {
}

func (*awsRestxml_serializeOpGetAccessPointPolicyStatus) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetAccessPointPolicyStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAccessPointPolicyStatusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/accesspoint/{Name}/policyStatus")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetAccessPointPolicyStatusInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetAccessPointPolicyStatusInput(v *GetAccessPointPolicyStatusInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetAccessPointPolicyStatusForObjectLambda struct {
}

func (*awsRestxml_serializeOpGetAccessPointPolicyStatusForObjectLambda) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetAccessPointPolicyStatusForObjectLambda) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAccessPointPolicyStatusForObjectLambdaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/accesspointforobjectlambda/{Name}/policyStatus")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetAccessPointPolicyStatusForObjectLambdaInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetAccessPointPolicyStatusForObjectLambdaInput(v *GetAccessPointPolicyStatusForObjectLambdaInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetBucket struct {
}

func (*awsRestxml_serializeOpGetBucket) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucket) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/bucket/{Bucket}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketInput(v *GetBucketInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetBucketLifecycleConfiguration struct {
}

func (*awsRestxml_serializeOpGetBucketLifecycleConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketLifecycleConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketLifecycleConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/bucket/{Bucket}/lifecycleconfiguration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketLifecycleConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketLifecycleConfigurationInput(v *GetBucketLifecycleConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetBucketPolicy struct {
}

func (*awsRestxml_serializeOpGetBucketPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/bucket/{Bucket}/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketPolicyInput(v *GetBucketPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetBucketTagging struct {
}

func (*awsRestxml_serializeOpGetBucketTagging) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketTagging) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketTaggingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/bucket/{Bucket}/tagging")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketTaggingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketTaggingInput(v *GetBucketTaggingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetBucketVersioning struct {
}

func (*awsRestxml_serializeOpGetBucketVersioning) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetBucketVersioning) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBucketVersioningInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/bucket/{Bucket}/versioning")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetBucketVersioningInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetBucketVersioningInput(v *GetBucketVersioningInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetJobTagging struct {
}

func (*awsRestxml_serializeOpGetJobTagging) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetJobTagging) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetJobTaggingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/jobs/{JobId}/tagging")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetJobTaggingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetJobTaggingInput(v *GetJobTaggingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member JobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("JobId").String(*v.JobId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetMultiRegionAccessPoint struct {
}

func (*awsRestxml_serializeOpGetMultiRegionAccessPoint) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetMultiRegionAccessPoint) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMultiRegionAccessPointInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/mrap/instances/{Name+}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetMultiRegionAccessPointInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetMultiRegionAccessPointInput(v *GetMultiRegionAccessPointInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetMultiRegionAccessPointPolicy struct {
}

func (*awsRestxml_serializeOpGetMultiRegionAccessPointPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetMultiRegionAccessPointPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMultiRegionAccessPointPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/mrap/instances/{Name+}/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetMultiRegionAccessPointPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetMultiRegionAccessPointPolicyInput(v *GetMultiRegionAccessPointPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetMultiRegionAccessPointPolicyStatus struct {
}

func (*awsRestxml_serializeOpGetMultiRegionAccessPointPolicyStatus) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetMultiRegionAccessPointPolicyStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMultiRegionAccessPointPolicyStatusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/mrap/instances/{Name+}/policystatus")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetMultiRegionAccessPointPolicyStatusInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetMultiRegionAccessPointPolicyStatusInput(v *GetMultiRegionAccessPointPolicyStatusInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetMultiRegionAccessPointRoutes struct {
}

func (*awsRestxml_serializeOpGetMultiRegionAccessPointRoutes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetMultiRegionAccessPointRoutes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMultiRegionAccessPointRoutesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/mrap/instances/{Mrap+}/routes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetMultiRegionAccessPointRoutesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetMultiRegionAccessPointRoutesInput(v *GetMultiRegionAccessPointRoutesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Mrap == nil || len(*v.Mrap) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Mrap must not be empty")}
	}
	if v.Mrap != nil {
		if err := encoder.SetURI("Mrap").String(*v.Mrap); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetPublicAccessBlock struct {
}

func (*awsRestxml_serializeOpGetPublicAccessBlock) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetPublicAccessBlock) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPublicAccessBlockInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/configuration/publicAccessBlock")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetPublicAccessBlockInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetPublicAccessBlockInput(v *GetPublicAccessBlockInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	return nil
}

type awsRestxml_serializeOpGetStorageLensConfiguration struct {
}

func (*awsRestxml_serializeOpGetStorageLensConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetStorageLensConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetStorageLensConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/storagelens/{ConfigId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetStorageLensConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetStorageLensConfigurationInput(v *GetStorageLensConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.ConfigId == nil || len(*v.ConfigId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ConfigId must not be empty")}
	}
	if v.ConfigId != nil {
		if err := encoder.SetURI("ConfigId").String(*v.ConfigId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpGetStorageLensConfigurationTagging struct {
}

func (*awsRestxml_serializeOpGetStorageLensConfigurationTagging) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpGetStorageLensConfigurationTagging) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetStorageLensConfigurationTaggingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/storagelens/{ConfigId}/tagging")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsGetStorageLensConfigurationTaggingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsGetStorageLensConfigurationTaggingInput(v *GetStorageLensConfigurationTaggingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.ConfigId == nil || len(*v.ConfigId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ConfigId must not be empty")}
	}
	if v.ConfigId != nil {
		if err := encoder.SetURI("ConfigId").String(*v.ConfigId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpListAccessPoints struct {
}

func (*awsRestxml_serializeOpListAccessPoints) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListAccessPoints) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAccessPointsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/accesspoint")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListAccessPointsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListAccessPointsInput(v *ListAccessPointsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Bucket != nil {
		encoder.SetQuery("bucket").String(*v.Bucket)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestxml_serializeOpListAccessPointsForObjectLambda struct {
}

func (*awsRestxml_serializeOpListAccessPointsForObjectLambda) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListAccessPointsForObjectLambda) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAccessPointsForObjectLambdaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/accesspointforobjectlambda")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListAccessPointsForObjectLambdaInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListAccessPointsForObjectLambdaInput(v *ListAccessPointsForObjectLambdaInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestxml_serializeOpListJobs struct {
}

func (*awsRestxml_serializeOpListJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListJobsInput(v *ListJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.JobStatuses != nil {
		for i := range v.JobStatuses {
			encoder.AddQuery("jobStatuses").String(string(v.JobStatuses[i]))
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("maxResults").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestxml_serializeOpListMultiRegionAccessPoints struct {
}

func (*awsRestxml_serializeOpListMultiRegionAccessPoints) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListMultiRegionAccessPoints) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListMultiRegionAccessPointsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/mrap/instances")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListMultiRegionAccessPointsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListMultiRegionAccessPointsInput(v *ListMultiRegionAccessPointsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestxml_serializeOpListRegionalBuckets struct {
}

func (*awsRestxml_serializeOpListRegionalBuckets) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListRegionalBuckets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListRegionalBucketsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/bucket")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListRegionalBucketsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListRegionalBucketsInput(v *ListRegionalBucketsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	if v.OutpostId != nil && len(*v.OutpostId) > 0 {
		locationName := "X-Amz-Outpost-Id"
		encoder.SetHeader(locationName).String(*v.OutpostId)
	}

	return nil
}

type awsRestxml_serializeOpListStorageLensConfigurations struct {
}

func (*awsRestxml_serializeOpListStorageLensConfigurations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpListStorageLensConfigurations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListStorageLensConfigurationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/storagelens")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsListStorageLensConfigurationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsListStorageLensConfigurationsInput(v *ListStorageLensConfigurationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestxml_serializeOpPutAccessPointConfigurationForObjectLambda struct {
}

func (*awsRestxml_serializeOpPutAccessPointConfigurationForObjectLambda) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutAccessPointConfigurationForObjectLambda) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutAccessPointConfigurationForObjectLambdaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/accesspointforobjectlambda/{Name}/configuration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutAccessPointConfigurationForObjectLambdaInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "PutAccessPointConfigurationForObjectLambdaRequest",
		},
		Attr: rootAttr,
	}
	root.Attr = append(root.Attr, smithyxml.NewNamespaceAttribute("", "http://awss3control.amazonaws.com/doc/2018-08-20/"))
	if err := awsRestxml_serializeOpDocumentPutAccessPointConfigurationForObjectLambdaInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutAccessPointConfigurationForObjectLambdaInput(v *PutAccessPointConfigurationForObjectLambdaInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

func awsRestxml_serializeOpDocumentPutAccessPointConfigurationForObjectLambdaInput(v *PutAccessPointConfigurationForObjectLambdaInput, value smithyxml.Value) error {
	defer value.Close()
	if v.Configuration != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Configuration",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentObjectLambdaConfiguration(v.Configuration, el); err != nil {
			return err
		}
	}
	return nil
}

type awsRestxml_serializeOpPutAccessPointPolicy struct {
}

func (*awsRestxml_serializeOpPutAccessPointPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutAccessPointPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutAccessPointPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/accesspoint/{Name}/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutAccessPointPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "PutAccessPointPolicyRequest",
		},
		Attr: rootAttr,
	}
	root.Attr = append(root.Attr, smithyxml.NewNamespaceAttribute("", "http://awss3control.amazonaws.com/doc/2018-08-20/"))
	if err := awsRestxml_serializeOpDocumentPutAccessPointPolicyInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutAccessPointPolicyInput(v *PutAccessPointPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

func awsRestxml_serializeOpDocumentPutAccessPointPolicyInput(v *PutAccessPointPolicyInput, value smithyxml.Value) error {
	defer value.Close()
	if v.Policy != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Policy",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Policy)
	}
	return nil
}

type awsRestxml_serializeOpPutAccessPointPolicyForObjectLambda struct {
}

func (*awsRestxml_serializeOpPutAccessPointPolicyForObjectLambda) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutAccessPointPolicyForObjectLambda) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutAccessPointPolicyForObjectLambdaInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/accesspointforobjectlambda/{Name}/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutAccessPointPolicyForObjectLambdaInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "PutAccessPointPolicyForObjectLambdaRequest",
		},
		Attr: rootAttr,
	}
	root.Attr = append(root.Attr, smithyxml.NewNamespaceAttribute("", "http://awss3control.amazonaws.com/doc/2018-08-20/"))
	if err := awsRestxml_serializeOpDocumentPutAccessPointPolicyForObjectLambdaInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutAccessPointPolicyForObjectLambdaInput(v *PutAccessPointPolicyForObjectLambdaInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Name == nil || len(*v.Name) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Name must not be empty")}
	}
	if v.Name != nil {
		if err := encoder.SetURI("Name").String(*v.Name); err != nil {
			return err
		}
	}

	return nil
}

func awsRestxml_serializeOpDocumentPutAccessPointPolicyForObjectLambdaInput(v *PutAccessPointPolicyForObjectLambdaInput, value smithyxml.Value) error {
	defer value.Close()
	if v.Policy != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Policy",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Policy)
	}
	return nil
}

type awsRestxml_serializeOpPutBucketLifecycleConfiguration struct {
}

func (*awsRestxml_serializeOpPutBucketLifecycleConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutBucketLifecycleConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBucketLifecycleConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/bucket/{Bucket}/lifecycleconfiguration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutBucketLifecycleConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.LifecycleConfiguration != nil {
		if !restEncoder.HasHeader("Content-Type") {
			ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "LifecycleConfiguration",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://awss3control.amazonaws.com/doc/2018-08-20/"))
		if err := awsRestxml_serializeDocumentLifecycleConfiguration(input.LifecycleConfiguration, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutBucketLifecycleConfigurationInput(v *PutBucketLifecycleConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpPutBucketPolicy struct {
}

func (*awsRestxml_serializeOpPutBucketPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutBucketPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBucketPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/bucket/{Bucket}/policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutBucketPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "PutBucketPolicyRequest",
		},
		Attr: rootAttr,
	}
	root.Attr = append(root.Attr, smithyxml.NewNamespaceAttribute("", "http://awss3control.amazonaws.com/doc/2018-08-20/"))
	if err := awsRestxml_serializeOpDocumentPutBucketPolicyInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutBucketPolicyInput(v *PutBucketPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.ConfirmRemoveSelfBucketAccess {
		locationName := "X-Amz-Confirm-Remove-Self-Bucket-Access"
		encoder.SetHeader(locationName).Boolean(v.ConfirmRemoveSelfBucketAccess)
	}

	return nil
}

func awsRestxml_serializeOpDocumentPutBucketPolicyInput(v *PutBucketPolicyInput, value smithyxml.Value) error {
	defer value.Close()
	if v.Policy != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Policy",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Policy)
	}
	return nil
}

type awsRestxml_serializeOpPutBucketTagging struct {
}

func (*awsRestxml_serializeOpPutBucketTagging) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutBucketTagging) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBucketTaggingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/bucket/{Bucket}/tagging")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutBucketTaggingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.Tagging != nil {
		if !restEncoder.HasHeader("Content-Type") {
			ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Tagging",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://awss3control.amazonaws.com/doc/2018-08-20/"))
		if err := awsRestxml_serializeDocumentTagging(input.Tagging, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutBucketTaggingInput(v *PutBucketTaggingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	return nil
}

type awsRestxml_serializeOpPutBucketVersioning struct {
}

func (*awsRestxml_serializeOpPutBucketVersioning) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutBucketVersioning) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutBucketVersioningInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/bucket/{Bucket}/versioning")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutBucketVersioningInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.VersioningConfiguration != nil {
		if !restEncoder.HasHeader("Content-Type") {
			ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "VersioningConfiguration",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://awss3control.amazonaws.com/doc/2018-08-20/"))
		if err := awsRestxml_serializeDocumentVersioningConfiguration(input.VersioningConfiguration, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutBucketVersioningInput(v *PutBucketVersioningInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Bucket == nil || len(*v.Bucket) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Bucket must not be empty")}
	}
	if v.Bucket != nil {
		if err := encoder.SetURI("Bucket").String(*v.Bucket); err != nil {
			return err
		}
	}

	if v.MFA != nil && len(*v.MFA) > 0 {
		locationName := "X-Amz-Mfa"
		encoder.SetHeader(locationName).String(*v.MFA)
	}

	return nil
}

type awsRestxml_serializeOpPutJobTagging struct {
}

func (*awsRestxml_serializeOpPutJobTagging) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutJobTagging) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutJobTaggingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/jobs/{JobId}/tagging")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutJobTaggingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "PutJobTaggingRequest",
		},
		Attr: rootAttr,
	}
	root.Attr = append(root.Attr, smithyxml.NewNamespaceAttribute("", "http://awss3control.amazonaws.com/doc/2018-08-20/"))
	if err := awsRestxml_serializeOpDocumentPutJobTaggingInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutJobTaggingInput(v *PutJobTaggingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member JobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("JobId").String(*v.JobId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestxml_serializeOpDocumentPutJobTaggingInput(v *PutJobTaggingInput, value smithyxml.Value) error {
	defer value.Close()
	if v.Tags != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Tags",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentS3TagSet(v.Tags, el); err != nil {
			return err
		}
	}
	return nil
}

type awsRestxml_serializeOpPutMultiRegionAccessPointPolicy struct {
}

func (*awsRestxml_serializeOpPutMultiRegionAccessPointPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutMultiRegionAccessPointPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutMultiRegionAccessPointPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/async-requests/mrap/put-policy")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutMultiRegionAccessPointPolicyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "PutMultiRegionAccessPointPolicyRequest",
		},
		Attr: rootAttr,
	}
	root.Attr = append(root.Attr, smithyxml.NewNamespaceAttribute("", "http://awss3control.amazonaws.com/doc/2018-08-20/"))
	if err := awsRestxml_serializeOpDocumentPutMultiRegionAccessPointPolicyInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutMultiRegionAccessPointPolicyInput(v *PutMultiRegionAccessPointPolicyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	return nil
}

func awsRestxml_serializeOpDocumentPutMultiRegionAccessPointPolicyInput(v *PutMultiRegionAccessPointPolicyInput, value smithyxml.Value) error {
	defer value.Close()
	if v.ClientToken != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ClientToken",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ClientToken)
	}
	if v.Details != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Details",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentPutMultiRegionAccessPointPolicyInput(v.Details, el); err != nil {
			return err
		}
	}
	return nil
}

type awsRestxml_serializeOpPutPublicAccessBlock struct {
}

func (*awsRestxml_serializeOpPutPublicAccessBlock) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutPublicAccessBlock) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutPublicAccessBlockInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/configuration/publicAccessBlock")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutPublicAccessBlockInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if input.PublicAccessBlockConfiguration != nil {
		if !restEncoder.HasHeader("Content-Type") {
			ctx = smithyhttp.SetIsContentTypeDefaultValue(ctx, true)
			restEncoder.SetHeader("Content-Type").String("application/xml")
		}

		xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
		payloadRootAttr := []smithyxml.Attr{}
		payloadRoot := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "PublicAccessBlockConfiguration",
			},
			Attr: payloadRootAttr,
		}
		payloadRoot.Attr = append(payloadRoot.Attr, smithyxml.NewNamespaceAttribute("", "http://awss3control.amazonaws.com/doc/2018-08-20/"))
		if err := awsRestxml_serializeDocumentPublicAccessBlockConfiguration(input.PublicAccessBlockConfiguration, xmlEncoder.RootElement(payloadRoot)); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(xmlEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutPublicAccessBlockInput(v *PutPublicAccessBlockInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	return nil
}

type awsRestxml_serializeOpPutStorageLensConfiguration struct {
}

func (*awsRestxml_serializeOpPutStorageLensConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutStorageLensConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutStorageLensConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/storagelens/{ConfigId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutStorageLensConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "PutStorageLensConfigurationRequest",
		},
		Attr: rootAttr,
	}
	root.Attr = append(root.Attr, smithyxml.NewNamespaceAttribute("", "http://awss3control.amazonaws.com/doc/2018-08-20/"))
	if err := awsRestxml_serializeOpDocumentPutStorageLensConfigurationInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutStorageLensConfigurationInput(v *PutStorageLensConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.ConfigId == nil || len(*v.ConfigId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ConfigId must not be empty")}
	}
	if v.ConfigId != nil {
		if err := encoder.SetURI("ConfigId").String(*v.ConfigId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestxml_serializeOpDocumentPutStorageLensConfigurationInput(v *PutStorageLensConfigurationInput, value smithyxml.Value) error {
	defer value.Close()
	if v.StorageLensConfiguration != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "StorageLensConfiguration",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentStorageLensConfiguration(v.StorageLensConfiguration, el); err != nil {
			return err
		}
	}
	if v.Tags != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Tags",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentStorageLensTags(v.Tags, el); err != nil {
			return err
		}
	}
	return nil
}

type awsRestxml_serializeOpPutStorageLensConfigurationTagging struct {
}

func (*awsRestxml_serializeOpPutStorageLensConfigurationTagging) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpPutStorageLensConfigurationTagging) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutStorageLensConfigurationTaggingInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/storagelens/{ConfigId}/tagging")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsPutStorageLensConfigurationTaggingInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "PutStorageLensConfigurationTaggingRequest",
		},
		Attr: rootAttr,
	}
	root.Attr = append(root.Attr, smithyxml.NewNamespaceAttribute("", "http://awss3control.amazonaws.com/doc/2018-08-20/"))
	if err := awsRestxml_serializeOpDocumentPutStorageLensConfigurationTaggingInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsPutStorageLensConfigurationTaggingInput(v *PutStorageLensConfigurationTaggingInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.ConfigId == nil || len(*v.ConfigId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ConfigId must not be empty")}
	}
	if v.ConfigId != nil {
		if err := encoder.SetURI("ConfigId").String(*v.ConfigId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestxml_serializeOpDocumentPutStorageLensConfigurationTaggingInput(v *PutStorageLensConfigurationTaggingInput, value smithyxml.Value) error {
	defer value.Close()
	if v.Tags != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Tags",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentStorageLensTags(v.Tags, el); err != nil {
			return err
		}
	}
	return nil
}

type awsRestxml_serializeOpSubmitMultiRegionAccessPointRoutes struct {
}

func (*awsRestxml_serializeOpSubmitMultiRegionAccessPointRoutes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpSubmitMultiRegionAccessPointRoutes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SubmitMultiRegionAccessPointRoutesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/mrap/instances/{Mrap+}/routes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsSubmitMultiRegionAccessPointRoutesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/xml")

	xmlEncoder := smithyxml.NewEncoder(bytes.NewBuffer(nil))
	rootAttr := []smithyxml.Attr{}
	root := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "SubmitMultiRegionAccessPointRoutesRequest",
		},
		Attr: rootAttr,
	}
	root.Attr = append(root.Attr, smithyxml.NewNamespaceAttribute("", "http://awss3control.amazonaws.com/doc/2018-08-20/"))
	if err := awsRestxml_serializeOpDocumentSubmitMultiRegionAccessPointRoutesInput(input, xmlEncoder.RootElement(root)); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	if request, err = request.SetStream(bytes.NewReader(xmlEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsSubmitMultiRegionAccessPointRoutesInput(v *SubmitMultiRegionAccessPointRoutesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.Mrap == nil || len(*v.Mrap) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Mrap must not be empty")}
	}
	if v.Mrap != nil {
		if err := encoder.SetURI("Mrap").String(*v.Mrap); err != nil {
			return err
		}
	}

	return nil
}

func awsRestxml_serializeOpDocumentSubmitMultiRegionAccessPointRoutesInput(v *SubmitMultiRegionAccessPointRoutesInput, value smithyxml.Value) error {
	defer value.Close()
	if v.RouteUpdates != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "RouteUpdates",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentRouteList(v.RouteUpdates, el); err != nil {
			return err
		}
	}
	return nil
}

type awsRestxml_serializeOpUpdateJobPriority struct {
}

func (*awsRestxml_serializeOpUpdateJobPriority) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpUpdateJobPriority) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateJobPriorityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/jobs/{JobId}/priority")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsUpdateJobPriorityInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsUpdateJobPriorityInput(v *UpdateJobPriorityInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member JobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("JobId").String(*v.JobId); err != nil {
			return err
		}
	}

	{
		encoder.SetQuery("priority").Integer(v.Priority)
	}

	return nil
}

type awsRestxml_serializeOpUpdateJobStatus struct {
}

func (*awsRestxml_serializeOpUpdateJobStatus) ID() string {
	return "OperationSerializer"
}

func (m *awsRestxml_serializeOpUpdateJobStatus) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateJobStatusInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v20180820/jobs/{JobId}/status")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestxml_serializeOpHttpBindingsUpdateJobStatusInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestxml_serializeOpHttpBindingsUpdateJobStatusInput(v *UpdateJobStatusInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AccountId != nil && len(*v.AccountId) > 0 {
		locationName := "X-Amz-Account-Id"
		encoder.SetHeader(locationName).String(*v.AccountId)
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member JobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("JobId").String(*v.JobId); err != nil {
			return err
		}
	}

	if len(v.RequestedJobStatus) > 0 {
		encoder.SetQuery("requestedJobStatus").String(string(v.RequestedJobStatus))
	}

	if v.StatusUpdateReason != nil {
		encoder.SetQuery("statusUpdateReason").String(*v.StatusUpdateReason)
	}

	return nil
}

func awsRestxml_serializeDocumentAbortIncompleteMultipartUpload(v *types.AbortIncompleteMultipartUpload, value smithyxml.Value) error {
	defer value.Close()
	if v.DaysAfterInitiation != 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "DaysAfterInitiation",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(v.DaysAfterInitiation)
	}
	return nil
}

func awsRestxml_serializeDocumentAccountLevel(v *types.AccountLevel, value smithyxml.Value) error {
	defer value.Close()
	if v.ActivityMetrics != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ActivityMetrics",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentActivityMetrics(v.ActivityMetrics, el); err != nil {
			return err
		}
	}
	if v.AdvancedCostOptimizationMetrics != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AdvancedCostOptimizationMetrics",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentAdvancedCostOptimizationMetrics(v.AdvancedCostOptimizationMetrics, el); err != nil {
			return err
		}
	}
	if v.AdvancedDataProtectionMetrics != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AdvancedDataProtectionMetrics",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentAdvancedDataProtectionMetrics(v.AdvancedDataProtectionMetrics, el); err != nil {
			return err
		}
	}
	if v.BucketLevel != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "BucketLevel",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentBucketLevel(v.BucketLevel, el); err != nil {
			return err
		}
	}
	if v.DetailedStatusCodesMetrics != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "DetailedStatusCodesMetrics",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentDetailedStatusCodesMetrics(v.DetailedStatusCodesMetrics, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentActivityMetrics(v *types.ActivityMetrics, value smithyxml.Value) error {
	defer value.Close()
	if v.IsEnabled {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "IsEnabled",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(v.IsEnabled)
	}
	return nil
}

func awsRestxml_serializeDocumentAdvancedCostOptimizationMetrics(v *types.AdvancedCostOptimizationMetrics, value smithyxml.Value) error {
	defer value.Close()
	if v.IsEnabled {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "IsEnabled",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(v.IsEnabled)
	}
	return nil
}

func awsRestxml_serializeDocumentAdvancedDataProtectionMetrics(v *types.AdvancedDataProtectionMetrics, value smithyxml.Value) error {
	defer value.Close()
	if v.IsEnabled {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "IsEnabled",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(v.IsEnabled)
	}
	return nil
}

func awsRestxml_serializeDocumentAwsLambdaTransformation(v *types.AwsLambdaTransformation, value smithyxml.Value) error {
	defer value.Close()
	if v.FunctionArn != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "FunctionArn",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.FunctionArn)
	}
	if v.FunctionPayload != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "FunctionPayload",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.FunctionPayload)
	}
	return nil
}

func awsRestxml_serializeDocumentBucketLevel(v *types.BucketLevel, value smithyxml.Value) error {
	defer value.Close()
	if v.ActivityMetrics != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ActivityMetrics",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentActivityMetrics(v.ActivityMetrics, el); err != nil {
			return err
		}
	}
	if v.AdvancedCostOptimizationMetrics != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AdvancedCostOptimizationMetrics",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentAdvancedCostOptimizationMetrics(v.AdvancedCostOptimizationMetrics, el); err != nil {
			return err
		}
	}
	if v.AdvancedDataProtectionMetrics != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AdvancedDataProtectionMetrics",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentAdvancedDataProtectionMetrics(v.AdvancedDataProtectionMetrics, el); err != nil {
			return err
		}
	}
	if v.DetailedStatusCodesMetrics != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "DetailedStatusCodesMetrics",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentDetailedStatusCodesMetrics(v.DetailedStatusCodesMetrics, el); err != nil {
			return err
		}
	}
	if v.PrefixLevel != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "PrefixLevel",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentPrefixLevel(v.PrefixLevel, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentBuckets(v []string, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "Arn",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		am.String(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentCloudWatchMetrics(v *types.CloudWatchMetrics, value smithyxml.Value) error {
	defer value.Close()
	{
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "IsEnabled",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(v.IsEnabled)
	}
	return nil
}

func awsRestxml_serializeDocumentCreateBucketConfiguration(v *types.CreateBucketConfiguration, value smithyxml.Value) error {
	defer value.Close()
	if len(v.LocationConstraint) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "LocationConstraint",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.LocationConstraint))
	}
	return nil
}

func awsRestxml_serializeDocumentCreateMultiRegionAccessPointInput(v *types.CreateMultiRegionAccessPointInput, value smithyxml.Value) error {
	defer value.Close()
	if v.Name != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Name",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Name)
	}
	if v.PublicAccessBlock != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "PublicAccessBlock",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentPublicAccessBlockConfiguration(v.PublicAccessBlock, el); err != nil {
			return err
		}
	}
	if v.Regions != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Regions",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentRegionCreationList(v.Regions, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentDeleteMultiRegionAccessPointInput(v *types.DeleteMultiRegionAccessPointInput, value smithyxml.Value) error {
	defer value.Close()
	if v.Name != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Name",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Name)
	}
	return nil
}

func awsRestxml_serializeDocumentDetailedStatusCodesMetrics(v *types.DetailedStatusCodesMetrics, value smithyxml.Value) error {
	defer value.Close()
	if v.IsEnabled {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "IsEnabled",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(v.IsEnabled)
	}
	return nil
}

func awsRestxml_serializeDocumentExclude(v *types.Exclude, value smithyxml.Value) error {
	defer value.Close()
	if v.Buckets != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Buckets",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentBuckets(v.Buckets, el); err != nil {
			return err
		}
	}
	if v.Regions != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Regions",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentRegions(v.Regions, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentGeneratedManifestEncryption(v *types.GeneratedManifestEncryption, value smithyxml.Value) error {
	defer value.Close()
	if v.SSEKMS != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "SSE-KMS",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentSSEKMSEncryption(v.SSEKMS, el); err != nil {
			return err
		}
	}
	if v.SSES3 != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "SSE-S3",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentSSES3Encryption(v.SSES3, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentInclude(v *types.Include, value smithyxml.Value) error {
	defer value.Close()
	if v.Buckets != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Buckets",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentBuckets(v.Buckets, el); err != nil {
			return err
		}
	}
	if v.Regions != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Regions",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentRegions(v.Regions, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentJobManifest(v *types.JobManifest, value smithyxml.Value) error {
	defer value.Close()
	if v.Location != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Location",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentJobManifestLocation(v.Location, el); err != nil {
			return err
		}
	}
	if v.Spec != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Spec",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentJobManifestSpec(v.Spec, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentJobManifestFieldList(v []types.JobManifestFieldName, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		am.String(string(v[i]))
	}
	return nil
}

func awsRestxml_serializeDocumentJobManifestGenerator(v types.JobManifestGenerator, value smithyxml.Value) error {
	defer value.Close()
	switch uv := v.(type) {
	case *types.JobManifestGeneratorMemberS3JobManifestGenerator:
		customMemberNameAttr := []smithyxml.Attr{}
		customMemberName := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "S3JobManifestGenerator",
			},
			Attr: customMemberNameAttr,
		}
		av := value.MemberElement(customMemberName)
		if err := awsRestxml_serializeDocumentS3JobManifestGenerator(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestxml_serializeDocumentJobManifestGeneratorFilter(v *types.JobManifestGeneratorFilter, value smithyxml.Value) error {
	defer value.Close()
	if v.CreatedAfter != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CreatedAfter",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(smithytime.FormatDateTime(*v.CreatedAfter))
	}
	if v.CreatedBefore != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CreatedBefore",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(smithytime.FormatDateTime(*v.CreatedBefore))
	}
	if v.EligibleForReplication != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "EligibleForReplication",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.EligibleForReplication)
	}
	if v.ObjectReplicationStatuses != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ObjectReplicationStatuses",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentReplicationStatusFilterList(v.ObjectReplicationStatuses, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentJobManifestLocation(v *types.JobManifestLocation, value smithyxml.Value) error {
	defer value.Close()
	if v.ETag != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ETag",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ETag)
	}
	if v.ObjectArn != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ObjectArn",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ObjectArn)
	}
	if v.ObjectVersionId != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ObjectVersionId",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ObjectVersionId)
	}
	return nil
}

func awsRestxml_serializeDocumentJobManifestSpec(v *types.JobManifestSpec, value smithyxml.Value) error {
	defer value.Close()
	if v.Fields != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Fields",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentJobManifestFieldList(v.Fields, el); err != nil {
			return err
		}
	}
	if len(v.Format) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Format",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Format))
	}
	return nil
}

func awsRestxml_serializeDocumentJobOperation(v *types.JobOperation, value smithyxml.Value) error {
	defer value.Close()
	if v.LambdaInvoke != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "LambdaInvoke",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentLambdaInvokeOperation(v.LambdaInvoke, el); err != nil {
			return err
		}
	}
	if v.S3DeleteObjectTagging != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "S3DeleteObjectTagging",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentS3DeleteObjectTaggingOperation(v.S3DeleteObjectTagging, el); err != nil {
			return err
		}
	}
	if v.S3InitiateRestoreObject != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "S3InitiateRestoreObject",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentS3InitiateRestoreObjectOperation(v.S3InitiateRestoreObject, el); err != nil {
			return err
		}
	}
	if v.S3PutObjectAcl != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "S3PutObjectAcl",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentS3SetObjectAclOperation(v.S3PutObjectAcl, el); err != nil {
			return err
		}
	}
	if v.S3PutObjectCopy != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "S3PutObjectCopy",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentS3CopyObjectOperation(v.S3PutObjectCopy, el); err != nil {
			return err
		}
	}
	if v.S3PutObjectLegalHold != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "S3PutObjectLegalHold",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentS3SetObjectLegalHoldOperation(v.S3PutObjectLegalHold, el); err != nil {
			return err
		}
	}
	if v.S3PutObjectRetention != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "S3PutObjectRetention",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentS3SetObjectRetentionOperation(v.S3PutObjectRetention, el); err != nil {
			return err
		}
	}
	if v.S3PutObjectTagging != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "S3PutObjectTagging",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentS3SetObjectTaggingOperation(v.S3PutObjectTagging, el); err != nil {
			return err
		}
	}
	if v.S3ReplicateObject != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "S3ReplicateObject",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentS3ReplicateObjectOperation(v.S3ReplicateObject, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentJobReport(v *types.JobReport, value smithyxml.Value) error {
	defer value.Close()
	if v.Bucket != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Bucket",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Bucket)
	}
	{
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Enabled",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(v.Enabled)
	}
	if len(v.Format) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Format",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Format))
	}
	if v.Prefix != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Prefix",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Prefix)
	}
	if len(v.ReportScope) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ReportScope",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.ReportScope))
	}
	return nil
}

func awsRestxml_serializeDocumentLambdaInvokeOperation(v *types.LambdaInvokeOperation, value smithyxml.Value) error {
	defer value.Close()
	if v.FunctionArn != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "FunctionArn",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.FunctionArn)
	}
	return nil
}

func awsRestxml_serializeDocumentLifecycleConfiguration(v *types.LifecycleConfiguration, value smithyxml.Value) error {
	defer value.Close()
	if v.Rules != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Rules",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentLifecycleRules(v.Rules, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentLifecycleExpiration(v *types.LifecycleExpiration, value smithyxml.Value) error {
	defer value.Close()
	if v.Date != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Date",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(smithytime.FormatDateTime(*v.Date))
	}
	if v.Days != 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Days",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(v.Days)
	}
	if v.ExpiredObjectDeleteMarker {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ExpiredObjectDeleteMarker",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(v.ExpiredObjectDeleteMarker)
	}
	return nil
}

func awsRestxml_serializeDocumentLifecycleRule(v *types.LifecycleRule, value smithyxml.Value) error {
	defer value.Close()
	if v.AbortIncompleteMultipartUpload != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AbortIncompleteMultipartUpload",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentAbortIncompleteMultipartUpload(v.AbortIncompleteMultipartUpload, el); err != nil {
			return err
		}
	}
	if v.Expiration != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Expiration",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentLifecycleExpiration(v.Expiration, el); err != nil {
			return err
		}
	}
	if v.Filter != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Filter",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentLifecycleRuleFilter(v.Filter, el); err != nil {
			return err
		}
	}
	if v.ID != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ID",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ID)
	}
	if v.NoncurrentVersionExpiration != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "NoncurrentVersionExpiration",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentNoncurrentVersionExpiration(v.NoncurrentVersionExpiration, el); err != nil {
			return err
		}
	}
	if v.NoncurrentVersionTransitions != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "NoncurrentVersionTransitions",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentNoncurrentVersionTransitionList(v.NoncurrentVersionTransitions, el); err != nil {
			return err
		}
	}
	if len(v.Status) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Status",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Status))
	}
	if v.Transitions != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Transitions",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentTransitionList(v.Transitions, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentLifecycleRuleAndOperator(v *types.LifecycleRuleAndOperator, value smithyxml.Value) error {
	defer value.Close()
	if v.ObjectSizeGreaterThan != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ObjectSizeGreaterThan",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Long(*v.ObjectSizeGreaterThan)
	}
	if v.ObjectSizeLessThan != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ObjectSizeLessThan",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Long(*v.ObjectSizeLessThan)
	}
	if v.Prefix != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Prefix",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Prefix)
	}
	if v.Tags != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Tags",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentS3TagSet(v.Tags, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentLifecycleRuleFilter(v *types.LifecycleRuleFilter, value smithyxml.Value) error {
	defer value.Close()
	if v.And != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "And",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentLifecycleRuleAndOperator(v.And, el); err != nil {
			return err
		}
	}
	if v.ObjectSizeGreaterThan != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ObjectSizeGreaterThan",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Long(*v.ObjectSizeGreaterThan)
	}
	if v.ObjectSizeLessThan != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ObjectSizeLessThan",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Long(*v.ObjectSizeLessThan)
	}
	if v.Prefix != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Prefix",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Prefix)
	}
	if v.Tag != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Tag",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentS3Tag(v.Tag, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentLifecycleRules(v []types.LifecycleRule, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "Rule",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentLifecycleRule(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentMultiRegionAccessPointRoute(v *types.MultiRegionAccessPointRoute, value smithyxml.Value) error {
	defer value.Close()
	if v.Bucket != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Bucket",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Bucket)
	}
	if v.Region != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Region",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Region)
	}
	if v.TrafficDialPercentage != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "TrafficDialPercentage",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.TrafficDialPercentage)
	}
	return nil
}

func awsRestxml_serializeDocumentNoncurrentVersionExpiration(v *types.NoncurrentVersionExpiration, value smithyxml.Value) error {
	defer value.Close()
	if v.NewerNoncurrentVersions != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "NewerNoncurrentVersions",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.NewerNoncurrentVersions)
	}
	if v.NoncurrentDays != 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "NoncurrentDays",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(v.NoncurrentDays)
	}
	return nil
}

func awsRestxml_serializeDocumentNoncurrentVersionTransition(v *types.NoncurrentVersionTransition, value smithyxml.Value) error {
	defer value.Close()
	if v.NoncurrentDays != 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "NoncurrentDays",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(v.NoncurrentDays)
	}
	if len(v.StorageClass) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "StorageClass",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.StorageClass))
	}
	return nil
}

func awsRestxml_serializeDocumentNoncurrentVersionTransitionList(v []types.NoncurrentVersionTransition, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "NoncurrentVersionTransition",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentNoncurrentVersionTransition(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentObjectLambdaAllowedFeaturesList(v []types.ObjectLambdaAllowedFeature, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "AllowedFeature",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		am.String(string(v[i]))
	}
	return nil
}

func awsRestxml_serializeDocumentObjectLambdaConfiguration(v *types.ObjectLambdaConfiguration, value smithyxml.Value) error {
	defer value.Close()
	if v.AllowedFeatures != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AllowedFeatures",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentObjectLambdaAllowedFeaturesList(v.AllowedFeatures, el); err != nil {
			return err
		}
	}
	if v.CloudWatchMetricsEnabled {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CloudWatchMetricsEnabled",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(v.CloudWatchMetricsEnabled)
	}
	if v.SupportingAccessPoint != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "SupportingAccessPoint",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.SupportingAccessPoint)
	}
	if v.TransformationConfigurations != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "TransformationConfigurations",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentObjectLambdaTransformationConfigurationsList(v.TransformationConfigurations, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentObjectLambdaContentTransformation(v types.ObjectLambdaContentTransformation, value smithyxml.Value) error {
	defer value.Close()
	switch uv := v.(type) {
	case *types.ObjectLambdaContentTransformationMemberAwsLambda:
		customMemberNameAttr := []smithyxml.Attr{}
		customMemberName := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AwsLambda",
			},
			Attr: customMemberNameAttr,
		}
		av := value.MemberElement(customMemberName)
		if err := awsRestxml_serializeDocumentAwsLambdaTransformation(&uv.Value, av); err != nil {
			return err
		}

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestxml_serializeDocumentObjectLambdaTransformationConfiguration(v *types.ObjectLambdaTransformationConfiguration, value smithyxml.Value) error {
	defer value.Close()
	if v.Actions != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Actions",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentObjectLambdaTransformationConfigurationActionsList(v.Actions, el); err != nil {
			return err
		}
	}
	if v.ContentTransformation != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ContentTransformation",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentObjectLambdaContentTransformation(v.ContentTransformation, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentObjectLambdaTransformationConfigurationActionsList(v []types.ObjectLambdaTransformationConfigurationAction, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "Action",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		am.String(string(v[i]))
	}
	return nil
}

func awsRestxml_serializeDocumentObjectLambdaTransformationConfigurationsList(v []types.ObjectLambdaTransformationConfiguration, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "TransformationConfiguration",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentObjectLambdaTransformationConfiguration(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentPrefixLevel(v *types.PrefixLevel, value smithyxml.Value) error {
	defer value.Close()
	if v.StorageMetrics != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "StorageMetrics",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentPrefixLevelStorageMetrics(v.StorageMetrics, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentPrefixLevelStorageMetrics(v *types.PrefixLevelStorageMetrics, value smithyxml.Value) error {
	defer value.Close()
	if v.IsEnabled {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "IsEnabled",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(v.IsEnabled)
	}
	if v.SelectionCriteria != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "SelectionCriteria",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentSelectionCriteria(v.SelectionCriteria, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentPublicAccessBlockConfiguration(v *types.PublicAccessBlockConfiguration, value smithyxml.Value) error {
	defer value.Close()
	if v.BlockPublicAcls {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "BlockPublicAcls",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(v.BlockPublicAcls)
	}
	if v.BlockPublicPolicy {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "BlockPublicPolicy",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(v.BlockPublicPolicy)
	}
	if v.IgnorePublicAcls {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "IgnorePublicAcls",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(v.IgnorePublicAcls)
	}
	if v.RestrictPublicBuckets {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "RestrictPublicBuckets",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(v.RestrictPublicBuckets)
	}
	return nil
}

func awsRestxml_serializeDocumentPutMultiRegionAccessPointPolicyInput(v *types.PutMultiRegionAccessPointPolicyInput, value smithyxml.Value) error {
	defer value.Close()
	if v.Name != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Name",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Name)
	}
	if v.Policy != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Policy",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Policy)
	}
	return nil
}

func awsRestxml_serializeDocumentRegion(v *types.Region, value smithyxml.Value) error {
	defer value.Close()
	if v.Bucket != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Bucket",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Bucket)
	}
	return nil
}

func awsRestxml_serializeDocumentRegionCreationList(v []types.Region, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "Region",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentRegion(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentRegions(v []string, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "Region",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		am.String(v[i])
	}
	return nil
}

func awsRestxml_serializeDocumentReplicationStatusFilterList(v []types.ReplicationStatus, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		am.String(string(v[i]))
	}
	return nil
}

func awsRestxml_serializeDocumentRouteList(v []types.MultiRegionAccessPointRoute, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "Route",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentMultiRegionAccessPointRoute(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentS3AccessControlList(v *types.S3AccessControlList, value smithyxml.Value) error {
	defer value.Close()
	if v.Grants != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Grants",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentS3GrantList(v.Grants, el); err != nil {
			return err
		}
	}
	if v.Owner != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Owner",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentS3ObjectOwner(v.Owner, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentS3AccessControlPolicy(v *types.S3AccessControlPolicy, value smithyxml.Value) error {
	defer value.Close()
	if v.AccessControlList != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AccessControlList",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentS3AccessControlList(v.AccessControlList, el); err != nil {
			return err
		}
	}
	if len(v.CannedAccessControlList) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CannedAccessControlList",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.CannedAccessControlList))
	}
	return nil
}

func awsRestxml_serializeDocumentS3BucketDestination(v *types.S3BucketDestination, value smithyxml.Value) error {
	defer value.Close()
	if v.AccountId != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AccountId",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.AccountId)
	}
	if v.Arn != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Arn",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Arn)
	}
	if v.Encryption != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Encryption",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentStorageLensDataExportEncryption(v.Encryption, el); err != nil {
			return err
		}
	}
	if len(v.Format) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Format",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Format))
	}
	if len(v.OutputSchemaVersion) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "OutputSchemaVersion",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.OutputSchemaVersion))
	}
	if v.Prefix != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Prefix",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Prefix)
	}
	return nil
}

func awsRestxml_serializeDocumentS3CopyObjectOperation(v *types.S3CopyObjectOperation, value smithyxml.Value) error {
	defer value.Close()
	if v.AccessControlGrants != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AccessControlGrants",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentS3GrantList(v.AccessControlGrants, el); err != nil {
			return err
		}
	}
	if v.BucketKeyEnabled {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "BucketKeyEnabled",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(v.BucketKeyEnabled)
	}
	if len(v.CannedAccessControlList) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CannedAccessControlList",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.CannedAccessControlList))
	}
	if len(v.ChecksumAlgorithm) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ChecksumAlgorithm",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.ChecksumAlgorithm))
	}
	if len(v.MetadataDirective) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "MetadataDirective",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.MetadataDirective))
	}
	if v.ModifiedSinceConstraint != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ModifiedSinceConstraint",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(smithytime.FormatDateTime(*v.ModifiedSinceConstraint))
	}
	if v.NewObjectMetadata != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "NewObjectMetadata",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentS3ObjectMetadata(v.NewObjectMetadata, el); err != nil {
			return err
		}
	}
	if v.NewObjectTagging != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "NewObjectTagging",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentS3TagSet(v.NewObjectTagging, el); err != nil {
			return err
		}
	}
	if len(v.ObjectLockLegalHoldStatus) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ObjectLockLegalHoldStatus",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.ObjectLockLegalHoldStatus))
	}
	if len(v.ObjectLockMode) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ObjectLockMode",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.ObjectLockMode))
	}
	if v.ObjectLockRetainUntilDate != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ObjectLockRetainUntilDate",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(smithytime.FormatDateTime(*v.ObjectLockRetainUntilDate))
	}
	if v.RedirectLocation != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "RedirectLocation",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.RedirectLocation)
	}
	if v.RequesterPays {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "RequesterPays",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(v.RequesterPays)
	}
	if v.SSEAwsKmsKeyId != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "SSEAwsKmsKeyId",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.SSEAwsKmsKeyId)
	}
	if len(v.StorageClass) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "StorageClass",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.StorageClass))
	}
	if v.TargetKeyPrefix != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "TargetKeyPrefix",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.TargetKeyPrefix)
	}
	if v.TargetResource != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "TargetResource",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.TargetResource)
	}
	if v.UnModifiedSinceConstraint != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "UnModifiedSinceConstraint",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(smithytime.FormatDateTime(*v.UnModifiedSinceConstraint))
	}
	return nil
}

func awsRestxml_serializeDocumentS3DeleteObjectTaggingOperation(v *types.S3DeleteObjectTaggingOperation, value smithyxml.Value) error {
	defer value.Close()
	return nil
}

func awsRestxml_serializeDocumentS3Grant(v *types.S3Grant, value smithyxml.Value) error {
	defer value.Close()
	if v.Grantee != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Grantee",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentS3Grantee(v.Grantee, el); err != nil {
			return err
		}
	}
	if len(v.Permission) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Permission",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Permission))
	}
	return nil
}

func awsRestxml_serializeDocumentS3Grantee(v *types.S3Grantee, value smithyxml.Value) error {
	defer value.Close()
	if v.DisplayName != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "DisplayName",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.DisplayName)
	}
	if v.Identifier != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Identifier",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Identifier)
	}
	if len(v.TypeIdentifier) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "TypeIdentifier",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.TypeIdentifier))
	}
	return nil
}

func awsRestxml_serializeDocumentS3GrantList(v []types.S3Grant, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentS3Grant(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentS3InitiateRestoreObjectOperation(v *types.S3InitiateRestoreObjectOperation, value smithyxml.Value) error {
	defer value.Close()
	if v.ExpirationInDays != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ExpirationInDays",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(*v.ExpirationInDays)
	}
	if len(v.GlacierJobTier) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "GlacierJobTier",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.GlacierJobTier))
	}
	return nil
}

func awsRestxml_serializeDocumentS3JobManifestGenerator(v *types.S3JobManifestGenerator, value smithyxml.Value) error {
	defer value.Close()
	{
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "EnableManifestOutput",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(v.EnableManifestOutput)
	}
	if v.ExpectedBucketOwner != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ExpectedBucketOwner",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ExpectedBucketOwner)
	}
	if v.Filter != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Filter",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentJobManifestGeneratorFilter(v.Filter, el); err != nil {
			return err
		}
	}
	if v.ManifestOutputLocation != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ManifestOutputLocation",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentS3ManifestOutputLocation(v.ManifestOutputLocation, el); err != nil {
			return err
		}
	}
	if v.SourceBucket != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "SourceBucket",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.SourceBucket)
	}
	return nil
}

func awsRestxml_serializeDocumentS3ManifestOutputLocation(v *types.S3ManifestOutputLocation, value smithyxml.Value) error {
	defer value.Close()
	if v.Bucket != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Bucket",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Bucket)
	}
	if v.ExpectedManifestBucketOwner != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ExpectedManifestBucketOwner",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ExpectedManifestBucketOwner)
	}
	if v.ManifestEncryption != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ManifestEncryption",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentGeneratedManifestEncryption(v.ManifestEncryption, el); err != nil {
			return err
		}
	}
	if len(v.ManifestFormat) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ManifestFormat",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.ManifestFormat))
	}
	if v.ManifestPrefix != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ManifestPrefix",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ManifestPrefix)
	}
	return nil
}

func awsRestxml_serializeDocumentS3ObjectLockLegalHold(v *types.S3ObjectLockLegalHold, value smithyxml.Value) error {
	defer value.Close()
	if len(v.Status) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Status",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Status))
	}
	return nil
}

func awsRestxml_serializeDocumentS3ObjectMetadata(v *types.S3ObjectMetadata, value smithyxml.Value) error {
	defer value.Close()
	if v.CacheControl != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CacheControl",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.CacheControl)
	}
	if v.ContentDisposition != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ContentDisposition",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ContentDisposition)
	}
	if v.ContentEncoding != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ContentEncoding",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ContentEncoding)
	}
	if v.ContentLanguage != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ContentLanguage",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ContentLanguage)
	}
	if v.ContentLength != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ContentLength",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Long(*v.ContentLength)
	}
	if v.ContentMD5 != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ContentMD5",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ContentMD5)
	}
	if v.ContentType != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ContentType",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ContentType)
	}
	if v.HttpExpiresDate != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "HttpExpiresDate",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(smithytime.FormatDateTime(*v.HttpExpiresDate))
	}
	if v.RequesterCharged {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "RequesterCharged",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(v.RequesterCharged)
	}
	if len(v.SSEAlgorithm) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "SSEAlgorithm",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.SSEAlgorithm))
	}
	if v.UserMetadata != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "UserMetadata",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentS3UserMetadata(v.UserMetadata, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentS3ObjectOwner(v *types.S3ObjectOwner, value smithyxml.Value) error {
	defer value.Close()
	if v.DisplayName != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "DisplayName",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.DisplayName)
	}
	if v.ID != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "ID",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.ID)
	}
	return nil
}

func awsRestxml_serializeDocumentS3ReplicateObjectOperation(v *types.S3ReplicateObjectOperation, value smithyxml.Value) error {
	defer value.Close()
	return nil
}

func awsRestxml_serializeDocumentS3Retention(v *types.S3Retention, value smithyxml.Value) error {
	defer value.Close()
	if len(v.Mode) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Mode",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Mode))
	}
	if v.RetainUntilDate != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "RetainUntilDate",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(smithytime.FormatDateTime(*v.RetainUntilDate))
	}
	return nil
}

func awsRestxml_serializeDocumentS3SetObjectAclOperation(v *types.S3SetObjectAclOperation, value smithyxml.Value) error {
	defer value.Close()
	if v.AccessControlPolicy != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AccessControlPolicy",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentS3AccessControlPolicy(v.AccessControlPolicy, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentS3SetObjectLegalHoldOperation(v *types.S3SetObjectLegalHoldOperation, value smithyxml.Value) error {
	defer value.Close()
	if v.LegalHold != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "LegalHold",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentS3ObjectLockLegalHold(v.LegalHold, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentS3SetObjectRetentionOperation(v *types.S3SetObjectRetentionOperation, value smithyxml.Value) error {
	defer value.Close()
	if v.BypassGovernanceRetention != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "BypassGovernanceRetention",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(*v.BypassGovernanceRetention)
	}
	if v.Retention != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Retention",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentS3Retention(v.Retention, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentS3SetObjectTaggingOperation(v *types.S3SetObjectTaggingOperation, value smithyxml.Value) error {
	defer value.Close()
	if v.TagSet != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "TagSet",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentS3TagSet(v.TagSet, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentS3Tag(v *types.S3Tag, value smithyxml.Value) error {
	defer value.Close()
	if v.Key != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Key",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Key)
	}
	if v.Value != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Value",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Value)
	}
	return nil
}

func awsRestxml_serializeDocumentS3TagSet(v []types.S3Tag, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	array = value.Array()
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentS3Tag(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentS3UserMetadata(v map[string]string, value smithyxml.Value) error {
	if !value.IsFlattened() {
		defer value.Close()
	}
	m := value.Map()
	for key := range v {
		entry := m.Entry()
		keyElementAttr := []smithyxml.Attr{}
		keyElement := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "key",
			},
			Attr: keyElementAttr,
		}
		entry.MemberElement(keyElement).String(key)
		valueElementAttr := []smithyxml.Attr{}
		valueElement := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "value",
			},
			Attr: valueElementAttr,
		}
		entry.MemberElement(valueElement).String(v[key])
		entry.Close()
	}
	return nil
}

func awsRestxml_serializeDocumentSelectionCriteria(v *types.SelectionCriteria, value smithyxml.Value) error {
	defer value.Close()
	if v.Delimiter != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Delimiter",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Delimiter)
	}
	if v.MaxDepth != 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "MaxDepth",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(v.MaxDepth)
	}
	if v.MinStorageBytesPercentage != 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "MinStorageBytesPercentage",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		switch {
		case math.IsNaN(v.MinStorageBytesPercentage):
			el.String("NaN")

		case math.IsInf(v.MinStorageBytesPercentage, 1):
			el.String("Infinity")

		case math.IsInf(v.MinStorageBytesPercentage, -1):
			el.String("-Infinity")

		default:
			el.Double(v.MinStorageBytesPercentage)

		}
	}
	return nil
}

func awsRestxml_serializeDocumentSSEKMS(v *types.SSEKMS, value smithyxml.Value) error {
	defer value.Close()
	if v.KeyId != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "KeyId",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.KeyId)
	}
	return nil
}

func awsRestxml_serializeDocumentSSEKMSEncryption(v *types.SSEKMSEncryption, value smithyxml.Value) error {
	defer value.Close()
	if v.KeyId != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "KeyId",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.KeyId)
	}
	return nil
}

func awsRestxml_serializeDocumentSSES3(v *types.SSES3, value smithyxml.Value) error {
	defer value.Close()
	return nil
}

func awsRestxml_serializeDocumentSSES3Encryption(v *types.SSES3Encryption, value smithyxml.Value) error {
	defer value.Close()
	return nil
}

func awsRestxml_serializeDocumentStorageLensAwsOrg(v *types.StorageLensAwsOrg, value smithyxml.Value) error {
	defer value.Close()
	if v.Arn != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Arn",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Arn)
	}
	return nil
}

func awsRestxml_serializeDocumentStorageLensConfiguration(v *types.StorageLensConfiguration, value smithyxml.Value) error {
	defer value.Close()
	if v.AccountLevel != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AccountLevel",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentAccountLevel(v.AccountLevel, el); err != nil {
			return err
		}
	}
	if v.AwsOrg != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "AwsOrg",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentStorageLensAwsOrg(v.AwsOrg, el); err != nil {
			return err
		}
	}
	if v.DataExport != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "DataExport",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentStorageLensDataExport(v.DataExport, el); err != nil {
			return err
		}
	}
	if v.Exclude != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Exclude",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentExclude(v.Exclude, el); err != nil {
			return err
		}
	}
	if v.Id != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Id",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Id)
	}
	if v.Include != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Include",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentInclude(v.Include, el); err != nil {
			return err
		}
	}
	{
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "IsEnabled",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Boolean(v.IsEnabled)
	}
	if v.StorageLensArn != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "StorageLensArn",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.StorageLensArn)
	}
	return nil
}

func awsRestxml_serializeDocumentStorageLensDataExport(v *types.StorageLensDataExport, value smithyxml.Value) error {
	defer value.Close()
	if v.CloudWatchMetrics != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "CloudWatchMetrics",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentCloudWatchMetrics(v.CloudWatchMetrics, el); err != nil {
			return err
		}
	}
	if v.S3BucketDestination != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "S3BucketDestination",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentS3BucketDestination(v.S3BucketDestination, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentStorageLensDataExportEncryption(v *types.StorageLensDataExportEncryption, value smithyxml.Value) error {
	defer value.Close()
	if v.SSEKMS != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "SSE-KMS",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentSSEKMS(v.SSEKMS, el); err != nil {
			return err
		}
	}
	if v.SSES3 != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "SSE-S3",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentSSES3(v.SSES3, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentStorageLensTag(v *types.StorageLensTag, value smithyxml.Value) error {
	defer value.Close()
	if v.Key != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Key",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Key)
	}
	if v.Value != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Value",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.Value)
	}
	return nil
}

func awsRestxml_serializeDocumentStorageLensTags(v []types.StorageLensTag, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "Tag",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentStorageLensTag(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentTagging(v *types.Tagging, value smithyxml.Value) error {
	defer value.Close()
	if v.TagSet != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "TagSet",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		if err := awsRestxml_serializeDocumentS3TagSet(v.TagSet, el); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentTransition(v *types.Transition, value smithyxml.Value) error {
	defer value.Close()
	if v.Date != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Date",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(smithytime.FormatDateTime(*v.Date))
	}
	if v.Days != 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Days",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.Integer(v.Days)
	}
	if len(v.StorageClass) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "StorageClass",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.StorageClass))
	}
	return nil
}

func awsRestxml_serializeDocumentTransitionList(v []types.Transition, value smithyxml.Value) error {
	var array *smithyxml.Array
	if !value.IsFlattened() {
		defer value.Close()
	}
	customMemberNameAttr := []smithyxml.Attr{}
	customMemberName := smithyxml.StartElement{
		Name: smithyxml.Name{
			Local: "Transition",
		},
		Attr: customMemberNameAttr,
	}
	array = value.ArrayWithCustomName(customMemberName)
	for i := range v {
		am := array.Member()
		if err := awsRestxml_serializeDocumentTransition(&v[i], am); err != nil {
			return err
		}
	}
	return nil
}

func awsRestxml_serializeDocumentVersioningConfiguration(v *types.VersioningConfiguration, value smithyxml.Value) error {
	defer value.Close()
	if len(v.MFADelete) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "MfaDelete",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.MFADelete))
	}
	if len(v.Status) > 0 {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "Status",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(string(v.Status))
	}
	return nil
}

func awsRestxml_serializeDocumentVpcConfiguration(v *types.VpcConfiguration, value smithyxml.Value) error {
	defer value.Close()
	if v.VpcId != nil {
		rootAttr := []smithyxml.Attr{}
		root := smithyxml.StartElement{
			Name: smithyxml.Name{
				Local: "VpcId",
			},
			Attr: rootAttr,
		}
		el := value.MemberElement(root)
		el.String(*v.VpcId)
	}
	return nil
}
