// Code generated by smithy-go-codegen DO NOT EDIT.

package proton

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/proton/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Get counts of Proton resources. For infrastructure-provisioning resources
// (environments, services, service instances, pipelines), the action returns
// staleness counts. A resource is stale when it's behind the recommended version
// of the Proton template that it uses and it needs an update to become current.
// The action returns staleness counts (counts of resources that are up-to-date,
// behind a template major version, or behind a template minor version), the total
// number of resources, and the number of resources that are in a failed state,
// grouped by resource type. Components, environments, and service templates are
// exceptions—see the components, environments, and serviceTemplates field
// descriptions. For context, the action also returns the total number of each type
// of Proton template in the Amazon Web Services account. For more information, see
// Proton dashboard
// (https://docs.aws.amazon.com/proton/latest/userguide/monitoring-dashboard.html)
// in the Proton User Guide.
func (c *Client) GetResourcesSummary(ctx context.Context, params *GetResourcesSummaryInput, optFns ...func(*Options)) (*GetResourcesSummaryOutput, error) {
	if params == nil {
		params = &GetResourcesSummaryInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetResourcesSummary", params, optFns, c.addOperationGetResourcesSummaryMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetResourcesSummaryOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetResourcesSummaryInput struct {
	noSmithyDocumentSerde
}

type GetResourcesSummaryOutput struct {

	// Summary counts of each Proton resource type.
	//
	// This member is required.
	Counts *types.CountsSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetResourcesSummaryMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpGetResourcesSummary{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpGetResourcesSummary{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetResourcesSummary(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetResourcesSummary(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "proton",
		OperationName: "GetResourcesSummary",
	}
}
