// Code generated by smithy-go-codegen DO NOT EDIT.

package networkfirewall

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/networkfirewall/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the properties of the specified firewall policy.
func (c *Client) UpdateFirewallPolicy(ctx context.Context, params *UpdateFirewallPolicyInput, optFns ...func(*Options)) (*UpdateFirewallPolicyOutput, error) {
	if params == nil {
		params = &UpdateFirewallPolicyInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateFirewallPolicy", params, optFns, c.addOperationUpdateFirewallPolicyMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateFirewallPolicyOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateFirewallPolicyInput struct {

	// The updated firewall policy to use for the firewall.
	//
	// This member is required.
	FirewallPolicy *types.FirewallPolicy

	// A token used for optimistic locking. Network Firewall returns a token to your
	// requests that access the firewall policy. The token marks the state of the
	// policy resource at the time of the request. To make changes to the policy, you
	// provide the token in your request. Network Firewall uses the token to ensure
	// that the policy hasn't changed since you last retrieved it. If it has changed,
	// the operation fails with an InvalidTokenException. If this happens, retrieve the
	// firewall policy again to get a current copy of it with current token. Reapply
	// your changes as needed, then try the operation again using the new token.
	//
	// This member is required.
	UpdateToken *string

	// A description of the firewall policy.
	Description *string

	// Indicates whether you want Network Firewall to just check the validity of the
	// request, rather than run the request. If set to TRUE, Network Firewall checks
	// whether the request can run successfully, but doesn't actually make the
	// requested changes. The call returns the value that the request would return if
	// you ran it with dry run set to FALSE, but doesn't make additions or changes to
	// your resources. This option allows you to make sure that you have the required
	// permissions to run the request and that your request parameters are valid. If
	// set to FALSE, Network Firewall makes the requested changes to your resources.
	DryRun bool

	// A complex type that contains settings for encryption of your firewall policy
	// resources.
	EncryptionConfiguration *types.EncryptionConfiguration

	// The Amazon Resource Name (ARN) of the firewall policy. You must specify the ARN
	// or the name, and you can specify both.
	FirewallPolicyArn *string

	// The descriptive name of the firewall policy. You can't change the name of a
	// firewall policy after you create it. You must specify the ARN or the name, and
	// you can specify both.
	FirewallPolicyName *string

	noSmithyDocumentSerde
}

type UpdateFirewallPolicyOutput struct {

	// The high-level properties of a firewall policy. This, along with the
	// FirewallPolicy, define the policy. You can retrieve all objects for a firewall
	// policy by calling DescribeFirewallPolicy.
	//
	// This member is required.
	FirewallPolicyResponse *types.FirewallPolicyResponse

	// A token used for optimistic locking. Network Firewall returns a token to your
	// requests that access the firewall policy. The token marks the state of the
	// policy resource at the time of the request. To make changes to the policy, you
	// provide the token in your request. Network Firewall uses the token to ensure
	// that the policy hasn't changed since you last retrieved it. If it has changed,
	// the operation fails with an InvalidTokenException. If this happens, retrieve the
	// firewall policy again to get a current copy of it with current token. Reapply
	// your changes as needed, then try the operation again using the new token.
	//
	// This member is required.
	UpdateToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateFirewallPolicyMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpUpdateFirewallPolicy{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpUpdateFirewallPolicy{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpUpdateFirewallPolicyValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateFirewallPolicy(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateFirewallPolicy(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "network-firewall",
		OperationName: "UpdateFirewallPolicy",
	}
}
