// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Internal only. Represents the dimensions of a metric. To learn more about the
// metrics published to Amazon CloudWatch, see Amazon MWAA performance metrics in
// Amazon CloudWatch
// (https://docs.aws.amazon.com/mwaa/latest/userguide/cw-metrics.html).
type Dimension struct {

	// Internal only. The name of the dimension.
	//
	// This member is required.
	Name *string

	// Internal only. The value of the dimension.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Describes an Amazon Managed Workflows for Apache Airflow (MWAA) environment.
type Environment struct {

	// A list of key-value pairs containing the Apache Airflow configuration options
	// attached to your environment. To learn more, see Apache Airflow configuration
	// options
	// (https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-env-variables.html).
	AirflowConfigurationOptions map[string]string

	// The Apache Airflow version on your environment. Valid values: 1.10.12, 2.0.2,
	// 2.2.2, and 2.4.3.
	AirflowVersion *string

	// The Amazon Resource Name (ARN) of the Amazon MWAA environment.
	Arn *string

	// The day and time the environment was created.
	CreatedAt *time.Time

	// The relative path to the DAGs folder on your Amazon S3 bucket. For example,
	// dags. To learn more, see Adding or updating DAGs
	// (https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-folder.html).
	DagS3Path *string

	// The environment class type. Valid values: mw1.small, mw1.medium, mw1.large. To
	// learn more, see Amazon MWAA environment class
	// (https://docs.aws.amazon.com/mwaa/latest/userguide/environment-class.html).
	EnvironmentClass *string

	// The Amazon Resource Name (ARN) of the execution role in IAM that allows MWAA to
	// access Amazon Web Services resources in your environment. For example,
	// arn:aws:iam::123456789:role/my-execution-role. To learn more, see Amazon MWAA
	// Execution role
	// (https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-create-role.html).
	ExecutionRoleArn *string

	// The Amazon Web Services Key Management Service (KMS) encryption key used to
	// encrypt the data in your environment.
	KmsKey *string

	// The status of the last update on the environment.
	LastUpdate *LastUpdate

	// The Apache Airflow logs published to CloudWatch Logs.
	LoggingConfiguration *LoggingConfiguration

	// The maximum number of workers that run in your environment. For example, 20.
	MaxWorkers *int32

	// The minimum number of workers that run in your environment. For example, 2.
	MinWorkers *int32

	// The name of the Amazon MWAA environment. For example, MyMWAAEnvironment.
	Name *string

	// Describes the VPC networking components used to secure and enable network
	// traffic between the Amazon Web Services resources for your environment. To learn
	// more, see About networking on Amazon MWAA
	// (https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html).
	NetworkConfiguration *NetworkConfiguration

	// The version of the plugins.zip file on your Amazon S3 bucket. To learn more, see
	// Installing custom plugins
	// (https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html).
	PluginsS3ObjectVersion *string

	// The relative path to the plugins.zip file on your Amazon S3 bucket. For example,
	// plugins.zip. To learn more, see Installing custom plugins
	// (https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-dag-import-plugins.html).
	PluginsS3Path *string

	// The version of the requirements.txt file on your Amazon S3 bucket. To learn
	// more, see Installing Python dependencies
	// (https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html).
	RequirementsS3ObjectVersion *string

	// The relative path to the requirements.txt file on your Amazon S3 bucket. For
	// example, requirements.txt. To learn more, see Installing Python dependencies
	// (https://docs.aws.amazon.com/mwaa/latest/userguide/working-dags-dependencies.html).
	RequirementsS3Path *string

	// The number of Apache Airflow schedulers that run in your Amazon MWAA
	// environment.
	Schedulers *int32

	// The Amazon Resource Name (ARN) for the service-linked role of the environment.
	// To learn more, see Amazon MWAA Service-linked role
	// (https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-slr.html).
	ServiceRoleArn *string

	// The Amazon Resource Name (ARN) of the Amazon S3 bucket where your DAG code and
	// supporting files are stored. For example,
	// arn:aws:s3:::my-airflow-bucket-unique-name. To learn more, see Create an Amazon
	// S3 bucket for Amazon MWAA
	// (https://docs.aws.amazon.com/mwaa/latest/userguide/mwaa-s3-bucket.html).
	SourceBucketArn *string

	// The status of the Amazon MWAA environment. Valid values:
	//
	// * CREATING - Indicates
	// the request to create the environment is in progress.
	//
	// * CREATE_FAILED -
	// Indicates the request to create the environment failed, and the environment
	// could not be created.
	//
	// * AVAILABLE - Indicates the request was successful and
	// the environment is ready to use.
	//
	// * UPDATING - Indicates the request to update
	// the environment is in progress.
	//
	// * DELETING - Indicates the request to delete
	// the environment is in progress.
	//
	// * DELETED - Indicates the request to delete the
	// environment is complete, and the environment has been deleted.
	//
	// * UNAVAILABLE -
	// Indicates the request failed, but the environment was unable to rollback and is
	// not in a stable state.
	//
	// * UPDATE_FAILED - Indicates the request to update the
	// environment failed, and the environment has rolled back successfully and is
	// ready to use.
	//
	// We recommend reviewing our troubleshooting guide for a list of
	// common errors and their solutions. To learn more, see Amazon MWAA
	// troubleshooting
	// (https://docs.aws.amazon.com/mwaa/latest/userguide/troubleshooting.html).
	Status EnvironmentStatus

	// The key-value tag pairs associated to your environment. For example,
	// "Environment": "Staging". To learn more, see Tagging Amazon Web Services
	// resources (https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html).
	Tags map[string]string

	// The Apache Airflow Web server access mode. To learn more, see Apache Airflow
	// access modes
	// (https://docs.aws.amazon.com/mwaa/latest/userguide/configuring-networking.html).
	WebserverAccessMode WebserverAccessMode

	// The Apache Airflow Web server host name for the Amazon MWAA environment. To
	// learn more, see Accessing the Apache Airflow UI
	// (https://docs.aws.amazon.com/mwaa/latest/userguide/access-airflow-ui.html).
	WebserverUrl *string

	// The day and time of the week in Coordinated Universal Time (UTC) 24-hour
	// standard time that weekly maintenance updates are scheduled. For example:
	// TUE:03:30.
	WeeklyMaintenanceWindowStart *string

	noSmithyDocumentSerde
}

// Describes the status of the last update on the environment, and any errors that
// were encountered.
type LastUpdate struct {

	// The day and time of the last update on the environment.
	CreatedAt *time.Time

	// The error that was encountered during the last update of the environment.
	Error *UpdateError

	// The source of the last update to the environment. Includes internal processes by
	// Amazon MWAA, such as an environment maintenance update.
	Source *string

	// The status of the last update on the environment.
	Status UpdateStatus

	noSmithyDocumentSerde
}

// Describes the Apache Airflow log types that are published to CloudWatch Logs.
type LoggingConfiguration struct {

	// The Airflow DAG processing logs published to CloudWatch Logs and the log level.
	DagProcessingLogs *ModuleLoggingConfiguration

	// The Airflow scheduler logs published to CloudWatch Logs and the log level.
	SchedulerLogs *ModuleLoggingConfiguration

	// The Airflow task logs published to CloudWatch Logs and the log level.
	TaskLogs *ModuleLoggingConfiguration

	// The Airflow web server logs published to CloudWatch Logs and the log level.
	WebserverLogs *ModuleLoggingConfiguration

	// The Airflow worker logs published to CloudWatch Logs and the log level.
	WorkerLogs *ModuleLoggingConfiguration

	noSmithyDocumentSerde
}

// Defines the Apache Airflow log types to send to CloudWatch Logs.
type LoggingConfigurationInput struct {

	// Publishes Airflow DAG processing logs to CloudWatch Logs.
	DagProcessingLogs *ModuleLoggingConfigurationInput

	// Publishes Airflow scheduler logs to CloudWatch Logs.
	SchedulerLogs *ModuleLoggingConfigurationInput

	// Publishes Airflow task logs to CloudWatch Logs.
	TaskLogs *ModuleLoggingConfigurationInput

	// Publishes Airflow web server logs to CloudWatch Logs.
	WebserverLogs *ModuleLoggingConfigurationInput

	// Publishes Airflow worker logs to CloudWatch Logs.
	WorkerLogs *ModuleLoggingConfigurationInput

	noSmithyDocumentSerde
}

// Internal only. Collects Apache Airflow metrics. To learn more about the metrics
// published to Amazon CloudWatch, see Amazon MWAA performance metrics in Amazon
// CloudWatch (https://docs.aws.amazon.com/mwaa/latest/userguide/cw-metrics.html).
type MetricDatum struct {

	// Internal only. The name of the metric.
	//
	// This member is required.
	MetricName *string

	// Internal only. The time the metric data was received.
	//
	// This member is required.
	Timestamp *time.Time

	// Internal only. The dimensions associated with the metric.
	Dimensions []Dimension

	// Internal only. The statistical values for the metric.
	StatisticValues *StatisticSet

	// Internal only. The unit used to store the metric.
	Unit Unit

	// Internal only. The value for the metric.
	Value *float64

	noSmithyDocumentSerde
}

// Describes the Apache Airflow log details for the log type (e.g.
// DagProcessingLogs).
type ModuleLoggingConfiguration struct {

	// The Amazon Resource Name (ARN) for the CloudWatch Logs group where the Apache
	// Airflow log type (e.g. DagProcessingLogs) is published. For example,
	// arn:aws:logs:us-east-1:123456789012:log-group:airflow-MyMWAAEnvironment-MwaaEnvironment-DAGProcessing:*.
	CloudWatchLogGroupArn *string

	// Indicates whether the Apache Airflow log type (e.g. DagProcessingLogs) is
	// enabled.
	Enabled *bool

	// The Apache Airflow log level for the log type (e.g. DagProcessingLogs).
	LogLevel LoggingLevel

	noSmithyDocumentSerde
}

// Enables the Apache Airflow log type (e.g. DagProcessingLogs) and defines the log
// level to send to CloudWatch Logs (e.g. INFO).
type ModuleLoggingConfigurationInput struct {

	// Indicates whether to enable the Apache Airflow log type (e.g.
	// DagProcessingLogs).
	//
	// This member is required.
	Enabled *bool

	// Defines the Apache Airflow log level (e.g. INFO) to send to CloudWatch Logs.
	//
	// This member is required.
	LogLevel LoggingLevel

	noSmithyDocumentSerde
}

// Describes the VPC networking components used to secure and enable network
// traffic between the Amazon Web Services resources for your environment. To learn
// more, see About networking on Amazon MWAA
// (https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html).
type NetworkConfiguration struct {

	// A list of security group IDs. To learn more, see Security in your VPC on Amazon
	// MWAA (https://docs.aws.amazon.com/mwaa/latest/userguide/vpc-security.html).
	SecurityGroupIds []string

	// A list of subnet IDs. To learn more, see About networking on Amazon MWAA
	// (https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html).
	SubnetIds []string

	noSmithyDocumentSerde
}

// Internal only. Represents a set of statistics that describe a specific metric.
// To learn more about the metrics published to Amazon CloudWatch, see Amazon MWAA
// performance metrics in Amazon CloudWatch
// (https://docs.aws.amazon.com/mwaa/latest/userguide/cw-metrics.html).
type StatisticSet struct {

	// Internal only. The maximum value of the sample set.
	Maximum *float64

	// Internal only. The minimum value of the sample set.
	Minimum *float64

	// Internal only. The number of samples used for the statistic set.
	SampleCount *int32

	// Internal only. The sum of values for the sample set.
	Sum *float64

	noSmithyDocumentSerde
}

// Describes the error(s) encountered with the last update of the environment.
type UpdateError struct {

	// The error code that corresponds to the error with the last update.
	ErrorCode *string

	// The error message that corresponds to the error code.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// Defines the VPC networking components used to secure and enable network traffic
// between the Amazon Web Services resources for your environment. To learn more,
// see About networking on Amazon MWAA
// (https://docs.aws.amazon.com/mwaa/latest/userguide/networking-about.html).
type UpdateNetworkConfigurationInput struct {

	// A list of security group IDs. A security group must be attached to the same VPC
	// as the subnets. To learn more, see Security in your VPC on Amazon MWAA
	// (https://docs.aws.amazon.com/mwaa/latest/userguide/vpc-security.html).
	//
	// This member is required.
	SecurityGroupIds []string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
