// Code generated by smithy-go-codegen DO NOT EDIT.

package mgn

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/mgn/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpArchiveApplication struct {
}

func (*validateOpArchiveApplication) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpArchiveApplication) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ArchiveApplicationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpArchiveApplicationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpArchiveWave struct {
}

func (*validateOpArchiveWave) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpArchiveWave) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ArchiveWaveInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpArchiveWaveInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpAssociateApplications struct {
}

func (*validateOpAssociateApplications) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAssociateApplications) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AssociateApplicationsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAssociateApplicationsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpAssociateSourceServers struct {
}

func (*validateOpAssociateSourceServers) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpAssociateSourceServers) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*AssociateSourceServersInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpAssociateSourceServersInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpChangeServerLifeCycleState struct {
}

func (*validateOpChangeServerLifeCycleState) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpChangeServerLifeCycleState) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ChangeServerLifeCycleStateInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpChangeServerLifeCycleStateInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateApplication struct {
}

func (*validateOpCreateApplication) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateApplication) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateApplicationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateApplicationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateLaunchConfigurationTemplate struct {
}

func (*validateOpCreateLaunchConfigurationTemplate) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateLaunchConfigurationTemplate) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateLaunchConfigurationTemplateInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateLaunchConfigurationTemplateInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateReplicationConfigurationTemplate struct {
}

func (*validateOpCreateReplicationConfigurationTemplate) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateReplicationConfigurationTemplate) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateReplicationConfigurationTemplateInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateReplicationConfigurationTemplateInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateWave struct {
}

func (*validateOpCreateWave) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateWave) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateWaveInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateWaveInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteApplication struct {
}

func (*validateOpDeleteApplication) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteApplication) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteApplicationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteApplicationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteJob struct {
}

func (*validateOpDeleteJob) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteJob) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteJobInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteJobInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteLaunchConfigurationTemplate struct {
}

func (*validateOpDeleteLaunchConfigurationTemplate) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteLaunchConfigurationTemplate) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteLaunchConfigurationTemplateInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteLaunchConfigurationTemplateInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteReplicationConfigurationTemplate struct {
}

func (*validateOpDeleteReplicationConfigurationTemplate) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteReplicationConfigurationTemplate) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteReplicationConfigurationTemplateInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteReplicationConfigurationTemplateInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteSourceServer struct {
}

func (*validateOpDeleteSourceServer) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteSourceServer) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteSourceServerInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteSourceServerInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteVcenterClient struct {
}

func (*validateOpDeleteVcenterClient) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteVcenterClient) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteVcenterClientInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteVcenterClientInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteWave struct {
}

func (*validateOpDeleteWave) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteWave) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteWaveInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteWaveInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDescribeJobLogItems struct {
}

func (*validateOpDescribeJobLogItems) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDescribeJobLogItems) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DescribeJobLogItemsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDescribeJobLogItemsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDisassociateApplications struct {
}

func (*validateOpDisassociateApplications) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDisassociateApplications) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DisassociateApplicationsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDisassociateApplicationsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDisassociateSourceServers struct {
}

func (*validateOpDisassociateSourceServers) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDisassociateSourceServers) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DisassociateSourceServersInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDisassociateSourceServersInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDisconnectFromService struct {
}

func (*validateOpDisconnectFromService) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDisconnectFromService) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DisconnectFromServiceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDisconnectFromServiceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpFinalizeCutover struct {
}

func (*validateOpFinalizeCutover) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpFinalizeCutover) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*FinalizeCutoverInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpFinalizeCutoverInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetLaunchConfiguration struct {
}

func (*validateOpGetLaunchConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetLaunchConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetLaunchConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetLaunchConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetReplicationConfiguration struct {
}

func (*validateOpGetReplicationConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetReplicationConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetReplicationConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetReplicationConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListSourceServerActions struct {
}

func (*validateOpListSourceServerActions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListSourceServerActions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListSourceServerActionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListSourceServerActionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTemplateActions struct {
}

func (*validateOpListTemplateActions) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTemplateActions) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTemplateActionsInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTemplateActionsInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpMarkAsArchived struct {
}

func (*validateOpMarkAsArchived) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpMarkAsArchived) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*MarkAsArchivedInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpMarkAsArchivedInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutSourceServerAction struct {
}

func (*validateOpPutSourceServerAction) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutSourceServerAction) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutSourceServerActionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutSourceServerActionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpPutTemplateAction struct {
}

func (*validateOpPutTemplateAction) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpPutTemplateAction) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*PutTemplateActionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpPutTemplateActionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRemoveSourceServerAction struct {
}

func (*validateOpRemoveSourceServerAction) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRemoveSourceServerAction) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RemoveSourceServerActionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRemoveSourceServerActionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRemoveTemplateAction struct {
}

func (*validateOpRemoveTemplateAction) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRemoveTemplateAction) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RemoveTemplateActionInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRemoveTemplateActionInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRetryDataReplication struct {
}

func (*validateOpRetryDataReplication) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRetryDataReplication) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RetryDataReplicationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRetryDataReplicationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartCutover struct {
}

func (*validateOpStartCutover) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartCutover) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartCutoverInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartCutoverInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartReplication struct {
}

func (*validateOpStartReplication) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartReplication) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartReplicationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartReplicationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpStartTest struct {
}

func (*validateOpStartTest) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpStartTest) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*StartTestInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpStartTestInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTerminateTargetInstances struct {
}

func (*validateOpTerminateTargetInstances) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTerminateTargetInstances) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TerminateTargetInstancesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTerminateTargetInstancesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUnarchiveApplication struct {
}

func (*validateOpUnarchiveApplication) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUnarchiveApplication) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UnarchiveApplicationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUnarchiveApplicationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUnarchiveWave struct {
}

func (*validateOpUnarchiveWave) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUnarchiveWave) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UnarchiveWaveInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUnarchiveWaveInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateApplication struct {
}

func (*validateOpUpdateApplication) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateApplication) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateApplicationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateApplicationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateLaunchConfiguration struct {
}

func (*validateOpUpdateLaunchConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateLaunchConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateLaunchConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateLaunchConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateLaunchConfigurationTemplate struct {
}

func (*validateOpUpdateLaunchConfigurationTemplate) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateLaunchConfigurationTemplate) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateLaunchConfigurationTemplateInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateLaunchConfigurationTemplateInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateReplicationConfiguration struct {
}

func (*validateOpUpdateReplicationConfiguration) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateReplicationConfiguration) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateReplicationConfigurationInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateReplicationConfigurationInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateReplicationConfigurationTemplate struct {
}

func (*validateOpUpdateReplicationConfigurationTemplate) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateReplicationConfigurationTemplate) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateReplicationConfigurationTemplateInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateReplicationConfigurationTemplateInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateSourceServerReplicationType struct {
}

func (*validateOpUpdateSourceServerReplicationType) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateSourceServerReplicationType) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateSourceServerReplicationTypeInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateSourceServerReplicationTypeInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateWave struct {
}

func (*validateOpUpdateWave) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateWave) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateWaveInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateWaveInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpArchiveApplicationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpArchiveApplication{}, middleware.After)
}

func addOpArchiveWaveValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpArchiveWave{}, middleware.After)
}

func addOpAssociateApplicationsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAssociateApplications{}, middleware.After)
}

func addOpAssociateSourceServersValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpAssociateSourceServers{}, middleware.After)
}

func addOpChangeServerLifeCycleStateValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpChangeServerLifeCycleState{}, middleware.After)
}

func addOpCreateApplicationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateApplication{}, middleware.After)
}

func addOpCreateLaunchConfigurationTemplateValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateLaunchConfigurationTemplate{}, middleware.After)
}

func addOpCreateReplicationConfigurationTemplateValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateReplicationConfigurationTemplate{}, middleware.After)
}

func addOpCreateWaveValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateWave{}, middleware.After)
}

func addOpDeleteApplicationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteApplication{}, middleware.After)
}

func addOpDeleteJobValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteJob{}, middleware.After)
}

func addOpDeleteLaunchConfigurationTemplateValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteLaunchConfigurationTemplate{}, middleware.After)
}

func addOpDeleteReplicationConfigurationTemplateValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteReplicationConfigurationTemplate{}, middleware.After)
}

func addOpDeleteSourceServerValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteSourceServer{}, middleware.After)
}

func addOpDeleteVcenterClientValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteVcenterClient{}, middleware.After)
}

func addOpDeleteWaveValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteWave{}, middleware.After)
}

func addOpDescribeJobLogItemsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDescribeJobLogItems{}, middleware.After)
}

func addOpDisassociateApplicationsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDisassociateApplications{}, middleware.After)
}

func addOpDisassociateSourceServersValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDisassociateSourceServers{}, middleware.After)
}

func addOpDisconnectFromServiceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDisconnectFromService{}, middleware.After)
}

func addOpFinalizeCutoverValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpFinalizeCutover{}, middleware.After)
}

func addOpGetLaunchConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetLaunchConfiguration{}, middleware.After)
}

func addOpGetReplicationConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetReplicationConfiguration{}, middleware.After)
}

func addOpListSourceServerActionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListSourceServerActions{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpListTemplateActionsValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTemplateActions{}, middleware.After)
}

func addOpMarkAsArchivedValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpMarkAsArchived{}, middleware.After)
}

func addOpPutSourceServerActionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutSourceServerAction{}, middleware.After)
}

func addOpPutTemplateActionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpPutTemplateAction{}, middleware.After)
}

func addOpRemoveSourceServerActionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRemoveSourceServerAction{}, middleware.After)
}

func addOpRemoveTemplateActionValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRemoveTemplateAction{}, middleware.After)
}

func addOpRetryDataReplicationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRetryDataReplication{}, middleware.After)
}

func addOpStartCutoverValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartCutover{}, middleware.After)
}

func addOpStartReplicationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartReplication{}, middleware.After)
}

func addOpStartTestValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpStartTest{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpTerminateTargetInstancesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTerminateTargetInstances{}, middleware.After)
}

func addOpUnarchiveApplicationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUnarchiveApplication{}, middleware.After)
}

func addOpUnarchiveWaveValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUnarchiveWave{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateApplicationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateApplication{}, middleware.After)
}

func addOpUpdateLaunchConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateLaunchConfiguration{}, middleware.After)
}

func addOpUpdateLaunchConfigurationTemplateValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateLaunchConfigurationTemplate{}, middleware.After)
}

func addOpUpdateReplicationConfigurationValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateReplicationConfiguration{}, middleware.After)
}

func addOpUpdateReplicationConfigurationTemplateValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateReplicationConfigurationTemplate{}, middleware.After)
}

func addOpUpdateSourceServerReplicationTypeValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateSourceServerReplicationType{}, middleware.After)
}

func addOpUpdateWaveValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateWave{}, middleware.After)
}

func validateChangeServerLifeCycleStateSourceServerLifecycle(v *types.ChangeServerLifeCycleStateSourceServerLifecycle) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ChangeServerLifeCycleStateSourceServerLifecycle"}
	if len(v.State) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("State"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePostLaunchActions(v *types.PostLaunchActions) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PostLaunchActions"}
	if v.SsmDocuments != nil {
		if err := validateSsmDocuments(v.SsmDocuments); err != nil {
			invalidParams.AddNested("SsmDocuments", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSsmDocument(v *types.SsmDocument) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SsmDocument"}
	if v.ActionName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionName"))
	}
	if v.SsmDocumentName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SsmDocumentName"))
	}
	if v.Parameters != nil {
		if err := validateSsmDocumentParameters(v.Parameters); err != nil {
			invalidParams.AddNested("Parameters", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSsmDocumentParameters(v map[string][]types.SsmParameterStoreParameter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SsmDocumentParameters"}
	for key := range v {
		if err := validateSsmParameterStoreParameters(v[key]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%q]", key), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSsmDocuments(v []types.SsmDocument) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SsmDocuments"}
	for i := range v {
		if err := validateSsmDocument(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSsmParameterStoreParameter(v *types.SsmParameterStoreParameter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SsmParameterStoreParameter"}
	if len(v.ParameterType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ParameterType"))
	}
	if v.ParameterName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ParameterName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSsmParameterStoreParameters(v []types.SsmParameterStoreParameter) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SsmParameterStoreParameters"}
	for i := range v {
		if err := validateSsmParameterStoreParameter(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpArchiveApplicationInput(v *ArchiveApplicationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ArchiveApplicationInput"}
	if v.ApplicationID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpArchiveWaveInput(v *ArchiveWaveInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ArchiveWaveInput"}
	if v.WaveID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("WaveID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAssociateApplicationsInput(v *AssociateApplicationsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AssociateApplicationsInput"}
	if v.WaveID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("WaveID"))
	}
	if v.ApplicationIDs == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationIDs"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpAssociateSourceServersInput(v *AssociateSourceServersInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "AssociateSourceServersInput"}
	if v.ApplicationID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationID"))
	}
	if v.SourceServerIDs == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceServerIDs"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpChangeServerLifeCycleStateInput(v *ChangeServerLifeCycleStateInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ChangeServerLifeCycleStateInput"}
	if v.SourceServerID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceServerID"))
	}
	if v.LifeCycle == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LifeCycle"))
	} else if v.LifeCycle != nil {
		if err := validateChangeServerLifeCycleStateSourceServerLifecycle(v.LifeCycle); err != nil {
			invalidParams.AddNested("LifeCycle", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateApplicationInput(v *CreateApplicationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateApplicationInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateLaunchConfigurationTemplateInput(v *CreateLaunchConfigurationTemplateInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateLaunchConfigurationTemplateInput"}
	if v.PostLaunchActions != nil {
		if err := validatePostLaunchActions(v.PostLaunchActions); err != nil {
			invalidParams.AddNested("PostLaunchActions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateReplicationConfigurationTemplateInput(v *CreateReplicationConfigurationTemplateInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateReplicationConfigurationTemplateInput"}
	if v.StagingAreaSubnetId == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StagingAreaSubnetId"))
	}
	if v.AssociateDefaultSecurityGroup == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AssociateDefaultSecurityGroup"))
	}
	if v.ReplicationServersSecurityGroupsIDs == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ReplicationServersSecurityGroupsIDs"))
	}
	if v.ReplicationServerInstanceType == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ReplicationServerInstanceType"))
	}
	if v.UseDedicatedReplicationServer == nil {
		invalidParams.Add(smithy.NewErrParamRequired("UseDedicatedReplicationServer"))
	}
	if len(v.DefaultLargeStagingDiskType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("DefaultLargeStagingDiskType"))
	}
	if len(v.EbsEncryption) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("EbsEncryption"))
	}
	if len(v.DataPlaneRouting) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("DataPlaneRouting"))
	}
	if v.CreatePublicIP == nil {
		invalidParams.Add(smithy.NewErrParamRequired("CreatePublicIP"))
	}
	if v.StagingAreaTags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("StagingAreaTags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateWaveInput(v *CreateWaveInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateWaveInput"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteApplicationInput(v *DeleteApplicationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteApplicationInput"}
	if v.ApplicationID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteJobInput(v *DeleteJobInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteJobInput"}
	if v.JobID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteLaunchConfigurationTemplateInput(v *DeleteLaunchConfigurationTemplateInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteLaunchConfigurationTemplateInput"}
	if v.LaunchConfigurationTemplateID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LaunchConfigurationTemplateID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteReplicationConfigurationTemplateInput(v *DeleteReplicationConfigurationTemplateInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteReplicationConfigurationTemplateInput"}
	if v.ReplicationConfigurationTemplateID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ReplicationConfigurationTemplateID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteSourceServerInput(v *DeleteSourceServerInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteSourceServerInput"}
	if v.SourceServerID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceServerID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteVcenterClientInput(v *DeleteVcenterClientInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteVcenterClientInput"}
	if v.VcenterClientID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("VcenterClientID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteWaveInput(v *DeleteWaveInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteWaveInput"}
	if v.WaveID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("WaveID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDescribeJobLogItemsInput(v *DescribeJobLogItemsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DescribeJobLogItemsInput"}
	if v.JobID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("JobID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDisassociateApplicationsInput(v *DisassociateApplicationsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DisassociateApplicationsInput"}
	if v.WaveID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("WaveID"))
	}
	if v.ApplicationIDs == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationIDs"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDisassociateSourceServersInput(v *DisassociateSourceServersInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DisassociateSourceServersInput"}
	if v.ApplicationID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationID"))
	}
	if v.SourceServerIDs == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceServerIDs"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDisconnectFromServiceInput(v *DisconnectFromServiceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DisconnectFromServiceInput"}
	if v.SourceServerID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceServerID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpFinalizeCutoverInput(v *FinalizeCutoverInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "FinalizeCutoverInput"}
	if v.SourceServerID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceServerID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetLaunchConfigurationInput(v *GetLaunchConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetLaunchConfigurationInput"}
	if v.SourceServerID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceServerID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetReplicationConfigurationInput(v *GetReplicationConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetReplicationConfigurationInput"}
	if v.SourceServerID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceServerID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListSourceServerActionsInput(v *ListSourceServerActionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListSourceServerActionsInput"}
	if v.SourceServerID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceServerID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTemplateActionsInput(v *ListTemplateActionsInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTemplateActionsInput"}
	if v.LaunchConfigurationTemplateID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LaunchConfigurationTemplateID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpMarkAsArchivedInput(v *MarkAsArchivedInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "MarkAsArchivedInput"}
	if v.SourceServerID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceServerID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutSourceServerActionInput(v *PutSourceServerActionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutSourceServerActionInput"}
	if v.SourceServerID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceServerID"))
	}
	if v.ActionName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionName"))
	}
	if v.DocumentIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DocumentIdentifier"))
	}
	if v.ActionID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionID"))
	}
	if v.Parameters != nil {
		if err := validateSsmDocumentParameters(v.Parameters); err != nil {
			invalidParams.AddNested("Parameters", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpPutTemplateActionInput(v *PutTemplateActionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PutTemplateActionInput"}
	if v.LaunchConfigurationTemplateID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LaunchConfigurationTemplateID"))
	}
	if v.ActionName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionName"))
	}
	if v.DocumentIdentifier == nil {
		invalidParams.Add(smithy.NewErrParamRequired("DocumentIdentifier"))
	}
	if v.ActionID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionID"))
	}
	if v.Parameters != nil {
		if err := validateSsmDocumentParameters(v.Parameters); err != nil {
			invalidParams.AddNested("Parameters", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRemoveSourceServerActionInput(v *RemoveSourceServerActionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RemoveSourceServerActionInput"}
	if v.SourceServerID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceServerID"))
	}
	if v.ActionID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRemoveTemplateActionInput(v *RemoveTemplateActionInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RemoveTemplateActionInput"}
	if v.LaunchConfigurationTemplateID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LaunchConfigurationTemplateID"))
	}
	if v.ActionID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ActionID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRetryDataReplicationInput(v *RetryDataReplicationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RetryDataReplicationInput"}
	if v.SourceServerID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceServerID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartCutoverInput(v *StartCutoverInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartCutoverInput"}
	if v.SourceServerIDs == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceServerIDs"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartReplicationInput(v *StartReplicationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartReplicationInput"}
	if v.SourceServerID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceServerID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpStartTestInput(v *StartTestInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StartTestInput"}
	if v.SourceServerIDs == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceServerIDs"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTerminateTargetInstancesInput(v *TerminateTargetInstancesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TerminateTargetInstancesInput"}
	if v.SourceServerIDs == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceServerIDs"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUnarchiveApplicationInput(v *UnarchiveApplicationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UnarchiveApplicationInput"}
	if v.ApplicationID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUnarchiveWaveInput(v *UnarchiveWaveInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UnarchiveWaveInput"}
	if v.WaveID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("WaveID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.TagKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TagKeys"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateApplicationInput(v *UpdateApplicationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateApplicationInput"}
	if v.ApplicationID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ApplicationID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateLaunchConfigurationInput(v *UpdateLaunchConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateLaunchConfigurationInput"}
	if v.SourceServerID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceServerID"))
	}
	if v.PostLaunchActions != nil {
		if err := validatePostLaunchActions(v.PostLaunchActions); err != nil {
			invalidParams.AddNested("PostLaunchActions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateLaunchConfigurationTemplateInput(v *UpdateLaunchConfigurationTemplateInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateLaunchConfigurationTemplateInput"}
	if v.LaunchConfigurationTemplateID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("LaunchConfigurationTemplateID"))
	}
	if v.PostLaunchActions != nil {
		if err := validatePostLaunchActions(v.PostLaunchActions); err != nil {
			invalidParams.AddNested("PostLaunchActions", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateReplicationConfigurationInput(v *UpdateReplicationConfigurationInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateReplicationConfigurationInput"}
	if v.SourceServerID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceServerID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateReplicationConfigurationTemplateInput(v *UpdateReplicationConfigurationTemplateInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateReplicationConfigurationTemplateInput"}
	if v.ReplicationConfigurationTemplateID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ReplicationConfigurationTemplateID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateSourceServerReplicationTypeInput(v *UpdateSourceServerReplicationTypeInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateSourceServerReplicationTypeInput"}
	if v.SourceServerID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceServerID"))
	}
	if len(v.ReplicationType) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ReplicationType"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateWaveInput(v *UpdateWaveInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateWaveInput"}
	if v.WaveID == nil {
		invalidParams.Add(smithy.NewErrParamRequired("WaveID"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
