// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Describes an access key for an Amazon Lightsail bucket. Access keys grant full
// programmatic access to the specified bucket and its objects. You can have a
// maximum of two access keys per bucket. Use the CreateBucketAccessKey
// (https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateBucketAccessKey.html)
// action to create an access key for a specific bucket. For more information about
// access keys, see Creating access keys for a bucket in Amazon Lightsail
// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-creating-bucket-access-keys)
// in the Amazon Lightsail Developer Guide. The secretAccessKey value is returned
// only in response to the CreateBucketAccessKey action. You can get a secret
// access key only when you first create an access key; you cannot get the secret
// access key later. If you lose the secret access key, you must create a new
// access key.
type AccessKey struct {

	// The ID of the access key.
	AccessKeyId *string

	// The timestamp when the access key was created.
	CreatedAt *time.Time

	// An object that describes the last time the access key was used. This object does
	// not include data in the response of a CreateBucketAccessKey
	// (https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateBucketAccessKey.html)
	// action. If the access key has not been used, the region and serviceName values
	// are N/A, and the lastUsedDate value is null.
	LastUsed *AccessKeyLastUsed

	// The secret access key used to sign requests. You should store the secret access
	// key in a safe location. We recommend that you delete the access key if the
	// secret access key is compromised.
	SecretAccessKey *string

	// The status of the access key. A status of Active means that the key is valid,
	// while Inactive means it is not.
	Status StatusType

	noSmithyDocumentSerde
}

// Describes the last time an access key was used. This object does not include
// data in the response of a CreateBucketAccessKey
// (https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_CreateBucketAccessKey.html)
// action.
type AccessKeyLastUsed struct {

	// The date and time when the access key was most recently used. This value is null
	// if the access key has not been used.
	LastUsedDate *time.Time

	// The Amazon Web Services Region where this access key was most recently used.
	// This value is N/A if the access key has not been used.
	Region *string

	// The name of the Amazon Web Services service with which this access key was most
	// recently used. This value is N/A if the access key has not been used.
	ServiceName *string

	noSmithyDocumentSerde
}

// Describes the anonymous access permissions for an Amazon Lightsail bucket and
// its objects. For more information about bucket access permissions, see
// Understanding bucket permissions in Amazon Lightsail
// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-understanding-bucket-permissions)
// in the Amazon Lightsail Developer Guide.
type AccessRules struct {

	// A Boolean value that indicates whether the access control list (ACL) permissions
	// that are applied to individual objects override the getObject option that is
	// currently specified. When this is true, you can use the PutObjectAcl
	// (https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectAcl.html) Amazon
	// S3 API action to set individual objects to public (read-only) using the
	// public-read ACL, or to private using the private ACL.
	AllowPublicOverrides *bool

	// Specifies the anonymous access to all objects in a bucket. The following options
	// can be specified:
	//
	// * public - Sets all objects in the bucket to public
	// (read-only), making them readable by anyone in the world. If the getObject value
	// is set to public, then all objects in the bucket default to public regardless of
	// the allowPublicOverrides value.
	//
	// * private - Sets all objects in the bucket to
	// private, making them readable only by you or anyone you give access to. If the
	// getObject value is set to private, and the allowPublicOverrides value is set to
	// true, then all objects in the bucket default to private unless they are
	// configured with a public-read ACL. Individual objects with a public-read ACL are
	// readable by anyone in the world.
	GetObject AccessType

	noSmithyDocumentSerde
}

// Describes the synchronization status of the Amazon Simple Storage Service
// (Amazon S3) account-level block public access (BPA) feature for your Lightsail
// buckets. The account-level BPA feature of Amazon S3 provides centralized
// controls to limit public access to all Amazon S3 buckets in an account. BPA can
// make all Amazon S3 buckets in an Amazon Web Services account private regardless
// of the individual bucket and object permissions that are configured. Lightsail
// buckets take into account the Amazon S3 account-level BPA configuration when
// allowing or denying public access. To do this, Lightsail periodically fetches
// the account-level BPA configuration from Amazon S3. When the account-level BPA
// status is InSync, the Amazon S3 account-level BPA configuration is synchronized
// and it applies to your Lightsail buckets. For more information about Amazon
// Simple Storage Service account-level BPA and how it affects Lightsail buckets,
// see Block public access for buckets in Amazon Lightsail
// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-block-public-access-for-buckets)
// in the Amazon Lightsail Developer Guide.
type AccountLevelBpaSync struct {

	// A Boolean value that indicates whether account-level block public access is
	// affecting your Lightsail buckets.
	BpaImpactsLightsail *bool

	// The timestamp of when the account-level BPA configuration was last synchronized.
	// This value is null when the account-level BPA configuration has not been
	// synchronized.
	LastSyncedAt *time.Time

	// A message that provides a reason for a Failed or Defaulted synchronization
	// status. The following messages are possible:
	//
	// * SYNC_ON_HOLD - The
	// synchronization has not yet happened. This status message occurs immediately
	// after you create your first Lightsail bucket. This status message should change
	// after the first synchronization happens, approximately 1 hour after the first
	// bucket is created.
	//
	// * DEFAULTED_FOR_SLR_MISSING - The synchronization failed
	// because the required service-linked role is missing from your Amazon Web
	// Services account. The account-level BPA configuration for your Lightsail buckets
	// is defaulted to active until the synchronization can occur. This means that all
	// your buckets are private and not publicly accessible. For more information about
	// how to create the required service-linked role to allow synchronization, see
	// Using Service-Linked Roles for Amazon Lightsail
	// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-using-service-linked-roles)
	// in the Amazon Lightsail Developer Guide.
	//
	// * DEFAULTED_FOR_SLR_MISSING_ON_HOLD -
	// The synchronization failed because the required service-linked role is missing
	// from your Amazon Web Services account. Account-level BPA is not yet configured
	// for your Lightsail buckets. Therefore, only the bucket access permissions and
	// individual object access permissions apply to your Lightsail buckets. For more
	// information about how to create the required service-linked role to allow
	// synchronization, see Using Service-Linked Roles for Amazon Lightsail
	// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-using-service-linked-roles)
	// in the Amazon Lightsail Developer Guide.
	//
	// * Unknown - The reason that
	// synchronization failed is unknown. Contact Amazon Web Services Support for more
	// information.
	Message BPAStatusMessage

	// The status of the account-level BPA synchronization. The following statuses are
	// possible:
	//
	// * InSync - Account-level BPA is synchronized. The Amazon S3
	// account-level BPA configuration applies to your Lightsail buckets.
	//
	// *
	// NeverSynced - Synchronization has not yet happened. The Amazon S3 account-level
	// BPA configuration does not apply to your Lightsail buckets.
	//
	// * Failed -
	// Synchronization failed. The Amazon S3 account-level BPA configuration does not
	// apply to your Lightsail buckets.
	//
	// * Defaulted - Synchronization failed and
	// account-level BPA for your Lightsail buckets is defaulted to active.
	//
	// You might
	// need to complete further actions if the status is Failed or Defaulted. The
	// message parameter provides more information for those statuses.
	Status AccountLevelBpaSyncStatus

	noSmithyDocumentSerde
}

// Describes an add-on that is enabled for an Amazon Lightsail resource.
type AddOn struct {

	// The name of the add-on.
	Name *string

	// The next daily time an automatic snapshot will be created. The time shown is in
	// HH:00 format, and in Coordinated Universal Time (UTC). The snapshot is
	// automatically created between the time shown and up to 45 minutes after.
	NextSnapshotTimeOfDay *string

	// The daily time when an automatic snapshot is created. The time shown is in HH:00
	// format, and in Coordinated Universal Time (UTC). The snapshot is automatically
	// created between the time shown and up to 45 minutes after.
	SnapshotTimeOfDay *string

	// The status of the add-on.
	Status *string

	noSmithyDocumentSerde
}

// Describes a request to enable, modify, or disable an add-on for an Amazon
// Lightsail resource. An additional cost may be associated with enabling add-ons.
// For more information, see the Lightsail pricing page
// (https://aws.amazon.com/lightsail/pricing/).
type AddOnRequest struct {

	// The add-on type.
	//
	// This member is required.
	AddOnType AddOnType

	// An object that represents additional parameters when enabling or modifying the
	// automatic snapshot add-on.
	AutoSnapshotAddOnRequest *AutoSnapshotAddOnRequest

	noSmithyDocumentSerde
}

// Describes an alarm. An alarm is a way to monitor your Lightsail resource
// metrics. For more information, see Alarms in Amazon Lightsail
// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms).
type Alarm struct {

	// The Amazon Resource Name (ARN) of the alarm.
	Arn *string

	// The arithmetic operation used when comparing the specified statistic and
	// threshold.
	ComparisonOperator ComparisonOperator

	// The contact protocols for the alarm, such as Email, SMS (text messaging), or
	// both.
	ContactProtocols []ContactProtocol

	// The timestamp when the alarm was created.
	CreatedAt *time.Time

	// The number of data points that must not within the specified threshold to
	// trigger the alarm.
	DatapointsToAlarm *int32

	// The number of periods over which data is compared to the specified threshold.
	EvaluationPeriods *int32

	// An object that lists information about the location of the alarm.
	Location *ResourceLocation

	// The name of the metric associated with the alarm.
	MetricName MetricName

	// An object that lists information about the resource monitored by the alarm.
	MonitoredResourceInfo *MonitoredResourceInfo

	// The name of the alarm.
	Name *string

	// Indicates whether the alarm is enabled.
	NotificationEnabled *bool

	// The alarm states that trigger a notification.
	NotificationTriggers []AlarmState

	// The period, in seconds, over which the statistic is applied.
	Period int32

	// The Lightsail resource type (e.g., Alarm).
	ResourceType ResourceType

	// The current state of the alarm. An alarm has the following possible states:
	//
	// *
	// ALARM - The metric is outside of the defined threshold.
	//
	// * INSUFFICIENT_DATA -
	// The alarm has just started, the metric is not available, or not enough data is
	// available for the metric to determine the alarm state.
	//
	// * OK - The metric is
	// within the defined threshold.
	State AlarmState

	// The statistic for the metric associated with the alarm. The following statistics
	// are available:
	//
	// * Minimum - The lowest value observed during the specified
	// period. Use this value to determine low volumes of activity for your
	// application.
	//
	// * Maximum - The highest value observed during the specified
	// period. Use this value to determine high volumes of activity for your
	// application.
	//
	// * Sum - All values submitted for the matching metric added
	// together. You can use this statistic to determine the total volume of a
	// metric.
	//
	// * Average - The value of Sum / SampleCount during the specified period.
	// By comparing this statistic with the Minimum and Maximum values, you can
	// determine the full scope of a metric and how close the average use is to the
	// Minimum and Maximum values. This comparison helps you to know when to increase
	// or decrease your resources.
	//
	// * SampleCount - The count, or number, of data
	// points used for the statistical calculation.
	Statistic MetricStatistic

	// The support code. Include this code in your email to support when you have
	// questions about your Lightsail alarm. This code enables our support team to look
	// up your Lightsail information more easily.
	SupportCode *string

	// The value against which the specified statistic is compared.
	Threshold *float64

	// Specifies how the alarm handles missing data points. An alarm can treat missing
	// data in the following ways:
	//
	// * breaching - Assume the missing data is not within
	// the threshold. Missing data counts towards the number of times the metric is not
	// within the threshold.
	//
	// * notBreaching - Assume the missing data is within the
	// threshold. Missing data does not count towards the number of times the metric is
	// not within the threshold.
	//
	// * ignore - Ignore the missing data. Maintains the
	// current alarm state.
	//
	// * missing - Missing data is treated as missing.
	TreatMissingData TreatMissingData

	// The unit of the metric associated with the alarm.
	Unit MetricUnit

	noSmithyDocumentSerde
}

// Describes a block storage disk that is attached to an instance, and is included
// in an automatic snapshot.
type AttachedDisk struct {

	// The path of the disk (e.g., /dev/xvdf).
	Path *string

	// The size of the disk in GB.
	SizeInGb *int32

	noSmithyDocumentSerde
}

// Describes a request to enable or modify the automatic snapshot add-on for an
// Amazon Lightsail instance or disk. When you modify the automatic snapshot time
// for a resource, it is typically effective immediately except under the following
// conditions:
//
// * If an automatic snapshot has been created for the current day,
// and you change the snapshot time to a later time of day, then the new snapshot
// time will be effective the following day. This ensures that two snapshots are
// not created for the current day.
//
// * If an automatic snapshot has not yet been
// created for the current day, and you change the snapshot time to an earlier time
// of day, then the new snapshot time will be effective the following day and a
// snapshot is automatically created at the previously set time for the current
// day. This ensures that a snapshot is created for the current day.
//
// * If an
// automatic snapshot has not yet been created for the current day, and you change
// the snapshot time to a time that is within 30 minutes from your current time,
// then the new snapshot time will be effective the following day and a snapshot is
// automatically created at the previously set time for the current day. This
// ensures that a snapshot is created for the current day, because 30 minutes is
// required between your current time and the new snapshot time that you
// specify.
//
// * If an automatic snapshot is scheduled to be created within 30
// minutes from your current time and you change the snapshot time, then the new
// snapshot time will be effective the following day and a snapshot is
// automatically created at the previously set time for the current day. This
// ensures that a snapshot is created for the current day, because 30 minutes is
// required between your current time and the new snapshot time that you specify.
type AutoSnapshotAddOnRequest struct {

	// The daily time when an automatic snapshot will be created. Constraints:
	//
	// * Must
	// be in HH:00 format, and in an hourly increment.
	//
	// * Specified in Coordinated
	// Universal Time (UTC).
	//
	// * The snapshot will be automatically created between the
	// time specified and up to 45 minutes after.
	SnapshotTimeOfDay *string

	noSmithyDocumentSerde
}

// Describes an automatic snapshot.
type AutoSnapshotDetails struct {

	// The timestamp when the automatic snapshot was created.
	CreatedAt *time.Time

	// The date of the automatic snapshot in YYYY-MM-DD format.
	Date *string

	// An array of objects that describe the block storage disks attached to the
	// instance when the automatic snapshot was created.
	FromAttachedDisks []AttachedDisk

	// The status of the automatic snapshot.
	Status AutoSnapshotStatus

	noSmithyDocumentSerde
}

// Describes an Availability Zone. This is returned only as part of a GetRegions
// request.
type AvailabilityZone struct {

	// The state of the Availability Zone.
	State *string

	// The name of the Availability Zone. The format is us-east-2a (case-sensitive).
	ZoneName *string

	noSmithyDocumentSerde
}

// Describes a blueprint (a virtual private server image).
type Blueprint struct {

	// The ID for the virtual private server image (e.g., app_wordpress_4_4 or
	// app_lamp_7_0).
	BlueprintId *string

	// The description of the blueprint.
	Description *string

	// The group name of the blueprint (e.g., amazon-linux).
	Group *string

	// A Boolean value indicating whether the blueprint is active. Inactive blueprints
	// are listed to support customers with existing instances but are not necessarily
	// available for launch of new instances. Blueprints are marked inactive when they
	// become outdated due to operating system updates or new application releases.
	IsActive *bool

	// The end-user license agreement URL for the image or blueprint.
	LicenseUrl *string

	// The minimum bundle power required to run this blueprint. For example, you need a
	// bundle with a power value of 500 or more to create an instance that uses a
	// blueprint with a minimum power value of 500. 0 indicates that the blueprint runs
	// on all instance sizes.
	MinPower *int32

	// The friendly name of the blueprint (e.g., Amazon Linux).
	Name *string

	// The operating system platform (either Linux/Unix-based or Windows Server-based)
	// of the blueprint.
	Platform InstancePlatform

	// The product URL to learn more about the image or blueprint.
	ProductUrl *string

	// The type of the blueprint (e.g., os or app).
	Type BlueprintType

	// The version number of the operating system, application, or stack (e.g.,
	// 2016.03.0).
	Version *string

	// The version code.
	VersionCode *string

	noSmithyDocumentSerde
}

// Describes an Amazon Lightsail bucket.
type Bucket struct {

	// Indicates whether the bundle that is currently applied to a bucket can be
	// changed to another bundle. You can update a bucket's bundle only one time within
	// a monthly Amazon Web Services billing cycle. Use the UpdateBucketBundle
	// (https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_UpdateBucketBundle.html)
	// action to change a bucket's bundle.
	AbleToUpdateBundle *bool

	// An object that describes the access log configuration for the bucket.
	AccessLogConfig *BucketAccessLogConfig

	// An object that describes the access rules of the bucket.
	AccessRules *AccessRules

	// The Amazon Resource Name (ARN) of the bucket.
	Arn *string

	// The ID of the bundle currently applied to the bucket. A bucket bundle specifies
	// the monthly cost, storage space, and data transfer quota for a bucket. Use the
	// UpdateBucketBundle
	// (https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_UpdateBucketBundle.html)
	// action to change the bundle of a bucket.
	BundleId *string

	// The timestamp when the distribution was created.
	CreatedAt *time.Time

	// An object that describes the location of the bucket, such as the Amazon Web
	// Services Region and Availability Zone.
	Location *ResourceLocation

	// The name of the bucket.
	Name *string

	// Indicates whether object versioning is enabled for the bucket. The following
	// options can be configured:
	//
	// * Enabled - Object versioning is enabled.
	//
	// *
	// Suspended - Object versioning was previously enabled but is currently suspended.
	// Existing object versions are retained.
	//
	// * NeverEnabled - Object versioning has
	// never been enabled.
	ObjectVersioning *string

	// An array of strings that specify the Amazon Web Services account IDs that have
	// read-only access to the bucket.
	ReadonlyAccessAccounts []string

	// The Lightsail resource type of the bucket (for example, Bucket).
	ResourceType *string

	// An array of objects that describe Lightsail instances that have access to the
	// bucket. Use the SetResourceAccessForBucket
	// (https://docs.aws.amazon.com/lightsail/2016-11-28/api-reference/API_SetResourceAccessForBucket.html)
	// action to update the instances that have access to a bucket.
	ResourcesReceivingAccess []ResourceReceivingAccess

	// An object that describes the state of the bucket.
	State *BucketState

	// The support code for a bucket. Include this code in your email to support when
	// you have questions about a Lightsail bucket. This code enables our support team
	// to look up your Lightsail information more easily.
	SupportCode *string

	// The tag keys and optional values for the bucket. For more information, see Tags
	// in Amazon Lightsail
	// (https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-tags) in
	// the Amazon Lightsail Developer Guide.
	Tags []Tag

	// The URL of the bucket.
	Url *string

	noSmithyDocumentSerde
}

// Describes the access log configuration for a bucket in the Amazon Lightsail
// object storage service. For more information about bucket access logs, see
// Logging bucket requests using access logging in Amazon Lightsail
// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-bucket-access-logs)
// in the Amazon Lightsail Developer Guide.
type BucketAccessLogConfig struct {

	// A Boolean value that indicates whether bucket access logging is enabled for the
	// bucket.
	//
	// This member is required.
	Enabled *bool

	// The name of the bucket where the access logs are saved. The destination can be a
	// Lightsail bucket in the same account, and in the same Amazon Web Services Region
	// as the source bucket. This parameter is required when enabling the access log
	// for a bucket, and should be omitted when disabling the access log.
	Destination *string

	// The optional object prefix for the bucket access log. The prefix is an optional
	// addition to the object key that organizes your access log files in the
	// destination bucket. For example, if you specify a logs/ prefix, then each log
	// object will begin with the logs/ prefix in its key (for example,
	// logs/2021-11-01-21-32-16-E568B2907131C0C0). This parameter can be optionally
	// specified when enabling the access log for a bucket, and should be omitted when
	// disabling the access log.
	Prefix *string

	noSmithyDocumentSerde
}

// Describes the specifications of a bundle that can be applied to an Amazon
// Lightsail bucket. A bucket bundle specifies the monthly cost, storage space, and
// data transfer quota for a bucket.
type BucketBundle struct {

	// The ID of the bundle.
	BundleId *string

	// Indicates whether the bundle is active. Use for a new or existing bucket.
	IsActive *bool

	// The name of the bundle.
	Name *string

	// The monthly price of the bundle, in US dollars.
	Price *float32

	// The storage size of the bundle, in GB.
	StoragePerMonthInGb *int32

	// The monthly network transfer quota of the bundle.
	TransferPerMonthInGb *int32

	noSmithyDocumentSerde
}

// Describes the state of an Amazon Lightsail bucket.
type BucketState struct {

	// The state code of the bucket. The following codes are possible:
	//
	// * OK - The
	// bucket is in a running state.
	//
	// * Unknown - Creation of the bucket might have
	// timed-out. You might want to delete the bucket and create a new one.
	Code *string

	// A message that describes the state of the bucket.
	Message *string

	noSmithyDocumentSerde
}

// Describes a bundle, which is a set of specs describing your virtual private
// server (or instance).
type Bundle struct {

	// The bundle ID (e.g., micro_1_0).
	BundleId *string

	// The number of vCPUs included in the bundle (e.g., 2).
	CpuCount *int32

	// The size of the SSD (e.g., 30).
	DiskSizeInGb *int32

	// The Amazon EC2 instance type (e.g., t2.micro).
	InstanceType *string

	// A Boolean value indicating whether the bundle is active.
	IsActive *bool

	// A friendly name for the bundle (e.g., Micro).
	Name *string

	// A numeric value that represents the power of the bundle (e.g., 500). You can use
	// the bundle's power value in conjunction with a blueprint's minimum power value
	// to determine whether the blueprint will run on the bundle. For example, you need
	// a bundle with a power value of 500 or more to create an instance that uses a
	// blueprint with a minimum power value of 500.
	Power *int32

	// The price in US dollars (e.g., 5.0) of the bundle.
	Price *float32

	// The amount of RAM in GB (e.g., 2.0).
	RamSizeInGb *float32

	// The operating system platform (Linux/Unix-based or Windows Server-based) that
	// the bundle supports. You can only launch a WINDOWS bundle on a blueprint that
	// supports the WINDOWS platform. LINUX_UNIX blueprints require a LINUX_UNIX
	// bundle.
	SupportedPlatforms []InstancePlatform

	// The data transfer rate per month in GB (e.g., 2000).
	TransferPerMonthInGb *int32

	noSmithyDocumentSerde
}

// Describes the default cache behavior of an Amazon Lightsail content delivery
// network (CDN) distribution.
type CacheBehavior struct {

	// The cache behavior of the distribution. The following cache behaviors can be
	// specified:
	//
	// * cache - This option is best for static sites. When specified, your
	// distribution caches and serves your entire website as static content. This
	// behavior is ideal for websites with static content that doesn't change depending
	// on who views it, or for websites that don't use cookies, headers, or query
	// strings to personalize content.
	//
	// * dont-cache - This option is best for sites
	// that serve a mix of static and dynamic content. When specified, your
	// distribution caches and serve only the content that is specified in the
	// distribution's CacheBehaviorPerPath parameter. This behavior is ideal for
	// websites or web applications that use cookies, headers, and query strings to
	// personalize content for individual users.
	Behavior BehaviorEnum

	noSmithyDocumentSerde
}

// Describes the per-path cache behavior of an Amazon Lightsail content delivery
// network (CDN) distribution. A per-path cache behavior is used to override, or
// add an exception to, the default cache behavior of a distribution. For example,
// if the cacheBehavior is set to cache, then a per-path cache behavior can be used
// to specify a directory, file, or file type that your distribution will cache.
// Alternately, if the distribution's cacheBehavior is dont-cache, then a per-path
// cache behavior can be used to specify a directory, file, or file type that your
// distribution will not cache.
type CacheBehaviorPerPath struct {

	// The cache behavior for the specified path. You can specify one of the following
	// per-path cache behaviors:
	//
	// * cache - This behavior caches the specified path.
	//
	// *
	// dont-cache - This behavior doesn't cache the specified path.
	Behavior BehaviorEnum

	// The path to a directory or file to cached, or not cache. Use an asterisk symbol
	// to specify wildcard directories (path/to/assets/*), and file types (*.html,
	// *jpg, *js). Directories and file paths are case-sensitive. Examples:
	//
	// * Specify
	// the following to cache all files in the document root of an Apache web server
	// running on a Lightsail instance. var/www/html/
	//
	// * Specify the following file to
	// cache only the index page in the document root of an Apache web server.
	// var/www/html/index.html
	//
	// * Specify the following to cache only the .html files
	// in the document root of an Apache web server. var/www/html/*.html
	//
	// * Specify the
	// following to cache only the .jpg, .png, and .gif files in the images
	// sub-directory of the document root of an Apache web server.
	// var/www/html/images/*.jpgvar/www/html/images/*.pngvar/www/html/images/*.gif
	// Specify the following to cache all files in the images sub-directory of the
	// document root of an Apache web server. var/www/html/images/
	Path *string

	noSmithyDocumentSerde
}

// Describes the cache settings of an Amazon Lightsail content delivery network
// (CDN) distribution. These settings apply only to your distribution's
// cacheBehaviors (including the defaultCacheBehavior) that have a behavior of
// cache.
type CacheSettings struct {

	// The HTTP methods that are processed and forwarded to the distribution's origin.
	// You can specify the following options:
	//
	// * GET,HEAD - The distribution forwards
	// the GET and HEAD methods.
	//
	// * GET,HEAD,OPTIONS - The distribution forwards the
	// GET, HEAD, and OPTIONS methods.
	//
	// * GET,HEAD,OPTIONS,PUT,PATCH,POST,DELETE - The
	// distribution forwards the GET, HEAD, OPTIONS, PUT, PATCH, POST, and DELETE
	// methods.
	//
	// If you specify the third option, you might need to restrict access to
	// your distribution's origin so users can't perform operations that you don't want
	// them to. For example, you might not want users to have permission to delete
	// objects from your origin.
	AllowedHTTPMethods *string

	// The HTTP method responses that are cached by your distribution. You can specify
	// the following options:
	//
	// * GET,HEAD - The distribution caches responses to the
	// GET and HEAD methods.
	//
	// * GET,HEAD,OPTIONS - The distribution caches responses to
	// the GET, HEAD, and OPTIONS methods.
	CachedHTTPMethods *string

	// The default amount of time that objects stay in the distribution's cache before
	// the distribution forwards another request to the origin to determine whether the
	// content has been updated. The value specified applies only when the origin does
	// not add HTTP headers such as Cache-Control max-age, Cache-Control s-maxage, and
	// Expires to objects.
	DefaultTTL *int64

	// An object that describes the cookies that are forwarded to the origin. Your
	// content is cached based on the cookies that are forwarded.
	ForwardedCookies *CookieObject

	// An object that describes the headers that are forwarded to the origin. Your
	// content is cached based on the headers that are forwarded.
	ForwardedHeaders *HeaderObject

	// An object that describes the query strings that are forwarded to the origin.
	// Your content is cached based on the query strings that are forwarded.
	ForwardedQueryStrings *QueryStringObject

	// The maximum amount of time that objects stay in the distribution's cache before
	// the distribution forwards another request to the origin to determine whether the
	// object has been updated. The value specified applies only when the origin adds
	// HTTP headers such as Cache-Control max-age, Cache-Control s-maxage, and Expires
	// to objects.
	MaximumTTL *int64

	// The minimum amount of time that objects stay in the distribution's cache before
	// the distribution forwards another request to the origin to determine whether the
	// object has been updated. A value of 0 must be specified for minimumTTL if the
	// distribution is configured to forward all headers to the origin.
	MinimumTTL *int64

	noSmithyDocumentSerde
}

// Describes the full details of an Amazon Lightsail SSL/TLS certificate. To get a
// summary of a certificate, use the GetCertificates action and ommit
// includeCertificateDetails from your request. The response will include only the
// certificate Amazon Resource Name (ARN), certificate name, domain name, and tags.
type Certificate struct {

	// The Amazon Resource Name (ARN) of the certificate.
	Arn *string

	// The timestamp when the certificate was created.
	CreatedAt *time.Time

	// The domain name of the certificate.
	DomainName *string

	// An array of objects that describe the domain validation records of the
	// certificate.
	DomainValidationRecords []DomainValidationRecord

	// The renewal eligibility of the certificate.
	EligibleToRenew *string

	// The number of Lightsail resources that the certificate is attached to.
	InUseResourceCount int32

	// The timestamp when the certificate was issued.
	IssuedAt *time.Time

	// The certificate authority that issued the certificate.
	IssuerCA *string

	// The algorithm used to generate the key pair (the public and private key) of the
	// certificate.
	KeyAlgorithm *string

	// The name of the certificate (e.g., my-certificate).
	Name *string

	// The timestamp when the certificate expires.
	NotAfter *time.Time

	// The timestamp when the certificate is first valid.
	NotBefore *time.Time

	// An object that describes the status of the certificate renewal managed by
	// Lightsail.
	RenewalSummary *RenewalSummary

	// The validation failure reason, if any, of the certificate. The following failure
	// reasons are possible:
	//
	// * NO_AVAILABLE_CONTACTS - This failure applies to email
	// validation, which is not available for Lightsail certificates.
	//
	// *
	// ADDITIONAL_VERIFICATION_REQUIRED - Lightsail requires additional information to
	// process this certificate request. This can happen as a fraud-protection measure,
	// such as when the domain ranks within the Alexa top 1000 websites. To provide the
	// required information, use the Amazon Web Services Support Center
	// (https://console.aws.amazon.com/support/home) to contact Amazon Web Services
	// Support. You cannot request a certificate for Amazon-owned domain names such as
	// those ending in amazonaws.com, cloudfront.net, or elasticbeanstalk.com.
	//
	// *
	// DOMAIN_NOT_ALLOWED - One or more of the domain names in the certificate request
	// was reported as an unsafe domain by VirusTotal
	// (https://www.virustotal.com/gui/home/url). To correct the problem, search for
	// your domain name on the VirusTotal (https://www.virustotal.com/gui/home/url)
	// website. If your domain is reported as suspicious, see Google Help for Hacked
	// Websites (https://developers.google.com/web/fundamentals/security/hacked) to
	// learn what you can do. If you believe that the result is a false positive,
	// notify the organization that is reporting the domain. VirusTotal is an aggregate
	// of several antivirus and URL scanners and cannot remove your domain from a block
	// list itself. After you correct the problem and the VirusTotal registry has been
	// updated, request a new certificate. If you see this error and your domain is not
	// included in the VirusTotal list, visit the Amazon Web Services Support Center
	// (https://console.aws.amazon.com/support/home) and create a case.
	//
	// *
	// INVALID_PUBLIC_DOMAIN - One or more of the domain names in the certificate
	// request is not valid. Typically, this is because a domain name in the request is
	// not a valid top-level domain. Try to request a certificate again, correcting any
	// spelling errors or typos that were in the failed request, and ensure that all
	// domain names in the request are for valid top-level domains. For example, you
	// cannot request a certificate for example.invalidpublicdomain because
	// invalidpublicdomain is not a valid top-level domain.
	//
	// * OTHER - Typically, this
	// failure occurs when there is a typographical error in one or more of the domain
	// names in the certificate request. Try to request a certificate again, correcting
	// any spelling errors or typos that were in the failed request.
	RequestFailureReason *string

	// The reason the certificate was revoked. This value is present only when the
	// certificate status is REVOKED.
	RevocationReason *string

	// The timestamp when the certificate was revoked. This value is present only when
	// the certificate status is REVOKED.
	RevokedAt *time.Time

	// The serial number of the certificate.
	SerialNumber *string

	// The validation status of the certificate.
	Status CertificateStatus

	// An array of strings that specify the alternate domains (e.g., example2.com) and
	// subdomains (e.g., blog.example.com) of the certificate.
	SubjectAlternativeNames []string

	// The support code. Include this code in your email to support when you have
	// questions about your Lightsail certificate. This code enables our support team
	// to look up your Lightsail information more easily.
	SupportCode *string

	// The tag keys and optional values for the resource. For more information about
	// tags in Lightsail, see the Amazon Lightsail Developer Guide
	// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
	Tags []Tag

	noSmithyDocumentSerde
}

// Describes an Amazon Lightsail SSL/TLS certificate.
type CertificateSummary struct {

	// The Amazon Resource Name (ARN) of the certificate.
	CertificateArn *string

	// An object that describes a certificate in detail.
	CertificateDetail *Certificate

	// The name of the certificate.
	CertificateName *string

	// The domain name of the certificate.
	DomainName *string

	// The tag keys and optional values for the resource. For more information about
	// tags in Lightsail, see the Amazon Lightsail Developer Guide
	// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
	Tags []Tag

	noSmithyDocumentSerde
}

// Describes a CloudFormation stack record created as a result of the create cloud
// formation stack action. A CloudFormation stack record provides information about
// the AWS CloudFormation stack used to create a new Amazon Elastic Compute Cloud
// instance from an exported Lightsail instance snapshot.
type CloudFormationStackRecord struct {

	// The Amazon Resource Name (ARN) of the CloudFormation stack record.
	Arn *string

	// The date when the CloudFormation stack record was created.
	CreatedAt *time.Time

	// A list of objects describing the destination service, which is AWS
	// CloudFormation, and the Amazon Resource Name (ARN) of the AWS CloudFormation
	// stack.
	DestinationInfo *DestinationInfo

	// A list of objects describing the Availability Zone and Amazon Web Services
	// Region of the CloudFormation stack record.
	Location *ResourceLocation

	// The name of the CloudFormation stack record. It starts with
	// CloudFormationStackRecord followed by a GUID.
	Name *string

	// The Lightsail resource type (e.g., CloudFormationStackRecord).
	ResourceType ResourceType

	// A list of objects describing the source of the CloudFormation stack record.
	SourceInfo []CloudFormationStackRecordSourceInfo

	// The current state of the CloudFormation stack record.
	State RecordState

	noSmithyDocumentSerde
}

// Describes the source of a CloudFormation stack record (i.e., the export snapshot
// record).
type CloudFormationStackRecordSourceInfo struct {

	// The Amazon Resource Name (ARN) of the export snapshot record.
	Arn *string

	// The name of the record.
	Name *string

	// The Lightsail resource type (e.g., ExportSnapshotRecord).
	ResourceType CloudFormationStackRecordSourceType

	noSmithyDocumentSerde
}

// Describes a contact method. A contact method is a way to send you notifications.
// For more information, see Notifications in Amazon Lightsail
// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-notifications).
type ContactMethod struct {

	// The Amazon Resource Name (ARN) of the contact method.
	Arn *string

	// The destination of the contact method, such as an email address or a mobile
	// phone number.
	ContactEndpoint *string

	// The timestamp when the contact method was created.
	CreatedAt *time.Time

	// An object that describes the location of the contact method, such as the Amazon
	// Web Services Region and Availability Zone.
	Location *ResourceLocation

	// The name of the contact method.
	Name *string

	// The protocol of the contact method, such as email or SMS (text messaging).
	Protocol ContactProtocol

	// The Lightsail resource type (e.g., ContactMethod).
	ResourceType ResourceType

	// The current status of the contact method. A contact method has the following
	// possible status:
	//
	// * PendingVerification - The contact method has not yet been
	// verified, and the verification has not yet expired.
	//
	// * Valid - The contact
	// method has been verified.
	//
	// * InValid - An attempt was made to verify the contact
	// method, but the verification has expired.
	Status ContactMethodStatus

	// The support code. Include this code in your email to support when you have
	// questions about your Lightsail contact method. This code enables our support
	// team to look up your Lightsail information more easily.
	SupportCode *string

	noSmithyDocumentSerde
}

// Describes the settings of a container that will be launched, or that is
// launched, to an Amazon Lightsail container service.
type Container struct {

	// The launch command for the container.
	Command []string

	// The environment variables of the container.
	Environment map[string]string

	// The name of the image used for the container. Container images sourced from your
	// Lightsail container service, that are registered and stored on your service,
	// start with a colon (:). For example, if your container service name is
	// container-service-1, the container image label is mystaticsite, and you want to
	// use the third (3) version of the registered container image, then you should
	// specify :container-service-1.mystaticsite.3. To use the latest version of a
	// container image, specify latest instead of a version number (for example,
	// :container-service-1.mystaticsite.latest). Lightsail will automatically use the
	// highest numbered version of the registered container image. Container images
	// sourced from a public registry like Docker Hub don't start with a colon. For
	// example, nginx:latest or nginx.
	Image *string

	// The open firewall ports of the container.
	Ports map[string]ContainerServiceProtocol

	noSmithyDocumentSerde
}

// Describes a container image that is registered to an Amazon Lightsail container
// service.
type ContainerImage struct {

	// The timestamp when the container image was created.
	CreatedAt *time.Time

	// The digest of the container image.
	Digest *string

	// The name of the container image.
	Image *string

	noSmithyDocumentSerde
}

// Describes an Amazon Lightsail container service.
type ContainerService struct {

	// The Amazon Resource Name (ARN) of the container service.
	Arn *string

	// The name of the container service.
	ContainerServiceName *string

	// The timestamp when the container service was created.
	CreatedAt *time.Time

	// An object that describes the current container deployment of the container
	// service.
	CurrentDeployment *ContainerServiceDeployment

	// A Boolean value indicating whether the container service is disabled.
	IsDisabled *bool

	// An object that describes the location of the container service, such as the
	// Amazon Web Services Region and Availability Zone.
	Location *ResourceLocation

	// An object that describes the next deployment of the container service. This
	// value is null when there is no deployment in a pending state.
	NextDeployment *ContainerServiceDeployment

	// The power specification of the container service. The power specifies the amount
	// of RAM, the number of vCPUs, and the base price of the container service.
	Power ContainerServicePowerName

	// The ID of the power of the container service.
	PowerId *string

	// The principal ARN of the container service. The principal ARN can be used to
	// create a trust relationship between your standard Amazon Web Services account
	// and your Lightsail container service. This allows you to give your service
	// permission to access resources in your standard Amazon Web Services account.
	PrincipalArn *string

	// The private domain name of the container service. The private domain name is
	// accessible only by other resources within the default virtual private cloud
	// (VPC) of your Lightsail account.
	PrivateDomainName *string

	// An object that describes the configuration for the container service to access
	// private container image repositories, such as Amazon Elastic Container Registry
	// (Amazon ECR) private repositories. For more information, see Configuring access
	// to an Amazon ECR private repository for an Amazon Lightsail container service
	// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-container-service-ecr-private-repo-access)
	// in the Amazon Lightsail Developer Guide.
	PrivateRegistryAccess *PrivateRegistryAccess

	// The public domain name of the container service, such as example.com and
	// www.example.com. You can specify up to four public domain names for a container
	// service. The domain names that you specify are used when you create a deployment
	// with a container configured as the public endpoint of your container service. If
	// you don't specify public domain names, then you can use the default domain of
	// the container service. You must create and validate an SSL/TLS certificate
	// before you can use public domain names with your container service. Use the
	// CreateCertificate action to create a certificate for the public domain names you
	// want to use with your container service. See CreateContainerService or
	// UpdateContainerService for information about how to specify public domain names
	// for your Lightsail container service.
	PublicDomainNames map[string][]string

	// The Lightsail resource type of the container service (i.e., ContainerService).
	ResourceType ResourceType

	// The scale specification of the container service. The scale specifies the
	// allocated compute nodes of the container service.
	Scale *int32

	// The current state of the container service. The following container service
	// states are possible:
	//
	// * PENDING - The container service is being created.
	//
	// *
	// READY - The container service is running but it does not have an active
	// container deployment.
	//
	// * DEPLOYING - The container service is launching a
	// container deployment.
	//
	// * RUNNING - The container service is running and it has
	// an active container deployment.
	//
	// * UPDATING - The container service capacity or
	// its custom domains are being updated.
	//
	// * DELETING - The container service is
	// being deleted.
	//
	// * DISABLED - The container service is disabled, and its active
	// deployment and containers, if any, are shut down.
	State ContainerServiceState

	// An object that describes the current state of the container service. The state
	// detail is populated only when a container service is in a PENDING, DEPLOYING, or
	// UPDATING state.
	StateDetail *ContainerServiceStateDetail

	// The tag keys and optional values for the resource. For more information about
	// tags in Lightsail, see the Amazon Lightsail Developer Guide
	// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
	Tags []Tag

	// The publicly accessible URL of the container service. If no public endpoint is
	// specified in the currentDeployment, this URL returns a 404 response.
	Url *string

	noSmithyDocumentSerde
}

// Describes a container deployment configuration of an Amazon Lightsail container
// service. A deployment specifies the settings, such as the ports and launch
// command, of containers that are deployed to your container service.
type ContainerServiceDeployment struct {

	// An object that describes the configuration for the containers of the deployment.
	Containers map[string]Container

	// The timestamp when the deployment was created.
	CreatedAt *time.Time

	// An object that describes the endpoint of the deployment.
	PublicEndpoint *ContainerServiceEndpoint

	// The state of the deployment. A deployment can be in one of the following
	// states:
	//
	// * Activating - The deployment is being created.
	//
	// * Active - The
	// deployment was successfully created, and it's currently running on the container
	// service. The container service can have only one deployment in an active state
	// at a time.
	//
	// * Inactive - The deployment was previously successfully created, but
	// it is not currently running on the container service.
	//
	// * Failed - The deployment
	// failed. Use the GetContainerLog action to view the log events for the containers
	// in the deployment to try to determine the reason for the failure.
	State ContainerServiceDeploymentState

	// The version number of the deployment.
	Version *int32

	noSmithyDocumentSerde
}

// Describes a container deployment configuration of an Amazon Lightsail container
// service. A deployment specifies the settings, such as the ports and launch
// command, of containers that are deployed to your container service.
type ContainerServiceDeploymentRequest struct {

	// An object that describes the configuration for the containers of the deployment.
	Containers map[string]Container

	// An object that describes the endpoint of the deployment.
	PublicEndpoint *EndpointRequest

	noSmithyDocumentSerde
}

// Describes the activation status of the role that you can use to grant an Amazon
// Lightsail container service access to Amazon Elastic Container Registry (Amazon
// ECR) private repositories. When activated, Lightsail creates an Identity and
// Access Management (IAM) role for the specified Lightsail container service. You
// can use the ARN of the role to create a trust relationship between your
// Lightsail container service and an Amazon ECR private repository in your Amazon
// Web Services account. This allows your container service to pull images from
// Amazon ECR private repositories. For more information, see Configuring access to
// an Amazon ECR private repository for an Amazon Lightsail container service
// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-container-service-ecr-private-repo-access)
// in the Amazon Lightsail Developer Guide.
type ContainerServiceECRImagePullerRole struct {

	// A Boolean value that indicates whether the role is activated.
	IsActive *bool

	// The Amazon Resource Name (ARN) of the role, if it is activated.
	PrincipalArn *string

	noSmithyDocumentSerde
}

// Describes a request to activate or deactivate the role that you can use to grant
// an Amazon Lightsail container service access to Amazon Elastic Container
// Registry (Amazon ECR) private repositories. When activated, Lightsail creates an
// Identity and Access Management (IAM) role for the specified Lightsail container
// service. You can use the ARN of the role to create a trust relationship between
// your Lightsail container service and an Amazon ECR private repository in your
// Amazon Web Services account. This allows your container service to pull images
// from Amazon ECR private repositories. For more information, see Configuring
// access to an Amazon ECR private repository for an Amazon Lightsail container
// service
// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-container-service-ecr-private-repo-access)
// in the Amazon Lightsail Developer Guide.
type ContainerServiceECRImagePullerRoleRequest struct {

	// A Boolean value that indicates whether to activate the role.
	IsActive *bool

	noSmithyDocumentSerde
}

// Describes the public endpoint configuration of a deployment of an Amazon
// Lightsail container service.
type ContainerServiceEndpoint struct {

	// The name of the container entry of the deployment that the endpoint
	// configuration applies to.
	ContainerName *string

	// The port of the specified container to which traffic is forwarded to.
	ContainerPort *int32

	// An object that describes the health check configuration of the container.
	HealthCheck *ContainerServiceHealthCheckConfig

	noSmithyDocumentSerde
}

// Describes the health check configuration of an Amazon Lightsail container
// service.
type ContainerServiceHealthCheckConfig struct {

	// The number of consecutive health checks successes required before moving the
	// container to the Healthy state. The default value is 2.
	HealthyThreshold *int32

	// The approximate interval, in seconds, between health checks of an individual
	// container. You can specify between 5 and 300 seconds. The default value is 5.
	IntervalSeconds *int32

	// The path on the container on which to perform the health check. The default
	// value is /.
	Path *string

	// The HTTP codes to use when checking for a successful response from a container.
	// You can specify values between 200 and 499. You can specify multiple values (for
	// example, 200,202) or a range of values (for example, 200-299).
	SuccessCodes *string

	// The amount of time, in seconds, during which no response means a failed health
	// check. You can specify between 2 and 60 seconds. The default value is 2.
	TimeoutSeconds *int32

	// The number of consecutive health check failures required before moving the
	// container to the Unhealthy state. The default value is 2.
	UnhealthyThreshold *int32

	noSmithyDocumentSerde
}

// Describes the log events of a container of an Amazon Lightsail container
// service.
type ContainerServiceLogEvent struct {

	// The timestamp when the container service log event was created.
	CreatedAt *time.Time

	// The message of the container service log event.
	Message *string

	noSmithyDocumentSerde
}

// Describes the powers that can be specified for an Amazon Lightsail container
// service. The power specifies the amount of RAM, the number of vCPUs, and the
// base price of the container service.
type ContainerServicePower struct {

	// The number of vCPUs included in the power.
	CpuCount *float32

	// A Boolean value indicating whether the power is active and can be specified for
	// container services.
	IsActive *bool

	// The friendly name of the power (e.g., nano).
	Name *string

	// The ID of the power (e.g., nano-1).
	PowerId *string

	// The monthly price of the power in USD.
	Price *float32

	// The amount of RAM (in GB) of the power.
	RamSizeInGb *float32

	noSmithyDocumentSerde
}

// Describes the sign-in credentials for the container image registry of an Amazon
// Lightsail account.
type ContainerServiceRegistryLogin struct {

	// The timestamp of when the container image registry sign-in credentials expire.
	// The log in credentials expire 12 hours after they are created, at which point
	// you will need to create a new set of log in credentials using the
	// CreateContainerServiceRegistryLogin action.
	ExpiresAt *time.Time

	// The container service registry password to use to push container images to the
	// container image registry of a Lightsail account
	Password *string

	// The address to use to push container images to the container image registry of a
	// Lightsail account.
	Registry *string

	// The container service registry username to use to push container images to the
	// container image registry of a Lightsail account.
	Username *string

	noSmithyDocumentSerde
}

// Describes the current state of a container service.
type ContainerServiceStateDetail struct {

	// The state code of the container service. The following state codes are
	// possible:
	//
	// * The following state codes are possible if your container service is
	// in a DEPLOYING or UPDATING state:
	//
	// * CREATING_SYSTEM_RESOURCES - The system
	// resources for your container service are being created.
	//
	// *
	// CREATING_NETWORK_INFRASTRUCTURE - The network infrastructure for your container
	// service are being created.
	//
	// * PROVISIONING_CERTIFICATE - The SSL/TLS certificate
	// for your container service is being created.
	//
	// * PROVISIONING_SERVICE - Your
	// container service is being provisioned.
	//
	// * CREATING_DEPLOYMENT - Your deployment
	// is being created on your container service.
	//
	// * EVALUATING_HEALTH_CHECK - The
	// health of your deployment is being evaluated.
	//
	// * ACTIVATING_DEPLOYMENT - Your
	// deployment is being activated.
	//
	// * The following state codes are possible if your
	// container service is in a PENDING state:
	//
	// * CERTIFICATE_LIMIT_EXCEEDED - The
	// SSL/TLS certificate required for your container service exceeds the maximum
	// number of certificates allowed for your account.
	//
	// * UNKNOWN_ERROR - An error was
	// experienced when your container service was being created.
	Code ContainerServiceStateDetailCode

	// A message that provides more information for the state code. The state detail is
	// populated only when a container service is in a PENDING, DEPLOYING, or UPDATING
	// state.
	Message *string

	noSmithyDocumentSerde
}

// Describes whether an Amazon Lightsail content delivery network (CDN)
// distribution forwards cookies to the origin and, if so, which ones. For the
// cookies that you specify, your distribution caches separate versions of the
// specified content based on the cookie values in viewer requests.
type CookieObject struct {

	// The specific cookies to forward to your distribution's origin.
	CookiesAllowList []string

	// Specifies which cookies to forward to the distribution's origin for a cache
	// behavior: all, none, or allow-list to forward only the cookies specified in the
	// cookiesAllowList parameter.
	Option ForwardValues

	noSmithyDocumentSerde
}

// Describes the destination of a record.
type DestinationInfo struct {

	// The ID of the resource created at the destination.
	Id *string

	// The destination service of the record.
	Service *string

	noSmithyDocumentSerde
}

// Describes a block storage disk.
type Disk struct {

	// An array of objects representing the add-ons enabled on the disk.
	AddOns []AddOn

	// The Amazon Resource Name (ARN) of the disk.
	Arn *string

	// The resources to which the disk is attached.
	AttachedTo *string

	// (Deprecated) The attachment state of the disk. In releases prior to November 14,
	// 2017, this parameter returned attached for system disks in the API response. It
	// is now deprecated, but still included in the response. Use isAttached instead.
	//
	// Deprecated: This member has been deprecated.
	AttachmentState *string

	// The date when the disk was created.
	CreatedAt *time.Time

	// (Deprecated) The number of GB in use by the disk. In releases prior to November
	// 14, 2017, this parameter was not included in the API response. It is now
	// deprecated.
	//
	// Deprecated: This member has been deprecated.
	GbInUse *int32

	// The input/output operations per second (IOPS) of the disk.
	Iops *int32

	// A Boolean value indicating whether the disk is attached.
	IsAttached *bool

	// A Boolean value indicating whether this disk is a system disk (has an operating
	// system loaded on it).
	IsSystemDisk *bool

	// The AWS Region and Availability Zone where the disk is located.
	Location *ResourceLocation

	// The unique name of the disk.
	Name *string

	// The disk path.
	Path *string

	// The Lightsail resource type (e.g., Disk).
	ResourceType ResourceType

	// The size of the disk in GB.
	SizeInGb *int32

	// Describes the status of the disk.
	State DiskState

	// The support code. Include this code in your email to support when you have
	// questions about an instance or another resource in Lightsail. This code enables
	// our support team to look up your Lightsail information more easily.
	SupportCode *string

	// The tag keys and optional values for the resource. For more information about
	// tags in Lightsail, see the Amazon Lightsail Developer Guide
	// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
	Tags []Tag

	noSmithyDocumentSerde
}

// Describes a disk.
type DiskInfo struct {

	// A Boolean value indicating whether this disk is a system disk (has an operating
	// system loaded on it).
	IsSystemDisk *bool

	// The disk name.
	Name *string

	// The disk path.
	Path *string

	// The size of the disk in GB (e.g., 32).
	SizeInGb *int32

	noSmithyDocumentSerde
}

// Describes a block storage disk mapping.
type DiskMap struct {

	// The new disk name (e.g., my-new-disk).
	NewDiskName *string

	// The original disk path exposed to the instance (for example, /dev/sdh).
	OriginalDiskPath *string

	noSmithyDocumentSerde
}

// Describes a block storage disk snapshot.
type DiskSnapshot struct {

	// The Amazon Resource Name (ARN) of the disk snapshot.
	Arn *string

	// The date when the disk snapshot was created.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) of the source disk from which the disk snapshot
	// was created.
	FromDiskArn *string

	// The unique name of the source disk from which the disk snapshot was created.
	FromDiskName *string

	// The Amazon Resource Name (ARN) of the source instance from which the disk
	// (system volume) snapshot was created.
	FromInstanceArn *string

	// The unique name of the source instance from which the disk (system volume)
	// snapshot was created.
	FromInstanceName *string

	// A Boolean value indicating whether the snapshot was created from an automatic
	// snapshot.
	IsFromAutoSnapshot *bool

	// The AWS Region and Availability Zone where the disk snapshot was created.
	Location *ResourceLocation

	// The name of the disk snapshot (e.g., my-disk-snapshot).
	Name *string

	// The progress of the snapshot.
	Progress *string

	// The Lightsail resource type (e.g., DiskSnapshot).
	ResourceType ResourceType

	// The size of the disk in GB.
	SizeInGb *int32

	// The status of the disk snapshot operation.
	State DiskSnapshotState

	// The support code. Include this code in your email to support when you have
	// questions about an instance or another resource in Lightsail. This code enables
	// our support team to look up your Lightsail information more easily.
	SupportCode *string

	// The tag keys and optional values for the resource. For more information about
	// tags in Lightsail, see the Amazon Lightsail Developer Guide
	// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
	Tags []Tag

	noSmithyDocumentSerde
}

// Describes a disk snapshot.
type DiskSnapshotInfo struct {

	// The size of the disk in GB (e.g., 32).
	SizeInGb *int32

	noSmithyDocumentSerde
}

// Describes the specifications of a distribution bundle.
type DistributionBundle struct {

	// The ID of the bundle.
	BundleId *string

	// Indicates whether the bundle is active, and can be specified for a new or
	// existing distribution.
	IsActive *bool

	// The name of the distribution bundle.
	Name *string

	// The monthly price, in US dollars, of the bundle.
	Price *float32

	// The monthly network transfer quota of the bundle.
	TransferPerMonthInGb *int32

	noSmithyDocumentSerde
}

// Describes the creation state of the canonical name (CNAME) records that are
// automatically added by Amazon Lightsail to the DNS of a domain to validate
// domain ownership for an SSL/TLS certificate. When you create an SSL/TLS
// certificate for a Lightsail resource, you must add a set of CNAME records to the
// DNS of the domains for the certificate to validate that you own the domains.
// Lightsail can automatically add the CNAME records to the DNS of the domain if
// the DNS zone for the domain exists within your Lightsail account. If automatic
// record addition fails, or if you manage the DNS of your domain using a
// third-party service, then you must manually add the CNAME records to the DNS of
// your domain. For more information, see Verify an SSL/TLS certificate in Amazon
// Lightsail
// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/verify-tls-ssl-certificate-using-dns-cname-https)
// in the Amazon Lightsail Developer Guide.
type DnsRecordCreationState struct {

	// The status code for the automated DNS record creation. Following are the
	// possible values:
	//
	// * SUCCEEDED - The validation records were successfully added
	// to the domain.
	//
	// * STARTED - The automatic DNS record creation has started.
	//
	// *
	// FAILED - The validation records failed to be added to the domain.
	Code DnsRecordCreationStateCode

	// The message that describes the reason for the status code.
	Message *string

	noSmithyDocumentSerde
}

// Describes a domain where you are storing recordsets.
type Domain struct {

	// The Amazon Resource Name (ARN) of the domain recordset (e.g.,
	// arn:aws:lightsail:global:123456789101:Domain/824cede0-abc7-4f84-8dbc-12345EXAMPLE).
	Arn *string

	// The date when the domain recordset was created.
	CreatedAt *time.Time

	// An array of key-value pairs containing information about the domain entries.
	DomainEntries []DomainEntry

	// The AWS Region and Availability Zones where the domain recordset was created.
	Location *ResourceLocation

	// The name of the domain.
	Name *string

	// An object that describes the state of the Route 53 domain delegation to a
	// Lightsail DNS zone.
	RegisteredDomainDelegationInfo *RegisteredDomainDelegationInfo

	// The resource type.
	ResourceType ResourceType

	// The support code. Include this code in your email to support when you have
	// questions about an instance or another resource in Lightsail. This code enables
	// our support team to look up your Lightsail information more easily.
	SupportCode *string

	// The tag keys and optional values for the resource. For more information about
	// tags in Lightsail, see the Amazon Lightsail Developer Guide
	// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
	Tags []Tag

	noSmithyDocumentSerde
}

// Describes a domain recordset entry.
type DomainEntry struct {

	// The ID of the domain recordset entry.
	Id *string

	// When true, specifies whether the domain entry is an alias used by the Lightsail
	// load balancer, Lightsail container service, Lightsail content delivery network
	// (CDN) distribution, or another Amazon Web Services resource. You can include an
	// alias (A type) record in your request, which points to the DNS name of a load
	// balancer, container service, CDN distribution, or other Amazon Web Services
	// resource and routes traffic to that resource.
	IsAlias *bool

	// The name of the domain.
	Name *string

	// (Deprecated) The options for the domain entry. In releases prior to November 29,
	// 2017, this parameter was not included in the API response. It is now deprecated.
	//
	// Deprecated: This member has been deprecated.
	Options map[string]string

	// The target IP address (e.g., 192.0.2.0), or AWS name server (e.g.,
	// ns-111.awsdns-22.com.). For Lightsail load balancers, the value looks like
	// ab1234c56789c6b86aba6fb203d443bc-123456789.us-east-2.elb.amazonaws.com. For
	// Lightsail distributions, the value looks like exampled1182ne.cloudfront.net. For
	// Lightsail container services, the value looks like
	// container-service-1.example23scljs.us-west-2.cs.amazonlightsail.com. Be sure to
	// also set isAlias to true when setting up an A record for a Lightsail load
	// balancer, distribution, or container service.
	Target *string

	// The type of domain entry, such as address for IPv4 (A), address for IPv6 (AAAA),
	// canonical name (CNAME), mail exchanger (MX), name server (NS), start of
	// authority (SOA), service locator (SRV), or text (TXT). The following domain
	// entry types can be used:
	//
	// * A
	//
	// * AAAA
	//
	// * CNAME
	//
	// * MX
	//
	// * NS
	//
	// * SOA
	//
	// * SRV
	//
	// * TXT
	Type *string

	noSmithyDocumentSerde
}

// Describes the domain name system (DNS) records that you must add to the DNS of
// your registered domain to validate ownership for an Amazon Lightsail SSL/TLS
// certificate.
type DomainValidationRecord struct {

	// An object that describes the state of the canonical name (CNAME) records that
	// are automatically added by Lightsail to the DNS of the domain to validate domain
	// ownership.
	DnsRecordCreationState *DnsRecordCreationState

	// The domain name of the certificate validation record. For example, example.com
	// or www.example.com.
	DomainName *string

	// An object that describes the DNS records to add to your domain's DNS to validate
	// it for the certificate.
	ResourceRecord *ResourceRecord

	// The validation status of the record.
	ValidationStatus CertificateDomainValidationStatus

	noSmithyDocumentSerde
}

// Describes the settings of a public endpoint for an Amazon Lightsail container
// service.
type EndpointRequest struct {

	// The name of the container for the endpoint.
	//
	// This member is required.
	ContainerName *string

	// The port of the container to which traffic is forwarded to.
	//
	// This member is required.
	ContainerPort *int32

	// An object that describes the health check configuration of the container.
	HealthCheck *ContainerServiceHealthCheckConfig

	noSmithyDocumentSerde
}

// Describes an export snapshot record.
type ExportSnapshotRecord struct {

	// The Amazon Resource Name (ARN) of the export snapshot record.
	Arn *string

	// The date when the export snapshot record was created.
	CreatedAt *time.Time

	// A list of objects describing the destination of the export snapshot record.
	DestinationInfo *DestinationInfo

	// The AWS Region and Availability Zone where the export snapshot record is
	// located.
	Location *ResourceLocation

	// The export snapshot record name.
	Name *string

	// The Lightsail resource type (e.g., ExportSnapshotRecord).
	ResourceType ResourceType

	// A list of objects describing the source of the export snapshot record.
	SourceInfo *ExportSnapshotRecordSourceInfo

	// The state of the export snapshot record.
	State RecordState

	noSmithyDocumentSerde
}

// Describes the source of an export snapshot record.
type ExportSnapshotRecordSourceInfo struct {

	// The Amazon Resource Name (ARN) of the source instance or disk snapshot.
	Arn *string

	// The date when the source instance or disk snapshot was created.
	CreatedAt *time.Time

	// A list of objects describing a disk snapshot.
	DiskSnapshotInfo *DiskSnapshotInfo

	// The Amazon Resource Name (ARN) of the snapshot's source instance or disk.
	FromResourceArn *string

	// The name of the snapshot's source instance or disk.
	FromResourceName *string

	// A list of objects describing an instance snapshot.
	InstanceSnapshotInfo *InstanceSnapshotInfo

	// The name of the source instance or disk snapshot.
	Name *string

	// The Lightsail resource type (e.g., InstanceSnapshot or DiskSnapshot).
	ResourceType ExportSnapshotRecordSourceType

	noSmithyDocumentSerde
}

// Describes the request headers that a Lightsail distribution bases caching on.
// For the headers that you specify, your distribution caches separate versions of
// the specified content based on the header values in viewer requests. For
// example, suppose viewer requests for logo.jpg contain a custom product header
// that has a value of either acme or apex, and you configure your distribution to
// cache your content based on values in the product header. Your distribution
// forwards the product header to the origin and caches the response from the
// origin once for each header value.
type HeaderObject struct {

	// The specific headers to forward to your distribution's origin.
	HeadersAllowList []HeaderEnum

	// The headers that you want your distribution to forward to your origin and base
	// caching on. You can configure your distribution to do one of the following:
	//
	// *
	// all - Forward all headers to your origin.
	//
	// * none - Forward only the default
	// headers.
	//
	// * allow-list - Forward only the headers you specify using the
	// headersAllowList parameter.
	Option ForwardValues

	noSmithyDocumentSerde
}

// Describes the public SSH host keys or the RDP certificate.
type HostKeyAttributes struct {

	// The SSH host key algorithm or the RDP certificate format. For SSH host keys, the
	// algorithm may be ssh-rsa, ecdsa-sha2-nistp256, ssh-ed25519, etc. For RDP
	// certificates, the algorithm is always x509-cert.
	Algorithm *string

	// The SHA-1 fingerprint of the returned SSH host key or RDP certificate.
	//
	// *
	// Example of an SHA-1 SSH fingerprint: SHA1:1CHH6FaAaXjtFOsR/t83vf91SR0
	//
	// * Example
	// of an SHA-1 RDP fingerprint:
	// af:34:51:fe:09:f0:e0:da:b8:4e:56:ca:60:c2:10:ff:38:06:db:45
	FingerprintSHA1 *string

	// The SHA-256 fingerprint of the returned SSH host key or RDP certificate.
	//
	// *
	// Example of an SHA-256 SSH fingerprint:
	// SHA256:KTsMnRBh1IhD17HpdfsbzeGA4jOijm5tyXsMjKVbB8o
	//
	// * Example of an SHA-256 RDP
	// fingerprint:
	// 03:9b:36:9f:4b:de:4e:61:70:fc:7c:c9:78:e7:d2:1a:1c:25:a8:0c:91:f6:7c:e4:d6:a0:85:c8:b4:53:99:68
	FingerprintSHA256 *string

	// The returned RDP certificate is not valid after this point in time. This value
	// is listed only for RDP certificates.
	NotValidAfter *time.Time

	// The returned RDP certificate is valid after this point in time. This value is
	// listed only for RDP certificates.
	NotValidBefore *time.Time

	// The public SSH host key or the RDP certificate.
	PublicKey *string

	// The time that the SSH host key or RDP certificate was recorded by Lightsail.
	WitnessedAt *time.Time

	noSmithyDocumentSerde
}

// Describes the origin resource of an Amazon Lightsail content delivery network
// (CDN) distribution. An origin can be a Lightsail instance, bucket, or load
// balancer. A distribution pulls content from an origin, caches it, and serves it
// to viewers via a worldwide network of edge servers.
type InputOrigin struct {

	// The name of the origin resource.
	Name *string

	// The protocol that your Amazon Lightsail distribution uses when establishing a
	// connection with your origin to pull content.
	ProtocolPolicy OriginProtocolPolicyEnum

	// The AWS Region name of the origin resource.
	RegionName RegionName

	noSmithyDocumentSerde
}

// Describes an instance (a virtual private server).
type Instance struct {

	// An array of objects representing the add-ons enabled on the instance.
	AddOns []AddOn

	// The Amazon Resource Name (ARN) of the instance (e.g.,
	// arn:aws:lightsail:us-east-2:123456789101:Instance/244ad76f-8aad-4741-809f-12345EXAMPLE).
	Arn *string

	// The blueprint ID (e.g., os_amlinux_2016_03).
	BlueprintId *string

	// The friendly name of the blueprint (e.g., Amazon Linux).
	BlueprintName *string

	// The bundle for the instance (e.g., micro_1_0).
	BundleId *string

	// The timestamp when the instance was created (e.g., 1479734909.17) in Unix time
	// format.
	CreatedAt *time.Time

	// The size of the vCPU and the amount of RAM for the instance.
	Hardware *InstanceHardware

	// The IP address type of the instance. The possible values are ipv4 for IPv4 only,
	// and dualstack for IPv4 and IPv6.
	IpAddressType IpAddressType

	// The IPv6 addresses of the instance.
	Ipv6Addresses []string

	// A Boolean value indicating whether this instance has a static IP assigned to it.
	IsStaticIp *bool

	// The region name and Availability Zone where the instance is located.
	Location *ResourceLocation

	// The metadata options for the Amazon Lightsail instance.
	MetadataOptions *InstanceMetadataOptions

	// The name the user gave the instance (e.g., Amazon_Linux-1GB-Ohio-1).
	Name *string

	// Information about the public ports and monthly data transfer rates for the
	// instance.
	Networking *InstanceNetworking

	// The private IP address of the instance.
	PrivateIpAddress *string

	// The public IP address of the instance.
	PublicIpAddress *string

	// The type of resource (usually Instance).
	ResourceType ResourceType

	// The name of the SSH key being used to connect to the instance (e.g.,
	// LightsailDefaultKeyPair).
	SshKeyName *string

	// The status code and the state (e.g., running) for the instance.
	State *InstanceState

	// The support code. Include this code in your email to support when you have
	// questions about an instance or another resource in Lightsail. This code enables
	// our support team to look up your Lightsail information more easily.
	SupportCode *string

	// The tag keys and optional values for the resource. For more information about
	// tags in Lightsail, see the Amazon Lightsail Developer Guide
	// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
	Tags []Tag

	// The user name for connecting to the instance (e.g., ec2-user).
	Username *string

	noSmithyDocumentSerde
}

// The parameters for gaining temporary access to one of your Amazon Lightsail
// instances.
type InstanceAccessDetails struct {

	// For SSH access, the public key to use when accessing your instance For OpenSSH
	// clients (e.g., command line SSH), you should save this value to
	// tempkey-cert.pub.
	CertKey *string

	// For SSH access, the date on which the temporary keys expire.
	ExpiresAt *time.Time

	// Describes the public SSH host keys or the RDP certificate.
	HostKeys []HostKeyAttributes

	// The name of this Amazon Lightsail instance.
	InstanceName *string

	// The public IP address of the Amazon Lightsail instance.
	IpAddress *string

	// For RDP access, the password for your Amazon Lightsail instance. Password will
	// be an empty string if the password for your new instance is not ready yet. When
	// you create an instance, it can take up to 15 minutes for the instance to be
	// ready. If you create an instance using any key pair other than the default
	// (LightsailDefaultKeyPair), password will always be an empty string. If you
	// change the Administrator password on the instance, Lightsail will continue to
	// return the original password value. When accessing the instance using RDP, you
	// need to manually enter the Administrator password after changing it from the
	// default.
	Password *string

	// For a Windows Server-based instance, an object with the data you can use to
	// retrieve your password. This is only needed if password is empty and the
	// instance is not new (and therefore the password is not ready yet). When you
	// create an instance, it can take up to 15 minutes for the instance to be ready.
	PasswordData *PasswordData

	// For SSH access, the temporary private key. For OpenSSH clients (e.g., command
	// line SSH), you should save this value to tempkey).
	PrivateKey *string

	// The protocol for these Amazon Lightsail instance access details.
	Protocol InstanceAccessProtocol

	// The user name to use when logging in to the Amazon Lightsail instance.
	Username *string

	noSmithyDocumentSerde
}

// Describes the Amazon Elastic Compute Cloud instance and related resources to be
// created using the create cloud formation stack operation.
type InstanceEntry struct {

	// The Availability Zone for the new Amazon EC2 instance.
	//
	// This member is required.
	AvailabilityZone *string

	// The instance type (e.g., t2.micro) to use for the new Amazon EC2 instance.
	//
	// This member is required.
	InstanceType *string

	// The port configuration to use for the new Amazon EC2 instance. The following
	// configuration options are available:
	//
	// * DEFAULT - Use the default firewall
	// settings from the Lightsail instance blueprint. If this is specified, then IPv4
	// and IPv6 will be configured for the new instance that is created in Amazon
	// EC2.
	//
	// * INSTANCE - Use the configured firewall settings from the source
	// Lightsail instance. If this is specified, the new instance that is created in
	// Amazon EC2 will be configured to match the configuration of the source Lightsail
	// instance. For example, if the source instance is configured for dual-stack (IPv4
	// and IPv6), then IPv4 and IPv6 will be configured for the new instance that is
	// created in Amazon EC2. If the source instance is configured for IPv4 only, then
	// only IPv4 will be configured for the new instance that is created in Amazon
	// EC2.
	//
	// * NONE - Use the default Amazon EC2 security group. If this is specified,
	// then only IPv4 will be configured for the new instance that is created in Amazon
	// EC2.
	//
	// * CLOSED - All ports closed. If this is specified, then only IPv4 will be
	// configured for the new instance that is created in Amazon EC2.
	//
	// If you
	// configured lightsail-connect as a cidrListAliases on your instance, or if you
	// chose to allow the Lightsail browser-based SSH or RDP clients to connect to your
	// instance, that configuration is not carried over to your new Amazon EC2
	// instance.
	//
	// This member is required.
	PortInfoSource PortInfoSourceType

	// The name of the export snapshot record, which contains the exported Lightsail
	// instance snapshot that will be used as the source of the new Amazon EC2
	// instance. Use the get export snapshot records operation to get a list of export
	// snapshot records that you can use to create a CloudFormation stack.
	//
	// This member is required.
	SourceName *string

	// A launch script you can create that configures a server with additional user
	// data. For example, you might want to run apt-get -y update. Depending on the
	// machine image you choose, the command to get software on your instance varies.
	// Amazon Linux and CentOS use yum, Debian and Ubuntu use apt-get, and FreeBSD uses
	// pkg.
	UserData *string

	noSmithyDocumentSerde
}

// Describes the hardware for the instance.
type InstanceHardware struct {

	// The number of vCPUs the instance has.
	CpuCount *int32

	// The disks attached to the instance.
	Disks []Disk

	// The amount of RAM in GB on the instance (e.g., 1.0).
	RamSizeInGb *float32

	noSmithyDocumentSerde
}

// Describes information about the health of the instance.
type InstanceHealthSummary struct {

	// Describes the overall instance health. Valid values are below.
	InstanceHealth InstanceHealthState

	// More information about the instance health. If the instanceHealth is healthy,
	// then an instanceHealthReason value is not provided. If instanceHealth is
	// initial, the instanceHealthReason value can be one of the following:
	//
	// *
	// Lb.RegistrationInProgress - The target instance is in the process of being
	// registered with the load balancer.
	//
	// * Lb.InitialHealthChecking - The Lightsail
	// load balancer is still sending the target instance the minimum number of health
	// checks required to determine its health status.
	//
	// If instanceHealth is unhealthy,
	// the instanceHealthReason value can be one of the following:
	//
	// *
	// Instance.ResponseCodeMismatch - The health checks did not return an expected
	// HTTP code.
	//
	// * Instance.Timeout - The health check requests timed out.
	//
	// *
	// Instance.FailedHealthChecks - The health checks failed because the connection to
	// the target instance timed out, the target instance response was malformed, or
	// the target instance failed the health check for an unknown reason.
	//
	// *
	// Lb.InternalError - The health checks failed due to an internal error.
	//
	// If
	// instanceHealth is unused, the instanceHealthReason value can be one of the
	// following:
	//
	// * Instance.NotRegistered - The target instance is not registered
	// with the target group.
	//
	// * Instance.NotInUse - The target group is not used by
	// any load balancer, or the target instance is in an Availability Zone that is not
	// enabled for its load balancer.
	//
	// * Instance.IpUnusable - The target IP address is
	// reserved for use by a Lightsail load balancer.
	//
	// * Instance.InvalidState - The
	// target is in the stopped or terminated state.
	//
	// If instanceHealth is draining,
	// the instanceHealthReason value can be one of the following:
	//
	// *
	// Instance.DeregistrationInProgress - The target instance is in the process of
	// being deregistered and the deregistration delay period has not expired.
	InstanceHealthReason InstanceHealthReason

	// The name of the Lightsail instance for which you are requesting health check
	// data.
	InstanceName *string

	noSmithyDocumentSerde
}

// The metadata options for the instance.
type InstanceMetadataOptions struct {

	// Indicates whether the HTTP metadata endpoint on your instances is enabled or
	// disabled. If the value is disabled, you cannot access your instance metadata.
	HttpEndpoint HttpEndpoint

	// Indicates whether the IPv6 endpoint for the instance metadata service is enabled
	// or disabled.
	HttpProtocolIpv6 HttpProtocolIpv6

	// The desired HTTP PUT response hop limit for instance metadata requests. A larger
	// number means that the instance metadata requests can travel farther.
	HttpPutResponseHopLimit *int32

	// The state of token usage for your instance metadata requests. If the state is
	// optional, you can choose whether to retrieve instance metadata with a signed
	// token header on your request. If you retrieve the IAM role credentials without a
	// token, the version 1.0 role credentials are returned. If you retrieve the IAM
	// role credentials by using a valid signed token, the version 2.0 role credentials
	// are returned. If the state is required, you must send a signed token header with
	// all instance metadata retrieval requests. In this state, retrieving the IAM role
	// credential always returns the version 2.0 credentials. The version 1.0
	// credentials are not available. Not all instance blueprints in Lightsail support
	// version 2.0 credentials. Use the MetadataNoToken instance metric to track the
	// number of calls to the instance metadata service that are using version 1.0
	// credentials. For more information, see Viewing instance metrics in Amazon
	// Lightsail
	// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-viewing-instance-health-metrics)
	// in the Amazon Lightsail Developer Guide.
	HttpTokens HttpTokens

	// The state of the metadata option changes. The following states are possible:
	//
	// *
	// pending - The metadata options are being updated. The instance is not yet ready
	// to process metadata traffic with the new selection.
	//
	// * applied - The metadata
	// options have been successfully applied to the instance.
	State InstanceMetadataState

	noSmithyDocumentSerde
}

// Describes monthly data transfer rates and port information for an instance.
type InstanceNetworking struct {

	// The amount of data in GB allocated for monthly data transfers.
	MonthlyTransfer *MonthlyTransfer

	// An array of key-value pairs containing information about the ports on the
	// instance.
	Ports []InstancePortInfo

	noSmithyDocumentSerde
}

// Describes information about ports for an Amazon Lightsail instance.
type InstancePortInfo struct {

	// The access direction (inbound or outbound). Lightsail currently supports only
	// inbound access direction.
	AccessDirection AccessDirection

	// The location from which access is allowed. For example, Anywhere (0.0.0.0/0), or
	// Custom if a specific IP address or range of IP addresses is allowed.
	AccessFrom *string

	// The type of access (Public or Private).
	AccessType PortAccessType

	// An alias that defines access for a preconfigured range of IP addresses. The only
	// alias currently supported is lightsail-connect, which allows IP addresses of the
	// browser-based RDP/SSH client in the Lightsail console to connect to your
	// instance.
	CidrListAliases []string

	// The IPv4 address, or range of IPv4 addresses (in CIDR notation) that are allowed
	// to connect to an instance through the ports, and the protocol. The ipv6Cidrs
	// parameter lists the IPv6 addresses that are allowed to connect to an instance.
	// For more information about CIDR block notation, see Classless Inter-Domain
	// Routing
	// (https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation) on
	// Wikipedia.
	Cidrs []string

	// The common name of the port information.
	CommonName *string

	// The first port in a range of open ports on an instance. Allowed ports:
	//
	// * TCP
	// and UDP - 0 to 65535
	//
	// * ICMP - The ICMP type for IPv4 addresses. For example,
	// specify 8 as the fromPort (ICMP type), and -1 as the toPort (ICMP code), to
	// enable ICMP Ping. For more information, see Control Messages
	// (https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol#Control_messages)
	// on Wikipedia.
	//
	// * ICMPv6 - The ICMP type for IPv6 addresses. For example, specify
	// 128 as the fromPort (ICMPv6 type), and 0 as toPort (ICMPv6 code). For more
	// information, see Internet Control Message Protocol for IPv6
	// (https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol_for_IPv6).
	FromPort int32

	// The IPv6 address, or range of IPv6 addresses (in CIDR notation) that are allowed
	// to connect to an instance through the ports, and the protocol. Only devices with
	// an IPv6 address can connect to an instance through IPv6; otherwise, IPv4 should
	// be used. The cidrs parameter lists the IPv4 addresses that are allowed to
	// connect to an instance. For more information about CIDR block notation, see
	// Classless Inter-Domain Routing
	// (https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation) on
	// Wikipedia.
	Ipv6Cidrs []string

	// The IP protocol name. The name can be one of the following:
	//
	// * tcp -
	// Transmission Control Protocol (TCP) provides reliable, ordered, and
	// error-checked delivery of streamed data between applications running on hosts
	// communicating by an IP network. If you have an application that doesn't require
	// reliable data stream service, use UDP instead.
	//
	// * all - All transport layer
	// protocol types. For more general information, see Transport layer
	// (https://en.wikipedia.org/wiki/Transport_layer) on Wikipedia.
	//
	// * udp - With User
	// Datagram Protocol (UDP), computer applications can send messages (or datagrams)
	// to other hosts on an Internet Protocol (IP) network. Prior communications are
	// not required to set up transmission channels or data paths. Applications that
	// don't require reliable data stream service can use UDP, which provides a
	// connectionless datagram service that emphasizes reduced latency over
	// reliability. If you do require reliable data stream service, use TCP instead.
	//
	// *
	// icmp - Internet Control Message Protocol (ICMP) is used to send error messages
	// and operational information indicating success or failure when communicating
	// with an instance. For example, an error is indicated when an instance could not
	// be reached. When you specify icmp as the protocol, you must specify the ICMP
	// type using the fromPort parameter, and ICMP code using the toPort parameter.
	Protocol NetworkProtocol

	// The last port in a range of open ports on an instance. Allowed ports:
	//
	// * TCP and
	// UDP - 0 to 65535
	//
	// * ICMP - The ICMP code for IPv4 addresses. For example,
	// specify 8 as the fromPort (ICMP type), and -1 as the toPort (ICMP code), to
	// enable ICMP Ping. For more information, see Control Messages
	// (https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol#Control_messages)
	// on Wikipedia.
	//
	// * ICMPv6 - The ICMP code for IPv6 addresses. For example, specify
	// 128 as the fromPort (ICMPv6 type), and 0 as toPort (ICMPv6 code). For more
	// information, see Internet Control Message Protocol for IPv6
	// (https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol_for_IPv6).
	ToPort int32

	noSmithyDocumentSerde
}

// Describes open ports on an instance, the IP addresses allowed to connect to the
// instance through the ports, and the protocol.
type InstancePortState struct {

	// An alias that defines access for a preconfigured range of IP addresses. The only
	// alias currently supported is lightsail-connect, which allows IP addresses of the
	// browser-based RDP/SSH client in the Lightsail console to connect to your
	// instance.
	CidrListAliases []string

	// The IPv4 address, or range of IPv4 addresses (in CIDR notation) that are allowed
	// to connect to an instance through the ports, and the protocol. The ipv6Cidrs
	// parameter lists the IPv6 addresses that are allowed to connect to an instance.
	// For more information about CIDR block notation, see Classless Inter-Domain
	// Routing
	// (https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation) on
	// Wikipedia.
	Cidrs []string

	// The first port in a range of open ports on an instance. Allowed ports:
	//
	// * TCP
	// and UDP - 0 to 65535
	//
	// * ICMP - The ICMP type for IPv4 addresses. For example,
	// specify 8 as the fromPort (ICMP type), and -1 as the toPort (ICMP code), to
	// enable ICMP Ping. For more information, see Control Messages
	// (https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol#Control_messages)
	// on Wikipedia.
	//
	// * ICMPv6 - The ICMP type for IPv6 addresses. For example, specify
	// 128 as the fromPort (ICMPv6 type), and 0 as toPort (ICMPv6 code). For more
	// information, see Internet Control Message Protocol for IPv6
	// (https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol_for_IPv6).
	FromPort int32

	// The IPv6 address, or range of IPv6 addresses (in CIDR notation) that are allowed
	// to connect to an instance through the ports, and the protocol. Only devices with
	// an IPv6 address can connect to an instance through IPv6; otherwise, IPv4 should
	// be used. The cidrs parameter lists the IPv4 addresses that are allowed to
	// connect to an instance. For more information about CIDR block notation, see
	// Classless Inter-Domain Routing
	// (https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation) on
	// Wikipedia.
	Ipv6Cidrs []string

	// The IP protocol name. The name can be one of the following:
	//
	// * tcp -
	// Transmission Control Protocol (TCP) provides reliable, ordered, and
	// error-checked delivery of streamed data between applications running on hosts
	// communicating by an IP network. If you have an application that doesn't require
	// reliable data stream service, use UDP instead.
	//
	// * all - All transport layer
	// protocol types. For more general information, see Transport layer
	// (https://en.wikipedia.org/wiki/Transport_layer) on Wikipedia.
	//
	// * udp - With User
	// Datagram Protocol (UDP), computer applications can send messages (or datagrams)
	// to other hosts on an Internet Protocol (IP) network. Prior communications are
	// not required to set up transmission channels or data paths. Applications that
	// don't require reliable data stream service can use UDP, which provides a
	// connectionless datagram service that emphasizes reduced latency over
	// reliability. If you do require reliable data stream service, use TCP instead.
	//
	// *
	// icmp - Internet Control Message Protocol (ICMP) is used to send error messages
	// and operational information indicating success or failure when communicating
	// with an instance. For example, an error is indicated when an instance could not
	// be reached. When you specify icmp as the protocol, you must specify the ICMP
	// type using the fromPort parameter, and ICMP code using the toPort parameter.
	Protocol NetworkProtocol

	// Specifies whether the instance port is open or closed. The port state for
	// Lightsail instances is always open.
	State PortState

	// The last port in a range of open ports on an instance. Allowed ports:
	//
	// * TCP and
	// UDP - 0 to 65535
	//
	// * ICMP - The ICMP code for IPv4 addresses. For example,
	// specify 8 as the fromPort (ICMP type), and -1 as the toPort (ICMP code), to
	// enable ICMP Ping. For more information, see Control Messages
	// (https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol#Control_messages)
	// on Wikipedia.
	//
	// * ICMPv6 - The ICMP code for IPv6 addresses. For example, specify
	// 128 as the fromPort (ICMPv6 type), and 0 as toPort (ICMPv6 code). For more
	// information, see Internet Control Message Protocol for IPv6
	// (https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol_for_IPv6).
	ToPort int32

	noSmithyDocumentSerde
}

// Describes an instance snapshot.
type InstanceSnapshot struct {

	// The Amazon Resource Name (ARN) of the snapshot (e.g.,
	// arn:aws:lightsail:us-east-2:123456789101:InstanceSnapshot/d23b5706-3322-4d83-81e5-12345EXAMPLE).
	Arn *string

	// The timestamp when the snapshot was created (e.g., 1479907467.024).
	CreatedAt *time.Time

	// An array of disk objects containing information about all block storage disks.
	FromAttachedDisks []Disk

	// The blueprint ID from which you created the snapshot (e.g., os_debian_8_3). A
	// blueprint is a virtual private server (or instance) image used to create
	// instances quickly.
	FromBlueprintId *string

	// The bundle ID from which you created the snapshot (e.g., micro_1_0).
	FromBundleId *string

	// The Amazon Resource Name (ARN) of the instance from which the snapshot was
	// created (e.g.,
	// arn:aws:lightsail:us-east-2:123456789101:Instance/64b8404c-ccb1-430b-8daf-12345EXAMPLE).
	FromInstanceArn *string

	// The instance from which the snapshot was created.
	FromInstanceName *string

	// A Boolean value indicating whether the snapshot was created from an automatic
	// snapshot.
	IsFromAutoSnapshot *bool

	// The region name and Availability Zone where you created the snapshot.
	Location *ResourceLocation

	// The name of the snapshot.
	Name *string

	// The progress of the snapshot. This is populated only for disk snapshots, and is
	// null for instance snapshots.
	Progress *string

	// The type of resource (usually InstanceSnapshot).
	ResourceType ResourceType

	// The size in GB of the SSD.
	SizeInGb *int32

	// The state the snapshot is in.
	State InstanceSnapshotState

	// The support code. Include this code in your email to support when you have
	// questions about an instance or another resource in Lightsail. This code enables
	// our support team to look up your Lightsail information more easily.
	SupportCode *string

	// The tag keys and optional values for the resource. For more information about
	// tags in Lightsail, see the Amazon Lightsail Developer Guide
	// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
	Tags []Tag

	noSmithyDocumentSerde
}

// Describes an instance snapshot.
type InstanceSnapshotInfo struct {

	// The blueprint ID from which the source instance (e.g., os_debian_8_3).
	FromBlueprintId *string

	// The bundle ID from which the source instance was created (e.g., micro_1_0).
	FromBundleId *string

	// A list of objects describing the disks that were attached to the source
	// instance.
	FromDiskInfo []DiskInfo

	noSmithyDocumentSerde
}

// Describes the virtual private server (or instance) status.
type InstanceState struct {

	// The status code for the instance.
	Code *int32

	// The state of the instance (e.g., running or pending).
	Name *string

	noSmithyDocumentSerde
}

// Describes an SSH key pair.
type KeyPair struct {

	// The Amazon Resource Name (ARN) of the key pair (e.g.,
	// arn:aws:lightsail:us-east-2:123456789101:KeyPair/05859e3d-331d-48ba-9034-12345EXAMPLE).
	Arn *string

	// The timestamp when the key pair was created (e.g., 1479816991.349).
	CreatedAt *time.Time

	// The RSA fingerprint of the key pair.
	Fingerprint *string

	// The region name and Availability Zone where the key pair was created.
	Location *ResourceLocation

	// The friendly name of the SSH key pair.
	Name *string

	// The resource type (usually KeyPair).
	ResourceType ResourceType

	// The support code. Include this code in your email to support when you have
	// questions about an instance or another resource in Lightsail. This code enables
	// our support team to look up your Lightsail information more easily.
	SupportCode *string

	// The tag keys and optional values for the resource. For more information about
	// tags in Lightsail, see the Amazon Lightsail Developer Guide
	// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
	Tags []Tag

	noSmithyDocumentSerde
}

// Describes an Amazon Lightsail content delivery network (CDN) distribution.
type LightsailDistribution struct {

	// Indicates whether the bundle that is currently applied to your distribution,
	// specified using the distributionName parameter, can be changed to another
	// bundle. Use the UpdateDistributionBundle action to change your distribution's
	// bundle.
	AbleToUpdateBundle *bool

	// The alternate domain names of the distribution.
	AlternativeDomainNames []string

	// The Amazon Resource Name (ARN) of the distribution.
	Arn *string

	// The ID of the bundle currently applied to the distribution.
	BundleId *string

	// An object that describes the cache behavior settings of the distribution.
	CacheBehaviorSettings *CacheSettings

	// An array of objects that describe the per-path cache behavior of the
	// distribution.
	CacheBehaviors []CacheBehaviorPerPath

	// The name of the SSL/TLS certificate attached to the distribution, if any.
	CertificateName *string

	// The timestamp when the distribution was created.
	CreatedAt *time.Time

	// An object that describes the default cache behavior of the distribution.
	DefaultCacheBehavior *CacheBehavior

	// The domain name of the distribution.
	DomainName *string

	// The IP address type of the distribution. The possible values are ipv4 for IPv4
	// only, and dualstack for IPv4 and IPv6.
	IpAddressType IpAddressType

	// Indicates whether the distribution is enabled.
	IsEnabled *bool

	// An object that describes the location of the distribution, such as the Amazon
	// Web Services Region and Availability Zone. Lightsail distributions are global
	// resources that can reference an origin in any Amazon Web Services Region, and
	// distribute its content globally. However, all distributions are located in the
	// us-east-1 Region.
	Location *ResourceLocation

	// The name of the distribution.
	Name *string

	// An object that describes the origin resource of the distribution, such as a
	// Lightsail instance, bucket, or load balancer. The distribution pulls, caches,
	// and serves content from the origin.
	Origin *Origin

	// The public DNS of the origin.
	OriginPublicDNS *string

	// The Lightsail resource type (e.g., Distribution).
	ResourceType ResourceType

	// The status of the distribution.
	Status *string

	// The support code. Include this code in your email to support when you have
	// questions about your Lightsail distribution. This code enables our support team
	// to look up your Lightsail information more easily.
	SupportCode *string

	// The tag keys and optional values for the resource. For more information about
	// tags in Lightsail, see the Amazon Lightsail Developer Guide
	// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
	Tags []Tag

	noSmithyDocumentSerde
}

// Describes a load balancer.
type LoadBalancer struct {

	// The Amazon Resource Name (ARN) of the load balancer.
	Arn *string

	// A string to string map of the configuration options for your load balancer.
	// Valid values are listed below.
	ConfigurationOptions map[string]string

	// The date when your load balancer was created.
	CreatedAt *time.Time

	// The DNS name of your Lightsail load balancer.
	DnsName *string

	// The path you specified to perform your health checks. If no path is specified,
	// the load balancer tries to make a request to the default (root) page.
	HealthCheckPath *string

	// A Boolean value that indicates whether HTTPS redirection is enabled for the load
	// balancer.
	HttpsRedirectionEnabled *bool

	// An array of InstanceHealthSummary objects describing the health of the load
	// balancer.
	InstanceHealthSummary []InstanceHealthSummary

	// The port where the load balancer will direct traffic to your Lightsail
	// instances. For HTTP traffic, it's port 80. For HTTPS traffic, it's port 443.
	InstancePort *int32

	// The IP address type of the load balancer. The possible values are ipv4 for IPv4
	// only, and dualstack for IPv4 and IPv6.
	IpAddressType IpAddressType

	// The AWS Region where your load balancer was created (e.g., us-east-2a).
	// Lightsail automatically creates your load balancer across Availability Zones.
	Location *ResourceLocation

	// The name of the load balancer (e.g., my-load-balancer).
	Name *string

	// The protocol you have enabled for your load balancer. Valid values are below.
	// You can't just have HTTP_HTTPS, but you can have just HTTP.
	Protocol LoadBalancerProtocol

	// An array of public port settings for your load balancer. For HTTP, use port 80.
	// For HTTPS, use port 443.
	PublicPorts []int32

	// The resource type (e.g., LoadBalancer.
	ResourceType ResourceType

	// The status of your load balancer. Valid values are below.
	State LoadBalancerState

	// The support code. Include this code in your email to support when you have
	// questions about your Lightsail load balancer. This code enables our support team
	// to look up your Lightsail information more easily.
	SupportCode *string

	// The tag keys and optional values for the resource. For more information about
	// tags in Lightsail, see the Amazon Lightsail Developer Guide
	// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
	Tags []Tag

	// An array of LoadBalancerTlsCertificateSummary objects that provide additional
	// information about the SSL/TLS certificates. For example, if true, the
	// certificate is attached to the load balancer.
	TlsCertificateSummaries []LoadBalancerTlsCertificateSummary

	// The name of the TLS security policy for the load balancer.
	TlsPolicyName *string

	noSmithyDocumentSerde
}

// Describes a load balancer SSL/TLS certificate. TLS is just an updated, more
// secure version of Secure Socket Layer (SSL).
type LoadBalancerTlsCertificate struct {

	// The Amazon Resource Name (ARN) of the SSL/TLS certificate.
	Arn *string

	// The time when you created your SSL/TLS certificate.
	CreatedAt *time.Time

	// The domain name for your SSL/TLS certificate.
	DomainName *string

	// An array of LoadBalancerTlsCertificateDomainValidationRecord objects describing
	// the records.
	DomainValidationRecords []LoadBalancerTlsCertificateDomainValidationRecord

	// The validation failure reason, if any, of the certificate. The following failure
	// reasons are possible:
	//
	// * NO_AVAILABLE_CONTACTS - This failure applies to email
	// validation, which is not available for Lightsail certificates.
	//
	// *
	// ADDITIONAL_VERIFICATION_REQUIRED - Lightsail requires additional information to
	// process this certificate request. This can happen as a fraud-protection measure,
	// such as when the domain ranks within the Alexa top 1000 websites. To provide the
	// required information, use the AWS Support Center
	// (https://console.aws.amazon.com/support/home) to contact AWS Support. You cannot
	// request a certificate for Amazon-owned domain names such as those ending in
	// amazonaws.com, cloudfront.net, or elasticbeanstalk.com.
	//
	// * DOMAIN_NOT_ALLOWED -
	// One or more of the domain names in the certificate request was reported as an
	// unsafe domain by VirusTotal (https://www.virustotal.com/gui/home/url). To
	// correct the problem, search for your domain name on the VirusTotal
	// (https://www.virustotal.com/gui/home/url) website. If your domain is reported as
	// suspicious, see Google Help for Hacked Websites
	// (https://developers.google.com/web/fundamentals/security/hacked) to learn what
	// you can do. If you believe that the result is a false positive, notify the
	// organization that is reporting the domain. VirusTotal is an aggregate of several
	// antivirus and URL scanners and cannot remove your domain from a block list
	// itself. After you correct the problem and the VirusTotal registry has been
	// updated, request a new certificate. If you see this error and your domain is not
	// included in the VirusTotal list, visit the AWS Support Center
	// (https://console.aws.amazon.com/support/home) and create a case.
	//
	// *
	// INVALID_PUBLIC_DOMAIN - One or more of the domain names in the certificate
	// request is not valid. Typically, this is because a domain name in the request is
	// not a valid top-level domain. Try to request a certificate again, correcting any
	// spelling errors or typos that were in the failed request, and ensure that all
	// domain names in the request are for valid top-level domains. For example, you
	// cannot request a certificate for example.invalidpublicdomain because
	// invalidpublicdomain is not a valid top-level domain.
	//
	// * OTHER - Typically, this
	// failure occurs when there is a typographical error in one or more of the domain
	// names in the certificate request. Try to request a certificate again, correcting
	// any spelling errors or typos that were in the failed request.
	FailureReason LoadBalancerTlsCertificateFailureReason

	// When true, the SSL/TLS certificate is attached to the Lightsail load balancer.
	IsAttached *bool

	// The time when the SSL/TLS certificate was issued.
	IssuedAt *time.Time

	// The issuer of the certificate.
	Issuer *string

	// The algorithm used to generate the key pair (the public and private key).
	KeyAlgorithm *string

	// The load balancer name where your SSL/TLS certificate is attached.
	LoadBalancerName *string

	// The Amazon Web Services Region and Availability Zone where you created your
	// certificate.
	Location *ResourceLocation

	// The name of the SSL/TLS certificate (e.g., my-certificate).
	Name *string

	// The timestamp when the SSL/TLS certificate expires.
	NotAfter *time.Time

	// The timestamp when the SSL/TLS certificate is first valid.
	NotBefore *time.Time

	// An object that describes the status of the certificate renewal managed by
	// Lightsail.
	RenewalSummary *LoadBalancerTlsCertificateRenewalSummary

	// The resource type (e.g., LoadBalancerTlsCertificate).
	//
	// * Instance - A Lightsail
	// instance (a virtual private server)
	//
	// * StaticIp - A static IP address
	//
	// * KeyPair
	// - The key pair used to connect to a Lightsail instance
	//
	// * InstanceSnapshot - A
	// Lightsail instance snapshot
	//
	// * Domain - A DNS zone
	//
	// * PeeredVpc - A peered
	// VPC
	//
	// * LoadBalancer - A Lightsail load balancer
	//
	// * LoadBalancerTlsCertificate -
	// An SSL/TLS certificate associated with a Lightsail load balancer
	//
	// * Disk - A
	// Lightsail block storage disk
	//
	// * DiskSnapshot - A block storage disk snapshot
	ResourceType ResourceType

	// The reason the certificate was revoked. This value is present only when the
	// certificate status is REVOKED.
	RevocationReason LoadBalancerTlsCertificateRevocationReason

	// The timestamp when the certificate was revoked. This value is present only when
	// the certificate status is REVOKED.
	RevokedAt *time.Time

	// The serial number of the certificate.
	Serial *string

	// The algorithm that was used to sign the certificate.
	SignatureAlgorithm *string

	// The validation status of the SSL/TLS certificate. Valid values are below.
	Status LoadBalancerTlsCertificateStatus

	// The name of the entity that is associated with the public key contained in the
	// certificate.
	Subject *string

	// An array of strings that specify the alternate domains (e.g., example2.com) and
	// subdomains (e.g., blog.example.com) for the certificate.
	SubjectAlternativeNames []string

	// The support code. Include this code in your email to support when you have
	// questions about your Lightsail load balancer or SSL/TLS certificate. This code
	// enables our support team to look up your Lightsail information more easily.
	SupportCode *string

	// The tag keys and optional values for the resource. For more information about
	// tags in Lightsail, see the Amazon Lightsail Developer Guide
	// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
	Tags []Tag

	noSmithyDocumentSerde
}

// An object that describes the state of the canonical name (CNAME) records that
// are automatically added by Lightsail to the DNS of the domain to validate domain
// ownership.
type LoadBalancerTlsCertificateDnsRecordCreationState struct {

	// The status code for the automated DNS record creation. Following are the
	// possible values:
	//
	// * SUCCEEDED - The validation records were successfully
	// added.
	//
	// * STARTED - The automatic DNS record creation has started.
	//
	// * FAILED -
	// The validation record addition failed.
	Code LoadBalancerTlsCertificateDnsRecordCreationStateCode

	// The message that describes the reason for the status code.
	Message *string

	noSmithyDocumentSerde
}

// Contains information about the domain names on an SSL/TLS certificate that you
// will use to validate domain ownership.
type LoadBalancerTlsCertificateDomainValidationOption struct {

	// The fully qualified domain name in the certificate request.
	DomainName *string

	// The status of the domain validation. Valid values are listed below.
	ValidationStatus LoadBalancerTlsCertificateDomainStatus

	noSmithyDocumentSerde
}

// Describes the validation record of each domain name in the SSL/TLS certificate.
type LoadBalancerTlsCertificateDomainValidationRecord struct {

	// An object that describes the state of the canonical name (CNAME) records that
	// are automatically added by Lightsail to the DNS of a domain to validate domain
	// ownership.
	DnsRecordCreationState *LoadBalancerTlsCertificateDnsRecordCreationState

	// The domain name against which your SSL/TLS certificate was validated.
	DomainName *string

	// A fully qualified domain name in the certificate. For example, example.com.
	Name *string

	// The type of validation record. For example, CNAME for domain validation.
	Type *string

	// The validation status. Valid values are listed below.
	ValidationStatus LoadBalancerTlsCertificateDomainStatus

	// The value for that type.
	Value *string

	noSmithyDocumentSerde
}

// Contains information about the status of Lightsail's managed renewal for the
// certificate. The renewal status of the certificate. The following renewal status
// are possible:
//
// * PendingAutoRenewal - Lightsail is attempting to automatically
// validate the domain names in the certificate. No further action is required.
//
// *
// PendingValidation - Lightsail couldn't automatically validate one or more domain
// names in the certificate. You must take action to validate these domain names or
// the certificate won't be renewed. If you used DNS validation, check to make sure
// your certificate's domain validation records exist in your domain's DNS, and
// that your certificate remains in use.
//
// * Success - All domain names in the
// certificate are validated, and Lightsail renewed the certificate. No further
// action is required.
//
// * Failed - One or more domain names were not validated
// before the certificate expired, and Lightsail did not renew the certificate. You
// can request a new certificate using the CreateCertificate action.
type LoadBalancerTlsCertificateRenewalSummary struct {

	// Contains information about the validation of each domain name in the
	// certificate, as it pertains to Lightsail's managed renewal. This is different
	// from the initial validation that occurs as a result of the RequestCertificate
	// request.
	DomainValidationOptions []LoadBalancerTlsCertificateDomainValidationOption

	// The renewal status of the certificate. The following renewal status are
	// possible:
	//
	// * PendingAutoRenewal - Lightsail is attempting to automatically
	// validate the domain names of the certificate. No further action is required.
	//
	// *
	// PendingValidation - Lightsail couldn't automatically validate one or more domain
	// names of the certificate. You must take action to validate these domain names or
	// the certificate won't be renewed. Check to make sure your certificate's domain
	// validation records exist in your domain's DNS, and that your certificate remains
	// in use.
	//
	// * Success - All domain names in the certificate are validated, and
	// Lightsail renewed the certificate. No further action is required.
	//
	// * Failed -
	// One or more domain names were not validated before the certificate expired, and
	// Lightsail did not renew the certificate. You can request a new certificate using
	// the CreateCertificate action.
	RenewalStatus LoadBalancerTlsCertificateRenewalStatus

	noSmithyDocumentSerde
}

// Provides a summary of SSL/TLS certificate metadata.
type LoadBalancerTlsCertificateSummary struct {

	// When true, the SSL/TLS certificate is attached to the Lightsail load balancer.
	IsAttached *bool

	// The name of the SSL/TLS certificate.
	Name *string

	noSmithyDocumentSerde
}

// Describes the TLS security policies that are available for Lightsail load
// balancers. For more information about load balancer TLS security policies, see
// Configuring TLS security policies on your Amazon Lightsail load balancers
// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-configure-load-balancer-tls-security-policy)
// in the Amazon Lightsail Developer Guide.
type LoadBalancerTlsPolicy struct {

	// The ciphers used by the TLS security policy. The ciphers are listed in order of
	// preference.
	Ciphers []string

	// The description of the TLS security policy.
	Description *string

	// A Boolean value that indicates whether the TLS security policy is the default.
	IsDefault *bool

	// The name of the TLS security policy.
	Name *string

	// The protocols used in a given TLS security policy.
	Protocols []string

	noSmithyDocumentSerde
}

// Describes a database log event.
type LogEvent struct {

	// The timestamp when the database log event was created.
	CreatedAt *time.Time

	// The message of the database log event.
	Message *string

	noSmithyDocumentSerde
}

// Describes the metric data point.
type MetricDatapoint struct {

	// The average.
	Average *float64

	// The maximum.
	Maximum *float64

	// The minimum.
	Minimum *float64

	// The sample count.
	SampleCount *float64

	// The sum.
	Sum *float64

	// The timestamp (e.g., 1479816991.349).
	Timestamp *time.Time

	// The unit.
	Unit MetricUnit

	noSmithyDocumentSerde
}

// Describes resource being monitored by an alarm. An alarm is a way to monitor
// your Amazon Lightsail resource metrics. For more information, see Alarms in
// Amazon Lightsail
// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-alarms).
type MonitoredResourceInfo struct {

	// The Amazon Resource Name (ARN) of the resource being monitored.
	Arn *string

	// The name of the Lightsail resource being monitored.
	Name *string

	// The Lightsail resource type of the resource being monitored. Instances, load
	// balancers, and relational databases are the only Lightsail resources that can
	// currently be monitored by alarms.
	ResourceType ResourceType

	noSmithyDocumentSerde
}

// Describes the monthly data transfer in and out of your virtual private server
// (or instance).
type MonthlyTransfer struct {

	// The amount allocated per month (in GB).
	GbPerMonthAllocated *int32

	noSmithyDocumentSerde
}

// Describes the state of the name server records update made by Amazon Lightsail
// to an Amazon Route 53 registered domain. For more information, see DNS in Amazon
// Lightsail
// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/understanding-dns-in-amazon-lightsail)
// in the Amazon Lightsail Developer Guide.
type NameServersUpdateState struct {

	// The status code for the name servers update. Following are the possible
	// values:
	//
	// * SUCCEEDED - The name server records were successfully updated.
	//
	// *
	// PENDING - The name server record update is in progress.
	//
	// * FAILED - The name
	// server record update failed.
	//
	// * STARTED - The automatic name server record
	// update started.
	Code NameServersUpdateStateCode

	// The message that describes the reason for the status code.
	Message *string

	noSmithyDocumentSerde
}

// Describes the API operation.
type Operation struct {

	// The timestamp when the operation was initialized (e.g., 1479816991.349).
	CreatedAt *time.Time

	// The error code.
	ErrorCode *string

	// The error details.
	ErrorDetails *string

	// The ID of the operation.
	Id *string

	// A Boolean value indicating whether the operation is terminal.
	IsTerminal *bool

	// The Amazon Web Services Region and Availability Zone.
	Location *ResourceLocation

	// Details about the operation (e.g., Debian-1GB-Ohio-1).
	OperationDetails *string

	// The type of operation.
	OperationType OperationType

	// The resource name.
	ResourceName *string

	// The resource type.
	ResourceType ResourceType

	// The status of the operation.
	Status OperationStatus

	// The timestamp when the status was changed (e.g., 1479816991.349).
	StatusChangedAt *time.Time

	noSmithyDocumentSerde
}

// Describes the origin resource of an Amazon Lightsail content delivery network
// (CDN) distribution. An origin can be a Lightsail instance, bucket, or load
// balancer. A distribution pulls content from an origin, caches it, and serves it
// to viewers via a worldwide network of edge servers.
type Origin struct {

	// The name of the origin resource.
	Name *string

	// The protocol that your Amazon Lightsail distribution uses when establishing a
	// connection with your origin to pull content.
	ProtocolPolicy OriginProtocolPolicyEnum

	// The AWS Region name of the origin resource.
	RegionName RegionName

	// The resource type of the origin resource (e.g., Instance).
	ResourceType ResourceType

	noSmithyDocumentSerde
}

// The password data for the Windows Server-based instance, including the
// ciphertext and the key pair name.
type PasswordData struct {

	// The encrypted password. Ciphertext will be an empty string if access to your new
	// instance is not ready yet. When you create an instance, it can take up to 15
	// minutes for the instance to be ready. If you use the default key pair
	// (LightsailDefaultKeyPair), the decrypted password will be available in the
	// password field. If you are using a custom key pair, you need to use your own
	// means of decryption. If you change the Administrator password on the instance,
	// Lightsail will continue to return the original ciphertext value. When accessing
	// the instance using RDP, you need to manually enter the Administrator password
	// after changing it from the default.
	Ciphertext *string

	// The name of the key pair that you used when creating your instance. If no key
	// pair name was specified when creating the instance, Lightsail uses the default
	// key pair (LightsailDefaultKeyPair). If you are using a custom key pair, you need
	// to use your own means of decrypting your password using the ciphertext.
	// Lightsail creates the ciphertext by encrypting your password with the public key
	// part of this key pair.
	KeyPairName *string

	noSmithyDocumentSerde
}

// Describes a pending database maintenance action.
type PendingMaintenanceAction struct {

	// The type of pending database maintenance action.
	Action *string

	// The effective date of the pending database maintenance action.
	CurrentApplyDate *time.Time

	// Additional detail about the pending database maintenance action.
	Description *string

	noSmithyDocumentSerde
}

// Describes a pending database value modification.
type PendingModifiedRelationalDatabaseValues struct {

	// A Boolean value indicating whether automated backup retention is enabled.
	BackupRetentionEnabled *bool

	// The database engine version.
	EngineVersion *string

	// The password for the master user of the database.
	MasterUserPassword *string

	noSmithyDocumentSerde
}

// Describes ports to open on an instance, the IP addresses allowed to connect to
// the instance through the ports, and the protocol.
type PortInfo struct {

	// An alias that defines access for a preconfigured range of IP addresses. The only
	// alias currently supported is lightsail-connect, which allows IP addresses of the
	// browser-based RDP/SSH client in the Lightsail console to connect to your
	// instance.
	CidrListAliases []string

	// The IPv4 address, or range of IPv4 addresses (in CIDR notation) that are allowed
	// to connect to an instance through the ports, and the protocol. The ipv6Cidrs
	// parameter lists the IPv6 addresses that are allowed to connect to an instance.
	// Examples:
	//
	// * To allow the IP address 192.0.2.44, specify 192.0.2.44 or
	// 192.0.2.44/32.
	//
	// * To allow the IP addresses 192.0.2.0 to 192.0.2.255, specify
	// 192.0.2.0/24.
	//
	// For more information about CIDR block notation, see Classless
	// Inter-Domain Routing
	// (https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation) on
	// Wikipedia.
	Cidrs []string

	// The first port in a range of open ports on an instance. Allowed ports:
	//
	// * TCP
	// and UDP - 0 to 65535
	//
	// * ICMP - The ICMP type for IPv4 addresses. For example,
	// specify 8 as the fromPort (ICMP type), and -1 as the toPort (ICMP code), to
	// enable ICMP Ping. For more information, see Control Messages
	// (https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol#Control_messages)
	// on Wikipedia.
	//
	// * ICMPv6 - The ICMP type for IPv6 addresses. For example, specify
	// 128 as the fromPort (ICMPv6 type), and 0 as toPort (ICMPv6 code). For more
	// information, see Internet Control Message Protocol for IPv6
	// (https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol_for_IPv6).
	FromPort int32

	// The IPv6 address, or range of IPv6 addresses (in CIDR notation) that are allowed
	// to connect to an instance through the ports, and the protocol. Only devices with
	// an IPv6 address can connect to an instance through IPv6; otherwise, IPv4 should
	// be used. The cidrs parameter lists the IPv4 addresses that are allowed to
	// connect to an instance. For more information about CIDR block notation, see
	// Classless Inter-Domain Routing
	// (https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing#CIDR_notation) on
	// Wikipedia.
	Ipv6Cidrs []string

	// The IP protocol name. The name can be one of the following:
	//
	// * tcp -
	// Transmission Control Protocol (TCP) provides reliable, ordered, and
	// error-checked delivery of streamed data between applications running on hosts
	// communicating by an IP network. If you have an application that doesn't require
	// reliable data stream service, use UDP instead.
	//
	// * all - All transport layer
	// protocol types. For more general information, see Transport layer
	// (https://en.wikipedia.org/wiki/Transport_layer) on Wikipedia.
	//
	// * udp - With User
	// Datagram Protocol (UDP), computer applications can send messages (or datagrams)
	// to other hosts on an Internet Protocol (IP) network. Prior communications are
	// not required to set up transmission channels or data paths. Applications that
	// don't require reliable data stream service can use UDP, which provides a
	// connectionless datagram service that emphasizes reduced latency over
	// reliability. If you do require reliable data stream service, use TCP instead.
	//
	// *
	// icmp - Internet Control Message Protocol (ICMP) is used to send error messages
	// and operational information indicating success or failure when communicating
	// with an instance. For example, an error is indicated when an instance could not
	// be reached. When you specify icmp as the protocol, you must specify the ICMP
	// type using the fromPort parameter, and ICMP code using the toPort parameter.
	Protocol NetworkProtocol

	// The last port in a range of open ports on an instance. Allowed ports:
	//
	// * TCP and
	// UDP - 0 to 65535
	//
	// * ICMP - The ICMP code for IPv4 addresses. For example,
	// specify 8 as the fromPort (ICMP type), and -1 as the toPort (ICMP code), to
	// enable ICMP Ping. For more information, see Control Messages
	// (https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol#Control_messages)
	// on Wikipedia.
	//
	// * ICMPv6 - The ICMP code for IPv6 addresses. For example, specify
	// 128 as the fromPort (ICMPv6 type), and 0 as toPort (ICMPv6 code). For more
	// information, see Internet Control Message Protocol for IPv6
	// (https://en.wikipedia.org/wiki/Internet_Control_Message_Protocol_for_IPv6).
	ToPort int32

	noSmithyDocumentSerde
}

// Describes the configuration for an Amazon Lightsail container service to access
// private container image repositories, such as Amazon Elastic Container Registry
// (Amazon ECR) private repositories. For more information, see Configuring access
// to an Amazon ECR private repository for an Amazon Lightsail container service
// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-container-service-ecr-private-repo-access)
// in the Amazon Lightsail Developer Guide.
type PrivateRegistryAccess struct {

	// An object that describes the activation status of the role that you can use to
	// grant a Lightsail container service access to Amazon ECR private repositories.
	// If the role is activated, the Amazon Resource Name (ARN) of the role is also
	// listed.
	EcrImagePullerRole *ContainerServiceECRImagePullerRole

	noSmithyDocumentSerde
}

// Describes a request to configure an Amazon Lightsail container service to access
// private container image repositories, such as Amazon Elastic Container Registry
// (Amazon ECR) private repositories. For more information, see Configuring access
// to an Amazon ECR private repository for an Amazon Lightsail container service
// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-container-service-ecr-private-repo-access)
// in the Amazon Lightsail Developer Guide.
type PrivateRegistryAccessRequest struct {

	// An object to describe a request to activate or deactivate the role that you can
	// use to grant an Amazon Lightsail container service access to Amazon Elastic
	// Container Registry (Amazon ECR) private repositories.
	EcrImagePullerRole *ContainerServiceECRImagePullerRoleRequest

	noSmithyDocumentSerde
}

// Describes the query string parameters that an Amazon Lightsail content delivery
// network (CDN) distribution to bases caching on. For the query strings that you
// specify, your distribution caches separate versions of the specified content
// based on the query string values in viewer requests.
type QueryStringObject struct {

	// Indicates whether the distribution forwards and caches based on query strings.
	Option *bool

	// The specific query strings that the distribution forwards to the origin. Your
	// distribution will cache content based on the specified query strings. If the
	// option parameter is true, then your distribution forwards all query strings,
	// regardless of what you specify using the queryStringsAllowList parameter.
	QueryStringsAllowList []string

	noSmithyDocumentSerde
}

// Describes the deletion state of an Amazon Route 53 hosted zone for a domain that
// is being automatically delegated to an Amazon Lightsail DNS zone.
type R53HostedZoneDeletionState struct {

	// The status code for the deletion state. Following are the possible values:
	//
	// *
	// SUCCEEDED - The hosted zone was successfully deleted.
	//
	// * PENDING - The hosted
	// zone deletion is in progress.
	//
	// * FAILED - The hosted zone deletion failed.
	//
	// *
	// STARTED - The hosted zone deletion started.
	Code R53HostedZoneDeletionStateCode

	// The message that describes the reason for the status code.
	Message *string

	noSmithyDocumentSerde
}

// Describes the Amazon Web Services Region.
type Region struct {

	// The Availability Zones. Follows the format us-east-2a (case-sensitive).
	AvailabilityZones []AvailabilityZone

	// The continent code (e.g., NA, meaning North America).
	ContinentCode *string

	// The description of the Amazon Web Services Region (e.g., This region is
	// recommended to serve users in the eastern United States and eastern Canada).
	Description *string

	// The display name (e.g., Ohio).
	DisplayName *string

	// The region name (e.g., us-east-2).
	Name RegionName

	// The Availability Zones for databases. Follows the format us-east-2a
	// (case-sensitive).
	RelationalDatabaseAvailabilityZones []AvailabilityZone

	noSmithyDocumentSerde
}

// Describes the delegation state of an Amazon Route 53 registered domain to Amazon
// Lightsail. When you delegate an Amazon Route 53 registered domain to Lightsail,
// you can manage the DNS of the domain using a Lightsail DNS zone. You no longer
// use the Route 53 hosted zone to manage the DNS of the domain. To delegate the
// domain, Lightsail automatically updates the domain's name servers in Route 53 to
// the name servers of the Lightsail DNS zone. Then, Lightsail automatically
// deletes the Route 53 hosted zone for the domain. All of the following conditions
// must be true for automatic domain delegation to be successful:
//
// * The registered
// domain must be in the same Amazon Web Services account as the Lightsail account
// making the request.
//
// * The user or entity making the request must have
// permission to manage domains in Route 53.
//
// * The Route 53 hosted zone for the
// domain must be empty. It cannot contain DNS records other than start of
// authority (SOA) and name server records.
//
// If automatic domain delegation fails,
// or if you manage the DNS of your domain using a service other than Route 53,
// then you must manually add the Lightsail DNS zone name servers to your domain in
// order to delegate management of its DNS to Lightsail. For more information, see
// Creating a DNS zone to manage your domain’s records in Amazon Lightsail
// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/lightsail-how-to-create-dns-entry)
// in the Amazon Lightsail Developer Guide.
type RegisteredDomainDelegationInfo struct {

	// An object that describes the state of the name server records that are
	// automatically added to the Route 53 domain by Lightsail.
	NameServersUpdateState *NameServersUpdateState

	// Describes the deletion state of an Amazon Route 53 hosted zone for a domain that
	// is being automatically delegated to an Amazon Lightsail DNS zone.
	R53HostedZoneDeletionState *R53HostedZoneDeletionState

	noSmithyDocumentSerde
}

// Describes a database.
type RelationalDatabase struct {

	// The Amazon Resource Name (ARN) of the database.
	Arn *string

	// A Boolean value indicating whether automated backup retention is enabled for the
	// database.
	BackupRetentionEnabled *bool

	// The certificate associated with the database.
	CaCertificateIdentifier *string

	// The timestamp when the database was created. Formatted in Unix time.
	CreatedAt *time.Time

	// The database software (for example, MySQL).
	Engine *string

	// The database engine version (for example, 5.7.23).
	EngineVersion *string

	// Describes the hardware of the database.
	Hardware *RelationalDatabaseHardware

	// The latest point in time to which the database can be restored. Formatted in
	// Unix time.
	LatestRestorableTime *time.Time

	// The Region name and Availability Zone where the database is located.
	Location *ResourceLocation

	// The name of the master database created when the Lightsail database resource is
	// created.
	MasterDatabaseName *string

	// The master endpoint for the database.
	MasterEndpoint *RelationalDatabaseEndpoint

	// The master user name of the database.
	MasterUsername *string

	// The unique name of the database resource in Lightsail.
	Name *string

	// The status of parameter updates for the database.
	ParameterApplyStatus *string

	// Describes the pending maintenance actions for the database.
	PendingMaintenanceActions []PendingMaintenanceAction

	// Describes pending database value modifications.
	PendingModifiedValues *PendingModifiedRelationalDatabaseValues

	// The daily time range during which automated backups are created for the database
	// (for example, 16:00-16:30).
	PreferredBackupWindow *string

	// The weekly time range during which system maintenance can occur on the database.
	// In the format ddd:hh24:mi-ddd:hh24:mi. For example, Tue:17:00-Tue:17:30.
	PreferredMaintenanceWindow *string

	// A Boolean value indicating whether the database is publicly accessible.
	PubliclyAccessible *bool

	// The blueprint ID for the database. A blueprint describes the major engine
	// version of a database.
	RelationalDatabaseBlueprintId *string

	// The bundle ID for the database. A bundle describes the performance
	// specifications for your database.
	RelationalDatabaseBundleId *string

	// The Lightsail resource type for the database (for example, RelationalDatabase).
	ResourceType ResourceType

	// Describes the secondary Availability Zone of a high availability database. The
	// secondary database is used for failover support of a high availability database.
	SecondaryAvailabilityZone *string

	// Describes the current state of the database.
	State *string

	// The support code for the database. Include this code in your email to support
	// when you have questions about a database in Lightsail. This code enables our
	// support team to look up your Lightsail information more easily.
	SupportCode *string

	// The tag keys and optional values for the resource. For more information about
	// tags in Lightsail, see the Amazon Lightsail Developer Guide
	// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
	Tags []Tag

	noSmithyDocumentSerde
}

// Describes a database image, or blueprint. A blueprint describes the major engine
// version of a database.
type RelationalDatabaseBlueprint struct {

	// The ID for the database blueprint.
	BlueprintId *string

	// The database software of the database blueprint (for example, MySQL).
	Engine RelationalDatabaseEngine

	// The description of the database engine for the database blueprint.
	EngineDescription *string

	// The database engine version for the database blueprint (for example, 5.7.23).
	EngineVersion *string

	// The description of the database engine version for the database blueprint.
	EngineVersionDescription *string

	// A Boolean value indicating whether the engine version is the default for the
	// database blueprint.
	IsEngineDefault *bool

	noSmithyDocumentSerde
}

// Describes a database bundle. A bundle describes the performance specifications
// of the database.
type RelationalDatabaseBundle struct {

	// The ID for the database bundle.
	BundleId *string

	// The number of virtual CPUs (vCPUs) for the database bundle.
	CpuCount *int32

	// The size of the disk for the database bundle.
	DiskSizeInGb *int32

	// A Boolean value indicating whether the database bundle is active.
	IsActive *bool

	// A Boolean value indicating whether the database bundle is encrypted.
	IsEncrypted *bool

	// The name for the database bundle.
	Name *string

	// The cost of the database bundle in US currency.
	Price *float32

	// The amount of RAM in GB (for example, 2.0) for the database bundle.
	RamSizeInGb *float32

	// The data transfer rate per month in GB for the database bundle.
	TransferPerMonthInGb *int32

	noSmithyDocumentSerde
}

// Describes an endpoint for a database.
type RelationalDatabaseEndpoint struct {

	// Specifies the DNS address of the database.
	Address *string

	// Specifies the port that the database is listening on.
	Port *int32

	noSmithyDocumentSerde
}

// Describes an event for a database.
type RelationalDatabaseEvent struct {

	// The timestamp when the database event was created.
	CreatedAt *time.Time

	// The category that the database event belongs to.
	EventCategories []string

	// The message of the database event.
	Message *string

	// The database that the database event relates to.
	Resource *string

	noSmithyDocumentSerde
}

// Describes the hardware of a database.
type RelationalDatabaseHardware struct {

	// The number of vCPUs for the database.
	CpuCount *int32

	// The size of the disk for the database.
	DiskSizeInGb *int32

	// The amount of RAM in GB for the database.
	RamSizeInGb *float32

	noSmithyDocumentSerde
}

// Describes the parameters of a database.
type RelationalDatabaseParameter struct {

	// Specifies the valid range of values for the parameter.
	AllowedValues *string

	// Indicates when parameter updates are applied. Can be immediate or
	// pending-reboot.
	ApplyMethod *string

	// Specifies the engine-specific parameter type.
	ApplyType *string

	// Specifies the valid data type for the parameter.
	DataType *string

	// Provides a description of the parameter.
	Description *string

	// A Boolean value indicating whether the parameter can be modified.
	IsModifiable *bool

	// Specifies the name of the parameter.
	ParameterName *string

	// Specifies the value of the parameter.
	ParameterValue *string

	noSmithyDocumentSerde
}

// Describes a database snapshot.
type RelationalDatabaseSnapshot struct {

	// The Amazon Resource Name (ARN) of the database snapshot.
	Arn *string

	// The timestamp when the database snapshot was created.
	CreatedAt *time.Time

	// The software of the database snapshot (for example, MySQL)
	Engine *string

	// The database engine version for the database snapshot (for example, 5.7.23).
	EngineVersion *string

	// The Amazon Resource Name (ARN) of the database from which the database snapshot
	// was created.
	FromRelationalDatabaseArn *string

	// The blueprint ID of the database from which the database snapshot was created. A
	// blueprint describes the major engine version of a database.
	FromRelationalDatabaseBlueprintId *string

	// The bundle ID of the database from which the database snapshot was created.
	FromRelationalDatabaseBundleId *string

	// The name of the source database from which the database snapshot was created.
	FromRelationalDatabaseName *string

	// The Region name and Availability Zone where the database snapshot is located.
	Location *ResourceLocation

	// The name of the database snapshot.
	Name *string

	// The Lightsail resource type.
	ResourceType ResourceType

	// The size of the disk in GB (for example, 32) for the database snapshot.
	SizeInGb *int32

	// The state of the database snapshot.
	State *string

	// The support code for the database snapshot. Include this code in your email to
	// support when you have questions about a database snapshot in Lightsail. This
	// code enables our support team to look up your Lightsail information more easily.
	SupportCode *string

	// The tag keys and optional values for the resource. For more information about
	// tags in Lightsail, see the Amazon Lightsail Developer Guide
	// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
	Tags []Tag

	noSmithyDocumentSerde
}

// Describes the status of a SSL/TLS certificate renewal managed by Amazon
// Lightsail.
type RenewalSummary struct {

	// An array of objects that describe the domain validation records of the
	// certificate.
	DomainValidationRecords []DomainValidationRecord

	// The renewal status of the certificate. The following renewal status are
	// possible:
	//
	// * PendingAutoRenewal - Lightsail is attempting to automatically
	// validate the domain names of the certificate. No further action is required.
	//
	// *
	// PendingValidation - Lightsail couldn't automatically validate one or more domain
	// names of the certificate. You must take action to validate these domain names or
	// the certificate won't be renewed. Check to make sure your certificate's domain
	// validation records exist in your domain's DNS, and that your certificate remains
	// in use.
	//
	// * Success - All domain names in the certificate are validated, and
	// Lightsail renewed the certificate. No further action is required.
	//
	// * Failed -
	// One or more domain names were not validated before the certificate expired, and
	// Lightsail did not renew the certificate. You can request a new certificate using
	// the CreateCertificate action.
	RenewalStatus RenewalStatus

	// The reason for the renewal status of the certificate.
	RenewalStatusReason *string

	// The timestamp when the certificate was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Describes the resource location.
type ResourceLocation struct {

	// The Availability Zone. Follows the format us-east-2a (case-sensitive).
	AvailabilityZone *string

	// The Amazon Web Services Region name.
	RegionName RegionName

	noSmithyDocumentSerde
}

// Describes an Amazon Lightsail instance that has access to a Lightsail bucket.
type ResourceReceivingAccess struct {

	// The name of the Lightsail instance.
	Name *string

	// The Lightsail resource type (for example, Instance).
	ResourceType *string

	noSmithyDocumentSerde
}

// Describes the domain name system (DNS) records to add to your domain's DNS to
// validate it for an Amazon Lightsail certificate.
type ResourceRecord struct {

	// The name of the record.
	Name *string

	// The DNS record type.
	Type *string

	// The value for the DNS record.
	Value *string

	noSmithyDocumentSerde
}

// Describes a static IP.
type StaticIp struct {

	// The Amazon Resource Name (ARN) of the static IP (e.g.,
	// arn:aws:lightsail:us-east-2:123456789101:StaticIp/9cbb4a9e-f8e3-4dfe-b57e-12345EXAMPLE).
	Arn *string

	// The instance where the static IP is attached (e.g., Amazon_Linux-1GB-Ohio-1).
	AttachedTo *string

	// The timestamp when the static IP was created (e.g., 1479735304.222).
	CreatedAt *time.Time

	// The static IP address.
	IpAddress *string

	// A Boolean value indicating whether the static IP is attached.
	IsAttached *bool

	// The region and Availability Zone where the static IP was created.
	Location *ResourceLocation

	// The name of the static IP (e.g., StaticIP-Ohio-EXAMPLE).
	Name *string

	// The resource type (usually StaticIp).
	ResourceType ResourceType

	// The support code. Include this code in your email to support when you have
	// questions about an instance or another resource in Lightsail. This code enables
	// our support team to look up your Lightsail information more easily.
	SupportCode *string

	noSmithyDocumentSerde
}

// Describes a tag key and optional value assigned to an Amazon Lightsail resource.
// For more information about tags in Lightsail, see the Amazon Lightsail Developer
// Guide
// (https://lightsail.aws.amazon.com/ls/docs/en_us/articles/amazon-lightsail-tags).
type Tag struct {

	// The key of the tag. Constraints: Tag keys accept a maximum of 128 letters,
	// numbers, spaces in UTF-8, or the following characters: + - = . _ : / @
	Key *string

	// The value of the tag. Constraints: Tag values accept a maximum of 256 letters,
	// numbers, spaces in UTF-8, or the following characters: + - = . _ : / @
	Value *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
