// Code generated by smithy-go-codegen DO NOT EDIT.

package customerprofiles

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/customerprofiles/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsRestjson1_serializeOpAddProfileKey struct {
}

func (*awsRestjson1_serializeOpAddProfileKey) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpAddProfileKey) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AddProfileKeyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains/{DomainName}/profiles/keys")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsAddProfileKeyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentAddProfileKeyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsAddProfileKeyInput(v *AddProfileKeyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentAddProfileKeyInput(v *AddProfileKeyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KeyName != nil {
		ok := object.Key("KeyName")
		ok.String(*v.KeyName)
	}

	if v.ProfileId != nil {
		ok := object.Key("ProfileId")
		ok.String(*v.ProfileId)
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsRestjson1_serializeDocumentRequestValueList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateDomain struct {
}

func (*awsRestjson1_serializeOpCreateDomain) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateDomain) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateDomainInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains/{DomainName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateDomainInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateDomainInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateDomainInput(v *CreateDomainInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateDomainInput(v *CreateDomainInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeadLetterQueueUrl != nil {
		ok := object.Key("DeadLetterQueueUrl")
		ok.String(*v.DeadLetterQueueUrl)
	}

	if v.DefaultEncryptionKey != nil {
		ok := object.Key("DefaultEncryptionKey")
		ok.String(*v.DefaultEncryptionKey)
	}

	if v.DefaultExpirationDays != nil {
		ok := object.Key("DefaultExpirationDays")
		ok.Integer(*v.DefaultExpirationDays)
	}

	if v.Matching != nil {
		ok := object.Key("Matching")
		if err := awsRestjson1_serializeDocumentMatchingRequest(v.Matching, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateIntegrationWorkflow struct {
}

func (*awsRestjson1_serializeOpCreateIntegrationWorkflow) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateIntegrationWorkflow) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateIntegrationWorkflowInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains/{DomainName}/workflows/integrations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateIntegrationWorkflowInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateIntegrationWorkflowInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateIntegrationWorkflowInput(v *CreateIntegrationWorkflowInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateIntegrationWorkflowInput(v *CreateIntegrationWorkflowInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IntegrationConfig != nil {
		ok := object.Key("IntegrationConfig")
		if err := awsRestjson1_serializeDocumentIntegrationConfig(v.IntegrationConfig, ok); err != nil {
			return err
		}
	}

	if v.ObjectTypeName != nil {
		ok := object.Key("ObjectTypeName")
		ok.String(*v.ObjectTypeName)
	}

	if v.RoleArn != nil {
		ok := object.Key("RoleArn")
		ok.String(*v.RoleArn)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if len(v.WorkflowType) > 0 {
		ok := object.Key("WorkflowType")
		ok.String(string(v.WorkflowType))
	}

	return nil
}

type awsRestjson1_serializeOpCreateProfile struct {
}

func (*awsRestjson1_serializeOpCreateProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains/{DomainName}/profiles")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateProfileInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateProfileInput(v *CreateProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateProfileInput(v *CreateProfileInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountNumber != nil {
		ok := object.Key("AccountNumber")
		ok.String(*v.AccountNumber)
	}

	if v.AdditionalInformation != nil {
		ok := object.Key("AdditionalInformation")
		ok.String(*v.AdditionalInformation)
	}

	if v.Address != nil {
		ok := object.Key("Address")
		if err := awsRestjson1_serializeDocumentAddress(v.Address, ok); err != nil {
			return err
		}
	}

	if v.Attributes != nil {
		ok := object.Key("Attributes")
		if err := awsRestjson1_serializeDocumentAttributes(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.BillingAddress != nil {
		ok := object.Key("BillingAddress")
		if err := awsRestjson1_serializeDocumentAddress(v.BillingAddress, ok); err != nil {
			return err
		}
	}

	if v.BirthDate != nil {
		ok := object.Key("BirthDate")
		ok.String(*v.BirthDate)
	}

	if v.BusinessEmailAddress != nil {
		ok := object.Key("BusinessEmailAddress")
		ok.String(*v.BusinessEmailAddress)
	}

	if v.BusinessName != nil {
		ok := object.Key("BusinessName")
		ok.String(*v.BusinessName)
	}

	if v.BusinessPhoneNumber != nil {
		ok := object.Key("BusinessPhoneNumber")
		ok.String(*v.BusinessPhoneNumber)
	}

	if v.EmailAddress != nil {
		ok := object.Key("EmailAddress")
		ok.String(*v.EmailAddress)
	}

	if v.FirstName != nil {
		ok := object.Key("FirstName")
		ok.String(*v.FirstName)
	}

	if len(v.Gender) > 0 {
		ok := object.Key("Gender")
		ok.String(string(v.Gender))
	}

	if v.GenderString != nil {
		ok := object.Key("GenderString")
		ok.String(*v.GenderString)
	}

	if v.HomePhoneNumber != nil {
		ok := object.Key("HomePhoneNumber")
		ok.String(*v.HomePhoneNumber)
	}

	if v.LastName != nil {
		ok := object.Key("LastName")
		ok.String(*v.LastName)
	}

	if v.MailingAddress != nil {
		ok := object.Key("MailingAddress")
		if err := awsRestjson1_serializeDocumentAddress(v.MailingAddress, ok); err != nil {
			return err
		}
	}

	if v.MiddleName != nil {
		ok := object.Key("MiddleName")
		ok.String(*v.MiddleName)
	}

	if v.MobilePhoneNumber != nil {
		ok := object.Key("MobilePhoneNumber")
		ok.String(*v.MobilePhoneNumber)
	}

	if len(v.PartyType) > 0 {
		ok := object.Key("PartyType")
		ok.String(string(v.PartyType))
	}

	if v.PartyTypeString != nil {
		ok := object.Key("PartyTypeString")
		ok.String(*v.PartyTypeString)
	}

	if v.PersonalEmailAddress != nil {
		ok := object.Key("PersonalEmailAddress")
		ok.String(*v.PersonalEmailAddress)
	}

	if v.PhoneNumber != nil {
		ok := object.Key("PhoneNumber")
		ok.String(*v.PhoneNumber)
	}

	if v.ShippingAddress != nil {
		ok := object.Key("ShippingAddress")
		if err := awsRestjson1_serializeDocumentAddress(v.ShippingAddress, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteDomain struct {
}

func (*awsRestjson1_serializeOpDeleteDomain) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteDomain) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteDomainInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains/{DomainName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteDomainInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteDomainInput(v *DeleteDomainInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteIntegration struct {
}

func (*awsRestjson1_serializeOpDeleteIntegration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteIntegration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteIntegrationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains/{DomainName}/integrations/delete")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteIntegrationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDeleteIntegrationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteIntegrationInput(v *DeleteIntegrationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDeleteIntegrationInput(v *DeleteIntegrationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Uri != nil {
		ok := object.Key("Uri")
		ok.String(*v.Uri)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteProfile struct {
}

func (*awsRestjson1_serializeOpDeleteProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains/{DomainName}/profiles/delete")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDeleteProfileInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteProfileInput(v *DeleteProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDeleteProfileInput(v *DeleteProfileInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ProfileId != nil {
		ok := object.Key("ProfileId")
		ok.String(*v.ProfileId)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteProfileKey struct {
}

func (*awsRestjson1_serializeOpDeleteProfileKey) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteProfileKey) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteProfileKeyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains/{DomainName}/profiles/keys/delete")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteProfileKeyInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDeleteProfileKeyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteProfileKeyInput(v *DeleteProfileKeyInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDeleteProfileKeyInput(v *DeleteProfileKeyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KeyName != nil {
		ok := object.Key("KeyName")
		ok.String(*v.KeyName)
	}

	if v.ProfileId != nil {
		ok := object.Key("ProfileId")
		ok.String(*v.ProfileId)
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsRestjson1_serializeDocumentRequestValueList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteProfileObject struct {
}

func (*awsRestjson1_serializeOpDeleteProfileObject) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteProfileObject) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteProfileObjectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains/{DomainName}/profiles/objects/delete")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteProfileObjectInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentDeleteProfileObjectInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteProfileObjectInput(v *DeleteProfileObjectInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentDeleteProfileObjectInput(v *DeleteProfileObjectInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ObjectTypeName != nil {
		ok := object.Key("ObjectTypeName")
		ok.String(*v.ObjectTypeName)
	}

	if v.ProfileId != nil {
		ok := object.Key("ProfileId")
		ok.String(*v.ProfileId)
	}

	if v.ProfileObjectUniqueKey != nil {
		ok := object.Key("ProfileObjectUniqueKey")
		ok.String(*v.ProfileObjectUniqueKey)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteProfileObjectType struct {
}

func (*awsRestjson1_serializeOpDeleteProfileObjectType) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteProfileObjectType) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteProfileObjectTypeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains/{DomainName}/object-types/{ObjectTypeName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteProfileObjectTypeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteProfileObjectTypeInput(v *DeleteProfileObjectTypeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	if v.ObjectTypeName == nil || len(*v.ObjectTypeName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ObjectTypeName must not be empty")}
	}
	if v.ObjectTypeName != nil {
		if err := encoder.SetURI("ObjectTypeName").String(*v.ObjectTypeName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteWorkflow struct {
}

func (*awsRestjson1_serializeOpDeleteWorkflow) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteWorkflow) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteWorkflowInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains/{DomainName}/workflows/{WorkflowId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteWorkflowInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteWorkflowInput(v *DeleteWorkflowInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	if v.WorkflowId == nil || len(*v.WorkflowId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member WorkflowId must not be empty")}
	}
	if v.WorkflowId != nil {
		if err := encoder.SetURI("WorkflowId").String(*v.WorkflowId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetAutoMergingPreview struct {
}

func (*awsRestjson1_serializeOpGetAutoMergingPreview) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetAutoMergingPreview) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetAutoMergingPreviewInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains/{DomainName}/identity-resolution-jobs/auto-merging-preview")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetAutoMergingPreviewInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetAutoMergingPreviewInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetAutoMergingPreviewInput(v *GetAutoMergingPreviewInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetAutoMergingPreviewInput(v *GetAutoMergingPreviewInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConflictResolution != nil {
		ok := object.Key("ConflictResolution")
		if err := awsRestjson1_serializeDocumentConflictResolution(v.ConflictResolution, ok); err != nil {
			return err
		}
	}

	if v.Consolidation != nil {
		ok := object.Key("Consolidation")
		if err := awsRestjson1_serializeDocumentConsolidation(v.Consolidation, ok); err != nil {
			return err
		}
	}

	if v.MinAllowedConfidenceScoreForMerging != nil {
		ok := object.Key("MinAllowedConfidenceScoreForMerging")
		switch {
		case math.IsNaN(*v.MinAllowedConfidenceScoreForMerging):
			ok.String("NaN")

		case math.IsInf(*v.MinAllowedConfidenceScoreForMerging, 1):
			ok.String("Infinity")

		case math.IsInf(*v.MinAllowedConfidenceScoreForMerging, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.MinAllowedConfidenceScoreForMerging)

		}
	}

	return nil
}

type awsRestjson1_serializeOpGetDomain struct {
}

func (*awsRestjson1_serializeOpGetDomain) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetDomain) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetDomainInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains/{DomainName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetDomainInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetDomainInput(v *GetDomainInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetIdentityResolutionJob struct {
}

func (*awsRestjson1_serializeOpGetIdentityResolutionJob) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetIdentityResolutionJob) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetIdentityResolutionJobInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains/{DomainName}/identity-resolution-jobs/{JobId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetIdentityResolutionJobInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetIdentityResolutionJobInput(v *GetIdentityResolutionJobInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	if v.JobId == nil || len(*v.JobId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member JobId must not be empty")}
	}
	if v.JobId != nil {
		if err := encoder.SetURI("JobId").String(*v.JobId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetIntegration struct {
}

func (*awsRestjson1_serializeOpGetIntegration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetIntegration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetIntegrationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains/{DomainName}/integrations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetIntegrationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetIntegrationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetIntegrationInput(v *GetIntegrationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetIntegrationInput(v *GetIntegrationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Uri != nil {
		ok := object.Key("Uri")
		ok.String(*v.Uri)
	}

	return nil
}

type awsRestjson1_serializeOpGetMatches struct {
}

func (*awsRestjson1_serializeOpGetMatches) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetMatches) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetMatchesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains/{DomainName}/matches")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetMatchesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetMatchesInput(v *GetMatchesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpGetProfileObjectType struct {
}

func (*awsRestjson1_serializeOpGetProfileObjectType) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetProfileObjectType) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetProfileObjectTypeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains/{DomainName}/object-types/{ObjectTypeName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetProfileObjectTypeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetProfileObjectTypeInput(v *GetProfileObjectTypeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	if v.ObjectTypeName == nil || len(*v.ObjectTypeName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ObjectTypeName must not be empty")}
	}
	if v.ObjectTypeName != nil {
		if err := encoder.SetURI("ObjectTypeName").String(*v.ObjectTypeName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetProfileObjectTypeTemplate struct {
}

func (*awsRestjson1_serializeOpGetProfileObjectTypeTemplate) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetProfileObjectTypeTemplate) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetProfileObjectTypeTemplateInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/templates/{TemplateId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetProfileObjectTypeTemplateInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetProfileObjectTypeTemplateInput(v *GetProfileObjectTypeTemplateInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.TemplateId == nil || len(*v.TemplateId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member TemplateId must not be empty")}
	}
	if v.TemplateId != nil {
		if err := encoder.SetURI("TemplateId").String(*v.TemplateId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetWorkflow struct {
}

func (*awsRestjson1_serializeOpGetWorkflow) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetWorkflow) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetWorkflowInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains/{DomainName}/workflows/{WorkflowId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetWorkflowInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetWorkflowInput(v *GetWorkflowInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	if v.WorkflowId == nil || len(*v.WorkflowId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member WorkflowId must not be empty")}
	}
	if v.WorkflowId != nil {
		if err := encoder.SetURI("WorkflowId").String(*v.WorkflowId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetWorkflowSteps struct {
}

func (*awsRestjson1_serializeOpGetWorkflowSteps) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetWorkflowSteps) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetWorkflowStepsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains/{DomainName}/workflows/{WorkflowId}/steps")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetWorkflowStepsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetWorkflowStepsInput(v *GetWorkflowStepsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	if v.WorkflowId == nil || len(*v.WorkflowId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member WorkflowId must not be empty")}
	}
	if v.WorkflowId != nil {
		if err := encoder.SetURI("WorkflowId").String(*v.WorkflowId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListAccountIntegrations struct {
}

func (*awsRestjson1_serializeOpListAccountIntegrations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListAccountIntegrations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListAccountIntegrationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/integrations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListAccountIntegrationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListAccountIntegrationsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListAccountIntegrationsInput(v *ListAccountIntegrationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.IncludeHidden != nil {
		encoder.SetQuery("include-hidden").Boolean(*v.IncludeHidden)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListAccountIntegrationsInput(v *ListAccountIntegrationsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Uri != nil {
		ok := object.Key("Uri")
		ok.String(*v.Uri)
	}

	return nil
}

type awsRestjson1_serializeOpListDomains struct {
}

func (*awsRestjson1_serializeOpListDomains) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListDomains) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListDomainsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListDomainsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListDomainsInput(v *ListDomainsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListIdentityResolutionJobs struct {
}

func (*awsRestjson1_serializeOpListIdentityResolutionJobs) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListIdentityResolutionJobs) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListIdentityResolutionJobsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains/{DomainName}/identity-resolution-jobs")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListIdentityResolutionJobsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListIdentityResolutionJobsInput(v *ListIdentityResolutionJobsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListIntegrations struct {
}

func (*awsRestjson1_serializeOpListIntegrations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListIntegrations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListIntegrationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains/{DomainName}/integrations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListIntegrationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListIntegrationsInput(v *ListIntegrationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	if v.IncludeHidden != nil {
		encoder.SetQuery("include-hidden").Boolean(*v.IncludeHidden)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListProfileObjects struct {
}

func (*awsRestjson1_serializeOpListProfileObjects) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListProfileObjects) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListProfileObjectsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains/{DomainName}/profiles/objects")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListProfileObjectsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListProfileObjectsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListProfileObjectsInput(v *ListProfileObjectsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListProfileObjectsInput(v *ListProfileObjectsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ObjectFilter != nil {
		ok := object.Key("ObjectFilter")
		if err := awsRestjson1_serializeDocumentObjectFilter(v.ObjectFilter, ok); err != nil {
			return err
		}
	}

	if v.ObjectTypeName != nil {
		ok := object.Key("ObjectTypeName")
		ok.String(*v.ObjectTypeName)
	}

	if v.ProfileId != nil {
		ok := object.Key("ProfileId")
		ok.String(*v.ProfileId)
	}

	return nil
}

type awsRestjson1_serializeOpListProfileObjectTypes struct {
}

func (*awsRestjson1_serializeOpListProfileObjectTypes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListProfileObjectTypes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListProfileObjectTypesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains/{DomainName}/object-types")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListProfileObjectTypesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListProfileObjectTypesInput(v *ListProfileObjectTypesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListProfileObjectTypeTemplates struct {
}

func (*awsRestjson1_serializeOpListProfileObjectTypeTemplates) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListProfileObjectTypeTemplates) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListProfileObjectTypeTemplatesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/templates")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListProfileObjectTypeTemplatesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListProfileObjectTypeTemplatesInput(v *ListProfileObjectTypeTemplatesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListWorkflows struct {
}

func (*awsRestjson1_serializeOpListWorkflows) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListWorkflows) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListWorkflowsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains/{DomainName}/workflows")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListWorkflowsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListWorkflowsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListWorkflowsInput(v *ListWorkflowsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListWorkflowsInput(v *ListWorkflowsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.QueryEndDate != nil {
		ok := object.Key("QueryEndDate")
		ok.Double(smithytime.FormatEpochSeconds(*v.QueryEndDate))
	}

	if v.QueryStartDate != nil {
		ok := object.Key("QueryStartDate")
		ok.Double(smithytime.FormatEpochSeconds(*v.QueryStartDate))
	}

	if len(v.Status) > 0 {
		ok := object.Key("Status")
		ok.String(string(v.Status))
	}

	if len(v.WorkflowType) > 0 {
		ok := object.Key("WorkflowType")
		ok.String(string(v.WorkflowType))
	}

	return nil
}

type awsRestjson1_serializeOpMergeProfiles struct {
}

func (*awsRestjson1_serializeOpMergeProfiles) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpMergeProfiles) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*MergeProfilesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains/{DomainName}/profiles/objects/merge")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsMergeProfilesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentMergeProfilesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsMergeProfilesInput(v *MergeProfilesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentMergeProfilesInput(v *MergeProfilesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FieldSourceProfileIds != nil {
		ok := object.Key("FieldSourceProfileIds")
		if err := awsRestjson1_serializeDocumentFieldSourceProfileIds(v.FieldSourceProfileIds, ok); err != nil {
			return err
		}
	}

	if v.MainProfileId != nil {
		ok := object.Key("MainProfileId")
		ok.String(*v.MainProfileId)
	}

	if v.ProfileIdsToBeMerged != nil {
		ok := object.Key("ProfileIdsToBeMerged")
		if err := awsRestjson1_serializeDocumentProfileIdToBeMergedList(v.ProfileIdsToBeMerged, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpPutIntegration struct {
}

func (*awsRestjson1_serializeOpPutIntegration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutIntegration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutIntegrationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains/{DomainName}/integrations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutIntegrationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutIntegrationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutIntegrationInput(v *PutIntegrationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutIntegrationInput(v *PutIntegrationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FlowDefinition != nil {
		ok := object.Key("FlowDefinition")
		if err := awsRestjson1_serializeDocumentFlowDefinition(v.FlowDefinition, ok); err != nil {
			return err
		}
	}

	if v.ObjectTypeName != nil {
		ok := object.Key("ObjectTypeName")
		ok.String(*v.ObjectTypeName)
	}

	if v.ObjectTypeNames != nil {
		ok := object.Key("ObjectTypeNames")
		if err := awsRestjson1_serializeDocumentObjectTypeNames(v.ObjectTypeNames, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Uri != nil {
		ok := object.Key("Uri")
		ok.String(*v.Uri)
	}

	return nil
}

type awsRestjson1_serializeOpPutProfileObject struct {
}

func (*awsRestjson1_serializeOpPutProfileObject) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutProfileObject) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutProfileObjectInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains/{DomainName}/profiles/objects")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutProfileObjectInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutProfileObjectInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutProfileObjectInput(v *PutProfileObjectInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutProfileObjectInput(v *PutProfileObjectInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Object != nil {
		ok := object.Key("Object")
		ok.String(*v.Object)
	}

	if v.ObjectTypeName != nil {
		ok := object.Key("ObjectTypeName")
		ok.String(*v.ObjectTypeName)
	}

	return nil
}

type awsRestjson1_serializeOpPutProfileObjectType struct {
}

func (*awsRestjson1_serializeOpPutProfileObjectType) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpPutProfileObjectType) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutProfileObjectTypeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains/{DomainName}/object-types/{ObjectTypeName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsPutProfileObjectTypeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentPutProfileObjectTypeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsPutProfileObjectTypeInput(v *PutProfileObjectTypeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	if v.ObjectTypeName == nil || len(*v.ObjectTypeName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ObjectTypeName must not be empty")}
	}
	if v.ObjectTypeName != nil {
		if err := encoder.SetURI("ObjectTypeName").String(*v.ObjectTypeName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentPutProfileObjectTypeInput(v *PutProfileObjectTypeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowProfileCreation {
		ok := object.Key("AllowProfileCreation")
		ok.Boolean(v.AllowProfileCreation)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.EncryptionKey != nil {
		ok := object.Key("EncryptionKey")
		ok.String(*v.EncryptionKey)
	}

	if v.ExpirationDays != nil {
		ok := object.Key("ExpirationDays")
		ok.Integer(*v.ExpirationDays)
	}

	if v.Fields != nil {
		ok := object.Key("Fields")
		if err := awsRestjson1_serializeDocumentFieldMap(v.Fields, ok); err != nil {
			return err
		}
	}

	if v.Keys != nil {
		ok := object.Key("Keys")
		if err := awsRestjson1_serializeDocumentKeyMap(v.Keys, ok); err != nil {
			return err
		}
	}

	if v.SourceLastUpdatedTimestampFormat != nil {
		ok := object.Key("SourceLastUpdatedTimestampFormat")
		ok.String(*v.SourceLastUpdatedTimestampFormat)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TemplateId != nil {
		ok := object.Key("TemplateId")
		ok.String(*v.TemplateId)
	}

	return nil
}

type awsRestjson1_serializeOpSearchProfiles struct {
}

func (*awsRestjson1_serializeOpSearchProfiles) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpSearchProfiles) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*SearchProfilesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains/{DomainName}/profiles/search")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsSearchProfilesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentSearchProfilesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsSearchProfilesInput(v *SearchProfilesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		encoder.SetQuery("max-results").Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("next-token").String(*v.NextToken)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentSearchProfilesInput(v *SearchProfilesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AdditionalSearchKeys != nil {
		ok := object.Key("AdditionalSearchKeys")
		if err := awsRestjson1_serializeDocumentAdditionalSearchKeysList(v.AdditionalSearchKeys, ok); err != nil {
			return err
		}
	}

	if v.KeyName != nil {
		ok := object.Key("KeyName")
		ok.String(*v.KeyName)
	}

	if len(v.LogicalOperator) > 0 {
		ok := object.Key("LogicalOperator")
		ok.String(string(v.LogicalOperator))
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsRestjson1_serializeDocumentRequestValueList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags/{resourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member resourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("resourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateDomain struct {
}

func (*awsRestjson1_serializeOpUpdateDomain) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateDomain) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateDomainInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains/{DomainName}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateDomainInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateDomainInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateDomainInput(v *UpdateDomainInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateDomainInput(v *UpdateDomainInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeadLetterQueueUrl != nil {
		ok := object.Key("DeadLetterQueueUrl")
		ok.String(*v.DeadLetterQueueUrl)
	}

	if v.DefaultEncryptionKey != nil {
		ok := object.Key("DefaultEncryptionKey")
		ok.String(*v.DefaultEncryptionKey)
	}

	if v.DefaultExpirationDays != nil {
		ok := object.Key("DefaultExpirationDays")
		ok.Integer(*v.DefaultExpirationDays)
	}

	if v.Matching != nil {
		ok := object.Key("Matching")
		if err := awsRestjson1_serializeDocumentMatchingRequest(v.Matching, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateProfile struct {
}

func (*awsRestjson1_serializeOpUpdateProfile) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateProfile) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateProfileInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/domains/{DomainName}/profiles")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateProfileInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateProfileInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateProfileInput(v *UpdateProfileInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.DomainName == nil || len(*v.DomainName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member DomainName must not be empty")}
	}
	if v.DomainName != nil {
		if err := encoder.SetURI("DomainName").String(*v.DomainName); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateProfileInput(v *UpdateProfileInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountNumber != nil {
		ok := object.Key("AccountNumber")
		ok.String(*v.AccountNumber)
	}

	if v.AdditionalInformation != nil {
		ok := object.Key("AdditionalInformation")
		ok.String(*v.AdditionalInformation)
	}

	if v.Address != nil {
		ok := object.Key("Address")
		if err := awsRestjson1_serializeDocumentUpdateAddress(v.Address, ok); err != nil {
			return err
		}
	}

	if v.Attributes != nil {
		ok := object.Key("Attributes")
		if err := awsRestjson1_serializeDocumentUpdateAttributes(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.BillingAddress != nil {
		ok := object.Key("BillingAddress")
		if err := awsRestjson1_serializeDocumentUpdateAddress(v.BillingAddress, ok); err != nil {
			return err
		}
	}

	if v.BirthDate != nil {
		ok := object.Key("BirthDate")
		ok.String(*v.BirthDate)
	}

	if v.BusinessEmailAddress != nil {
		ok := object.Key("BusinessEmailAddress")
		ok.String(*v.BusinessEmailAddress)
	}

	if v.BusinessName != nil {
		ok := object.Key("BusinessName")
		ok.String(*v.BusinessName)
	}

	if v.BusinessPhoneNumber != nil {
		ok := object.Key("BusinessPhoneNumber")
		ok.String(*v.BusinessPhoneNumber)
	}

	if v.EmailAddress != nil {
		ok := object.Key("EmailAddress")
		ok.String(*v.EmailAddress)
	}

	if v.FirstName != nil {
		ok := object.Key("FirstName")
		ok.String(*v.FirstName)
	}

	if len(v.Gender) > 0 {
		ok := object.Key("Gender")
		ok.String(string(v.Gender))
	}

	if v.GenderString != nil {
		ok := object.Key("GenderString")
		ok.String(*v.GenderString)
	}

	if v.HomePhoneNumber != nil {
		ok := object.Key("HomePhoneNumber")
		ok.String(*v.HomePhoneNumber)
	}

	if v.LastName != nil {
		ok := object.Key("LastName")
		ok.String(*v.LastName)
	}

	if v.MailingAddress != nil {
		ok := object.Key("MailingAddress")
		if err := awsRestjson1_serializeDocumentUpdateAddress(v.MailingAddress, ok); err != nil {
			return err
		}
	}

	if v.MiddleName != nil {
		ok := object.Key("MiddleName")
		ok.String(*v.MiddleName)
	}

	if v.MobilePhoneNumber != nil {
		ok := object.Key("MobilePhoneNumber")
		ok.String(*v.MobilePhoneNumber)
	}

	if len(v.PartyType) > 0 {
		ok := object.Key("PartyType")
		ok.String(string(v.PartyType))
	}

	if v.PartyTypeString != nil {
		ok := object.Key("PartyTypeString")
		ok.String(*v.PartyTypeString)
	}

	if v.PersonalEmailAddress != nil {
		ok := object.Key("PersonalEmailAddress")
		ok.String(*v.PersonalEmailAddress)
	}

	if v.PhoneNumber != nil {
		ok := object.Key("PhoneNumber")
		ok.String(*v.PhoneNumber)
	}

	if v.ProfileId != nil {
		ok := object.Key("ProfileId")
		ok.String(*v.ProfileId)
	}

	if v.ShippingAddress != nil {
		ok := object.Key("ShippingAddress")
		if err := awsRestjson1_serializeDocumentUpdateAddress(v.ShippingAddress, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAdditionalSearchKey(v *types.AdditionalSearchKey, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KeyName != nil {
		ok := object.Key("KeyName")
		ok.String(*v.KeyName)
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsRestjson1_serializeDocumentRequestValueList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAdditionalSearchKeysList(v []types.AdditionalSearchKey, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentAdditionalSearchKey(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentAddress(v *types.Address, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Address1 != nil {
		ok := object.Key("Address1")
		ok.String(*v.Address1)
	}

	if v.Address2 != nil {
		ok := object.Key("Address2")
		ok.String(*v.Address2)
	}

	if v.Address3 != nil {
		ok := object.Key("Address3")
		ok.String(*v.Address3)
	}

	if v.Address4 != nil {
		ok := object.Key("Address4")
		ok.String(*v.Address4)
	}

	if v.City != nil {
		ok := object.Key("City")
		ok.String(*v.City)
	}

	if v.Country != nil {
		ok := object.Key("Country")
		ok.String(*v.Country)
	}

	if v.County != nil {
		ok := object.Key("County")
		ok.String(*v.County)
	}

	if v.PostalCode != nil {
		ok := object.Key("PostalCode")
		ok.String(*v.PostalCode)
	}

	if v.Province != nil {
		ok := object.Key("Province")
		ok.String(*v.Province)
	}

	if v.State != nil {
		ok := object.Key("State")
		ok.String(*v.State)
	}

	return nil
}

func awsRestjson1_serializeDocumentAppflowIntegration(v *types.AppflowIntegration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Batches != nil {
		ok := object.Key("Batches")
		if err := awsRestjson1_serializeDocumentBatches(v.Batches, ok); err != nil {
			return err
		}
	}

	if v.FlowDefinition != nil {
		ok := object.Key("FlowDefinition")
		if err := awsRestjson1_serializeDocumentFlowDefinition(v.FlowDefinition, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentAttributes(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentAttributeSourceIdMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentAutoMerging(v *types.AutoMerging, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConflictResolution != nil {
		ok := object.Key("ConflictResolution")
		if err := awsRestjson1_serializeDocumentConflictResolution(v.ConflictResolution, ok); err != nil {
			return err
		}
	}

	if v.Consolidation != nil {
		ok := object.Key("Consolidation")
		if err := awsRestjson1_serializeDocumentConsolidation(v.Consolidation, ok); err != nil {
			return err
		}
	}

	if v.Enabled != nil {
		ok := object.Key("Enabled")
		ok.Boolean(*v.Enabled)
	}

	if v.MinAllowedConfidenceScoreForMerging != nil {
		ok := object.Key("MinAllowedConfidenceScoreForMerging")
		switch {
		case math.IsNaN(*v.MinAllowedConfidenceScoreForMerging):
			ok.String("NaN")

		case math.IsInf(*v.MinAllowedConfidenceScoreForMerging, 1):
			ok.String("Infinity")

		case math.IsInf(*v.MinAllowedConfidenceScoreForMerging, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.MinAllowedConfidenceScoreForMerging)

		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBatch(v *types.Batch, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EndTime != nil {
		ok := object.Key("EndTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.EndTime))
	}

	if v.StartTime != nil {
		ok := object.Key("StartTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartTime))
	}

	return nil
}

func awsRestjson1_serializeDocumentBatches(v []types.Batch, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentBatch(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentConflictResolution(v *types.ConflictResolution, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ConflictResolvingModel) > 0 {
		ok := object.Key("ConflictResolvingModel")
		ok.String(string(v.ConflictResolvingModel))
	}

	if v.SourceName != nil {
		ok := object.Key("SourceName")
		ok.String(*v.SourceName)
	}

	return nil
}

func awsRestjson1_serializeDocumentConnectorOperator(v *types.ConnectorOperator, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Marketo) > 0 {
		ok := object.Key("Marketo")
		ok.String(string(v.Marketo))
	}

	if len(v.S3) > 0 {
		ok := object.Key("S3")
		ok.String(string(v.S3))
	}

	if len(v.Salesforce) > 0 {
		ok := object.Key("Salesforce")
		ok.String(string(v.Salesforce))
	}

	if len(v.ServiceNow) > 0 {
		ok := object.Key("ServiceNow")
		ok.String(string(v.ServiceNow))
	}

	if len(v.Zendesk) > 0 {
		ok := object.Key("Zendesk")
		ok.String(string(v.Zendesk))
	}

	return nil
}

func awsRestjson1_serializeDocumentConsolidation(v *types.Consolidation, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MatchingAttributesList != nil {
		ok := object.Key("MatchingAttributesList")
		if err := awsRestjson1_serializeDocumentMatchingAttributesList(v.MatchingAttributesList, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentExportingConfig(v *types.ExportingConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3Exporting != nil {
		ok := object.Key("S3Exporting")
		if err := awsRestjson1_serializeDocumentS3ExportingConfig(v.S3Exporting, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentFieldMap(v map[string]types.ObjectTypeField, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentObjectTypeField(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentFieldNameList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentFieldSourceProfileIds(v *types.FieldSourceProfileIds, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AccountNumber != nil {
		ok := object.Key("AccountNumber")
		ok.String(*v.AccountNumber)
	}

	if v.AdditionalInformation != nil {
		ok := object.Key("AdditionalInformation")
		ok.String(*v.AdditionalInformation)
	}

	if v.Address != nil {
		ok := object.Key("Address")
		ok.String(*v.Address)
	}

	if v.Attributes != nil {
		ok := object.Key("Attributes")
		if err := awsRestjson1_serializeDocumentAttributeSourceIdMap(v.Attributes, ok); err != nil {
			return err
		}
	}

	if v.BillingAddress != nil {
		ok := object.Key("BillingAddress")
		ok.String(*v.BillingAddress)
	}

	if v.BirthDate != nil {
		ok := object.Key("BirthDate")
		ok.String(*v.BirthDate)
	}

	if v.BusinessEmailAddress != nil {
		ok := object.Key("BusinessEmailAddress")
		ok.String(*v.BusinessEmailAddress)
	}

	if v.BusinessName != nil {
		ok := object.Key("BusinessName")
		ok.String(*v.BusinessName)
	}

	if v.BusinessPhoneNumber != nil {
		ok := object.Key("BusinessPhoneNumber")
		ok.String(*v.BusinessPhoneNumber)
	}

	if v.EmailAddress != nil {
		ok := object.Key("EmailAddress")
		ok.String(*v.EmailAddress)
	}

	if v.FirstName != nil {
		ok := object.Key("FirstName")
		ok.String(*v.FirstName)
	}

	if v.Gender != nil {
		ok := object.Key("Gender")
		ok.String(*v.Gender)
	}

	if v.HomePhoneNumber != nil {
		ok := object.Key("HomePhoneNumber")
		ok.String(*v.HomePhoneNumber)
	}

	if v.LastName != nil {
		ok := object.Key("LastName")
		ok.String(*v.LastName)
	}

	if v.MailingAddress != nil {
		ok := object.Key("MailingAddress")
		ok.String(*v.MailingAddress)
	}

	if v.MiddleName != nil {
		ok := object.Key("MiddleName")
		ok.String(*v.MiddleName)
	}

	if v.MobilePhoneNumber != nil {
		ok := object.Key("MobilePhoneNumber")
		ok.String(*v.MobilePhoneNumber)
	}

	if v.PartyType != nil {
		ok := object.Key("PartyType")
		ok.String(*v.PartyType)
	}

	if v.PersonalEmailAddress != nil {
		ok := object.Key("PersonalEmailAddress")
		ok.String(*v.PersonalEmailAddress)
	}

	if v.PhoneNumber != nil {
		ok := object.Key("PhoneNumber")
		ok.String(*v.PhoneNumber)
	}

	if v.ShippingAddress != nil {
		ok := object.Key("ShippingAddress")
		ok.String(*v.ShippingAddress)
	}

	return nil
}

func awsRestjson1_serializeDocumentFlowDefinition(v *types.FlowDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.FlowName != nil {
		ok := object.Key("FlowName")
		ok.String(*v.FlowName)
	}

	if v.KmsArn != nil {
		ok := object.Key("KmsArn")
		ok.String(*v.KmsArn)
	}

	if v.SourceFlowConfig != nil {
		ok := object.Key("SourceFlowConfig")
		if err := awsRestjson1_serializeDocumentSourceFlowConfig(v.SourceFlowConfig, ok); err != nil {
			return err
		}
	}

	if v.Tasks != nil {
		ok := object.Key("Tasks")
		if err := awsRestjson1_serializeDocumentTasks(v.Tasks, ok); err != nil {
			return err
		}
	}

	if v.TriggerConfig != nil {
		ok := object.Key("TriggerConfig")
		if err := awsRestjson1_serializeDocumentTriggerConfig(v.TriggerConfig, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentIncrementalPullConfig(v *types.IncrementalPullConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DatetimeTypeFieldName != nil {
		ok := object.Key("DatetimeTypeFieldName")
		ok.String(*v.DatetimeTypeFieldName)
	}

	return nil
}

func awsRestjson1_serializeDocumentIntegrationConfig(v *types.IntegrationConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AppflowIntegration != nil {
		ok := object.Key("AppflowIntegration")
		if err := awsRestjson1_serializeDocumentAppflowIntegration(v.AppflowIntegration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentJobSchedule(v *types.JobSchedule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DayOfTheWeek) > 0 {
		ok := object.Key("DayOfTheWeek")
		ok.String(string(v.DayOfTheWeek))
	}

	if v.Time != nil {
		ok := object.Key("Time")
		ok.String(*v.Time)
	}

	return nil
}

func awsRestjson1_serializeDocumentKeyMap(v map[string][]types.ObjectTypeKey, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		if vv := v[key]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentObjectTypeKeyList(v[key], om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMarketoSourceProperties(v *types.MarketoSourceProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Object != nil {
		ok := object.Key("Object")
		ok.String(*v.Object)
	}

	return nil
}

func awsRestjson1_serializeDocumentMatchingAttributes(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentMatchingAttributesList(v [][]string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentMatchingAttributes(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentMatchingRequest(v *types.MatchingRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AutoMerging != nil {
		ok := object.Key("AutoMerging")
		if err := awsRestjson1_serializeDocumentAutoMerging(v.AutoMerging, ok); err != nil {
			return err
		}
	}

	if v.Enabled != nil {
		ok := object.Key("Enabled")
		ok.Boolean(*v.Enabled)
	}

	if v.ExportingConfig != nil {
		ok := object.Key("ExportingConfig")
		if err := awsRestjson1_serializeDocumentExportingConfig(v.ExportingConfig, ok); err != nil {
			return err
		}
	}

	if v.JobSchedule != nil {
		ok := object.Key("JobSchedule")
		if err := awsRestjson1_serializeDocumentJobSchedule(v.JobSchedule, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentObjectFilter(v *types.ObjectFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KeyName != nil {
		ok := object.Key("KeyName")
		ok.String(*v.KeyName)
	}

	if v.Values != nil {
		ok := object.Key("Values")
		if err := awsRestjson1_serializeDocumentRequestValueList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentObjectTypeField(v *types.ObjectTypeField, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ContentType) > 0 {
		ok := object.Key("ContentType")
		ok.String(string(v.ContentType))
	}

	if v.Source != nil {
		ok := object.Key("Source")
		ok.String(*v.Source)
	}

	if v.Target != nil {
		ok := object.Key("Target")
		ok.String(*v.Target)
	}

	return nil
}

func awsRestjson1_serializeDocumentObjectTypeKey(v *types.ObjectTypeKey, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FieldNames != nil {
		ok := object.Key("FieldNames")
		if err := awsRestjson1_serializeDocumentFieldNameList(v.FieldNames, ok); err != nil {
			return err
		}
	}

	if v.StandardIdentifiers != nil {
		ok := object.Key("StandardIdentifiers")
		if err := awsRestjson1_serializeDocumentStandardIdentifierList(v.StandardIdentifiers, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentObjectTypeKeyList(v []types.ObjectTypeKey, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentObjectTypeKey(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentObjectTypeNames(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentProfileIdToBeMergedList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentRequestValueList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentS3ExportingConfig(v *types.S3ExportingConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.S3BucketName != nil {
		ok := object.Key("S3BucketName")
		ok.String(*v.S3BucketName)
	}

	if v.S3KeyName != nil {
		ok := object.Key("S3KeyName")
		ok.String(*v.S3KeyName)
	}

	return nil
}

func awsRestjson1_serializeDocumentS3SourceProperties(v *types.S3SourceProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BucketName != nil {
		ok := object.Key("BucketName")
		ok.String(*v.BucketName)
	}

	if v.BucketPrefix != nil {
		ok := object.Key("BucketPrefix")
		ok.String(*v.BucketPrefix)
	}

	return nil
}

func awsRestjson1_serializeDocumentSalesforceSourceProperties(v *types.SalesforceSourceProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EnableDynamicFieldUpdate {
		ok := object.Key("EnableDynamicFieldUpdate")
		ok.Boolean(v.EnableDynamicFieldUpdate)
	}

	if v.IncludeDeletedRecords {
		ok := object.Key("IncludeDeletedRecords")
		ok.Boolean(v.IncludeDeletedRecords)
	}

	if v.Object != nil {
		ok := object.Key("Object")
		ok.String(*v.Object)
	}

	return nil
}

func awsRestjson1_serializeDocumentScheduledTriggerProperties(v *types.ScheduledTriggerProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.DataPullMode) > 0 {
		ok := object.Key("DataPullMode")
		ok.String(string(v.DataPullMode))
	}

	if v.FirstExecutionFrom != nil {
		ok := object.Key("FirstExecutionFrom")
		ok.Double(smithytime.FormatEpochSeconds(*v.FirstExecutionFrom))
	}

	if v.ScheduleEndTime != nil {
		ok := object.Key("ScheduleEndTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.ScheduleEndTime))
	}

	if v.ScheduleExpression != nil {
		ok := object.Key("ScheduleExpression")
		ok.String(*v.ScheduleExpression)
	}

	if v.ScheduleOffset != nil {
		ok := object.Key("ScheduleOffset")
		ok.Long(*v.ScheduleOffset)
	}

	if v.ScheduleStartTime != nil {
		ok := object.Key("ScheduleStartTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.ScheduleStartTime))
	}

	if v.Timezone != nil {
		ok := object.Key("Timezone")
		ok.String(*v.Timezone)
	}

	return nil
}

func awsRestjson1_serializeDocumentServiceNowSourceProperties(v *types.ServiceNowSourceProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Object != nil {
		ok := object.Key("Object")
		ok.String(*v.Object)
	}

	return nil
}

func awsRestjson1_serializeDocumentSourceConnectorProperties(v *types.SourceConnectorProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Marketo != nil {
		ok := object.Key("Marketo")
		if err := awsRestjson1_serializeDocumentMarketoSourceProperties(v.Marketo, ok); err != nil {
			return err
		}
	}

	if v.S3 != nil {
		ok := object.Key("S3")
		if err := awsRestjson1_serializeDocumentS3SourceProperties(v.S3, ok); err != nil {
			return err
		}
	}

	if v.Salesforce != nil {
		ok := object.Key("Salesforce")
		if err := awsRestjson1_serializeDocumentSalesforceSourceProperties(v.Salesforce, ok); err != nil {
			return err
		}
	}

	if v.ServiceNow != nil {
		ok := object.Key("ServiceNow")
		if err := awsRestjson1_serializeDocumentServiceNowSourceProperties(v.ServiceNow, ok); err != nil {
			return err
		}
	}

	if v.Zendesk != nil {
		ok := object.Key("Zendesk")
		if err := awsRestjson1_serializeDocumentZendeskSourceProperties(v.Zendesk, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentSourceFields(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSourceFlowConfig(v *types.SourceFlowConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectorProfileName != nil {
		ok := object.Key("ConnectorProfileName")
		ok.String(*v.ConnectorProfileName)
	}

	if len(v.ConnectorType) > 0 {
		ok := object.Key("ConnectorType")
		ok.String(string(v.ConnectorType))
	}

	if v.IncrementalPullConfig != nil {
		ok := object.Key("IncrementalPullConfig")
		if err := awsRestjson1_serializeDocumentIncrementalPullConfig(v.IncrementalPullConfig, ok); err != nil {
			return err
		}
	}

	if v.SourceConnectorProperties != nil {
		ok := object.Key("SourceConnectorProperties")
		if err := awsRestjson1_serializeDocumentSourceConnectorProperties(v.SourceConnectorProperties, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentStandardIdentifierList(v []types.StandardIdentifier, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsRestjson1_serializeDocumentTagMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentTask(v *types.Task, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectorOperator != nil {
		ok := object.Key("ConnectorOperator")
		if err := awsRestjson1_serializeDocumentConnectorOperator(v.ConnectorOperator, ok); err != nil {
			return err
		}
	}

	if v.DestinationField != nil {
		ok := object.Key("DestinationField")
		ok.String(*v.DestinationField)
	}

	if v.SourceFields != nil {
		ok := object.Key("SourceFields")
		if err := awsRestjson1_serializeDocumentSourceFields(v.SourceFields, ok); err != nil {
			return err
		}
	}

	if v.TaskProperties != nil {
		ok := object.Key("TaskProperties")
		if err := awsRestjson1_serializeDocumentTaskPropertiesMap(v.TaskProperties, ok); err != nil {
			return err
		}
	}

	if len(v.TaskType) > 0 {
		ok := object.Key("TaskType")
		ok.String(string(v.TaskType))
	}

	return nil
}

func awsRestjson1_serializeDocumentTaskPropertiesMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentTasks(v []types.Task, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentTask(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTriggerConfig(v *types.TriggerConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TriggerProperties != nil {
		ok := object.Key("TriggerProperties")
		if err := awsRestjson1_serializeDocumentTriggerProperties(v.TriggerProperties, ok); err != nil {
			return err
		}
	}

	if len(v.TriggerType) > 0 {
		ok := object.Key("TriggerType")
		ok.String(string(v.TriggerType))
	}

	return nil
}

func awsRestjson1_serializeDocumentTriggerProperties(v *types.TriggerProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Scheduled != nil {
		ok := object.Key("Scheduled")
		if err := awsRestjson1_serializeDocumentScheduledTriggerProperties(v.Scheduled, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateAddress(v *types.UpdateAddress, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Address1 != nil {
		ok := object.Key("Address1")
		ok.String(*v.Address1)
	}

	if v.Address2 != nil {
		ok := object.Key("Address2")
		ok.String(*v.Address2)
	}

	if v.Address3 != nil {
		ok := object.Key("Address3")
		ok.String(*v.Address3)
	}

	if v.Address4 != nil {
		ok := object.Key("Address4")
		ok.String(*v.Address4)
	}

	if v.City != nil {
		ok := object.Key("City")
		ok.String(*v.City)
	}

	if v.Country != nil {
		ok := object.Key("Country")
		ok.String(*v.Country)
	}

	if v.County != nil {
		ok := object.Key("County")
		ok.String(*v.County)
	}

	if v.PostalCode != nil {
		ok := object.Key("PostalCode")
		ok.String(*v.PostalCode)
	}

	if v.Province != nil {
		ok := object.Key("Province")
		ok.String(*v.Province)
	}

	if v.State != nil {
		ok := object.Key("State")
		ok.String(*v.State)
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateAttributes(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentZendeskSourceProperties(v *types.ZendeskSourceProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Object != nil {
		ok := object.Key("Object")
		ok.String(*v.Object)
	}

	return nil
}
