// Code generated by smithy-go-codegen DO NOT EDIT.

package connect

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/connect/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets the real-time active user data from the specified Amazon Connect instance.
func (c *Client) GetCurrentUserData(ctx context.Context, params *GetCurrentUserDataInput, optFns ...func(*Options)) (*GetCurrentUserDataOutput, error) {
	if params == nil {
		params = &GetCurrentUserDataInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetCurrentUserData", params, optFns, c.addOperationGetCurrentUserDataMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetCurrentUserDataOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetCurrentUserDataInput struct {

	// The filters to apply to returned user data. You can filter up to the following
	// limits:
	//
	// * Queues: 100
	//
	// * Routing profiles: 100
	//
	// * Agents: 100
	//
	// * Contact
	// states: 9
	//
	// * User hierarchy groups: 1
	//
	// The user data is retrieved for only the
	// specified values/resources in the filter. A maximum of one filter can be passed
	// from queues, routing profiles, agents, and user hierarchy groups. Currently
	// tagging is only supported on the resources that are passed in the filter.
	//
	// This member is required.
	Filters *types.UserDataFilters

	// The identifier of the Amazon Connect instance. You can find the instance ID
	// (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// This member is required.
	InstanceId *string

	// The maximum number of results to return per page.
	MaxResults *int32

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string

	noSmithyDocumentSerde
}

type GetCurrentUserDataOutput struct {

	// The total count of the result, regardless of the current page size.
	ApproximateTotalCount *int64

	// If there are additional results, this is the token for the next set of results.
	NextToken *string

	// A list of the user data that is returned.
	UserDataList []types.UserData

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetCurrentUserDataMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetCurrentUserData{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetCurrentUserData{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpGetCurrentUserDataValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetCurrentUserData(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// GetCurrentUserDataAPIClient is a client that implements the GetCurrentUserData
// operation.
type GetCurrentUserDataAPIClient interface {
	GetCurrentUserData(context.Context, *GetCurrentUserDataInput, ...func(*Options)) (*GetCurrentUserDataOutput, error)
}

var _ GetCurrentUserDataAPIClient = (*Client)(nil)

// GetCurrentUserDataPaginatorOptions is the paginator options for
// GetCurrentUserData
type GetCurrentUserDataPaginatorOptions struct {
	// The maximum number of results to return per page.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetCurrentUserDataPaginator is a paginator for GetCurrentUserData
type GetCurrentUserDataPaginator struct {
	options   GetCurrentUserDataPaginatorOptions
	client    GetCurrentUserDataAPIClient
	params    *GetCurrentUserDataInput
	nextToken *string
	firstPage bool
}

// NewGetCurrentUserDataPaginator returns a new GetCurrentUserDataPaginator
func NewGetCurrentUserDataPaginator(client GetCurrentUserDataAPIClient, params *GetCurrentUserDataInput, optFns ...func(*GetCurrentUserDataPaginatorOptions)) *GetCurrentUserDataPaginator {
	if params == nil {
		params = &GetCurrentUserDataInput{}
	}

	options := GetCurrentUserDataPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetCurrentUserDataPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetCurrentUserDataPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetCurrentUserData page.
func (p *GetCurrentUserDataPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetCurrentUserDataOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.GetCurrentUserData(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opGetCurrentUserData(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "connect",
		OperationName: "GetCurrentUserData",
	}
}
