// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// The caller's account ID must be the same as the channel owner's account ID.
type ChannelInsufficientPermission struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ChannelInsufficientPermission) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ChannelInsufficientPermission) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ChannelInsufficientPermission) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ChannelInsufficientPermission"
	}
	return *e.ErrorCodeOverride
}
func (e *ChannelInsufficientPermission) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The channel could not be found.
type ChannelNotFound struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ChannelNotFound) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ChannelNotFound) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ChannelNotFound) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ChannelNotFound"
	}
	return *e.ErrorCodeOverride
}
func (e *ChannelNotFound) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The schema type of the event is not supported.
type ChannelUnsupportedSchema struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *ChannelUnsupportedSchema) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ChannelUnsupportedSchema) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ChannelUnsupportedSchema) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "ChannelUnsupportedSchema"
	}
	return *e.ErrorCodeOverride
}
func (e *ChannelUnsupportedSchema) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Two or more entries in the request have the same event ID.
type DuplicatedAuditEventId struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *DuplicatedAuditEventId) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *DuplicatedAuditEventId) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *DuplicatedAuditEventId) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "DuplicatedAuditEventId"
	}
	return *e.ErrorCodeOverride
}
func (e *DuplicatedAuditEventId) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The specified channel ARN is not a valid channel ARN.
type InvalidChannelARN struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *InvalidChannelARN) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InvalidChannelARN) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InvalidChannelARN) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "InvalidChannelARN"
	}
	return *e.ErrorCodeOverride
}
func (e *InvalidChannelARN) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// The operation requested is not supported in this region or account.
type UnsupportedOperationException struct {
	Message *string

	ErrorCodeOverride *string

	noSmithyDocumentSerde
}

func (e *UnsupportedOperationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *UnsupportedOperationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *UnsupportedOperationException) ErrorCode() string {
	if e.ErrorCodeOverride == nil {
		return "UnsupportedOperationException"
	}
	return *e.ErrorCodeOverride
}
func (e *UnsupportedOperationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
