// Code generated by smithy-go-codegen DO NOT EDIT.

package securitylake

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/securitylake/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Removes a natively-supported Amazon Web Services service as a Amazon Security
// Lake source. When you remove the source, Security Lake stops collecting data
// from that source, and subscribers can no longer consume new data from the
// source. Subscribers can still consume data that Amazon Security Lake collected
// from the source before disablement. You can choose any source type in any Region
// for accounts that are either part of a trusted organization or standalone
// accounts. At least one of the three dimensions is a mandatory input to this API.
// However, any combination of the three dimensions can be supplied to this API. By
// default, dimension refers to the entire set. This is overridden when you supply
// any one of the inputs. For instance, when members is not specified, the API
// disables all Security Lake member accounts for sources. Similarly, when Regions
// are not specified, Security Lake is disabled for all the Regions where Security
// Lake is available as a service. You can use this API to remove a
// natively-supported Amazon Web Services service as a source. Use
// DeregisterCustomData to remove a custom source. When you don't provide a
// dimension, Security Lake assumes that the missing dimension refers to the entire
// set. For example, if you don't provide specific accounts, the API applies to the
// entire set of accounts in your organization.
func (c *Client) DeleteAwsLogSource(ctx context.Context, params *DeleteAwsLogSourceInput, optFns ...func(*Options)) (*DeleteAwsLogSourceOutput, error) {
	if params == nil {
		params = &DeleteAwsLogSourceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DeleteAwsLogSource", params, optFns, c.addOperationDeleteAwsLogSourceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DeleteAwsLogSourceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DeleteAwsLogSourceInput struct {

	// This is a mandatory input. Specifies the input order to disable dimensions in
	// Security Lake, namely Region, source type, and member.
	//
	// This member is required.
	InputOrder []types.Dimension

	// Removes the specific Amazon Web Services sources from all Regions and source
	// types.
	DisableAllDimensions map[string]map[string][]string

	// Removes all Amazon Web Services sources from specific accounts or Regions.
	DisableSingleDimension []string

	// Remove a specific Amazon Web Services source from specific accounts or Regions.
	DisableTwoDimensions map[string][]string

	noSmithyDocumentSerde
}

type DeleteAwsLogSourceOutput struct {

	// Deletion of the Amazon Web Services sources failed as the account is not a part
	// of the organization.
	Failed []string

	// Deletion of the Amazon Web Services sources is in-progress.
	Processing []string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDeleteAwsLogSourceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpDeleteAwsLogSource{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpDeleteAwsLogSource{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpDeleteAwsLogSourceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDeleteAwsLogSource(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDeleteAwsLogSource(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "securitylake",
		OperationName: "DeleteAwsLogSource",
	}
}
