// Code generated by smithy-go-codegen DO NOT EDIT.

package securitylake

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/securitylake/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Initializes an Amazon Security Lake instance with the provided (or default)
// configuration. You can enable Security Lake in Regions with customized settings
// in advance before enabling log collection in Regions. You can either use the
// enableAll parameter to specify all Regions or you can specify the Regions you
// want to enable Security Lake using the Regions parameter and configure these
// Regions using the configurations parameter. When the CreateDataLake API is
// called multiple times, if that Region is already enabled, it will update the
// Region if configuration for that Region is provided. If that Region is a new
// Region, it will be set up with the customized configurations if it is specified.
// When you enable Security Lake, it starts ingesting security data after the
// CreateAwsLogSource call. This includes ingesting security data from sources,
// storing data, and making data accessible to subscribers. Security Lake also
// enables all the existing settings and resources that it stores or maintains for
// your account in the current Region, including security log and event data. For
// more information, see the Amazon Security Lake User Guide.
func (c *Client) CreateDatalake(ctx context.Context, params *CreateDatalakeInput, optFns ...func(*Options)) (*CreateDatalakeOutput, error) {
	if params == nil {
		params = &CreateDatalakeInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateDatalake", params, optFns, c.addOperationCreateDatalakeMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateDatalakeOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateDatalakeInput struct {

	// Enable Security Lake with the specified configurations settings to begin
	// ingesting security data.
	Configurations map[string]types.LakeConfigurationRequest

	// Enable Security Lake in all Regions to begin ingesting security data.
	EnableAll *bool

	// The Role ARN used to create and update the Glue table with partitions generated
	// by ingestion and normalization of Amazon Web Services log sources and custom
	// sources.
	MetaStoreManagerRoleArn *string

	// Enable Security Lake in the specified Regions to begin ingesting security data.
	// To enable Security Lake in specific Amazon Web Services Regions, such as
	// us-east-1 or ap-northeast-3, provide the Region codes. For a list of Region
	// codes, see Region codes
	// (https://docs.aws.amazon.com/general/latest/gr/rande.html#regional-endpoints) in
	// the Amazon Web Services General Reference.
	Regions []types.Region

	noSmithyDocumentSerde
}

type CreateDatalakeOutput struct {
	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateDatalakeMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateDatalake{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateDatalake{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateDatalake(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateDatalake(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "securitylake",
		OperationName: "CreateDatalake",
	}
}
