// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
)

// Aac Settings
type AacSettings struct {

	// Average bitrate in bits/second. Valid values depend on rate control mode and
	// profile.
	Bitrate float64

	// Mono, Stereo, or 5.1 channel layout. Valid values depend on rate control mode
	// and profile. The adReceiverMix setting receives a stereo description plus
	// control track and emits a mono AAC encode of the description track, with control
	// data emitted in the PES header as per ETSI TS 101 154 Annex E.
	CodingMode AacCodingMode

	// Set to "broadcasterMixedAd" when input contains pre-mixed main audio + AD
	// (narration) as a stereo pair. The Audio Type field (audioType) will be set to 3,
	// which signals to downstream systems that this stream contains "broadcaster mixed
	// AD". Note that the input received by the encoder must contain pre-mixed audio;
	// the encoder does not perform the mixing. The values in audioTypeControl and
	// audioType (in AudioDescription) are ignored when set to broadcasterMixedAd.
	// Leave set to "normal" when input does not contain pre-mixed audio + AD.
	InputType AacInputType

	// AAC Profile.
	Profile AacProfile

	// Rate Control Mode.
	RateControlMode AacRateControlMode

	// Sets LATM / LOAS AAC output for raw containers.
	RawFormat AacRawFormat

	// Sample rate in Hz. Valid values depend on rate control mode and profile.
	SampleRate float64

	// Use MPEG-2 AAC audio instead of MPEG-4 AAC audio for raw or MPEG-2 Transport
	// Stream containers.
	Spec AacSpec

	// VBR Quality Level - Only used if rateControlMode is VBR.
	VbrQuality AacVbrQuality

	noSmithyDocumentSerde
}

// Ac3 Settings
type Ac3Settings struct {

	// Average bitrate in bits/second. Valid bitrates depend on the coding mode.
	Bitrate float64

	// Specifies the bitstream mode (bsmod) for the emitted AC-3 stream. See ATSC
	// A/52-2012 for background on these values.
	BitstreamMode Ac3BitstreamMode

	// Dolby Digital coding mode. Determines number of channels.
	CodingMode Ac3CodingMode

	// Sets the dialnorm for the output. If excluded and input audio is Dolby Digital,
	// dialnorm will be passed through.
	Dialnorm int32

	// If set to filmStandard, adds dynamic range compression signaling to the output
	// bitstream as defined in the Dolby Digital specification.
	DrcProfile Ac3DrcProfile

	// When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to
	// encoding. Only valid in codingMode32Lfe mode.
	LfeFilter Ac3LfeFilter

	// When set to "followInput", encoder metadata will be sourced from the DD, DD+, or
	// DolbyE decoder that supplied this audio data. If audio was not supplied from one
	// of these streams, then the static metadata settings will be used.
	MetadataControl Ac3MetadataControl

	noSmithyDocumentSerde
}

// Ancillary Source Settings
type AncillarySourceSettings struct {

	// Specifies the number (1 to 4) of the captions channel you want to extract from
	// the ancillary captions. If you plan to convert the ancillary captions to another
	// format, complete this field. If you plan to choose Embedded as the captions
	// destination in the output (to pass through all the channels in the ancillary
	// captions), leave this field blank because MediaLive ignores the field.
	SourceAncillaryChannelNumber int32

	noSmithyDocumentSerde
}

// Archive Cdn Settings
type ArchiveCdnSettings struct {

	// Archive S3 Settings
	ArchiveS3Settings *ArchiveS3Settings

	noSmithyDocumentSerde
}

// Archive Container Settings
type ArchiveContainerSettings struct {

	// M2ts Settings
	M2tsSettings *M2tsSettings

	// Raw Settings
	RawSettings *RawSettings

	noSmithyDocumentSerde
}

// Archive Group Settings
type ArchiveGroupSettings struct {

	// A directory and base filename where archive files should be written.
	//
	// This member is required.
	Destination *OutputLocationRef

	// Parameters that control interactions with the CDN.
	ArchiveCdnSettings *ArchiveCdnSettings

	// Number of seconds to write to archive file before closing and starting a new
	// one.
	RolloverInterval int32

	noSmithyDocumentSerde
}

// Archive Output Settings
type ArchiveOutputSettings struct {

	// Settings specific to the container type of the file.
	//
	// This member is required.
	ContainerSettings *ArchiveContainerSettings

	// Output file extension. If excluded, this will be auto-selected from the
	// container type.
	Extension *string

	// String concatenated to the end of the destination filename. Required for
	// multiple outputs of the same type.
	NameModifier *string

	noSmithyDocumentSerde
}

// Archive S3 Settings
type ArchiveS3Settings struct {

	// Specify the canned ACL to apply to each S3 request. Defaults to none.
	CannedAcl S3CannedAcl

	noSmithyDocumentSerde
}

// Arib Destination Settings
type AribDestinationSettings struct {
	noSmithyDocumentSerde
}

// Arib Source Settings
type AribSourceSettings struct {
	noSmithyDocumentSerde
}

// Audio Channel Mapping
type AudioChannelMapping struct {

	// Indices and gain values for each input channel that should be remixed into this
	// output channel.
	//
	// This member is required.
	InputChannelLevels []InputChannelLevel

	// The index of the output channel being produced.
	//
	// This member is required.
	OutputChannel int32

	noSmithyDocumentSerde
}

// Audio Codec Settings
type AudioCodecSettings struct {

	// Aac Settings
	AacSettings *AacSettings

	// Ac3 Settings
	Ac3Settings *Ac3Settings

	// Eac3 Atmos Settings
	Eac3AtmosSettings *Eac3AtmosSettings

	// Eac3 Settings
	Eac3Settings *Eac3Settings

	// Mp2 Settings
	Mp2Settings *Mp2Settings

	// Pass Through Settings
	PassThroughSettings *PassThroughSettings

	// Wav Settings
	WavSettings *WavSettings

	noSmithyDocumentSerde
}

// Audio Description
type AudioDescription struct {

	// The name of the AudioSelector used as the source for this AudioDescription.
	//
	// This member is required.
	AudioSelectorName *string

	// The name of this AudioDescription. Outputs will use this name to uniquely
	// identify this AudioDescription. Description names should be unique within this
	// Live Event.
	//
	// This member is required.
	Name *string

	// Advanced audio normalization settings.
	AudioNormalizationSettings *AudioNormalizationSettings

	// Applies only if audioTypeControl is useConfigured. The values for audioType are
	// defined in ISO-IEC 13818-1.
	AudioType AudioType

	// Determines how audio type is determined. followInput: If the input contains an
	// ISO 639 audioType, then that value is passed through to the output. If the input
	// contains no ISO 639 audioType, the value in Audio Type is included in the
	// output. useConfigured: The value in Audio Type is included in the output. Note
	// that this field and audioType are both ignored if inputType is
	// broadcasterMixedAd.
	AudioTypeControl AudioDescriptionAudioTypeControl

	// Settings to configure one or more solutions that insert audio watermarks in the
	// audio encode
	AudioWatermarkingSettings *AudioWatermarkSettings

	// Audio codec settings.
	CodecSettings *AudioCodecSettings

	// RFC 5646 language code representing the language of the audio output track. Only
	// used if languageControlMode is useConfigured, or there is no ISO 639 language
	// code specified in the input.
	LanguageCode *string

	// Choosing followInput will cause the ISO 639 language code of the output to
	// follow the ISO 639 language code of the input. The languageCode will be used
	// when useConfigured is set, or when followInput is selected but there is no ISO
	// 639 language code specified by the input.
	LanguageCodeControl AudioDescriptionLanguageCodeControl

	// Settings that control how input audio channels are remixed into the output audio
	// channels.
	RemixSettings *RemixSettings

	// Used for MS Smooth and Apple HLS outputs. Indicates the name displayed by the
	// player (eg. English, or Director Commentary).
	StreamName *string

	noSmithyDocumentSerde
}

// Audio Hls Rendition Selection
type AudioHlsRenditionSelection struct {

	// Specifies the GROUP-ID in the #EXT-X-MEDIA tag of the target HLS audio
	// rendition.
	//
	// This member is required.
	GroupId *string

	// Specifies the NAME in the #EXT-X-MEDIA tag of the target HLS audio rendition.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Audio Language Selection
type AudioLanguageSelection struct {

	// Selects a specific three-letter language code from within an audio source.
	//
	// This member is required.
	LanguageCode *string

	// When set to "strict", the transport stream demux strictly identifies audio
	// streams by their language descriptor. If a PMT update occurs such that an audio
	// stream matching the initially selected language is no longer present then mute
	// will be encoded until the language returns. If "loose", then on a PMT update the
	// demux will choose another audio stream in the program with the same stream type
	// if it can't find one with the same language.
	LanguageSelectionPolicy AudioLanguageSelectionPolicy

	noSmithyDocumentSerde
}

// Audio Normalization Settings
type AudioNormalizationSettings struct {

	// Audio normalization algorithm to use. itu17701 conforms to the CALM Act
	// specification, itu17702 conforms to the EBU R-128 specification.
	Algorithm AudioNormalizationAlgorithm

	// When set to correctAudio the output audio is corrected using the chosen
	// algorithm. If set to measureOnly, the audio will be measured but not adjusted.
	AlgorithmControl AudioNormalizationAlgorithmControl

	// Target LKFS(loudness) to adjust volume to. If no value is entered, a default
	// value will be used according to the chosen algorithm. The CALM Act (1770-1)
	// recommends a target of -24 LKFS. The EBU R-128 specification (1770-2) recommends
	// a target of -23 LKFS.
	TargetLkfs float64

	noSmithyDocumentSerde
}

// Audio Only Hls Settings
type AudioOnlyHlsSettings struct {

	// Specifies the group to which the audio Rendition belongs.
	AudioGroupId *string

	// Optional. Specifies the .jpg or .png image to use as the cover art for an
	// audio-only output. We recommend a low bit-size file because the image increases
	// the output audio bandwidth. The image is attached to the audio as an ID3 tag,
	// frame type APIC, picture type 0x10, as per the "ID3 tag version 2.4.0 - Native
	// Frames" standard.
	AudioOnlyImage *InputLocation

	// Four types of audio-only tracks are supported: Audio-Only Variant Stream The
	// client can play back this audio-only stream instead of video in low-bandwidth
	// scenarios. Represented as an EXT-X-STREAM-INF in the HLS manifest. Alternate
	// Audio, Auto Select, Default Alternate rendition that the client should try to
	// play back by default. Represented as an EXT-X-MEDIA in the HLS manifest with
	// DEFAULT=YES, AUTOSELECT=YES Alternate Audio, Auto Select, Not Default Alternate
	// rendition that the client may try to play back by default. Represented as an
	// EXT-X-MEDIA in the HLS manifest with DEFAULT=NO, AUTOSELECT=YES Alternate Audio,
	// not Auto Select Alternate rendition that the client will not try to play back by
	// default. Represented as an EXT-X-MEDIA in the HLS manifest with DEFAULT=NO,
	// AUTOSELECT=NO
	AudioTrackType AudioOnlyHlsTrackType

	// Specifies the segment type.
	SegmentType AudioOnlyHlsSegmentType

	noSmithyDocumentSerde
}

// Audio Pid Selection
type AudioPidSelection struct {

	// Selects a specific PID from within a source.
	//
	// This member is required.
	Pid int32

	noSmithyDocumentSerde
}

// Audio Selector
type AudioSelector struct {

	// The name of this AudioSelector. AudioDescriptions will use this name to uniquely
	// identify this Selector. Selector names should be unique per input.
	//
	// This member is required.
	Name *string

	// The audio selector settings.
	SelectorSettings *AudioSelectorSettings

	noSmithyDocumentSerde
}

// Audio Selector Settings
type AudioSelectorSettings struct {

	// Audio Hls Rendition Selection
	AudioHlsRenditionSelection *AudioHlsRenditionSelection

	// Audio Language Selection
	AudioLanguageSelection *AudioLanguageSelection

	// Audio Pid Selection
	AudioPidSelection *AudioPidSelection

	// Audio Track Selection
	AudioTrackSelection *AudioTrackSelection

	noSmithyDocumentSerde
}

// Placeholder documentation for AudioSilenceFailoverSettings
type AudioSilenceFailoverSettings struct {

	// The name of the audio selector in the input that MediaLive should monitor to
	// detect silence. Select your most important rendition. If you didn't create an
	// audio selector in this input, leave blank.
	//
	// This member is required.
	AudioSelectorName *string

	// The amount of time (in milliseconds) that the active input must be silent before
	// automatic input failover occurs. Silence is defined as audio loss or audio
	// quieter than -50 dBFS.
	AudioSilenceThresholdMsec int32

	noSmithyDocumentSerde
}

// Audio Track
type AudioTrack struct {

	// 1-based integer value that maps to a specific audio track
	//
	// This member is required.
	Track int32

	noSmithyDocumentSerde
}

// Audio Track Selection
type AudioTrackSelection struct {

	// Selects one or more unique audio tracks from within a source.
	//
	// This member is required.
	Tracks []AudioTrack

	noSmithyDocumentSerde
}

// Audio Watermark Settings
type AudioWatermarkSettings struct {

	// Settings to configure Nielsen Watermarks in the audio encode
	NielsenWatermarksSettings *NielsenWatermarksSettings

	noSmithyDocumentSerde
}

// The settings for Automatic Input Failover.
type AutomaticInputFailoverSettings struct {

	// The input ID of the secondary input in the automatic input failover pair.
	//
	// This member is required.
	SecondaryInputId *string

	// This clear time defines the requirement a recovered input must meet to be
	// considered healthy. The input must have no failover conditions for this length
	// of time. Enter a time in milliseconds. This value is particularly important if
	// the input_preference for the failover pair is set to PRIMARY_INPUT_PREFERRED,
	// because after this time, MediaLive will switch back to the primary input.
	ErrorClearTimeMsec int32

	// A list of failover conditions. If any of these conditions occur, MediaLive will
	// perform a failover to the other input.
	FailoverConditions []FailoverCondition

	// Input preference when deciding which input to make active when a previously
	// failed input has recovered.
	InputPreference InputPreference

	noSmithyDocumentSerde
}

// Avail Blanking
type AvailBlanking struct {

	// Blanking image to be used. Leave empty for solid black. Only bmp and png images
	// are supported.
	AvailBlankingImage *InputLocation

	// When set to enabled, causes video, audio and captions to be blanked when
	// insertion metadata is added.
	State AvailBlankingState

	noSmithyDocumentSerde
}

// Avail Configuration
type AvailConfiguration struct {

	// Ad avail settings.
	AvailSettings *AvailSettings

	noSmithyDocumentSerde
}

// Avail Settings
type AvailSettings struct {

	// Settings for the Esam
	Esam *Esam

	// Scte35 Splice Insert
	Scte35SpliceInsert *Scte35SpliceInsert

	// Scte35 Time Signal Apos
	Scte35TimeSignalApos *Scte35TimeSignalApos

	noSmithyDocumentSerde
}

// Details from a failed operation
type BatchFailedResultModel struct {

	// ARN of the resource
	Arn *string

	// Error code for the failed operation
	Code *string

	// ID of the resource
	Id *string

	// Error message for the failed operation
	Message *string

	noSmithyDocumentSerde
}

// A list of schedule actions to create (in a request) or that have been created
// (in a response).
type BatchScheduleActionCreateRequest struct {

	// A list of schedule actions to create.
	//
	// This member is required.
	ScheduleActions []ScheduleAction

	noSmithyDocumentSerde
}

// List of actions that have been created in the schedule.
type BatchScheduleActionCreateResult struct {

	// List of actions that have been created in the schedule.
	//
	// This member is required.
	ScheduleActions []ScheduleAction

	noSmithyDocumentSerde
}

// A list of schedule actions to delete.
type BatchScheduleActionDeleteRequest struct {

	// A list of schedule actions to delete.
	//
	// This member is required.
	ActionNames []string

	noSmithyDocumentSerde
}

// List of actions that have been deleted from the schedule.
type BatchScheduleActionDeleteResult struct {

	// List of actions that have been deleted from the schedule.
	//
	// This member is required.
	ScheduleActions []ScheduleAction

	noSmithyDocumentSerde
}

// Details from a successful operation
type BatchSuccessfulResultModel struct {

	// ARN of the resource
	Arn *string

	// ID of the resource
	Id *string

	// Current state of the resource
	State *string

	noSmithyDocumentSerde
}

// Blackout Slate
type BlackoutSlate struct {

	// Blackout slate image to be used. Leave empty for solid black. Only bmp and png
	// images are supported.
	BlackoutSlateImage *InputLocation

	// Setting to enabled causes the encoder to blackout the video, audio, and
	// captions, and raise the "Network Blackout Image" slate when an SCTE104/35
	// Network End Segmentation Descriptor is encountered. The blackout will be lifted
	// when the Network Start Segmentation Descriptor is encountered. The Network End
	// and Network Start descriptors must contain a network ID that matches the value
	// entered in "Network ID".
	NetworkEndBlackout BlackoutSlateNetworkEndBlackout

	// Path to local file to use as Network End Blackout image. Image will be scaled to
	// fill the entire output raster.
	NetworkEndBlackoutImage *InputLocation

	// Provides Network ID that matches EIDR ID format (e.g.,
	// "10.XXXX/XXXX-XXXX-XXXX-XXXX-XXXX-C").
	NetworkId *string

	// When set to enabled, causes video, audio and captions to be blanked when
	// indicated by program metadata.
	State BlackoutSlateState

	noSmithyDocumentSerde
}

// Burn In Destination Settings
type BurnInDestinationSettings struct {

	// If no explicit xPosition or yPosition is provided, setting alignment to centered
	// will place the captions at the bottom center of the output. Similarly, setting a
	// left alignment will align captions to the bottom left of the output. If x and y
	// positions are given in conjunction with the alignment parameter, the font will
	// be justified (either left or centered) relative to those coordinates. Selecting
	// "smart" justification will left-justify live subtitles and center-justify
	// pre-recorded subtitles. All burn-in and DVB-Sub font settings must match.
	Alignment BurnInAlignment

	// Specifies the color of the rectangle behind the captions. All burn-in and
	// DVB-Sub font settings must match.
	BackgroundColor BurnInBackgroundColor

	// Specifies the opacity of the background rectangle. 255 is opaque; 0 is
	// transparent. Leaving this parameter out is equivalent to setting it to 0
	// (transparent). All burn-in and DVB-Sub font settings must match.
	BackgroundOpacity int32

	// External font file used for caption burn-in. File extension must be 'ttf' or
	// 'tte'. Although the user can select output fonts for many different types of
	// input captions, embedded, STL and teletext sources use a strict grid system.
	// Using external fonts with these caption sources could cause unexpected display
	// of proportional fonts. All burn-in and DVB-Sub font settings must match.
	Font *InputLocation

	// Specifies the color of the burned-in captions. This option is not valid for
	// source captions that are STL, 608/embedded or teletext. These source settings
	// are already pre-defined by the caption stream. All burn-in and DVB-Sub font
	// settings must match.
	FontColor BurnInFontColor

	// Specifies the opacity of the burned-in captions. 255 is opaque; 0 is
	// transparent. All burn-in and DVB-Sub font settings must match.
	FontOpacity int32

	// Font resolution in DPI (dots per inch); default is 96 dpi. All burn-in and
	// DVB-Sub font settings must match.
	FontResolution int32

	// When set to 'auto' fontSize will scale depending on the size of the output.
	// Giving a positive integer will specify the exact font size in points. All
	// burn-in and DVB-Sub font settings must match.
	FontSize *string

	// Specifies font outline color. This option is not valid for source captions that
	// are either 608/embedded or teletext. These source settings are already
	// pre-defined by the caption stream. All burn-in and DVB-Sub font settings must
	// match.
	OutlineColor BurnInOutlineColor

	// Specifies font outline size in pixels. This option is not valid for source
	// captions that are either 608/embedded or teletext. These source settings are
	// already pre-defined by the caption stream. All burn-in and DVB-Sub font settings
	// must match.
	OutlineSize int32

	// Specifies the color of the shadow cast by the captions. All burn-in and DVB-Sub
	// font settings must match.
	ShadowColor BurnInShadowColor

	// Specifies the opacity of the shadow. 255 is opaque; 0 is transparent. Leaving
	// this parameter out is equivalent to setting it to 0 (transparent). All burn-in
	// and DVB-Sub font settings must match.
	ShadowOpacity int32

	// Specifies the horizontal offset of the shadow relative to the captions in
	// pixels. A value of -2 would result in a shadow offset 2 pixels to the left. All
	// burn-in and DVB-Sub font settings must match.
	ShadowXOffset int32

	// Specifies the vertical offset of the shadow relative to the captions in pixels.
	// A value of -2 would result in a shadow offset 2 pixels above the text. All
	// burn-in and DVB-Sub font settings must match.
	ShadowYOffset int32

	// Controls whether a fixed grid size will be used to generate the output subtitles
	// bitmap. Only applicable for Teletext inputs and DVB-Sub/Burn-in outputs.
	TeletextGridControl BurnInTeletextGridControl

	// Specifies the horizontal position of the caption relative to the left side of
	// the output in pixels. A value of 10 would result in the captions starting 10
	// pixels from the left of the output. If no explicit xPosition is provided, the
	// horizontal caption position will be determined by the alignment parameter. All
	// burn-in and DVB-Sub font settings must match.
	XPosition int32

	// Specifies the vertical position of the caption relative to the top of the output
	// in pixels. A value of 10 would result in the captions starting 10 pixels from
	// the top of the output. If no explicit yPosition is provided, the caption will be
	// positioned towards the bottom of the output. All burn-in and DVB-Sub font
	// settings must match.
	YPosition int32

	noSmithyDocumentSerde
}

// Caption Description
type CaptionDescription struct {

	// Specifies which input caption selector to use as a caption source when
	// generating output captions. This field should match a captionSelector name.
	//
	// This member is required.
	CaptionSelectorName *string

	// Name of the caption description. Used to associate a caption description with an
	// output. Names must be unique within an event.
	//
	// This member is required.
	Name *string

	// Indicates whether the caption track implements accessibility features such as
	// written descriptions of spoken dialog, music, and sounds.
	Accessibility AccessibilityType

	// Additional settings for captions destination that depend on the destination
	// type.
	DestinationSettings *CaptionDestinationSettings

	// ISO 639-2 three-digit code: http://www.loc.gov/standards/iso639-2/
	LanguageCode *string

	// Human readable information to indicate captions available for players (eg.
	// English, or Spanish).
	LanguageDescription *string

	noSmithyDocumentSerde
}

// Caption Destination Settings
type CaptionDestinationSettings struct {

	// Arib Destination Settings
	AribDestinationSettings *AribDestinationSettings

	// Burn In Destination Settings
	BurnInDestinationSettings *BurnInDestinationSettings

	// Dvb Sub Destination Settings
	DvbSubDestinationSettings *DvbSubDestinationSettings

	// Ebu Tt DDestination Settings
	EbuTtDDestinationSettings *EbuTtDDestinationSettings

	// Embedded Destination Settings
	EmbeddedDestinationSettings *EmbeddedDestinationSettings

	// Embedded Plus Scte20 Destination Settings
	EmbeddedPlusScte20DestinationSettings *EmbeddedPlusScte20DestinationSettings

	// Rtmp Caption Info Destination Settings
	RtmpCaptionInfoDestinationSettings *RtmpCaptionInfoDestinationSettings

	// Scte20 Plus Embedded Destination Settings
	Scte20PlusEmbeddedDestinationSettings *Scte20PlusEmbeddedDestinationSettings

	// Scte27 Destination Settings
	Scte27DestinationSettings *Scte27DestinationSettings

	// Smpte Tt Destination Settings
	SmpteTtDestinationSettings *SmpteTtDestinationSettings

	// Teletext Destination Settings
	TeletextDestinationSettings *TeletextDestinationSettings

	// Ttml Destination Settings
	TtmlDestinationSettings *TtmlDestinationSettings

	// Webvtt Destination Settings
	WebvttDestinationSettings *WebvttDestinationSettings

	noSmithyDocumentSerde
}

// Maps a caption channel to an ISO 693-2 language code
// (http://www.loc.gov/standards/iso639-2), with an optional description.
type CaptionLanguageMapping struct {

	// The closed caption channel being described by this CaptionLanguageMapping. Each
	// channel mapping must have a unique channel number (maximum of 4)
	//
	// This member is required.
	CaptionChannel int32

	// Three character ISO 639-2 language code (see
	// http://www.loc.gov/standards/iso639-2)
	//
	// This member is required.
	LanguageCode *string

	// Textual description of language
	//
	// This member is required.
	LanguageDescription *string

	noSmithyDocumentSerde
}

// Caption Rectangle
type CaptionRectangle struct {

	// See the description in leftOffset. For height, specify the entire height of the
	// rectangle as a percentage of the underlying frame height. For example, "80"
	// means the rectangle height is 80% of the underlying frame height. The topOffset
	// and rectangleHeight must add up to 100% or less. This field corresponds to
	// tts:extent - Y in the TTML standard.
	//
	// This member is required.
	Height float64

	// Applies only if you plan to convert these source captions to EBU-TT-D or TTML in
	// an output. (Make sure to leave the default if you don't have either of these
	// formats in the output.) You can define a display rectangle for the captions that
	// is smaller than the underlying video frame. You define the rectangle by
	// specifying the position of the left edge, top edge, bottom edge, and right edge
	// of the rectangle, all within the underlying video frame. The units for the
	// measurements are percentages. If you specify a value for one of these fields,
	// you must specify a value for all of them. For leftOffset, specify the position
	// of the left edge of the rectangle, as a percentage of the underlying frame
	// width, and relative to the left edge of the frame. For example, "10" means the
	// measurement is 10% of the underlying frame width. The rectangle left edge starts
	// at that position from the left edge of the frame. This field corresponds to
	// tts:origin - X in the TTML standard.
	//
	// This member is required.
	LeftOffset float64

	// See the description in leftOffset. For topOffset, specify the position of the
	// top edge of the rectangle, as a percentage of the underlying frame height, and
	// relative to the top edge of the frame. For example, "10" means the measurement
	// is 10% of the underlying frame height. The rectangle top edge starts at that
	// position from the top edge of the frame. This field corresponds to tts:origin -
	// Y in the TTML standard.
	//
	// This member is required.
	TopOffset float64

	// See the description in leftOffset. For width, specify the entire width of the
	// rectangle as a percentage of the underlying frame width. For example, "80" means
	// the rectangle width is 80% of the underlying frame width. The leftOffset and
	// rectangleWidth must add up to 100% or less. This field corresponds to tts:extent
	// - X in the TTML standard.
	//
	// This member is required.
	Width float64

	noSmithyDocumentSerde
}

// Output groups for this Live Event. Output groups contain information about where
// streams should be distributed.
type CaptionSelector struct {

	// Name identifier for a caption selector. This name is used to associate this
	// caption selector with one or more caption descriptions. Names must be unique
	// within an event.
	//
	// This member is required.
	Name *string

	// When specified this field indicates the three letter language code of the
	// caption track to extract from the source.
	LanguageCode *string

	// Caption selector settings.
	SelectorSettings *CaptionSelectorSettings

	noSmithyDocumentSerde
}

// Caption Selector Settings
type CaptionSelectorSettings struct {

	// Ancillary Source Settings
	AncillarySourceSettings *AncillarySourceSettings

	// Arib Source Settings
	AribSourceSettings *AribSourceSettings

	// Dvb Sub Source Settings
	DvbSubSourceSettings *DvbSubSourceSettings

	// Embedded Source Settings
	EmbeddedSourceSettings *EmbeddedSourceSettings

	// Scte20 Source Settings
	Scte20SourceSettings *Scte20SourceSettings

	// Scte27 Source Settings
	Scte27SourceSettings *Scte27SourceSettings

	// Teletext Source Settings
	TeletextSourceSettings *TeletextSourceSettings

	noSmithyDocumentSerde
}

// Placeholder documentation for CdiInputSpecification
type CdiInputSpecification struct {

	// Maximum CDI input resolution
	Resolution CdiInputResolution

	noSmithyDocumentSerde
}

// Placeholder documentation for Channel
type Channel struct {

	// The unique arn of the channel.
	Arn *string

	// Specification of CDI inputs for this channel
	CdiInputSpecification *CdiInputSpecification

	// The class for this channel. STANDARD for a channel with two pipelines or
	// SINGLE_PIPELINE for a channel with one pipeline.
	ChannelClass ChannelClass

	// A list of destinations of the channel. For UDP outputs, there is one destination
	// per output. For other types (HLS, for example), there is one destination per
	// packager.
	Destinations []OutputDestination

	// The endpoints where outgoing connections initiate from
	EgressEndpoints []ChannelEgressEndpoint

	// Encoder Settings
	EncoderSettings *EncoderSettings

	// The unique id of the channel.
	Id *string

	// List of input attachments for channel.
	InputAttachments []InputAttachment

	// Specification of network and file inputs for this channel
	InputSpecification *InputSpecification

	// The log level being written to CloudWatch Logs.
	LogLevel LogLevel

	// Maintenance settings for this channel.
	Maintenance *MaintenanceStatus

	// The name of the channel. (user-mutable)
	Name *string

	// Runtime details for the pipelines of a running channel.
	PipelineDetails []PipelineDetail

	// The number of currently healthy pipelines.
	PipelinesRunningCount int32

	// The Amazon Resource Name (ARN) of the role assumed when running the Channel.
	RoleArn *string

	// Placeholder documentation for ChannelState
	State ChannelState

	// A collection of key-value pairs.
	Tags map[string]string

	// Settings for VPC output
	Vpc *VpcOutputSettingsDescription

	noSmithyDocumentSerde
}

// Placeholder documentation for ChannelEgressEndpoint
type ChannelEgressEndpoint struct {

	// Public IP of where a channel's output comes from
	SourceIp *string

	noSmithyDocumentSerde
}

// Placeholder documentation for ChannelSummary
type ChannelSummary struct {

	// The unique arn of the channel.
	Arn *string

	// Specification of CDI inputs for this channel
	CdiInputSpecification *CdiInputSpecification

	// The class for this channel. STANDARD for a channel with two pipelines or
	// SINGLE_PIPELINE for a channel with one pipeline.
	ChannelClass ChannelClass

	// A list of destinations of the channel. For UDP outputs, there is one destination
	// per output. For other types (HLS, for example), there is one destination per
	// packager.
	Destinations []OutputDestination

	// The endpoints where outgoing connections initiate from
	EgressEndpoints []ChannelEgressEndpoint

	// The unique id of the channel.
	Id *string

	// List of input attachments for channel.
	InputAttachments []InputAttachment

	// Specification of network and file inputs for this channel
	InputSpecification *InputSpecification

	// The log level being written to CloudWatch Logs.
	LogLevel LogLevel

	// Maintenance settings for this channel.
	Maintenance *MaintenanceStatus

	// The name of the channel. (user-mutable)
	Name *string

	// The number of currently healthy pipelines.
	PipelinesRunningCount int32

	// The Amazon Resource Name (ARN) of the role assumed when running the Channel.
	RoleArn *string

	// Placeholder documentation for ChannelState
	State ChannelState

	// A collection of key-value pairs.
	Tags map[string]string

	// Settings for any VPC outputs.
	Vpc *VpcOutputSettingsDescription

	noSmithyDocumentSerde
}

// Passthrough applies no color space conversion to the output
type ColorSpacePassthroughSettings struct {
	noSmithyDocumentSerde
}

// Dolby Vision Profile 8.1 Settings
type DolbyVision81Settings struct {
	noSmithyDocumentSerde
}

// DVB Network Information Table (NIT)
type DvbNitSettings struct {

	// The numeric value placed in the Network Information Table (NIT).
	//
	// This member is required.
	NetworkId int32

	// The network name text placed in the networkNameDescriptor inside the Network
	// Information Table. Maximum length is 256 characters.
	//
	// This member is required.
	NetworkName *string

	// The number of milliseconds between instances of this table in the output
	// transport stream.
	RepInterval int32

	noSmithyDocumentSerde
}

// DVB Service Description Table (SDT)
type DvbSdtSettings struct {

	// Selects method of inserting SDT information into output stream. The sdtFollow
	// setting copies SDT information from input stream to output stream. The
	// sdtFollowIfPresent setting copies SDT information from input stream to output
	// stream if SDT information is present in the input, otherwise it will fall back
	// on the user-defined values. The sdtManual setting means user will enter the SDT
	// information. The sdtNone setting means output stream will not contain SDT
	// information.
	OutputSdt DvbSdtOutputSdt

	// The number of milliseconds between instances of this table in the output
	// transport stream.
	RepInterval int32

	// The service name placed in the serviceDescriptor in the Service Description
	// Table. Maximum length is 256 characters.
	ServiceName *string

	// The service provider name placed in the serviceDescriptor in the Service
	// Description Table. Maximum length is 256 characters.
	ServiceProviderName *string

	noSmithyDocumentSerde
}

// Dvb Sub Destination Settings
type DvbSubDestinationSettings struct {

	// If no explicit xPosition or yPosition is provided, setting alignment to centered
	// will place the captions at the bottom center of the output. Similarly, setting a
	// left alignment will align captions to the bottom left of the output. If x and y
	// positions are given in conjunction with the alignment parameter, the font will
	// be justified (either left or centered) relative to those coordinates. Selecting
	// "smart" justification will left-justify live subtitles and center-justify
	// pre-recorded subtitles. This option is not valid for source captions that are
	// STL or 608/embedded. These source settings are already pre-defined by the
	// caption stream. All burn-in and DVB-Sub font settings must match.
	Alignment DvbSubDestinationAlignment

	// Specifies the color of the rectangle behind the captions. All burn-in and
	// DVB-Sub font settings must match.
	BackgroundColor DvbSubDestinationBackgroundColor

	// Specifies the opacity of the background rectangle. 255 is opaque; 0 is
	// transparent. Leaving this parameter blank is equivalent to setting it to 0
	// (transparent). All burn-in and DVB-Sub font settings must match.
	BackgroundOpacity int32

	// External font file used for caption burn-in. File extension must be 'ttf' or
	// 'tte'. Although the user can select output fonts for many different types of
	// input captions, embedded, STL and teletext sources use a strict grid system.
	// Using external fonts with these caption sources could cause unexpected display
	// of proportional fonts. All burn-in and DVB-Sub font settings must match.
	Font *InputLocation

	// Specifies the color of the burned-in captions. This option is not valid for
	// source captions that are STL, 608/embedded or teletext. These source settings
	// are already pre-defined by the caption stream. All burn-in and DVB-Sub font
	// settings must match.
	FontColor DvbSubDestinationFontColor

	// Specifies the opacity of the burned-in captions. 255 is opaque; 0 is
	// transparent. All burn-in and DVB-Sub font settings must match.
	FontOpacity int32

	// Font resolution in DPI (dots per inch); default is 96 dpi. All burn-in and
	// DVB-Sub font settings must match.
	FontResolution int32

	// When set to auto fontSize will scale depending on the size of the output. Giving
	// a positive integer will specify the exact font size in points. All burn-in and
	// DVB-Sub font settings must match.
	FontSize *string

	// Specifies font outline color. This option is not valid for source captions that
	// are either 608/embedded or teletext. These source settings are already
	// pre-defined by the caption stream. All burn-in and DVB-Sub font settings must
	// match.
	OutlineColor DvbSubDestinationOutlineColor

	// Specifies font outline size in pixels. This option is not valid for source
	// captions that are either 608/embedded or teletext. These source settings are
	// already pre-defined by the caption stream. All burn-in and DVB-Sub font settings
	// must match.
	OutlineSize int32

	// Specifies the color of the shadow cast by the captions. All burn-in and DVB-Sub
	// font settings must match.
	ShadowColor DvbSubDestinationShadowColor

	// Specifies the opacity of the shadow. 255 is opaque; 0 is transparent. Leaving
	// this parameter blank is equivalent to setting it to 0 (transparent). All burn-in
	// and DVB-Sub font settings must match.
	ShadowOpacity int32

	// Specifies the horizontal offset of the shadow relative to the captions in
	// pixels. A value of -2 would result in a shadow offset 2 pixels to the left. All
	// burn-in and DVB-Sub font settings must match.
	ShadowXOffset int32

	// Specifies the vertical offset of the shadow relative to the captions in pixels.
	// A value of -2 would result in a shadow offset 2 pixels above the text. All
	// burn-in and DVB-Sub font settings must match.
	ShadowYOffset int32

	// Controls whether a fixed grid size will be used to generate the output subtitles
	// bitmap. Only applicable for Teletext inputs and DVB-Sub/Burn-in outputs.
	TeletextGridControl DvbSubDestinationTeletextGridControl

	// Specifies the horizontal position of the caption relative to the left side of
	// the output in pixels. A value of 10 would result in the captions starting 10
	// pixels from the left of the output. If no explicit xPosition is provided, the
	// horizontal caption position will be determined by the alignment parameter. This
	// option is not valid for source captions that are STL, 608/embedded or teletext.
	// These source settings are already pre-defined by the caption stream. All burn-in
	// and DVB-Sub font settings must match.
	XPosition int32

	// Specifies the vertical position of the caption relative to the top of the output
	// in pixels. A value of 10 would result in the captions starting 10 pixels from
	// the top of the output. If no explicit yPosition is provided, the caption will be
	// positioned towards the bottom of the output. This option is not valid for source
	// captions that are STL, 608/embedded or teletext. These source settings are
	// already pre-defined by the caption stream. All burn-in and DVB-Sub font settings
	// must match.
	YPosition int32

	noSmithyDocumentSerde
}

// Dvb Sub Source Settings
type DvbSubSourceSettings struct {

	// If you will configure a WebVTT caption description that references this caption
	// selector, use this field to provide the language to consider when translating
	// the image-based source to text.
	OcrLanguage DvbSubOcrLanguage

	// When using DVB-Sub with Burn-In or SMPTE-TT, use this PID for the source
	// content. Unused for DVB-Sub passthrough. All DVB-Sub content is passed through,
	// regardless of selectors.
	Pid int32

	noSmithyDocumentSerde
}

// DVB Time and Date Table (SDT)
type DvbTdtSettings struct {

	// The number of milliseconds between instances of this table in the output
	// transport stream.
	RepInterval int32

	noSmithyDocumentSerde
}

// Eac3 Atmos Settings
type Eac3AtmosSettings struct {

	// Average bitrate in bits/second. Valid bitrates depend on the coding mode. // *
	// @affectsRightSizing true
	Bitrate float64

	// Dolby Digital Plus with Dolby Atmos coding mode. Determines number of channels.
	CodingMode Eac3AtmosCodingMode

	// Sets the dialnorm for the output. Default 23.
	Dialnorm int32

	// Sets the Dolby dynamic range compression profile.
	DrcLine Eac3AtmosDrcLine

	// Sets the profile for heavy Dolby dynamic range compression, ensures that the
	// instantaneous signal peaks do not exceed specified levels.
	DrcRf Eac3AtmosDrcRf

	// Height dimensional trim. Sets the maximum amount to attenuate the height
	// channels when the downstream player isn??t configured to handle Dolby Digital
	// Plus with Dolby Atmos and must remix the channels.
	HeightTrim float64

	// Surround dimensional trim. Sets the maximum amount to attenuate the surround
	// channels when the downstream player isn't configured to handle Dolby Digital
	// Plus with Dolby Atmos and must remix the channels.
	SurroundTrim float64

	noSmithyDocumentSerde
}

// Eac3 Settings
type Eac3Settings struct {

	// When set to attenuate3Db, applies a 3 dB attenuation to the surround channels.
	// Only used for 3/2 coding mode.
	AttenuationControl Eac3AttenuationControl

	// Average bitrate in bits/second. Valid bitrates depend on the coding mode.
	Bitrate float64

	// Specifies the bitstream mode (bsmod) for the emitted E-AC-3 stream. See ATSC
	// A/52-2012 (Annex E) for background on these values.
	BitstreamMode Eac3BitstreamMode

	// Dolby Digital Plus coding mode. Determines number of channels.
	CodingMode Eac3CodingMode

	// When set to enabled, activates a DC highpass filter for all input channels.
	DcFilter Eac3DcFilter

	// Sets the dialnorm for the output. If blank and input audio is Dolby Digital
	// Plus, dialnorm will be passed through.
	Dialnorm int32

	// Sets the Dolby dynamic range compression profile.
	DrcLine Eac3DrcLine

	// Sets the profile for heavy Dolby dynamic range compression, ensures that the
	// instantaneous signal peaks do not exceed specified levels.
	DrcRf Eac3DrcRf

	// When encoding 3/2 audio, setting to lfe enables the LFE channel
	LfeControl Eac3LfeControl

	// When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to
	// encoding. Only valid with codingMode32 coding mode.
	LfeFilter Eac3LfeFilter

	// Left only/Right only center mix level. Only used for 3/2 coding mode.
	LoRoCenterMixLevel float64

	// Left only/Right only surround mix level. Only used for 3/2 coding mode.
	LoRoSurroundMixLevel float64

	// Left total/Right total center mix level. Only used for 3/2 coding mode.
	LtRtCenterMixLevel float64

	// Left total/Right total surround mix level. Only used for 3/2 coding mode.
	LtRtSurroundMixLevel float64

	// When set to followInput, encoder metadata will be sourced from the DD, DD+, or
	// DolbyE decoder that supplied this audio data. If audio was not supplied from one
	// of these streams, then the static metadata settings will be used.
	MetadataControl Eac3MetadataControl

	// When set to whenPossible, input DD+ audio will be passed through if it is
	// present on the input. This detection is dynamic over the life of the transcode.
	// Inputs that alternate between DD+ and non-DD+ content will have a consistent DD+
	// output as the system alternates between passthrough and encoding.
	PassthroughControl Eac3PassthroughControl

	// When set to shift90Degrees, applies a 90-degree phase shift to the surround
	// channels. Only used for 3/2 coding mode.
	PhaseControl Eac3PhaseControl

	// Stereo downmix preference. Only used for 3/2 coding mode.
	StereoDownmix Eac3StereoDownmix

	// When encoding 3/2 audio, sets whether an extra center back surround channel is
	// matrix encoded into the left and right surround channels.
	SurroundExMode Eac3SurroundExMode

	// When encoding 2/0 audio, sets whether Dolby Surround is matrix encoded into the
	// two channels.
	SurroundMode Eac3SurroundMode

	noSmithyDocumentSerde
}

// Ebu Tt DDestination Settings
type EbuTtDDestinationSettings struct {

	// Complete this field if you want to include the name of the copyright holder in
	// the copyright tag in the captions metadata.
	CopyrightHolder *string

	// Specifies how to handle the gap between the lines (in multi-line captions).
	//
	// *
	// enabled: Fill with the captions background color (as specified in the input
	// captions).
	//
	// * disabled: Leave the gap unfilled.
	FillLineGap EbuTtDFillLineGapControl

	// Specifies the font family to include in the font data attached to the EBU-TT
	// captions. Valid only if styleControl is set to include. If you leave this field
	// empty, the font family is set to "monospaced". (If styleControl is set to
	// exclude, the font family is always set to "monospaced".) You specify only the
	// font family. All other style information (color, bold, position and so on) is
	// copied from the input captions. The size is always set to 100% to allow the
	// downstream player to choose the size.
	//
	// * Enter a list of font families, as a
	// comma-separated list of font names, in order of preference. The name can be a
	// font family (such as “Arial”), or a generic font family (such as “serif”), or
	// “default” (to let the downstream player choose the font).
	//
	// * Leave blank to set
	// the family to “monospace”.
	FontFamily *string

	// Specifies the style information (font color, font position, and so on) to
	// include in the font data that is attached to the EBU-TT captions.
	//
	// * include:
	// Take the style information (font color, font position, and so on) from the
	// source captions and include that information in the font data attached to the
	// EBU-TT captions. This option is valid only if the source captions are Embedded
	// or Teletext.
	//
	// * exclude: In the font data attached to the EBU-TT captions, set
	// the font family to "monospaced". Do not include any other style information.
	StyleControl EbuTtDDestinationStyleControl

	noSmithyDocumentSerde
}

// Embedded Destination Settings
type EmbeddedDestinationSettings struct {
	noSmithyDocumentSerde
}

// Embedded Plus Scte20 Destination Settings
type EmbeddedPlusScte20DestinationSettings struct {
	noSmithyDocumentSerde
}

// Embedded Source Settings
type EmbeddedSourceSettings struct {

	// If upconvert, 608 data is both passed through via the "608 compatibility bytes"
	// fields of the 708 wrapper as well as translated into 708. 708 data present in
	// the source content will be discarded.
	Convert608To708 EmbeddedConvert608To708

	// Set to "auto" to handle streams with intermittent and/or non-aligned SCTE-20 and
	// Embedded captions.
	Scte20Detection EmbeddedScte20Detection

	// Specifies the 608/708 channel number within the video track from which to
	// extract captions. Unused for passthrough.
	Source608ChannelNumber int32

	// This field is unused and deprecated.
	Source608TrackNumber int32

	noSmithyDocumentSerde
}

// Encoder Settings
type EncoderSettings struct {

	// Placeholder documentation for __listOfAudioDescription
	//
	// This member is required.
	AudioDescriptions []AudioDescription

	// Placeholder documentation for __listOfOutputGroup
	//
	// This member is required.
	OutputGroups []OutputGroup

	// Contains settings used to acquire and adjust timecode information from inputs.
	//
	// This member is required.
	TimecodeConfig *TimecodeConfig

	// Placeholder documentation for __listOfVideoDescription
	//
	// This member is required.
	VideoDescriptions []VideoDescription

	// Settings for ad avail blanking.
	AvailBlanking *AvailBlanking

	// Event-wide configuration settings for ad avail insertion.
	AvailConfiguration *AvailConfiguration

	// Settings for blackout slate.
	BlackoutSlate *BlackoutSlate

	// Settings for caption decriptions
	CaptionDescriptions []CaptionDescription

	// Feature Activations
	FeatureActivations *FeatureActivations

	// Configuration settings that apply to the event as a whole.
	GlobalConfiguration *GlobalConfiguration

	// Settings for motion graphics.
	MotionGraphicsConfiguration *MotionGraphicsConfiguration

	// Nielsen configuration settings.
	NielsenConfiguration *NielsenConfiguration

	noSmithyDocumentSerde
}

// Settings for the Esam
type Esam struct {

	// Sent as acquisitionPointIdentity to identify the MediaLive channel to the POIS.
	//
	// This member is required.
	AcquisitionPointId *string

	// The URL of the signal conditioner endpoint on the Placement Opportunity
	// Information System (POIS). MediaLive sends SignalProcessingEvents here when
	// SCTE-35 messages are read.
	//
	// This member is required.
	PoisEndpoint *string

	// When specified, this offset (in milliseconds) is added to the input Ad Avail PTS
	// time. This only applies to embedded SCTE 104/35 messages and does not apply to
	// OOB messages.
	AdAvailOffset int32

	// Password if credentials are required to access the POIS endpoint. This is a
	// reference to an AWS parameter store name from which the password can be
	// retrieved. AWS Parameter store format: "ssm://"
	PasswordParam *string

	// Username if credentials are required to access the POIS endpoint. This can be
	// either a plaintext username, or a reference to an AWS parameter store name from
	// which the username can be retrieved. AWS Parameter store format: "ssm://"
	Username *string

	// Optional data sent as zoneIdentity to identify the MediaLive channel to the
	// POIS.
	ZoneIdentity *string

	noSmithyDocumentSerde
}

// Failover Condition settings. There can be multiple failover conditions inside
// AutomaticInputFailoverSettings.
type FailoverCondition struct {

	// Failover condition type-specific settings.
	FailoverConditionSettings *FailoverConditionSettings

	noSmithyDocumentSerde
}

// Settings for one failover condition.
type FailoverConditionSettings struct {

	// MediaLive will perform a failover if the specified audio selector is silent for
	// the specified period.
	AudioSilenceSettings *AudioSilenceFailoverSettings

	// MediaLive will perform a failover if content is not detected in this input for
	// the specified period.
	InputLossSettings *InputLossFailoverSettings

	// MediaLive will perform a failover if content is considered black for the
	// specified period.
	VideoBlackSettings *VideoBlackFailoverSettings

	noSmithyDocumentSerde
}

// Feature Activations
type FeatureActivations struct {

	// Enables the Input Prepare feature. You can create Input Prepare actions in the
	// schedule only if this feature is enabled. If you disable the feature on an
	// existing schedule, make sure that you first delete all input prepare actions
	// from the schedule.
	InputPrepareScheduleActions FeatureActivationsInputPrepareScheduleActions

	noSmithyDocumentSerde
}

// Fec Output Settings
type FecOutputSettings struct {

	// Parameter D from SMPTE 2022-1. The height of the FEC protection matrix. The
	// number of transport stream packets per column error correction packet. Must be
	// between 4 and 20, inclusive.
	ColumnDepth int32

	// Enables column only or column and row based FEC
	IncludeFec FecOutputIncludeFec

	// Parameter L from SMPTE 2022-1. The width of the FEC protection matrix. Must be
	// between 1 and 20, inclusive. If only Column FEC is used, then larger values
	// increase robustness. If Row FEC is used, then this is the number of transport
	// stream packets per row error correction packet, and the value must be between 4
	// and 20, inclusive, if includeFec is columnAndRow. If includeFec is column, this
	// value must be 1 to 20, inclusive.
	RowLength int32

	noSmithyDocumentSerde
}

// Start time for the action.
type FixedModeScheduleActionStartSettings struct {

	// Start time for the action to start in the channel. (Not the time for the action
	// to be added to the schedule: actions are always added to the schedule
	// immediately.) UTC format: yyyy-mm-ddThh:mm:ss.nnnZ. All the letters are digits
	// (for example, mm might be 01) except for the two constants "T" for time and "Z"
	// for "UTC format".
	//
	// This member is required.
	Time *string

	noSmithyDocumentSerde
}

// Fmp4 Hls Settings
type Fmp4HlsSettings struct {

	// List all the audio groups that are used with the video output stream. Input all
	// the audio GROUP-IDs that are associated to the video, separate by ','.
	AudioRenditionSets *string

	// If set to passthrough, Nielsen inaudible tones for media tracking will be
	// detected in the input audio and an equivalent ID3 tag will be inserted in the
	// output.
	NielsenId3Behavior Fmp4NielsenId3Behavior

	// When set to passthrough, timed metadata is passed through from input to output.
	TimedMetadataBehavior Fmp4TimedMetadataBehavior

	noSmithyDocumentSerde
}

// Settings to specify if an action follows another.
type FollowModeScheduleActionStartSettings struct {

	// Identifies whether this action starts relative to the start or relative to the
	// end of the reference action.
	//
	// This member is required.
	FollowPoint FollowPoint

	// The action name of another action that this one refers to.
	//
	// This member is required.
	ReferenceActionName *string

	noSmithyDocumentSerde
}

// Frame Capture Cdn Settings
type FrameCaptureCdnSettings struct {

	// Frame Capture S3 Settings
	FrameCaptureS3Settings *FrameCaptureS3Settings

	noSmithyDocumentSerde
}

// Frame Capture Group Settings
type FrameCaptureGroupSettings struct {

	// The destination for the frame capture files. Either the URI for an Amazon S3
	// bucket and object, plus a file name prefix (for example,
	// s3ssl://sportsDelivery/highlights/20180820/curling-) or the URI for a MediaStore
	// container, plus a file name prefix (for example,
	// mediastoressl://sportsDelivery/20180820/curling-). The final file names consist
	// of the prefix from the destination field (for example, "curling-") + name
	// modifier + the counter (5 digits, starting from 00001) + extension (which is
	// always .jpg). For example, curling-low.00001.jpg
	//
	// This member is required.
	Destination *OutputLocationRef

	// Parameters that control interactions with the CDN.
	FrameCaptureCdnSettings *FrameCaptureCdnSettings

	noSmithyDocumentSerde
}

// Frame Capture Hls Settings
type FrameCaptureHlsSettings struct {
	noSmithyDocumentSerde
}

// Frame Capture Output Settings
type FrameCaptureOutputSettings struct {

	// Required if the output group contains more than one output. This modifier forms
	// part of the output file name.
	NameModifier *string

	noSmithyDocumentSerde
}

// Frame Capture S3 Settings
type FrameCaptureS3Settings struct {

	// Specify the canned ACL to apply to each S3 request. Defaults to none.
	CannedAcl S3CannedAcl

	noSmithyDocumentSerde
}

// Frame Capture Settings
type FrameCaptureSettings struct {

	// The frequency at which to capture frames for inclusion in the output. May be
	// specified in either seconds or milliseconds, as specified by
	// captureIntervalUnits.
	CaptureInterval int32

	// Unit for the frame capture interval.
	CaptureIntervalUnits FrameCaptureIntervalUnit

	noSmithyDocumentSerde
}

// Global Configuration
type GlobalConfiguration struct {

	// Value to set the initial audio gain for the Live Event.
	InitialAudioGain int32

	// Indicates the action to take when the current input completes (e.g.
	// end-of-file). When switchAndLoopInputs is configured the encoder will restart at
	// the beginning of the first input. When "none" is configured the encoder will
	// transcode either black, a solid color, or a user specified slate images per the
	// "Input Loss Behavior" configuration until the next input switch occurs (which is
	// controlled through the Channel Schedule API).
	InputEndAction GlobalConfigurationInputEndAction

	// Settings for system actions when input is lost.
	InputLossBehavior *InputLossBehavior

	// Indicates how MediaLive pipelines are synchronized. PIPELINE_LOCKING - MediaLive
	// will attempt to synchronize the output of each pipeline to the other.
	// EPOCH_LOCKING - MediaLive will attempt to synchronize the output of each
	// pipeline to the Unix epoch.
	OutputLockingMode GlobalConfigurationOutputLockingMode

	// Indicates whether the rate of frames emitted by the Live encoder should be paced
	// by its system clock (which optionally may be locked to another source via NTP)
	// or should be locked to the clock of the source that is providing the input
	// stream.
	OutputTimingSource GlobalConfigurationOutputTimingSource

	// Adjusts video input buffer for streams with very low video framerates. This is
	// commonly set to enabled for music channels with less than one video frame per
	// second.
	SupportLowFramerateInputs GlobalConfigurationLowFramerateInputs

	noSmithyDocumentSerde
}

// H264 Color Space Settings
type H264ColorSpaceSettings struct {

	// Passthrough applies no color space conversion to the output
	ColorSpacePassthroughSettings *ColorSpacePassthroughSettings

	// Rec601 Settings
	Rec601Settings *Rec601Settings

	// Rec709 Settings
	Rec709Settings *Rec709Settings

	noSmithyDocumentSerde
}

// H264 Filter Settings
type H264FilterSettings struct {

	// Temporal Filter Settings
	TemporalFilterSettings *TemporalFilterSettings

	noSmithyDocumentSerde
}

// H264 Settings
type H264Settings struct {

	// Enables or disables adaptive quantization, which is a technique MediaLive can
	// apply to video on a frame-by-frame basis to produce more compression without
	// losing quality. There are three types of adaptive quantization: flicker,
	// spatial, and temporal. Set the field in one of these ways: Set to Auto.
	// Recommended. For each type of AQ, MediaLive will determine if AQ is needed, and
	// if so, the appropriate strength. Set a strength (a value other than Auto or
	// Disable). This strength will apply to any of the AQ fields that you choose to
	// enable. Set to Disabled to disable all types of adaptive quantization.
	AdaptiveQuantization H264AdaptiveQuantization

	// Indicates that AFD values will be written into the output stream. If
	// afdSignaling is "auto", the system will try to preserve the input AFD value (in
	// cases where multiple AFD values are valid). If set to "fixed", the AFD value
	// will be the value configured in the fixedAfd parameter.
	AfdSignaling AfdSignaling

	// Average bitrate in bits/second. Required when the rate control mode is VBR or
	// CBR. Not used for QVBR. In an MS Smooth output group, each output must have a
	// unique value when its bitrate is rounded down to the nearest multiple of 1000.
	Bitrate int32

	// Percentage of the buffer that should initially be filled (HRD buffer model).
	BufFillPct int32

	// Size of buffer (HRD buffer model) in bits.
	BufSize int32

	// Includes colorspace metadata in the output.
	ColorMetadata H264ColorMetadata

	// Color Space settings
	ColorSpaceSettings *H264ColorSpaceSettings

	// Entropy encoding mode. Use cabac (must be in Main or High profile) or cavlc.
	EntropyEncoding H264EntropyEncoding

	// Optional filters that you can apply to an encode.
	FilterSettings *H264FilterSettings

	// Four bit AFD value to write on all frames of video in the output stream. Only
	// valid when afdSignaling is set to 'Fixed'.
	FixedAfd FixedAfd

	// Flicker AQ makes adjustments within each frame to reduce flicker or 'pop' on
	// I-frames. The value to enter in this field depends on the value in the Adaptive
	// quantization field: If you have set the Adaptive quantization field to Auto,
	// MediaLive ignores any value in this field. MediaLive will determine if flicker
	// AQ is appropriate and will apply the appropriate strength. If you have set the
	// Adaptive quantization field to a strength, you can set this field to Enabled or
	// Disabled. Enabled: MediaLive will apply flicker AQ using the specified strength.
	// Disabled: MediaLive won't apply flicker AQ. If you have set the Adaptive
	// quantization to Disabled, MediaLive ignores any value in this field and doesn't
	// apply flicker AQ.
	FlickerAq H264FlickerAq

	// This setting applies only when scan type is "interlaced." It controls whether
	// coding is performed on a field basis or on a frame basis. (When the video is
	// progressive, the coding is always performed on a frame basis.) enabled: Force
	// MediaLive to code on a field basis, so that odd and even sets of fields are
	// coded separately. disabled: Code the two sets of fields separately (on a field
	// basis) or together (on a frame basis using PAFF), depending on what is most
	// appropriate for the content.
	ForceFieldPictures H264ForceFieldPictures

	// This field indicates how the output video frame rate is specified. If
	// "specified" is selected then the output video frame rate is determined by
	// framerateNumerator and framerateDenominator, else if "initializeFromSource" is
	// selected then the output video frame rate will be set equal to the input video
	// frame rate of the first input.
	FramerateControl H264FramerateControl

	// Framerate denominator.
	FramerateDenominator int32

	// Framerate numerator - framerate is a fraction, e.g. 24000 / 1001 = 23.976 fps.
	FramerateNumerator int32

	// Documentation update needed
	GopBReference H264GopBReference

	// Frequency of closed GOPs. In streaming applications, it is recommended that this
	// be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly
	// as possible. Setting this value to 0 will break output segmenting.
	GopClosedCadence int32

	// Number of B-frames between reference frames.
	GopNumBFrames int32

	// GOP size (keyframe interval) in units of either frames or seconds per
	// gopSizeUnits. If gopSizeUnits is frames, gopSize must be an integer and must be
	// greater than or equal to 1. If gopSizeUnits is seconds, gopSize must be greater
	// than 0, but need not be an integer.
	GopSize float64

	// Indicates if the gopSize is specified in frames or seconds. If seconds the
	// system will convert the gopSize into a frame count at run time.
	GopSizeUnits H264GopSizeUnits

	// H.264 Level.
	Level H264Level

	// Amount of lookahead. A value of low can decrease latency and memory usage, while
	// high can produce better quality for certain content.
	LookAheadRateControl H264LookAheadRateControl

	// For QVBR: See the tooltip for Quality level For VBR: Set the maximum bitrate in
	// order to accommodate expected spikes in the complexity of the video.
	MaxBitrate int32

	// Only meaningful if sceneChangeDetect is set to enabled. Defaults to 5 if
	// multiplex rate control is used. Enforces separation between repeated (cadence)
	// I-frames and I-frames inserted by Scene Change Detection. If a scene change
	// I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk
	// and/or stretched to the scene change I-frame. GOP stretch requires enabling
	// lookahead as well as setting I-interval. The normal cadence resumes for the next
	// GOP. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
	MinIInterval int32

	// Number of reference frames to use. The encoder may use more than requested if
	// using B-frames and/or interlaced encoding.
	NumRefFrames int32

	// This field indicates how the output pixel aspect ratio is specified. If
	// "specified" is selected then the output video pixel aspect ratio is determined
	// by parNumerator and parDenominator, else if "initializeFromSource" is selected
	// then the output pixsel aspect ratio will be set equal to the input video pixel
	// aspect ratio of the first input.
	ParControl H264ParControl

	// Pixel Aspect Ratio denominator.
	ParDenominator int32

	// Pixel Aspect Ratio numerator.
	ParNumerator int32

	// H.264 Profile.
	Profile H264Profile

	// Leave as STANDARD_QUALITY or choose a different value (which might result in
	// additional costs to run the channel).
	//
	// * ENHANCED_QUALITY: Produces a slightly
	// better video quality without an increase in the bitrate. Has an effect only when
	// the Rate control mode is QVBR or CBR. If this channel is in a MediaLive
	// multiplex, the value must be ENHANCED_QUALITY.
	//
	// * STANDARD_QUALITY: Valid for
	// any Rate control mode.
	QualityLevel H264QualityLevel

	// Controls the target quality for the video encode. Applies only when the rate
	// control mode is QVBR. You can set a target quality or you can let MediaLive
	// determine the best quality. To set a target quality, enter values in the QVBR
	// quality level field and the Max bitrate field. Enter values that suit your most
	// important viewing devices. Recommended values are:
	//
	// * Primary screen: Quality
	// level: 8 to 10. Max bitrate: 4M
	//
	// * PC or tablet: Quality level: 7. Max bitrate:
	// 1.5M to 3M
	//
	// * Smartphone: Quality level: 6. Max bitrate: 1M to 1.5M To let
	// MediaLive decide, leave the QVBR quality level field empty, and in Max bitrate
	// enter the maximum rate you want in the video. For more information, see the
	// section called "Video - rate control mode" in the MediaLive user guide
	QvbrQualityLevel int32

	// Rate control mode. QVBR: Quality will match the specified quality level except
	// when it is constrained by the maximum bitrate. Recommended if you or your
	// viewers pay for bandwidth. VBR: Quality and bitrate vary, depending on the video
	// complexity. Recommended instead of QVBR if you want to maintain a specific
	// average bitrate over the duration of the channel. CBR: Quality varies, depending
	// on the video complexity. Recommended only if you distribute your assets to
	// devices that cannot handle variable bitrates. Multiplex: This rate control mode
	// is only supported (and is required) when the video is being delivered to a
	// MediaLive Multiplex in which case the rate control configuration is controlled
	// by the properties within the Multiplex Program.
	RateControlMode H264RateControlMode

	// Sets the scan type of the output to progressive or top-field-first interlaced.
	ScanType H264ScanType

	// Scene change detection.
	//
	// * On: inserts I-frames when scene change is
	// detected.
	//
	// * Off: does not force an I-frame when scene change is detected.
	SceneChangeDetect H264SceneChangeDetect

	// Number of slices per picture. Must be less than or equal to the number of
	// macroblock rows for progressive pictures, and less than or equal to half the
	// number of macroblock rows for interlaced pictures. This field is optional; when
	// no value is specified the encoder will choose the number of slices based on
	// encode resolution.
	Slices int32

	// Softness. Selects quantizer matrix, larger values reduce high-frequency content
	// in the encoded image. If not set to zero, must be greater than 15.
	Softness int32

	// Spatial AQ makes adjustments within each frame based on spatial variation of
	// content complexity. The value to enter in this field depends on the value in the
	// Adaptive quantization field: If you have set the Adaptive quantization field to
	// Auto, MediaLive ignores any value in this field. MediaLive will determine if
	// spatial AQ is appropriate and will apply the appropriate strength. If you have
	// set the Adaptive quantization field to a strength, you can set this field to
	// Enabled or Disabled. Enabled: MediaLive will apply spatial AQ using the
	// specified strength. Disabled: MediaLive won't apply spatial AQ. If you have set
	// the Adaptive quantization to Disabled, MediaLive ignores any value in this field
	// and doesn't apply spatial AQ.
	SpatialAq H264SpatialAq

	// If set to fixed, use gopNumBFrames B-frames per sub-GOP. If set to dynamic,
	// optimize the number of B-frames used for each sub-GOP to improve visual quality.
	SubgopLength H264SubGopLength

	// Produces a bitstream compliant with SMPTE RP-2027.
	Syntax H264Syntax

	// Temporal makes adjustments within each frame based on temporal variation of
	// content complexity. The value to enter in this field depends on the value in the
	// Adaptive quantization field: If you have set the Adaptive quantization field to
	// Auto, MediaLive ignores any value in this field. MediaLive will determine if
	// temporal AQ is appropriate and will apply the appropriate strength. If you have
	// set the Adaptive quantization field to a strength, you can set this field to
	// Enabled or Disabled. Enabled: MediaLive will apply temporal AQ using the
	// specified strength. Disabled: MediaLive won't apply temporal AQ. If you have set
	// the Adaptive quantization to Disabled, MediaLive ignores any value in this field
	// and doesn't apply temporal AQ.
	TemporalAq H264TemporalAq

	// Determines how timecodes should be inserted into the video elementary stream.
	//
	// *
	// 'disabled': Do not include timecodes
	//
	// * 'picTimingSei': Pass through picture
	// timing SEI messages from the source specified in Timecode Config
	TimecodeInsertion H264TimecodeInsertionBehavior

	noSmithyDocumentSerde
}

// H265 Color Space Settings
type H265ColorSpaceSettings struct {

	// Passthrough applies no color space conversion to the output
	ColorSpacePassthroughSettings *ColorSpacePassthroughSettings

	// Dolby Vision Profile 8.1 Settings
	DolbyVision81Settings *DolbyVision81Settings

	// Hdr10 Settings
	Hdr10Settings *Hdr10Settings

	// Rec601 Settings
	Rec601Settings *Rec601Settings

	// Rec709 Settings
	Rec709Settings *Rec709Settings

	noSmithyDocumentSerde
}

// H265 Filter Settings
type H265FilterSettings struct {

	// Temporal Filter Settings
	TemporalFilterSettings *TemporalFilterSettings

	noSmithyDocumentSerde
}

// H265 Settings
type H265Settings struct {

	// Framerate denominator.
	//
	// This member is required.
	FramerateDenominator int32

	// Framerate numerator - framerate is a fraction, e.g. 24000 / 1001 = 23.976 fps.
	//
	// This member is required.
	FramerateNumerator int32

	// Adaptive quantization. Allows intra-frame quantizers to vary to improve visual
	// quality.
	AdaptiveQuantization H265AdaptiveQuantization

	// Indicates that AFD values will be written into the output stream. If
	// afdSignaling is "auto", the system will try to preserve the input AFD value (in
	// cases where multiple AFD values are valid). If set to "fixed", the AFD value
	// will be the value configured in the fixedAfd parameter.
	AfdSignaling AfdSignaling

	// Whether or not EML should insert an Alternative Transfer Function SEI message to
	// support backwards compatibility with non-HDR decoders and displays.
	AlternativeTransferFunction H265AlternativeTransferFunction

	// Average bitrate in bits/second. Required when the rate control mode is VBR or
	// CBR. Not used for QVBR. In an MS Smooth output group, each output must have a
	// unique value when its bitrate is rounded down to the nearest multiple of 1000.
	Bitrate int32

	// Size of buffer (HRD buffer model) in bits.
	BufSize int32

	// Includes colorspace metadata in the output.
	ColorMetadata H265ColorMetadata

	// Color Space settings
	ColorSpaceSettings *H265ColorSpaceSettings

	// Optional filters that you can apply to an encode.
	FilterSettings *H265FilterSettings

	// Four bit AFD value to write on all frames of video in the output stream. Only
	// valid when afdSignaling is set to 'Fixed'.
	FixedAfd FixedAfd

	// If set to enabled, adjust quantization within each frame to reduce flicker or
	// 'pop' on I-frames.
	FlickerAq H265FlickerAq

	// Frequency of closed GOPs. In streaming applications, it is recommended that this
	// be set to 1 so a decoder joining mid-stream will receive an IDR frame as quickly
	// as possible. Setting this value to 0 will break output segmenting.
	GopClosedCadence int32

	// GOP size (keyframe interval) in units of either frames or seconds per
	// gopSizeUnits. If gopSizeUnits is frames, gopSize must be an integer and must be
	// greater than or equal to 1. If gopSizeUnits is seconds, gopSize must be greater
	// than 0, but need not be an integer.
	GopSize float64

	// Indicates if the gopSize is specified in frames or seconds. If seconds the
	// system will convert the gopSize into a frame count at run time.
	GopSizeUnits H265GopSizeUnits

	// H.265 Level.
	Level H265Level

	// Amount of lookahead. A value of low can decrease latency and memory usage, while
	// high can produce better quality for certain content.
	LookAheadRateControl H265LookAheadRateControl

	// For QVBR: See the tooltip for Quality level
	MaxBitrate int32

	// Only meaningful if sceneChangeDetect is set to enabled. Defaults to 5 if
	// multiplex rate control is used. Enforces separation between repeated (cadence)
	// I-frames and I-frames inserted by Scene Change Detection. If a scene change
	// I-frame is within I-interval frames of a cadence I-frame, the GOP is shrunk
	// and/or stretched to the scene change I-frame. GOP stretch requires enabling
	// lookahead as well as setting I-interval. The normal cadence resumes for the next
	// GOP. Note: Maximum GOP stretch = GOP size + Min-I-interval - 1
	MinIInterval int32

	// Pixel Aspect Ratio denominator.
	ParDenominator int32

	// Pixel Aspect Ratio numerator.
	ParNumerator int32

	// H.265 Profile.
	Profile H265Profile

	// Controls the target quality for the video encode. Applies only when the rate
	// control mode is QVBR. Set values for the QVBR quality level field and Max
	// bitrate field that suit your most important viewing devices. Recommended values
	// are:
	//
	// * Primary screen: Quality level: 8 to 10. Max bitrate: 4M
	//
	// * PC or tablet:
	// Quality level: 7. Max bitrate: 1.5M to 3M
	//
	// * Smartphone: Quality level: 6. Max
	// bitrate: 1M to 1.5M
	QvbrQualityLevel int32

	// Rate control mode. QVBR: Quality will match the specified quality level except
	// when it is constrained by the maximum bitrate. Recommended if you or your
	// viewers pay for bandwidth. CBR: Quality varies, depending on the video
	// complexity. Recommended only if you distribute your assets to devices that
	// cannot handle variable bitrates. Multiplex: This rate control mode is only
	// supported (and is required) when the video is being delivered to a MediaLive
	// Multiplex in which case the rate control configuration is controlled by the
	// properties within the Multiplex Program.
	RateControlMode H265RateControlMode

	// Sets the scan type of the output to progressive or top-field-first interlaced.
	ScanType H265ScanType

	// Scene change detection.
	SceneChangeDetect H265SceneChangeDetect

	// Number of slices per picture. Must be less than or equal to the number of
	// macroblock rows for progressive pictures, and less than or equal to half the
	// number of macroblock rows for interlaced pictures. This field is optional; when
	// no value is specified the encoder will choose the number of slices based on
	// encode resolution.
	Slices int32

	// H.265 Tier.
	Tier H265Tier

	// Determines how timecodes should be inserted into the video elementary stream.
	//
	// *
	// 'disabled': Do not include timecodes
	//
	// * 'picTimingSei': Pass through picture
	// timing SEI messages from the source specified in Timecode Config
	TimecodeInsertion H265TimecodeInsertionBehavior

	noSmithyDocumentSerde
}

// Hdr10 Settings
type Hdr10Settings struct {

	// Maximum Content Light Level An integer metadata value defining the maximum light
	// level, in nits, of any single pixel within an encoded HDR video stream or file.
	MaxCll int32

	// Maximum Frame Average Light Level An integer metadata value defining the maximum
	// average light level, in nits, for any single frame within an encoded HDR video
	// stream or file.
	MaxFall int32

	noSmithyDocumentSerde
}

// Hls Akamai Settings
type HlsAkamaiSettings struct {

	// Number of seconds to wait before retrying connection to the CDN if the
	// connection is lost.
	ConnectionRetryInterval int32

	// Size in seconds of file cache for streaming outputs.
	FilecacheDuration int32

	// Specify whether or not to use chunked transfer encoding to Akamai. User should
	// contact Akamai to enable this feature.
	HttpTransferMode HlsAkamaiHttpTransferMode

	// Number of retry attempts that will be made before the Live Event is put into an
	// error state.
	NumRetries int32

	// If a streaming output fails, number of seconds to wait until a restart is
	// initiated. A value of 0 means never restart.
	RestartDelay int32

	// Salt for authenticated Akamai.
	Salt *string

	// Token parameter for authenticated akamai. If not specified, gda is used.
	Token *string

	noSmithyDocumentSerde
}

// Hls Basic Put Settings
type HlsBasicPutSettings struct {

	// Number of seconds to wait before retrying connection to the CDN if the
	// connection is lost.
	ConnectionRetryInterval int32

	// Size in seconds of file cache for streaming outputs.
	FilecacheDuration int32

	// Number of retry attempts that will be made before the Live Event is put into an
	// error state.
	NumRetries int32

	// If a streaming output fails, number of seconds to wait until a restart is
	// initiated. A value of 0 means never restart.
	RestartDelay int32

	noSmithyDocumentSerde
}

// Hls Cdn Settings
type HlsCdnSettings struct {

	// Hls Akamai Settings
	HlsAkamaiSettings *HlsAkamaiSettings

	// Hls Basic Put Settings
	HlsBasicPutSettings *HlsBasicPutSettings

	// Hls Media Store Settings
	HlsMediaStoreSettings *HlsMediaStoreSettings

	// Hls S3 Settings
	HlsS3Settings *HlsS3Settings

	// Hls Webdav Settings
	HlsWebdavSettings *HlsWebdavSettings

	noSmithyDocumentSerde
}

// Hls Group Settings
type HlsGroupSettings struct {

	// A directory or HTTP destination for the HLS segments, manifest files, and
	// encryption keys (if enabled).
	//
	// This member is required.
	Destination *OutputLocationRef

	// Choose one or more ad marker types to pass SCTE35 signals through to this group
	// of Apple HLS outputs.
	AdMarkers []HlsAdMarkers

	// A partial URI prefix that will be prepended to each output in the media .m3u8
	// file. Can be used if base manifest is delivered from a different URL than the
	// main .m3u8 file.
	BaseUrlContent *string

	// Optional. One value per output group. This field is required only if you are
	// completing Base URL content A, and the downstream system has notified you that
	// the media files for pipeline 1 of all outputs are in a location different from
	// the media files for pipeline 0.
	BaseUrlContent1 *string

	// A partial URI prefix that will be prepended to each output in the media .m3u8
	// file. Can be used if base manifest is delivered from a different URL than the
	// main .m3u8 file.
	BaseUrlManifest *string

	// Optional. One value per output group. Complete this field only if you are
	// completing Base URL manifest A, and the downstream system has notified you that
	// the child manifest files for pipeline 1 of all outputs are in a location
	// different from the child manifest files for pipeline 0.
	BaseUrlManifest1 *string

	// Mapping of up to 4 caption channels to caption languages. Is only meaningful if
	// captionLanguageSetting is set to "insert".
	CaptionLanguageMappings []CaptionLanguageMapping

	// Applies only to 608 Embedded output captions. insert: Include CLOSED-CAPTIONS
	// lines in the manifest. Specify at least one language in the CC1 Language Code
	// field. One CLOSED-CAPTION line is added for each Language Code you specify. Make
	// sure to specify the languages in the order in which they appear in the original
	// source (if the source is embedded format) or the order of the caption selectors
	// (if the source is other than embedded). Otherwise, languages in the manifest
	// will not match up properly with the output captions. none: Include
	// CLOSED-CAPTIONS=NONE line in the manifest. omit: Omit any CLOSED-CAPTIONS line
	// from the manifest.
	CaptionLanguageSetting HlsCaptionLanguageSetting

	// When set to "disabled", sets the #EXT-X-ALLOW-CACHE:no tag in the manifest,
	// which prevents clients from saving media segments for later replay.
	ClientCache HlsClientCache

	// Specification to use (RFC-6381 or the default RFC-4281) during m3u8 playlist
	// generation.
	CodecSpecification HlsCodecSpecification

	// For use with encryptionType. This is a 128-bit, 16-byte hex value represented by
	// a 32-character text string. If ivSource is set to "explicit" then this parameter
	// is required and is used as the IV for encryption.
	ConstantIv *string

	// Place segments in subdirectories.
	DirectoryStructure HlsDirectoryStructure

	// Specifies whether to insert EXT-X-DISCONTINUITY tags in the HLS child manifests
	// for this output group. Typically, choose Insert because these tags are required
	// in the manifest (according to the HLS specification) and serve an important
	// purpose. Choose Never Insert only if the downstream system is doing real-time
	// failover (without using the MediaLive automatic failover feature) and only if
	// that downstream system has advised you to exclude the tags.
	DiscontinuityTags HlsDiscontinuityTags

	// Encrypts the segments with the given encryption scheme. Exclude this parameter
	// if no encryption is desired.
	EncryptionType HlsEncryptionType

	// Parameters that control interactions with the CDN.
	HlsCdnSettings *HlsCdnSettings

	// State of HLS ID3 Segment Tagging
	HlsId3SegmentTagging HlsId3SegmentTaggingState

	// DISABLED: Do not create an I-frame-only manifest, but do create the master and
	// media manifests (according to the Output Selection field). STANDARD: Create an
	// I-frame-only manifest for each output that contains video, as well as the other
	// manifests (according to the Output Selection field). The I-frame manifest
	// contains a #EXT-X-I-FRAMES-ONLY tag to indicate it is I-frame only, and one or
	// more #EXT-X-BYTERANGE entries identifying the I-frame position. For example,
	// #EXT-X-BYTERANGE:160364@1461888"
	IFrameOnlyPlaylists IFrameOnlyPlaylistType

	// Specifies whether to include the final (incomplete) segment in the media output
	// when the pipeline stops producing output because of a channel stop, a channel
	// pause or a loss of input to the pipeline. Auto means that MediaLive decides
	// whether to include the final segment, depending on the channel class and the
	// types of output groups. Suppress means to never include the incomplete segment.
	// We recommend you choose Auto and let MediaLive control the behavior.
	IncompleteSegmentBehavior HlsIncompleteSegmentBehavior

	// Applies only if Mode field is LIVE. Specifies the maximum number of segments in
	// the media manifest file. After this maximum, older segments are removed from the
	// media manifest. This number must be smaller than the number in the Keep Segments
	// field.
	IndexNSegments int32

	// Parameter that control output group behavior on input loss.
	InputLossAction InputLossActionForHlsOut

	// For use with encryptionType. The IV (Initialization Vector) is a 128-bit number
	// used in conjunction with the key for encrypting blocks. If set to "include", IV
	// is listed in the manifest, otherwise the IV is not in the manifest.
	IvInManifest HlsIvInManifest

	// For use with encryptionType. The IV (Initialization Vector) is a 128-bit number
	// used in conjunction with the key for encrypting blocks. If this setting is
	// "followsSegmentNumber", it will cause the IV to change every segment (to match
	// the segment number). If this is set to "explicit", you must enter a constantIv
	// value.
	IvSource HlsIvSource

	// Applies only if Mode field is LIVE. Specifies the number of media segments to
	// retain in the destination directory. This number should be bigger than
	// indexNSegments (Num segments). We recommend (value = (2 x indexNsegments) + 1).
	// If this "keep segments" number is too low, the following might happen: the
	// player is still reading a media manifest file that lists this segment, but that
	// segment has been removed from the destination directory (as directed by
	// indexNSegments). This situation would result in a 404 HTTP error on the player.
	KeepSegments int32

	// The value specifies how the key is represented in the resource identified by the
	// URI. If parameter is absent, an implicit value of "identity" is used. A reverse
	// DNS string can also be given.
	KeyFormat *string

	// Either a single positive integer version value or a slash delimited list of
	// version values (1/2/3).
	KeyFormatVersions *string

	// The key provider settings.
	KeyProviderSettings *KeyProviderSettings

	// When set to gzip, compresses HLS playlist.
	ManifestCompression HlsManifestCompression

	// Indicates whether the output manifest should use floating point or integer
	// values for segment duration.
	ManifestDurationFormat HlsManifestDurationFormat

	// When set, minimumSegmentLength is enforced by looking ahead and back within the
	// specified range for a nearby avail and extending the segment size if needed.
	MinSegmentLength int32

	// If "vod", all segments are indexed and kept permanently in the destination and
	// manifest. If "live", only the number segments specified in keepSegments and
	// indexNSegments are kept; newer segments replace older segments, which may
	// prevent players from rewinding all the way to the beginning of the event. VOD
	// mode uses HLS EXT-X-PLAYLIST-TYPE of EVENT while the channel is running,
	// converting it to a "VOD" type manifest on completion of the stream.
	Mode HlsMode

	// MANIFESTS_AND_SEGMENTS: Generates manifests (master manifest, if applicable, and
	// media manifests) for this output group. VARIANT_MANIFESTS_AND_SEGMENTS:
	// Generates media manifests for this output group, but not a master manifest.
	// SEGMENTS_ONLY: Does not generate any manifests for this output group.
	OutputSelection HlsOutputSelection

	// Includes or excludes EXT-X-PROGRAM-DATE-TIME tag in .m3u8 manifest files. The
	// value is calculated using the program date time clock.
	ProgramDateTime HlsProgramDateTime

	// Specifies the algorithm used to drive the HLS EXT-X-PROGRAM-DATE-TIME clock.
	// Options include: INITIALIZE_FROM_OUTPUT_TIMECODE: The PDT clock is initialized
	// as a function of the first output timecode, then incremented by the EXTINF
	// duration of each encoded segment. SYSTEM_CLOCK: The PDT clock is initialized as
	// a function of the UTC wall clock, then incremented by the EXTINF duration of
	// each encoded segment. If the PDT clock diverges from the wall clock by more than
	// 500ms, it is resynchronized to the wall clock.
	ProgramDateTimeClock HlsProgramDateTimeClock

	// Period of insertion of EXT-X-PROGRAM-DATE-TIME entry, in seconds.
	ProgramDateTimePeriod int32

	// ENABLED: The master manifest (.m3u8 file) for each pipeline includes information
	// about both pipelines: first its own media files, then the media files of the
	// other pipeline. This feature allows playout device that support stale manifest
	// detection to switch from one manifest to the other, when the current manifest
	// seems to be stale. There are still two destinations and two master manifests,
	// but both master manifests reference the media files from both pipelines.
	// DISABLED: The master manifest (.m3u8 file) for each pipeline includes
	// information about its own pipeline only. For an HLS output group with
	// MediaPackage as the destination, the DISABLED behavior is always followed.
	// MediaPackage regenerates the manifests it serves to players so a redundant
	// manifest from MediaLive is irrelevant.
	RedundantManifest HlsRedundantManifest

	// Length of MPEG-2 Transport Stream segments to create (in seconds). Note that
	// segments will end on the next keyframe after this number of seconds, so actual
	// segment length may be longer.
	SegmentLength int32

	// useInputSegmentation has been deprecated. The configured segment size is always
	// used.
	SegmentationMode HlsSegmentationMode

	// Number of segments to write to a subdirectory before starting a new one.
	// directoryStructure must be subdirectoryPerStream for this setting to have an
	// effect.
	SegmentsPerSubdirectory int32

	// Include or exclude RESOLUTION attribute for video in EXT-X-STREAM-INF tag of
	// variant manifest.
	StreamInfResolution HlsStreamInfResolution

	// Indicates ID3 frame that has the timecode.
	TimedMetadataId3Frame HlsTimedMetadataId3Frame

	// Timed Metadata interval in seconds.
	TimedMetadataId3Period int32

	// Provides an extra millisecond delta offset to fine tune the timestamps.
	TimestampDeltaMilliseconds int32

	// SEGMENTED_FILES: Emit the program as segments - multiple .ts media files.
	// SINGLE_FILE: Applies only if Mode field is VOD. Emit the program as a single .ts
	// media file. The media manifest includes #EXT-X-BYTERANGE tags to index segments
	// for playback. A typical use for this value is when sending the output to AWS
	// Elemental MediaConvert, which can accept only a single media file. Playback
	// while the channel is running is not guaranteed due to HTTP server caching.
	TsFileMode HlsTsFileMode

	noSmithyDocumentSerde
}

// Settings for the action to insert a user-defined ID3 tag in each HLS segment
type HlsId3SegmentTaggingScheduleActionSettings struct {

	// ID3 tag to insert into each segment. Supports special keyword identifiers to
	// substitute in segment-related values.\nSupported keyword identifiers:
	// https://docs.aws.amazon.com/medialive/latest/ug/variable-data-identifiers.html
	//
	// This member is required.
	Tag *string

	noSmithyDocumentSerde
}

// Hls Input Settings
type HlsInputSettings struct {

	// When specified the HLS stream with the m3u8 BANDWIDTH that most closely matches
	// this value will be chosen, otherwise the highest bandwidth stream in the m3u8
	// will be chosen. The bitrate is specified in bits per second, as in an HLS
	// manifest.
	Bandwidth int32

	// When specified, reading of the HLS input will begin this many buffer segments
	// from the end (most recently written segment). When not specified, the HLS input
	// will begin with the first segment specified in the m3u8.
	BufferSegments int32

	// The number of consecutive times that attempts to read a manifest or segment must
	// fail before the input is considered unavailable.
	Retries int32

	// The number of seconds between retries when an attempt to read a manifest or
	// segment fails.
	RetryInterval int32

	// Identifies the source for the SCTE-35 messages that MediaLive will ingest.
	// Messages can be ingested from the content segments (in the stream) or from tags
	// in the playlist (the HLS manifest). MediaLive ignores SCTE-35 information in the
	// source that is not selected.
	Scte35Source HlsScte35SourceType

	noSmithyDocumentSerde
}

// Hls Media Store Settings
type HlsMediaStoreSettings struct {

	// Number of seconds to wait before retrying connection to the CDN if the
	// connection is lost.
	ConnectionRetryInterval int32

	// Size in seconds of file cache for streaming outputs.
	FilecacheDuration int32

	// When set to temporal, output files are stored in non-persistent memory for
	// faster reading and writing.
	MediaStoreStorageClass HlsMediaStoreStorageClass

	// Number of retry attempts that will be made before the Live Event is put into an
	// error state.
	NumRetries int32

	// If a streaming output fails, number of seconds to wait until a restart is
	// initiated. A value of 0 means never restart.
	RestartDelay int32

	noSmithyDocumentSerde
}

// Hls Output Settings
type HlsOutputSettings struct {

	// Settings regarding the underlying stream. These settings are different for
	// audio-only outputs.
	//
	// This member is required.
	HlsSettings *HlsSettings

	// Only applicable when this output is referencing an H.265 video description.
	// Specifies whether MP4 segments should be packaged as HEV1 or HVC1.
	H265PackagingType HlsH265PackagingType

	// String concatenated to the end of the destination filename. Accepts "Format
	// Identifiers":#formatIdentifierParameters.
	NameModifier *string

	// String concatenated to end of segment filenames.
	SegmentModifier *string

	noSmithyDocumentSerde
}

// Hls S3 Settings
type HlsS3Settings struct {

	// Specify the canned ACL to apply to each S3 request. Defaults to none.
	CannedAcl S3CannedAcl

	noSmithyDocumentSerde
}

// Hls Settings
type HlsSettings struct {

	// Audio Only Hls Settings
	AudioOnlyHlsSettings *AudioOnlyHlsSettings

	// Fmp4 Hls Settings
	Fmp4HlsSettings *Fmp4HlsSettings

	// Frame Capture Hls Settings
	FrameCaptureHlsSettings *FrameCaptureHlsSettings

	// Standard Hls Settings
	StandardHlsSettings *StandardHlsSettings

	noSmithyDocumentSerde
}

// Settings for the action to emit HLS metadata
type HlsTimedMetadataScheduleActionSettings struct {

	// Base64 string formatted according to the ID3 specification:
	// http://id3.org/id3v2.4.0-structure
	//
	// This member is required.
	Id3 *string

	noSmithyDocumentSerde
}

// Hls Webdav Settings
type HlsWebdavSettings struct {

	// Number of seconds to wait before retrying connection to the CDN if the
	// connection is lost.
	ConnectionRetryInterval int32

	// Size in seconds of file cache for streaming outputs.
	FilecacheDuration int32

	// Specify whether or not to use chunked transfer encoding to WebDAV.
	HttpTransferMode HlsWebdavHttpTransferMode

	// Number of retry attempts that will be made before the Live Event is put into an
	// error state.
	NumRetries int32

	// If a streaming output fails, number of seconds to wait until a restart is
	// initiated. A value of 0 means never restart.
	RestartDelay int32

	noSmithyDocumentSerde
}

// Html Motion Graphics Settings
type HtmlMotionGraphicsSettings struct {
	noSmithyDocumentSerde
}

// Settings to configure an action so that it occurs as soon as possible.
type ImmediateModeScheduleActionStartSettings struct {
	noSmithyDocumentSerde
}

// Placeholder documentation for Input
type Input struct {

	// The Unique ARN of the input (generated, immutable).
	Arn *string

	// A list of channel IDs that that input is attached to (currently an input can
	// only be attached to one channel).
	AttachedChannels []string

	// A list of the destinations of the input (PUSH-type).
	Destinations []InputDestination

	// The generated ID of the input (unique for user account, immutable).
	Id *string

	// STANDARD - MediaLive expects two sources to be connected to this input. If the
	// channel is also STANDARD, both sources will be ingested. If the channel is
	// SINGLE_PIPELINE, only the first source will be ingested; the second source will
	// always be ignored, even if the first source fails. SINGLE_PIPELINE - You can
	// connect only one source to this input. If the ChannelClass is also
	// SINGLE_PIPELINE, this value is valid. If the ChannelClass is STANDARD, this
	// value is not valid because the channel requires two sources in the input.
	InputClass InputClass

	// Settings for the input devices.
	InputDevices []InputDeviceSettings

	// A list of IDs for all Inputs which are partners of this one.
	InputPartnerIds []string

	// Certain pull input sources can be dynamic, meaning that they can have their
	// URL's dynamically changes during input switch actions. Presently, this
	// functionality only works with MP4_FILE and TS_FILE inputs.
	InputSourceType InputSourceType

	// A list of MediaConnect Flows for this input.
	MediaConnectFlows []MediaConnectFlow

	// The user-assigned name (This is a mutable value).
	Name *string

	// The Amazon Resource Name (ARN) of the role this input assumes during and after
	// creation.
	RoleArn *string

	// A list of IDs for all the Input Security Groups attached to the input.
	SecurityGroups []string

	// A list of the sources of the input (PULL-type).
	Sources []InputSource

	// Placeholder documentation for InputState
	State InputState

	// A collection of key-value pairs.
	Tags map[string]string

	// The different types of inputs that AWS Elemental MediaLive supports.
	Type InputType

	noSmithyDocumentSerde
}

// Placeholder documentation for InputAttachment
type InputAttachment struct {

	// User-specified settings for defining what the conditions are for declaring the
	// input unhealthy and failing over to a different input.
	AutomaticInputFailoverSettings *AutomaticInputFailoverSettings

	// User-specified name for the attachment. This is required if the user wants to
	// use this input in an input switch action.
	InputAttachmentName *string

	// The ID of the input
	InputId *string

	// Settings of an input (caption selector, etc.)
	InputSettings *InputSettings

	noSmithyDocumentSerde
}

// Input Channel Level
type InputChannelLevel struct {

	// Remixing value. Units are in dB and acceptable values are within the range from
	// -60 (mute) and 6 dB.
	//
	// This member is required.
	Gain int32

	// The index of the input channel used as a source.
	//
	// This member is required.
	InputChannel int32

	noSmithyDocumentSerde
}

// Settings to let you create a clip of the file input, in order to set up the
// input to ingest only a portion of the file.
type InputClippingSettings struct {

	// The source of the timecodes in the source being clipped.
	//
	// This member is required.
	InputTimecodeSource InputTimecodeSource

	// Settings to identify the start of the clip.
	StartTimecode *StartTimecode

	// Settings to identify the end of the clip.
	StopTimecode *StopTimecode

	noSmithyDocumentSerde
}

// The settings for a PUSH type input.
type InputDestination struct {

	// The system-generated static IP address of endpoint. It remains fixed for the
	// lifetime of the input.
	Ip *string

	// The port number for the input.
	Port *string

	// This represents the endpoint that the customer stream will be pushed to.
	Url *string

	// The properties for a VPC type input destination.
	Vpc *InputDestinationVpc

	noSmithyDocumentSerde
}

// Endpoint settings for a PUSH type input.
type InputDestinationRequest struct {

	// A unique name for the location the RTMP stream is being pushed to.
	StreamName *string

	noSmithyDocumentSerde
}

// The properties for a VPC type input destination.
type InputDestinationVpc struct {

	// The availability zone of the Input destination.
	AvailabilityZone *string

	// The network interface ID of the Input destination in the VPC.
	NetworkInterfaceId *string

	noSmithyDocumentSerde
}

// Configurable settings for the input device.
type InputDeviceConfigurableSettings struct {

	// The input source that you want to use. If the device has a source connected to
	// only one of its input ports, or if you don't care which source the device sends,
	// specify Auto. If the device has sources connected to both its input ports, and
	// you want to use a specific source, specify the source.
	ConfiguredInput InputDeviceConfiguredInput

	// The Link device's buffer size (latency) in milliseconds (ms).
	LatencyMs int32

	// The maximum bitrate in bits per second. Set a value here to throttle the bitrate
	// of the source video.
	MaxBitrate int32

	noSmithyDocumentSerde
}

// Settings that describe the active source from the input device, and the video
// characteristics of that source.
type InputDeviceHdSettings struct {

	// If you specified Auto as the configured input, specifies which of the sources is
	// currently active (SDI or HDMI).
	ActiveInput InputDeviceActiveInput

	// The source at the input device that is currently active. You can specify this
	// source.
	ConfiguredInput InputDeviceConfiguredInput

	// The state of the input device.
	DeviceState InputDeviceState

	// The frame rate of the video source.
	Framerate float64

	// The height of the video source, in pixels.
	Height int32

	// The Link device's buffer size (latency) in milliseconds (ms). You can specify
	// this value.
	LatencyMs int32

	// The current maximum bitrate for ingesting this source, in bits per second. You
	// can specify this maximum.
	MaxBitrate int32

	// The scan type of the video source.
	ScanType InputDeviceScanType

	// The width of the video source, in pixels.
	Width int32

	noSmithyDocumentSerde
}

// The network settings for the input device.
type InputDeviceNetworkSettings struct {

	// The DNS addresses of the input device.
	DnsAddresses []string

	// The network gateway IP address.
	Gateway *string

	// The IP address of the input device.
	IpAddress *string

	// Specifies whether the input device has been configured (outside of MediaLive) to
	// use a dynamic IP address assignment (DHCP) or a static IP address.
	IpScheme InputDeviceIpScheme

	// The subnet mask of the input device.
	SubnetMask *string

	noSmithyDocumentSerde
}

// Settings for an input device.
type InputDeviceRequest struct {

	// The unique ID for the device.
	Id *string

	noSmithyDocumentSerde
}

// Settings for an input device.
type InputDeviceSettings struct {

	// The unique ID for the device.
	Id *string

	noSmithyDocumentSerde
}

// Details of the input device.
type InputDeviceSummary struct {

	// The unique ARN of the input device.
	Arn *string

	// The state of the connection between the input device and AWS.
	ConnectionState InputDeviceConnectionState

	// The status of the action to synchronize the device configuration. If you change
	// the configuration of the input device (for example, the maximum bitrate),
	// MediaLive sends the new data to the device. The device might not update itself
	// immediately. SYNCED means the device has updated its configuration. SYNCING
	// means that it has not updated its configuration.
	DeviceSettingsSyncState DeviceSettingsSyncState

	// The status of software on the input device.
	DeviceUpdateStatus DeviceUpdateStatus

	// Settings that describe an input device that is type HD.
	HdDeviceSettings *InputDeviceHdSettings

	// The unique ID of the input device.
	Id *string

	// The network MAC address of the input device.
	MacAddress *string

	// A name that you specify for the input device.
	Name *string

	// Network settings for the input device.
	NetworkSettings *InputDeviceNetworkSettings

	// The unique serial number of the input device.
	SerialNumber *string

	// The type of the input device.
	Type InputDeviceType

	// Settings that describe an input device that is type UHD.
	UhdDeviceSettings *InputDeviceUhdSettings

	noSmithyDocumentSerde
}

// Settings that describe the active source from the input device, and the video
// characteristics of that source.
type InputDeviceUhdSettings struct {

	// If you specified Auto as the configured input, specifies which of the sources is
	// currently active (SDI or HDMI).
	ActiveInput InputDeviceActiveInput

	// The source at the input device that is currently active. You can specify this
	// source.
	ConfiguredInput InputDeviceConfiguredInput

	// The state of the input device.
	DeviceState InputDeviceState

	// The frame rate of the video source.
	Framerate float64

	// The height of the video source, in pixels.
	Height int32

	// The Link device's buffer size (latency) in milliseconds (ms). You can specify
	// this value.
	LatencyMs int32

	// The current maximum bitrate for ingesting this source, in bits per second. You
	// can specify this maximum.
	MaxBitrate int32

	// The scan type of the video source.
	ScanType InputDeviceScanType

	// The width of the video source, in pixels.
	Width int32

	noSmithyDocumentSerde
}

// Input Location
type InputLocation struct {

	// Uniform Resource Identifier - This should be a path to a file accessible to the
	// Live system (eg. a http:// URI) depending on the output type. For example, a
	// RTMP destination should have a uri simliar to: "rtmp://fmsserver/live".
	//
	// This member is required.
	Uri *string

	// key used to extract the password from EC2 Parameter store
	PasswordParam *string

	// Documentation update needed
	Username *string

	noSmithyDocumentSerde
}

// Input Loss Behavior
type InputLossBehavior struct {

	// Documentation update needed
	BlackFrameMsec int32

	// When input loss image type is "color" this field specifies the color to use.
	// Value: 6 hex characters representing the values of RGB.
	InputLossImageColor *string

	// When input loss image type is "slate" these fields specify the parameters for
	// accessing the slate.
	InputLossImageSlate *InputLocation

	// Indicates whether to substitute a solid color or a slate into the output after
	// input loss exceeds blackFrameMsec.
	InputLossImageType InputLossImageType

	// Documentation update needed
	RepeatFrameMsec int32

	noSmithyDocumentSerde
}

// MediaLive will perform a failover if content is not detected in this input for
// the specified period.
type InputLossFailoverSettings struct {

	// The amount of time (in milliseconds) that no input is detected. After that time,
	// an input failover will occur.
	InputLossThresholdMsec int32

	noSmithyDocumentSerde
}

// Action to prepare an input for a future immediate input switch.
type InputPrepareScheduleActionSettings struct {

	// The name of the input attachment that should be prepared by this action. If no
	// name is provided, the action will stop the most recent prepare (if any) when
	// activated.
	InputAttachmentNameReference *string

	// Settings to let you create a clip of the file input, in order to set up the
	// input to ingest only a portion of the file.
	InputClippingSettings *InputClippingSettings

	// The value for the variable portion of the URL for the dynamic input, for this
	// instance of the input. Each time you use the same dynamic input in an input
	// switch action, you can provide a different value, in order to connect the input
	// to a different content source.
	UrlPath []string

	noSmithyDocumentSerde
}

// An Input Security Group
type InputSecurityGroup struct {

	// Unique ARN of Input Security Group
	Arn *string

	// The Id of the Input Security Group
	Id *string

	// The list of inputs currently using this Input Security Group.
	Inputs []string

	// The current state of the Input Security Group.
	State InputSecurityGroupState

	// A collection of key-value pairs.
	Tags map[string]string

	// Whitelist rules and their sync status
	WhitelistRules []InputWhitelistRule

	noSmithyDocumentSerde
}

// Live Event input parameters. There can be multiple inputs in a single Live
// Event.
type InputSettings struct {

	// Used to select the audio stream to decode for inputs that have multiple
	// available.
	AudioSelectors []AudioSelector

	// Used to select the caption input to use for inputs that have multiple available.
	CaptionSelectors []CaptionSelector

	// Enable or disable the deblock filter when filtering.
	DeblockFilter InputDeblockFilter

	// Enable or disable the denoise filter when filtering.
	DenoiseFilter InputDenoiseFilter

	// Adjusts the magnitude of filtering from 1 (minimal) to 5 (strongest).
	FilterStrength int32

	// Turns on the filter for this input. MPEG-2 inputs have the deblocking filter
	// enabled by default.
	//
	// * auto - filtering will be applied depending on input
	// type/quality
	//
	// * disabled - no filtering will be applied to the input
	//
	// * forced -
	// filtering will be applied regardless of input type
	InputFilter InputFilter

	// Input settings.
	NetworkInputSettings *NetworkInputSettings

	// PID from which to read SCTE-35 messages. If left undefined, EML will select the
	// first SCTE-35 PID found in the input.
	Scte35Pid int32

	// Specifies whether to extract applicable ancillary data from a SMPTE-2038 source
	// in this input. Applicable data types are captions, timecode, AFD, and SCTE-104
	// messages.
	//
	// * PREFER: Extract from SMPTE-2038 if present in this input, otherwise
	// extract from another source (if any).
	//
	// * IGNORE: Never extract any ancillary
	// data from SMPTE-2038.
	Smpte2038DataPreference Smpte2038DataPreference

	// Loop input if it is a file. This allows a file input to be streamed
	// indefinitely.
	SourceEndBehavior InputSourceEndBehavior

	// Informs which video elementary stream to decode for input types that have
	// multiple available.
	VideoSelector *VideoSelector

	noSmithyDocumentSerde
}

// The settings for a PULL type input.
type InputSource struct {

	// The key used to extract the password from EC2 Parameter store.
	PasswordParam *string

	// This represents the customer's source URL where stream is pulled from.
	Url *string

	// The username for the input source.
	Username *string

	noSmithyDocumentSerde
}

// Settings for for a PULL type input.
type InputSourceRequest struct {

	// The key used to extract the password from EC2 Parameter store.
	PasswordParam *string

	// This represents the customer's source URL where stream is pulled from.
	Url *string

	// The username for the input source.
	Username *string

	noSmithyDocumentSerde
}

// Placeholder documentation for InputSpecification
type InputSpecification struct {

	// Input codec
	Codec InputCodec

	// Maximum input bitrate, categorized coarsely
	MaximumBitrate InputMaximumBitrate

	// Input resolution, categorized coarsely
	Resolution InputResolution

	noSmithyDocumentSerde
}

// Settings for the "switch input" action: to switch from ingesting one input to
// ingesting another input.
type InputSwitchScheduleActionSettings struct {

	// The name of the input attachment (not the name of the input!) to switch to. The
	// name is specified in the channel configuration.
	//
	// This member is required.
	InputAttachmentNameReference *string

	// Settings to let you create a clip of the file input, in order to set up the
	// input to ingest only a portion of the file.
	InputClippingSettings *InputClippingSettings

	// The value for the variable portion of the URL for the dynamic input, for this
	// instance of the input. Each time you use the same dynamic input in an input
	// switch action, you can provide a different value, in order to connect the input
	// to a different content source.
	UrlPath []string

	noSmithyDocumentSerde
}

// Settings for a private VPC Input. When this property is specified, the input
// destination addresses will be created in a VPC rather than with public Internet
// addresses. This property requires setting the roleArn property on Input
// creation. Not compatible with the inputSecurityGroups property.
type InputVpcRequest struct {

	// A list of 2 VPC subnet IDs from the same VPC. Subnet IDs must be mapped to two
	// unique availability zones (AZ).
	//
	// This member is required.
	SubnetIds []string

	// A list of up to 5 EC2 VPC security group IDs to attach to the Input VPC network
	// interfaces. Requires subnetIds. If none are specified then the VPC default
	// security group will be used.
	SecurityGroupIds []string

	noSmithyDocumentSerde
}

// Whitelist rule
type InputWhitelistRule struct {

	// The IPv4 CIDR that's whitelisted.
	Cidr *string

	noSmithyDocumentSerde
}

// An IPv4 CIDR to whitelist.
type InputWhitelistRuleCidr struct {

	// The IPv4 CIDR to whitelist.
	Cidr *string

	noSmithyDocumentSerde
}

// Key Provider Settings
type KeyProviderSettings struct {

	// Static Key Settings
	StaticKeySettings *StaticKeySettings

	noSmithyDocumentSerde
}

// M2ts Settings
type M2tsSettings struct {

	// When set to drop, output audio streams will be removed from the program if the
	// selected input audio stream is removed from the input. This allows the output
	// audio configuration to dynamically change based on input configuration. If this
	// is set to encodeSilence, all output audio streams will output encoded silence
	// when not connected to an active input stream.
	AbsentInputAudioBehavior M2tsAbsentInputAudioBehavior

	// When set to enabled, uses ARIB-compliant field muxing and removes video
	// descriptor.
	Arib M2tsArib

	// Packet Identifier (PID) for ARIB Captions in the transport stream. Can be
	// entered as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182
	// (or 0x1ff6).
	AribCaptionsPid *string

	// If set to auto, pid number used for ARIB Captions will be auto-selected from
	// unused pids. If set to useConfigured, ARIB Captions will be on the configured
	// pid number.
	AribCaptionsPidControl M2tsAribCaptionsPidControl

	// When set to dvb, uses DVB buffer model for Dolby Digital audio. When set to
	// atsc, the ATSC model is used.
	AudioBufferModel M2tsAudioBufferModel

	// The number of audio frames to insert for each PES packet.
	AudioFramesPerPes int32

	// Packet Identifier (PID) of the elementary audio stream(s) in the transport
	// stream. Multiple values are accepted, and can be entered in ranges and/or by
	// comma separation. Can be entered as decimal or hexadecimal values. Each PID
	// specified must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
	AudioPids *string

	// When set to atsc, uses stream type = 0x81 for AC3 and stream type = 0x87 for
	// EAC3. When set to dvb, uses stream type = 0x06.
	AudioStreamType M2tsAudioStreamType

	// The output bitrate of the transport stream in bits per second. Setting to 0 lets
	// the muxer automatically determine the appropriate bitrate.
	Bitrate int32

	// Controls the timing accuracy for output network traffic. Leave as MULTIPLEX to
	// ensure accurate network packet timing. Or set to NONE, which might result in
	// lower latency but will result in more variability in output network packet
	// timing. This variability might cause interruptions, jitter, or bursty behavior
	// in your playback or receiving devices.
	BufferModel M2tsBufferModel

	// When set to enabled, generates captionServiceDescriptor in PMT.
	CcDescriptor M2tsCcDescriptor

	// Inserts DVB Network Information Table (NIT) at the specified table repetition
	// interval.
	DvbNitSettings *DvbNitSettings

	// Inserts DVB Service Description Table (SDT) at the specified table repetition
	// interval.
	DvbSdtSettings *DvbSdtSettings

	// Packet Identifier (PID) for input source DVB Subtitle data to this output.
	// Multiple values are accepted, and can be entered in ranges and/or by comma
	// separation. Can be entered as decimal or hexadecimal values. Each PID specified
	// must be in the range of 32 (or 0x20)..8182 (or 0x1ff6).
	DvbSubPids *string

	// Inserts DVB Time and Date Table (TDT) at the specified table repetition
	// interval.
	DvbTdtSettings *DvbTdtSettings

	// Packet Identifier (PID) for input source DVB Teletext data to this output. Can
	// be entered as a decimal or hexadecimal value. Valid values are 32 (or
	// 0x20)..8182 (or 0x1ff6).
	DvbTeletextPid *string

	// If set to passthrough, passes any EBIF data from the input source to this
	// output.
	Ebif M2tsEbifControl

	// When videoAndFixedIntervals is selected, audio EBP markers will be added to
	// partitions 3 and 4. The interval between these additional markers will be fixed,
	// and will be slightly shorter than the video EBP marker interval. Only available
	// when EBP Cablelabs segmentation markers are selected. Partitions 1 and 2 will
	// always follow the video interval.
	EbpAudioInterval M2tsAudioInterval

	// When set, enforces that Encoder Boundary Points do not come within the specified
	// time interval of each other by looking ahead at input video. If another EBP is
	// going to come in within the specified time interval, the current EBP is not
	// emitted, and the segment is "stretched" to the next marker. The lookahead value
	// does not add latency to the system. The Live Event must be configured elsewhere
	// to create sufficient latency to make the lookahead accurate.
	EbpLookaheadMs int32

	// Controls placement of EBP on Audio PIDs. If set to videoAndAudioPids, EBP
	// markers will be placed on the video PID and all audio PIDs. If set to videoPid,
	// EBP markers will be placed on only the video PID.
	EbpPlacement M2tsEbpPlacement

	// This field is unused and deprecated.
	EcmPid *string

	// Include or exclude the ES Rate field in the PES header.
	EsRateInPes M2tsEsRateInPes

	// Packet Identifier (PID) for input source ETV Platform data to this output. Can
	// be entered as a decimal or hexadecimal value. Valid values are 32 (or
	// 0x20)..8182 (or 0x1ff6).
	EtvPlatformPid *string

	// Packet Identifier (PID) for input source ETV Signal data to this output. Can be
	// entered as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182
	// (or 0x1ff6).
	EtvSignalPid *string

	// The length in seconds of each fragment. Only used with EBP markers.
	FragmentTime float64

	// If set to passthrough, passes any KLV data from the input source to this output.
	Klv M2tsKlv

	// Packet Identifier (PID) for input source KLV data to this output. Multiple
	// values are accepted, and can be entered in ranges and/or by comma separation.
	// Can be entered as decimal or hexadecimal values. Each PID specified must be in
	// the range of 32 (or 0x20)..8182 (or 0x1ff6).
	KlvDataPids *string

	// If set to passthrough, Nielsen inaudible tones for media tracking will be
	// detected in the input audio and an equivalent ID3 tag will be inserted in the
	// output.
	NielsenId3Behavior M2tsNielsenId3Behavior

	// Value in bits per second of extra null packets to insert into the transport
	// stream. This can be used if a downstream encryption system requires periodic
	// null packets.
	NullPacketBitrate float64

	// The number of milliseconds between instances of this table in the output
	// transport stream. Valid values are 0, 10..1000.
	PatInterval int32

	// When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for
	// every Packetized Elementary Stream (PES) header. This parameter is effective
	// only when the PCR PID is the same as the video or audio elementary stream.
	PcrControl M2tsPcrControl

	// Maximum time in milliseconds between Program Clock Reference (PCRs) inserted
	// into the transport stream.
	PcrPeriod int32

	// Packet Identifier (PID) of the Program Clock Reference (PCR) in the transport
	// stream. When no value is given, the encoder will assign the same value as the
	// Video PID. Can be entered as a decimal or hexadecimal value. Valid values are 32
	// (or 0x20)..8182 (or 0x1ff6).
	PcrPid *string

	// The number of milliseconds between instances of this table in the output
	// transport stream. Valid values are 0, 10..1000.
	PmtInterval int32

	// Packet Identifier (PID) for the Program Map Table (PMT) in the transport stream.
	// Can be entered as a decimal or hexadecimal value. Valid values are 32 (or
	// 0x20)..8182 (or 0x1ff6).
	PmtPid *string

	// The value of the program number field in the Program Map Table.
	ProgramNum int32

	// When vbr, does not insert null packets into transport stream to fill specified
	// bitrate. The bitrate setting acts as the maximum bitrate when vbr is set.
	RateMode M2tsRateMode

	// Packet Identifier (PID) for input source SCTE-27 data to this output. Multiple
	// values are accepted, and can be entered in ranges and/or by comma separation.
	// Can be entered as decimal or hexadecimal values. Each PID specified must be in
	// the range of 32 (or 0x20)..8182 (or 0x1ff6).
	Scte27Pids *string

	// Optionally pass SCTE-35 signals from the input source to this output.
	Scte35Control M2tsScte35Control

	// Packet Identifier (PID) of the SCTE-35 stream in the transport stream. Can be
	// entered as a decimal or hexadecimal value. Valid values are 32 (or 0x20)..8182
	// (or 0x1ff6).
	Scte35Pid *string

	// Inserts segmentation markers at each segmentationTime period. raiSegstart sets
	// the Random Access Indicator bit in the adaptation field. raiAdapt sets the RAI
	// bit and adds the current timecode in the private data bytes. psiSegstart inserts
	// PAT and PMT tables at the start of segments. ebp adds Encoder Boundary Point
	// information to the adaptation field as per OpenCable specification
	// OC-SP-EBP-I01-130118. ebpLegacy adds Encoder Boundary Point information to the
	// adaptation field using a legacy proprietary format.
	SegmentationMarkers M2tsSegmentationMarkers

	// The segmentation style parameter controls how segmentation markers are inserted
	// into the transport stream. With avails, it is possible that segments may be
	// truncated, which can influence where future segmentation markers are inserted.
	// When a segmentation style of "resetCadence" is selected and a segment is
	// truncated due to an avail, we will reset the segmentation cadence. This means
	// the subsequent segment will have a duration of $segmentationTime seconds. When a
	// segmentation style of "maintainCadence" is selected and a segment is truncated
	// due to an avail, we will not reset the segmentation cadence. This means the
	// subsequent segment will likely be truncated as well. However, all segments after
	// that will have a duration of $segmentationTime seconds. Note that EBP lookahead
	// is a slight exception to this rule.
	SegmentationStyle M2tsSegmentationStyle

	// The length in seconds of each segment. Required unless markers is set to none.
	SegmentationTime float64

	// When set to passthrough, timed metadata will be passed through from input to
	// output.
	TimedMetadataBehavior M2tsTimedMetadataBehavior

	// Packet Identifier (PID) of the timed metadata stream in the transport stream.
	// Can be entered as a decimal or hexadecimal value. Valid values are 32 (or
	// 0x20)..8182 (or 0x1ff6).
	TimedMetadataPid *string

	// The value of the transport stream ID field in the Program Map Table.
	TransportStreamId int32

	// Packet Identifier (PID) of the elementary video stream in the transport stream.
	// Can be entered as a decimal or hexadecimal value. Valid values are 32 (or
	// 0x20)..8182 (or 0x1ff6).
	VideoPid *string

	noSmithyDocumentSerde
}

// Settings information for the .m3u8 container
type M3u8Settings struct {

	// The number of audio frames to insert for each PES packet.
	AudioFramesPerPes int32

	// Packet Identifier (PID) of the elementary audio stream(s) in the transport
	// stream. Multiple values are accepted, and can be entered in ranges and/or by
	// comma separation. Can be entered as decimal or hexadecimal values.
	AudioPids *string

	// This parameter is unused and deprecated.
	EcmPid *string

	// If set to passthrough, Nielsen inaudible tones for media tracking will be
	// detected in the input audio and an equivalent ID3 tag will be inserted in the
	// output.
	NielsenId3Behavior M3u8NielsenId3Behavior

	// The number of milliseconds between instances of this table in the output
	// transport stream. A value of "0" writes out the PMT once per segment file.
	PatInterval int32

	// When set to pcrEveryPesPacket, a Program Clock Reference value is inserted for
	// every Packetized Elementary Stream (PES) header. This parameter is effective
	// only when the PCR PID is the same as the video or audio elementary stream.
	PcrControl M3u8PcrControl

	// Maximum time in milliseconds between Program Clock References (PCRs) inserted
	// into the transport stream.
	PcrPeriod int32

	// Packet Identifier (PID) of the Program Clock Reference (PCR) in the transport
	// stream. When no value is given, the encoder will assign the same value as the
	// Video PID. Can be entered as a decimal or hexadecimal value.
	PcrPid *string

	// The number of milliseconds between instances of this table in the output
	// transport stream. A value of "0" writes out the PMT once per segment file.
	PmtInterval int32

	// Packet Identifier (PID) for the Program Map Table (PMT) in the transport stream.
	// Can be entered as a decimal or hexadecimal value.
	PmtPid *string

	// The value of the program number field in the Program Map Table.
	ProgramNum int32

	// If set to passthrough, passes any SCTE-35 signals from the input source to this
	// output.
	Scte35Behavior M3u8Scte35Behavior

	// Packet Identifier (PID) of the SCTE-35 stream in the transport stream. Can be
	// entered as a decimal or hexadecimal value.
	Scte35Pid *string

	// When set to passthrough, timed metadata is passed through from input to output.
	TimedMetadataBehavior M3u8TimedMetadataBehavior

	// Packet Identifier (PID) of the timed metadata stream in the transport stream.
	// Can be entered as a decimal or hexadecimal value. Valid values are 32 (or
	// 0x20)..8182 (or 0x1ff6).
	TimedMetadataPid *string

	// The value of the transport stream ID field in the Program Map Table.
	TransportStreamId int32

	// Packet Identifier (PID) of the elementary video stream in the transport stream.
	// Can be entered as a decimal or hexadecimal value.
	VideoPid *string

	noSmithyDocumentSerde
}

// Placeholder documentation for MaintenanceCreateSettings
type MaintenanceCreateSettings struct {

	// Choose one day of the week for maintenance. The chosen day is used for all
	// future maintenance windows.
	MaintenanceDay MaintenanceDay

	// Choose the hour that maintenance will start. The chosen time is used for all
	// future maintenance windows.
	MaintenanceStartTime *string

	noSmithyDocumentSerde
}

// Placeholder documentation for MaintenanceStatus
type MaintenanceStatus struct {

	// The currently selected maintenance day.
	MaintenanceDay MaintenanceDay

	// Maintenance is required by the displayed date and time. Date and time is in ISO.
	MaintenanceDeadline *string

	// The currently scheduled maintenance date and time. Date and time is in ISO.
	MaintenanceScheduledDate *string

	// The currently selected maintenance start time. Time is in UTC.
	MaintenanceStartTime *string

	noSmithyDocumentSerde
}

// Placeholder documentation for MaintenanceUpdateSettings
type MaintenanceUpdateSettings struct {

	// Choose one day of the week for maintenance. The chosen day is used for all
	// future maintenance windows.
	MaintenanceDay MaintenanceDay

	// Choose a specific date for maintenance to occur. The chosen date is used for the
	// next maintenance window only.
	MaintenanceScheduledDate *string

	// Choose the hour that maintenance will start. The chosen time is used for all
	// future maintenance windows.
	MaintenanceStartTime *string

	noSmithyDocumentSerde
}

// The settings for a MediaConnect Flow.
type MediaConnectFlow struct {

	// The unique ARN of the MediaConnect Flow being used as a source.
	FlowArn *string

	noSmithyDocumentSerde
}

// The settings for a MediaConnect Flow.
type MediaConnectFlowRequest struct {

	// The ARN of the MediaConnect Flow that you want to use as a source.
	FlowArn *string

	noSmithyDocumentSerde
}

// Media Package Group Settings
type MediaPackageGroupSettings struct {

	// MediaPackage channel destination.
	//
	// This member is required.
	Destination *OutputLocationRef

	noSmithyDocumentSerde
}

// MediaPackage Output Destination Settings
type MediaPackageOutputDestinationSettings struct {

	// ID of the channel in MediaPackage that is the destination for this output group.
	// You do not need to specify the individual inputs in MediaPackage; MediaLive will
	// handle the connection of the two MediaLive pipelines to the two MediaPackage
	// inputs. The MediaPackage channel and MediaLive channel must be in the same
	// region.
	ChannelId *string

	noSmithyDocumentSerde
}

// Media Package Output Settings
type MediaPackageOutputSettings struct {
	noSmithyDocumentSerde
}

// Settings to specify the rendering of motion graphics into the video stream.
type MotionGraphicsActivateScheduleActionSettings struct {

	// Duration (in milliseconds) that motion graphics should render on to the video
	// stream. Leaving out this property or setting to 0 will result in rendering
	// continuing until a deactivate action is processed.
	Duration int64

	// Key used to extract the password from EC2 Parameter store
	PasswordParam *string

	// URI of the HTML5 content to be rendered into the live stream.
	Url *string

	// Documentation update needed
	Username *string

	noSmithyDocumentSerde
}

// Motion Graphics Configuration
type MotionGraphicsConfiguration struct {

	// Motion Graphics Settings
	//
	// This member is required.
	MotionGraphicsSettings *MotionGraphicsSettings

	// Motion Graphics Insertion
	MotionGraphicsInsertion MotionGraphicsInsertion

	noSmithyDocumentSerde
}

// Settings to specify the ending of rendering motion graphics into the video
// stream.
type MotionGraphicsDeactivateScheduleActionSettings struct {
	noSmithyDocumentSerde
}

// Motion Graphics Settings
type MotionGraphicsSettings struct {

	// Html Motion Graphics Settings
	HtmlMotionGraphicsSettings *HtmlMotionGraphicsSettings

	noSmithyDocumentSerde
}

// Mp2 Settings
type Mp2Settings struct {

	// Average bitrate in bits/second.
	Bitrate float64

	// The MPEG2 Audio coding mode. Valid values are codingMode10 (for mono) or
	// codingMode20 (for stereo).
	CodingMode Mp2CodingMode

	// Sample rate in Hz.
	SampleRate float64

	noSmithyDocumentSerde
}

// Mpeg2 Filter Settings
type Mpeg2FilterSettings struct {

	// Temporal Filter Settings
	TemporalFilterSettings *TemporalFilterSettings

	noSmithyDocumentSerde
}

// Mpeg2 Settings
type Mpeg2Settings struct {

	// description": "The framerate denominator. For example, 1001. The framerate is
	// the numerator divided by the denominator. For example, 24000 / 1001 = 23.976
	// FPS.
	//
	// This member is required.
	FramerateDenominator int32

	// The framerate numerator. For example, 24000. The framerate is the numerator
	// divided by the denominator. For example, 24000 / 1001 = 23.976 FPS.
	//
	// This member is required.
	FramerateNumerator int32

	// Choose Off to disable adaptive quantization. Or choose another value to enable
	// the quantizer and set its strength. The strengths are: Auto, Off, Low, Medium,
	// High. When you enable this field, MediaLive allows intra-frame quantizers to
	// vary, which might improve visual quality.
	AdaptiveQuantization Mpeg2AdaptiveQuantization

	// Indicates the AFD values that MediaLive will write into the video encode. If you
	// do not know what AFD signaling is, or if your downstream system has not given
	// you guidance, choose AUTO. AUTO: MediaLive will try to preserve the input AFD
	// value (in cases where multiple AFD values are valid). FIXED: MediaLive will use
	// the value you specify in fixedAFD.
	AfdSignaling AfdSignaling

	// Specifies whether to include the color space metadata. The metadata describes
	// the color space that applies to the video (the colorSpace field). We recommend
	// that you insert the metadata.
	ColorMetadata Mpeg2ColorMetadata

	// Choose the type of color space conversion to apply to the output. For detailed
	// information on setting up both the input and the output to obtain the desired
	// color space in the output, see the section on "MediaLive Features - Video -
	// color space" in the MediaLive User Guide. PASSTHROUGH: Keep the color space of
	// the input content - do not convert it. AUTO:Convert all content that is SD to
	// rec 601, and convert all content that is HD to rec 709.
	ColorSpace Mpeg2ColorSpace

	// Sets the pixel aspect ratio for the encode.
	DisplayAspectRatio Mpeg2DisplayRatio

	// Optionally specify a noise reduction filter, which can improve quality of
	// compressed content. If you do not choose a filter, no filter will be applied.
	// TEMPORAL: This filter is useful for both source content that is noisy (when it
	// has excessive digital artifacts) and source content that is clean. When the
	// content is noisy, the filter cleans up the source content before the encoding
	// phase, with these two effects: First, it improves the output video quality
	// because the content has been cleaned up. Secondly, it decreases the bandwidth
	// because MediaLive does not waste bits on encoding noise. When the content is
	// reasonably clean, the filter tends to decrease the bitrate.
	FilterSettings *Mpeg2FilterSettings

	// Complete this field only when afdSignaling is set to FIXED. Enter the AFD value
	// (4 bits) to write on all frames of the video encode.
	FixedAfd FixedAfd

	// MPEG2: default is open GOP.
	GopClosedCadence int32

	// Relates to the GOP structure. The number of B-frames between reference frames.
	// If you do not know what a B-frame is, use the default.
	GopNumBFrames int32

	// Relates to the GOP structure. The GOP size (keyframe interval) in the units
	// specified in gopSizeUnits. If you do not know what GOP is, use the default. If
	// gopSizeUnits is frames, then the gopSize must be an integer and must be greater
	// than or equal to 1. If gopSizeUnits is seconds, the gopSize must be greater than
	// 0, but does not need to be an integer.
	GopSize float64

	// Relates to the GOP structure. Specifies whether the gopSize is specified in
	// frames or seconds. If you do not plan to change the default gopSize, leave the
	// default. If you specify SECONDS, MediaLive will internally convert the gop size
	// to a frame count.
	GopSizeUnits Mpeg2GopSizeUnits

	// Set the scan type of the output to PROGRESSIVE or INTERLACED (top field first).
	ScanType Mpeg2ScanType

	// Relates to the GOP structure. If you do not know what GOP is, use the default.
	// FIXED: Set the number of B-frames in each sub-GOP to the value in gopNumBFrames.
	// DYNAMIC: Let MediaLive optimize the number of B-frames in each sub-GOP, to
	// improve visual quality.
	SubgopLength Mpeg2SubGopLength

	// Determines how MediaLive inserts timecodes in the output video. For detailed
	// information about setting up the input and the output for a timecode, see the
	// section on "MediaLive Features - Timecode configuration" in the MediaLive User
	// Guide. DISABLED: do not include timecodes. GOP_TIMECODE: Include timecode
	// metadata in the GOP header.
	TimecodeInsertion Mpeg2TimecodeInsertionBehavior

	noSmithyDocumentSerde
}

// Ms Smooth Group Settings
type MsSmoothGroupSettings struct {

	// Smooth Streaming publish point on an IIS server. Elemental Live acts as a "Push"
	// encoder to IIS.
	//
	// This member is required.
	Destination *OutputLocationRef

	// The ID to include in each message in the sparse track. Ignored if
	// sparseTrackType is NONE.
	AcquisitionPointId *string

	// If set to passthrough for an audio-only MS Smooth output, the fragment absolute
	// time will be set to the current timecode. This option does not write timecodes
	// to the audio elementary stream.
	AudioOnlyTimecodeControl SmoothGroupAudioOnlyTimecodeControl

	// If set to verifyAuthenticity, verify the https certificate chain to a trusted
	// Certificate Authority (CA). This will cause https outputs to self-signed
	// certificates to fail.
	CertificateMode SmoothGroupCertificateMode

	// Number of seconds to wait before retrying connection to the IIS server if the
	// connection is lost. Content will be cached during this time and the cache will
	// be be delivered to the IIS server once the connection is re-established.
	ConnectionRetryInterval int32

	// MS Smooth event ID to be sent to the IIS server. Should only be specified if
	// eventIdMode is set to useConfigured.
	EventId *string

	// Specifies whether or not to send an event ID to the IIS server. If no event ID
	// is sent and the same Live Event is used without changing the publishing point,
	// clients might see cached video from the previous run. Options:
	//
	// *
	// "useConfigured" - use the value provided in eventId
	//
	// * "useTimestamp" - generate
	// and send an event ID based on the current timestamp
	//
	// * "noEventId" - do not send
	// an event ID to the IIS server.
	EventIdMode SmoothGroupEventIdMode

	// When set to sendEos, send EOS signal to IIS server when stopping the event
	EventStopBehavior SmoothGroupEventStopBehavior

	// Size in seconds of file cache for streaming outputs.
	FilecacheDuration int32

	// Length of mp4 fragments to generate (in seconds). Fragment length must be
	// compatible with GOP size and framerate.
	FragmentLength int32

	// Parameter that control output group behavior on input loss.
	InputLossAction InputLossActionForMsSmoothOut

	// Number of retry attempts.
	NumRetries int32

	// Number of seconds before initiating a restart due to output failure, due to
	// exhausting the numRetries on one segment, or exceeding filecacheDuration.
	RestartDelay int32

	// useInputSegmentation has been deprecated. The configured segment size is always
	// used.
	SegmentationMode SmoothGroupSegmentationMode

	// Number of milliseconds to delay the output from the second pipeline.
	SendDelayMs int32

	// Identifies the type of data to place in the sparse track:
	//
	// * SCTE35: Insert
	// SCTE-35 messages from the source content. With each message, insert an IDR frame
	// to start a new segment.
	//
	// * SCTE35_WITHOUT_SEGMENTATION: Insert SCTE-35 messages
	// from the source content. With each message, insert an IDR frame but don't start
	// a new segment.
	//
	// * NONE: Don't generate a sparse track for any outputs in this
	// output group.
	SparseTrackType SmoothGroupSparseTrackType

	// When set to send, send stream manifest so publishing point doesn't start until
	// all streams start.
	StreamManifestBehavior SmoothGroupStreamManifestBehavior

	// Timestamp offset for the event. Only used if timestampOffsetMode is set to
	// useConfiguredOffset.
	TimestampOffset *string

	// Type of timestamp date offset to use.
	//
	// * useEventStartDate: Use the date the
	// event was started as the offset
	//
	// * useConfiguredOffset: Use an explicitly
	// configured date as the offset
	TimestampOffsetMode SmoothGroupTimestampOffsetMode

	noSmithyDocumentSerde
}

// Ms Smooth Output Settings
type MsSmoothOutputSettings struct {

	// Only applicable when this output is referencing an H.265 video description.
	// Specifies whether MP4 segments should be packaged as HEV1 or HVC1.
	H265PackagingType MsSmoothH265PackagingType

	// String concatenated to the end of the destination filename. Required for
	// multiple outputs of the same type.
	NameModifier *string

	noSmithyDocumentSerde
}

// The multiplex object.
type Multiplex struct {

	// The unique arn of the multiplex.
	Arn *string

	// A list of availability zones for the multiplex.
	AvailabilityZones []string

	// A list of the multiplex output destinations.
	Destinations []MultiplexOutputDestination

	// The unique id of the multiplex.
	Id *string

	// Configuration for a multiplex event.
	MultiplexSettings *MultiplexSettings

	// The name of the multiplex.
	Name *string

	// The number of currently healthy pipelines.
	PipelinesRunningCount int32

	// The number of programs in the multiplex.
	ProgramCount int32

	// The current state of the multiplex.
	State MultiplexState

	// A collection of key-value pairs.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Multiplex Group Settings
type MultiplexGroupSettings struct {
	noSmithyDocumentSerde
}

// Multiplex MediaConnect output destination settings.
type MultiplexMediaConnectOutputDestinationSettings struct {

	// The MediaConnect entitlement ARN available as a Flow source.
	EntitlementArn *string

	noSmithyDocumentSerde
}

// Multiplex output destination settings
type MultiplexOutputDestination struct {

	// Multiplex MediaConnect output destination settings.
	MediaConnectSettings *MultiplexMediaConnectOutputDestinationSettings

	noSmithyDocumentSerde
}

// Multiplex Output Settings
type MultiplexOutputSettings struct {

	// Destination is a Multiplex.
	//
	// This member is required.
	Destination *OutputLocationRef

	noSmithyDocumentSerde
}

// The multiplex program object.
type MultiplexProgram struct {

	// The MediaLive channel associated with the program.
	ChannelId *string

	// The settings for this multiplex program.
	MultiplexProgramSettings *MultiplexProgramSettings

	// The packet identifier map for this multiplex program.
	PacketIdentifiersMap *MultiplexProgramPacketIdentifiersMap

	// Contains information about the current sources for the specified program in the
	// specified multiplex. Keep in mind that each multiplex pipeline connects to both
	// pipelines in a given source channel (the channel identified by the program). But
	// only one of those channel pipelines is ever active at one time.
	PipelineDetails []MultiplexProgramPipelineDetail

	// The name of the multiplex program.
	ProgramName *string

	noSmithyDocumentSerde
}

// Multiplex Program Input Destination Settings for outputting a Channel to a
// Multiplex
type MultiplexProgramChannelDestinationSettings struct {

	// The ID of the Multiplex that the encoder is providing output to. You do not need
	// to specify the individual inputs to the Multiplex; MediaLive will handle the
	// connection of the two MediaLive pipelines to the two Multiplex instances. The
	// Multiplex must be in the same region as the Channel.
	MultiplexId *string

	// The program name of the Multiplex program that the encoder is providing output
	// to.
	ProgramName *string

	noSmithyDocumentSerde
}

// Packet identifiers map for a given Multiplex program.
type MultiplexProgramPacketIdentifiersMap struct {

	// Placeholder documentation for __listOf__integer
	AudioPids []int32

	// Placeholder documentation for __listOf__integer
	DvbSubPids []int32

	// Placeholder documentation for __integer
	DvbTeletextPid int32

	// Placeholder documentation for __integer
	EtvPlatformPid int32

	// Placeholder documentation for __integer
	EtvSignalPid int32

	// Placeholder documentation for __listOf__integer
	KlvDataPids []int32

	// Placeholder documentation for __integer
	PcrPid int32

	// Placeholder documentation for __integer
	PmtPid int32

	// Placeholder documentation for __integer
	PrivateMetadataPid int32

	// Placeholder documentation for __listOf__integer
	Scte27Pids []int32

	// Placeholder documentation for __integer
	Scte35Pid int32

	// Placeholder documentation for __integer
	TimedMetadataPid int32

	// Placeholder documentation for __integer
	VideoPid int32

	noSmithyDocumentSerde
}

// The current source for one of the pipelines in the multiplex.
type MultiplexProgramPipelineDetail struct {

	// Identifies the channel pipeline that is currently active for the pipeline
	// (identified by PipelineId) in the multiplex.
	ActiveChannelPipeline *string

	// Identifies a specific pipeline in the multiplex.
	PipelineId *string

	noSmithyDocumentSerde
}

// Transport stream service descriptor configuration for the Multiplex program.
type MultiplexProgramServiceDescriptor struct {

	// Name of the provider.
	//
	// This member is required.
	ProviderName *string

	// Name of the service.
	//
	// This member is required.
	ServiceName *string

	noSmithyDocumentSerde
}

// Multiplex Program settings configuration.
type MultiplexProgramSettings struct {

	// Unique program number.
	//
	// This member is required.
	ProgramNumber int32

	// Indicates which pipeline is preferred by the multiplex for program ingest.
	PreferredChannelPipeline PreferredChannelPipeline

	// Transport stream service descriptor configuration for the Multiplex program.
	ServiceDescriptor *MultiplexProgramServiceDescriptor

	// Program video settings configuration.
	VideoSettings *MultiplexVideoSettings

	noSmithyDocumentSerde
}

// Placeholder documentation for MultiplexProgramSummary
type MultiplexProgramSummary struct {

	// The MediaLive Channel associated with the program.
	ChannelId *string

	// The name of the multiplex program.
	ProgramName *string

	noSmithyDocumentSerde
}

// Contains configuration for a Multiplex event
type MultiplexSettings struct {

	// Transport stream bit rate.
	//
	// This member is required.
	TransportStreamBitrate int32

	// Transport stream ID.
	//
	// This member is required.
	TransportStreamId int32

	// Maximum video buffer delay in milliseconds.
	MaximumVideoBufferDelayMilliseconds int32

	// Transport stream reserved bit rate.
	TransportStreamReservedBitrate int32

	noSmithyDocumentSerde
}

// Contains summary configuration for a Multiplex event.
type MultiplexSettingsSummary struct {

	// Transport stream bit rate.
	TransportStreamBitrate int32

	noSmithyDocumentSerde
}

// Statmux rate control settings
type MultiplexStatmuxVideoSettings struct {

	// Maximum statmux bitrate.
	MaximumBitrate int32

	// Minimum statmux bitrate.
	MinimumBitrate int32

	// The purpose of the priority is to use a combination of the\nmultiplex rate
	// control algorithm and the QVBR capability of the\nencoder to prioritize the
	// video quality of some channels in a\nmultiplex over others. Channels that have a
	// higher priority will\nget higher video quality at the expense of the video
	// quality of\nother channels in the multiplex with lower priority.
	Priority int32

	noSmithyDocumentSerde
}

// Placeholder documentation for MultiplexSummary
type MultiplexSummary struct {

	// The unique arn of the multiplex.
	Arn *string

	// A list of availability zones for the multiplex.
	AvailabilityZones []string

	// The unique id of the multiplex.
	Id *string

	// Configuration for a multiplex event.
	MultiplexSettings *MultiplexSettingsSummary

	// The name of the multiplex.
	Name *string

	// The number of currently healthy pipelines.
	PipelinesRunningCount int32

	// The number of programs in the multiplex.
	ProgramCount int32

	// The current state of the multiplex.
	State MultiplexState

	// A collection of key-value pairs.
	Tags map[string]string

	noSmithyDocumentSerde
}

// The video configuration for each program in a multiplex.
type MultiplexVideoSettings struct {

	// The constant bitrate configuration for the video encode. When this field is
	// defined, StatmuxSettings must be undefined.
	ConstantBitrate int32

	// Statmux rate control settings. When this field is defined, ConstantBitrate must
	// be undefined.
	StatmuxSettings *MultiplexStatmuxVideoSettings

	noSmithyDocumentSerde
}

// Network source to transcode. Must be accessible to the Elemental Live node that
// is running the live event through a network connection.
type NetworkInputSettings struct {

	// Specifies HLS input settings when the uri is for a HLS manifest.
	HlsInputSettings *HlsInputSettings

	// Check HTTPS server certificates. When set to checkCryptographyOnly, cryptography
	// in the certificate will be checked, but not the server's name. Certain
	// subdomains (notably S3 buckets that use dots in the bucket name) do not strictly
	// match the corresponding certificate's wildcard pattern and would otherwise cause
	// the event to error. This setting is ignored for protocols that do not use https.
	ServerValidation NetworkInputServerValidation

	noSmithyDocumentSerde
}

// Nielsen CBET
type NielsenCBET struct {

	// Enter the CBET check digits to use in the watermark.
	//
	// This member is required.
	CbetCheckDigitString *string

	// Determines the method of CBET insertion mode when prior encoding is detected on
	// the same layer.
	//
	// This member is required.
	CbetStepaside NielsenWatermarksCbetStepaside

	// Enter the CBET Source ID (CSID) to use in the watermark
	//
	// This member is required.
	Csid *string

	noSmithyDocumentSerde
}

// Nielsen Configuration
type NielsenConfiguration struct {

	// Enter the Distributor ID assigned to your organization by Nielsen.
	DistributorId *string

	// Enables Nielsen PCM to ID3 tagging
	NielsenPcmToId3Tagging NielsenPcmToId3TaggingState

	noSmithyDocumentSerde
}

// Nielsen Naes Ii Nw
type NielsenNaesIiNw struct {

	// Enter the check digit string for the watermark
	//
	// This member is required.
	CheckDigitString *string

	// Enter the Nielsen Source ID (SID) to include in the watermark
	//
	// This member is required.
	Sid float64

	noSmithyDocumentSerde
}

// Nielsen Watermarks Settings
type NielsenWatermarksSettings struct {

	// Complete these fields only if you want to insert watermarks of type Nielsen CBET
	NielsenCbetSettings *NielsenCBET

	// Choose the distribution types that you want to assign to the watermarks:
	//
	// *
	// PROGRAM_CONTENT
	//
	// * FINAL_DISTRIBUTOR
	NielsenDistributionType NielsenWatermarksDistributionTypes

	// Complete these fields only if you want to insert watermarks of type Nielsen NAES
	// II (N2) and Nielsen NAES VI (NW).
	NielsenNaesIiNwSettings *NielsenNaesIiNw

	noSmithyDocumentSerde
}

// Reserved resources available for purchase
type Offering struct {

	// Unique offering ARN, e.g.
	// 'arn:aws:medialive:us-west-2:123456789012:offering:87654321'
	Arn *string

	// Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. 'USD'
	CurrencyCode *string

	// Lease duration, e.g. '12'
	Duration int32

	// Units for duration, e.g. 'MONTHS'
	DurationUnits OfferingDurationUnits

	// One-time charge for each reserved resource, e.g. '0.0' for a NO_UPFRONT offering
	FixedPrice float64

	// Offering description, e.g. 'HD AVC output at 10-20 Mbps, 30 fps, and standard VQ
	// in US West (Oregon)'
	OfferingDescription *string

	// Unique offering ID, e.g. '87654321'
	OfferingId *string

	// Offering type, e.g. 'NO_UPFRONT'
	OfferingType OfferingType

	// AWS region, e.g. 'us-west-2'
	Region *string

	// Resource configuration details
	ResourceSpecification *ReservationResourceSpecification

	// Recurring usage charge for each reserved resource, e.g. '157.0'
	UsagePrice float64

	noSmithyDocumentSerde
}

// Output settings. There can be multiple outputs within a group.
type Output struct {

	// Output type-specific settings.
	//
	// This member is required.
	OutputSettings *OutputSettings

	// The names of the AudioDescriptions used as audio sources for this output.
	AudioDescriptionNames []string

	// The names of the CaptionDescriptions used as caption sources for this output.
	CaptionDescriptionNames []string

	// The name used to identify an output.
	OutputName *string

	// The name of the VideoDescription used as the source for this output.
	VideoDescriptionName *string

	noSmithyDocumentSerde
}

// Placeholder documentation for OutputDestination
type OutputDestination struct {

	// User-specified id. This is used in an output group or an output.
	Id *string

	// Destination settings for a MediaPackage output; one destination for both
	// encoders.
	MediaPackageSettings []MediaPackageOutputDestinationSettings

	// Destination settings for a Multiplex output; one destination for both encoders.
	MultiplexSettings *MultiplexProgramChannelDestinationSettings

	// Destination settings for a standard output; one destination for each redundant
	// encoder.
	Settings []OutputDestinationSettings

	noSmithyDocumentSerde
}

// Placeholder documentation for OutputDestinationSettings
type OutputDestinationSettings struct {

	// key used to extract the password from EC2 Parameter store
	PasswordParam *string

	// Stream name for RTMP destinations (URLs of type rtmp://)
	StreamName *string

	// A URL specifying a destination
	Url *string

	// username for destination
	Username *string

	noSmithyDocumentSerde
}

// Output groups for this Live Event. Output groups contain information about where
// streams should be distributed.
type OutputGroup struct {

	// Settings associated with the output group.
	//
	// This member is required.
	OutputGroupSettings *OutputGroupSettings

	// Placeholder documentation for __listOfOutput
	//
	// This member is required.
	Outputs []Output

	// Custom output group name optionally defined by the user.
	Name *string

	noSmithyDocumentSerde
}

// Output Group Settings
type OutputGroupSettings struct {

	// Archive Group Settings
	ArchiveGroupSettings *ArchiveGroupSettings

	// Frame Capture Group Settings
	FrameCaptureGroupSettings *FrameCaptureGroupSettings

	// Hls Group Settings
	HlsGroupSettings *HlsGroupSettings

	// Media Package Group Settings
	MediaPackageGroupSettings *MediaPackageGroupSettings

	// Ms Smooth Group Settings
	MsSmoothGroupSettings *MsSmoothGroupSettings

	// Multiplex Group Settings
	MultiplexGroupSettings *MultiplexGroupSettings

	// Rtmp Group Settings
	RtmpGroupSettings *RtmpGroupSettings

	// Udp Group Settings
	UdpGroupSettings *UdpGroupSettings

	noSmithyDocumentSerde
}

// Reference to an OutputDestination ID defined in the channel
type OutputLocationRef struct {

	// Placeholder documentation for __string
	DestinationRefId *string

	noSmithyDocumentSerde
}

// Output Settings
type OutputSettings struct {

	// Archive Output Settings
	ArchiveOutputSettings *ArchiveOutputSettings

	// Frame Capture Output Settings
	FrameCaptureOutputSettings *FrameCaptureOutputSettings

	// Hls Output Settings
	HlsOutputSettings *HlsOutputSettings

	// Media Package Output Settings
	MediaPackageOutputSettings *MediaPackageOutputSettings

	// Ms Smooth Output Settings
	MsSmoothOutputSettings *MsSmoothOutputSettings

	// Multiplex Output Settings
	MultiplexOutputSettings *MultiplexOutputSettings

	// Rtmp Output Settings
	RtmpOutputSettings *RtmpOutputSettings

	// Udp Output Settings
	UdpOutputSettings *UdpOutputSettings

	noSmithyDocumentSerde
}

// Pass Through Settings
type PassThroughSettings struct {
	noSmithyDocumentSerde
}

// Settings for the action to set pause state of a channel.
type PauseStateScheduleActionSettings struct {

	// Placeholder documentation for __listOfPipelinePauseStateSettings
	Pipelines []PipelinePauseStateSettings

	noSmithyDocumentSerde
}

// Runtime details of a pipeline when a channel is running.
type PipelineDetail struct {

	// The name of the active input attachment currently being ingested by this
	// pipeline.
	ActiveInputAttachmentName *string

	// The name of the input switch schedule action that occurred most recently and
	// that resulted in the switch to the current input attachment for this pipeline.
	ActiveInputSwitchActionName *string

	// The name of the motion graphics activate action that occurred most recently and
	// that resulted in the current graphics URI for this pipeline.
	ActiveMotionGraphicsActionName *string

	// The current URI being used for HTML5 motion graphics for this pipeline.
	ActiveMotionGraphicsUri *string

	// Pipeline ID
	PipelineId *string

	noSmithyDocumentSerde
}

// Settings for pausing a pipeline.
type PipelinePauseStateSettings struct {

	// Pipeline ID to pause ("PIPELINE_0" or "PIPELINE_1").
	//
	// This member is required.
	PipelineId PipelineId

	noSmithyDocumentSerde
}

// Raw Settings
type RawSettings struct {
	noSmithyDocumentSerde
}

// Rec601 Settings
type Rec601Settings struct {
	noSmithyDocumentSerde
}

// Rec709 Settings
type Rec709Settings struct {
	noSmithyDocumentSerde
}

// Remix Settings
type RemixSettings struct {

	// Mapping of input channels to output channels, with appropriate gain adjustments.
	//
	// This member is required.
	ChannelMappings []AudioChannelMapping

	// Number of input channels to be used.
	ChannelsIn int32

	// Number of output channels to be produced. Valid values: 1, 2, 4, 6, 8
	ChannelsOut int32

	noSmithyDocumentSerde
}

// The Renewal settings for Reservations
type RenewalSettings struct {

	// Automatic renewal status for the reservation
	AutomaticRenewal ReservationAutomaticRenewal

	// Count for the reservation renewal
	RenewalCount int32

	noSmithyDocumentSerde
}

// Reserved resources available to use
type Reservation struct {

	// Unique reservation ARN, e.g.
	// 'arn:aws:medialive:us-west-2:123456789012:reservation:1234567'
	Arn *string

	// Number of reserved resources
	Count int32

	// Currency code for usagePrice and fixedPrice in ISO-4217 format, e.g. 'USD'
	CurrencyCode *string

	// Lease duration, e.g. '12'
	Duration int32

	// Units for duration, e.g. 'MONTHS'
	DurationUnits OfferingDurationUnits

	// Reservation UTC end date and time in ISO-8601 format, e.g. '2019-03-01T00:00:00'
	End *string

	// One-time charge for each reserved resource, e.g. '0.0' for a NO_UPFRONT offering
	FixedPrice float64

	// User specified reservation name
	Name *string

	// Offering description, e.g. 'HD AVC output at 10-20 Mbps, 30 fps, and standard VQ
	// in US West (Oregon)'
	OfferingDescription *string

	// Unique offering ID, e.g. '87654321'
	OfferingId *string

	// Offering type, e.g. 'NO_UPFRONT'
	OfferingType OfferingType

	// AWS region, e.g. 'us-west-2'
	Region *string

	// Renewal settings for the reservation
	RenewalSettings *RenewalSettings

	// Unique reservation ID, e.g. '1234567'
	ReservationId *string

	// Resource configuration details
	ResourceSpecification *ReservationResourceSpecification

	// Reservation UTC start date and time in ISO-8601 format, e.g.
	// '2018-03-01T00:00:00'
	Start *string

	// Current state of reservation, e.g. 'ACTIVE'
	State ReservationState

	// A collection of key-value pairs
	Tags map[string]string

	// Recurring usage charge for each reserved resource, e.g. '157.0'
	UsagePrice float64

	noSmithyDocumentSerde
}

// Resource configuration (codec, resolution, bitrate, ...)
type ReservationResourceSpecification struct {

	// Channel class, e.g. 'STANDARD'
	ChannelClass ChannelClass

	// Codec, e.g. 'AVC'
	Codec ReservationCodec

	// Maximum bitrate, e.g. 'MAX_20_MBPS'
	MaximumBitrate ReservationMaximumBitrate

	// Maximum framerate, e.g. 'MAX_30_FPS' (Outputs only)
	MaximumFramerate ReservationMaximumFramerate

	// Resolution, e.g. 'HD'
	Resolution ReservationResolution

	// Resource type, 'INPUT', 'OUTPUT', 'MULTIPLEX', or 'CHANNEL'
	ResourceType ReservationResourceType

	// Special feature, e.g. 'AUDIO_NORMALIZATION' (Channels only)
	SpecialFeature ReservationSpecialFeature

	// Video quality, e.g. 'STANDARD' (Outputs only)
	VideoQuality ReservationVideoQuality

	noSmithyDocumentSerde
}

// Rtmp Caption Info Destination Settings
type RtmpCaptionInfoDestinationSettings struct {
	noSmithyDocumentSerde
}

// Rtmp Group Settings
type RtmpGroupSettings struct {

	// Choose the ad marker type for this output group. MediaLive will create a message
	// based on the content of each SCTE-35 message, format it for that marker type,
	// and insert it in the datastream.
	AdMarkers []RtmpAdMarkers

	// Authentication scheme to use when connecting with CDN
	AuthenticationScheme AuthenticationScheme

	// Controls behavior when content cache fills up. If remote origin server stalls
	// the RTMP connection and does not accept content fast enough the 'Media Cache'
	// will fill up. When the cache reaches the duration specified by cacheLength the
	// cache will stop accepting new content. If set to disconnectImmediately, the RTMP
	// output will force a disconnect. Clear the media cache, and reconnect after
	// restartDelay seconds. If set to waitForServer, the RTMP output will wait up to 5
	// minutes to allow the origin server to begin accepting data again.
	CacheFullBehavior RtmpCacheFullBehavior

	// Cache length, in seconds, is used to calculate buffer size.
	CacheLength int32

	// Controls the types of data that passes to onCaptionInfo outputs. If set to 'all'
	// then 608 and 708 carried DTVCC data will be passed. If set to
	// 'field1AndField2608' then DTVCC data will be stripped out, but 608 data from
	// both fields will be passed. If set to 'field1608' then only the data carried in
	// 608 from field 1 video will be passed.
	CaptionData RtmpCaptionData

	// Controls the behavior of this RTMP group if input becomes unavailable.
	//
	// *
	// emitOutput: Emit a slate until input returns.
	//
	// * pauseOutput: Stop transmitting
	// data until input returns. This does not close the underlying RTMP connection.
	InputLossAction InputLossActionForRtmpOut

	// If a streaming output fails, number of seconds to wait until a restart is
	// initiated. A value of 0 means never restart.
	RestartDelay int32

	noSmithyDocumentSerde
}

// Rtmp Output Settings
type RtmpOutputSettings struct {

	// The RTMP endpoint excluding the stream name (eg. rtmp://host/appname). For
	// connection to Akamai, a username and password must be supplied. URI fields
	// accept format identifiers.
	//
	// This member is required.
	Destination *OutputLocationRef

	// If set to verifyAuthenticity, verify the tls certificate chain to a trusted
	// Certificate Authority (CA). This will cause rtmps outputs with self-signed
	// certificates to fail.
	CertificateMode RtmpOutputCertificateMode

	// Number of seconds to wait before retrying a connection to the Flash Media server
	// if the connection is lost.
	ConnectionRetryInterval int32

	// Number of retry attempts.
	NumRetries int32

	noSmithyDocumentSerde
}

// Contains information on a single schedule action.
type ScheduleAction struct {

	// The name of the action, must be unique within the schedule. This name provides
	// the main reference to an action once it is added to the schedule. A name is
	// unique if it is no longer in the schedule. The schedule is automatically cleaned
	// up to remove actions with a start time of more than 1 hour ago (approximately)
	// so at that point a name can be reused.
	//
	// This member is required.
	ActionName *string

	// Settings for this schedule action.
	//
	// This member is required.
	ScheduleActionSettings *ScheduleActionSettings

	// The time for the action to start in the channel.
	//
	// This member is required.
	ScheduleActionStartSettings *ScheduleActionStartSettings

	noSmithyDocumentSerde
}

// Holds the settings for a single schedule action.
type ScheduleActionSettings struct {

	// Action to insert HLS ID3 segment tagging
	HlsId3SegmentTaggingSettings *HlsId3SegmentTaggingScheduleActionSettings

	// Action to insert HLS metadata
	HlsTimedMetadataSettings *HlsTimedMetadataScheduleActionSettings

	// Action to prepare an input for a future immediate input switch
	InputPrepareSettings *InputPrepareScheduleActionSettings

	// Action to switch the input
	InputSwitchSettings *InputSwitchScheduleActionSettings

	// Action to activate a motion graphics image overlay
	MotionGraphicsImageActivateSettings *MotionGraphicsActivateScheduleActionSettings

	// Action to deactivate a motion graphics image overlay
	MotionGraphicsImageDeactivateSettings *MotionGraphicsDeactivateScheduleActionSettings

	// Action to pause or unpause one or both channel pipelines
	PauseStateSettings *PauseStateScheduleActionSettings

	// Action to specify scte35 input
	Scte35InputSettings *Scte35InputScheduleActionSettings

	// Action to insert SCTE-35 return_to_network message
	Scte35ReturnToNetworkSettings *Scte35ReturnToNetworkScheduleActionSettings

	// Action to insert SCTE-35 splice_insert message
	Scte35SpliceInsertSettings *Scte35SpliceInsertScheduleActionSettings

	// Action to insert SCTE-35 time_signal message
	Scte35TimeSignalSettings *Scte35TimeSignalScheduleActionSettings

	// Action to activate a static image overlay
	StaticImageActivateSettings *StaticImageActivateScheduleActionSettings

	// Action to deactivate a static image overlay
	StaticImageDeactivateSettings *StaticImageDeactivateScheduleActionSettings

	noSmithyDocumentSerde
}

// Settings to specify when an action should occur. Only one of the options must be
// selected.
type ScheduleActionStartSettings struct {

	// Option for specifying the start time for an action.
	FixedModeScheduleActionStartSettings *FixedModeScheduleActionStartSettings

	// Option for specifying an action as relative to another action.
	FollowModeScheduleActionStartSettings *FollowModeScheduleActionStartSettings

	// Option for specifying an action that should be applied immediately.
	ImmediateModeScheduleActionStartSettings *ImmediateModeScheduleActionStartSettings

	noSmithyDocumentSerde
}

// Scte20 Plus Embedded Destination Settings
type Scte20PlusEmbeddedDestinationSettings struct {
	noSmithyDocumentSerde
}

// Scte20 Source Settings
type Scte20SourceSettings struct {

	// If upconvert, 608 data is both passed through via the "608 compatibility bytes"
	// fields of the 708 wrapper as well as translated into 708. 708 data present in
	// the source content will be discarded.
	Convert608To708 Scte20Convert608To708

	// Specifies the 608/708 channel number within the video track from which to
	// extract captions. Unused for passthrough.
	Source608ChannelNumber int32

	noSmithyDocumentSerde
}

// Scte27 Destination Settings
type Scte27DestinationSettings struct {
	noSmithyDocumentSerde
}

// Scte27 Source Settings
type Scte27SourceSettings struct {

	// If you will configure a WebVTT caption description that references this caption
	// selector, use this field to provide the language to consider when translating
	// the image-based source to text.
	OcrLanguage Scte27OcrLanguage

	// The pid field is used in conjunction with the caption selector languageCode
	// field as follows:
	//
	// * Specify PID and Language: Extracts captions from that PID;
	// the language is "informational".
	//
	// * Specify PID and omit Language: Extracts the
	// specified PID.
	//
	// * Omit PID and specify Language: Extracts the specified
	// language, whichever PID that happens to be.
	//
	// * Omit PID and omit Language: Valid
	// only if source is DVB-Sub that is being passed through; all languages will be
	// passed through.
	Pid int32

	noSmithyDocumentSerde
}

// Corresponds to SCTE-35 delivery_not_restricted_flag parameter. To declare
// delivery restrictions, include this element and its four "restriction" flags. To
// declare that there are no restrictions, omit this element.
type Scte35DeliveryRestrictions struct {

	// Corresponds to SCTE-35 archive_allowed_flag.
	//
	// This member is required.
	ArchiveAllowedFlag Scte35ArchiveAllowedFlag

	// Corresponds to SCTE-35 device_restrictions parameter.
	//
	// This member is required.
	DeviceRestrictions Scte35DeviceRestrictions

	// Corresponds to SCTE-35 no_regional_blackout_flag parameter.
	//
	// This member is required.
	NoRegionalBlackoutFlag Scte35NoRegionalBlackoutFlag

	// Corresponds to SCTE-35 web_delivery_allowed_flag parameter.
	//
	// This member is required.
	WebDeliveryAllowedFlag Scte35WebDeliveryAllowedFlag

	noSmithyDocumentSerde
}

// Holds one set of SCTE-35 Descriptor Settings.
type Scte35Descriptor struct {

	// SCTE-35 Descriptor Settings.
	//
	// This member is required.
	Scte35DescriptorSettings *Scte35DescriptorSettings

	noSmithyDocumentSerde
}

// SCTE-35 Descriptor settings.
type Scte35DescriptorSettings struct {

	// SCTE-35 Segmentation Descriptor.
	//
	// This member is required.
	SegmentationDescriptorScte35DescriptorSettings *Scte35SegmentationDescriptor

	noSmithyDocumentSerde
}

// Settings for the "scte35 input" action
type Scte35InputScheduleActionSettings struct {

	// Whether the SCTE-35 input should be the active input or a fixed input.
	//
	// This member is required.
	Mode Scte35InputMode

	// In fixed mode, enter the name of the input attachment that you want to use as a
	// SCTE-35 input. (Don't enter the ID of the input.)"
	InputAttachmentNameReference *string

	noSmithyDocumentSerde
}

// Settings for a SCTE-35 return_to_network message.
type Scte35ReturnToNetworkScheduleActionSettings struct {

	// The splice_event_id for the SCTE-35 splice_insert, as defined in SCTE-35.
	//
	// This member is required.
	SpliceEventId int64

	noSmithyDocumentSerde
}

// Corresponds to SCTE-35 segmentation_descriptor.
type Scte35SegmentationDescriptor struct {

	// Corresponds to SCTE-35 segmentation_event_cancel_indicator.
	//
	// This member is required.
	SegmentationCancelIndicator Scte35SegmentationCancelIndicator

	// Corresponds to SCTE-35 segmentation_event_id.
	//
	// This member is required.
	SegmentationEventId int64

	// Holds the four SCTE-35 delivery restriction parameters.
	DeliveryRestrictions *Scte35DeliveryRestrictions

	// Corresponds to SCTE-35 segment_num. A value that is valid for the specified
	// segmentation_type_id.
	SegmentNum int32

	// Corresponds to SCTE-35 segmentation_duration. Optional. The duration for the
	// time_signal, in 90 KHz ticks. To convert seconds to ticks, multiple the seconds
	// by 90,000. Enter time in 90 KHz clock ticks. If you do not enter a duration, the
	// time_signal will continue until you insert a cancellation message.
	SegmentationDuration int64

	// Corresponds to SCTE-35 segmentation_type_id. One of the segmentation_type_id
	// values listed in the SCTE-35 specification. On the console, enter the ID in
	// decimal (for example, "52"). In the CLI, API, or an SDK, enter the ID in hex
	// (for example, "0x34") or decimal (for example, "52").
	SegmentationTypeId int32

	// Corresponds to SCTE-35 segmentation_upid. Enter a string containing the
	// hexadecimal representation of the characters that make up the SCTE-35
	// segmentation_upid value. Must contain an even number of hex characters. Do not
	// include spaces between each hex pair. For example, the ASCII "ADS Information"
	// becomes hex "41445320496e666f726d6174696f6e.
	SegmentationUpid *string

	// Corresponds to SCTE-35 segmentation_upid_type. On the console, enter one of the
	// types listed in the SCTE-35 specification, converted to a decimal. For example,
	// "0x0C" hex from the specification is "12" in decimal. In the CLI, API, or an
	// SDK, enter one of the types listed in the SCTE-35 specification, in either hex
	// (for example, "0x0C" ) or in decimal (for example, "12").
	SegmentationUpidType int32

	// Corresponds to SCTE-35 segments_expected. A value that is valid for the
	// specified segmentation_type_id.
	SegmentsExpected int32

	// Corresponds to SCTE-35 sub_segment_num. A value that is valid for the specified
	// segmentation_type_id.
	SubSegmentNum int32

	// Corresponds to SCTE-35 sub_segments_expected. A value that is valid for the
	// specified segmentation_type_id.
	SubSegmentsExpected int32

	noSmithyDocumentSerde
}

// Scte35 Splice Insert
type Scte35SpliceInsert struct {

	// When specified, this offset (in milliseconds) is added to the input Ad Avail PTS
	// time. This only applies to embedded SCTE 104/35 messages and does not apply to
	// OOB messages.
	AdAvailOffset int32

	// When set to ignore, Segment Descriptors with noRegionalBlackoutFlag set to 0
	// will no longer trigger blackouts or Ad Avail slates
	NoRegionalBlackoutFlag Scte35SpliceInsertNoRegionalBlackoutBehavior

	// When set to ignore, Segment Descriptors with webDeliveryAllowedFlag set to 0
	// will no longer trigger blackouts or Ad Avail slates
	WebDeliveryAllowedFlag Scte35SpliceInsertWebDeliveryAllowedBehavior

	noSmithyDocumentSerde
}

// Settings for a SCTE-35 splice_insert message.
type Scte35SpliceInsertScheduleActionSettings struct {

	// The splice_event_id for the SCTE-35 splice_insert, as defined in SCTE-35.
	//
	// This member is required.
	SpliceEventId int64

	// Optional, the duration for the splice_insert, in 90 KHz ticks. To convert
	// seconds to ticks, multiple the seconds by 90,000. If you enter a duration, there
	// is an expectation that the downstream system can read the duration and cue in at
	// that time. If you do not enter a duration, the splice_insert will continue
	// indefinitely and there is an expectation that you will enter a return_to_network
	// to end the splice_insert at the appropriate time.
	Duration int64

	noSmithyDocumentSerde
}

// Scte35 Time Signal Apos
type Scte35TimeSignalApos struct {

	// When specified, this offset (in milliseconds) is added to the input Ad Avail PTS
	// time. This only applies to embedded SCTE 104/35 messages and does not apply to
	// OOB messages.
	AdAvailOffset int32

	// When set to ignore, Segment Descriptors with noRegionalBlackoutFlag set to 0
	// will no longer trigger blackouts or Ad Avail slates
	NoRegionalBlackoutFlag Scte35AposNoRegionalBlackoutBehavior

	// When set to ignore, Segment Descriptors with webDeliveryAllowedFlag set to 0
	// will no longer trigger blackouts or Ad Avail slates
	WebDeliveryAllowedFlag Scte35AposWebDeliveryAllowedBehavior

	noSmithyDocumentSerde
}

// Settings for a SCTE-35 time_signal.
type Scte35TimeSignalScheduleActionSettings struct {

	// The list of SCTE-35 descriptors accompanying the SCTE-35 time_signal.
	//
	// This member is required.
	Scte35Descriptors []Scte35Descriptor

	noSmithyDocumentSerde
}

// Smpte Tt Destination Settings
type SmpteTtDestinationSettings struct {
	noSmithyDocumentSerde
}

// Standard Hls Settings
type StandardHlsSettings struct {

	// Settings information for the .m3u8 container
	//
	// This member is required.
	M3u8Settings *M3u8Settings

	// List all the audio groups that are used with the video output stream. Input all
	// the audio GROUP-IDs that are associated to the video, separate by ','.
	AudioRenditionSets *string

	noSmithyDocumentSerde
}

// Settings to identify the start of the clip.
type StartTimecode struct {

	// The timecode for the frame where you want to start the clip. Optional; if not
	// specified, the clip starts at first frame in the file. Enter the timecode as
	// HH:MM:SS:FF or HH:MM:SS;FF.
	Timecode *string

	noSmithyDocumentSerde
}

// Settings for the action to activate a static image.
type StaticImageActivateScheduleActionSettings struct {

	// The location and filename of the image file to overlay on the video. The file
	// must be a 32-bit BMP, PNG, or TGA file, and must not be larger (in pixels) than
	// the input video.
	//
	// This member is required.
	Image *InputLocation

	// The duration in milliseconds for the image to remain on the video. If omitted or
	// set to 0 the duration is unlimited and the image will remain until it is
	// explicitly deactivated.
	Duration int32

	// The time in milliseconds for the image to fade in. The fade-in starts at the
	// start time of the overlay. Default is 0 (no fade-in).
	FadeIn int32

	// Applies only if a duration is specified. The time in milliseconds for the image
	// to fade out. The fade-out starts when the duration time is hit, so it
	// effectively extends the duration. Default is 0 (no fade-out).
	FadeOut int32

	// The height of the image when inserted into the video, in pixels. The overlay
	// will be scaled up or down to the specified height. Leave blank to use the native
	// height of the overlay.
	Height int32

	// Placement of the left edge of the overlay relative to the left edge of the video
	// frame, in pixels. 0 (the default) is the left edge of the frame. If the
	// placement causes the overlay to extend beyond the right edge of the underlying
	// video, then the overlay is cropped on the right.
	ImageX int32

	// Placement of the top edge of the overlay relative to the top edge of the video
	// frame, in pixels. 0 (the default) is the top edge of the frame. If the placement
	// causes the overlay to extend beyond the bottom edge of the underlying video,
	// then the overlay is cropped on the bottom.
	ImageY int32

	// The number of the layer, 0 to 7. There are 8 layers that can be overlaid on the
	// video, each layer with a different image. The layers are in Z order, which means
	// that overlays with higher values of layer are inserted on top of overlays with
	// lower values of layer. Default is 0.
	Layer int32

	// Opacity of image where 0 is transparent and 100 is fully opaque. Default is 100.
	Opacity int32

	// The width of the image when inserted into the video, in pixels. The overlay will
	// be scaled up or down to the specified width. Leave blank to use the native width
	// of the overlay.
	Width int32

	noSmithyDocumentSerde
}

// Settings for the action to deactivate the image in a specific layer.
type StaticImageDeactivateScheduleActionSettings struct {

	// The time in milliseconds for the image to fade out. Default is 0 (no fade-out).
	FadeOut int32

	// The image overlay layer to deactivate, 0 to 7. Default is 0.
	Layer int32

	noSmithyDocumentSerde
}

// Static Key Settings
type StaticKeySettings struct {

	// Static key value as a 32 character hexadecimal string.
	//
	// This member is required.
	StaticKeyValue *string

	// The URL of the license server used for protecting content.
	KeyProviderServer *InputLocation

	noSmithyDocumentSerde
}

// Settings to identify the end of the clip.
type StopTimecode struct {

	// If you specify a StopTimecode in an input (in order to clip the file), you can
	// specify if you want the clip to exclude (the default) or include the frame
	// specified by the timecode.
	LastFrameClippingBehavior LastFrameClippingBehavior

	// The timecode for the frame where you want to stop the clip. Optional; if not
	// specified, the clip continues to the end of the file. Enter the timecode as
	// HH:MM:SS:FF or HH:MM:SS;FF.
	Timecode *string

	noSmithyDocumentSerde
}

// Teletext Destination Settings
type TeletextDestinationSettings struct {
	noSmithyDocumentSerde
}

// Teletext Source Settings
type TeletextSourceSettings struct {

	// Optionally defines a region where TTML style captions will be displayed
	OutputRectangle *CaptionRectangle

	// Specifies the teletext page number within the data stream from which to extract
	// captions. Range of 0x100 (256) to 0x8FF (2303). Unused for passthrough. Should
	// be specified as a hexadecimal string with no "0x" prefix.
	PageNumber *string

	noSmithyDocumentSerde
}

// Temporal Filter Settings
type TemporalFilterSettings struct {

	// If you enable this filter, the results are the following:
	//
	// * If the source
	// content is noisy (it contains excessive digital artifacts), the filter cleans up
	// the source.
	//
	// * If the source content is already clean, the filter tends to
	// decrease the bitrate, especially when the rate control mode is QVBR.
	PostFilterSharpening TemporalFilterPostFilterSharpening

	// Choose a filter strength. We recommend a strength of 1 or 2. A higher strength
	// might take out good information, resulting in an image that is overly soft.
	Strength TemporalFilterStrength

	noSmithyDocumentSerde
}

// Timecode Config
type TimecodeConfig struct {

	// Identifies the source for the timecode that will be associated with the events
	// outputs. -Embedded (embedded): Initialize the output timecode with timecode from
	// the the source. If no embedded timecode is detected in the source, the system
	// falls back to using "Start at 0" (zerobased). -System Clock (systemclock): Use
	// the UTC time. -Start at 0 (zerobased): The time of the first frame of the event
	// will be 00:00:00:00.
	//
	// This member is required.
	Source TimecodeConfigSource

	// Threshold in frames beyond which output timecode is resynchronized to the input
	// timecode. Discrepancies below this threshold are permitted to avoid unnecessary
	// discontinuities in the output timecode. No timecode sync when this is not
	// specified.
	SyncThreshold int32

	noSmithyDocumentSerde
}

// Details about the input device that is being transferred.
type TransferringInputDeviceSummary struct {

	// The unique ID of the input device.
	Id *string

	// The optional message that the sender has attached to the transfer.
	Message *string

	// The AWS account ID for the recipient of the input device transfer.
	TargetCustomerId *string

	// The type (direction) of the input device transfer.
	TransferType InputDeviceTransferType

	noSmithyDocumentSerde
}

// Ttml Destination Settings
type TtmlDestinationSettings struct {

	// This field is not currently supported and will not affect the output styling.
	// Leave the default value.
	StyleControl TtmlDestinationStyleControl

	noSmithyDocumentSerde
}

// Udp Container Settings
type UdpContainerSettings struct {

	// M2ts Settings
	M2tsSettings *M2tsSettings

	noSmithyDocumentSerde
}

// Udp Group Settings
type UdpGroupSettings struct {

	// Specifies behavior of last resort when input video is lost, and no more backup
	// inputs are available. When dropTs is selected the entire transport stream will
	// stop being emitted. When dropProgram is selected the program can be dropped from
	// the transport stream (and replaced with null packets to meet the TS bitrate
	// requirement). Or, when emitProgram is chosen the transport stream will continue
	// to be produced normally with repeat frames, black frames, or slate frames
	// substituted for the absent input video.
	InputLossAction InputLossActionForUdpOut

	// Indicates ID3 frame that has the timecode.
	TimedMetadataId3Frame UdpTimedMetadataId3Frame

	// Timed Metadata interval in seconds.
	TimedMetadataId3Period int32

	noSmithyDocumentSerde
}

// Udp Output Settings
type UdpOutputSettings struct {

	// Udp Container Settings
	//
	// This member is required.
	ContainerSettings *UdpContainerSettings

	// Destination address and port number for RTP or UDP packets. Can be unicast or
	// multicast RTP or UDP (eg. rtp://239.10.10.10:5001 or udp://10.100.100.100:5002).
	//
	// This member is required.
	Destination *OutputLocationRef

	// UDP output buffering in milliseconds. Larger values increase latency through the
	// transcoder but simultaneously assist the transcoder in maintaining a constant,
	// low-jitter UDP/RTP output while accommodating clock recovery, input switching,
	// input disruptions, picture reordering, etc.
	BufferMsec int32

	// Settings for enabling and adjusting Forward Error Correction on UDP outputs.
	FecOutputSettings *FecOutputSettings

	noSmithyDocumentSerde
}

// Placeholder documentation for ValidationError
type ValidationError struct {

	// Path to the source of the error.
	ElementPath *string

	// The error message.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// Placeholder documentation for VideoBlackFailoverSettings
type VideoBlackFailoverSettings struct {

	// A value used in calculating the threshold below which MediaLive considers a
	// pixel to be 'black'. For the input to be considered black, every pixel in a
	// frame must be below this threshold. The threshold is calculated as a percentage
	// (expressed as a decimal) of white. Therefore .1 means 10% white (or 90% black).
	// Note how the formula works for any color depth. For example, if you set this
	// field to 0.1 in 10-bit color depth: (10230.1=102.3), which means a pixel value
	// of 102 or less is 'black'. If you set this field to .1 in an 8-bit color depth:
	// (2550.1=25.5), which means a pixel value of 25 or less is 'black'. The range is
	// 0.0 to 1.0, with any number of decimal places.
	BlackDetectThreshold float64

	// The amount of time (in milliseconds) that the active input must be black before
	// automatic input failover occurs.
	VideoBlackThresholdMsec int32

	noSmithyDocumentSerde
}

// Video Codec Settings
type VideoCodecSettings struct {

	// Frame Capture Settings
	FrameCaptureSettings *FrameCaptureSettings

	// H264 Settings
	H264Settings *H264Settings

	// H265 Settings
	H265Settings *H265Settings

	// Mpeg2 Settings
	Mpeg2Settings *Mpeg2Settings

	noSmithyDocumentSerde
}

// Video settings for this stream.
type VideoDescription struct {

	// The name of this VideoDescription. Outputs will use this name to uniquely
	// identify this Description. Description names should be unique within this Live
	// Event.
	//
	// This member is required.
	Name *string

	// Video codec settings.
	CodecSettings *VideoCodecSettings

	// Output video height, in pixels. Must be an even number. For most codecs, you can
	// leave this field and width blank in order to use the height and width
	// (resolution) from the source. Note, however, that leaving blank is not
	// recommended. For the Frame Capture codec, height and width are required.
	Height int32

	// Indicates how MediaLive will respond to the AFD values that might be in the
	// input video. If you do not know what AFD signaling is, or if your downstream
	// system has not given you guidance, choose PASSTHROUGH. RESPOND: MediaLive clips
	// the input video using a formula that uses the AFD values (configured in
	// afdSignaling ), the input display aspect ratio, and the output display aspect
	// ratio. MediaLive also includes the AFD values in the output, unless the codec
	// for this encode is FRAME_CAPTURE. PASSTHROUGH: MediaLive ignores the AFD values
	// and does not clip the video. But MediaLive does include the values in the
	// output. NONE: MediaLive does not clip the input video and does not include the
	// AFD values in the output
	RespondToAfd VideoDescriptionRespondToAfd

	// STRETCH_TO_OUTPUT configures the output position to stretch the video to the
	// specified output resolution (height and width). This option will override any
	// position value. DEFAULT may insert black boxes (pillar boxes or letter boxes)
	// around the video to provide the specified output resolution.
	ScalingBehavior VideoDescriptionScalingBehavior

	// Changes the strength of the anti-alias filter used for scaling. 0 is the softest
	// setting, 100 is the sharpest. A setting of 50 is recommended for most content.
	Sharpness int32

	// Output video width, in pixels. Must be an even number. For most codecs, you can
	// leave this field and height blank in order to use the height and width
	// (resolution) from the source. Note, however, that leaving blank is not
	// recommended. For the Frame Capture codec, height and width are required.
	Width int32

	noSmithyDocumentSerde
}

// Specifies a particular video stream within an input source. An input may have
// only a single video selector.
type VideoSelector struct {

	// Specifies the color space of an input. This setting works in tandem with
	// colorSpaceUsage and a video description's colorSpaceSettingsChoice to determine
	// if any conversion will be performed.
	ColorSpace VideoSelectorColorSpace

	// Color space settings
	ColorSpaceSettings *VideoSelectorColorSpaceSettings

	// Applies only if colorSpace is a value other than follow. This field controls how
	// the value in the colorSpace field will be used. fallback means that when the
	// input does include color space data, that data will be used, but when the input
	// has no color space data, the value in colorSpace will be used. Choose fallback
	// if your input is sometimes missing color space data, but when it does have color
	// space data, that data is correct. force means to always use the value in
	// colorSpace. Choose force if your input usually has no color space data or might
	// have unreliable color space data.
	ColorSpaceUsage VideoSelectorColorSpaceUsage

	// The video selector settings.
	SelectorSettings *VideoSelectorSettings

	noSmithyDocumentSerde
}

// Video Selector Color Space Settings
type VideoSelectorColorSpaceSettings struct {

	// Hdr10 Settings
	Hdr10Settings *Hdr10Settings

	noSmithyDocumentSerde
}

// Video Selector Pid
type VideoSelectorPid struct {

	// Selects a specific PID from within a video source.
	Pid int32

	noSmithyDocumentSerde
}

// Video Selector Program Id
type VideoSelectorProgramId struct {

	// Selects a specific program from within a multi-program transport stream. If the
	// program doesn't exist, the first program within the transport stream will be
	// selected by default.
	ProgramId int32

	noSmithyDocumentSerde
}

// Video Selector Settings
type VideoSelectorSettings struct {

	// Video Selector Pid
	VideoSelectorPid *VideoSelectorPid

	// Video Selector Program Id
	VideoSelectorProgramId *VideoSelectorProgramId

	noSmithyDocumentSerde
}

// The properties for a private VPC Output When this property is specified, the
// output egress addresses will be created in a user specified VPC
type VpcOutputSettings struct {

	// A list of VPC subnet IDs from the same VPC. If STANDARD channel, subnet IDs must
	// be mapped to two unique availability zones (AZ).
	//
	// This member is required.
	SubnetIds []string

	// List of public address allocation ids to associate with ENIs that will be
	// created in Output VPC. Must specify one for SINGLE_PIPELINE, two for STANDARD
	// channels
	PublicAddressAllocationIds []string

	// A list of up to 5 EC2 VPC security group IDs to attach to the Output VPC network
	// interfaces. If none are specified then the VPC default security group will be
	// used
	SecurityGroupIds []string

	noSmithyDocumentSerde
}

// The properties for a private VPC Output
type VpcOutputSettingsDescription struct {

	// The Availability Zones where the vpc subnets are located. The first Availability
	// Zone applies to the first subnet in the list of subnets. The second Availability
	// Zone applies to the second subnet.
	AvailabilityZones []string

	// A list of Elastic Network Interfaces created by MediaLive in the customer's VPC
	NetworkInterfaceIds []string

	// A list of up EC2 VPC security group IDs attached to the Output VPC network
	// interfaces.
	SecurityGroupIds []string

	// A list of VPC subnet IDs from the same VPC. If STANDARD channel, subnet IDs must
	// be mapped to two unique availability zones (AZ).
	SubnetIds []string

	noSmithyDocumentSerde
}

// Wav Settings
type WavSettings struct {

	// Bits per sample.
	BitDepth float64

	// The audio coding mode for the WAV audio. The mode determines the number of
	// channels in the audio.
	CodingMode WavCodingMode

	// Sample rate in Hz.
	SampleRate float64

	noSmithyDocumentSerde
}

// Webvtt Destination Settings
type WebvttDestinationSettings struct {

	// Controls whether the color and position of the source captions is passed through
	// to the WebVTT output captions. PASSTHROUGH - Valid only if the source captions
	// are EMBEDDED or TELETEXT. NO_STYLE_DATA - Don't pass through the style. The
	// output captions will not contain any font styling information.
	StyleControl WebvttDestinationStyleControl

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
