// Code generated by smithy-go-codegen DO NOT EDIT.

package transcribe

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/transcribe/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Starts an asynchronous analytics job that not only transcribes the audio
// recording of a caller and agent, but also returns additional insights. These
// insights include how quickly or loudly the caller or agent was speaking. To
// retrieve additional insights with your analytics jobs, create categories. A
// category is a way to classify analytics jobs based on attributes, such as a
// customer's sentiment or a particular phrase being used during the call. For more
// information, see the operation.
func (c *Client) StartCallAnalyticsJob(ctx context.Context, params *StartCallAnalyticsJobInput, optFns ...func(*Options)) (*StartCallAnalyticsJobOutput, error) {
	if params == nil {
		params = &StartCallAnalyticsJobInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "StartCallAnalyticsJob", params, optFns, c.addOperationStartCallAnalyticsJobMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*StartCallAnalyticsJobOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type StartCallAnalyticsJobInput struct {

	// The name of the call analytics job. You can't use the string "." or ".." by
	// themselves as the job name. The name must also be unique within an Amazon Web
	// Services account. If you try to create a call analytics job with the same name
	// as a previous call analytics job, you get a ConflictException error.
	//
	// This member is required.
	CallAnalyticsJobName *string

	// The Amazon Resource Name (ARN) of a role that has access to the S3 bucket that
	// contains your input files. Amazon Transcribe assumes this role to read queued
	// audio files. If you have specified an output S3 bucket for your transcription
	// results, this role should have access to the output bucket as well.
	//
	// This member is required.
	DataAccessRoleArn *string

	// Describes the input media file in a transcription request.
	//
	// This member is required.
	Media *types.Media

	// When you start a call analytics job, you must pass an array that maps the agent
	// and the customer to specific audio channels. The values you can assign to a
	// channel are 0 and 1. The agent and the customer must each have their own
	// channel. You can't assign more than one channel to an agent or customer.
	ChannelDefinitions []types.ChannelDefinition

	// The Amazon Resource Name (ARN) of the Amazon Web Services Key Management Service
	// key used to encrypt the output of the call analytics job. The user calling the
	// operation must have permission to use the specified KMS key. You use either of
	// the following to identify an Amazon Web Services KMS key in the current
	// account:
	//
	// * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	// * KMS Key Alias:
	// "alias/ExampleAlias"
	//
	// You can use either of the following to identify a KMS key
	// in the current account or another account:
	//
	// * Amazon Resource Name (ARN) of a
	// KMS key in the current account or another account: "arn:aws:kms:region:account
	// ID:key/1234abcd-12ab-34cd-56ef1234567890ab"
	//
	// * ARN of a KMS Key Alias:
	// "arn:aws:kms:region:accountID:alias/ExampleAlias"
	//
	// If you don't specify an
	// encryption key, the output of the call analytics job is encrypted with the
	// default Amazon S3 key (SSE-S3). If you specify a KMS key to encrypt your output,
	// you must also specify an output location in the OutputLocation parameter.
	OutputEncryptionKMSKeyId *string

	// The Amazon S3 location where the output of the call analytics job is stored. You
	// can provide the following location types to store the output of call analytics
	// job:
	//
	// * s3://DOC-EXAMPLE-BUCKET1 If you specify a bucket, Amazon Transcribe
	// saves the output of the analytics job as a JSON file at the root level of the
	// bucket.
	//
	// * s3://DOC-EXAMPLE-BUCKET1/folder/ f you specify a path, Amazon
	// Transcribe saves the output of the analytics job as
	// s3://DOC-EXAMPLE-BUCKET1/folder/your-transcription-job-name.json. If you specify
	// a folder, you must provide a trailing slash.
	//
	// *
	// s3://DOC-EXAMPLE-BUCKET1/folder/filename.json. If you provide a path that has
	// the filename specified, Amazon Transcribe saves the output of the analytics job
	// as s3://DOC-EXAMPLEBUCKET1/folder/filename.json.
	//
	// You can specify an Amazon Web
	// Services Key Management Service (KMS) key to encrypt the output of our analytics
	// job using the OutputEncryptionKMSKeyId parameter. If you don't specify a KMS
	// key, Amazon Transcribe uses the default Amazon S3 key for server-side encryption
	// of the analytics job output that is placed in your S3 bucket.
	OutputLocation *string

	// A Settings object that provides optional settings for a call analytics job.
	Settings *types.CallAnalyticsJobSettings

	noSmithyDocumentSerde
}

type StartCallAnalyticsJobOutput struct {

	// An object containing the details of the asynchronous call analytics job.
	CallAnalyticsJob *types.CallAnalyticsJob

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationStartCallAnalyticsJobMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpStartCallAnalyticsJob{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpStartCallAnalyticsJob{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpStartCallAnalyticsJobValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opStartCallAnalyticsJob(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opStartCallAnalyticsJob(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "transcribe",
		OperationName: "StartCallAnalyticsJob",
	}
}
