// Code generated by smithy-go-codegen DO NOT EDIT.

package transcribe

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/transcribe/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Gets information about vocabulary filters.
func (c *Client) ListVocabularyFilters(ctx context.Context, params *ListVocabularyFiltersInput, optFns ...func(*Options)) (*ListVocabularyFiltersOutput, error) {
	if params == nil {
		params = &ListVocabularyFiltersInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListVocabularyFilters", params, optFns, c.addOperationListVocabularyFiltersMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListVocabularyFiltersOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListVocabularyFiltersInput struct {

	// The maximum number of filters to return in each page of results. If there are
	// fewer results than the value you specify, only the actual results are returned.
	// If you do not specify a value, the default of 5 is used.
	MaxResults *int32

	// Filters the response so that it only contains vocabulary filters whose name
	// contains the specified string.
	NameContains *string

	// If the result of the previous request to ListVocabularyFilters was truncated,
	// include the NextToken to fetch the next set of collections.
	NextToken *string

	noSmithyDocumentSerde
}

type ListVocabularyFiltersOutput struct {

	// The ListVocabularyFilters operation returns a page of collections at a time. The
	// maximum size of the page is set by the MaxResults parameter. If there are more
	// jobs in the list than the page size, Amazon Transcribe returns the NextPage
	// token. Include the token in the next request to the ListVocabularyFilters
	// operation to return in the next page of jobs.
	NextToken *string

	// The list of vocabulary filters. It contains at most MaxResults number of
	// filters. If there are more filters, call the ListVocabularyFilters operation
	// again with the NextToken parameter in the request set to the value of the
	// NextToken field in the response.
	VocabularyFilters []types.VocabularyFilterInfo

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListVocabularyFiltersMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListVocabularyFilters{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListVocabularyFilters{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListVocabularyFilters(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListVocabularyFiltersAPIClient is a client that implements the
// ListVocabularyFilters operation.
type ListVocabularyFiltersAPIClient interface {
	ListVocabularyFilters(context.Context, *ListVocabularyFiltersInput, ...func(*Options)) (*ListVocabularyFiltersOutput, error)
}

var _ ListVocabularyFiltersAPIClient = (*Client)(nil)

// ListVocabularyFiltersPaginatorOptions is the paginator options for
// ListVocabularyFilters
type ListVocabularyFiltersPaginatorOptions struct {
	// The maximum number of filters to return in each page of results. If there are
	// fewer results than the value you specify, only the actual results are returned.
	// If you do not specify a value, the default of 5 is used.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListVocabularyFiltersPaginator is a paginator for ListVocabularyFilters
type ListVocabularyFiltersPaginator struct {
	options   ListVocabularyFiltersPaginatorOptions
	client    ListVocabularyFiltersAPIClient
	params    *ListVocabularyFiltersInput
	nextToken *string
	firstPage bool
}

// NewListVocabularyFiltersPaginator returns a new ListVocabularyFiltersPaginator
func NewListVocabularyFiltersPaginator(client ListVocabularyFiltersAPIClient, params *ListVocabularyFiltersInput, optFns ...func(*ListVocabularyFiltersPaginatorOptions)) *ListVocabularyFiltersPaginator {
	if params == nil {
		params = &ListVocabularyFiltersInput{}
	}

	options := ListVocabularyFiltersPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListVocabularyFiltersPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListVocabularyFiltersPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListVocabularyFilters page.
func (p *ListVocabularyFiltersPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListVocabularyFiltersOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListVocabularyFilters(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListVocabularyFilters(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "transcribe",
		OperationName: "ListVocabularyFilters",
	}
}
