// Code generated by smithy-go-codegen DO NOT EDIT.

package transcribe

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/transcribe/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of vocabularies that match the specified criteria. If you don't
// enter a value in any of the request parameters, returns the entire list of
// vocabularies.
func (c *Client) ListMedicalVocabularies(ctx context.Context, params *ListMedicalVocabulariesInput, optFns ...func(*Options)) (*ListMedicalVocabulariesOutput, error) {
	if params == nil {
		params = &ListMedicalVocabulariesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListMedicalVocabularies", params, optFns, c.addOperationListMedicalVocabulariesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListMedicalVocabulariesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListMedicalVocabulariesInput struct {

	// The maximum number of vocabularies to return in each page of results. If there
	// are fewer results than the value you specify, only the actual results are
	// returned. If you do not specify a value, the default of 5 is used.
	MaxResults *int32

	// Returns vocabularies whose names contain the specified string. The search is not
	// case sensitive. ListMedicalVocabularies returns both "vocabularyname" and
	// "VocabularyName".
	NameContains *string

	// If the result of your previous request to ListMedicalVocabularies was truncated,
	// include the NextToken to fetch the next set of vocabularies.
	NextToken *string

	// When specified, returns only vocabularies with the VocabularyState equal to the
	// specified vocabulary state. Use this field to see which vocabularies are ready
	// for your medical transcription jobs.
	StateEquals types.VocabularyState

	noSmithyDocumentSerde
}

type ListMedicalVocabulariesOutput struct {

	// The ListMedicalVocabularies operation returns a page of vocabularies at a time.
	// You set the maximum number of vocabularies to return on a page with the
	// MaxResults parameter. If there are more jobs in the list will fit on a page,
	// Amazon Transcribe Medical returns the NextPage token. To return the next page of
	// vocabularies, include the token in the next request to the
	// ListMedicalVocabularies operation .
	NextToken *string

	// The requested vocabulary state.
	Status types.VocabularyState

	// A list of objects that describe the vocabularies that match your search
	// criteria.
	Vocabularies []types.VocabularyInfo

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListMedicalVocabulariesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListMedicalVocabularies{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListMedicalVocabularies{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListMedicalVocabularies(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListMedicalVocabulariesAPIClient is a client that implements the
// ListMedicalVocabularies operation.
type ListMedicalVocabulariesAPIClient interface {
	ListMedicalVocabularies(context.Context, *ListMedicalVocabulariesInput, ...func(*Options)) (*ListMedicalVocabulariesOutput, error)
}

var _ ListMedicalVocabulariesAPIClient = (*Client)(nil)

// ListMedicalVocabulariesPaginatorOptions is the paginator options for
// ListMedicalVocabularies
type ListMedicalVocabulariesPaginatorOptions struct {
	// The maximum number of vocabularies to return in each page of results. If there
	// are fewer results than the value you specify, only the actual results are
	// returned. If you do not specify a value, the default of 5 is used.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListMedicalVocabulariesPaginator is a paginator for ListMedicalVocabularies
type ListMedicalVocabulariesPaginator struct {
	options   ListMedicalVocabulariesPaginatorOptions
	client    ListMedicalVocabulariesAPIClient
	params    *ListMedicalVocabulariesInput
	nextToken *string
	firstPage bool
}

// NewListMedicalVocabulariesPaginator returns a new
// ListMedicalVocabulariesPaginator
func NewListMedicalVocabulariesPaginator(client ListMedicalVocabulariesAPIClient, params *ListMedicalVocabulariesInput, optFns ...func(*ListMedicalVocabulariesPaginatorOptions)) *ListMedicalVocabulariesPaginator {
	if params == nil {
		params = &ListMedicalVocabulariesInput{}
	}

	options := ListMedicalVocabulariesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListMedicalVocabulariesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListMedicalVocabulariesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListMedicalVocabularies page.
func (p *ListMedicalVocabulariesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListMedicalVocabulariesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListMedicalVocabularies(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListMedicalVocabularies(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "transcribe",
		OperationName: "ListMedicalVocabularies",
	}
}
