// Code generated by smithy-go-codegen DO NOT EDIT.

package proton

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/proton/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Deploy a new environment. An Proton environment is created from an environment
// template that defines infrastructure and resources that can be shared across
// services. You can provision environments using the following methods:
//
// *
// Standard provisioning: Proton makes direct calls to provision your resources.
//
// *
// Pull request provisioning: Proton makes pull requests on your repository to
// provide compiled infrastructure as code (IaC) files that your IaC engine uses to
// provision resources.
//
// For more information, see the Environments
// (https://docs.aws.amazon.com/proton/latest/adminguide/ag-environments.html) in
// the Proton Administrator Guide.
func (c *Client) CreateEnvironment(ctx context.Context, params *CreateEnvironmentInput, optFns ...func(*Options)) (*CreateEnvironmentOutput, error) {
	if params == nil {
		params = &CreateEnvironmentInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateEnvironment", params, optFns, c.addOperationCreateEnvironmentMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateEnvironmentOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateEnvironmentInput struct {

	// The name of the environment.
	//
	// This member is required.
	Name *string

	// A link to a YAML formatted spec file that provides inputs as defined in the
	// environment template bundle schema file. For more information, see Environments
	// (https://docs.aws.amazon.com/proton/latest/adminguide/ag-environments.html) in
	// the Proton Administrator Guide.
	//
	// This value conforms to the media type: application/yaml
	//
	// This member is required.
	Spec *string

	// The major version of the environment template.
	//
	// This member is required.
	TemplateMajorVersion *string

	// The name of the environment template. For more information, see Environment
	// Templates
	// (https://docs.aws.amazon.com/proton/latest/adminguide/ag-templates.html) in the
	// Proton Administrator Guide.
	//
	// This member is required.
	TemplateName *string

	// A description of the environment that's being created and deployed.
	Description *string

	// The ID of the environment account connection that you provide if you're
	// provisioning your environment infrastructure resources to an environment
	// account. You must include either the environmentAccountConnectionId or
	// protonServiceRoleArn parameter and value and omit the provisioningRepository
	// parameter and values. For more information, see Environment account connections
	// (https://docs.aws.amazon.com/proton/latest/adminguide/ag-env-account-connections.html)
	// in the Proton Administrator guide.
	EnvironmentAccountConnectionId *string

	// The Amazon Resource Name (ARN) of the Proton service role that allows Proton to
	// make calls to other services on your behalf. You must include either the
	// environmentAccountConnectionId or protonServiceRoleArn parameter and value and
	// omit the provisioningRepository parameter when you use standard provisioning.
	ProtonServiceRoleArn *string

	// The repository that you provide with pull request provisioning. If you provide
	// this parameter, you must omit the environmentAccountConnectionId and
	// protonServiceRoleArn parameters. Provisioning by pull request is currently in
	// feature preview and is only usable with Terraform based Proton Templates. To
	// learn more about Amazon Web Services Feature Preview terms
	// (https://aws.amazon.com/service-terms), see section 2 on Beta and Previews.
	ProvisioningRepository *types.RepositoryBranchInput

	// Create tags for your environment. For more information, see Proton resources and
	// tagging in the Proton Administrator Guide
	// (https://docs.aws.amazon.com/proton/latest/adminguide/resources.html) or Proton
	// User Guide (https://docs.aws.amazon.com/proton/latest/userguide/resources.html).
	Tags []types.Tag

	// The minor version of the environment template.
	TemplateMinorVersion *string

	noSmithyDocumentSerde
}

type CreateEnvironmentOutput struct {

	// The environment detail data that's returned by Proton.
	//
	// This member is required.
	Environment *types.Environment

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateEnvironmentMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpCreateEnvironment{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpCreateEnvironment{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateEnvironmentValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateEnvironment(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateEnvironment(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "proton",
		OperationName: "CreateEnvironment",
	}
}
