// Code generated by smithy-go-codegen DO NOT EDIT.

package iottwinmaker

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/iottwinmaker/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"math"
)

type awsRestjson1_serializeOpBatchPutPropertyValues struct {
}

func (*awsRestjson1_serializeOpBatchPutPropertyValues) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchPutPropertyValues) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchPutPropertyValuesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}/entity-properties")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchPutPropertyValuesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchPutPropertyValuesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchPutPropertyValuesInput(v *BatchPutPropertyValuesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchPutPropertyValuesInput(v *BatchPutPropertyValuesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Entries != nil {
		ok := object.Key("entries")
		if err := awsRestjson1_serializeDocumentEntries(v.Entries, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateComponentType struct {
}

func (*awsRestjson1_serializeOpCreateComponentType) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateComponentType) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateComponentTypeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}/component-types/{componentTypeId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateComponentTypeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateComponentTypeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateComponentTypeInput(v *CreateComponentTypeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ComponentTypeId == nil || len(*v.ComponentTypeId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member componentTypeId must not be empty")}
	}
	if v.ComponentTypeId != nil {
		if err := encoder.SetURI("componentTypeId").String(*v.ComponentTypeId); err != nil {
			return err
		}
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateComponentTypeInput(v *CreateComponentTypeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.ExtendsFrom != nil {
		ok := object.Key("extendsFrom")
		if err := awsRestjson1_serializeDocumentExtendsFrom(v.ExtendsFrom, ok); err != nil {
			return err
		}
	}

	if v.Functions != nil {
		ok := object.Key("functions")
		if err := awsRestjson1_serializeDocumentFunctionsRequest(v.Functions, ok); err != nil {
			return err
		}
	}

	if v.IsSingleton != nil {
		ok := object.Key("isSingleton")
		ok.Boolean(*v.IsSingleton)
	}

	if v.PropertyDefinitions != nil {
		ok := object.Key("propertyDefinitions")
		if err := awsRestjson1_serializeDocumentPropertyDefinitionsRequest(v.PropertyDefinitions, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateEntity struct {
}

func (*awsRestjson1_serializeOpCreateEntity) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateEntity) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateEntityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}/entities")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateEntityInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateEntityInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateEntityInput(v *CreateEntityInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateEntityInput(v *CreateEntityInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Components != nil {
		ok := object.Key("components")
		if err := awsRestjson1_serializeDocumentComponentsMapRequest(v.Components, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.EntityId != nil {
		ok := object.Key("entityId")
		ok.String(*v.EntityId)
	}

	if v.EntityName != nil {
		ok := object.Key("entityName")
		ok.String(*v.EntityName)
	}

	if v.ParentEntityId != nil {
		ok := object.Key("parentEntityId")
		ok.String(*v.ParentEntityId)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateScene struct {
}

func (*awsRestjson1_serializeOpCreateScene) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateScene) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateSceneInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}/scenes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateSceneInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateSceneInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateSceneInput(v *CreateSceneInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateSceneInput(v *CreateSceneInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Capabilities != nil {
		ok := object.Key("capabilities")
		if err := awsRestjson1_serializeDocumentSceneCapabilities(v.Capabilities, ok); err != nil {
			return err
		}
	}

	if v.ContentLocation != nil {
		ok := object.Key("contentLocation")
		ok.String(*v.ContentLocation)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.SceneId != nil {
		ok := object.Key("sceneId")
		ok.String(*v.SceneId)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateWorkspace struct {
}

func (*awsRestjson1_serializeOpCreateWorkspace) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateWorkspace) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateWorkspaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateWorkspaceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateWorkspaceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateWorkspaceInput(v *CreateWorkspaceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateWorkspaceInput(v *CreateWorkspaceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Role != nil {
		ok := object.Key("role")
		ok.String(*v.Role)
	}

	if v.S3Location != nil {
		ok := object.Key("s3Location")
		ok.String(*v.S3Location)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteComponentType struct {
}

func (*awsRestjson1_serializeOpDeleteComponentType) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteComponentType) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteComponentTypeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}/component-types/{componentTypeId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteComponentTypeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteComponentTypeInput(v *DeleteComponentTypeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ComponentTypeId == nil || len(*v.ComponentTypeId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member componentTypeId must not be empty")}
	}
	if v.ComponentTypeId != nil {
		if err := encoder.SetURI("componentTypeId").String(*v.ComponentTypeId); err != nil {
			return err
		}
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteEntity struct {
}

func (*awsRestjson1_serializeOpDeleteEntity) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteEntity) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteEntityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}/entities/{entityId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteEntityInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteEntityInput(v *DeleteEntityInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EntityId == nil || len(*v.EntityId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member entityId must not be empty")}
	}
	if v.EntityId != nil {
		if err := encoder.SetURI("entityId").String(*v.EntityId); err != nil {
			return err
		}
	}

	if v.IsRecursive != nil {
		encoder.SetQuery("isRecursive").Boolean(*v.IsRecursive)
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteScene struct {
}

func (*awsRestjson1_serializeOpDeleteScene) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteScene) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteSceneInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}/scenes/{sceneId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteSceneInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteSceneInput(v *DeleteSceneInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SceneId == nil || len(*v.SceneId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member sceneId must not be empty")}
	}
	if v.SceneId != nil {
		if err := encoder.SetURI("sceneId").String(*v.SceneId); err != nil {
			return err
		}
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteWorkspace struct {
}

func (*awsRestjson1_serializeOpDeleteWorkspace) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteWorkspace) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteWorkspaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteWorkspaceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteWorkspaceInput(v *DeleteWorkspaceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetComponentType struct {
}

func (*awsRestjson1_serializeOpGetComponentType) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetComponentType) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetComponentTypeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}/component-types/{componentTypeId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetComponentTypeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetComponentTypeInput(v *GetComponentTypeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ComponentTypeId == nil || len(*v.ComponentTypeId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member componentTypeId must not be empty")}
	}
	if v.ComponentTypeId != nil {
		if err := encoder.SetURI("componentTypeId").String(*v.ComponentTypeId); err != nil {
			return err
		}
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetEntity struct {
}

func (*awsRestjson1_serializeOpGetEntity) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetEntity) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetEntityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}/entities/{entityId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetEntityInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetEntityInput(v *GetEntityInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EntityId == nil || len(*v.EntityId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member entityId must not be empty")}
	}
	if v.EntityId != nil {
		if err := encoder.SetURI("entityId").String(*v.EntityId); err != nil {
			return err
		}
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetPropertyValue struct {
}

func (*awsRestjson1_serializeOpGetPropertyValue) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetPropertyValue) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPropertyValueInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}/entity-properties/value")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetPropertyValueInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetPropertyValueInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetPropertyValueInput(v *GetPropertyValueInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetPropertyValueInput(v *GetPropertyValueInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComponentName != nil {
		ok := object.Key("componentName")
		ok.String(*v.ComponentName)
	}

	if v.ComponentTypeId != nil {
		ok := object.Key("componentTypeId")
		ok.String(*v.ComponentTypeId)
	}

	if v.EntityId != nil {
		ok := object.Key("entityId")
		ok.String(*v.EntityId)
	}

	if v.SelectedProperties != nil {
		ok := object.Key("selectedProperties")
		if err := awsRestjson1_serializeDocumentSelectedPropertyList(v.SelectedProperties, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetPropertyValueHistory struct {
}

func (*awsRestjson1_serializeOpGetPropertyValueHistory) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetPropertyValueHistory) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetPropertyValueHistoryInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}/entity-properties/history")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetPropertyValueHistoryInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentGetPropertyValueHistoryInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetPropertyValueHistoryInput(v *GetPropertyValueHistoryInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentGetPropertyValueHistoryInput(v *GetPropertyValueHistoryInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComponentName != nil {
		ok := object.Key("componentName")
		ok.String(*v.ComponentName)
	}

	if v.ComponentTypeId != nil {
		ok := object.Key("componentTypeId")
		ok.String(*v.ComponentTypeId)
	}

	if v.EndDateTime != nil {
		ok := object.Key("endDateTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.EndDateTime))
	}

	if v.EntityId != nil {
		ok := object.Key("entityId")
		ok.String(*v.EntityId)
	}

	if v.Interpolation != nil {
		ok := object.Key("interpolation")
		if err := awsRestjson1_serializeDocumentInterpolationParameters(v.Interpolation, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if len(v.OrderByTime) > 0 {
		ok := object.Key("orderByTime")
		ok.String(string(v.OrderByTime))
	}

	if v.PropertyFilters != nil {
		ok := object.Key("propertyFilters")
		if err := awsRestjson1_serializeDocumentPropertyFilters(v.PropertyFilters, ok); err != nil {
			return err
		}
	}

	if v.SelectedProperties != nil {
		ok := object.Key("selectedProperties")
		if err := awsRestjson1_serializeDocumentSelectedPropertyList(v.SelectedProperties, ok); err != nil {
			return err
		}
	}

	if v.StartDateTime != nil {
		ok := object.Key("startDateTime")
		ok.Double(smithytime.FormatEpochSeconds(*v.StartDateTime))
	}

	return nil
}

type awsRestjson1_serializeOpGetScene struct {
}

func (*awsRestjson1_serializeOpGetScene) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetScene) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetSceneInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}/scenes/{sceneId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetSceneInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetSceneInput(v *GetSceneInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SceneId == nil || len(*v.SceneId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member sceneId must not be empty")}
	}
	if v.SceneId != nil {
		if err := encoder.SetURI("sceneId").String(*v.SceneId); err != nil {
			return err
		}
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetWorkspace struct {
}

func (*awsRestjson1_serializeOpGetWorkspace) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetWorkspace) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetWorkspaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetWorkspaceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetWorkspaceInput(v *GetWorkspaceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListComponentTypes struct {
}

func (*awsRestjson1_serializeOpListComponentTypes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListComponentTypes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListComponentTypesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}/component-types-list")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListComponentTypesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListComponentTypesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListComponentTypesInput(v *ListComponentTypesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListComponentTypesInput(v *ListComponentTypesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("filters")
		if err := awsRestjson1_serializeDocumentListComponentTypesFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListEntities struct {
}

func (*awsRestjson1_serializeOpListEntities) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListEntities) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListEntitiesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}/entities-list")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListEntitiesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListEntitiesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListEntitiesInput(v *ListEntitiesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListEntitiesInput(v *ListEntitiesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Filters != nil {
		ok := object.Key("filters")
		if err := awsRestjson1_serializeDocumentListEntitiesFilters(v.Filters, ok); err != nil {
			return err
		}
	}

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListScenes struct {
}

func (*awsRestjson1_serializeOpListScenes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListScenes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListScenesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}/scenes-list")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListScenesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListScenesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListScenesInput(v *ListScenesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListScenesInput(v *ListScenesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags-list")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListTagsForResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListTagsForResourceInput(v *ListTagsForResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	if v.ResourceARN != nil {
		ok := object.Key("resourceARN")
		ok.String(*v.ResourceARN)
	}

	return nil
}

type awsRestjson1_serializeOpListWorkspaces struct {
}

func (*awsRestjson1_serializeOpListWorkspaces) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListWorkspaces) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListWorkspacesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces-list")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentListWorkspacesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListWorkspacesInput(v *ListWorkspacesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentListWorkspacesInput(v *ListWorkspacesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("maxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("nextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceARN != nil {
		ok := object.Key("resourceARN")
		ok.String(*v.ResourceARN)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTagMap(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tags")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceARN != nil {
		encoder.SetQuery("resourceARN").String(*v.ResourceARN)
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateComponentType struct {
}

func (*awsRestjson1_serializeOpUpdateComponentType) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateComponentType) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateComponentTypeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}/component-types/{componentTypeId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateComponentTypeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateComponentTypeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateComponentTypeInput(v *UpdateComponentTypeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ComponentTypeId == nil || len(*v.ComponentTypeId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member componentTypeId must not be empty")}
	}
	if v.ComponentTypeId != nil {
		if err := encoder.SetURI("componentTypeId").String(*v.ComponentTypeId); err != nil {
			return err
		}
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateComponentTypeInput(v *UpdateComponentTypeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.ExtendsFrom != nil {
		ok := object.Key("extendsFrom")
		if err := awsRestjson1_serializeDocumentExtendsFrom(v.ExtendsFrom, ok); err != nil {
			return err
		}
	}

	if v.Functions != nil {
		ok := object.Key("functions")
		if err := awsRestjson1_serializeDocumentFunctionsRequest(v.Functions, ok); err != nil {
			return err
		}
	}

	if v.IsSingleton != nil {
		ok := object.Key("isSingleton")
		ok.Boolean(*v.IsSingleton)
	}

	if v.PropertyDefinitions != nil {
		ok := object.Key("propertyDefinitions")
		if err := awsRestjson1_serializeDocumentPropertyDefinitionsRequest(v.PropertyDefinitions, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateEntity struct {
}

func (*awsRestjson1_serializeOpUpdateEntity) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateEntity) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateEntityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}/entities/{entityId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateEntityInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateEntityInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateEntityInput(v *UpdateEntityInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.EntityId == nil || len(*v.EntityId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member entityId must not be empty")}
	}
	if v.EntityId != nil {
		if err := encoder.SetURI("entityId").String(*v.EntityId); err != nil {
			return err
		}
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateEntityInput(v *UpdateEntityInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComponentUpdates != nil {
		ok := object.Key("componentUpdates")
		if err := awsRestjson1_serializeDocumentComponentUpdatesMapRequest(v.ComponentUpdates, ok); err != nil {
			return err
		}
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.EntityName != nil {
		ok := object.Key("entityName")
		ok.String(*v.EntityName)
	}

	if v.ParentEntityUpdate != nil {
		ok := object.Key("parentEntityUpdate")
		if err := awsRestjson1_serializeDocumentParentEntityUpdateRequest(v.ParentEntityUpdate, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateScene struct {
}

func (*awsRestjson1_serializeOpUpdateScene) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateScene) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateSceneInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}/scenes/{sceneId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateSceneInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateSceneInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateSceneInput(v *UpdateSceneInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.SceneId == nil || len(*v.SceneId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member sceneId must not be empty")}
	}
	if v.SceneId != nil {
		if err := encoder.SetURI("sceneId").String(*v.SceneId); err != nil {
			return err
		}
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateSceneInput(v *UpdateSceneInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Capabilities != nil {
		ok := object.Key("capabilities")
		if err := awsRestjson1_serializeDocumentSceneCapabilities(v.Capabilities, ok); err != nil {
			return err
		}
	}

	if v.ContentLocation != nil {
		ok := object.Key("contentLocation")
		ok.String(*v.ContentLocation)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateWorkspace struct {
}

func (*awsRestjson1_serializeOpUpdateWorkspace) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateWorkspace) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateWorkspaceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/workspaces/{workspaceId}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateWorkspaceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateWorkspaceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateWorkspaceInput(v *UpdateWorkspaceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.WorkspaceId == nil || len(*v.WorkspaceId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member workspaceId must not be empty")}
	}
	if v.WorkspaceId != nil {
		if err := encoder.SetURI("workspaceId").String(*v.WorkspaceId); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateWorkspaceInput(v *UpdateWorkspaceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Role != nil {
		ok := object.Key("role")
		ok.String(*v.Role)
	}

	return nil
}

func awsRestjson1_serializeDocumentComponentRequest(v *types.ComponentRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComponentTypeId != nil {
		ok := object.Key("componentTypeId")
		ok.String(*v.ComponentTypeId)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.Properties != nil {
		ok := object.Key("properties")
		if err := awsRestjson1_serializeDocumentPropertyRequests(v.Properties, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentComponentsMapRequest(v map[string]types.ComponentRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentComponentRequest(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentComponentUpdateRequest(v *types.ComponentUpdateRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComponentTypeId != nil {
		ok := object.Key("componentTypeId")
		ok.String(*v.ComponentTypeId)
	}

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.PropertyUpdates != nil {
		ok := object.Key("propertyUpdates")
		if err := awsRestjson1_serializeDocumentPropertyRequests(v.PropertyUpdates, ok); err != nil {
			return err
		}
	}

	if len(v.UpdateType) > 0 {
		ok := object.Key("updateType")
		ok.String(string(v.UpdateType))
	}

	return nil
}

func awsRestjson1_serializeDocumentComponentUpdatesMapRequest(v map[string]types.ComponentUpdateRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentComponentUpdateRequest(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentConfiguration(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentDataConnector(v *types.DataConnector, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IsNative != nil {
		ok := object.Key("isNative")
		ok.Boolean(*v.IsNative)
	}

	if v.Lambda != nil {
		ok := object.Key("lambda")
		if err := awsRestjson1_serializeDocumentLambdaFunction(v.Lambda, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentDataType(v *types.DataType, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AllowedValues != nil {
		ok := object.Key("allowedValues")
		if err := awsRestjson1_serializeDocumentDataValueList(v.AllowedValues, ok); err != nil {
			return err
		}
	}

	if v.NestedType != nil {
		ok := object.Key("nestedType")
		if err := awsRestjson1_serializeDocumentDataType(v.NestedType, ok); err != nil {
			return err
		}
	}

	if v.Relationship != nil {
		ok := object.Key("relationship")
		if err := awsRestjson1_serializeDocumentRelationship(v.Relationship, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("type")
		ok.String(string(v.Type))
	}

	if v.UnitOfMeasure != nil {
		ok := object.Key("unitOfMeasure")
		ok.String(*v.UnitOfMeasure)
	}

	return nil
}

func awsRestjson1_serializeDocumentDataValue(v *types.DataValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BooleanValue != nil {
		ok := object.Key("booleanValue")
		ok.Boolean(*v.BooleanValue)
	}

	if v.DoubleValue != nil {
		ok := object.Key("doubleValue")
		switch {
		case math.IsNaN(*v.DoubleValue):
			ok.String("NaN")

		case math.IsInf(*v.DoubleValue, 1):
			ok.String("Infinity")

		case math.IsInf(*v.DoubleValue, -1):
			ok.String("-Infinity")

		default:
			ok.Double(*v.DoubleValue)

		}
	}

	if v.Expression != nil {
		ok := object.Key("expression")
		ok.String(*v.Expression)
	}

	if v.IntegerValue != nil {
		ok := object.Key("integerValue")
		ok.Integer(*v.IntegerValue)
	}

	if v.ListValue != nil {
		ok := object.Key("listValue")
		if err := awsRestjson1_serializeDocumentDataValueList(v.ListValue, ok); err != nil {
			return err
		}
	}

	if v.LongValue != nil {
		ok := object.Key("longValue")
		ok.Long(*v.LongValue)
	}

	if v.MapValue != nil {
		ok := object.Key("mapValue")
		if err := awsRestjson1_serializeDocumentDataValueMap(v.MapValue, ok); err != nil {
			return err
		}
	}

	if v.RelationshipValue != nil {
		ok := object.Key("relationshipValue")
		if err := awsRestjson1_serializeDocumentRelationshipValue(v.RelationshipValue, ok); err != nil {
			return err
		}
	}

	if v.StringValue != nil {
		ok := object.Key("stringValue")
		ok.String(*v.StringValue)
	}

	return nil
}

func awsRestjson1_serializeDocumentDataValueList(v []types.DataValue, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentDataValue(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentDataValueMap(v map[string]types.DataValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentDataValue(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentEntityPropertyReference(v *types.EntityPropertyReference, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ComponentName != nil {
		ok := object.Key("componentName")
		ok.String(*v.ComponentName)
	}

	if v.EntityId != nil {
		ok := object.Key("entityId")
		ok.String(*v.EntityId)
	}

	if v.ExternalIdProperty != nil {
		ok := object.Key("externalIdProperty")
		if err := awsRestjson1_serializeDocumentExternalIdProperty(v.ExternalIdProperty, ok); err != nil {
			return err
		}
	}

	if v.PropertyName != nil {
		ok := object.Key("propertyName")
		ok.String(*v.PropertyName)
	}

	return nil
}

func awsRestjson1_serializeDocumentEntries(v []types.PropertyValueEntry, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentPropertyValueEntry(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentExtendsFrom(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentExternalIdProperty(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentFunctionRequest(v *types.FunctionRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ImplementedBy != nil {
		ok := object.Key("implementedBy")
		if err := awsRestjson1_serializeDocumentDataConnector(v.ImplementedBy, ok); err != nil {
			return err
		}
	}

	if v.RequiredProperties != nil {
		ok := object.Key("requiredProperties")
		if err := awsRestjson1_serializeDocumentRequiredProperties(v.RequiredProperties, ok); err != nil {
			return err
		}
	}

	if len(v.Scope) > 0 {
		ok := object.Key("scope")
		ok.String(string(v.Scope))
	}

	return nil
}

func awsRestjson1_serializeDocumentFunctionsRequest(v map[string]types.FunctionRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentFunctionRequest(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentInterpolationParameters(v *types.InterpolationParameters, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.InterpolationType) > 0 {
		ok := object.Key("interpolationType")
		ok.String(string(v.InterpolationType))
	}

	if v.IntervalInSeconds != nil {
		ok := object.Key("intervalInSeconds")
		ok.Long(*v.IntervalInSeconds)
	}

	return nil
}

func awsRestjson1_serializeDocumentLambdaFunction(v *types.LambdaFunction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("arn")
		ok.String(*v.Arn)
	}

	return nil
}

func awsRestjson1_serializeDocumentListComponentTypesFilter(v types.ListComponentTypesFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ListComponentTypesFilterMemberExtendsFrom:
		av := object.Key("extendsFrom")
		av.String(uv.Value)

	case *types.ListComponentTypesFilterMemberIsAbstract:
		av := object.Key("isAbstract")
		av.Boolean(uv.Value)

	case *types.ListComponentTypesFilterMemberNamespace:
		av := object.Key("namespace")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentListComponentTypesFilters(v []types.ListComponentTypesFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentListComponentTypesFilter(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentListEntitiesFilter(v types.ListEntitiesFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	switch uv := v.(type) {
	case *types.ListEntitiesFilterMemberComponentTypeId:
		av := object.Key("componentTypeId")
		av.String(uv.Value)

	case *types.ListEntitiesFilterMemberParentEntityId:
		av := object.Key("parentEntityId")
		av.String(uv.Value)

	default:
		return fmt.Errorf("attempted to serialize unknown member type %T for union %T", uv, v)

	}
	return nil
}

func awsRestjson1_serializeDocumentListEntitiesFilters(v []types.ListEntitiesFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if vv := v[i]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentListEntitiesFilter(v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentParentEntityUpdateRequest(v *types.ParentEntityUpdateRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ParentEntityId != nil {
		ok := object.Key("parentEntityId")
		ok.String(*v.ParentEntityId)
	}

	if len(v.UpdateType) > 0 {
		ok := object.Key("updateType")
		ok.String(string(v.UpdateType))
	}

	return nil
}

func awsRestjson1_serializeDocumentPropertyDefinitionRequest(v *types.PropertyDefinitionRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Configuration != nil {
		ok := object.Key("configuration")
		if err := awsRestjson1_serializeDocumentConfiguration(v.Configuration, ok); err != nil {
			return err
		}
	}

	if v.DataType != nil {
		ok := object.Key("dataType")
		if err := awsRestjson1_serializeDocumentDataType(v.DataType, ok); err != nil {
			return err
		}
	}

	if v.DefaultValue != nil {
		ok := object.Key("defaultValue")
		if err := awsRestjson1_serializeDocumentDataValue(v.DefaultValue, ok); err != nil {
			return err
		}
	}

	if v.IsExternalId != nil {
		ok := object.Key("isExternalId")
		ok.Boolean(*v.IsExternalId)
	}

	if v.IsRequiredInEntity != nil {
		ok := object.Key("isRequiredInEntity")
		ok.Boolean(*v.IsRequiredInEntity)
	}

	if v.IsStoredExternally != nil {
		ok := object.Key("isStoredExternally")
		ok.Boolean(*v.IsStoredExternally)
	}

	if v.IsTimeSeries != nil {
		ok := object.Key("isTimeSeries")
		ok.Boolean(*v.IsTimeSeries)
	}

	return nil
}

func awsRestjson1_serializeDocumentPropertyDefinitionsRequest(v map[string]types.PropertyDefinitionRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentPropertyDefinitionRequest(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPropertyFilter(v *types.PropertyFilter, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Operator != nil {
		ok := object.Key("operator")
		ok.String(*v.Operator)
	}

	if v.PropertyName != nil {
		ok := object.Key("propertyName")
		ok.String(*v.PropertyName)
	}

	if v.Value != nil {
		ok := object.Key("value")
		if err := awsRestjson1_serializeDocumentDataValue(v.Value, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPropertyFilters(v []types.PropertyFilter, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentPropertyFilter(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPropertyRequest(v *types.PropertyRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Definition != nil {
		ok := object.Key("definition")
		if err := awsRestjson1_serializeDocumentPropertyDefinitionRequest(v.Definition, ok); err != nil {
			return err
		}
	}

	if len(v.UpdateType) > 0 {
		ok := object.Key("updateType")
		ok.String(string(v.UpdateType))
	}

	if v.Value != nil {
		ok := object.Key("value")
		if err := awsRestjson1_serializeDocumentDataValue(v.Value, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPropertyRequests(v map[string]types.PropertyRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentPropertyRequest(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentPropertyValue(v *types.PropertyValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Timestamp != nil {
		ok := object.Key("timestamp")
		ok.Double(smithytime.FormatEpochSeconds(*v.Timestamp))
	}

	if v.Value != nil {
		ok := object.Key("value")
		if err := awsRestjson1_serializeDocumentDataValue(v.Value, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPropertyValueEntry(v *types.PropertyValueEntry, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EntityPropertyReference != nil {
		ok := object.Key("entityPropertyReference")
		if err := awsRestjson1_serializeDocumentEntityPropertyReference(v.EntityPropertyReference, ok); err != nil {
			return err
		}
	}

	if v.PropertyValues != nil {
		ok := object.Key("propertyValues")
		if err := awsRestjson1_serializeDocumentPropertyValues(v.PropertyValues, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPropertyValues(v []types.PropertyValue, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentPropertyValue(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRelationship(v *types.Relationship, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RelationshipType != nil {
		ok := object.Key("relationshipType")
		ok.String(*v.RelationshipType)
	}

	if v.TargetComponentTypeId != nil {
		ok := object.Key("targetComponentTypeId")
		ok.String(*v.TargetComponentTypeId)
	}

	return nil
}

func awsRestjson1_serializeDocumentRelationshipValue(v *types.RelationshipValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TargetComponentName != nil {
		ok := object.Key("targetComponentName")
		ok.String(*v.TargetComponentName)
	}

	if v.TargetEntityId != nil {
		ok := object.Key("targetEntityId")
		ok.String(*v.TargetEntityId)
	}

	return nil
}

func awsRestjson1_serializeDocumentRequiredProperties(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSceneCapabilities(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentSelectedPropertyList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentTagMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}
