// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Describes one or more of your network insights analyses.
func (c *Client) DescribeNetworkInsightsAnalyses(ctx context.Context, params *DescribeNetworkInsightsAnalysesInput, optFns ...func(*Options)) (*DescribeNetworkInsightsAnalysesOutput, error) {
	if params == nil {
		params = &DescribeNetworkInsightsAnalysesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeNetworkInsightsAnalyses", params, optFns, c.addOperationDescribeNetworkInsightsAnalysesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeNetworkInsightsAnalysesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeNetworkInsightsAnalysesInput struct {

	// The time when the network insights analyses ended.
	AnalysisEndTime *time.Time

	// The time when the network insights analyses started.
	AnalysisStartTime *time.Time

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation. Otherwise, it is
	// UnauthorizedOperation.
	DryRun *bool

	// The filters. The following are possible values:
	//
	// * PathFound - A Boolean value
	// that indicates whether a feasible path is found.
	//
	// * Status - The status of the
	// analysis (running | succeeded | failed).
	Filters []types.Filter

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int32

	// The ID of the network insights analyses. You must specify either analysis IDs or
	// a path ID.
	NetworkInsightsAnalysisIds []string

	// The ID of the path. You must specify either a path ID or analysis IDs.
	NetworkInsightsPathId *string

	// The token for the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type DescribeNetworkInsightsAnalysesOutput struct {

	// Information about the network insights analyses.
	NetworkInsightsAnalyses []types.NetworkInsightsAnalysis

	// The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeNetworkInsightsAnalysesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsEc2query_serializeOpDescribeNetworkInsightsAnalyses{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpDescribeNetworkInsightsAnalyses{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeNetworkInsightsAnalyses(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// DescribeNetworkInsightsAnalysesAPIClient is a client that implements the
// DescribeNetworkInsightsAnalyses operation.
type DescribeNetworkInsightsAnalysesAPIClient interface {
	DescribeNetworkInsightsAnalyses(context.Context, *DescribeNetworkInsightsAnalysesInput, ...func(*Options)) (*DescribeNetworkInsightsAnalysesOutput, error)
}

var _ DescribeNetworkInsightsAnalysesAPIClient = (*Client)(nil)

// DescribeNetworkInsightsAnalysesPaginatorOptions is the paginator options for
// DescribeNetworkInsightsAnalyses
type DescribeNetworkInsightsAnalysesPaginatorOptions struct {
	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// DescribeNetworkInsightsAnalysesPaginator is a paginator for
// DescribeNetworkInsightsAnalyses
type DescribeNetworkInsightsAnalysesPaginator struct {
	options   DescribeNetworkInsightsAnalysesPaginatorOptions
	client    DescribeNetworkInsightsAnalysesAPIClient
	params    *DescribeNetworkInsightsAnalysesInput
	nextToken *string
	firstPage bool
}

// NewDescribeNetworkInsightsAnalysesPaginator returns a new
// DescribeNetworkInsightsAnalysesPaginator
func NewDescribeNetworkInsightsAnalysesPaginator(client DescribeNetworkInsightsAnalysesAPIClient, params *DescribeNetworkInsightsAnalysesInput, optFns ...func(*DescribeNetworkInsightsAnalysesPaginatorOptions)) *DescribeNetworkInsightsAnalysesPaginator {
	if params == nil {
		params = &DescribeNetworkInsightsAnalysesInput{}
	}

	options := DescribeNetworkInsightsAnalysesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &DescribeNetworkInsightsAnalysesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *DescribeNetworkInsightsAnalysesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next DescribeNetworkInsightsAnalyses page.
func (p *DescribeNetworkInsightsAnalysesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*DescribeNetworkInsightsAnalysesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.DescribeNetworkInsightsAnalyses(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opDescribeNetworkInsightsAnalyses(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "ec2",
		OperationName: "DescribeNetworkInsightsAnalyses",
	}
}
