// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Specifies the minimum and maximum for the AcceleratorCount object when you
// specify InstanceRequirements for an Auto Scaling group.
type AcceleratorCountRequest struct {

	// The maximum value.
	Max *int32

	// The minimum value.
	Min *int32

	noSmithyDocumentSerde
}

// Specifies the minimum and maximum for the AcceleratorTotalMemoryMiB object when
// you specify InstanceRequirements for an Auto Scaling group.
type AcceleratorTotalMemoryMiBRequest struct {

	// The memory maximum in MiB.
	Max *int32

	// The memory minimum in MiB.
	Min *int32

	noSmithyDocumentSerde
}

// Describes scaling activity, which is a long-running process that represents a
// change to your Auto Scaling group, such as changing its size or replacing an
// instance.
type Activity struct {

	// The ID of the activity.
	//
	// This member is required.
	ActivityId *string

	// The name of the Auto Scaling group.
	//
	// This member is required.
	AutoScalingGroupName *string

	// The reason the activity began.
	//
	// This member is required.
	Cause *string

	// The start time of the activity.
	//
	// This member is required.
	StartTime *time.Time

	// The current status of the activity.
	//
	// This member is required.
	StatusCode ScalingActivityStatusCode

	// The Amazon Resource Name (ARN) of the Auto Scaling group.
	AutoScalingGroupARN *string

	// The state of the Auto Scaling group, which is either InService or Deleted.
	AutoScalingGroupState *string

	// A friendly, more verbose description of the activity.
	Description *string

	// The details about the activity.
	Details *string

	// The end time of the activity.
	EndTime *time.Time

	// A value between 0 and 100 that indicates the progress of the activity.
	Progress int32

	// A friendly, more verbose description of the activity status.
	StatusMessage *string

	noSmithyDocumentSerde
}

// Describes a policy adjustment type.
type AdjustmentType struct {

	// The policy adjustment type. The valid values are ChangeInCapacity,
	// ExactCapacity, and PercentChangeInCapacity.
	AdjustmentType *string

	noSmithyDocumentSerde
}

// Describes an alarm.
type Alarm struct {

	// The Amazon Resource Name (ARN) of the alarm.
	AlarmARN *string

	// The name of the alarm.
	AlarmName *string

	noSmithyDocumentSerde
}

// Describes an Auto Scaling group.
type AutoScalingGroup struct {

	// The name of the Auto Scaling group.
	//
	// This member is required.
	AutoScalingGroupName *string

	// One or more Availability Zones for the group.
	//
	// This member is required.
	AvailabilityZones []string

	// The date and time the group was created.
	//
	// This member is required.
	CreatedTime *time.Time

	// The duration of the default cooldown period, in seconds.
	//
	// This member is required.
	DefaultCooldown *int32

	// The desired size of the group.
	//
	// This member is required.
	DesiredCapacity *int32

	// The service to use for the health checks. The valid values are EC2 and ELB. If
	// you configure an Auto Scaling group to use ELB health checks, it considers the
	// instance unhealthy if it fails either the EC2 status checks or the load balancer
	// health checks.
	//
	// This member is required.
	HealthCheckType *string

	// The maximum size of the group.
	//
	// This member is required.
	MaxSize *int32

	// The minimum size of the group.
	//
	// This member is required.
	MinSize *int32

	// The Amazon Resource Name (ARN) of the Auto Scaling group.
	AutoScalingGroupARN *string

	// Indicates whether Capacity Rebalancing is enabled.
	CapacityRebalance *bool

	// Reserved.
	Context *string

	// The unit of measurement for the value specified for desired capacity. Amazon EC2
	// Auto Scaling supports DesiredCapacityType for attribute-based instance type
	// selection only. For more information, see Creating an Auto Scaling group using
	// attribute-based instance type selection
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html)
	// in the Amazon EC2 Auto Scaling User Guide. By default, Amazon EC2 Auto Scaling
	// specifies units, which translates into number of instances. Valid values: units
	// | vcpu | memory-mib
	DesiredCapacityType *string

	// The metrics enabled for the group.
	EnabledMetrics []EnabledMetric

	// The amount of time, in seconds, that Amazon EC2 Auto Scaling waits before
	// checking the health status of an EC2 instance that has come into service and
	// marking it unhealthy due to a failed health check.
	HealthCheckGracePeriod *int32

	// The EC2 instances associated with the group.
	Instances []Instance

	// The name of the associated launch configuration.
	LaunchConfigurationName *string

	// The launch template for the group.
	LaunchTemplate *LaunchTemplateSpecification

	// One or more load balancers associated with the group.
	LoadBalancerNames []string

	// The maximum amount of time, in seconds, that an instance can be in service.
	// Valid Range: Minimum value of 0.
	MaxInstanceLifetime *int32

	// The mixed instances policy for the group.
	MixedInstancesPolicy *MixedInstancesPolicy

	// Indicates whether newly launched instances are protected from termination by
	// Amazon EC2 Auto Scaling when scaling in.
	NewInstancesProtectedFromScaleIn *bool

	// The name of the placement group into which to launch your instances, if any.
	PlacementGroup *string

	// The predicted capacity of the group when it has a predictive scaling policy.
	PredictedCapacity *int32

	// The Amazon Resource Name (ARN) of the service-linked role that the Auto Scaling
	// group uses to call other Amazon Web Services on your behalf.
	ServiceLinkedRoleARN *string

	// The current state of the group when the DeleteAutoScalingGroup operation is in
	// progress.
	Status *string

	// The suspended processes associated with the group.
	SuspendedProcesses []SuspendedProcess

	// The tags for the group.
	Tags []TagDescription

	// The Amazon Resource Names (ARN) of the target groups for your load balancer.
	TargetGroupARNs []string

	// The termination policies for the group.
	TerminationPolicies []string

	// One or more subnet IDs, if applicable, separated by commas.
	VPCZoneIdentifier *string

	// The warm pool for the group.
	WarmPoolConfiguration *WarmPoolConfiguration

	// The current size of the warm pool.
	WarmPoolSize *int32

	noSmithyDocumentSerde
}

// Describes an EC2 instance associated with an Auto Scaling group.
type AutoScalingInstanceDetails struct {

	// The name of the Auto Scaling group for the instance.
	//
	// This member is required.
	AutoScalingGroupName *string

	// The Availability Zone for the instance.
	//
	// This member is required.
	AvailabilityZone *string

	// The last reported health status of this instance. "Healthy" means that the
	// instance is healthy and should remain in service. "Unhealthy" means that the
	// instance is unhealthy and Amazon EC2 Auto Scaling should terminate and replace
	// it.
	//
	// This member is required.
	HealthStatus *string

	// The ID of the instance.
	//
	// This member is required.
	InstanceId *string

	// The lifecycle state for the instance. The Quarantined state is not used. For
	// information about lifecycle states, see Instance lifecycle
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroupLifecycle.html)
	// in the Amazon EC2 Auto Scaling User Guide. Valid Values: Pending | Pending:Wait
	// | Pending:Proceed | Quarantined | InService | Terminating | Terminating:Wait |
	// Terminating:Proceed | Terminated | Detaching | Detached | EnteringStandby |
	// Standby | Warmed:Pending | Warmed:Pending:Wait | Warmed:Pending:Proceed |
	// Warmed:Terminating | Warmed:Terminating:Wait | Warmed:Terminating:Proceed |
	// Warmed:Terminated | Warmed:Stopped | Warmed:Running
	//
	// This member is required.
	LifecycleState *string

	// Indicates whether the instance is protected from termination by Amazon EC2 Auto
	// Scaling when scaling in.
	//
	// This member is required.
	ProtectedFromScaleIn *bool

	// The instance type of the EC2 instance.
	InstanceType *string

	// The launch configuration used to launch the instance. This value is not
	// available if you attached the instance to the Auto Scaling group.
	LaunchConfigurationName *string

	// The launch template for the instance.
	LaunchTemplate *LaunchTemplateSpecification

	// The number of capacity units contributed by the instance based on its instance
	// type. Valid Range: Minimum value of 1. Maximum value of 999.
	WeightedCapacity *string

	noSmithyDocumentSerde
}

// Specifies the minimum and maximum for the BaselineEbsBandwidthMbps object when
// you specify InstanceRequirements for an Auto Scaling group.
type BaselineEbsBandwidthMbpsRequest struct {

	// The maximum value in Mbps.
	Max *int32

	// The minimum value in Mbps.
	Min *int32

	noSmithyDocumentSerde
}

// Describes a block device mapping.
type BlockDeviceMapping struct {

	// The device name exposed to the EC2 instance (for example, /dev/sdh or xvdh). For
	// more information, see Device Naming on Linux Instances
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/device_naming.html) in the
	// Amazon EC2 User Guide for Linux Instances.
	//
	// This member is required.
	DeviceName *string

	// Parameters used to automatically set up EBS volumes when an instance is
	// launched. You can specify either VirtualName or Ebs, but not both.
	Ebs *Ebs

	// Setting this value to true suppresses the specified device included in the block
	// device mapping of the AMI. If NoDevice is true for the root device, instances
	// might fail the EC2 health check. In that case, Amazon EC2 Auto Scaling launches
	// replacement instances. If you specify NoDevice, you cannot specify Ebs.
	NoDevice *bool

	// The name of the virtual device (for example, ephemeral0). You can specify either
	// VirtualName or Ebs, but not both.
	VirtualName *string

	noSmithyDocumentSerde
}

// A GetPredictiveScalingForecast call returns the capacity forecast for a
// predictive scaling policy. This structure includes the data points for that
// capacity forecast, along with the timestamps of those data points.
type CapacityForecast struct {

	// The timestamps for the data points, in UTC format.
	//
	// This member is required.
	Timestamps []time.Time

	// The values of the data points.
	//
	// This member is required.
	Values []float64

	noSmithyDocumentSerde
}

// Represents a CloudWatch metric of your choosing for a target tracking scaling
// policy to use with Amazon EC2 Auto Scaling. To create your customized metric
// specification:
//
// * Add values for each required parameter from CloudWatch. You
// can use an existing metric, or a new metric that you create. To use your own
// metric, you must first publish the metric to CloudWatch. For more information,
// see Publish custom metrics
// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/publishingMetrics.html)
// in the Amazon CloudWatch User Guide.
//
// * Choose a metric that changes
// proportionally with capacity. The value of the metric should increase or
// decrease in inverse proportion to the number of capacity units. That is, the
// value of the metric should decrease when capacity increases.
//
// For more
// information about the CloudWatch terminology below, see Amazon CloudWatch
// concepts
// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html).
// Each individual service provides information about the metrics, namespace, and
// dimensions they use. For more information, see Amazon Web Services services that
// publish CloudWatch metrics
// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html)
// in the Amazon CloudWatch User Guide.
type CustomizedMetricSpecification struct {

	// The name of the metric. To get the exact metric name, namespace, and dimensions,
	// inspect the Metric
	// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html)
	// object that is returned by a call to ListMetrics
	// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html).
	//
	// This member is required.
	MetricName *string

	// The namespace of the metric.
	//
	// This member is required.
	Namespace *string

	// The statistic of the metric.
	//
	// This member is required.
	Statistic MetricStatistic

	// The dimensions of the metric. Conditional: If you published your metric with
	// dimensions, you must specify the same dimensions in your scaling policy.
	Dimensions []MetricDimension

	// The unit of the metric. For a complete list of the units that CloudWatch
	// supports, see the MetricDatum
	// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html)
	// data type in the Amazon CloudWatch API Reference.
	Unit *string

	noSmithyDocumentSerde
}

// Describes the desired configuration for an instance refresh. If you specify a
// desired configuration, you must specify either a LaunchTemplate or a
// MixedInstancesPolicy.
type DesiredConfiguration struct {

	// Describes the launch template and the version of the launch template that Amazon
	// EC2 Auto Scaling uses to launch Amazon EC2 instances. For more information about
	// launch templates, see Launch templates
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/LaunchTemplates.html) in
	// the Amazon EC2 Auto Scaling User Guide.
	LaunchTemplate *LaunchTemplateSpecification

	// Describes a mixed instances policy. A mixed instances policy contains the
	// instance types that Amazon EC2 Auto Scaling can launch and other information
	// that Amazon EC2 Auto Scaling can use to launch instances and help optimize your
	// costs. For more information, see Auto Scaling groups with multiple instance
	// types and purchase options
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	MixedInstancesPolicy *MixedInstancesPolicy

	noSmithyDocumentSerde
}

// Describes information used to set up an Amazon EBS volume specified in a block
// device mapping.
type Ebs struct {

	// Indicates whether the volume is deleted on instance termination. For Amazon EC2
	// Auto Scaling, the default value is true.
	DeleteOnTermination *bool

	// Specifies whether the volume should be encrypted. Encrypted EBS volumes can only
	// be attached to instances that support Amazon EBS encryption. For more
	// information, see Supported instance types
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances).
	// If your AMI uses encrypted volumes, you can also only launch it on supported
	// instance types. If you are creating a volume from a snapshot, you cannot create
	// an unencrypted volume from an encrypted snapshot. Also, you cannot specify a KMS
	// key ID when using a launch configuration. If you enable encryption by default,
	// the EBS volumes that you create are always encrypted, either using the Amazon
	// Web Services managed KMS key or a customer-managed KMS key, regardless of
	// whether the snapshot was encrypted. For more information, see Using Amazon Web
	// Services KMS keys to encrypt Amazon EBS volumes
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-data-protection.html#encryption)
	// in the Amazon EC2 Auto Scaling User Guide.
	Encrypted *bool

	// The number of input/output (I/O) operations per second (IOPS) to provision for
	// the volume. For gp3 and io1 volumes, this represents the number of IOPS that are
	// provisioned for the volume. For gp2 volumes, this represents the baseline
	// performance of the volume and the rate at which the volume accumulates I/O
	// credits for bursting. The following are the supported values for each volume
	// type:
	//
	// * gp3: 3,000-16,000 IOPS
	//
	// * io1: 100-64,000 IOPS
	//
	// For io1 volumes, we
	// guarantee 64,000 IOPS only for Instances built on the Nitro System
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances).
	// Other instance families guarantee performance up to 32,000 IOPS. Iops is
	// supported when the volume type is gp3 or io1 and required only when the volume
	// type is io1. (Not used with standard, gp2, st1, or sc1 volumes.)
	Iops *int32

	// The snapshot ID of the volume to use. You must specify either a VolumeSize or a
	// SnapshotId.
	SnapshotId *string

	// The throughput (MiBps) to provision for a gp3 volume.
	Throughput *int32

	// The volume size, in GiBs. The following are the supported volumes sizes for each
	// volume type:
	//
	// * gp2 and gp3: 1-16,384
	//
	// * io1: 4-16,384
	//
	// * st1 and sc1:
	// 125-16,384
	//
	// * standard: 1-1,024
	//
	// You must specify either a SnapshotId or a
	// VolumeSize. If you specify both SnapshotId and VolumeSize, the volume size must
	// be equal or greater than the size of the snapshot.
	VolumeSize *int32

	// The volume type. For more information, see Amazon EBS volume types
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html) in the
	// Amazon EC2 User Guide for Linux Instances. Valid Values: standard | io1 | gp2 |
	// st1 | sc1 | gp3
	VolumeType *string

	noSmithyDocumentSerde
}

// Describes an enabled metric.
type EnabledMetric struct {

	// The granularity of the metric. The only valid value is 1Minute.
	Granularity *string

	// One of the following metrics:
	//
	// * GroupMinSize
	//
	// * GroupMaxSize
	//
	// *
	// GroupDesiredCapacity
	//
	// * GroupInServiceInstances
	//
	// * GroupPendingInstances
	//
	// *
	// GroupStandbyInstances
	//
	// * GroupTerminatingInstances
	//
	// * GroupTotalInstances
	//
	// *
	// GroupInServiceCapacity
	//
	// * GroupPendingCapacity
	//
	// * GroupStandbyCapacity
	//
	// *
	// GroupTerminatingCapacity
	//
	// * GroupTotalCapacity
	//
	// * WarmPoolDesiredCapacity
	//
	// *
	// WarmPoolWarmedCapacity
	//
	// * WarmPoolPendingCapacity
	//
	// *
	// WarmPoolTerminatingCapacity
	//
	// * WarmPoolTotalCapacity
	//
	// *
	// GroupAndWarmPoolDesiredCapacity
	//
	// * GroupAndWarmPoolTotalCapacity
	Metric *string

	noSmithyDocumentSerde
}

// Describes a scheduled action that could not be created, updated, or deleted.
type FailedScheduledUpdateGroupActionRequest struct {

	// The name of the scheduled action.
	//
	// This member is required.
	ScheduledActionName *string

	// The error code.
	ErrorCode *string

	// The error message accompanying the error code.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// Describes a filter that is used to return a more specific list of results from a
// describe operation. If you specify multiple filters, the filters are
// automatically logically joined with an AND, and the request returns only the
// results that match all of the specified filters. For more information, see
// Tagging Auto Scaling groups and instances
// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-tagging.html)
// in the Amazon EC2 Auto Scaling User Guide.
type Filter struct {

	// The name of the filter. The valid values for Name depend on which API operation
	// you're using with the filter (DescribeAutoScalingGroups or DescribeTags).
	// DescribeAutoScalingGroups Valid values for Name include the following:
	//
	// *
	// tag-key - Accepts tag keys. The results only include information about the Auto
	// Scaling groups associated with these tag keys.
	//
	// * tag-value - Accepts tag
	// values. The results only include information about the Auto Scaling groups
	// associated with these tag values.
	//
	// * tag: - Accepts the key/value combination of
	// the tag. Use the tag key in the filter name and the tag value as the filter
	// value. The results only include information about the Auto Scaling groups
	// associated with the specified key/value combination.
	//
	// DescribeTags Valid values
	// for Name include the following:
	//
	// * auto-scaling-group - Accepts the names of
	// Auto Scaling groups. The results only include information about the tags
	// associated with these Auto Scaling groups.
	//
	// * key - Accepts tag keys. The
	// results only include information about the tags associated with these tag
	// keys.
	//
	// * value - Accepts tag values. The results only include information about
	// the tags associated with these tag values.
	//
	// * propagate-at-launch - Accepts a
	// Boolean value, which specifies whether tags propagate to instances at launch.
	// The results only include information about the tags associated with the
	// specified Boolean value.
	Name *string

	// One or more filter values. Filter values are case-sensitive. If you specify
	// multiple values for a filter, the values are automatically logically joined with
	// an OR, and the request returns all results that match any of the specified
	// values. For example, specify "tag:environment" for the filter name and
	// "production,development" for the filter values to find Auto Scaling groups with
	// the tag "environment=production" or "environment=development".
	Values []string

	noSmithyDocumentSerde
}

// Describes an EC2 instance.
type Instance struct {

	// The Availability Zone in which the instance is running.
	//
	// This member is required.
	AvailabilityZone *string

	// The last reported health status of the instance. "Healthy" means that the
	// instance is healthy and should remain in service. "Unhealthy" means that the
	// instance is unhealthy and that Amazon EC2 Auto Scaling should terminate and
	// replace it.
	//
	// This member is required.
	HealthStatus *string

	// The ID of the instance.
	//
	// This member is required.
	InstanceId *string

	// A description of the current lifecycle state. The Quarantined state is not used.
	// For information about lifecycle states, see Instance lifecycle
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroupLifecycle.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	//
	// This member is required.
	LifecycleState LifecycleState

	// Indicates whether the instance is protected from termination by Amazon EC2 Auto
	// Scaling when scaling in.
	//
	// This member is required.
	ProtectedFromScaleIn *bool

	// The instance type of the EC2 instance.
	InstanceType *string

	// The launch configuration associated with the instance.
	LaunchConfigurationName *string

	// The launch template for the instance.
	LaunchTemplate *LaunchTemplateSpecification

	// The number of capacity units contributed by the instance based on its instance
	// type. Valid Range: Minimum value of 1. Maximum value of 999.
	WeightedCapacity *string

	noSmithyDocumentSerde
}

// The metadata options for the instances. For more information, see Configuring
// the Instance Metadata Options
// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds)
// in the Amazon EC2 Auto Scaling User Guide.
type InstanceMetadataOptions struct {

	// This parameter enables or disables the HTTP metadata endpoint on your instances.
	// If the parameter is not specified, the default state is enabled. If you specify
	// a value of disabled, you will not be able to access your instance metadata.
	HttpEndpoint InstanceMetadataEndpointState

	// The desired HTTP PUT response hop limit for instance metadata requests. The
	// larger the number, the further instance metadata requests can travel. Default: 1
	HttpPutResponseHopLimit *int32

	// The state of token usage for your instance metadata requests. If the parameter
	// is not specified in the request, the default state is optional. If the state is
	// optional, you can choose to retrieve instance metadata with or without a signed
	// token header on your request. If you retrieve the IAM role credentials without a
	// token, the version 1.0 role credentials are returned. If you retrieve the IAM
	// role credentials using a valid signed token, the version 2.0 role credentials
	// are returned. If the state is required, you must send a signed token header with
	// any instance metadata retrieval requests. In this state, retrieving the IAM role
	// credentials always returns the version 2.0 credentials; the version 1.0
	// credentials are not available.
	HttpTokens InstanceMetadataHttpTokensState

	noSmithyDocumentSerde
}

// Describes whether detailed monitoring is enabled for the Auto Scaling instances.
type InstanceMonitoring struct {

	// If true, detailed monitoring is enabled. Otherwise, basic monitoring is enabled.
	Enabled *bool

	noSmithyDocumentSerde
}

// Describes an instance refresh for an Auto Scaling group.
type InstanceRefresh struct {

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string

	// Describes the specific update you want to deploy.
	DesiredConfiguration *DesiredConfiguration

	// The date and time at which the instance refresh ended.
	EndTime *time.Time

	// The instance refresh ID.
	InstanceRefreshId *string

	// The number of instances remaining to update before the instance refresh is
	// complete.
	InstancesToUpdate *int32

	// The percentage of the instance refresh that is complete. For each instance
	// replacement, Amazon EC2 Auto Scaling tracks the instance's health status and
	// warm-up time. When the instance's health status changes to healthy and the
	// specified warm-up time passes, the instance is considered updated and is added
	// to the percentage complete.
	PercentageComplete *int32

	// Describes the preferences for an instance refresh.
	Preferences *RefreshPreferences

	// Additional progress details for an Auto Scaling group that has a warm pool.
	ProgressDetails *InstanceRefreshProgressDetails

	// The date and time at which the instance refresh began.
	StartTime *time.Time

	// The current status for the instance refresh operation:
	//
	// * Pending - The request
	// was created, but the operation has not started.
	//
	// * InProgress - The operation is
	// in progress.
	//
	// * Successful - The operation completed successfully.
	//
	// * Failed -
	// The operation failed to complete. You can troubleshoot using the status reason
	// and the scaling activities.
	//
	// * Cancelling - An ongoing operation is being
	// cancelled. Cancellation does not roll back any replacements that have already
	// been completed, but it prevents new replacements from being started.
	//
	// *
	// Cancelled - The operation is cancelled.
	Status InstanceRefreshStatus

	// Provides more details about the current status of the instance refresh.
	StatusReason *string

	noSmithyDocumentSerde
}

// Reports the progress of an instance refresh on instances that are in the Auto
// Scaling group.
type InstanceRefreshLivePoolProgress struct {

	// The number of instances remaining to update.
	InstancesToUpdate *int32

	// The percentage of instances in the Auto Scaling group that have been replaced.
	// For each instance replacement, Amazon EC2 Auto Scaling tracks the instance's
	// health status and warm-up time. When the instance's health status changes to
	// healthy and the specified warm-up time passes, the instance is considered
	// updated and is added to the percentage complete.
	PercentageComplete *int32

	noSmithyDocumentSerde
}

// Reports the progress of an instance refresh on an Auto Scaling group that has a
// warm pool. This includes separate details for instances in the warm pool and
// instances in the Auto Scaling group (the live pool).
type InstanceRefreshProgressDetails struct {

	// Indicates the progress of an instance refresh on instances that are in the Auto
	// Scaling group.
	LivePoolProgress *InstanceRefreshLivePoolProgress

	// Indicates the progress of an instance refresh on instances that are in the warm
	// pool.
	WarmPoolProgress *InstanceRefreshWarmPoolProgress

	noSmithyDocumentSerde
}

// Reports the progress of an instance refresh on instances that are in the warm
// pool.
type InstanceRefreshWarmPoolProgress struct {

	// The number of instances remaining to update.
	InstancesToUpdate *int32

	// The percentage of instances in the warm pool that have been replaced. For each
	// instance replacement, Amazon EC2 Auto Scaling tracks the instance's health
	// status and warm-up time. When the instance's health status changes to healthy
	// and the specified warm-up time passes, the instance is considered updated and is
	// added to the percentage complete.
	PercentageComplete *int32

	noSmithyDocumentSerde
}

// When you specify multiple parameters, you get instance types that satisfy all of
// the specified parameters. If you specify multiple values for a parameter, you
// get instance types that satisfy any of the specified values. Represents
// requirements for the types of instances that can be launched. You must specify
// VCpuCount and MemoryMiB, but all other parameters are optional. For more
// information, see Creating an Auto Scaling group using attribute-based instance
// type selection
// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-asg-instance-type-requirements.html)
// in the Amazon EC2 Auto Scaling User Guide.
type InstanceRequirements struct {

	// The minimum and maximum instance memory size for an instance type, in MiB.
	//
	// This member is required.
	MemoryMiB *MemoryMiBRequest

	// The minimum and maximum number of vCPUs for an instance type.
	//
	// This member is required.
	VCpuCount *VCpuCountRequest

	// The minimum and maximum number of accelerators (GPUs, FPGAs, or Amazon Web
	// Services Inferentia chips) for an instance type. To exclude accelerator-enabled
	// instance types, set Max to 0. Default: No minimum or maximum
	AcceleratorCount *AcceleratorCountRequest

	// Indicates whether instance types must have accelerators by specific
	// manufacturers.
	//
	// * For instance types with NVIDIA devices, specify nvidia.
	//
	// * For
	// instance types with AMD devices, specify amd.
	//
	// * For instance types with Amazon
	// Web Services devices, specify amazon-web-services.
	//
	// * For instance types with
	// Xilinx devices, specify xilinx.
	//
	// Default: Any manufacturer
	AcceleratorManufacturers []AcceleratorManufacturer

	// Lists the accelerators that must be on an instance type.
	//
	// * For instance types
	// with NVIDIA A100 GPUs, specify a100.
	//
	// * For instance types with NVIDIA V100
	// GPUs, specify v100.
	//
	// * For instance types with NVIDIA K80 GPUs, specify k80.
	//
	// *
	// For instance types with NVIDIA T4 GPUs, specify t4.
	//
	// * For instance types with
	// NVIDIA M60 GPUs, specify m60.
	//
	// * For instance types with AMD Radeon Pro V520
	// GPUs, specify radeon-pro-v520.
	//
	// * For instance types with Xilinx VU9P FPGAs,
	// specify vu9p.
	//
	// Default: Any accelerator
	AcceleratorNames []AcceleratorName

	// The minimum and maximum total memory size for the accelerators on an instance
	// type, in MiB. Default: No minimum or maximum
	AcceleratorTotalMemoryMiB *AcceleratorTotalMemoryMiBRequest

	// Lists the accelerator types that must be on an instance type.
	//
	// * For instance
	// types with GPU accelerators, specify gpu.
	//
	// * For instance types with FPGA
	// accelerators, specify fpga.
	//
	// * For instance types with inference accelerators,
	// specify inference.
	//
	// Default: Any accelerator type
	AcceleratorTypes []AcceleratorType

	// Indicates whether bare metal instance types are included, excluded, or required.
	// Default: excluded
	BareMetal BareMetal

	// The minimum and maximum baseline bandwidth performance for an instance type, in
	// Mbps. For more information, see Amazon EBS–optimized instances
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-optimized.html) in the
	// Amazon EC2 User Guide for Linux Instances. Default: No minimum or maximum
	BaselineEbsBandwidthMbps *BaselineEbsBandwidthMbpsRequest

	// Indicates whether burstable performance instance types are included, excluded,
	// or required. For more information, see Burstable performance instances
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html)
	// in the Amazon EC2 User Guide for Linux Instances. Default: excluded
	BurstablePerformance BurstablePerformance

	// Lists which specific CPU manufacturers to include.
	//
	// * For instance types with
	// Intel CPUs, specify intel.
	//
	// * For instance types with AMD CPUs, specify amd.
	//
	// *
	// For instance types with Amazon Web Services CPUs, specify
	// amazon-web-services.
	//
	// Don't confuse the CPU hardware manufacturer with the CPU
	// hardware architecture. Instances will be launched with a compatible CPU
	// architecture based on the Amazon Machine Image (AMI) that you specify in your
	// launch template. Default: Any manufacturer
	CpuManufacturers []CpuManufacturer

	// Lists which instance types to exclude. You can use strings with one or more wild
	// cards, represented by an asterisk (*). The following are examples: c5*, m5a.*,
	// r*, *3*. For example, if you specify c5*, you are excluding the entire C5
	// instance family, which includes all C5a and C5n instance types. If you specify
	// m5a.*, you are excluding all the M5a instance types, but not the M5n instance
	// types. Default: No excluded instance types
	ExcludedInstanceTypes []string

	// Indicates whether current or previous generation instance types are included.
	//
	// *
	// For current generation instance types, specify current. The current generation
	// includes EC2 instance types currently recommended for use. This typically
	// includes the latest two to three generations in each instance family. For more
	// information, see Instance types
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the
	// Amazon EC2 User Guide for Linux Instances.
	//
	// * For previous generation instance
	// types, specify previous.
	//
	// Default: Any current or previous generation
	InstanceGenerations []InstanceGeneration

	// Indicates whether instance types with instance store volumes are included,
	// excluded, or required. For more information, see Amazon EC2 instance store
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/InstanceStorage.html) in
	// the Amazon EC2 User Guide for Linux Instances. Default: included
	LocalStorage LocalStorage

	// Indicates the type of local storage that is required.
	//
	// * For instance types with
	// hard disk drive (HDD) storage, specify hdd.
	//
	// * For instance types with solid
	// state drive (SSD) storage, specify sdd.
	//
	// Default: Any local storage type
	LocalStorageTypes []LocalStorageType

	// The minimum and maximum amount of memory per vCPU for an instance type, in GiB.
	// Default: No minimum or maximum
	MemoryGiBPerVCpu *MemoryGiBPerVCpuRequest

	// The minimum and maximum number of network interfaces for an instance type.
	// Default: No minimum or maximum
	NetworkInterfaceCount *NetworkInterfaceCountRequest

	// The price protection threshold for On-Demand Instances. This is the maximum
	// you’ll pay for an On-Demand Instance, expressed as a percentage higher than the
	// cheapest M, C, or R instance type with your specified attributes. When Amazon
	// EC2 Auto Scaling selects instance types with your attributes, we will exclude
	// instance types whose price is higher than your threshold. The parameter accepts
	// an integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn
	// off price protection, specify a high value, such as 999999. Default: 20
	OnDemandMaxPricePercentageOverLowestPrice *int32

	// Indicates whether instance types must provide On-Demand Instance hibernation
	// support. Default: false
	RequireHibernateSupport *bool

	// The price protection threshold for Spot Instances. This is the maximum you’ll
	// pay for a Spot Instance, expressed as a percentage higher than the cheapest M,
	// C, or R instance type with your specified attributes. When Amazon EC2 Auto
	// Scaling selects instance types with your attributes, we will exclude instance
	// types whose price is higher than your threshold. The parameter accepts an
	// integer, which Amazon EC2 Auto Scaling interprets as a percentage. To turn off
	// price protection, specify a high value, such as 999999. Default: 100
	SpotMaxPricePercentageOverLowestPrice *int32

	// The minimum and maximum total local storage size for an instance type, in GB.
	// Default: No minimum or maximum
	TotalLocalStorageGB *TotalLocalStorageGBRequest

	noSmithyDocumentSerde
}

// Describes an instances distribution for an Auto Scaling group.
type InstancesDistribution struct {

	// The order of the launch template overrides to use in fulfilling On-Demand
	// capacity. If you specify lowest-price, Amazon EC2 Auto Scaling uses price to
	// determine the order, launching the lowest price first. If you specify
	// prioritized, Amazon EC2 Auto Scaling uses the priority that you assigned to each
	// launch template override, launching the highest priority first. If all your
	// On-Demand capacity cannot be fulfilled using your highest priority instance,
	// then Amazon EC2 Auto Scaling launches the remaining capacity using the second
	// priority instance type, and so on. Default: lowest-price for Auto Scaling groups
	// that specify InstanceRequirements in the overrides and prioritized for Auto
	// Scaling groups that don't.
	OnDemandAllocationStrategy *string

	// The minimum amount of the Auto Scaling group's capacity that must be fulfilled
	// by On-Demand Instances. This base portion is launched first as your group
	// scales. If you specify weights for the instance types in the overrides, the base
	// capacity is measured in the same unit of measurement as the instance types. If
	// you specify InstanceRequirements in the overrides, the base capacity is measured
	// in the same unit of measurement as your group's desired capacity. Default: 0
	OnDemandBaseCapacity *int32

	// Controls the percentages of On-Demand Instances and Spot Instances for your
	// additional capacity beyond OnDemandBaseCapacity. Expressed as a number (for
	// example, 20 specifies 20% On-Demand Instances, 80% Spot Instances). If set to
	// 100, only On-Demand Instances are used. Default: 100
	OnDemandPercentageAboveBaseCapacity *int32

	// Indicates how to allocate instances across Spot Instance pools. If the
	// allocation strategy is lowest-price, the Auto Scaling group launches instances
	// using the Spot pools with the lowest price, and evenly allocates your instances
	// across the number of Spot pools that you specify. If the allocation strategy is
	// capacity-optimized (recommended), the Auto Scaling group launches instances
	// using Spot pools that are optimally chosen based on the available Spot capacity.
	// Alternatively, you can use capacity-optimized-prioritized and set the order of
	// instance types in the list of launch template overrides from highest to lowest
	// priority (from first to last in the list). Amazon EC2 Auto Scaling honors the
	// instance type priorities on a best-effort basis but optimizes for capacity
	// first. Default: lowest-price
	SpotAllocationStrategy *string

	// The number of Spot Instance pools across which to allocate your Spot Instances.
	// The Spot pools are determined from the different instance types in the
	// overrides. Valid only when the Spot allocation strategy is lowest-price. Value
	// must be in the range of 1–20. Default: 2
	SpotInstancePools *int32

	// The maximum price per unit hour that you are willing to pay for a Spot Instance.
	// If you keep the value at its default (unspecified), Amazon EC2 Auto Scaling uses
	// the On-Demand price as the maximum Spot price. To remove a value that you
	// previously set, include the property but specify an empty string ("") for the
	// value.
	SpotMaxPrice *string

	noSmithyDocumentSerde
}

// Describes a launch configuration.
type LaunchConfiguration struct {

	// The creation date and time for the launch configuration.
	//
	// This member is required.
	CreatedTime *time.Time

	// The ID of the Amazon Machine Image (AMI) to use to launch your EC2 instances.
	// For more information, see Finding an AMI
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/finding-an-ami.html) in the
	// Amazon EC2 User Guide for Linux Instances.
	//
	// This member is required.
	ImageId *string

	// The instance type for the instances. For information about available instance
	// types, see Available Instance Types
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#AvailableInstanceTypes)
	// in the Amazon EC2 User Guide for Linux Instances.
	//
	// This member is required.
	InstanceType *string

	// The name of the launch configuration.
	//
	// This member is required.
	LaunchConfigurationName *string

	// For Auto Scaling groups that are running in a VPC, specifies whether to assign a
	// public IP address to the group's instances. For more information, see Launching
	// Auto Scaling instances in a VPC
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html) in the
	// Amazon EC2 Auto Scaling User Guide.
	AssociatePublicIpAddress *bool

	// A block device mapping, which specifies the block devices for the instance. For
	// more information, see Block Device Mapping
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html)
	// in the Amazon EC2 User Guide for Linux Instances.
	BlockDeviceMappings []BlockDeviceMapping

	// The ID of a ClassicLink-enabled VPC to link your EC2-Classic instances to. For
	// more information, see ClassicLink
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html) in
	// the Amazon EC2 User Guide for Linux Instances and Linking EC2-Classic instances
	// to a VPC
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink)
	// in the Amazon EC2 Auto Scaling User Guide.
	ClassicLinkVPCId *string

	// The IDs of one or more security groups for the VPC specified in
	// ClassicLinkVPCId. For more information, see ClassicLink
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html) in
	// the Amazon EC2 User Guide for Linux Instances and Linking EC2-Classic instances
	// to a VPC
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-in-vpc.html#as-ClassicLink)
	// in the Amazon EC2 Auto Scaling User Guide.
	ClassicLinkVPCSecurityGroups []string

	// Specifies whether the launch configuration is optimized for EBS I/O (true) or
	// not (false). For more information, see Amazon EBS-Optimized Instances
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSOptimized.html) in the
	// Amazon EC2 User Guide for Linux Instances.
	EbsOptimized *bool

	// The name or the Amazon Resource Name (ARN) of the instance profile associated
	// with the IAM role for the instance. The instance profile contains the IAM role.
	// For more information, see IAM role for applications that run on Amazon EC2
	// instances
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/us-iam-role.html) in the
	// Amazon EC2 Auto Scaling User Guide.
	IamInstanceProfile *string

	// Controls whether instances in this group are launched with detailed (true) or
	// basic (false) monitoring. For more information, see Configure Monitoring for
	// Auto Scaling Instances
	// (https://docs.aws.amazon.com/autoscaling/latest/userguide/enable-as-instance-metrics.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	InstanceMonitoring *InstanceMonitoring

	// The ID of the kernel associated with the AMI.
	KernelId *string

	// The name of the key pair. For more information, see Amazon EC2 Key Pairs
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html) in the
	// Amazon EC2 User Guide for Linux Instances.
	KeyName *string

	// The Amazon Resource Name (ARN) of the launch configuration.
	LaunchConfigurationARN *string

	// The metadata options for the instances. For more information, see Configuring
	// the Instance Metadata Options
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/create-launch-config.html#launch-configurations-imds)
	// in the Amazon EC2 Auto Scaling User Guide.
	MetadataOptions *InstanceMetadataOptions

	// The tenancy of the instance, either default or dedicated. An instance with
	// dedicated tenancy runs on isolated, single-tenant hardware and can only be
	// launched into a VPC. For more information, see Configuring instance tenancy with
	// Amazon EC2 Auto Scaling
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/auto-scaling-dedicated-instances.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	PlacementTenancy *string

	// The ID of the RAM disk associated with the AMI.
	RamdiskId *string

	// A list that contains the security groups to assign to the instances in the Auto
	// Scaling group. For more information, see Security Groups for Your VPC
	// (https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html)
	// in the Amazon Virtual Private Cloud User Guide.
	SecurityGroups []string

	// The maximum hourly price to be paid for any Spot Instance launched to fulfill
	// the request. Spot Instances are launched when the price you specify exceeds the
	// current Spot price. For more information, see Requesting Spot Instances
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-launch-spot-instances.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	SpotPrice *string

	// The user data to make available to the launched EC2 instances. For more
	// information, see Instance metadata and user data
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html)
	// (Linux) and Instance metadata and user data
	// (https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2-instance-metadata.html)
	// (Windows). If you are using a command line tool, base64-encoding is performed
	// for you, and you can load the text from a file. Otherwise, you must provide
	// base64-encoded text. User data is limited to 16 KB.
	UserData *string

	noSmithyDocumentSerde
}

// Describes a launch template and overrides. You specify these properties as part
// of a mixed instances policy.
type LaunchTemplate struct {

	// The launch template to use.
	LaunchTemplateSpecification *LaunchTemplateSpecification

	// Any properties that you specify override the same properties in the launch
	// template. If not provided, Amazon EC2 Auto Scaling uses the instance type or
	// instance type requirements specified in the launch template when it launches an
	// instance. The overrides can include either one or more instance types or a set
	// of instance requirements, but not both.
	Overrides []LaunchTemplateOverrides

	noSmithyDocumentSerde
}

// Describes an override for a launch template. For more information, see
// Configuring overrides
// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-configuring-overrides.html)
// in the Amazon EC2 Auto Scaling User Guide.
type LaunchTemplateOverrides struct {

	// The instance requirements. When you specify instance requirements, Amazon EC2
	// Auto Scaling finds instance types that satisfy your requirements, and then uses
	// your On-Demand and Spot allocation strategies to launch instances from these
	// instance types, in the same way as when you specify a list of specific instance
	// types.
	InstanceRequirements *InstanceRequirements

	// The instance type, such as m3.xlarge. You must use an instance type that is
	// supported in your requested Region and Availability Zones. For more information,
	// see Instance types
	// (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html) in the
	// Amazon Elastic Compute Cloud User Guide.
	InstanceType *string

	// Provides the launch template to be used when launching the instance type
	// specified in InstanceType. For example, some instance types might require a
	// launch template with a different AMI. If not provided, Amazon EC2 Auto Scaling
	// uses the launch template that's defined for your mixed instances policy. For
	// more information, see Specifying a different launch template for an instance
	// type
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups-launch-template-overrides.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	LaunchTemplateSpecification *LaunchTemplateSpecification

	// The number of capacity units provided by the instance type specified in
	// InstanceType in terms of virtual CPUs, memory, storage, throughput, or other
	// relative performance characteristic. When a Spot or On-Demand Instance is
	// launched, the capacity units count toward the desired capacity. Amazon EC2 Auto
	// Scaling launches instances until the desired capacity is totally fulfilled, even
	// if this results in an overage. For example, if there are two units remaining to
	// fulfill capacity, and Amazon EC2 Auto Scaling can only launch an instance with a
	// WeightedCapacity of five units, the instance is launched, and the desired
	// capacity is exceeded by three units. For more information, see Instance
	// weighting for Amazon EC2 Auto Scaling
	// (https://docs.aws.amazon.com/ec2-auto-scaling-mixed-instances-groups-instance-weighting.html)
	// in the Amazon EC2 Auto Scaling User Guide. Value must be in the range of 1–999.
	WeightedCapacity *string

	noSmithyDocumentSerde
}

// Describes the launch template and the version of the launch template that Amazon
// EC2 Auto Scaling uses to launch Amazon EC2 instances. For more information about
// launch templates, see Launch templates
// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/LaunchTemplates.html) in
// the Amazon EC2 Auto Scaling User Guide.
type LaunchTemplateSpecification struct {

	// The ID of the launch template. To get the template ID, use the Amazon EC2
	// DescribeLaunchTemplates
	// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplates.html)
	// API operation. New launch templates can be created using the Amazon EC2
	// CreateLaunchTemplate
	// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html)
	// API. Conditional: You must specify either a LaunchTemplateId or a
	// LaunchTemplateName.
	LaunchTemplateId *string

	// The name of the launch template. To get the template name, use the Amazon EC2
	// DescribeLaunchTemplates
	// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplates.html)
	// API operation. New launch templates can be created using the Amazon EC2
	// CreateLaunchTemplate
	// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplate.html)
	// API. Conditional: You must specify either a LaunchTemplateId or a
	// LaunchTemplateName.
	LaunchTemplateName *string

	// The version number, $Latest, or $Default. To get the version number, use the
	// Amazon EC2 DescribeLaunchTemplateVersions
	// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeLaunchTemplateVersions.html)
	// API operation. New launch template versions can be created using the Amazon EC2
	// CreateLaunchTemplateVersion
	// (https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateLaunchTemplateVersion.html)
	// API. If the value is $Latest, Amazon EC2 Auto Scaling selects the latest version
	// of the launch template when launching instances. If the value is $Default,
	// Amazon EC2 Auto Scaling selects the default version of the launch template when
	// launching instances. The default value is $Default.
	Version *string

	noSmithyDocumentSerde
}

// Describes a lifecycle hook, which enables an Auto Scaling group to be aware of
// events in the Auto Scaling instance lifecycle, and then perform a custom action
// when the corresponding lifecycle event occurs.
type LifecycleHook struct {

	// The name of the Auto Scaling group for the lifecycle hook.
	AutoScalingGroupName *string

	// Defines the action the Auto Scaling group should take when the lifecycle hook
	// timeout elapses or if an unexpected failure occurs. The possible values are
	// CONTINUE and ABANDON.
	DefaultResult *string

	// The maximum time, in seconds, that an instance can remain in a Pending:Wait or
	// Terminating:Wait state. The maximum is 172800 seconds (48 hours) or 100 times
	// HeartbeatTimeout, whichever is smaller.
	GlobalTimeout *int32

	// The maximum time, in seconds, that can elapse before the lifecycle hook times
	// out. If the lifecycle hook times out, Amazon EC2 Auto Scaling performs the
	// action that you specified in the DefaultResult parameter.
	HeartbeatTimeout *int32

	// The name of the lifecycle hook.
	LifecycleHookName *string

	// The state of the EC2 instance to which to attach the lifecycle hook. The
	// following are possible values:
	//
	// * autoscaling:EC2_INSTANCE_LAUNCHING
	//
	// *
	// autoscaling:EC2_INSTANCE_TERMINATING
	LifecycleTransition *string

	// Additional information that is included any time Amazon EC2 Auto Scaling sends a
	// message to the notification target.
	NotificationMetadata *string

	// The ARN of the target that Amazon EC2 Auto Scaling sends notifications to when
	// an instance is in the transition state for the lifecycle hook. The notification
	// target can be either an SQS queue or an SNS topic.
	NotificationTargetARN *string

	// The ARN of the IAM role that allows the Auto Scaling group to publish to the
	// specified notification target.
	RoleARN *string

	noSmithyDocumentSerde
}

// Describes information used to specify a lifecycle hook for an Auto Scaling
// group. For more information, see Amazon EC2 Auto Scaling lifecycle hooks
// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/lifecycle-hooks.html) in
// the Amazon EC2 Auto Scaling User Guide.
type LifecycleHookSpecification struct {

	// The name of the lifecycle hook.
	//
	// This member is required.
	LifecycleHookName *string

	// The state of the EC2 instance to which you want to attach the lifecycle hook.
	// The valid values are:
	//
	// * autoscaling:EC2_INSTANCE_LAUNCHING
	//
	// *
	// autoscaling:EC2_INSTANCE_TERMINATING
	//
	// This member is required.
	LifecycleTransition *string

	// Defines the action the Auto Scaling group should take when the lifecycle hook
	// timeout elapses or if an unexpected failure occurs. The valid values are
	// CONTINUE and ABANDON. The default value is ABANDON.
	DefaultResult *string

	// The maximum time, in seconds, that can elapse before the lifecycle hook times
	// out. If the lifecycle hook times out, Amazon EC2 Auto Scaling performs the
	// action that you specified in the DefaultResult parameter. You can prevent the
	// lifecycle hook from timing out by calling RecordLifecycleActionHeartbeat.
	HeartbeatTimeout *int32

	// Additional information that you want to include any time Amazon EC2 Auto Scaling
	// sends a message to the notification target.
	NotificationMetadata *string

	// The ARN of the target that Amazon EC2 Auto Scaling sends notifications to when
	// an instance is in the transition state for the lifecycle hook. The notification
	// target can be either an SQS queue or an SNS topic.
	NotificationTargetARN *string

	// The ARN of the IAM role that allows the Auto Scaling group to publish to the
	// specified notification target, for example, an Amazon SNS topic or an Amazon SQS
	// queue.
	RoleARN *string

	noSmithyDocumentSerde
}

// Describes the state of a Classic Load Balancer.
type LoadBalancerState struct {

	// The name of the load balancer.
	LoadBalancerName *string

	// One of the following load balancer states:
	//
	// * Adding - The Auto Scaling
	// instances are being registered with the load balancer.
	//
	// * Added - All Auto
	// Scaling instances are registered with the load balancer.
	//
	// * InService - At least
	// one Auto Scaling instance passed an ELB health check.
	//
	// * Removing - The Auto
	// Scaling instances are being deregistered from the load balancer. If connection
	// draining is enabled, Elastic Load Balancing waits for in-flight requests to
	// complete before deregistering the instances.
	//
	// * Removed - All Auto Scaling
	// instances are deregistered from the load balancer.
	State *string

	noSmithyDocumentSerde
}

// Describes the state of a target group.
type LoadBalancerTargetGroupState struct {

	// The Amazon Resource Name (ARN) of the target group.
	LoadBalancerTargetGroupARN *string

	// The state of the target group.
	//
	// * Adding - The Auto Scaling instances are being
	// registered with the target group.
	//
	// * Added - All Auto Scaling instances are
	// registered with the target group.
	//
	// * InService - At least one Auto Scaling
	// instance passed an ELB health check.
	//
	// * Removing - The Auto Scaling instances
	// are being deregistered from the target group. If connection draining is enabled,
	// Elastic Load Balancing waits for in-flight requests to complete before
	// deregistering the instances.
	//
	// * Removed - All Auto Scaling instances are
	// deregistered from the target group.
	State *string

	noSmithyDocumentSerde
}

// A GetPredictiveScalingForecast call returns the load forecast for a predictive
// scaling policy. This structure includes the data points for that load forecast,
// along with the timestamps of those data points and the metric specification.
type LoadForecast struct {

	// The metric specification for the load forecast.
	//
	// This member is required.
	MetricSpecification *PredictiveScalingMetricSpecification

	// The timestamps for the data points, in UTC format.
	//
	// This member is required.
	Timestamps []time.Time

	// The values of the data points.
	//
	// This member is required.
	Values []float64

	noSmithyDocumentSerde
}

// Specifies the minimum and maximum for the MemoryGiBPerVCpu object when you
// specify InstanceRequirements for an Auto Scaling group.
type MemoryGiBPerVCpuRequest struct {

	// The memory maximum in GiB.
	Max *float64

	// The memory minimum in GiB.
	Min *float64

	noSmithyDocumentSerde
}

// Specifies the minimum and maximum for the MemoryMiB object when you specify
// InstanceRequirements for an Auto Scaling group.
type MemoryMiBRequest struct {

	// The memory minimum in MiB.
	//
	// This member is required.
	Min *int32

	// The memory maximum in MiB.
	Max *int32

	noSmithyDocumentSerde
}

// Represents a specific metric.
type Metric struct {

	// The name of the metric.
	//
	// This member is required.
	MetricName *string

	// The namespace of the metric. For more information, see the table in Amazon Web
	// Services services that publish CloudWatch metrics
	// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html)
	// in the Amazon CloudWatch User Guide.
	//
	// This member is required.
	Namespace *string

	// The dimensions for the metric. For the list of available dimensions, see the
	// Amazon Web Services documentation available from the table in Amazon Web
	// Services services that publish CloudWatch metrics
	// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/aws-services-cloudwatch-metrics.html)
	// in the Amazon CloudWatch User Guide. Conditional: If you published your metric
	// with dimensions, you must specify the same dimensions in your scaling policy.
	Dimensions []MetricDimension

	noSmithyDocumentSerde
}

// Describes a metric.
type MetricCollectionType struct {

	// One of the following metrics:
	//
	// * GroupMinSize
	//
	// * GroupMaxSize
	//
	// *
	// GroupDesiredCapacity
	//
	// * GroupInServiceInstances
	//
	// * GroupPendingInstances
	//
	// *
	// GroupStandbyInstances
	//
	// * GroupTerminatingInstances
	//
	// * GroupTotalInstances
	//
	// *
	// GroupInServiceCapacity
	//
	// * GroupPendingCapacity
	//
	// * GroupStandbyCapacity
	//
	// *
	// GroupTerminatingCapacity
	//
	// * GroupTotalCapacity
	//
	// * WarmPoolDesiredCapacity
	//
	// *
	// WarmPoolWarmedCapacity
	//
	// * WarmPoolPendingCapacity
	//
	// *
	// WarmPoolTerminatingCapacity
	//
	// * WarmPoolTotalCapacity
	//
	// *
	// GroupAndWarmPoolDesiredCapacity
	//
	// * GroupAndWarmPoolTotalCapacity
	Metric *string

	noSmithyDocumentSerde
}

// The metric data to return. Also defines whether this call is returning data for
// one metric only, or whether it is performing a math expression on the values of
// returned metric statistics to create a new time series. A time series is a
// series of data points, each of which is associated with a timestamp. For more
// information and examples, see Advanced predictive scaling policy configurations
// using custom metrics
// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/predictive-scaling-customized-metric-specification.html)
// in the Amazon EC2 Auto Scaling User Guide.
type MetricDataQuery struct {

	// A short name that identifies the object's results in the response. This name
	// must be unique among all MetricDataQuery objects specified for a single scaling
	// policy. If you are performing math expressions on this set of data, this name
	// represents that data and can serve as a variable in the mathematical expression.
	// The valid characters are letters, numbers, and underscores. The first character
	// must be a lowercase letter.
	//
	// This member is required.
	Id *string

	// The math expression to perform on the returned data, if this object is
	// performing a math expression. This expression can use the Id of the other
	// metrics to refer to those metrics, and can also use the Id of other expressions
	// to use the result of those expressions. Conditional: Within each MetricDataQuery
	// object, you must specify either Expression or MetricStat, but not both.
	Expression *string

	// A human-readable label for this metric or expression. This is especially useful
	// if this is a math expression, so that you know what the value represents.
	Label *string

	// Information about the metric data to return. Conditional: Within each
	// MetricDataQuery object, you must specify either Expression or MetricStat, but
	// not both.
	MetricStat *MetricStat

	// Indicates whether to return the timestamps and raw data values of this metric.
	// If you use any math expressions, specify true for this value for only the final
	// math expression that the metric specification is based on. You must specify
	// false for ReturnData for all the other metrics and expressions used in the
	// metric specification. If you are only retrieving metrics and not performing any
	// math expressions, do not specify anything for ReturnData. This sets it to its
	// default (true).
	ReturnData *bool

	noSmithyDocumentSerde
}

// Describes the dimension of a metric.
type MetricDimension struct {

	// The name of the dimension.
	//
	// This member is required.
	Name *string

	// The value of the dimension.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Describes a granularity of a metric.
type MetricGranularityType struct {

	// The granularity. The only valid value is 1Minute.
	Granularity *string

	noSmithyDocumentSerde
}

// This structure defines the CloudWatch metric to return, along with the
// statistic, period, and unit. For more information about the CloudWatch
// terminology below, see Amazon CloudWatch concepts
// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html)
// in the Amazon CloudWatch User Guide.
type MetricStat struct {

	// The CloudWatch metric to return, including the metric name, namespace, and
	// dimensions. To get the exact metric name, namespace, and dimensions, inspect the
	// Metric
	// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_Metric.html)
	// object that is returned by a call to ListMetrics
	// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_ListMetrics.html).
	//
	// This member is required.
	Metric *Metric

	// The statistic to return. It can include any CloudWatch statistic or extended
	// statistic. For a list of valid values, see the table in Statistics
	// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/cloudwatch_concepts.html#Statistic)
	// in the Amazon CloudWatch User Guide. The most commonly used metrics for
	// predictive scaling are Average and Sum.
	//
	// This member is required.
	Stat *string

	// The unit to use for the returned data points. For a complete list of the units
	// that CloudWatch supports, see the MetricDatum
	// (https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_MetricDatum.html)
	// data type in the Amazon CloudWatch API Reference.
	Unit *string

	noSmithyDocumentSerde
}

// Describes a mixed instances policy. A mixed instances policy contains the
// instance types that Amazon EC2 Auto Scaling can launch and other information
// that Amazon EC2 Auto Scaling can use to launch instances and help optimize your
// costs. For more information, see Auto Scaling groups with multiple instance
// types and purchase options
// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/ec2-auto-scaling-mixed-instances-groups.html)
// in the Amazon EC2 Auto Scaling User Guide.
type MixedInstancesPolicy struct {

	// Specifies the instances distribution.
	InstancesDistribution *InstancesDistribution

	// Specifies the launch template to use and the instance types (overrides) that are
	// used to launch EC2 instances to fulfill On-Demand and Spot capacities. Required
	// when creating a mixed instances policy.
	LaunchTemplate *LaunchTemplate

	noSmithyDocumentSerde
}

// Specifies the minimum and maximum for the NetworkInterfaceCount object when you
// specify InstanceRequirements for an Auto Scaling group.
type NetworkInterfaceCountRequest struct {

	// The maximum number of network interfaces.
	Max *int32

	// The minimum number of network interfaces.
	Min *int32

	noSmithyDocumentSerde
}

// Describes a notification.
type NotificationConfiguration struct {

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string

	// One of the following event notification types:
	//
	// *
	// autoscaling:EC2_INSTANCE_LAUNCH
	//
	// * autoscaling:EC2_INSTANCE_LAUNCH_ERROR
	//
	// *
	// autoscaling:EC2_INSTANCE_TERMINATE
	//
	// *
	// autoscaling:EC2_INSTANCE_TERMINATE_ERROR
	//
	// * autoscaling:TEST_NOTIFICATION
	NotificationType *string

	// The Amazon Resource Name (ARN) of the Amazon SNS topic.
	TopicARN *string

	noSmithyDocumentSerde
}

// Represents a predefined metric for a target tracking scaling policy to use with
// Amazon EC2 Auto Scaling.
type PredefinedMetricSpecification struct {

	// The metric type. The following predefined metrics are available:
	//
	// *
	// ASGAverageCPUUtilization - Average CPU utilization of the Auto Scaling group.
	//
	// *
	// ASGAverageNetworkIn - Average number of bytes received on all network interfaces
	// by the Auto Scaling group.
	//
	// * ASGAverageNetworkOut - Average number of bytes
	// sent out on all network interfaces by the Auto Scaling group.
	//
	// *
	// ALBRequestCountPerTarget - Number of requests completed per target in an
	// Application Load Balancer target group.
	//
	// This member is required.
	PredefinedMetricType MetricType

	// A label that uniquely identifies a specific Application Load Balancer target
	// group from which to determine the average request count served by your Auto
	// Scaling group. You can't specify a resource label unless the target group is
	// attached to the Auto Scaling group. You create the resource label by appending
	// the final portion of the load balancer ARN and the final portion of the target
	// group ARN into a single value, separated by a forward slash (/). The format of
	// the resource label is:
	// app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff.
	// Where:
	//
	// * app// is the final portion of the load balancer ARN
	//
	// * targetgroup//
	// is the final portion of the target group ARN.
	//
	// To find the ARN for an
	// Application Load Balancer, use the DescribeLoadBalancers
	// (https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html)
	// API operation. To find the ARN for the target group, use the
	// DescribeTargetGroups
	// (https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html)
	// API operation.
	ResourceLabel *string

	noSmithyDocumentSerde
}

// Represents a predictive scaling policy configuration to use with Amazon EC2 Auto
// Scaling.
type PredictiveScalingConfiguration struct {

	// This structure includes the metrics and target utilization to use for predictive
	// scaling. This is an array, but we currently only support a single metric
	// specification. That is, you can specify a target value and a single metric pair,
	// or a target value and one scaling metric and one load metric.
	//
	// This member is required.
	MetricSpecifications []PredictiveScalingMetricSpecification

	// Defines the behavior that should be applied if the forecast capacity approaches
	// or exceeds the maximum capacity of the Auto Scaling group. Defaults to
	// HonorMaxCapacity if not specified. The following are possible values:
	//
	// *
	// HonorMaxCapacity - Amazon EC2 Auto Scaling cannot scale out capacity higher than
	// the maximum capacity. The maximum capacity is enforced as a hard limit.
	//
	// *
	// IncreaseMaxCapacity - Amazon EC2 Auto Scaling can scale out capacity higher than
	// the maximum capacity when the forecast capacity is close to or exceeds the
	// maximum capacity. The upper limit is determined by the forecasted capacity and
	// the value for MaxCapacityBuffer.
	MaxCapacityBreachBehavior PredictiveScalingMaxCapacityBreachBehavior

	// The size of the capacity buffer to use when the forecast capacity is close to or
	// exceeds the maximum capacity. The value is specified as a percentage relative to
	// the forecast capacity. For example, if the buffer is 10, this means a 10 percent
	// buffer, such that if the forecast capacity is 50, and the maximum capacity is
	// 40, then the effective maximum capacity is 55. If set to 0, Amazon EC2 Auto
	// Scaling may scale capacity higher than the maximum capacity to equal but not
	// exceed forecast capacity. Required if the MaxCapacityBreachBehavior property is
	// set to IncreaseMaxCapacity, and cannot be used otherwise.
	MaxCapacityBuffer *int32

	// The predictive scaling mode. Defaults to ForecastOnly if not specified.
	Mode PredictiveScalingMode

	// The amount of time, in seconds, by which the instance launch time can be
	// advanced. For example, the forecast says to add capacity at 10:00 AM, and you
	// choose to pre-launch instances by 5 minutes. In that case, the instances will be
	// launched at 9:55 AM. The intention is to give resources time to be provisioned.
	// It can take a few minutes to launch an EC2 instance. The actual amount of time
	// required depends on several factors, such as the size of the instance and
	// whether there are startup scripts to complete. The value must be less than the
	// forecast interval duration of 3600 seconds (60 minutes). Defaults to 300 seconds
	// if not specified.
	SchedulingBufferTime *int32

	noSmithyDocumentSerde
}

// Describes a customized capacity metric for a predictive scaling policy.
type PredictiveScalingCustomizedCapacityMetric struct {

	// One or more metric data queries to provide the data points for a capacity
	// metric. Use multiple metric data queries only if you are performing a math
	// expression on returned data.
	//
	// This member is required.
	MetricDataQueries []MetricDataQuery

	noSmithyDocumentSerde
}

// Describes a custom load metric for a predictive scaling policy.
type PredictiveScalingCustomizedLoadMetric struct {

	// One or more metric data queries to provide the data points for a load metric.
	// Use multiple metric data queries only if you are performing a math expression on
	// returned data.
	//
	// This member is required.
	MetricDataQueries []MetricDataQuery

	noSmithyDocumentSerde
}

// Describes a custom scaling metric for a predictive scaling policy.
type PredictiveScalingCustomizedScalingMetric struct {

	// One or more metric data queries to provide the data points for a scaling metric.
	// Use multiple metric data queries only if you are performing a math expression on
	// returned data.
	//
	// This member is required.
	MetricDataQueries []MetricDataQuery

	noSmithyDocumentSerde
}

// This structure specifies the metrics and target utilization settings for a
// predictive scaling policy. You must specify either a metric pair, or a load
// metric and a scaling metric individually. Specifying a metric pair instead of
// individual metrics provides a simpler way to configure metrics for a scaling
// policy. You choose the metric pair, and the policy automatically knows the
// correct sum and average statistics to use for the load metric and the scaling
// metric. Example
//
// * You create a predictive scaling policy and specify
// ALBRequestCount as the value for the metric pair and 1000.0 as the target value.
// For this type of metric, you must provide the metric dimension for the
// corresponding target group, so you also provide a resource label for the
// Application Load Balancer target group that is attached to your Auto Scaling
// group.
//
// * The number of requests the target group receives per minute provides
// the load metric, and the request count averaged between the members of the
// target group provides the scaling metric. In CloudWatch, this refers to the
// RequestCount and RequestCountPerTarget metrics, respectively.
//
// * For optimal use
// of predictive scaling, you adhere to the best practice of using a dynamic
// scaling policy to automatically scale between the minimum capacity and maximum
// capacity in response to real-time changes in resource utilization.
//
// * Amazon EC2
// Auto Scaling consumes data points for the load metric over the last 14 days and
// creates an hourly load forecast for predictive scaling. (A minimum of 24 hours
// of data is required.)
//
// * After creating the load forecast, Amazon EC2 Auto
// Scaling determines when to reduce or increase the capacity of your Auto Scaling
// group in each hour of the forecast period so that the average number of requests
// received by each instance is as close to 1000 requests per minute as possible at
// all times.
//
// For information about using custom metrics with predictive scaling,
// see Advanced predictive scaling policy configurations using custom metrics
// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/predictive-scaling-customized-metric-specification.html)
// in the Amazon EC2 Auto Scaling User Guide.
type PredictiveScalingMetricSpecification struct {

	// Specifies the target utilization. Some metrics are based on a count instead of a
	// percentage, such as the request count for an Application Load Balancer or the
	// number of messages in an SQS queue. If the scaling policy specifies one of these
	// metrics, specify the target utilization as the optimal average request or
	// message count per instance during any one-minute interval.
	//
	// This member is required.
	TargetValue *float64

	// The customized capacity metric specification.
	CustomizedCapacityMetricSpecification *PredictiveScalingCustomizedCapacityMetric

	// The customized load metric specification.
	CustomizedLoadMetricSpecification *PredictiveScalingCustomizedLoadMetric

	// The customized scaling metric specification.
	CustomizedScalingMetricSpecification *PredictiveScalingCustomizedScalingMetric

	// The predefined load metric specification.
	PredefinedLoadMetricSpecification *PredictiveScalingPredefinedLoadMetric

	// The predefined metric pair specification from which Amazon EC2 Auto Scaling
	// determines the appropriate scaling metric and load metric to use.
	PredefinedMetricPairSpecification *PredictiveScalingPredefinedMetricPair

	// The predefined scaling metric specification.
	PredefinedScalingMetricSpecification *PredictiveScalingPredefinedScalingMetric

	noSmithyDocumentSerde
}

// Describes a load metric for a predictive scaling policy. When returned in the
// output of DescribePolicies, it indicates that a predictive scaling policy uses
// individually specified load and scaling metrics instead of a metric pair.
type PredictiveScalingPredefinedLoadMetric struct {

	// The metric type.
	//
	// This member is required.
	PredefinedMetricType PredefinedLoadMetricType

	// A label that uniquely identifies a specific Application Load Balancer target
	// group from which to determine the request count served by your Auto Scaling
	// group. You can't specify a resource label unless the target group is attached to
	// the Auto Scaling group. You create the resource label by appending the final
	// portion of the load balancer ARN and the final portion of the target group ARN
	// into a single value, separated by a forward slash (/). The format of the
	// resource label is:
	// app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff.
	// Where:
	//
	// * app// is the final portion of the load balancer ARN
	//
	// * targetgroup//
	// is the final portion of the target group ARN.
	//
	// To find the ARN for an
	// Application Load Balancer, use the DescribeLoadBalancers
	// (https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html)
	// API operation. To find the ARN for the target group, use the
	// DescribeTargetGroups
	// (https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html)
	// API operation.
	ResourceLabel *string

	noSmithyDocumentSerde
}

// Represents a metric pair for a predictive scaling policy.
type PredictiveScalingPredefinedMetricPair struct {

	// Indicates which metrics to use. There are two different types of metrics for
	// each metric type: one is a load metric and one is a scaling metric. For example,
	// if the metric type is ASGCPUUtilization, the Auto Scaling group's total CPU
	// metric is used as the load metric, and the average CPU metric is used for the
	// scaling metric.
	//
	// This member is required.
	PredefinedMetricType PredefinedMetricPairType

	// A label that uniquely identifies a specific Application Load Balancer target
	// group from which to determine the total and average request count served by your
	// Auto Scaling group. You can't specify a resource label unless the target group
	// is attached to the Auto Scaling group. You create the resource label by
	// appending the final portion of the load balancer ARN and the final portion of
	// the target group ARN into a single value, separated by a forward slash (/). The
	// format of the resource label is:
	// app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff.
	// Where:
	//
	// * app// is the final portion of the load balancer ARN
	//
	// * targetgroup//
	// is the final portion of the target group ARN.
	//
	// To find the ARN for an
	// Application Load Balancer, use the DescribeLoadBalancers
	// (https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html)
	// API operation. To find the ARN for the target group, use the
	// DescribeTargetGroups
	// (https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html)
	// API operation.
	ResourceLabel *string

	noSmithyDocumentSerde
}

// Describes a scaling metric for a predictive scaling policy. When returned in the
// output of DescribePolicies, it indicates that a predictive scaling policy uses
// individually specified load and scaling metrics instead of a metric pair.
type PredictiveScalingPredefinedScalingMetric struct {

	// The metric type.
	//
	// This member is required.
	PredefinedMetricType PredefinedScalingMetricType

	// A label that uniquely identifies a specific Application Load Balancer target
	// group from which to determine the average request count served by your Auto
	// Scaling group. You can't specify a resource label unless the target group is
	// attached to the Auto Scaling group. You create the resource label by appending
	// the final portion of the load balancer ARN and the final portion of the target
	// group ARN into a single value, separated by a forward slash (/). The format of
	// the resource label is:
	// app/my-alb/778d41231b141a0f/targetgroup/my-alb-target-group/943f017f100becff.
	// Where:
	//
	// * app// is the final portion of the load balancer ARN
	//
	// * targetgroup//
	// is the final portion of the target group ARN.
	//
	// To find the ARN for an
	// Application Load Balancer, use the DescribeLoadBalancers
	// (https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeLoadBalancers.html)
	// API operation. To find the ARN for the target group, use the
	// DescribeTargetGroups
	// (https://docs.aws.amazon.com/elasticloadbalancing/latest/APIReference/API_DescribeTargetGroups.html)
	// API operation.
	ResourceLabel *string

	noSmithyDocumentSerde
}

// Describes a process type. For more information, see Scaling processes
// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html#process-types)
// in the Amazon EC2 Auto Scaling User Guide.
type ProcessType struct {

	// One of the following processes:
	//
	// * Launch
	//
	// * Terminate
	//
	// * AddToLoadBalancer
	//
	// *
	// AlarmNotification
	//
	// * AZRebalance
	//
	// * HealthCheck
	//
	// * InstanceRefresh
	//
	// *
	// ReplaceUnhealthy
	//
	// * ScheduledActions
	//
	// This member is required.
	ProcessName *string

	noSmithyDocumentSerde
}

// Describes the preferences for an instance refresh.
type RefreshPreferences struct {

	// The amount of time, in seconds, to wait after a checkpoint before continuing.
	// This property is optional, but if you specify a value for it, you must also
	// specify a value for CheckpointPercentages. If you specify a value for
	// CheckpointPercentages and not for CheckpointDelay, the CheckpointDelay defaults
	// to 3600 (1 hour).
	CheckpointDelay *int32

	// Threshold values for each checkpoint in ascending order. Each number must be
	// unique. To replace all instances in the Auto Scaling group, the last number in
	// the array must be 100. For usage examples, see Adding checkpoints to an instance
	// refresh
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-adding-checkpoints-instance-refresh.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	CheckpointPercentages []int32

	// The number of seconds until a newly launched instance is configured and ready to
	// use. During this time, Amazon EC2 Auto Scaling does not immediately move on to
	// the next replacement. The default is to use the value for the health check grace
	// period defined for the group.
	InstanceWarmup *int32

	// The amount of capacity in the Auto Scaling group that must remain healthy during
	// an instance refresh to allow the operation to continue. The value is expressed
	// as a percentage of the desired capacity of the Auto Scaling group (rounded up to
	// the nearest integer). The default is 90. Setting the minimum healthy percentage
	// to 100 percent limits the rate of replacement to one instance at a time. In
	// contrast, setting it to 0 percent has the effect of replacing all instances at
	// the same time.
	MinHealthyPercentage *int32

	// A boolean value that indicates whether skip matching is enabled. If true, then
	// Amazon EC2 Auto Scaling skips replacing instances that match the desired
	// configuration. If no desired configuration is specified, then it skips replacing
	// instances that have the same configuration that is already set on the group. The
	// default is false.
	SkipMatching *bool

	noSmithyDocumentSerde
}

// Describes a scaling policy.
type ScalingPolicy struct {

	// Specifies how the scaling adjustment is interpreted (for example, an absolute
	// number or a percentage). The valid values are ChangeInCapacity, ExactCapacity,
	// and PercentChangeInCapacity.
	AdjustmentType *string

	// The CloudWatch alarms related to the policy.
	Alarms []Alarm

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string

	// The duration of the policy's cooldown period, in seconds.
	Cooldown *int32

	// Indicates whether the policy is enabled (true) or disabled (false).
	Enabled *bool

	// The estimated time, in seconds, until a newly launched instance can contribute
	// to the CloudWatch metrics.
	EstimatedInstanceWarmup *int32

	// The aggregation type for the CloudWatch metrics. The valid values are Minimum,
	// Maximum, and Average.
	MetricAggregationType *string

	// The minimum value to scale by when the adjustment type is
	// PercentChangeInCapacity.
	MinAdjustmentMagnitude *int32

	// Available for backward compatibility. Use MinAdjustmentMagnitude instead.
	//
	// Deprecated: This member has been deprecated.
	MinAdjustmentStep *int32

	// The Amazon Resource Name (ARN) of the policy.
	PolicyARN *string

	// The name of the scaling policy.
	PolicyName *string

	// One of the following policy types:
	//
	// * TargetTrackingScaling
	//
	// * StepScaling
	//
	// *
	// SimpleScaling (default)
	//
	// * PredictiveScaling
	//
	// For more information, see Target
	// tracking scaling policies
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-target-tracking.html)
	// and Step and simple scaling policies
	// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html)
	// in the Amazon EC2 Auto Scaling User Guide.
	PolicyType *string

	// A predictive scaling policy.
	PredictiveScalingConfiguration *PredictiveScalingConfiguration

	// The amount by which to scale, based on the specified adjustment type. A positive
	// value adds to the current capacity while a negative number removes from the
	// current capacity.
	ScalingAdjustment *int32

	// A set of adjustments that enable you to scale based on the size of the alarm
	// breach.
	StepAdjustments []StepAdjustment

	// A target tracking scaling policy.
	TargetTrackingConfiguration *TargetTrackingConfiguration

	noSmithyDocumentSerde
}

// Describes a scheduled scaling action.
type ScheduledUpdateGroupAction struct {

	// The name of the Auto Scaling group.
	AutoScalingGroupName *string

	// The desired capacity is the initial capacity of the Auto Scaling group after the
	// scheduled action runs and the capacity it attempts to maintain.
	DesiredCapacity *int32

	// The date and time in UTC for the recurring schedule to end. For example,
	// "2019-06-01T00:00:00Z".
	EndTime *time.Time

	// The maximum size of the Auto Scaling group.
	MaxSize *int32

	// The minimum size of the Auto Scaling group.
	MinSize *int32

	// The recurring schedule for the action, in Unix cron syntax format. When
	// StartTime and EndTime are specified with Recurrence, they form the boundaries of
	// when the recurring action starts and stops.
	Recurrence *string

	// The Amazon Resource Name (ARN) of the scheduled action.
	ScheduledActionARN *string

	// The name of the scheduled action.
	ScheduledActionName *string

	// The date and time in UTC for this action to start. For example,
	// "2019-06-01T00:00:00Z".
	StartTime *time.Time

	// This parameter is no longer used.
	Time *time.Time

	// The time zone for the cron expression.
	TimeZone *string

	noSmithyDocumentSerde
}

// Describes information used for one or more scheduled scaling action updates in a
// BatchPutScheduledUpdateGroupAction operation.
type ScheduledUpdateGroupActionRequest struct {

	// The name of the scaling action.
	//
	// This member is required.
	ScheduledActionName *string

	// The desired capacity is the initial capacity of the Auto Scaling group after the
	// scheduled action runs and the capacity it attempts to maintain.
	DesiredCapacity *int32

	// The date and time for the recurring schedule to end, in UTC.
	EndTime *time.Time

	// The maximum size of the Auto Scaling group.
	MaxSize *int32

	// The minimum size of the Auto Scaling group.
	MinSize *int32

	// The recurring schedule for the action, in Unix cron syntax format. This format
	// consists of five fields separated by white spaces: [Minute] [Hour]
	// [Day_of_Month] [Month_of_Year] [Day_of_Week]. The value must be in quotes (for
	// example, "30 0 1 1,6,12 *"). For more information about this format, see Crontab
	// (http://crontab.org). When StartTime and EndTime are specified with Recurrence,
	// they form the boundaries of when the recurring action starts and stops. Cron
	// expressions use Universal Coordinated Time (UTC) by default.
	Recurrence *string

	// The date and time for the action to start, in YYYY-MM-DDThh:mm:ssZ format in
	// UTC/GMT only and in quotes (for example, "2019-06-01T00:00:00Z"). If you specify
	// Recurrence and StartTime, Amazon EC2 Auto Scaling performs the action at this
	// time, and then performs the action based on the specified recurrence. If you try
	// to schedule the action in the past, Amazon EC2 Auto Scaling returns an error
	// message.
	StartTime *time.Time

	// Specifies the time zone for a cron expression. If a time zone is not provided,
	// UTC is used by default. Valid values are the canonical names of the IANA time
	// zones, derived from the IANA Time Zone Database (such as Etc/GMT+9 or
	// Pacific/Tahiti). For more information, see
	// https://en.wikipedia.org/wiki/List_of_tz_database_time_zones
	// (https://en.wikipedia.org/wiki/List_of_tz_database_time_zones).
	TimeZone *string

	noSmithyDocumentSerde
}

// Describes information used to create a step adjustment for a step scaling
// policy. For the following examples, suppose that you have an alarm with a breach
// threshold of 50:
//
// * To trigger the adjustment when the metric is greater than or
// equal to 50 and less than 60, specify a lower bound of 0 and an upper bound of
// 10.
//
// * To trigger the adjustment when the metric is greater than 40 and less
// than or equal to 50, specify a lower bound of -10 and an upper bound of
// 0.
//
// There are a few rules for the step adjustments for your step policy:
//
// * The
// ranges of your step adjustments can't overlap or have a gap.
//
// * At most, one
// step adjustment can have a null lower bound. If one step adjustment has a
// negative lower bound, then there must be a step adjustment with a null lower
// bound.
//
// * At most, one step adjustment can have a null upper bound. If one step
// adjustment has a positive upper bound, then there must be a step adjustment with
// a null upper bound.
//
// * The upper and lower bound can't be null in the same step
// adjustment.
//
// For more information, see Step adjustments
// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html#as-scaling-steps)
// in the Amazon EC2 Auto Scaling User Guide.
type StepAdjustment struct {

	// The amount by which to scale, based on the specified adjustment type. A positive
	// value adds to the current capacity while a negative number removes from the
	// current capacity.
	//
	// This member is required.
	ScalingAdjustment *int32

	// The lower bound for the difference between the alarm threshold and the
	// CloudWatch metric. If the metric value is above the breach threshold, the lower
	// bound is inclusive (the metric must be greater than or equal to the threshold
	// plus the lower bound). Otherwise, it is exclusive (the metric must be greater
	// than the threshold plus the lower bound). A null value indicates negative
	// infinity.
	MetricIntervalLowerBound *float64

	// The upper bound for the difference between the alarm threshold and the
	// CloudWatch metric. If the metric value is above the breach threshold, the upper
	// bound is exclusive (the metric must be less than the threshold plus the upper
	// bound). Otherwise, it is inclusive (the metric must be less than or equal to the
	// threshold plus the upper bound). A null value indicates positive infinity. The
	// upper bound must be greater than the lower bound.
	MetricIntervalUpperBound *float64

	noSmithyDocumentSerde
}

// Describes an auto scaling process that has been suspended. For more information,
// see Scaling processes
// (https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-suspend-resume-processes.html#process-types)
// in the Amazon EC2 Auto Scaling User Guide.
type SuspendedProcess struct {

	// The name of the suspended process.
	ProcessName *string

	// The reason that the process was suspended.
	SuspensionReason *string

	noSmithyDocumentSerde
}

// Describes a tag for an Auto Scaling group.
type Tag struct {

	// The tag key.
	//
	// This member is required.
	Key *string

	// Determines whether the tag is added to new instances as they are launched in the
	// group.
	PropagateAtLaunch *bool

	// The name of the Auto Scaling group.
	ResourceId *string

	// The type of resource. The only supported value is auto-scaling-group.
	ResourceType *string

	// The tag value.
	Value *string

	noSmithyDocumentSerde
}

// Describes a tag for an Auto Scaling group.
type TagDescription struct {

	// The tag key.
	Key *string

	// Determines whether the tag is added to new instances as they are launched in the
	// group.
	PropagateAtLaunch *bool

	// The name of the group.
	ResourceId *string

	// The type of resource. The only supported value is auto-scaling-group.
	ResourceType *string

	// The tag value.
	Value *string

	noSmithyDocumentSerde
}

// Represents a target tracking scaling policy configuration to use with Amazon EC2
// Auto Scaling.
type TargetTrackingConfiguration struct {

	// The target value for the metric.
	//
	// This member is required.
	TargetValue *float64

	// A customized metric. You must specify either a predefined metric or a customized
	// metric.
	CustomizedMetricSpecification *CustomizedMetricSpecification

	// Indicates whether scaling in by the target tracking scaling policy is disabled.
	// If scaling in is disabled, the target tracking scaling policy doesn't remove
	// instances from the Auto Scaling group. Otherwise, the target tracking scaling
	// policy can remove instances from the Auto Scaling group. The default is false.
	DisableScaleIn *bool

	// A predefined metric. You must specify either a predefined metric or a customized
	// metric.
	PredefinedMetricSpecification *PredefinedMetricSpecification

	noSmithyDocumentSerde
}

// Specifies the minimum and maximum for the TotalLocalStorageGB object when you
// specify InstanceRequirements for an Auto Scaling group.
type TotalLocalStorageGBRequest struct {

	// The storage maximum in GB.
	Max *float64

	// The storage minimum in GB.
	Min *float64

	noSmithyDocumentSerde
}

// Specifies the minimum and maximum for the VCpuCount object when you specify
// InstanceRequirements for an Auto Scaling group.
type VCpuCountRequest struct {

	// The minimum number of vCPUs.
	//
	// This member is required.
	Min *int32

	// The maximum number of vCPUs.
	Max *int32

	noSmithyDocumentSerde
}

// Describes a warm pool configuration.
type WarmPoolConfiguration struct {

	// The maximum number of instances that are allowed to be in the warm pool or in
	// any state except Terminated for the Auto Scaling group.
	MaxGroupPreparedCapacity *int32

	// The minimum number of instances to maintain in the warm pool.
	MinSize *int32

	// The instance state to transition to after the lifecycle actions are complete.
	PoolState WarmPoolState

	// The status of a warm pool that is marked for deletion.
	Status WarmPoolStatus

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
