// Code generated by smithy-go-codegen DO NOT EDIT.

package amplifyuibuilder

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/amplifyuibuilder/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpCreateComponent struct {
}

func (*awsRestjson1_serializeOpCreateComponent) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateComponent) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateComponentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app/{appId}/environment/{environmentName}/components")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateComponentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		restEncoder.SetHeader("Content-Type").String("application/json")
	}

	if input.ComponentToCreate != nil {
		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentCreateComponentData(input.ComponentToCreate, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	} else {
		jsonEncoder := smithyjson.NewEncoder()
		jsonEncoder.Value.Object().Close()
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}

	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateComponentInput(v *CreateComponentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		encoder.SetQuery("clientToken").String(*v.ClientToken)
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateTheme struct {
}

func (*awsRestjson1_serializeOpCreateTheme) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateTheme) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateThemeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app/{appId}/environment/{environmentName}/themes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsCreateThemeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		restEncoder.SetHeader("Content-Type").String("application/json")
	}

	if input.ThemeToCreate != nil {
		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentCreateThemeData(input.ThemeToCreate, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	} else {
		jsonEncoder := smithyjson.NewEncoder()
		jsonEncoder.Value.Object().Close()
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}

	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateThemeInput(v *CreateThemeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		encoder.SetQuery("clientToken").String(*v.ClientToken)
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteComponent struct {
}

func (*awsRestjson1_serializeOpDeleteComponent) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteComponent) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteComponentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app/{appId}/environment/{environmentName}/components/{id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteComponentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteComponentInput(v *DeleteComponentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDeleteTheme struct {
}

func (*awsRestjson1_serializeOpDeleteTheme) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteTheme) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteThemeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app/{appId}/environment/{environmentName}/themes/{id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteThemeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteThemeInput(v *DeleteThemeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpExchangeCodeForToken struct {
}

func (*awsRestjson1_serializeOpExchangeCodeForToken) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpExchangeCodeForToken) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ExchangeCodeForTokenInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tokens/{provider}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsExchangeCodeForTokenInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		restEncoder.SetHeader("Content-Type").String("application/json")
	}

	if input.Request != nil {
		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentExchangeCodeForTokenRequestBody(input.Request, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	} else {
		jsonEncoder := smithyjson.NewEncoder()
		jsonEncoder.Value.Object().Close()
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}

	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsExchangeCodeForTokenInput(v *ExchangeCodeForTokenInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.Provider) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member provider must not be empty")}
	}
	if len(v.Provider) > 0 {
		if err := encoder.SetURI("provider").String(string(v.Provider)); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpExportComponents struct {
}

func (*awsRestjson1_serializeOpExportComponents) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpExportComponents) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ExportComponentsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/export/app/{appId}/environment/{environmentName}/components")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsExportComponentsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsExportComponentsInput(v *ExportComponentsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpExportThemes struct {
}

func (*awsRestjson1_serializeOpExportThemes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpExportThemes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ExportThemesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/export/app/{appId}/environment/{environmentName}/themes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsExportThemesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsExportThemesInput(v *ExportThemesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetComponent struct {
}

func (*awsRestjson1_serializeOpGetComponent) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetComponent) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetComponentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app/{appId}/environment/{environmentName}/components/{id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetComponentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetComponentInput(v *GetComponentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetTheme struct {
}

func (*awsRestjson1_serializeOpGetTheme) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetTheme) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetThemeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app/{appId}/environment/{environmentName}/themes/{id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetThemeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetThemeInput(v *GetThemeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpListComponents struct {
}

func (*awsRestjson1_serializeOpListComponents) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListComponents) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListComponentsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app/{appId}/environment/{environmentName}/components")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListComponentsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListComponentsInput(v *ListComponentsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListThemes struct {
}

func (*awsRestjson1_serializeOpListThemes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListThemes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListThemesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app/{appId}/environment/{environmentName}/themes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListThemesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListThemesInput(v *ListThemesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpRefreshToken struct {
}

func (*awsRestjson1_serializeOpRefreshToken) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRefreshToken) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RefreshTokenInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/tokens/{provider}/refresh")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRefreshTokenInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		restEncoder.SetHeader("Content-Type").String("application/json")
	}

	if input.RefreshTokenBody != nil {
		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentRefreshTokenRequestBody(input.RefreshTokenBody, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	} else {
		jsonEncoder := smithyjson.NewEncoder()
		jsonEncoder.Value.Object().Close()
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}

	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRefreshTokenInput(v *RefreshTokenInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if len(v.Provider) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member provider must not be empty")}
	}
	if len(v.Provider) > 0 {
		if err := encoder.SetURI("provider").String(string(v.Provider)); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateComponent struct {
}

func (*awsRestjson1_serializeOpUpdateComponent) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateComponent) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateComponentInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app/{appId}/environment/{environmentName}/components/{id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateComponentInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		restEncoder.SetHeader("Content-Type").String("application/json")
	}

	if input.UpdatedComponent != nil {
		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentUpdateComponentData(input.UpdatedComponent, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	} else {
		jsonEncoder := smithyjson.NewEncoder()
		jsonEncoder.Value.Object().Close()
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}

	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateComponentInput(v *UpdateComponentInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		encoder.SetQuery("clientToken").String(*v.ClientToken)
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateTheme struct {
}

func (*awsRestjson1_serializeOpUpdateTheme) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateTheme) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateThemeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/app/{appId}/environment/{environmentName}/themes/{id}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateThemeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if !restEncoder.HasHeader("Content-Type") {
		restEncoder.SetHeader("Content-Type").String("application/json")
	}

	if input.UpdatedTheme != nil {
		jsonEncoder := smithyjson.NewEncoder()
		if err := awsRestjson1_serializeDocumentUpdateThemeData(input.UpdatedTheme, jsonEncoder.Value); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}
	} else {
		jsonEncoder := smithyjson.NewEncoder()
		jsonEncoder.Value.Object().Close()
		payload := bytes.NewReader(jsonEncoder.Bytes())
		if request, err = request.SetStream(payload); err != nil {
			return out, metadata, &smithy.SerializationError{Err: err}
		}

	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateThemeInput(v *UpdateThemeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.AppId == nil || len(*v.AppId) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member appId must not be empty")}
	}
	if v.AppId != nil {
		if err := encoder.SetURI("appId").String(*v.AppId); err != nil {
			return err
		}
	}

	if v.ClientToken != nil {
		encoder.SetQuery("clientToken").String(*v.ClientToken)
	}

	if v.EnvironmentName == nil || len(*v.EnvironmentName) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member environmentName must not be empty")}
	}
	if v.EnvironmentName != nil {
		if err := encoder.SetURI("environmentName").String(*v.EnvironmentName); err != nil {
			return err
		}
	}

	if v.Id == nil || len(*v.Id) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member id must not be empty")}
	}
	if v.Id != nil {
		if err := encoder.SetURI("id").String(*v.Id); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentComponentBindingProperties(v map[string]types.ComponentBindingPropertiesValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentComponentBindingPropertiesValue(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentComponentBindingPropertiesValue(v *types.ComponentBindingPropertiesValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BindingProperties != nil {
		ok := object.Key("bindingProperties")
		if err := awsRestjson1_serializeDocumentComponentBindingPropertiesValueProperties(v.BindingProperties, ok); err != nil {
			return err
		}
	}

	if v.DefaultValue != nil {
		ok := object.Key("defaultValue")
		ok.String(*v.DefaultValue)
	}

	if v.Type != nil {
		ok := object.Key("type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentComponentBindingPropertiesValueProperties(v *types.ComponentBindingPropertiesValueProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bucket != nil {
		ok := object.Key("bucket")
		ok.String(*v.Bucket)
	}

	if v.DefaultValue != nil {
		ok := object.Key("defaultValue")
		ok.String(*v.DefaultValue)
	}

	if v.Field != nil {
		ok := object.Key("field")
		ok.String(*v.Field)
	}

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.Model != nil {
		ok := object.Key("model")
		ok.String(*v.Model)
	}

	if v.Predicates != nil {
		ok := object.Key("predicates")
		if err := awsRestjson1_serializeDocumentPredicateList(v.Predicates, ok); err != nil {
			return err
		}
	}

	if v.UserAttribute != nil {
		ok := object.Key("userAttribute")
		ok.String(*v.UserAttribute)
	}

	return nil
}

func awsRestjson1_serializeDocumentComponentChild(v *types.ComponentChild, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Children != nil {
		ok := object.Key("children")
		if err := awsRestjson1_serializeDocumentComponentChildList(v.Children, ok); err != nil {
			return err
		}
	}

	if v.ComponentType != nil {
		ok := object.Key("componentType")
		ok.String(*v.ComponentType)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Properties != nil {
		ok := object.Key("properties")
		if err := awsRestjson1_serializeDocumentComponentProperties(v.Properties, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentComponentChildList(v []types.ComponentChild, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentComponentChild(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentComponentCollectionProperties(v map[string]types.ComponentDataConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentComponentDataConfiguration(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentComponentConditionProperty(v *types.ComponentConditionProperty, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Else != nil {
		ok := object.Key("else")
		if err := awsRestjson1_serializeDocumentComponentProperty(v.Else, ok); err != nil {
			return err
		}
	}

	if v.Field != nil {
		ok := object.Key("field")
		ok.String(*v.Field)
	}

	if v.Operand != nil {
		ok := object.Key("operand")
		ok.String(*v.Operand)
	}

	if v.Operator != nil {
		ok := object.Key("operator")
		ok.String(*v.Operator)
	}

	if v.Property != nil {
		ok := object.Key("property")
		ok.String(*v.Property)
	}

	if v.Then != nil {
		ok := object.Key("then")
		if err := awsRestjson1_serializeDocumentComponentProperty(v.Then, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentComponentDataConfiguration(v *types.ComponentDataConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Identifiers != nil {
		ok := object.Key("identifiers")
		if err := awsRestjson1_serializeDocumentIdentifierList(v.Identifiers, ok); err != nil {
			return err
		}
	}

	if v.Model != nil {
		ok := object.Key("model")
		ok.String(*v.Model)
	}

	if v.Predicate != nil {
		ok := object.Key("predicate")
		if err := awsRestjson1_serializeDocumentPredicate(v.Predicate, ok); err != nil {
			return err
		}
	}

	if v.Sort != nil {
		ok := object.Key("sort")
		if err := awsRestjson1_serializeDocumentSortPropertyList(v.Sort, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentComponentOverrides(v map[string]map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		if vv := v[key]; vv == nil {
			continue
		}
		if err := awsRestjson1_serializeDocumentComponentOverridesValue(v[key], om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentComponentOverridesValue(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentComponentProperties(v map[string]types.ComponentProperty, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentComponentProperty(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentComponentProperty(v *types.ComponentProperty, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BindingProperties != nil {
		ok := object.Key("bindingProperties")
		if err := awsRestjson1_serializeDocumentComponentPropertyBindingProperties(v.BindingProperties, ok); err != nil {
			return err
		}
	}

	if v.Bindings != nil {
		ok := object.Key("bindings")
		if err := awsRestjson1_serializeDocumentFormBindings(v.Bindings, ok); err != nil {
			return err
		}
	}

	if v.CollectionBindingProperties != nil {
		ok := object.Key("collectionBindingProperties")
		if err := awsRestjson1_serializeDocumentComponentPropertyBindingProperties(v.CollectionBindingProperties, ok); err != nil {
			return err
		}
	}

	if v.Concat != nil {
		ok := object.Key("concat")
		if err := awsRestjson1_serializeDocumentComponentPropertyList(v.Concat, ok); err != nil {
			return err
		}
	}

	if v.Condition != nil {
		ok := object.Key("condition")
		if err := awsRestjson1_serializeDocumentComponentConditionProperty(v.Condition, ok); err != nil {
			return err
		}
	}

	if v.Configured != nil {
		ok := object.Key("configured")
		ok.Boolean(*v.Configured)
	}

	if v.DefaultValue != nil {
		ok := object.Key("defaultValue")
		ok.String(*v.DefaultValue)
	}

	if v.Event != nil {
		ok := object.Key("event")
		ok.String(*v.Event)
	}

	if v.ImportedValue != nil {
		ok := object.Key("importedValue")
		ok.String(*v.ImportedValue)
	}

	if v.Model != nil {
		ok := object.Key("model")
		ok.String(*v.Model)
	}

	if v.Type != nil {
		ok := object.Key("type")
		ok.String(*v.Type)
	}

	if v.UserAttribute != nil {
		ok := object.Key("userAttribute")
		ok.String(*v.UserAttribute)
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentComponentPropertyBindingProperties(v *types.ComponentPropertyBindingProperties, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Field != nil {
		ok := object.Key("field")
		ok.String(*v.Field)
	}

	if v.Property != nil {
		ok := object.Key("property")
		ok.String(*v.Property)
	}

	return nil
}

func awsRestjson1_serializeDocumentComponentPropertyList(v []types.ComponentProperty, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentComponentProperty(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentComponentVariant(v *types.ComponentVariant, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Overrides != nil {
		ok := object.Key("overrides")
		if err := awsRestjson1_serializeDocumentComponentOverrides(v.Overrides, ok); err != nil {
			return err
		}
	}

	if v.VariantValues != nil {
		ok := object.Key("variantValues")
		if err := awsRestjson1_serializeDocumentComponentVariantValues(v.VariantValues, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentComponentVariants(v []types.ComponentVariant, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentComponentVariant(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentComponentVariantValues(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentCreateComponentData(v *types.CreateComponentData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BindingProperties != nil {
		ok := object.Key("bindingProperties")
		if err := awsRestjson1_serializeDocumentComponentBindingProperties(v.BindingProperties, ok); err != nil {
			return err
		}
	}

	if v.Children != nil {
		ok := object.Key("children")
		if err := awsRestjson1_serializeDocumentComponentChildList(v.Children, ok); err != nil {
			return err
		}
	}

	if v.CollectionProperties != nil {
		ok := object.Key("collectionProperties")
		if err := awsRestjson1_serializeDocumentComponentCollectionProperties(v.CollectionProperties, ok); err != nil {
			return err
		}
	}

	if v.ComponentType != nil {
		ok := object.Key("componentType")
		ok.String(*v.ComponentType)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Overrides != nil {
		ok := object.Key("overrides")
		if err := awsRestjson1_serializeDocumentComponentOverrides(v.Overrides, ok); err != nil {
			return err
		}
	}

	if v.Properties != nil {
		ok := object.Key("properties")
		if err := awsRestjson1_serializeDocumentComponentProperties(v.Properties, ok); err != nil {
			return err
		}
	}

	if v.SourceId != nil {
		ok := object.Key("sourceId")
		ok.String(*v.SourceId)
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Variants != nil {
		ok := object.Key("variants")
		if err := awsRestjson1_serializeDocumentComponentVariants(v.Variants, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCreateThemeData(v *types.CreateThemeData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Overrides != nil {
		ok := object.Key("overrides")
		if err := awsRestjson1_serializeDocumentThemeValuesList(v.Overrides, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocumentTags(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.Values != nil {
		ok := object.Key("values")
		if err := awsRestjson1_serializeDocumentThemeValuesList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentExchangeCodeForTokenRequestBody(v *types.ExchangeCodeForTokenRequestBody, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Code != nil {
		ok := object.Key("code")
		ok.String(*v.Code)
	}

	if v.RedirectUri != nil {
		ok := object.Key("redirectUri")
		ok.String(*v.RedirectUri)
	}

	return nil
}

func awsRestjson1_serializeDocumentFormBindingElement(v *types.FormBindingElement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Element != nil {
		ok := object.Key("element")
		ok.String(*v.Element)
	}

	if v.Property != nil {
		ok := object.Key("property")
		ok.String(*v.Property)
	}

	return nil
}

func awsRestjson1_serializeDocumentFormBindings(v map[string]types.FormBindingElement, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsRestjson1_serializeDocumentFormBindingElement(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentIdentifierList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocumentPredicate(v *types.Predicate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.And != nil {
		ok := object.Key("and")
		if err := awsRestjson1_serializeDocumentPredicateList(v.And, ok); err != nil {
			return err
		}
	}

	if v.Field != nil {
		ok := object.Key("field")
		ok.String(*v.Field)
	}

	if v.Operand != nil {
		ok := object.Key("operand")
		ok.String(*v.Operand)
	}

	if v.Operator != nil {
		ok := object.Key("operator")
		ok.String(*v.Operator)
	}

	if v.Or != nil {
		ok := object.Key("or")
		if err := awsRestjson1_serializeDocumentPredicateList(v.Or, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPredicateList(v []types.Predicate, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentPredicate(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentRefreshTokenRequestBody(v *types.RefreshTokenRequestBody, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Token != nil {
		ok := object.Key("token")
		ok.String(*v.Token)
	}

	return nil
}

func awsRestjson1_serializeDocumentSortProperty(v *types.SortProperty, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Direction) > 0 {
		ok := object.Key("direction")
		ok.String(string(v.Direction))
	}

	if v.Field != nil {
		ok := object.Key("field")
		ok.String(*v.Field)
	}

	return nil
}

func awsRestjson1_serializeDocumentSortPropertyList(v []types.SortProperty, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentSortProperty(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentTags(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentThemeValue(v *types.ThemeValue, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Children != nil {
		ok := object.Key("children")
		if err := awsRestjson1_serializeDocumentThemeValuesList(v.Children, ok); err != nil {
			return err
		}
	}

	if v.Value != nil {
		ok := object.Key("value")
		ok.String(*v.Value)
	}

	return nil
}

func awsRestjson1_serializeDocumentThemeValues(v *types.ThemeValues, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("value")
		if err := awsRestjson1_serializeDocumentThemeValue(v.Value, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentThemeValuesList(v []types.ThemeValues, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentThemeValues(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocumentUpdateComponentData(v *types.UpdateComponentData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BindingProperties != nil {
		ok := object.Key("bindingProperties")
		if err := awsRestjson1_serializeDocumentComponentBindingProperties(v.BindingProperties, ok); err != nil {
			return err
		}
	}

	if v.Children != nil {
		ok := object.Key("children")
		if err := awsRestjson1_serializeDocumentComponentChildList(v.Children, ok); err != nil {
			return err
		}
	}

	if v.CollectionProperties != nil {
		ok := object.Key("collectionProperties")
		if err := awsRestjson1_serializeDocumentComponentCollectionProperties(v.CollectionProperties, ok); err != nil {
			return err
		}
	}

	if v.ComponentType != nil {
		ok := object.Key("componentType")
		ok.String(*v.ComponentType)
	}

	if v.Id != nil {
		ok := object.Key("id")
		ok.String(*v.Id)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Overrides != nil {
		ok := object.Key("overrides")
		if err := awsRestjson1_serializeDocumentComponentOverrides(v.Overrides, ok); err != nil {
			return err
		}
	}

	if v.Properties != nil {
		ok := object.Key("properties")
		if err := awsRestjson1_serializeDocumentComponentProperties(v.Properties, ok); err != nil {
			return err
		}
	}

	if v.SourceId != nil {
		ok := object.Key("sourceId")
		ok.String(*v.SourceId)
	}

	if v.Variants != nil {
		ok := object.Key("variants")
		if err := awsRestjson1_serializeDocumentComponentVariants(v.Variants, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentUpdateThemeData(v *types.UpdateThemeData, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Id != nil {
		ok := object.Key("id")
		ok.String(*v.Id)
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.Overrides != nil {
		ok := object.Key("overrides")
		if err := awsRestjson1_serializeDocumentThemeValuesList(v.Overrides, ok); err != nil {
			return err
		}
	}

	if v.Values != nil {
		ok := object.Key("values")
		if err := awsRestjson1_serializeDocumentThemeValuesList(v.Values, ok); err != nil {
			return err
		}
	}

	return nil
}
