// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A single action condition for a Condition in a logging filter.
type ActionCondition struct {

	// The action setting that a log record must contain in order to meet the
	// condition.
	//
	// This member is required.
	Action ActionValue

	noSmithyDocumentSerde
}

// Inspect all of the elements that WAF has parsed and extracted from the web
// request JSON body that are within the JsonBodyMatchScope. This is used with the
// FieldToMatch option JsonBody. This is used only to indicate the web request
// component for WAF to inspect, in the FieldToMatch specification. JSON
// specification: "All": {}
type All struct {
	noSmithyDocumentSerde
}

// Specifies that WAF should allow the request and optionally defines additional
// custom handling for the request. This is used in the context of other settings,
// for example to specify values for RuleAction and web ACL DefaultAction.
type AllowAction struct {

	// Defines custom handling for the web request. For information about customizing
	// web requests and responses, see Customizing web requests and responses in WAF
	// (https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html)
	// in the WAF Developer Guide
	// (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	CustomRequestHandling *CustomRequestHandling

	noSmithyDocumentSerde
}

// All query arguments of a web request. This is used only to indicate the web
// request component for WAF to inspect, in the FieldToMatch specification. JSON
// specification: "AllQueryArguments": {}
type AllQueryArguments struct {
	noSmithyDocumentSerde
}

// A logical rule statement used to combine other rule statements with AND logic.
// You provide more than one Statement within the AndStatement.
type AndStatement struct {

	// The statements to combine with AND logic. You can use any statements that can be
	// nested.
	//
	// This member is required.
	Statements []Statement

	noSmithyDocumentSerde
}

// Specifies that WAF should block the request and optionally defines additional
// custom handling for the response to the web request. This is used in the context
// of other settings, for example to specify values for RuleAction and web ACL
// DefaultAction.
type BlockAction struct {

	// Defines a custom response for the web request. For information about customizing
	// web requests and responses, see Customizing web requests and responses in WAF
	// (https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html)
	// in the WAF Developer Guide
	// (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	CustomResponse *CustomResponse

	noSmithyDocumentSerde
}

// The body of a web request. This immediately follows the request headers. This is
// used only to indicate the web request component for WAF to inspect, in the
// FieldToMatch specification. JSON specification: "Body": {}
type Body struct {
	noSmithyDocumentSerde
}

// A rule statement that defines a string match search for WAF to apply to web
// requests. The byte match statement provides the bytes to search for, the
// location in requests that you want WAF to search, and other settings. The bytes
// to search for are typically a string that corresponds with ASCII characters. In
// the WAF console and the developer guide, this is refered to as a string match
// statement.
type ByteMatchStatement struct {

	// The part of a web request that you want WAF to inspect. For more information,
	// see FieldToMatch.
	//
	// This member is required.
	FieldToMatch *FieldToMatch

	// The area within the portion of a web request that you want WAF to search for
	// SearchString. Valid values include the following: CONTAINS The specified part of
	// the web request must include the value of SearchString, but the location doesn't
	// matter. CONTAINS_WORD The specified part of the web request must include the
	// value of SearchString, and SearchString must contain only alphanumeric
	// characters or underscore (A-Z, a-z, 0-9, or _). In addition, SearchString must
	// be a word, which means that both of the following are true:
	//
	// * SearchString is
	// at the beginning of the specified part of the web request or is preceded by a
	// character other than an alphanumeric character or underscore (_). Examples
	// include the value of a header and ;BadBot.
	//
	// * SearchString is at the end of the
	// specified part of the web request or is followed by a character other than an
	// alphanumeric character or underscore (_), for example, BadBot; and
	// -BadBot;.
	//
	// EXACTLY The value of the specified part of the web request must
	// exactly match the value of SearchString. STARTS_WITH The value of SearchString
	// must appear at the beginning of the specified part of the web request. ENDS_WITH
	// The value of SearchString must appear at the end of the specified part of the
	// web request.
	//
	// This member is required.
	PositionalConstraint PositionalConstraint

	// A string value that you want WAF to search for. WAF searches only in the part of
	// web requests that you designate for inspection in FieldToMatch. The maximum
	// length of the value is 50 bytes. Valid values depend on the component that you
	// specify for inspection in FieldToMatch:
	//
	// * Method: The HTTP method that you want
	// WAF to search for. This indicates the type of operation specified in the
	// request.
	//
	// * UriPath: The value that you want WAF to search for in the URI path,
	// for example, /images/daily-ad.jpg.
	//
	// If SearchString includes alphabetic
	// characters A-Z and a-z, note that the value is case sensitive. If you're using
	// the WAF API Specify a base64-encoded version of the value. The maximum length of
	// the value before you base64-encode it is 50 bytes. For example, suppose the
	// value of Type is HEADER and the value of Data is User-Agent. If you want to
	// search the User-Agent header for the value BadBot, you base64-encode BadBot
	// using MIME base64-encoding and include the resulting value, QmFkQm90, in the
	// value of SearchString. If you're using the CLI or one of the Amazon Web Services
	// SDKs The value that you want WAF to search for. The SDK automatically base64
	// encodes the value.
	//
	// This member is required.
	SearchString []byte

	// Text transformations eliminate some of the unusual formatting that attackers use
	// in web requests in an effort to bypass detection. If you specify one or more
	// transformations in a rule statement, WAF performs all transformations on the
	// content of the request component identified by FieldToMatch, starting from the
	// lowest priority setting, before inspecting the content for a match.
	//
	// This member is required.
	TextTransformations []TextTransformation

	noSmithyDocumentSerde
}

// Specifies that WAF should run a CAPTCHA check against the request:
//
// * If the
// request includes a valid, unexpired CAPTCHA token, WAF allows the web request
// inspection to proceed to the next rule, similar to a CountAction.
//
// * If the
// request doesn't include a valid, unexpired CAPTCHA token, WAF discontinues the
// web ACL evaluation of the request and blocks it from going to its intended
// destination. WAF generates a response that it sends back to the client, which
// includes the following:
//
// * The header x-amzn-waf-action with a value of
// captcha.
//
// * The HTTP status code 405 Method Not Allowed.
//
// * If the request
// contains an Accept header with a value of text/html, the response includes a
// CAPTCHA challenge.
//
// You can configure the expiration time in the
// CaptchaConfigImmunityTimeProperty setting at the rule and web ACL level. The
// rule setting overrides the web ACL setting. This action option is available for
// rules. It isn't available for web ACL default actions. This is used in the
// context of other settings, for example to specify values for RuleAction and web
// ACL DefaultAction.
type CaptchaAction struct {

	// Defines custom handling for the web request. For information about customizing
	// web requests and responses, see Customizing web requests and responses in WAF
	// (https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html)
	// in the WAF Developer Guide
	// (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	CustomRequestHandling *CustomRequestHandling

	noSmithyDocumentSerde
}

// Specifies how WAF should handle CAPTCHA evaluations. This is available at the
// web ACL level and in each rule.
type CaptchaConfig struct {

	// Determines how long a CAPTCHA token remains valid after the client successfully
	// solves a CAPTCHA puzzle.
	ImmunityTimeProperty *ImmunityTimeProperty

	noSmithyDocumentSerde
}

// The result from the inspection of the web request for a valid CAPTCHA token.
type CaptchaResponse struct {

	// The reason for failure, populated when the evaluation of the token fails.
	FailureReason FailureReason

	// The HTTP response code indicating the status of the CAPTCHA token in the web
	// request. If the token is missing, invalid, or expired, this code is 405 Method
	// Not Allowed.
	ResponseCode *int32

	// The time that the CAPTCHA puzzle was solved for the supplied token.
	SolveTimestamp *int64

	noSmithyDocumentSerde
}

// A single match condition for a Filter.
type Condition struct {

	// A single action condition.
	ActionCondition *ActionCondition

	// A single label name condition.
	LabelNameCondition *LabelNameCondition

	noSmithyDocumentSerde
}

// Specifies that WAF should count the request. Optionally defines additional
// custom handling for the request. This is used in the context of other settings,
// for example to specify values for RuleAction and web ACL DefaultAction.
type CountAction struct {

	// Defines custom handling for the web request. For information about customizing
	// web requests and responses, see Customizing web requests and responses in WAF
	// (https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html)
	// in the WAF Developer Guide
	// (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	CustomRequestHandling *CustomRequestHandling

	noSmithyDocumentSerde
}

// A custom header for custom request and response handling. This is used in
// CustomResponse and CustomRequestHandling.
type CustomHTTPHeader struct {

	// The name of the custom header. For custom request header insertion, when WAF
	// inserts the header into the request, it prefixes this name x-amzn-waf-, to avoid
	// confusion with the headers that are already in the request. For example, for the
	// header name sample, WAF inserts the header x-amzn-waf-sample.
	//
	// This member is required.
	Name *string

	// The value of the custom header.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Custom request handling behavior that inserts custom headers into a web request.
// You can add custom request handling for the rule actions allow and count. For
// information about customizing web requests and responses, see Customizing web
// requests and responses in WAF
// (https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html)
// in the WAF Developer Guide
// (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
type CustomRequestHandling struct {

	// The HTTP headers to insert into the request. Duplicate header names are not
	// allowed. For information about the limits on count and size for custom request
	// and response settings, see WAF quotas
	// (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in the WAF
	// Developer Guide
	// (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	//
	// This member is required.
	InsertHeaders []CustomHTTPHeader

	noSmithyDocumentSerde
}

// A custom response to send to the client. You can define a custom response for
// rule actions and default web ACL actions that are set to BlockAction. For
// information about customizing web requests and responses, see Customizing web
// requests and responses in WAF
// (https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html)
// in the WAF Developer Guide
// (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
type CustomResponse struct {

	// The HTTP status code to return to the client. For a list of status codes that
	// you can use in your custom reqponses, see Supported status codes for custom
	// response
	// (https://docs.aws.amazon.com/waf/latest/developerguide/customizing-the-response-status-codes.html)
	// in the WAF Developer Guide
	// (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	//
	// This member is required.
	ResponseCode *int32

	// References the response body that you want WAF to return to the web request
	// client. You can define a custom response for a rule action or a default web ACL
	// action that is set to block. To do this, you first define the response body key
	// and value in the CustomResponseBodies setting for the WebACL or RuleGroup where
	// you want to use it. Then, in the rule action or web ACL default action
	// BlockAction setting, you reference the response body using this key.
	CustomResponseBodyKey *string

	// The HTTP headers to use in the response. Duplicate header names are not allowed.
	// For information about the limits on count and size for custom request and
	// response settings, see WAF quotas
	// (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in the WAF
	// Developer Guide
	// (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	ResponseHeaders []CustomHTTPHeader

	noSmithyDocumentSerde
}

// The response body to use in a custom response to a web request. This is
// referenced by key from CustomResponseCustomResponseBodyKey.
type CustomResponseBody struct {

	// The payload of the custom response. You can use JSON escape strings in JSON
	// content. To do this, you must specify JSON content in the ContentType setting.
	// For information about the limits on count and size for custom request and
	// response settings, see WAF quotas
	// (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in the WAF
	// Developer Guide
	// (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	//
	// This member is required.
	Content *string

	// The type of content in the payload that you are defining in the Content string.
	//
	// This member is required.
	ContentType ResponseContentType

	noSmithyDocumentSerde
}

// In a WebACL, this is the action that you want WAF to perform when a web request
// doesn't match any of the rules in the WebACL. The default action must be a
// terminating action, so you can't use count.
type DefaultAction struct {

	// Specifies that WAF should allow requests by default.
	Allow *AllowAction

	// Specifies that WAF should block requests by default.
	Block *BlockAction

	noSmithyDocumentSerde
}

// Specifies a single rule in a rule group whose action you want to override to
// Count. When you exclude a rule, WAF evaluates it exactly as it would if the rule
// action setting were Count. This is a useful option for testing the rules in a
// rule group without modifying how they handle your web traffic.
type ExcludedRule struct {

	// The name of the rule whose action you want to override to Count.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// The part of a web request that you want WAF to inspect. Include the single
// FieldToMatch type that you want to inspect, with additional specifications as
// needed, according to the type. You specify a single request component in
// FieldToMatch for each rule statement that requires it. To inspect more than one
// component of a web request, create a separate rule statement for each component.
// JSON specification for a QueryString field to match:  "FieldToMatch": {
// "QueryString": {} } Example JSON for a Method field to match specification:
// "FieldToMatch": { "Method": { "Name": "DELETE" } }
type FieldToMatch struct {

	// Inspect all query arguments.
	AllQueryArguments *AllQueryArguments

	// Inspect the request body as plain text. The request body immediately follows the
	// request headers. This is the part of a request that contains any additional data
	// that you want to send to your web server as the HTTP request body, such as data
	// from a form. Note that only the first 8 KB (8192 bytes) of the request body are
	// forwarded to WAF for inspection by the underlying host service. If you don't
	// need to inspect more than 8 KB, you can guarantee that you don't allow
	// additional bytes in by combining a statement that inspects the body of the web
	// request, such as ByteMatchStatement or RegexPatternSetReferenceStatement, with a
	// SizeConstraintStatement that enforces an 8 KB size limit on the body of the
	// request. WAF doesn't support inspecting the entire contents of web requests
	// whose bodies exceed the 8 KB limit.
	Body *Body

	// Inspect the request body as JSON. The request body immediately follows the
	// request headers. This is the part of a request that contains any additional data
	// that you want to send to your web server as the HTTP request body, such as data
	// from a form. Note that only the first 8 KB (8192 bytes) of the request body are
	// forwarded to WAF for inspection by the underlying host service. If you don't
	// need to inspect more than 8 KB, you can guarantee that you don't allow
	// additional bytes in by combining a statement that inspects the body of the web
	// request, such as ByteMatchStatement or RegexPatternSetReferenceStatement, with a
	// SizeConstraintStatement that enforces an 8 KB size limit on the body of the
	// request. WAF doesn't support inspecting the entire contents of web requests
	// whose bodies exceed the 8 KB limit.
	JsonBody *JsonBody

	// Inspect the HTTP method. The method indicates the type of operation that the
	// request is asking the origin to perform.
	Method *Method

	// Inspect the query string. This is the part of a URL that appears after a ?
	// character, if any.
	QueryString *QueryString

	// Inspect a single header. Provide the name of the header to inspect, for example,
	// User-Agent or Referer. This setting isn't case sensitive. Example JSON:
	// "SingleHeader": { "Name": "haystack" }
	SingleHeader *SingleHeader

	// Inspect a single query argument. Provide the name of the query argument to
	// inspect, such as UserName or SalesRegion. The name can be up to 30 characters
	// long and isn't case sensitive. This is used only to indicate the web request
	// component for WAF to inspect, in the FieldToMatch specification. Example JSON:
	// "SingleQueryArgument": { "Name": "myArgument" }
	SingleQueryArgument *SingleQueryArgument

	// Inspect the request URI path. This is the part of a web request that identifies
	// a resource, for example, /images/daily-ad.jpg.
	UriPath *UriPath

	noSmithyDocumentSerde
}

// A single logging filter, used in LoggingFilter.
type Filter struct {

	// How to handle logs that satisfy the filter's conditions and requirement.
	//
	// This member is required.
	Behavior FilterBehavior

	// Match conditions for the filter.
	//
	// This member is required.
	Conditions []Condition

	// Logic to apply to the filtering conditions. You can specify that, in order to
	// satisfy the filter, a log must match all conditions or must match at least one
	// condition.
	//
	// This member is required.
	Requirement FilterRequirement

	noSmithyDocumentSerde
}

// A rule group that's defined for an Firewall Manager WAF policy.
type FirewallManagerRuleGroup struct {

	// The processing guidance for an Firewall Manager rule. This is like a regular
	// rule Statement, but it can only contain a rule group reference.
	//
	// This member is required.
	FirewallManagerStatement *FirewallManagerStatement

	// The name of the rule group. You cannot change the name of a rule group after you
	// create it.
	//
	// This member is required.
	Name *string

	// The action to use in the place of the action that results from the rule group
	// evaluation. Set the override action to none to leave the result of the rule
	// group alone. Set it to count to override the result to count only. You can only
	// use this for rule statements that reference a rule group, like
	// RuleGroupReferenceStatement and ManagedRuleGroupStatement. This option is
	// usually set to none. It does not affect how the rules in the rule group are
	// evaluated. If you want the rules in the rule group to only count matches, do not
	// use this and instead exclude those rules in your rule group reference statement
	// settings.
	//
	// This member is required.
	OverrideAction *OverrideAction

	// If you define more than one rule group in the first or last Firewall Manager
	// rule groups, WAF evaluates each request against the rule groups in order,
	// starting from the lowest priority setting. The priorities don't need to be
	// consecutive, but they must all be different.
	//
	// This member is required.
	Priority int32

	// Defines and enables Amazon CloudWatch metrics and web request sample collection.
	//
	// This member is required.
	VisibilityConfig *VisibilityConfig

	noSmithyDocumentSerde
}

// The processing guidance for an Firewall Manager rule. This is like a regular
// rule Statement, but it can only contain a rule group reference.
type FirewallManagerStatement struct {

	// A rule statement used to run the rules that are defined in a managed rule group.
	// To use this, provide the vendor name and the name of the rule group in this
	// statement. You can retrieve the required names by calling
	// ListAvailableManagedRuleGroups. You cannot nest a ManagedRuleGroupStatement, for
	// example for use inside a NotStatement or OrStatement. It can only be referenced
	// as a top-level statement within a rule.
	ManagedRuleGroupStatement *ManagedRuleGroupStatement

	// A rule statement used to run the rules that are defined in a RuleGroup. To use
	// this, create a rule group with your rules, then provide the ARN of the rule
	// group in this statement. You cannot nest a RuleGroupReferenceStatement, for
	// example for use inside a NotStatement or OrStatement. You can only use a rule
	// group reference statement at the top level inside a web ACL.
	RuleGroupReferenceStatement *RuleGroupReferenceStatement

	noSmithyDocumentSerde
}

// The configuration for inspecting IP addresses in an HTTP header that you
// specify, instead of using the IP address that's reported by the web request
// origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify
// any header name. If the specified header isn't present in the request, WAF
// doesn't apply the rule to the web request at all. This configuration is used for
// GeoMatchStatement and RateBasedStatement. For IPSetReferenceStatement, use
// IPSetForwardedIPConfig instead. WAF only evaluates the first IP address found in
// the specified HTTP header.
type ForwardedIPConfig struct {

	// The match status to assign to the web request if the request doesn't have a
	// valid IP address in the specified position. If the specified header isn't
	// present in the request, WAF doesn't apply the rule to the web request at all.
	// You can specify the following fallback behaviors:
	//
	// * MATCH - Treat the web
	// request as matching the rule statement. WAF applies the rule action to the
	// request.
	//
	// * NO_MATCH - Treat the web request as not matching the rule statement.
	//
	// This member is required.
	FallbackBehavior FallbackBehavior

	// The name of the HTTP header to use for the IP address. For example, to use the
	// X-Forwarded-For (XFF) header, set this to X-Forwarded-For. If the specified
	// header isn't present in the request, WAF doesn't apply the rule to the web
	// request at all.
	//
	// This member is required.
	HeaderName *string

	noSmithyDocumentSerde
}

// A rule statement used to identify web requests based on country of origin.
type GeoMatchStatement struct {

	// An array of two-character country codes, for example, [ "US", "CN" ], from the
	// alpha-2 country ISO codes of the ISO 3166 international standard.
	CountryCodes []CountryCode

	// The configuration for inspecting IP addresses in an HTTP header that you
	// specify, instead of using the IP address that's reported by the web request
	// origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify
	// any header name. If the specified header isn't present in the request, WAF
	// doesn't apply the rule to the web request at all.
	ForwardedIPConfig *ForwardedIPConfig

	noSmithyDocumentSerde
}

// Part of the response from GetSampledRequests. This is a complex type that
// appears as Headers in the response syntax. HTTPHeader contains the names and
// values of all of the headers that appear in one of the web requests.
type HTTPHeader struct {

	// The name of the HTTP header.
	Name *string

	// The value of the HTTP header.
	Value *string

	noSmithyDocumentSerde
}

// Part of the response from GetSampledRequests. This is a complex type that
// appears as Request in the response syntax. HTTPRequest contains information
// about one of the web requests.
type HTTPRequest struct {

	// The IP address that the request originated from. If the web ACL is associated
	// with a CloudFront distribution, this is the value of one of the following fields
	// in CloudFront access logs:
	//
	// * c-ip, if the viewer did not use an HTTP proxy or a
	// load balancer to send the request
	//
	// * x-forwarded-for, if the viewer did use an
	// HTTP proxy or a load balancer to send the request
	ClientIP *string

	// The two-letter country code for the country that the request originated from.
	// For a current list of country codes, see the Wikipedia entry ISO 3166-1 alpha-2
	// (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2).
	Country *string

	// The HTTP version specified in the sampled web request, for example, HTTP/1.1.
	HTTPVersion *string

	// A complex type that contains the name and value for each header in the sampled
	// web request.
	Headers []HTTPHeader

	// The HTTP method specified in the sampled web request.
	Method *string

	// The URI path of the request, which identifies the resource, for example,
	// /images/daily-ad.jpg.
	URI *string

	noSmithyDocumentSerde
}

// Determines how long a CAPTCHA token remains valid after the client successfully
// solves a CAPTCHA puzzle.
type ImmunityTimeProperty struct {

	// The amount of time, in seconds, that a CAPTCHA token is valid. The default
	// setting is 300.
	//
	// This member is required.
	ImmunityTime *int64

	noSmithyDocumentSerde
}

// Contains one or more IP addresses or blocks of IP addresses specified in
// Classless Inter-Domain Routing (CIDR) notation. WAF supports all IPv4 and IPv6
// CIDR ranges except for /0. For information about CIDR notation, see the
// Wikipedia entry Classless Inter-Domain Routing
// (https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing). WAF assigns an
// ARN to each IPSet that you create. To use an IP set in a rule, you provide the
// ARN to the Rule statement IPSetReferenceStatement.
type IPSet struct {

	// The Amazon Resource Name (ARN) of the entity.
	//
	// This member is required.
	ARN *string

	// Contains an array of strings that specify one or more IP addresses or blocks of
	// IP addresses in Classless Inter-Domain Routing (CIDR) notation. WAF supports all
	// IPv4 and IPv6 CIDR ranges except for /0. Examples:
	//
	// * To configure WAF to allow,
	// block, or count requests that originated from the IP address 192.0.2.44, specify
	// 192.0.2.44/32.
	//
	// * To configure WAF to allow, block, or count requests that
	// originated from IP addresses from 192.0.2.0 to 192.0.2.255, specify
	// 192.0.2.0/24.
	//
	// * To configure WAF to allow, block, or count requests that
	// originated from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify
	// 1111:0000:0000:0000:0000:0000:0000:0111/128.
	//
	// * To configure WAF to allow,
	// block, or count requests that originated from IP addresses
	// 1111:0000:0000:0000:0000:0000:0000:0000 to
	// 1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify
	// 1111:0000:0000:0000:0000:0000:0000:0000/64.
	//
	// For more information about CIDR
	// notation, see the Wikipedia entry Classless Inter-Domain Routing
	// (https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
	//
	// This member is required.
	Addresses []string

	// The version of the IP addresses, either IPV4 or IPV6.
	//
	// This member is required.
	IPAddressVersion IPAddressVersion

	// A unique identifier for the set. This ID is returned in the responses to create
	// and list commands. You provide it to operations like update and delete.
	//
	// This member is required.
	Id *string

	// The name of the IP set. You cannot change the name of an IPSet after you create
	// it.
	//
	// This member is required.
	Name *string

	// A description of the IP set that helps with identification.
	Description *string

	noSmithyDocumentSerde
}

// The configuration for inspecting IP addresses in an HTTP header that you
// specify, instead of using the IP address that's reported by the web request
// origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify
// any header name. If the specified header isn't present in the request, WAF
// doesn't apply the rule to the web request at all. This configuration is used
// only for IPSetReferenceStatement. For GeoMatchStatement and RateBasedStatement,
// use ForwardedIPConfig instead.
type IPSetForwardedIPConfig struct {

	// The match status to assign to the web request if the request doesn't have a
	// valid IP address in the specified position. If the specified header isn't
	// present in the request, WAF doesn't apply the rule to the web request at all.
	// You can specify the following fallback behaviors:
	//
	// * MATCH - Treat the web
	// request as matching the rule statement. WAF applies the rule action to the
	// request.
	//
	// * NO_MATCH - Treat the web request as not matching the rule statement.
	//
	// This member is required.
	FallbackBehavior FallbackBehavior

	// The name of the HTTP header to use for the IP address. For example, to use the
	// X-Forwarded-For (XFF) header, set this to X-Forwarded-For. If the specified
	// header isn't present in the request, WAF doesn't apply the rule to the web
	// request at all.
	//
	// This member is required.
	HeaderName *string

	// The position in the header to search for the IP address. The header can contain
	// IP addresses of the original client and also of proxies. For example, the header
	// value could be 10.1.1.1, 127.0.0.0, 10.10.10.10 where the first IP address
	// identifies the original client and the rest identify proxies that the request
	// went through. The options for this setting are the following:
	//
	// * FIRST - Inspect
	// the first IP address in the list of IP addresses in the header. This is usually
	// the client's original IP.
	//
	// * LAST - Inspect the last IP address in the list of
	// IP addresses in the header.
	//
	// * ANY - Inspect all IP addresses in the header for
	// a match. If the header contains more than 10 IP addresses, WAF inspects the last
	// 10.
	//
	// This member is required.
	Position ForwardedIPPosition

	noSmithyDocumentSerde
}

// A rule statement used to detect web requests coming from particular IP addresses
// or address ranges. To use this, create an IPSet that specifies the addresses you
// want to detect, then use the ARN of that set in this statement. To create an IP
// set, see CreateIPSet. Each IP set rule statement references an IP set. You
// create and maintain the set independent of your rules. This allows you to use
// the single set in multiple rules. When you update the referenced set, WAF
// automatically updates all rules that reference it.
type IPSetReferenceStatement struct {

	// The Amazon Resource Name (ARN) of the IPSet that this statement references.
	//
	// This member is required.
	ARN *string

	// The configuration for inspecting IP addresses in an HTTP header that you
	// specify, instead of using the IP address that's reported by the web request
	// origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify
	// any header name. If the specified header isn't present in the request, WAF
	// doesn't apply the rule to the web request at all.
	IPSetForwardedIPConfig *IPSetForwardedIPConfig

	noSmithyDocumentSerde
}

// High-level information about an IPSet, returned by operations like create and
// list. This provides information like the ID, that you can use to retrieve and
// manage an IPSet, and the ARN, that you provide to the IPSetReferenceStatement to
// use the address set in a Rule.
type IPSetSummary struct {

	// The Amazon Resource Name (ARN) of the entity.
	ARN *string

	// A description of the IP set that helps with identification.
	Description *string

	// A unique identifier for the set. This ID is returned in the responses to create
	// and list commands. You provide it to operations like update and delete.
	Id *string

	// A token used for optimistic locking. WAF returns a token to your get and list
	// requests, to mark the state of the entity at the time of the request. To make
	// changes to the entity associated with the token, you provide the token to
	// operations like update and delete. WAF uses the token to ensure that no changes
	// have been made to the entity since you last retrieved it. If a change has been
	// made, the update fails with a WAFOptimisticLockException. If this happens,
	// perform another get, and use the new token returned by that operation.
	LockToken *string

	// The name of the IP set. You cannot change the name of an IPSet after you create
	// it.
	Name *string

	noSmithyDocumentSerde
}

// The body of a web request, inspected as JSON. The body immediately follows the
// request headers. This is used in the FieldToMatch specification. Use the
// specifications in this object to indicate which parts of the JSON body to
// inspect using the rule's inspection criteria. WAF inspects only the parts of the
// JSON that result from the matches that you indicate. Example JSON: "JsonBody": {
// "MatchPattern": { "All": {} }, "MatchScope": "ALL" }
type JsonBody struct {

	// The patterns to look for in the JSON body. WAF inspects the results of these
	// pattern matches against the rule inspection criteria.
	//
	// This member is required.
	MatchPattern *JsonMatchPattern

	// The parts of the JSON to match against using the MatchPattern. If you specify
	// All, WAF matches against keys and values.
	//
	// This member is required.
	MatchScope JsonMatchScope

	// What WAF should do if it fails to completely parse the JSON body. The options
	// are the following:
	//
	// * EVALUATE_AS_STRING - Inspect the body as plain text. WAF
	// applies the text transformations and inspection criteria that you defined for
	// the JSON inspection to the body text string.
	//
	// * MATCH - Treat the web request as
	// matching the rule statement. WAF applies the rule action to the request.
	//
	// *
	// NO_MATCH - Treat the web request as not matching the rule statement.
	//
	// If you
	// don't provide this setting, WAF parses and evaluates the content only up to the
	// first parsing failure that it encounters. WAF does its best to parse the entire
	// JSON body, but might be forced to stop for reasons such as invalid characters,
	// duplicate keys, truncation, and any content whose root node isn't an object or
	// an array. WAF parses the JSON in the following examples as two valid key, value
	// pairs:
	//
	// * Missing comma: {"key1":"value1""key2":"value2"}
	//
	// * Missing colon:
	// {"key1":"value1","key2""value2"}
	//
	// * Extra colons:
	// {"key1"::"value1","key2""value2"}
	InvalidFallbackBehavior BodyParsingFallbackBehavior

	noSmithyDocumentSerde
}

// The patterns to look for in the JSON body. WAF inspects the results of these
// pattern matches against the rule inspection criteria. This is used with the
// FieldToMatch option JsonBody.
type JsonMatchPattern struct {

	// Match all of the elements. See also MatchScope in JsonBody. You must specify
	// either this setting or the IncludedPaths setting, but not both.
	All *All

	// Match only the specified include paths. See also MatchScope in JsonBody. Provide
	// the include paths using JSON Pointer syntax. For example, "IncludedPaths":
	// ["/dogs/0/name", "/dogs/1/name"]. For information about this syntax, see the
	// Internet Engineering Task Force (IETF) documentation JavaScript Object Notation
	// (JSON) Pointer (https://tools.ietf.org/html/rfc6901). You must specify either
	// this setting or the All setting, but not both. Don't use this option to include
	// all paths. Instead, use the All setting.
	IncludedPaths []string

	noSmithyDocumentSerde
}

// A single label container. This is used as an element of a label array in
// multiple contexts, for example, in RuleLabels inside a Rule and in Labels inside
// a SampledHTTPRequest.
type Label struct {

	// The label string.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// A rule statement that defines a string match search against labels that have
// been added to the web request by rules that have already run in the web ACL. The
// label match statement provides the label or namespace string to search for. The
// label string can represent a part or all of the fully qualified label name that
// had been added to the web request. Fully qualified labels have a prefix,
// optional namespaces, and label name. The prefix identifies the rule group or web
// ACL context of the rule that added the label. If you do not provide the fully
// qualified name in your label match string, WAF performs the search for labels
// that were added in the same context as the label match statement.
type LabelMatchStatement struct {

	// The string to match against. The setting you provide for this depends on the
	// match statement's Scope setting:
	//
	// * If the Scope indicates LABEL, then this
	// specification must include the name and can include any number of preceding
	// namespace specifications and prefix up to providing the fully qualified label
	// name.
	//
	// * If the Scope indicates NAMESPACE, then this specification can include
	// any number of contiguous namespace strings, and can include the entire label
	// namespace prefix from the rule group or web ACL where the label
	// originates.
	//
	// Labels are case sensitive and components of a label must be
	// separated by colon, for example NS1:NS2:name.
	//
	// This member is required.
	Key *string

	// Specify whether you want to match using the label name or just the namespace.
	//
	// This member is required.
	Scope LabelMatchScope

	noSmithyDocumentSerde
}

// A single label name condition for a Condition in a logging filter.
type LabelNameCondition struct {

	// The label name that a log record must contain in order to meet the condition.
	// This must be a fully qualified label name. Fully qualified labels have a prefix,
	// optional namespaces, and label name. The prefix identifies the rule group or web
	// ACL context of the rule that added the label.
	//
	// This member is required.
	LabelName *string

	noSmithyDocumentSerde
}

// List of labels used by one or more of the rules of a RuleGroup. This summary
// object is used for the following rule group lists:
//
// * AvailableLabels - Labels
// that rules add to matching requests. These labels are defined in the RuleLabels
// for a Rule.
//
// * ConsumedLabels - Labels that rules match against. These labels
// are defined in a LabelMatchStatement specification, in the Statement definition
// of a rule.
type LabelSummary struct {

	// An individual label specification.
	Name *string

	noSmithyDocumentSerde
}

// Defines an association between logging destinations and a web ACL resource, for
// logging from WAF. As part of the association, you can specify parts of the
// standard logging fields to keep out of the logs and you can specify filters so
// that you log only a subset of the logging records. For information about
// configuring web ACL logging destinations, see Logging web ACL traffic
// information (https://docs.aws.amazon.com/waf/latest/developerguide/logging.html)
// in the WAF Developer Guide.
type LoggingConfiguration struct {

	// The Amazon Resource Names (ARNs) of the logging destinations that you want to
	// associate with the web ACL.
	//
	// This member is required.
	LogDestinationConfigs []string

	// The Amazon Resource Name (ARN) of the web ACL that you want to associate with
	// LogDestinationConfigs.
	//
	// This member is required.
	ResourceArn *string

	// Filtering that specifies which web requests are kept in the logs and which are
	// dropped. You can filter on the rule action and on the web request labels that
	// were applied by matching rules during web ACL evaluation.
	LoggingFilter *LoggingFilter

	// Indicates whether the logging configuration was created by Firewall Manager, as
	// part of an WAF policy configuration. If true, only Firewall Manager can modify
	// or delete the configuration.
	ManagedByFirewallManager bool

	// The parts of the request that you want to keep out of the logs. For example, if
	// you redact the SingleHeader field, the HEADER field in the logs will be xxx. You
	// can specify only the following fields for redaction: UriPath, QueryString,
	// SingleHeader, Method, and JsonBody.
	RedactedFields []FieldToMatch

	noSmithyDocumentSerde
}

// Filtering that specifies which web requests are kept in the logs and which are
// dropped, defined for a web ACL's LoggingConfiguration. You can filter on the
// rule action and on the web request labels that were applied by matching rules
// during web ACL evaluation.
type LoggingFilter struct {

	// Default handling for logs that don't match any of the specified filtering
	// conditions.
	//
	// This member is required.
	DefaultBehavior FilterBehavior

	// The filters that you want to apply to the logs.
	//
	// This member is required.
	Filters []Filter

	noSmithyDocumentSerde
}

// A rule statement used to run the rules that are defined in a managed rule group.
// To use this, provide the vendor name and the name of the rule group in this
// statement. You can retrieve the required names by calling
// ListAvailableManagedRuleGroups. You cannot nest a ManagedRuleGroupStatement, for
// example for use inside a NotStatement or OrStatement. It can only be referenced
// as a top-level statement within a rule.
type ManagedRuleGroupStatement struct {

	// The name of the managed rule group. You use this, along with the vendor name, to
	// identify the rule group.
	//
	// This member is required.
	Name *string

	// The name of the managed rule group vendor. You use this, along with the rule
	// group name, to identify the rule group.
	//
	// This member is required.
	VendorName *string

	// The rules in the referenced rule group whose actions are set to Count. When you
	// exclude a rule, WAF evaluates it exactly as it would if the rule action setting
	// were Count. This is a useful option for testing the rules in a rule group
	// without modifying how they handle your web traffic.
	ExcludedRules []ExcludedRule

	// An optional nested statement that narrows the scope of the web requests that are
	// evaluated by the managed rule group. Requests are only evaluated by the rule
	// group if they match the scope-down statement. You can use any nestable Statement
	// in the scope-down statement, and you can nest statements at any level, the same
	// as you can for a rule statement.
	ScopeDownStatement *Statement

	// The version of the managed rule group to use. If you specify this, the version
	// setting is fixed until you change it. If you don't specify this, WAF uses the
	// vendor's default version, and then keeps the version at the vendor's default
	// when the vendor updates the managed rule group settings.
	Version *string

	noSmithyDocumentSerde
}

// High-level information about a managed rule group, returned by
// ListAvailableManagedRuleGroups. This provides information like the name and
// vendor name, that you provide when you add a ManagedRuleGroupStatement to a web
// ACL. Managed rule groups include Amazon Web Services Managed Rules rule groups,
// which are free of charge to WAF customers, and Amazon Web Services Marketplace
// managed rule groups, which you can subscribe to through Amazon Web Services
// Marketplace.
type ManagedRuleGroupSummary struct {

	// The description of the managed rule group, provided by Amazon Web Services
	// Managed Rules or the Amazon Web Services Marketplace seller who manages it.
	Description *string

	// The name of the managed rule group. You use this, along with the vendor name, to
	// identify the rule group.
	Name *string

	// The name of the managed rule group vendor. You use this, along with the rule
	// group name, to identify the rule group.
	VendorName *string

	noSmithyDocumentSerde
}

// Describes a single version of a managed rule group.
type ManagedRuleGroupVersion struct {

	// The date and time that the managed rule group owner updated the rule group
	// version information.
	LastUpdateTimestamp *time.Time

	// The version name.
	Name *string

	noSmithyDocumentSerde
}

// A set of rules that is managed by Amazon Web Services and Amazon Web Services
// Marketplace sellers to provide versioned managed rule groups for customers of
// WAF. This is intended for use only by vendors of managed rule sets. Vendors are
// Amazon Web Services and Amazon Web Services Marketplace sellers. Vendors, you
// can use the managed rule set APIs to provide controlled rollout of your
// versioned managed rule group offerings for your customers. The APIs are
// ListManagedRuleSets, GetManagedRuleSet, PutManagedRuleSetVersions, and
// UpdateManagedRuleSetVersionExpiryDate.
type ManagedRuleSet struct {

	// The Amazon Resource Name (ARN) of the entity.
	//
	// This member is required.
	ARN *string

	// A unique identifier for the managed rule set. The ID is returned in the
	// responses to commands like list. You provide it to operations like get and
	// update.
	//
	// This member is required.
	Id *string

	// The name of the managed rule set. You use this, along with the rule set ID, to
	// identify the rule set. This name is assigned to the corresponding managed rule
	// group, which your customers can access and use.
	//
	// This member is required.
	Name *string

	// A description of the set that helps with identification.
	Description *string

	// The label namespace prefix for the managed rule groups that are offered to
	// customers from this managed rule set. All labels that are added by rules in the
	// managed rule group have this prefix.
	//
	// * The syntax for the label namespace
	// prefix for a managed rule group is the following: awswaf:managed:::
	//
	// * When a
	// rule with a label matches a web request, WAF adds the fully qualified label to
	// the request. A fully qualified label is made up of the label namespace from the
	// rule group or web ACL where the rule is defined and the label from the rule,
	// separated by a colon: :
	LabelNamespace *string

	// The versions of this managed rule set that are available for use by customers.
	PublishedVersions map[string]ManagedRuleSetVersion

	// The version that you would like your customers to use.
	RecommendedVersion *string

	noSmithyDocumentSerde
}

// High-level information for a managed rule set. This is intended for use only by
// vendors of managed rule sets. Vendors are Amazon Web Services and Amazon Web
// Services Marketplace sellers. Vendors, you can use the managed rule set APIs to
// provide controlled rollout of your versioned managed rule group offerings for
// your customers. The APIs are ListManagedRuleSets, GetManagedRuleSet,
// PutManagedRuleSetVersions, and UpdateManagedRuleSetVersionExpiryDate.
type ManagedRuleSetSummary struct {

	// The Amazon Resource Name (ARN) of the entity.
	ARN *string

	// A description of the set that helps with identification.
	Description *string

	// A unique identifier for the managed rule set. The ID is returned in the
	// responses to commands like list. You provide it to operations like get and
	// update.
	Id *string

	// The label namespace prefix for the managed rule groups that are offered to
	// customers from this managed rule set. All labels that are added by rules in the
	// managed rule group have this prefix.
	//
	// * The syntax for the label namespace
	// prefix for a managed rule group is the following: awswaf:managed:::
	//
	// * When a
	// rule with a label matches a web request, WAF adds the fully qualified label to
	// the request. A fully qualified label is made up of the label namespace from the
	// rule group or web ACL where the rule is defined and the label from the rule,
	// separated by a colon: :
	LabelNamespace *string

	// A token used for optimistic locking. WAF returns a token to your get and list
	// requests, to mark the state of the entity at the time of the request. To make
	// changes to the entity associated with the token, you provide the token to
	// operations like update and delete. WAF uses the token to ensure that no changes
	// have been made to the entity since you last retrieved it. If a change has been
	// made, the update fails with a WAFOptimisticLockException. If this happens,
	// perform another get, and use the new token returned by that operation.
	LockToken *string

	// The name of the managed rule set. You use this, along with the rule set ID, to
	// identify the rule set. This name is assigned to the corresponding managed rule
	// group, which your customers can access and use.
	Name *string

	noSmithyDocumentSerde
}

// Information for a single version of a managed rule set. This is intended for use
// only by vendors of managed rule sets. Vendors are Amazon Web Services and Amazon
// Web Services Marketplace sellers. Vendors, you can use the managed rule set APIs
// to provide controlled rollout of your versioned managed rule group offerings for
// your customers. The APIs are ListManagedRuleSets, GetManagedRuleSet,
// PutManagedRuleSetVersions, and UpdateManagedRuleSetVersionExpiryDate.
type ManagedRuleSetVersion struct {

	// The Amazon Resource Name (ARN) of the vendor rule group that's used to define
	// the published version of your managed rule group.
	AssociatedRuleGroupArn *string

	// The web ACL capacity units (WCUs) required for this rule group. WAF uses WCUs to
	// calculate and control the operating resources that are used to run your rules,
	// rule groups, and web ACLs. WAF calculates capacity differently for each rule
	// type, to reflect the relative cost of each rule. Simple rules that cost little
	// to run use fewer WCUs than more complex rules that use more processing power.
	// Rule group capacity is fixed at creation, which helps users plan their web ACL
	// WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.
	Capacity int64

	// The time that this version is set to expire. Times are in Coordinated Universal
	// Time (UTC) format. UTC format includes the special designator, Z. For example,
	// "2016-09-27T14:50Z".
	ExpiryTimestamp *time.Time

	// The amount of time you expect this version of your managed rule group to last,
	// in days.
	ForecastedLifetime *int32

	// The last time that you updated this version. Times are in Coordinated Universal
	// Time (UTC) format. UTC format includes the special designator, Z. For example,
	// "2016-09-27T14:50Z".
	LastUpdateTimestamp *time.Time

	// The time that you first published this version. Times are in Coordinated
	// Universal Time (UTC) format. UTC format includes the special designator, Z. For
	// example, "2016-09-27T14:50Z".
	PublishTimestamp *time.Time

	noSmithyDocumentSerde
}

// The HTTP method of a web request. The method indicates the type of operation
// that the request is asking the origin to perform. This is used only to indicate
// the web request component for WAF to inspect, in the FieldToMatch specification.
// JSON specification: "Method": {}
type Method struct {
	noSmithyDocumentSerde
}

// Specifies that WAF should do nothing. This is used for the OverrideAction
// setting on a Rule when the rule uses a rule group reference statement. This is
// used in the context of other settings, for example to specify values for
// RuleAction and web ACL DefaultAction. JSON specification: "None": {}
type NoneAction struct {
	noSmithyDocumentSerde
}

// A logical rule statement used to negate the results of another rule statement.
// You provide one Statement within the NotStatement.
type NotStatement struct {

	// The statement to negate. You can use any statement that can be nested.
	//
	// This member is required.
	Statement *Statement

	noSmithyDocumentSerde
}

// A logical rule statement used to combine other rule statements with OR logic.
// You provide more than one Statement within the OrStatement.
type OrStatement struct {

	// The statements to combine with OR logic. You can use any statements that can be
	// nested.
	//
	// This member is required.
	Statements []Statement

	noSmithyDocumentSerde
}

// The action to use in the place of the action that results from the rule group
// evaluation. Set the override action to none to leave the result of the rule
// group alone. Set it to count to override the result to count only. You can only
// use this for rule statements that reference a rule group, like
// RuleGroupReferenceStatement and ManagedRuleGroupStatement. This option is
// usually set to none. It does not affect how the rules in the rule group are
// evaluated. If you want the rules in the rule group to only count matches, do not
// use this and instead exclude those rules in your rule group reference statement
// settings.
type OverrideAction struct {

	// Override the rule group evaluation result to count only. This option is usually
	// set to none. It does not affect how the rules in the rule group are evaluated.
	// If you want the rules in the rule group to only count matches, do not use this
	// and instead exclude those rules in your rule group reference statement settings.
	Count *CountAction

	// Don't override the rule group evaluation result. This is the most common
	// setting.
	None *NoneAction

	noSmithyDocumentSerde
}

// The query string of a web request. This is the part of a URL that appears after
// a ? character, if any. This is used only to indicate the web request component
// for WAF to inspect, in the FieldToMatch specification. JSON specification:
// "QueryString": {}
type QueryString struct {
	noSmithyDocumentSerde
}

// A rate-based rule tracks the rate of requests for each originating IP address,
// and triggers the rule action when the rate exceeds a limit that you specify on
// the number of requests in any 5-minute time span. You can use this to put a
// temporary block on requests from an IP address that is sending excessive
// requests. WAF tracks and manages web requests separately for each instance of a
// rate-based rule that you use. For example, if you provide the same rate-based
// rule settings in two web ACLs, each of the two rule statements represents a
// separate instance of the rate-based rule and gets its own tracking and
// management by WAF. If you define a rate-based rule inside a rule group, and then
// use that rule group in multiple places, each use creates a separate instance of
// the rate-based rule that gets its own tracking and management by WAF. When the
// rule action triggers, WAF blocks additional requests from the IP address until
// the request rate falls below the limit. You can optionally nest another
// statement inside the rate-based statement, to narrow the scope of the rule so
// that it only counts requests that match the nested statement. For example, based
// on recent requests that you have seen from an attacker, you might create a
// rate-based rule with a nested AND rule statement that contains the following
// nested statements:
//
// * An IP match statement with an IP set that specified the
// address 192.0.2.44.
//
// * A string match statement that searches in the User-Agent
// header for the string BadBot.
//
// In this rate-based rule, you also define a rate
// limit. For this example, the rate limit is 1,000. Requests that meet both of the
// conditions in the statements are counted. If the count exceeds 1,000 requests
// per five minutes, the rule action triggers. Requests that do not meet both
// conditions are not counted towards the rate limit and are not affected by this
// rule. You cannot nest a RateBasedStatement inside another statement, for example
// inside a NotStatement or OrStatement. You can define a RateBasedStatement inside
// a web ACL and inside a rule group.
type RateBasedStatement struct {

	// Setting that indicates how to aggregate the request counts. The options are the
	// following:
	//
	// * IP - Aggregate the request counts on the IP address from the web
	// request origin.
	//
	// * FORWARDED_IP - Aggregate the request counts on the first IP
	// address in an HTTP header. If you use this, configure the ForwardedIPConfig, to
	// specify the header to use.
	//
	// This member is required.
	AggregateKeyType RateBasedStatementAggregateKeyType

	// The limit on requests per 5-minute period for a single originating IP address.
	// If the statement includes a ScopeDownStatement, this limit is applied only to
	// the requests that match the statement.
	//
	// This member is required.
	Limit int64

	// The configuration for inspecting IP addresses in an HTTP header that you
	// specify, instead of using the IP address that's reported by the web request
	// origin. Commonly, this is the X-Forwarded-For (XFF) header, but you can specify
	// any header name. If the specified header isn't present in the request, WAF
	// doesn't apply the rule to the web request at all. This is required if
	// AggregateKeyType is set to FORWARDED_IP.
	ForwardedIPConfig *ForwardedIPConfig

	// An optional nested statement that narrows the scope of the web requests that are
	// evaluated by the rate-based statement. Requests are only tracked by the
	// rate-based statement if they match the scope-down statement. You can use any
	// nestable Statement in the scope-down statement, and you can nest statements at
	// any level, the same as you can for a rule statement.
	ScopeDownStatement *Statement

	noSmithyDocumentSerde
}

// The set of IP addresses that are currently blocked for a RateBasedStatement.
type RateBasedStatementManagedKeysIPSet struct {

	// The IP addresses that are currently blocked.
	Addresses []string

	// The version of the IP addresses, either IPV4 or IPV6.
	IPAddressVersion IPAddressVersion

	noSmithyDocumentSerde
}

// A single regular expression. This is used in a RegexPatternSet.
type Regex struct {

	// The string representing the regular expression.
	RegexString *string

	noSmithyDocumentSerde
}

// A rule statement used to search web request components for a match against a
// single regular expression.
type RegexMatchStatement struct {

	// The part of a web request that you want WAF to inspect. For more information,
	// see FieldToMatch.
	//
	// This member is required.
	FieldToMatch *FieldToMatch

	// The string representing the regular expression.
	//
	// This member is required.
	RegexString *string

	// Text transformations eliminate some of the unusual formatting that attackers use
	// in web requests in an effort to bypass detection. If you specify one or more
	// transformations in a rule statement, WAF performs all transformations on the
	// content of the request component identified by FieldToMatch, starting from the
	// lowest priority setting, before inspecting the content for a match.
	//
	// This member is required.
	TextTransformations []TextTransformation

	noSmithyDocumentSerde
}

// Contains one or more regular expressions. WAF assigns an ARN to each
// RegexPatternSet that you create. To use a set in a rule, you provide the ARN to
// the Rule statement RegexPatternSetReferenceStatement.
type RegexPatternSet struct {

	// The Amazon Resource Name (ARN) of the entity.
	ARN *string

	// A description of the set that helps with identification.
	Description *string

	// A unique identifier for the set. This ID is returned in the responses to create
	// and list commands. You provide it to operations like update and delete.
	Id *string

	// The name of the set. You cannot change the name after you create the set.
	Name *string

	// The regular expression patterns in the set.
	RegularExpressionList []Regex

	noSmithyDocumentSerde
}

// A rule statement used to search web request components for matches with regular
// expressions. To use this, create a RegexPatternSet that specifies the
// expressions that you want to detect, then use the ARN of that set in this
// statement. A web request matches the pattern set rule statement if the request
// component matches any of the patterns in the set. To create a regex pattern set,
// see CreateRegexPatternSet. Each regex pattern set rule statement references a
// regex pattern set. You create and maintain the set independent of your rules.
// This allows you to use the single set in multiple rules. When you update the
// referenced set, WAF automatically updates all rules that reference it.
type RegexPatternSetReferenceStatement struct {

	// The Amazon Resource Name (ARN) of the RegexPatternSet that this statement
	// references.
	//
	// This member is required.
	ARN *string

	// The part of a web request that you want WAF to inspect. For more information,
	// see FieldToMatch.
	//
	// This member is required.
	FieldToMatch *FieldToMatch

	// Text transformations eliminate some of the unusual formatting that attackers use
	// in web requests in an effort to bypass detection. If you specify one or more
	// transformations in a rule statement, WAF performs all transformations on the
	// content of the request component identified by FieldToMatch, starting from the
	// lowest priority setting, before inspecting the content for a match.
	//
	// This member is required.
	TextTransformations []TextTransformation

	noSmithyDocumentSerde
}

// High-level information about a RegexPatternSet, returned by operations like
// create and list. This provides information like the ID, that you can use to
// retrieve and manage a RegexPatternSet, and the ARN, that you provide to the
// RegexPatternSetReferenceStatement to use the pattern set in a Rule.
type RegexPatternSetSummary struct {

	// The Amazon Resource Name (ARN) of the entity.
	ARN *string

	// A description of the set that helps with identification.
	Description *string

	// A unique identifier for the set. This ID is returned in the responses to create
	// and list commands. You provide it to operations like update and delete.
	Id *string

	// A token used for optimistic locking. WAF returns a token to your get and list
	// requests, to mark the state of the entity at the time of the request. To make
	// changes to the entity associated with the token, you provide the token to
	// operations like update and delete. WAF uses the token to ensure that no changes
	// have been made to the entity since you last retrieved it. If a change has been
	// made, the update fails with a WAFOptimisticLockException. If this happens,
	// perform another get, and use the new token returned by that operation.
	LockToken *string

	// The name of the data type instance. You cannot change the name after you create
	// the instance.
	Name *string

	noSmithyDocumentSerde
}

// A single rule, which you can use in a WebACL or RuleGroup to identify web
// requests that you want to allow, block, or count. Each rule includes one
// top-level Statement that WAF uses to identify matching web requests, and
// parameters that govern how WAF handles them.
type Rule struct {

	// The name of the rule. You can't change the name of a Rule after you create it.
	//
	// This member is required.
	Name *string

	// If you define more than one Rule in a WebACL, WAF evaluates each request against
	// the Rules in order based on the value of Priority. WAF processes rules with
	// lower priority first. The priorities don't need to be consecutive, but they must
	// all be different.
	//
	// This member is required.
	Priority int32

	// The WAF processing statement for the rule, for example ByteMatchStatement or
	// SizeConstraintStatement.
	//
	// This member is required.
	Statement *Statement

	// Defines and enables Amazon CloudWatch metrics and web request sample collection.
	//
	// This member is required.
	VisibilityConfig *VisibilityConfig

	// The action that WAF should take on a web request when it matches the rule
	// statement. Settings at the web ACL level can override the rule action setting.
	// This is used only for rules whose statements do not reference a rule group. Rule
	// statements that reference a rule group include RuleGroupReferenceStatement and
	// ManagedRuleGroupStatement. You must specify either this Action setting or the
	// rule OverrideAction setting, but not both:
	//
	// * If the rule statement does not
	// reference a rule group, use this rule action setting and not the rule override
	// action setting.
	//
	// * If the rule statement references a rule group, use the
	// override action setting and not this action setting.
	Action *RuleAction

	// Specifies how WAF should handle CAPTCHA evaluations. If you don't specify this,
	// WAF uses the CAPTCHA configuration that's defined for the web ACL.
	CaptchaConfig *CaptchaConfig

	// The action to use in the place of the action that results from the rule group
	// evaluation. Set the override action to none to leave the result of the rule
	// group alone. Set it to count to override the result to count only. You can only
	// use this for rule statements that reference a rule group, like
	// RuleGroupReferenceStatement and ManagedRuleGroupStatement. This option is
	// usually set to none. It does not affect how the rules in the rule group are
	// evaluated. If you want the rules in the rule group to only count matches, do not
	// use this and instead exclude those rules in your rule group reference statement
	// settings.
	OverrideAction *OverrideAction

	// Labels to apply to web requests that match the rule match statement. WAF applies
	// fully qualified labels to matching web requests. A fully qualified label is the
	// concatenation of a label namespace and a rule label. The rule's rule group or
	// web ACL defines the label namespace. Rules that run after this rule in the web
	// ACL can match against these labels using a LabelMatchStatement. For each label,
	// provide a case-sensitive string containing optional namespaces and a label name,
	// according to the following guidelines:
	//
	// * Separate each component of the label
	// with a colon.
	//
	// * Each namespace or name can have up to 128 characters.
	//
	// * You
	// can specify up to 5 namespaces in a label.
	//
	// * Don't use the following reserved
	// words in your label specification: aws, waf, managed, rulegroup, webacl,
	// regexpatternset, or ipset.
	//
	// For example, myLabelName or
	// nameSpace1:nameSpace2:myLabelName.
	RuleLabels []Label

	noSmithyDocumentSerde
}

// The action that WAF should take on a web request when it matches a rule's
// statement. Settings at the web ACL level can override the rule action setting.
type RuleAction struct {

	// Instructs WAF to allow the web request.
	Allow *AllowAction

	// Instructs WAF to block the web request.
	Block *BlockAction

	// Instructs WAF to run a CAPTCHA check against the web request.
	Captcha *CaptchaAction

	// Instructs WAF to count the web request and allow it.
	Count *CountAction

	noSmithyDocumentSerde
}

// A rule group defines a collection of rules to inspect and control web requests
// that you can use in a WebACL. When you create a rule group, you define an
// immutable capacity limit. If you update a rule group, you must stay within the
// capacity. This allows others to reuse the rule group with confidence in its
// capacity requirements.
type RuleGroup struct {

	// The Amazon Resource Name (ARN) of the entity.
	//
	// This member is required.
	ARN *string

	// The web ACL capacity units (WCUs) required for this rule group. When you create
	// your own rule group, you define this, and you cannot change it after creation.
	// When you add or modify the rules in a rule group, WAF enforces this limit. You
	// can check the capacity for a set of rules using CheckCapacity. WAF uses WCUs to
	// calculate and control the operating resources that are used to run your rules,
	// rule groups, and web ACLs. WAF calculates capacity differently for each rule
	// type, to reflect the relative cost of each rule. Simple rules that cost little
	// to run use fewer WCUs than more complex rules that use more processing power.
	// Rule group capacity is fixed at creation, which helps users plan their web ACL
	// WCU usage when they use a rule group. The WCU limit for web ACLs is 1,500.
	//
	// This member is required.
	Capacity int64

	// A unique identifier for the rule group. This ID is returned in the responses to
	// create and list commands. You provide it to operations like update and delete.
	//
	// This member is required.
	Id *string

	// The name of the rule group. You cannot change the name of a rule group after you
	// create it.
	//
	// This member is required.
	Name *string

	// Defines and enables Amazon CloudWatch metrics and web request sample collection.
	//
	// This member is required.
	VisibilityConfig *VisibilityConfig

	// The labels that one or more rules in this rule group add to matching web
	// requests. These labels are defined in the RuleLabels for a Rule.
	AvailableLabels []LabelSummary

	// The labels that one or more rules in this rule group match against in label
	// match statements. These labels are defined in a LabelMatchStatement
	// specification, in the Statement definition of a rule.
	ConsumedLabels []LabelSummary

	// A map of custom response keys and content bodies. When you create a rule with a
	// block action, you can send a custom response to the web request. You define
	// these for the rule group, and then use them in the rules that you define in the
	// rule group. For information about customizing web requests and responses, see
	// Customizing web requests and responses in WAF
	// (https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html)
	// in the WAF Developer Guide
	// (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). For
	// information about the limits on count and size for custom request and response
	// settings, see WAF quotas
	// (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in the WAF
	// Developer Guide
	// (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	CustomResponseBodies map[string]CustomResponseBody

	// A description of the rule group that helps with identification.
	Description *string

	// The label namespace prefix for this rule group. All labels added by rules in
	// this rule group have this prefix.
	//
	// * The syntax for the label namespace prefix
	// for your rule groups is the following: awswaf::rulegroup::
	//
	// * When a rule with a
	// label matches a web request, WAF adds the fully qualified label to the request.
	// A fully qualified label is made up of the label namespace from the rule group or
	// web ACL where the rule is defined and the label from the rule, separated by a
	// colon: :
	LabelNamespace *string

	// The Rule statements used to identify the web requests that you want to allow,
	// block, or count. Each rule includes one top-level statement that WAF uses to
	// identify matching web requests, and parameters that govern how WAF handles them.
	Rules []Rule

	noSmithyDocumentSerde
}

// A rule statement used to run the rules that are defined in a RuleGroup. To use
// this, create a rule group with your rules, then provide the ARN of the rule
// group in this statement. You cannot nest a RuleGroupReferenceStatement, for
// example for use inside a NotStatement or OrStatement. You can only use a rule
// group reference statement at the top level inside a web ACL.
type RuleGroupReferenceStatement struct {

	// The Amazon Resource Name (ARN) of the entity.
	//
	// This member is required.
	ARN *string

	// The rules in the referenced rule group whose actions are set to Count. When you
	// exclude a rule, WAF evaluates it exactly as it would if the rule action setting
	// were Count. This is a useful option for testing the rules in a rule group
	// without modifying how they handle your web traffic.
	ExcludedRules []ExcludedRule

	noSmithyDocumentSerde
}

// High-level information about a RuleGroup, returned by operations like create and
// list. This provides information like the ID, that you can use to retrieve and
// manage a RuleGroup, and the ARN, that you provide to the
// RuleGroupReferenceStatement to use the rule group in a Rule.
type RuleGroupSummary struct {

	// The Amazon Resource Name (ARN) of the entity.
	ARN *string

	// A description of the rule group that helps with identification.
	Description *string

	// A unique identifier for the rule group. This ID is returned in the responses to
	// create and list commands. You provide it to operations like update and delete.
	Id *string

	// A token used for optimistic locking. WAF returns a token to your get and list
	// requests, to mark the state of the entity at the time of the request. To make
	// changes to the entity associated with the token, you provide the token to
	// operations like update and delete. WAF uses the token to ensure that no changes
	// have been made to the entity since you last retrieved it. If a change has been
	// made, the update fails with a WAFOptimisticLockException. If this happens,
	// perform another get, and use the new token returned by that operation.
	LockToken *string

	// The name of the data type instance. You cannot change the name after you create
	// the instance.
	Name *string

	noSmithyDocumentSerde
}

// High-level information about a Rule, returned by operations like
// DescribeManagedRuleGroup. This provides information like the ID, that you can
// use to retrieve and manage a RuleGroup, and the ARN, that you provide to the
// RuleGroupReferenceStatement to use the rule group in a Rule.
type RuleSummary struct {

	// The action that WAF should take on a web request when it matches a rule's
	// statement. Settings at the web ACL level can override the rule action setting.
	Action *RuleAction

	// The name of the rule.
	Name *string

	noSmithyDocumentSerde
}

// Represents a single sampled web request. The response from GetSampledRequests
// includes a SampledHTTPRequests complex type that appears as SampledRequests in
// the response syntax. SampledHTTPRequests contains an array of SampledHTTPRequest
// objects.
type SampledHTTPRequest struct {

	// A complex type that contains detailed information about the request.
	//
	// This member is required.
	Request *HTTPRequest

	// A value that indicates how one result in the response relates proportionally to
	// other results in the response. For example, a result that has a weight of 2
	// represents roughly twice as many web requests as a result that has a weight of
	// 1.
	//
	// This member is required.
	Weight int64

	// The action for the Rule that the request matched: Allow, Block, or Count.
	Action *string

	// The CAPTCHA response for the request.
	CaptchaResponse *CaptchaResponse

	// Labels applied to the web request by matching rules. WAF applies fully qualified
	// labels to matching web requests. A fully qualified label is the concatenation of
	// a label namespace and a rule label. The rule's rule group or web ACL defines the
	// label namespace. For example,
	// awswaf:111122223333:myRuleGroup:testRules:testNS1:testNS2:labelNameA or
	// awswaf:managed:aws:managed-rule-set:header:encoding:utf8.
	Labels []Label

	// Custom request headers inserted by WAF into the request, according to the custom
	// request configuration for the matching rule action.
	RequestHeadersInserted []HTTPHeader

	// The response code that was sent for the request.
	ResponseCodeSent *int32

	// The name of the Rule that the request matched. For managed rule groups, the
	// format for this name is ##. For your own rule groups, the format for this name
	// is #. If the rule is not in a rule group, this field is absent.
	RuleNameWithinRuleGroup *string

	// The time at which WAF received the request from your Amazon Web Services
	// resource, in Unix time format (in seconds).
	Timestamp *time.Time

	noSmithyDocumentSerde
}

// One of the headers in a web request, identified by name, for example, User-Agent
// or Referer. This setting isn't case sensitive. This is used only to indicate the
// web request component for WAF to inspect, in the FieldToMatch specification.
// Example JSON: "SingleHeader": { "Name": "haystack" }
type SingleHeader struct {

	// The name of the query header to inspect.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// One query argument in a web request, identified by name, for example UserName or
// SalesRegion. The name can be up to 30 characters long and isn't case sensitive.
// Example JSON: "SingleQueryArgument": { "Name": "myArgument" }
type SingleQueryArgument struct {

	// The name of the query argument to inspect.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// A rule statement that compares a number of bytes against the size of a request
// component, using a comparison operator, such as greater than (>) or less than
// (<). For example, you can use a size constraint statement to look for query
// strings that are longer than 100 bytes. If you configure WAF to inspect the
// request body, WAF inspects only the first 8192 bytes (8 KB). If the request body
// for your web requests never exceeds 8192 bytes, you can create a size constraint
// condition and block requests that have a request body greater than 8192 bytes.
// If you choose URI for the value of Part of the request to filter on, the slash
// (/) in the URI counts as one character. For example, the URI /logo.jpg is nine
// characters long.
type SizeConstraintStatement struct {

	// The operator to use to compare the request part to the size setting.
	//
	// This member is required.
	ComparisonOperator ComparisonOperator

	// The part of a web request that you want WAF to inspect. For more information,
	// see FieldToMatch.
	//
	// This member is required.
	FieldToMatch *FieldToMatch

	// The size, in byte, to compare to the request part, after any transformations.
	//
	// This member is required.
	Size int64

	// Text transformations eliminate some of the unusual formatting that attackers use
	// in web requests in an effort to bypass detection. If you specify one or more
	// transformations in a rule statement, WAF performs all transformations on the
	// content of the request component identified by FieldToMatch, starting from the
	// lowest priority setting, before inspecting the content for a match.
	//
	// This member is required.
	TextTransformations []TextTransformation

	noSmithyDocumentSerde
}

// Attackers sometimes insert malicious SQL code into web requests in an effort to
// extract data from your database. To allow or block web requests that appear to
// contain malicious SQL code, create one or more SQL injection match conditions.
// An SQL injection match condition identifies the part of web requests, such as
// the URI or the query string, that you want WAF to inspect. Later in the process,
// when you create a web ACL, you specify whether to allow or block requests that
// appear to contain malicious SQL code.
type SqliMatchStatement struct {

	// The part of a web request that you want WAF to inspect. For more information,
	// see FieldToMatch.
	//
	// This member is required.
	FieldToMatch *FieldToMatch

	// Text transformations eliminate some of the unusual formatting that attackers use
	// in web requests in an effort to bypass detection. If you specify one or more
	// transformations in a rule statement, WAF performs all transformations on the
	// content of the request component identified by FieldToMatch, starting from the
	// lowest priority setting, before inspecting the content for a match.
	//
	// This member is required.
	TextTransformations []TextTransformation

	noSmithyDocumentSerde
}

// The processing guidance for a Rule, used by WAF to determine whether a web
// request matches the rule.
type Statement struct {

	// A logical rule statement used to combine other rule statements with AND logic.
	// You provide more than one Statement within the AndStatement.
	AndStatement *AndStatement

	// A rule statement that defines a string match search for WAF to apply to web
	// requests. The byte match statement provides the bytes to search for, the
	// location in requests that you want WAF to search, and other settings. The bytes
	// to search for are typically a string that corresponds with ASCII characters. In
	// the WAF console and the developer guide, this is refered to as a string match
	// statement.
	ByteMatchStatement *ByteMatchStatement

	// A rule statement used to identify web requests based on country of origin.
	GeoMatchStatement *GeoMatchStatement

	// A rule statement used to detect web requests coming from particular IP addresses
	// or address ranges. To use this, create an IPSet that specifies the addresses you
	// want to detect, then use the ARN of that set in this statement. To create an IP
	// set, see CreateIPSet. Each IP set rule statement references an IP set. You
	// create and maintain the set independent of your rules. This allows you to use
	// the single set in multiple rules. When you update the referenced set, WAF
	// automatically updates all rules that reference it.
	IPSetReferenceStatement *IPSetReferenceStatement

	// A rule statement that defines a string match search against labels that have
	// been added to the web request by rules that have already run in the web ACL. The
	// label match statement provides the label or namespace string to search for. The
	// label string can represent a part or all of the fully qualified label name that
	// had been added to the web request. Fully qualified labels have a prefix,
	// optional namespaces, and label name. The prefix identifies the rule group or web
	// ACL context of the rule that added the label. If you do not provide the fully
	// qualified name in your label match string, WAF performs the search for labels
	// that were added in the same context as the label match statement.
	LabelMatchStatement *LabelMatchStatement

	// A rule statement used to run the rules that are defined in a managed rule group.
	// To use this, provide the vendor name and the name of the rule group in this
	// statement. You can retrieve the required names by calling
	// ListAvailableManagedRuleGroups. You cannot nest a ManagedRuleGroupStatement, for
	// example for use inside a NotStatement or OrStatement. It can only be referenced
	// as a top-level statement within a rule.
	ManagedRuleGroupStatement *ManagedRuleGroupStatement

	// A logical rule statement used to negate the results of another rule statement.
	// You provide one Statement within the NotStatement.
	NotStatement *NotStatement

	// A logical rule statement used to combine other rule statements with OR logic.
	// You provide more than one Statement within the OrStatement.
	OrStatement *OrStatement

	// A rate-based rule tracks the rate of requests for each originating IP address,
	// and triggers the rule action when the rate exceeds a limit that you specify on
	// the number of requests in any 5-minute time span. You can use this to put a
	// temporary block on requests from an IP address that is sending excessive
	// requests. WAF tracks and manages web requests separately for each instance of a
	// rate-based rule that you use. For example, if you provide the same rate-based
	// rule settings in two web ACLs, each of the two rule statements represents a
	// separate instance of the rate-based rule and gets its own tracking and
	// management by WAF. If you define a rate-based rule inside a rule group, and then
	// use that rule group in multiple places, each use creates a separate instance of
	// the rate-based rule that gets its own tracking and management by WAF. When the
	// rule action triggers, WAF blocks additional requests from the IP address until
	// the request rate falls below the limit. You can optionally nest another
	// statement inside the rate-based statement, to narrow the scope of the rule so
	// that it only counts requests that match the nested statement. For example, based
	// on recent requests that you have seen from an attacker, you might create a
	// rate-based rule with a nested AND rule statement that contains the following
	// nested statements:
	//
	// * An IP match statement with an IP set that specified the
	// address 192.0.2.44.
	//
	// * A string match statement that searches in the User-Agent
	// header for the string BadBot.
	//
	// In this rate-based rule, you also define a rate
	// limit. For this example, the rate limit is 1,000. Requests that meet both of the
	// conditions in the statements are counted. If the count exceeds 1,000 requests
	// per five minutes, the rule action triggers. Requests that do not meet both
	// conditions are not counted towards the rate limit and are not affected by this
	// rule. You cannot nest a RateBasedStatement inside another statement, for example
	// inside a NotStatement or OrStatement. You can define a RateBasedStatement inside
	// a web ACL and inside a rule group.
	RateBasedStatement *RateBasedStatement

	// A rule statement used to search web request components for a match against a
	// single regular expression.
	RegexMatchStatement *RegexMatchStatement

	// A rule statement used to search web request components for matches with regular
	// expressions. To use this, create a RegexPatternSet that specifies the
	// expressions that you want to detect, then use the ARN of that set in this
	// statement. A web request matches the pattern set rule statement if the request
	// component matches any of the patterns in the set. To create a regex pattern set,
	// see CreateRegexPatternSet. Each regex pattern set rule statement references a
	// regex pattern set. You create and maintain the set independent of your rules.
	// This allows you to use the single set in multiple rules. When you update the
	// referenced set, WAF automatically updates all rules that reference it.
	RegexPatternSetReferenceStatement *RegexPatternSetReferenceStatement

	// A rule statement used to run the rules that are defined in a RuleGroup. To use
	// this, create a rule group with your rules, then provide the ARN of the rule
	// group in this statement. You cannot nest a RuleGroupReferenceStatement, for
	// example for use inside a NotStatement or OrStatement. You can only use a rule
	// group reference statement at the top level inside a web ACL.
	RuleGroupReferenceStatement *RuleGroupReferenceStatement

	// A rule statement that compares a number of bytes against the size of a request
	// component, using a comparison operator, such as greater than (>) or less than
	// (<). For example, you can use a size constraint statement to look for query
	// strings that are longer than 100 bytes. If you configure WAF to inspect the
	// request body, WAF inspects only the first 8192 bytes (8 KB). If the request body
	// for your web requests never exceeds 8192 bytes, you can create a size constraint
	// condition and block requests that have a request body greater than 8192 bytes.
	// If you choose URI for the value of Part of the request to filter on, the slash
	// (/) in the URI counts as one character. For example, the URI /logo.jpg is nine
	// characters long.
	SizeConstraintStatement *SizeConstraintStatement

	// Attackers sometimes insert malicious SQL code into web requests in an effort to
	// extract data from your database. To allow or block web requests that appear to
	// contain malicious SQL code, create one or more SQL injection match conditions.
	// An SQL injection match condition identifies the part of web requests, such as
	// the URI or the query string, that you want WAF to inspect. Later in the process,
	// when you create a web ACL, you specify whether to allow or block requests that
	// appear to contain malicious SQL code.
	SqliMatchStatement *SqliMatchStatement

	// A rule statement that defines a cross-site scripting (XSS) match search for WAF
	// to apply to web requests. XSS attacks are those where the attacker uses
	// vulnerabilities in a benign website as a vehicle to inject malicious client-site
	// scripts into other legitimate web browsers. The XSS match statement provides the
	// location in requests that you want WAF to search and text transformations to use
	// on the search area before WAF searches for character sequences that are likely
	// to be malicious strings.
	XssMatchStatement *XssMatchStatement

	noSmithyDocumentSerde
}

// A tag associated with an Amazon Web Services resource. Tags are key:value pairs
// that you can use to categorize and manage your resources, for purposes like
// billing or other management. Typically, the tag key represents a category, such
// as "environment", and the tag value represents a specific value within that
// category, such as "test," "development," or "production". Or you might set the
// tag key to "customer" and the value to the customer name or ID. You can specify
// one or more tags to add to each Amazon Web Services resource, up to 50 tags for
// a resource. You can tag the Amazon Web Services resources that you manage
// through WAF: web ACLs, rule groups, IP sets, and regex pattern sets. You can't
// manage or view tags through the WAF console.
type Tag struct {

	// Part of the key:value pair that defines a tag. You can use a tag key to describe
	// a category of information, such as "customer." Tag keys are case-sensitive.
	//
	// This member is required.
	Key *string

	// Part of the key:value pair that defines a tag. You can use a tag value to
	// describe a specific value within a category, such as "companyA" or "companyB."
	// Tag values are case-sensitive.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// The collection of tagging definitions for an Amazon Web Services resource. Tags
// are key:value pairs that you can use to categorize and manage your resources,
// for purposes like billing or other management. Typically, the tag key represents
// a category, such as "environment", and the tag value represents a specific value
// within that category, such as "test," "development," or "production". Or you
// might set the tag key to "customer" and the value to the customer name or ID.
// You can specify one or more tags to add to each Amazon Web Services resource, up
// to 50 tags for a resource. You can tag the Amazon Web Services resources that
// you manage through WAF: web ACLs, rule groups, IP sets, and regex pattern sets.
// You can't manage or view tags through the WAF console.
type TagInfoForResource struct {

	// The Amazon Resource Name (ARN) of the resource.
	ResourceARN *string

	// The array of Tag objects defined for the resource.
	TagList []Tag

	noSmithyDocumentSerde
}

// Text transformations eliminate some of the unusual formatting that attackers use
// in web requests in an effort to bypass detection.
type TextTransformation struct {

	// Sets the relative processing order for multiple transformations that are defined
	// for a rule statement. WAF processes all transformations, from lowest priority to
	// highest, before inspecting the transformed content. The priorities don't need to
	// be consecutive, but they must all be different.
	//
	// This member is required.
	Priority int32

	// You can specify the following transformation types: BASE64_DECODE - Decode a
	// Base64-encoded string. BASE64_DECODE_EXT - Decode a Base64-encoded string, but
	// use a forgiving implementation that ignores characters that aren't valid.
	// CMD_LINE - Command-line transformations. These are helpful in reducing
	// effectiveness of attackers who inject an operating system command-line command
	// and use unusual formatting to disguise some or all of the command.
	//
	// * Delete the
	// following characters: \ " ' ^
	//
	// * Delete spaces before the following characters:
	// / (
	//
	// * Replace the following characters with a space: , ;
	//
	// * Replace multiple
	// spaces with one space
	//
	// * Convert uppercase letters (A-Z) to lowercase
	// (a-z)
	//
	// COMPRESS_WHITE_SPACE - Replace these characters with a space character
	// (decimal 32):
	//
	// * \f, formfeed, decimal 12
	//
	// * \t, tab, decimal 9
	//
	// * \n, newline,
	// decimal 10
	//
	// * \r, carriage return, decimal 13
	//
	// * \v, vertical tab, decimal 11
	//
	// *
	// Non-breaking space, decimal 160
	//
	// COMPRESS_WHITE_SPACE also replaces multiple
	// spaces with one space. CSS_DECODE - Decode characters that were encoded using
	// CSS 2.x escape rules syndata.html#characters. This function uses up to two bytes
	// in the decoding process, so it can help to uncover ASCII characters that were
	// encoded using CSS encoding that wouldn’t typically be encoded. It's also useful
	// in countering evasion, which is a combination of a backslash and non-hexadecimal
	// characters. For example, ja\vascript for javascript. ESCAPE_SEQ_DECODE - Decode
	// the following ANSI C escape sequences: \a, \b, \f, \n, \r, \t, \v, \, ?, ', ",
	// \xHH (hexadecimal), \0OOO (octal). Encodings that aren't valid remain in the
	// output. HEX_DECODE - Decode a string of hexadecimal characters into a binary.
	// HTML_ENTITY_DECODE - Replace HTML-encoded characters with unencoded characters.
	// HTML_ENTITY_DECODE performs these operations:
	//
	// * Replaces (ampersand)quot; with
	// "
	//
	// * Replaces (ampersand)nbsp; with a non-breaking space, decimal 160
	//
	// *
	// Replaces (ampersand)lt; with a "less than" symbol
	//
	// * Replaces (ampersand)gt;
	// with >
	//
	// * Replaces characters that are represented in hexadecimal format,
	// (ampersand)#xhhhh;, with the corresponding characters
	//
	// * Replaces characters
	// that are represented in decimal format, (ampersand)#nnnn;, with the
	// corresponding characters
	//
	// JS_DECODE - Decode JavaScript escape sequences. If a
	// </code> uHHHH code is in the full-width ASCII code range of FF01-FF5E, then the
	// higher byte is used to detect and adjust the lower byte. If not, only the lower
	// byte is used and the higher byte is zeroed, causing a possible loss of
	// information.
	//     LOWERCASE - Convert uppercase letters (A-Z) to lowercase (a-z).
	// MD5 - Calculate an MD5 hash from the data in the input. The computed hash is in
	// a raw binary form. NONE - Specify NONE if you don't want any text
	// transformations. NORMALIZE_PATH - Remove multiple slashes, directory
	// self-references, and directory back-references that are not at the beginning of
	// the input from an input string. NORMALIZE_PATH_WIN - This is the same as
	// NORMALIZE_PATH, but first converts backslash characters to forward slashes.
	// REMOVE_NULLS - Remove all NULL bytes from the input. REPLACE_COMMENTS - Replace
	// each occurrence of a C-style comment (/* ... /) with a single space. Multiple
	// consecutive occurrences are not compressed. Unterminated comments are also
	// replaced with a space (ASCII 0x20). However, a standalone termination of a
	// comment (/) is not acted upon. REPLACE_NULLS - Replace NULL bytes in the input
	// with space characters (ASCII 0x20). SQL_HEX_DECODE - Decode SQL hex data.
	// Example (0x414243) will be decoded to (ABC). URL_DECODE - Decode a URL-encoded
	// value. URL_DECODE_UNI - Like URL_DECODE, but with support for Microsoft-specific
	// %u encoding. If the code is in the full-width ASCII code range of FF01-FF5E, the
	// higher byte is used to detect and adjust the lower byte. Otherwise, only the
	// lower byte is used and the higher byte is zeroed. UTF8_TO_UNICODE - Convert all
	// UTF-8 character sequences to Unicode. This helps input normalization, and
	// minimizing false-positives and false-negatives for non-English languages.
	//
	// This member is required.
	Type TextTransformationType

	noSmithyDocumentSerde
}

// In a GetSampledRequests request, the StartTime and EndTime objects specify the
// time range for which you want WAF to return a sample of web requests. You must
// specify the times in Coordinated Universal Time (UTC) format. UTC format
// includes the special designator, Z. For example, "2016-09-27T14:50Z". You can
// specify any time range in the previous three hours. In a GetSampledRequests
// response, the StartTime and EndTime objects specify the time range for which WAF
// actually returned a sample of web requests. WAF gets the specified number of
// requests from among the first 5,000 requests that your Amazon Web Services
// resource receives during the specified time period. If your resource receives
// more than 5,000 requests during that period, WAF stops sampling after the
// 5,000th request. In that case, EndTime is the time that WAF received the 5,000th
// request.
type TimeWindow struct {

	// The end of the time range from which you want GetSampledRequests to return a
	// sample of the requests that your Amazon Web Services resource received. You must
	// specify the times in Coordinated Universal Time (UTC) format. UTC format
	// includes the special designator, Z. For example, "2016-09-27T14:50Z". You can
	// specify any time range in the previous three hours.
	//
	// This member is required.
	EndTime *time.Time

	// The beginning of the time range from which you want GetSampledRequests to return
	// a sample of the requests that your Amazon Web Services resource received. You
	// must specify the times in Coordinated Universal Time (UTC) format. UTC format
	// includes the special designator, Z. For example, "2016-09-27T14:50Z". You can
	// specify any time range in the previous three hours.
	//
	// This member is required.
	StartTime *time.Time

	noSmithyDocumentSerde
}

// The path component of the URI of a web request. This is the part of a web
// request that identifies a resource. For example, /images/daily-ad.jpg. This is
// used only to indicate the web request component for WAF to inspect, in the
// FieldToMatch specification. JSON specification: "UriPath": {}
type UriPath struct {
	noSmithyDocumentSerde
}

// A version of the named managed rule group, that the rule group's vendor
// publishes for use by customers. This is intended for use only by vendors of
// managed rule sets. Vendors are Amazon Web Services and Amazon Web Services
// Marketplace sellers. Vendors, you can use the managed rule set APIs to provide
// controlled rollout of your versioned managed rule group offerings for your
// customers. The APIs are ListManagedRuleSets, GetManagedRuleSet,
// PutManagedRuleSetVersions, and UpdateManagedRuleSetVersionExpiryDate.
type VersionToPublish struct {

	// The Amazon Resource Name (ARN) of the vendor's rule group that's used in the
	// published managed rule group version.
	AssociatedRuleGroupArn *string

	// The amount of time the vendor expects this version of the managed rule group to
	// last, in days.
	ForecastedLifetime *int32

	noSmithyDocumentSerde
}

// Defines and enables Amazon CloudWatch metrics and web request sample collection.
type VisibilityConfig struct {

	// A boolean indicating whether the associated resource sends metrics to Amazon
	// CloudWatch. For the list of available metrics, see WAF Metrics
	// (https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html#waf-metrics).
	//
	// This member is required.
	CloudWatchMetricsEnabled bool

	// A name of the Amazon CloudWatch metric. The name can contain only the
	// characters: A-Z, a-z, 0-9, - (hyphen), and _ (underscore). The name can be from
	// one to 128 characters long. It can't contain whitespace or metric names reserved
	// for WAF, for example "All" and "Default_Action."
	//
	// This member is required.
	MetricName *string

	// A boolean indicating whether WAF should store a sampling of the web requests
	// that match the rules. You can view the sampled requests through the WAF console.
	//
	// This member is required.
	SampledRequestsEnabled bool

	noSmithyDocumentSerde
}

// A web ACL defines a collection of rules to use to inspect and control web
// requests. Each rule has an action defined (allow, block, or count) for requests
// that match the statement of the rule. In the web ACL, you assign a default
// action to take (allow, block) for any request that does not match any of the
// rules. The rules in a web ACL can be a combination of the types Rule, RuleGroup,
// and managed rule group. You can associate a web ACL with one or more Amazon Web
// Services resources to protect. The resources can be an Amazon CloudFront
// distribution, an Amazon API Gateway REST API, an Application Load Balancer, or
// an AppSync GraphQL API.
type WebACL struct {

	// The Amazon Resource Name (ARN) of the web ACL that you want to associate with
	// the resource.
	//
	// This member is required.
	ARN *string

	// The action to perform if none of the Rules contained in the WebACL match.
	//
	// This member is required.
	DefaultAction *DefaultAction

	// A unique identifier for the WebACL. This ID is returned in the responses to
	// create and list commands. You use this ID to do things like get, update, and
	// delete a WebACL.
	//
	// This member is required.
	Id *string

	// The name of the web ACL. You cannot change the name of a web ACL after you
	// create it.
	//
	// This member is required.
	Name *string

	// Defines and enables Amazon CloudWatch metrics and web request sample collection.
	//
	// This member is required.
	VisibilityConfig *VisibilityConfig

	// The web ACL capacity units (WCUs) currently being used by this web ACL. WAF uses
	// WCUs to calculate and control the operating resources that are used to run your
	// rules, rule groups, and web ACLs. WAF calculates capacity differently for each
	// rule type, to reflect the relative cost of each rule. Simple rules that cost
	// little to run use fewer WCUs than more complex rules that use more processing
	// power. Rule group capacity is fixed at creation, which helps users plan their
	// web ACL WCU usage when they use a rule group. The WCU limit for web ACLs is
	// 1,500.
	Capacity int64

	// Specifies how WAF should handle CAPTCHA evaluations for rules that don't have
	// their own CaptchaConfig settings. If you don't specify this, WAF uses its
	// default settings for CaptchaConfig.
	CaptchaConfig *CaptchaConfig

	// A map of custom response keys and content bodies. When you create a rule with a
	// block action, you can send a custom response to the web request. You define
	// these for the web ACL, and then use them in the rules and default actions that
	// you define in the web ACL. For information about customizing web requests and
	// responses, see Customizing web requests and responses in WAF
	// (https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html)
	// in the WAF Developer Guide
	// (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html). For
	// information about the limits on count and size for custom request and response
	// settings, see WAF quotas
	// (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in the WAF
	// Developer Guide
	// (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
	CustomResponseBodies map[string]CustomResponseBody

	// A description of the web ACL that helps with identification.
	Description *string

	// The label namespace prefix for this web ACL. All labels added by rules in this
	// web ACL have this prefix.
	//
	// * The syntax for the label namespace prefix for a web
	// ACL is the following: awswaf::webacl::
	//
	// * When a rule with a label matches a web
	// request, WAF adds the fully qualified label to the request. A fully qualified
	// label is made up of the label namespace from the rule group or web ACL where the
	// rule is defined and the label from the rule, separated by a colon: :
	LabelNamespace *string

	// Indicates whether this web ACL is managed by Firewall Manager. If true, then
	// only Firewall Manager can delete the web ACL or any Firewall Manager rule groups
	// in the web ACL.
	ManagedByFirewallManager bool

	// The last set of rules for WAF to process in the web ACL. This is defined in an
	// Firewall Manager WAF policy and contains only rule group references. You can't
	// alter these. Any rules and rule groups that you define for the web ACL are
	// prioritized before these. In the Firewall Manager WAF policy, the Firewall
	// Manager administrator can define a set of rule groups to run first in the web
	// ACL and a set of rule groups to run last. Within each set, the administrator
	// prioritizes the rule groups, to determine their relative processing order.
	PostProcessFirewallManagerRuleGroups []FirewallManagerRuleGroup

	// The first set of rules for WAF to process in the web ACL. This is defined in an
	// Firewall Manager WAF policy and contains only rule group references. You can't
	// alter these. Any rules and rule groups that you define for the web ACL are
	// prioritized after these. In the Firewall Manager WAF policy, the Firewall
	// Manager administrator can define a set of rule groups to run first in the web
	// ACL and a set of rule groups to run last. Within each set, the administrator
	// prioritizes the rule groups, to determine their relative processing order.
	PreProcessFirewallManagerRuleGroups []FirewallManagerRuleGroup

	// The Rule statements used to identify the web requests that you want to allow,
	// block, or count. Each rule includes one top-level statement that WAF uses to
	// identify matching web requests, and parameters that govern how WAF handles them.
	Rules []Rule

	noSmithyDocumentSerde
}

// High-level information about a WebACL, returned by operations like create and
// list. This provides information like the ID, that you can use to retrieve and
// manage a WebACL, and the ARN, that you provide to operations like
// AssociateWebACL.
type WebACLSummary struct {

	// The Amazon Resource Name (ARN) of the entity.
	ARN *string

	// A description of the web ACL that helps with identification.
	Description *string

	// The unique identifier for the web ACL. This ID is returned in the responses to
	// create and list commands. You provide it to operations like update and delete.
	Id *string

	// A token used for optimistic locking. WAF returns a token to your get and list
	// requests, to mark the state of the entity at the time of the request. To make
	// changes to the entity associated with the token, you provide the token to
	// operations like update and delete. WAF uses the token to ensure that no changes
	// have been made to the entity since you last retrieved it. If a change has been
	// made, the update fails with a WAFOptimisticLockException. If this happens,
	// perform another get, and use the new token returned by that operation.
	LockToken *string

	// The name of the web ACL. You cannot change the name of a web ACL after you
	// create it.
	Name *string

	noSmithyDocumentSerde
}

// A rule statement that defines a cross-site scripting (XSS) match search for WAF
// to apply to web requests. XSS attacks are those where the attacker uses
// vulnerabilities in a benign website as a vehicle to inject malicious client-site
// scripts into other legitimate web browsers. The XSS match statement provides the
// location in requests that you want WAF to search and text transformations to use
// on the search area before WAF searches for character sequences that are likely
// to be malicious strings.
type XssMatchStatement struct {

	// The part of a web request that you want WAF to inspect. For more information,
	// see FieldToMatch.
	//
	// This member is required.
	FieldToMatch *FieldToMatch

	// Text transformations eliminate some of the unusual formatting that attackers use
	// in web requests in an effort to bypass detection. If you specify one or more
	// transformations in a rule statement, WAF performs all transformations on the
	// content of the request component identified by FieldToMatch, starting from the
	// lowest priority setting, before inspecting the content for a match.
	//
	// This member is required.
	TextTransformations []TextTransformation

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
