// Code generated by smithy-go-codegen DO NOT EDIT.

package rekognition

import (
	"context"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/rekognition/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Creates a new version of a model and begins training. Models are managed as part
// of an Amazon Rekognition Custom Labels project. The response from
// CreateProjectVersion is an Amazon Resource Name (ARN) for the version of the
// model. Training uses the training and test datasets associated with the project.
// For more information, see Creating training and test dataset in the Amazon
// Rekognition Custom Labels Developer Guide. You can train a modelin a project
// that doesn't have associated datasets by specifying manifest files in the
// TrainingData and TestingData fields. If you open the console after training a
// model with manifest files, Amazon Rekognition Custom Labels creates the datasets
// for you using the most recent manifest files. You can no longer train a model
// version for the project by specifying manifest files. Instead of training with a
// project without associated datasets, we recommend that you use the manifest
// files to create training and test datasets for the project. Training takes a
// while to complete. You can get the current status by calling
// DescribeProjectVersions. Training completed successfully if the value of the
// Status field is TRAINING_COMPLETED. If training fails, see Debugging a failed
// model training in the Amazon Rekognition Custom Labels developer guide. Once
// training has successfully completed, call DescribeProjectVersions to get the
// training results and evaluate the model. For more information, see Improving a
// trained Amazon Rekognition Custom Labels model in the Amazon Rekognition Custom
// Labels developers guide. After evaluating the model, you start the model by
// calling StartProjectVersion. This operation requires permissions to perform the
// rekognition:CreateProjectVersion action.
func (c *Client) CreateProjectVersion(ctx context.Context, params *CreateProjectVersionInput, optFns ...func(*Options)) (*CreateProjectVersionOutput, error) {
	if params == nil {
		params = &CreateProjectVersionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateProjectVersion", params, optFns, c.addOperationCreateProjectVersionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateProjectVersionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateProjectVersionInput struct {

	// The Amazon S3 bucket location to store the results of training. The S3 bucket
	// can be in any AWS account as long as the caller has s3:PutObject permissions on
	// the S3 bucket.
	//
	// This member is required.
	OutputConfig *types.OutputConfig

	// The ARN of the Amazon Rekognition Custom Labels project that manages the model
	// that you want to train.
	//
	// This member is required.
	ProjectArn *string

	// A name for the version of the model. This value must be unique.
	//
	// This member is required.
	VersionName *string

	// The identifier for your AWS Key Management Service key (AWS KMS key). You can
	// supply the Amazon Resource Name (ARN) of your KMS key, the ID of your KMS key,
	// an alias for your KMS key, or an alias ARN. The key is used to encrypt training
	// and test images copied into the service for model training. Your source images
	// are unaffected. The key is also used to encrypt training results and manifest
	// files written to the output Amazon S3 bucket (OutputConfig). If you choose to
	// use your own KMS key, you need the following permissions on the KMS key.
	//
	// *
	// kms:CreateGrant
	//
	// * kms:DescribeKey
	//
	// * kms:GenerateDataKey
	//
	// * kms:Decrypt
	//
	// If you
	// don't specify a value for KmsKeyId, images copied into the service are encrypted
	// using a key that AWS owns and manages.
	KmsKeyId *string

	// A set of tags (key-value pairs) that you want to attach to the model.
	Tags map[string]string

	// Specifies an external manifest that the service uses to test the model. If you
	// specify TestingData you must also specify TrainingData. The project must not
	// have any associated datasets.
	TestingData *types.TestingData

	// Specifies an external manifest that the services uses to train the model. If you
	// specify TrainingData you must also specify TestingData. The project must not
	// have any associated datasets.
	TrainingData *types.TrainingData

	noSmithyDocumentSerde
}

type CreateProjectVersionOutput struct {

	// The ARN of the model version that was created. Use DescribeProjectVersion to get
	// the current status of the training operation.
	ProjectVersionArn *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateProjectVersionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpCreateProjectVersion{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpCreateProjectVersion{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateProjectVersionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateProjectVersion(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opCreateProjectVersion(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "rekognition",
		OperationName: "CreateProjectVersion",
	}
}
