// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// A structure that encapsulates a signaling channel's metadata and properties.
type ChannelInfo struct {

	// The Amazon Resource Name (ARN) of the signaling channel.
	ChannelARN *string

	// The name of the signaling channel.
	ChannelName *string

	// Current status of the signaling channel.
	ChannelStatus Status

	// The type of the signaling channel.
	ChannelType ChannelType

	// The time at which the signaling channel was created.
	CreationTime *time.Time

	// A structure that contains the configuration for the SINGLE_MASTER channel type.
	SingleMasterConfiguration *SingleMasterConfiguration

	// The current version of the signaling channel.
	Version *string

	noSmithyDocumentSerde
}

// An optional input parameter for the ListSignalingChannels API. When this
// parameter is specified while invoking ListSignalingChannels, the API returns
// only the channels that satisfy a condition specified in ChannelNameCondition.
type ChannelNameCondition struct {

	// A comparison operator. Currently, you can only specify the BEGINS_WITH operator,
	// which finds signaling channels whose names begin with a given prefix.
	ComparisonOperator ComparisonOperator

	// A value to compare.
	ComparisonValue *string

	noSmithyDocumentSerde
}

// An object that describes the endpoint of the signaling channel returned by the
// GetSignalingChannelEndpoint API.
type ResourceEndpointListItem struct {

	// The protocol of the signaling channel returned by the
	// GetSignalingChannelEndpoint API.
	Protocol ChannelProtocol

	// The endpoint of the signaling channel returned by the
	// GetSignalingChannelEndpoint API.
	ResourceEndpoint *string

	noSmithyDocumentSerde
}

// An object that contains the endpoint configuration for the SINGLE_MASTER channel
// type.
type SingleMasterChannelEndpointConfiguration struct {

	// This property is used to determine the nature of communication over this
	// SINGLE_MASTER signaling channel. If WSS is specified, this API returns a
	// websocket endpoint. If HTTPS is specified, this API returns an HTTPS endpoint.
	Protocols []ChannelProtocol

	// This property is used to determine messaging permissions in this SINGLE_MASTER
	// signaling channel. If MASTER is specified, this API returns an endpoint that a
	// client can use to receive offers from and send answers to any of the viewers on
	// this signaling channel. If VIEWER is specified, this API returns an endpoint
	// that a client can use only to send offers to another MASTER client on this
	// signaling channel.
	Role ChannelRole

	noSmithyDocumentSerde
}

// A structure that contains the configuration for the SINGLE_MASTER channel type.
type SingleMasterConfiguration struct {

	// The period of time a signaling channel retains underlivered messages before they
	// are discarded.
	MessageTtlSeconds *int32

	noSmithyDocumentSerde
}

// An object describing a Kinesis video stream.
type StreamInfo struct {

	// A time stamp that indicates when the stream was created.
	CreationTime *time.Time

	// How long the stream retains data, in hours.
	DataRetentionInHours *int32

	// The name of the device that is associated with the stream.
	DeviceName *string

	// The ID of the AWS Key Management Service (AWS KMS) key that Kinesis Video
	// Streams uses to encrypt data on the stream.
	KmsKeyId *string

	// The MediaType of the stream.
	MediaType *string

	// The status of the stream.
	Status Status

	// The Amazon Resource Name (ARN) of the stream.
	StreamARN *string

	// The name of the stream.
	StreamName *string

	// The version of the stream.
	Version *string

	noSmithyDocumentSerde
}

// Specifies the condition that streams must satisfy to be returned when you list
// streams (see the ListStreams API). A condition has a comparison operation and a
// value. Currently, you can specify only the BEGINS_WITH operator, which finds
// streams whose names start with a given prefix.
type StreamNameCondition struct {

	// A comparison operator. Currently, you can specify only the BEGINS_WITH operator,
	// which finds streams whose names start with a given prefix.
	ComparisonOperator ComparisonOperator

	// A value to compare.
	ComparisonValue *string

	noSmithyDocumentSerde
}

// A key and value pair that is associated with the specified signaling channel.
type Tag struct {

	// The key of the tag that is associated with the specified signaling channel.
	//
	// This member is required.
	Key *string

	// The value of the tag that is associated with the specified signaling channel.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
