// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Access Control List files for the documents in a data source. For the format of
// the file, see Access control for S3 data sources
// (https://docs.aws.amazon.com/kendra/latest/dg/s3-acl.html).
type AccessControlListConfiguration struct {

	// Path to the Amazon Web Services S3 bucket that contains the ACL files.
	KeyPath *string

	noSmithyDocumentSerde
}

// Provides information about the column that should be used for filtering the
// query response by groups.
type AclConfiguration struct {

	// A list of groups, separated by semi-colons, that filters a query response based
	// on user context. The document is only returned to users that are in one of the
	// groups specified in the UserContext field of the Query operation.
	//
	// This member is required.
	AllowedGroupsColumnName *string

	noSmithyDocumentSerde
}

// An attribute returned from an index query.
type AdditionalResultAttribute struct {

	// The key that identifies the attribute.
	//
	// This member is required.
	Key *string

	// An object that contains the attribute value.
	//
	// This member is required.
	Value *AdditionalResultAttributeValue

	// The data type of the Value property.
	//
	// This member is required.
	ValueType AdditionalResultAttributeValueType

	noSmithyDocumentSerde
}

// An attribute returned with a document from a search.
type AdditionalResultAttributeValue struct {

	// The text associated with the attribute and information about the highlight to
	// apply to the text.
	TextWithHighlightsValue *TextWithHighlights

	noSmithyDocumentSerde
}

// Provides filtering the query results based on document attributes. When you use
// the AndAllFilters or OrAllFilters, filters you can use 2 layers under the first
// attribute filter. For example, you can use:
//
// If you use more than 2 layers, you
// receive a ValidationException exception with the message "AttributeFilter cannot
// have a depth of more than 2." If you use more than 10 attribute filters in a
// given list for AndAllFilters or OrAllFilters, you receive a ValidationException
// with the message "AttributeFilter cannot have a length of more than 10".
type AttributeFilter struct {

	// Performs a logical AND operation on all supplied filters.
	AndAllFilters []AttributeFilter

	// Returns true when a document contains all of the specified document attributes.
	// This filter is only applicable to StringListValue metadata.
	ContainsAll *DocumentAttribute

	// Returns true when a document contains any of the specified document attributes.
	// This filter is only applicable to StringListValue metadata.
	ContainsAny *DocumentAttribute

	// Performs an equals operation on two document attributes.
	EqualsTo *DocumentAttribute

	// Performs a greater than operation on two document attributes. Use with a
	// document attribute of type Date or Long.
	GreaterThan *DocumentAttribute

	// Performs a greater or equals than operation on two document attributes. Use with
	// a document attribute of type Date or Long.
	GreaterThanOrEquals *DocumentAttribute

	// Performs a less than operation on two document attributes. Use with a document
	// attribute of type Date or Long.
	LessThan *DocumentAttribute

	// Performs a less than or equals operation on two document attributes. Use with a
	// document attribute of type Date or Long.
	LessThanOrEquals *DocumentAttribute

	// Performs a logical NOT operation on all supplied filters.
	NotFilter *AttributeFilter

	// Performs a logical OR operation on all supplied filters.
	OrAllFilters []AttributeFilter

	noSmithyDocumentSerde
}

// Provides the configuration information to connect to websites that require user
// authentication.
type AuthenticationConfiguration struct {

	// The list of configuration information that's required to connect to and crawl a
	// website host using basic authentication credentials. The list includes the name
	// and port number of the website host.
	BasicAuthentication []BasicAuthenticationConfiguration

	noSmithyDocumentSerde
}

// Provides the configuration information to connect to websites that require basic
// user authentication.
type BasicAuthenticationConfiguration struct {

	// Your secret ARN, which you can create in Secrets Manager
	// (https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html) You use
	// a secret if basic authentication credentials are required to connect to a
	// website. The secret stores your credentials of user name and password.
	//
	// This member is required.
	Credentials *string

	// The name of the website host you want to connect to using authentication
	// credentials. For example, the host name of https://a.example.com/page1.html is
	// "a.example.com".
	//
	// This member is required.
	Host *string

	// The port number of the website host you want to connect to using authentication
	// credentials. For example, the port for https://a.example.com/page1.html is 443,
	// the standard port for HTTPS.
	//
	// This member is required.
	Port *int32

	noSmithyDocumentSerde
}

// Provides information about documents that could not be removed from an index by
// the BatchDeleteDocument operation.
type BatchDeleteDocumentResponseFailedDocument struct {

	// The error code for why the document couldn't be removed from the index.
	ErrorCode ErrorCode

	// An explanation for why the document couldn't be removed from the index.
	ErrorMessage *string

	// The identifier of the document that couldn't be removed from the index.
	Id *string

	noSmithyDocumentSerde
}

// Provides a response when the status of a document could not be retrieved.
type BatchGetDocumentStatusResponseError struct {

	// The unique identifier of the document whose status could not be retrieved.
	DocumentId *string

	// Indicates the source of the error.
	ErrorCode ErrorCode

	// States that the API could not get the status of a document. This could be
	// because the request is not valid or there is a system error.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// Provides information about a document that could not be indexed.
type BatchPutDocumentResponseFailedDocument struct {

	// The type of error that caused the document to fail to be indexed.
	ErrorCode ErrorCode

	// A description of the reason why the document could not be indexed.
	ErrorMessage *string

	// The unique identifier of the document.
	Id *string

	noSmithyDocumentSerde
}

// Specifies capacity units configured for your enterprise edition index. You can
// add and remove capacity units to tune an index to your requirements.
type CapacityUnitsConfiguration struct {

	// The amount of extra query capacity for an index and GetQuerySuggestions
	// (https://docs.aws.amazon.com/kendra/latest/dg/API_GetQuerySuggestions.html)
	// capacity. A single extra capacity unit for an index provides 0.1 queries per
	// second or approximately 8,000 queries per day. GetQuerySuggestions capacity is
	// five times the provisioned query capacity for an index, or the base capacity of
	// 2.5 calls per second, whichever is higher. For example, the base capacity for an
	// index is 0.1 queries per second, and GetQuerySuggestions capacity has a base of
	// 2.5 calls per second. If you add another 0.1 queries per second to total 0.2
	// queries per second for an index, the GetQuerySuggestions capacity is 2.5 calls
	// per second (higher than five times 0.2 queries per second).
	//
	// This member is required.
	QueryCapacityUnits *int32

	// The amount of extra storage capacity for an index. A single capacity unit
	// provides 30 GB of storage space or 100,000 documents, whichever is reached
	// first.
	//
	// This member is required.
	StorageCapacityUnits *int32

	noSmithyDocumentSerde
}

// Gathers information about when a particular result was clicked by a user. Your
// application uses the SubmitFeedback operation to provide click information.
type ClickFeedback struct {

	// The Unix timestamp of the date and time that the result was clicked.
	//
	// This member is required.
	ClickTime *time.Time

	// The unique identifier of the search result that was clicked.
	//
	// This member is required.
	ResultId *string

	noSmithyDocumentSerde
}

// Provides information about how Amazon Kendra should use the columns of a
// database in an index.
type ColumnConfiguration struct {

	// One to five columns that indicate when a document in the database has changed.
	//
	// This member is required.
	ChangeDetectingColumns []string

	// The column that contains the contents of the document.
	//
	// This member is required.
	DocumentDataColumnName *string

	// The column that provides the document's unique identifier.
	//
	// This member is required.
	DocumentIdColumnName *string

	// The column that contains the title of the document.
	DocumentTitleColumnName *string

	// An array of objects that map database column names to the corresponding fields
	// in an index. You must first create the fields in the index using the UpdateIndex
	// operation.
	FieldMappings []DataSourceToIndexFieldMapping

	noSmithyDocumentSerde
}

// Specifies the attachment settings for the Confluence data source. Attachment
// settings are optional, if you don't specify settings attachments, Amazon Kendra
// won't index them.
type ConfluenceAttachmentConfiguration struct {

	// Defines how attachment metadata fields should be mapped to index fields. Before
	// you can map a field, you must first create an index field with a matching type
	// using the console or the UpdateIndex operation. If you specify the
	// AttachentFieldMappings parameter, you must specify at least one field mapping.
	AttachmentFieldMappings []ConfluenceAttachmentToIndexFieldMapping

	// Indicates whether Amazon Kendra indexes attachments to the pages and blogs in
	// the Confluence data source.
	CrawlAttachments bool

	noSmithyDocumentSerde
}

// Defines the mapping between a field in the Confluence data source to a Amazon
// Kendra index field. You must first create the index field using the UpdateIndex
// operation.
type ConfluenceAttachmentToIndexFieldMapping struct {

	// The name of the field in the data source. You must first create the index field
	// using the UpdateIndex operation.
	DataSourceFieldName ConfluenceAttachmentFieldName

	// The format for date fields in the data source. If the field specified in
	// DataSourceFieldName is a date field you must specify the date format. If the
	// field is not a date field, an exception is thrown.
	DateFieldFormat *string

	// The name of the index field to map to the Confluence data source field. The
	// index field type must match the Confluence field type.
	IndexFieldName *string

	noSmithyDocumentSerde
}

// Specifies the blog settings for the Confluence data source. Blogs are always
// indexed unless filtered from the index by the ExclusionPatterns or
// InclusionPatterns fields in the ConfluenceConfiguration type.
type ConfluenceBlogConfiguration struct {

	// Defines how blog metadata fields should be mapped to index fields. Before you
	// can map a field, you must first create an index field with a matching type using
	// the console or the UpdateIndex operation. If you specify the BlogFieldMappings
	// parameter, you must specify at least one field mapping.
	BlogFieldMappings []ConfluenceBlogToIndexFieldMapping

	noSmithyDocumentSerde
}

// Defines the mapping between a blog field in the Confluence data source to a
// Amazon Kendra index field. You must first create the index field using the
// UpdateIndex operation.
type ConfluenceBlogToIndexFieldMapping struct {

	// The name of the field in the data source.
	DataSourceFieldName ConfluenceBlogFieldName

	// The format for date fields in the data source. If the field specified in
	// DataSourceFieldName is a date field you must specify the date format. If the
	// field is not a date field, an exception is thrown.
	DateFieldFormat *string

	// The name of the index field to map to the Confluence data source field. The
	// index field type must match the Confluence field type.
	IndexFieldName *string

	noSmithyDocumentSerde
}

// Provides configuration information for data sources that connect to Confluence.
type ConfluenceConfiguration struct {

	// The Amazon Resource Name (ARN) of an Secrets Manager secret that contains the
	// key/value pairs required to connect to your Confluence server. The secret must
	// contain a JSON structure with the following keys:
	//
	// * username - The user name or
	// email address of a user with administrative privileges for the Confluence
	// server.
	//
	// * password - The password associated with the user logging in to the
	// Confluence server.
	//
	// This member is required.
	SecretArn *string

	// The URL of your Confluence instance. Use the full URL of the server. For
	// example, https://server.example.com:port/. You can also use an IP address, for
	// example, https://192.168.1.113/.
	//
	// This member is required.
	ServerUrl *string

	// Specifies the version of the Confluence installation that you are connecting to.
	//
	// This member is required.
	Version ConfluenceVersion

	// Specifies configuration information for indexing attachments to Confluence blogs
	// and pages.
	AttachmentConfiguration *ConfluenceAttachmentConfiguration

	// Specifies configuration information for indexing Confluence blogs.
	BlogConfiguration *ConfluenceBlogConfiguration

	// A list of regular expression patterns that apply to a URL on the Confluence
	// server. An exclusion pattern can apply to a blog post, a page, a space, or an
	// attachment. Items that match the pattern are excluded from the index. Items that
	// don't match the pattern are included in the index. If a item matches both an
	// exclusion pattern and an inclusion pattern, the item isn't included in the
	// index.
	ExclusionPatterns []string

	// A list of regular expression patterns that apply to a URL on the Confluence
	// server. An inclusion pattern can apply to a blog post, a page, a space, or an
	// attachment. Items that match the patterns are included in the index. Items that
	// don't match the pattern are excluded from the index. If an item matches both an
	// inclusion pattern and an exclusion pattern, the item isn't included in the
	// index.
	InclusionPatterns []string

	// Specifies configuration information for indexing Confluence pages.
	PageConfiguration *ConfluencePageConfiguration

	// Specifies configuration information for indexing Confluence spaces.
	SpaceConfiguration *ConfluenceSpaceConfiguration

	// Specifies the information for connecting to an Amazon VPC.
	VpcConfiguration *DataSourceVpcConfiguration

	noSmithyDocumentSerde
}

// Specifies the page settings for the Confluence data source.
type ConfluencePageConfiguration struct {

	// Defines how page metadata fields should be mapped to index fields. Before you
	// can map a field, you must first create an index field with a matching type using
	// the console or the UpdateIndex operation. If you specify the PageFieldMappings
	// parameter, you must specify at least one field mapping.
	PageFieldMappings []ConfluencePageToIndexFieldMapping

	noSmithyDocumentSerde
}

// Defines the mapping between a field in the Confluence data source to a Amazon
// Kendra index field. You must first create the index field using the UpdateIndex
// operation.
type ConfluencePageToIndexFieldMapping struct {

	// The name of the field in the data source.
	DataSourceFieldName ConfluencePageFieldName

	// The format for date fields in the data source. If the field specified in
	// DataSourceFieldName is a date field you must specify the date format. If the
	// field is not a date field, an exception is thrown.
	DateFieldFormat *string

	// The name of the index field to map to the Confluence data source field. The
	// index field type must match the Confluence field type.
	IndexFieldName *string

	noSmithyDocumentSerde
}

// Specifies the configuration for indexing Confluence spaces.
type ConfluenceSpaceConfiguration struct {

	// Specifies whether Amazon Kendra should index archived spaces.
	CrawlArchivedSpaces bool

	// Specifies whether Amazon Kendra should index personal spaces. Users can add
	// restrictions to items in personal spaces. If personal spaces are indexed,
	// queries without user context information may return restricted items from a
	// personal space in their results. For more information, see Filtering on user
	// context (https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html).
	CrawlPersonalSpaces bool

	// A list of space keys of Confluence spaces. If you include a key, the blogs,
	// documents, and attachments in the space are not indexed. If a space is in both
	// the ExcludeSpaces and the IncludeSpaces list, the space is excluded.
	ExcludeSpaces []string

	// A list of space keys for Confluence spaces. If you include a key, the blogs,
	// documents, and attachments in the space are indexed. Spaces that aren't in the
	// list aren't indexed. A space in the list must exist. Otherwise, Amazon Kendra
	// logs an error when the data source is synchronized. If a space is in both the
	// IncludeSpaces and the ExcludeSpaces list, the space is excluded.
	IncludeSpaces []string

	// Defines how space metadata fields should be mapped to index fields. Before you
	// can map a field, you must first create an index field with a matching type using
	// the console or the UpdateIndex operation. If you specify the SpaceFieldMappings
	// parameter, you must specify at least one field mapping.
	SpaceFieldMappings []ConfluenceSpaceToIndexFieldMapping

	noSmithyDocumentSerde
}

// Defines the mapping between a field in the Confluence data source to a Amazon
// Kendra index field. You must first create the index field using the UpdateIndex
// operation.
type ConfluenceSpaceToIndexFieldMapping struct {

	// The name of the field in the data source.
	DataSourceFieldName ConfluenceSpaceFieldName

	// The format for date fields in the data source. If the field specified in
	// DataSourceFieldName is a date field you must specify the date format. If the
	// field is not a date field, an exception is thrown.
	DateFieldFormat *string

	// The name of the index field to map to the Confluence data source field. The
	// index field type must match the Confluence field type.
	IndexFieldName *string

	noSmithyDocumentSerde
}

// Provides the information necessary to connect to a database.
type ConnectionConfiguration struct {

	// The name of the host for the database. Can be either a string
	// (host.subdomain.domain.tld) or an IPv4 or IPv6 address.
	//
	// This member is required.
	DatabaseHost *string

	// The name of the database containing the document data.
	//
	// This member is required.
	DatabaseName *string

	// The port that the database uses for connections.
	//
	// This member is required.
	DatabasePort *int32

	// The Amazon Resource Name (ARN) of credentials stored in Secrets Manager. The
	// credentials should be a user/password pair. For more information, see Using a
	// Database Data Source
	// (https://docs.aws.amazon.com/kendra/latest/dg/data-source-database.html). For
	// more information about Secrets Manager, see  What Is Secrets Manager
	// (https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html) in the
	// Secrets Manager user guide.
	//
	// This member is required.
	SecretArn *string

	// The name of the table that contains the document data.
	//
	// This member is required.
	TableName *string

	noSmithyDocumentSerde
}

// Configuration information for your content sources, such as data sources, FAQs,
// and content indexed directly via BatchPutDocument
// (https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html).
type ContentSourceConfiguration struct {

	// The identifier of the data sources you want to use for your Amazon Kendra
	// experience.
	DataSourceIds []string

	// TRUE to use documents you indexed directly using the BatchPutDocument operation.
	DirectPutContent bool

	// The identifier of the FAQs that you want to use for your Amazon Kendra
	// experience.
	FaqIds []string

	noSmithyDocumentSerde
}

// Provides the configuration information for altering document metadata and
// content during the document ingestion process. For more information, see
// Customizing document metadata during the ingestion process
// (https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html).
type CustomDocumentEnrichmentConfiguration struct {

	// Configuration information to alter document attributes or metadata fields and
	// content when ingesting documents into Amazon Kendra.
	InlineConfigurations []InlineCustomDocumentEnrichmentConfiguration

	// Configuration information for invoking a Lambda function in Lambda on the
	// structured documents with their metadata and text extracted. You can use a
	// Lambda function to apply advanced logic for creating, modifying, or deleting
	// document metadata and content. For more information, see Advanced data
	// manipulation
	// (https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation).
	PostExtractionHookConfiguration *HookConfiguration

	// Configuration information for invoking a Lambda function in Lambda on the
	// original or raw documents before extracting their metadata and text. You can use
	// a Lambda function to apply advanced logic for creating, modifying, or deleting
	// document metadata and content. For more information, see Advanced data
	// manipulation
	// (https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#advanced-data-manipulation).
	PreExtractionHookConfiguration *HookConfiguration

	// The Amazon Resource Name (ARN) of a role with permission to run
	// PreExtractionHookConfiguration and PostExtractionHookConfiguration for altering
	// document metadata and content during the document ingestion process. For more
	// information, see IAM roles for Amazon Kendra
	// (https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
	RoleArn *string

	noSmithyDocumentSerde
}

// Provides the information necessary to connect a database to an index.
type DatabaseConfiguration struct {

	// Information about where the index should get the document information from the
	// database.
	//
	// This member is required.
	ColumnConfiguration *ColumnConfiguration

	// The information necessary to connect to a database.
	//
	// This member is required.
	ConnectionConfiguration *ConnectionConfiguration

	// The type of database engine that runs the database.
	//
	// This member is required.
	DatabaseEngineType DatabaseEngineType

	// Information about the database column that provides information for user context
	// filtering.
	AclConfiguration *AclConfiguration

	// Provides information about how Amazon Kendra uses quote marks around SQL
	// identifiers when querying a database data source.
	SqlConfiguration *SqlConfiguration

	// Provides information for connecting to an Amazon VPC.
	VpcConfiguration *DataSourceVpcConfiguration

	noSmithyDocumentSerde
}

// Configuration information for an Amazon Kendra data source.
type DataSourceConfiguration struct {

	// Provides configuration information for connecting to a Confluence data source.
	ConfluenceConfiguration *ConfluenceConfiguration

	// Provides information necessary to create a data source connector for a database.
	DatabaseConfiguration *DatabaseConfiguration

	// Provides configuration for data sources that connect to Google Drive.
	GoogleDriveConfiguration *GoogleDriveConfiguration

	// Provides configuration for data sources that connect to Microsoft OneDrive.
	OneDriveConfiguration *OneDriveConfiguration

	// Provides information to create a data source connector for a document repository
	// in an Amazon S3 bucket.
	S3Configuration *S3DataSourceConfiguration

	// Provides configuration information for data sources that connect to a Salesforce
	// site.
	SalesforceConfiguration *SalesforceConfiguration

	// Provides configuration for data sources that connect to ServiceNow instances.
	ServiceNowConfiguration *ServiceNowConfiguration

	// Provides information necessary to create a data source connector for a Microsoft
	// SharePoint site.
	SharePointConfiguration *SharePointConfiguration

	// Provides the configuration information required for Amazon Kendra Web Crawler.
	WebCrawlerConfiguration *WebCrawlerConfiguration

	// Provides the configuration information to connect to WorkDocs as your data
	// source.
	WorkDocsConfiguration *WorkDocsConfiguration

	noSmithyDocumentSerde
}

// Data source information for user context filtering.
type DataSourceGroup struct {

	// The identifier of the data source group you want to add to your list of data
	// source groups. This is for filtering search results based on the groups' access
	// to documents in that data source.
	//
	// This member is required.
	DataSourceId *string

	// The identifier of the group you want to add to your list of groups. This is for
	// filtering search results based on the groups' access to documents.
	//
	// This member is required.
	GroupId *string

	noSmithyDocumentSerde
}

// Summary information for a Amazon Kendra data source. Returned in a call to the
// DescribeDataSource operation.
type DataSourceSummary struct {

	// The UNIX datetime that the data source was created.
	CreatedAt *time.Time

	// The unique identifier for the data source.
	Id *string

	// The code for a language. This shows a supported language for all documents in
	// the data source. English is supported by default. For more information on
	// supported languages, including their codes, see Adding documents in languages
	// other than English
	// (https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html).
	LanguageCode *string

	// The name of the data source.
	Name *string

	// The status of the data source. When the status is ACTIVE the data source is
	// ready to use.
	Status DataSourceStatus

	// The type of the data source.
	Type DataSourceType

	// The UNIX datetime that the data source was lasted updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Provides information about a synchronization job.
type DataSourceSyncJob struct {

	// If the reason that the synchronization failed is due to an error with the
	// underlying data source, this field contains a code that identifies the error.
	DataSourceErrorCode *string

	// The UNIX datetime that the synchronization job was completed.
	EndTime *time.Time

	// If the Status field is set to FAILED, the ErrorCode field contains a the reason
	// that the synchronization failed.
	ErrorCode ErrorCode

	// If the Status field is set to ERROR, the ErrorMessage field contains a
	// description of the error that caused the synchronization to fail.
	ErrorMessage *string

	// A unique identifier for the synchronization job.
	ExecutionId *string

	// Maps a batch delete document request to a specific data source sync job. This is
	// optional and should only be supplied when documents are deleted by a data source
	// connector.
	Metrics *DataSourceSyncJobMetrics

	// The UNIX datetime that the synchronization job was started.
	StartTime *time.Time

	// The execution status of the synchronization job. When the Status field is set to
	// SUCCEEDED, the synchronization job is done. If the status code is set to FAILED,
	// the ErrorCode and ErrorMessage fields give you the reason for the failure.
	Status DataSourceSyncJobStatus

	noSmithyDocumentSerde
}

// Maps a batch delete document request to a specific data source sync job. This is
// optional and should only be supplied when documents are deleted by a data source
// connector.
type DataSourceSyncJobMetrics struct {

	// The number of documents added from the data source up to now in the data source
	// sync.
	DocumentsAdded *string

	// The number of documents deleted from the data source up to now in the data
	// source sync run.
	DocumentsDeleted *string

	// The number of documents that failed to sync from the data source up to now in
	// the data source sync run.
	DocumentsFailed *string

	// The number of documents modified in the data source up to now in the data source
	// sync run.
	DocumentsModified *string

	// The current number of documents crawled by the current sync job in the data
	// source.
	DocumentsScanned *string

	noSmithyDocumentSerde
}

// Maps a particular data source sync job to a particular data source.
type DataSourceSyncJobMetricTarget struct {

	// The ID of the data source that is running the sync job.
	//
	// This member is required.
	DataSourceId *string

	// The ID of the sync job that is running on the data source. If the ID of a sync
	// job is not provided and there is a sync job running, then the ID of this sync
	// job is used and metrics are generated for this sync job. If the ID of a sync job
	// is not provided and there is no sync job running, then no metrics are generated
	// and documents are indexed/deleted at the index level without sync job metrics
	// included.
	DataSourceSyncJobId *string

	noSmithyDocumentSerde
}

// Maps a column or attribute in the data source to an index field. You must first
// create the fields in the index using the UpdateIndex operation.
type DataSourceToIndexFieldMapping struct {

	// The name of the column or attribute in the data source.
	//
	// This member is required.
	DataSourceFieldName *string

	// The name of the field in the index.
	//
	// This member is required.
	IndexFieldName *string

	// The type of data stored in the column or attribute.
	DateFieldFormat *string

	noSmithyDocumentSerde
}

// Provides information for connecting to an Amazon VPC.
type DataSourceVpcConfiguration struct {

	// A list of identifiers of security groups within your Amazon VPC. The security
	// groups should enable Amazon Kendra to connect to the data source.
	//
	// This member is required.
	SecurityGroupIds []string

	// A list of identifiers for subnets within your Amazon VPC. The subnets should be
	// able to connect to each other in the VPC, and they should have outgoing access
	// to the Internet through a NAT device.
	//
	// This member is required.
	SubnetIds []string

	noSmithyDocumentSerde
}

// A document in an index.
type Document struct {

	// A unique identifier of the document in the index.
	//
	// This member is required.
	Id *string

	// Information on user and group access rights, which is used for user context
	// filtering.
	AccessControlList []Principal

	// Custom attributes to apply to the document. Use the custom attributes to provide
	// additional information for searching, to provide facets for refining searches,
	// and to provide additional information in the query response.
	Attributes []DocumentAttribute

	// The contents of the document. Documents passed to the Blob parameter must be
	// base64 encoded. Your code might not need to encode the document file bytes if
	// you're using an Amazon Web Services SDK to call Amazon Kendra operations. If you
	// are calling the Amazon Kendra endpoint directly using REST, you must base64
	// encode the contents before sending.
	Blob []byte

	// The file type of the document in the Blob field.
	ContentType ContentType

	// The list of principal
	// (https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html) lists that
	// define the hierarchy for which documents users should have access to.
	HierarchicalAccessControlList []HierarchicalPrincipal

	// Information required to find a specific file in an Amazon S3 bucket.
	S3Path *S3Path

	// The title of the document.
	Title *string

	noSmithyDocumentSerde
}

// A custom attribute value assigned to a document. For more information on how to
// create custom document attributes, see Custom Attributes
// (https://docs.aws.amazon.com/kendra/latest/dg/custom-attributes.html).
type DocumentAttribute struct {

	// The identifier for the attribute.
	//
	// This member is required.
	Key *string

	// The value of the attribute.
	//
	// This member is required.
	Value *DocumentAttributeValue

	noSmithyDocumentSerde
}

// The condition used for the target document attribute or metadata field when
// ingesting documents into Amazon Kendra. You use this with
// DocumentAttributeTarget to apply the condition
// (https://docs.aws.amazon.com/kendra/latest/dg/API_DocumentAttributeTarget.html).
// For example, you can create the 'Department' target field and have it prefill
// department names associated with the documents based on information in the
// 'Source_URI' field. Set the condition that if the 'Source_URI' field contains
// 'financial' in its URI value, then prefill the target field 'Department' with
// the target value 'Finance' for the document. Amazon Kendra cannot create a
// target field if it has not already been created as an index field. After you
// create your index field, you can create a document metadata field using
// DocumentAttributeTarget. Amazon Kendra then will map your newly created metadata
// field to your index field.
type DocumentAttributeCondition struct {

	// The identifier of the document attribute used for the condition. For example,
	// 'Source_URI' could be an identifier for the attribute or metadata field that
	// contains source URIs associated with the documents. Amazon Kendra currently does
	// not support _document_body as an attribute key used for the condition.
	//
	// This member is required.
	ConditionDocumentAttributeKey *string

	// The condition operator. For example, you can use 'Contains' to partially match a
	// string.
	//
	// This member is required.
	Operator ConditionOperator

	// The value used by the operator. For example, you can specify the value
	// 'financial' for strings in the 'Source_URI' field that partially match or
	// contain this value.
	ConditionOnValue *DocumentAttributeValue

	noSmithyDocumentSerde
}

// The target document attribute or metadata field you want to alter when ingesting
// documents into Amazon Kendra. For example, you can delete customer
// identification numbers associated with the documents, stored in the document
// metadata field called 'Customer_ID'. You set the target key as 'Customer_ID' and
// the deletion flag to TRUE. This removes all customer ID values in the field
// 'Customer_ID'. This would scrub personally identifiable information from each
// document's metadata. Amazon Kendra cannot create a target field if it has not
// already been created as an index field. After you create your index field, you
// can create a document metadata field using DocumentAttributeTarget. Amazon
// Kendra then will map your newly created metadata field to your index field. You
// can also use this with DocumentAttributeCondition
// (https://docs.aws.amazon.com/kendra/latest/dg/API_DocumentAttributeCondition.html).
type DocumentAttributeTarget struct {

	// The identifier of the target document attribute or metadata field. For example,
	// 'Department' could be an identifier for the target attribute or metadata field
	// that includes the department names associated with the documents.
	TargetDocumentAttributeKey *string

	// The target value you want to create for the target attribute. For example,
	// 'Finance' could be the target value for the target attribute key 'Department'.
	TargetDocumentAttributeValue *DocumentAttributeValue

	// TRUE to delete the existing target value for your specified target attribute
	// key. You cannot create a target value and set this to TRUE. To create a target
	// value (TargetDocumentAttributeValue), set this to FALSE.
	TargetDocumentAttributeValueDeletion bool

	noSmithyDocumentSerde
}

// The value of a custom document attribute. You can only provide one value for a
// custom attribute.
type DocumentAttributeValue struct {

	// A date expressed as an ISO 8601 string. It is important for the time zone to be
	// included in the ISO 8601 date-time format. For example,
	// 2012-03-25T12:30:10+01:00 is the ISO 8601 date-time format for March 25th 2012
	// at 12:30PM (plus 10 seconds) in Central European Time.
	DateValue *time.Time

	// A long integer value.
	LongValue *int64

	// A list of strings.
	StringListValue []string

	// A string, such as "department".
	StringValue *string

	noSmithyDocumentSerde
}

// Provides the count of documents that match a particular attribute when doing a
// faceted search.
type DocumentAttributeValueCountPair struct {

	// The number of documents in the response that have the attribute value for the
	// key.
	Count *int32

	// The value of the attribute. For example, "HR."
	DocumentAttributeValue *DocumentAttributeValue

	noSmithyDocumentSerde
}

// Identifies a document for which to retrieve status information
type DocumentInfo struct {

	// The unique identifier of the document.
	//
	// This member is required.
	DocumentId *string

	// Attributes that identify a specific version of a document to check. The only
	// valid attributes are:
	//
	// * version
	//
	// * datasourceId
	//
	// * jobExecutionId
	//
	// The
	// attributes follow these rules:
	//
	// * dataSourceId and jobExecutionId must be used
	// together.
	//
	// * version is ignored if dataSourceId and jobExecutionId are not
	// provided.
	//
	// * If dataSourceId and jobExecutionId are provided, but version is
	// not, the version defaults to "0".
	Attributes []DocumentAttribute

	noSmithyDocumentSerde
}

// Specifies the properties of a custom index field.
type DocumentMetadataConfiguration struct {

	// The name of the index field.
	//
	// This member is required.
	Name *string

	// The data type of the index field.
	//
	// This member is required.
	Type DocumentAttributeValueType

	// Provides manual tuning parameters to determine how the field affects the search
	// results.
	Relevance *Relevance

	// Provides information about how the field is used during a search.
	Search *Search

	noSmithyDocumentSerde
}

// Overrides the document relevance properties of a custom index field.
type DocumentRelevanceConfiguration struct {

	// The name of the tuning configuration to override document relevance at the index
	// level.
	//
	// This member is required.
	Name *string

	// Provides information for manually tuning the relevance of a field in a search.
	// When a query includes terms that match the field, the results are given a boost
	// in the response based on these tuning parameters.
	//
	// This member is required.
	Relevance *Relevance

	noSmithyDocumentSerde
}

// Document metadata files that contain information such as the document access
// control information, source URI, document author, and custom attributes. Each
// metadata file contains metadata about a single document.
type DocumentsMetadataConfiguration struct {

	// A prefix used to filter metadata configuration files in the Amazon Web Services
	// S3 bucket. The S3 bucket might contain multiple metadata files. Use S3Prefix to
	// include only the desired metadata files.
	S3Prefix *string

	noSmithyDocumentSerde
}

// Provides the configuration information of users or groups in your Amazon Web
// Services SSO identity source to grant access your Amazon Kendra experience.
type EntityConfiguration struct {

	// The identifier of a user or group in your Amazon Web Services SSO identity
	// source. For example, a user ID could be an email.
	//
	// This member is required.
	EntityId *string

	// Specifies whether you are configuring a User or a Group.
	//
	// This member is required.
	EntityType EntityType

	noSmithyDocumentSerde
}

// Information about the user entity.
type EntityDisplayData struct {

	// The first name of the user.
	FirstName *string

	// The name of the group.
	GroupName *string

	// The user name of the user.
	IdentifiedUserName *string

	// The last name of the user.
	LastName *string

	// The name of the user.
	UserName *string

	noSmithyDocumentSerde
}

// Provides the configuration information of users or groups in your Amazon Web
// Services SSO identity source for access to your Amazon Kendra experience.
// Specific permissions are defined for each user or group once they are granted
// access to your Amazon Kendra experience.
type EntityPersonaConfiguration struct {

	// The identifier of a user or group in your Amazon Web Services SSO identity
	// source. For example, a user ID could be an email.
	//
	// This member is required.
	EntityId *string

	// The persona that defines the specific permissions of the user or group in your
	// Amazon Web Services SSO identity source. The available personas or access roles
	// are Owner and Viewer. For more information on these personas, see Providing
	// access to your search page
	// (https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience).
	//
	// This member is required.
	Persona Persona

	noSmithyDocumentSerde
}

// Specifies the configuration information for your Amazon Kendra experience. This
// includes the data source IDs and/or FAQ IDs, and user or group information to
// grant access to your Amazon Kendra experience.
type ExperienceConfiguration struct {

	// The identifiers of your data sources and FAQs. Or, you can specify that you want
	// to use documents indexed via the BatchPutDocument operation. This is the content
	// you want to use for your Amazon Kendra experience.
	ContentSourceConfiguration *ContentSourceConfiguration

	// The Amazon Web Services SSO field name that contains the identifiers of your
	// users, such as their emails.
	UserIdentityConfiguration *UserIdentityConfiguration

	noSmithyDocumentSerde
}

// Provides the configuration information of the endpoint for your Amazon Kendra
// experience.
type ExperienceEndpoint struct {

	// The endpoint of your Amazon Kendra experience.
	Endpoint *string

	// The type of endpoint for your Amazon Kendra experience. The type currently
	// available is HOME, which is a unique and fully hosted URL to the home page of
	// your Amazon Kendra experience.
	EndpointType EndpointType

	noSmithyDocumentSerde
}

// Summary information for users or groups in your Amazon Web Services SSO identity
// source with granted access to your Amazon Kendra experience. You can create an
// Amazon Kendra experience such as a search application. For more information on
// creating a search application experience, see Building a search experience with
// no code
// (https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
type ExperienceEntitiesSummary struct {

	// Information about the user entity.
	DisplayData *EntityDisplayData

	// The identifier of a user or group in your Amazon Web Services SSO identity
	// source. For example, a user ID could be an email.
	EntityId *string

	// Shows the type as User or Group.
	EntityType EntityType

	noSmithyDocumentSerde
}

// Summary information for your Amazon Kendra experience. You can create an Amazon
// Kendra experience such as a search application. For more information on creating
// a search application experience, see Building a search experience with no code
// (https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
type ExperiencesSummary struct {

	// The date-time your Amazon Kendra experience was created.
	CreatedAt *time.Time

	// The endpoint URLs for your Amazon Kendra experiences. The URLs are unique and
	// fully hosted by Amazon Web Services.
	Endpoints []ExperienceEndpoint

	// The identifier of your Amazon Kendra experience.
	Id *string

	// The name of your Amazon Kendra experience.
	Name *string

	// The processing status of your Amazon Kendra experience.
	Status ExperienceStatus

	noSmithyDocumentSerde
}

// Information about a document attribute
type Facet struct {

	// The unique key for the document attribute.
	DocumentAttributeKey *string

	noSmithyDocumentSerde
}

// The facet values for the documents in the response.
type FacetResult struct {

	// The key for the facet values. This is the same as the DocumentAttributeKey
	// provided in the query.
	DocumentAttributeKey *string

	// An array of key/value pairs, where the key is the value of the attribute and the
	// count is the number of documents that share the key value.
	DocumentAttributeValueCountPairs []DocumentAttributeValueCountPair

	// The data type of the facet value. This is the same as the type defined for the
	// index field when it was created.
	DocumentAttributeValueType DocumentAttributeValueType

	noSmithyDocumentSerde
}

// Information on the users or groups in your Amazon Web Services SSO identity
// source that failed to properly configure with your Amazon Kendra experience.
type FailedEntity struct {

	// The identifier of the user or group in your Amazon Web Services SSO identity
	// source. For example, a user ID could be an email.
	EntityId *string

	// The reason the user or group in your Amazon Web Services SSO identity source
	// failed to properly configure with your Amazon Kendra experience.
	ErrorMessage *string

	noSmithyDocumentSerde
}

// Provides statistical information about the FAQ questions and answers contained
// in an index.
type FaqStatistics struct {

	// The total number of FAQ questions and answers contained in the index.
	//
	// This member is required.
	IndexedQuestionAnswersCount int32

	noSmithyDocumentSerde
}

// Provides information about a frequently asked questions and answer contained in
// an index.
type FaqSummary struct {

	// The UNIX datetime that the FAQ was added to the index.
	CreatedAt *time.Time

	// The file type used to create the FAQ.
	FileFormat FaqFileFormat

	// The unique identifier of the FAQ.
	Id *string

	// The code for a language. This shows a supported language for the FAQ document as
	// part of the summary information for FAQs. English is supported by default. For
	// more information on supported languages, including their codes, see Adding
	// documents in languages other than English
	// (https://docs.aws.amazon.com/kendra/latest/dg/in-adding-languages.html).
	LanguageCode *string

	// The name that you assigned the FAQ when you created or updated the FAQ.
	Name *string

	// The current status of the FAQ. When the status is ACTIVE the FAQ is ready for
	// use.
	Status FaqStatus

	// The UNIX datetime that the FAQ was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Provides configuration information for data sources that connect to Google
// Drive.
type GoogleDriveConfiguration struct {

	// The Amazon Resource Name (ARN) of a Secrets Managersecret that contains the
	// credentials required to connect to Google Drive. For more information, see Using
	// a Google Workspace Drive data source
	// (https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html).
	//
	// This member is required.
	SecretArn *string

	// A list of MIME types to exclude from the index. All documents matching the
	// specified MIME type are excluded. For a list of MIME types, see Using a Google
	// Workspace Drive data source
	// (https://docs.aws.amazon.com/kendra/latest/dg/data-source-google-drive.html).
	ExcludeMimeTypes []string

	// A list of identifiers or shared drives to exclude from the index. All files and
	// folders stored on the shared drive are excluded.
	ExcludeSharedDrives []string

	// A list of email addresses of the users. Documents owned by these users are
	// excluded from the index. Documents shared with excluded users are indexed unless
	// they are excluded in another way.
	ExcludeUserAccounts []string

	// A list of regular expression patterns that apply to the path on Google Drive.
	// Items that match the pattern are excluded from the index from both shared drives
	// and users' My Drives. Items that don't match the pattern are included in the
	// index. If an item matches both an exclusion pattern and an inclusion pattern, it
	// is excluded from the index.
	ExclusionPatterns []string

	// Defines mapping between a field in the Google Drive and a Amazon Kendra index
	// field. If you are using the console, you can define index fields when creating
	// the mapping. If you are using the API, you must first create the field using the
	// UpdateIndex operation.
	FieldMappings []DataSourceToIndexFieldMapping

	// A list of regular expression patterns that apply to path on Google Drive. Items
	// that match the pattern are included in the index from both shared drives and
	// users' My Drives. Items that don't match the pattern are excluded from the
	// index. If an item matches both an inclusion pattern and an exclusion pattern, it
	// is excluded from the index.
	InclusionPatterns []string

	noSmithyDocumentSerde
}

// A list of users or sub groups that belong to a group. Users and groups are
// useful for filtering search results to different users based on their group's
// access to documents.
type GroupMembers struct {

	// A list of sub groups that belong to a group. For example, the sub groups
	// "Research", "Engineering", and "Sales and Marketing" all belong to the group
	// "Company".
	MemberGroups []MemberGroup

	// A list of users that belong to a group. For example, a list of interns all
	// belong to the "Interns" group.
	MemberUsers []MemberUser

	// If you have more than 1000 users and/or sub groups for a single group, you need
	// to provide the path to the S3 file that lists your users and sub groups for a
	// group. Your sub groups can contain more than 1000 users, but the list of sub
	// groups that belong to a group (and/or users) must be no more than 1000. You can
	// download this example S3 file
	// (https://docs.aws.amazon.com/kendra/latest/dg/samples/group_members.zip) that
	// uses the correct format for listing group members. Note, dataSourceId is
	// optional. The value of type for a group is always GROUP and for a user it is
	// always USER.
	S3PathforGroupMembers *S3Path

	noSmithyDocumentSerde
}

// Information on the processing of PUT and DELETE actions for mapping users to
// their groups.
type GroupOrderingIdSummary struct {

	// The reason an action could not be processed. An action can be a PUT or DELETE
	// action for mapping users to their groups.
	FailureReason *string

	// The last date-time an action was updated. An action can be a PUT or DELETE
	// action for mapping users to their groups.
	LastUpdatedAt *time.Time

	// The order in which actions should complete processing. An action can be a PUT or
	// DELETE action for mapping users to their groups.
	OrderingId *int64

	// The date-time an action was received by Amazon Kendra. An action can be a PUT or
	// DELETE action for mapping users to their groups.
	ReceivedAt *time.Time

	// The current processing status of actions for mapping users to their groups. The
	// status can be either PROCESSING, SUCCEEDED, DELETING, DELETED, or FAILED.
	Status PrincipalMappingStatus

	noSmithyDocumentSerde
}

// Group summary information.
type GroupSummary struct {

	// The identifier of the group you want group summary information on.
	GroupId *string

	// The timestamp identifier used for the latest PUT or DELETE action.
	OrderingId *int64

	noSmithyDocumentSerde
}

// Information to define the hierarchy for which documents users should have access
// to.
type HierarchicalPrincipal struct {

	// A list of principal
	// (https://docs.aws.amazon.com/kendra/latest/dg/API_Principal.html) lists that
	// define the hierarchy for which documents users should have access to. Each
	// hierarchical list specifies which user or group has allow or deny access for
	// each document.
	//
	// This member is required.
	PrincipalList []Principal

	noSmithyDocumentSerde
}

// Provides information that you can use to highlight a search result so that your
// users can quickly identify terms in the response.
type Highlight struct {

	// The zero-based location in the response string where the highlight starts.
	//
	// This member is required.
	BeginOffset *int32

	// The zero-based location in the response string where the highlight ends.
	//
	// This member is required.
	EndOffset *int32

	// Indicates whether the response is the best response. True if this is the best
	// response; otherwise, false.
	TopAnswer bool

	// The highlight type.
	Type HighlightType

	noSmithyDocumentSerde
}

// Provides the configuration information for invoking a Lambda function in Lambda
// to alter document metadata and content when ingesting documents into Amazon
// Kendra. You can configure your Lambda function using
// PreExtractionHookConfiguration
// (https://docs.aws.amazon.com/kendra/latest/dg/API_CustomDocumentEnrichmentConfiguration.html)
// if you want to apply advanced alterations on the original or raw documents. If
// you want to apply advanced alterations on the Amazon Kendra structured
// documents, you must configure your Lambda function using
// PostExtractionHookConfiguration
// (https://docs.aws.amazon.com/kendra/latest/dg/API_CustomDocumentEnrichmentConfiguration.html).
// You can only invoke one Lambda function. However, this function can invoke other
// functions it requires. For more information, see Customizing document metadata
// during the ingestion process
// (https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html).
type HookConfiguration struct {

	// The Amazon Resource Name (ARN) of a role with permission to run a Lambda
	// function during ingestion. For more information, see IAM roles for Amazon Kendra
	// (https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html).
	//
	// This member is required.
	LambdaArn *string

	// Stores the original, raw documents or the structured, parsed documents before
	// and after altering them. For more information, see Data contracts for Lambda
	// functions
	// (https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html#cde-data-contracts-lambda).
	//
	// This member is required.
	S3Bucket *string

	// The condition used for when a Lambda function should be invoked. For example,
	// you can specify a condition that if there are empty date-time values, then
	// Amazon Kendra should invoke a function that inserts the current date-time.
	InvocationCondition *DocumentAttributeCondition

	noSmithyDocumentSerde
}

// A summary of information about an index.
type IndexConfigurationSummary struct {

	// The Unix timestamp when the index was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The current status of the index. When the status is ACTIVE, the index is ready
	// to search.
	//
	// This member is required.
	Status IndexStatus

	// The Unix timestamp when the index was last updated by the UpdateIndex operation.
	//
	// This member is required.
	UpdatedAt *time.Time

	// Indicates whether the index is a enterprise edition index or a developer edition
	// index.
	Edition IndexEdition

	// A unique identifier for the index. Use this to identify the index when you are
	// using operations such as Query, DescribeIndex, UpdateIndex, and DeleteIndex.
	Id *string

	// The name of the index.
	Name *string

	noSmithyDocumentSerde
}

// Provides information about the number of documents and the number of questions
// and answers in an index.
type IndexStatistics struct {

	// The number of question and answer topics in the index.
	//
	// This member is required.
	FaqStatistics *FaqStatistics

	// The number of text documents indexed.
	//
	// This member is required.
	TextDocumentStatistics *TextDocumentStatistics

	noSmithyDocumentSerde
}

// Provides the configuration information for applying basic logic to alter
// document metadata and content when ingesting documents into Amazon Kendra. To
// apply advanced logic, to go beyond what you can do with basic logic, see
// HookConfiguration
// (https://docs.aws.amazon.com/kendra/latest/dg/API_HookConfiguration.html). For
// more information, see Customizing document metadata during the ingestion process
// (https://docs.aws.amazon.com/kendra/latest/dg/custom-document-enrichment.html).
type InlineCustomDocumentEnrichmentConfiguration struct {

	// Configuration of the condition used for the target document attribute or
	// metadata field when ingesting documents into Amazon Kendra.
	Condition *DocumentAttributeCondition

	// TRUE to delete content if the condition used for the target attribute is met.
	DocumentContentDeletion bool

	// Configuration of the target document attribute or metadata field when ingesting
	// documents into Amazon Kendra. You can also include a value.
	Target *DocumentAttributeTarget

	noSmithyDocumentSerde
}

// Configuration information for the JSON token type.
type JsonTokenTypeConfiguration struct {

	// The group attribute field.
	//
	// This member is required.
	GroupAttributeField *string

	// The user name attribute field.
	//
	// This member is required.
	UserNameAttributeField *string

	noSmithyDocumentSerde
}

// Configuration information for the JWT token type.
type JwtTokenTypeConfiguration struct {

	// The location of the key.
	//
	// This member is required.
	KeyLocation KeyLocation

	// The regular expression that identifies the claim.
	ClaimRegex *string

	// The group attribute field.
	GroupAttributeField *string

	// The issuer of the token.
	Issuer *string

	// The Amazon Resource Name (arn) of the secret.
	SecretManagerArn *string

	// The signing key URL.
	URL *string

	// The user name attribute field.
	UserNameAttributeField *string

	noSmithyDocumentSerde
}

// The sub groups that belong to a group.
type MemberGroup struct {

	// The identifier of the sub group you want to map to a group.
	//
	// This member is required.
	GroupId *string

	// The identifier of the data source for the sub group you want to map to a group.
	DataSourceId *string

	noSmithyDocumentSerde
}

// The users that belong to a group.
type MemberUser struct {

	// The identifier of the user you want to map to a group.
	//
	// This member is required.
	UserId *string

	noSmithyDocumentSerde
}

// Provides configuration information for data sources that connect to OneDrive.
type OneDriveConfiguration struct {

	// A list of user accounts whose documents should be indexed.
	//
	// This member is required.
	OneDriveUsers *OneDriveUsers

	// The Amazon Resource Name (ARN) of an Secrets Managersecret that contains the
	// user name and password to connect to OneDrive. The user namd should be the
	// application ID for the OneDrive application, and the password is the application
	// key for the OneDrive application.
	//
	// This member is required.
	SecretArn *string

	// The Azure Active Directory domain of the organization.
	//
	// This member is required.
	TenantDomain *string

	// A Boolean value that specifies whether local groups are disabled (True) or
	// enabled (False).
	DisableLocalGroups bool

	// List of regular expressions applied to documents. Items that match the exclusion
	// pattern are not indexed. If you provide both an inclusion pattern and an
	// exclusion pattern, any item that matches the exclusion pattern isn't indexed.
	// The exclusion pattern is applied to the file name.
	ExclusionPatterns []string

	// A list of DataSourceToIndexFieldMapping objects that map Microsoft OneDrive
	// fields to custom fields in the Amazon Kendra index. You must first create the
	// index fields before you map OneDrive fields.
	FieldMappings []DataSourceToIndexFieldMapping

	// A list of regular expression patterns. Documents that match the pattern are
	// included in the index. Documents that don't match the pattern are excluded from
	// the index. If a document matches both an inclusion pattern and an exclusion
	// pattern, the document is not included in the index. The exclusion pattern is
	// applied to the file name.
	InclusionPatterns []string

	noSmithyDocumentSerde
}

// User accounts whose documents should be indexed.
type OneDriveUsers struct {

	// A list of users whose documents should be indexed. Specify the user names in
	// email format, for example, username@tenantdomain. If you need to index the
	// documents of more than 100 users, use the OneDriveUserS3Path field to specify
	// the location of a file containing a list of users.
	OneDriveUserList []string

	// The S3 bucket location of a file containing a list of users whose documents
	// should be indexed.
	OneDriveUserS3Path *S3Path

	noSmithyDocumentSerde
}

// Summary information for users or groups in your Amazon Web Services SSO identity
// source. This applies to users and groups with specific permissions that define
// their level of access to your Amazon Kendra experience. You can create an Amazon
// Kendra experience such as a search application. For more information on creating
// a search application experience, see Building a search experience with no code
// (https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html).
type PersonasSummary struct {

	// The date-time the summary information was created.
	CreatedAt *time.Time

	// The identifier of a user or group in your Amazon Web Services SSO identity
	// source. For example, a user ID could be an email.
	EntityId *string

	// The persona that defines the specific permissions of the user or group in your
	// Amazon Web Services SSO identity source. The available personas or access roles
	// are Owner and Viewer. For more information on these personas, see Providing
	// access to your search page
	// (https://docs.aws.amazon.com/kendra/latest/dg/deploying-search-experience-no-code.html#access-search-experience).
	Persona Persona

	// The date-time the summary information was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Provides user and group information for document access filtering.
type Principal struct {

	// Whether to allow or deny access to the principal.
	//
	// This member is required.
	Access ReadAccessType

	// The name of the user or group.
	//
	// This member is required.
	Name *string

	// The type of principal.
	//
	// This member is required.
	Type PrincipalType

	// The identifier of the data source the principal should access documents from.
	DataSourceId *string

	noSmithyDocumentSerde
}

// Provides the configuration information for a web proxy to connect to website
// hosts.
type ProxyConfiguration struct {

	// The name of the website host you want to connect to via a web proxy server. For
	// example, the host name of https://a.example.com/page1.html is "a.example.com".
	//
	// This member is required.
	Host *string

	// The port number of the website host you want to connect to via a web proxy
	// server. For example, the port for https://a.example.com/page1.html is 443, the
	// standard port for HTTPS.
	//
	// This member is required.
	Port *int32

	// Your secret ARN, which you can create in Secrets Manager
	// (https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html) The
	// credentials are optional. You use a secret if web proxy credentials are required
	// to connect to a website host. Amazon Kendra currently support basic
	// authentication to connect to a web proxy server. The secret stores your
	// credentials.
	Credentials *string

	noSmithyDocumentSerde
}

// A single query result. A query result contains information about a document
// returned by the query. This includes the original location of the document, a
// list of attributes assigned to the document, and relevant text from the document
// that satisfies the query.
type QueryResultItem struct {

	// One or more additional attributes associated with the query result.
	AdditionalAttributes []AdditionalResultAttribute

	// An array of document attributes for the document that the query result maps to.
	// For example, the document author (Author) or the source URI (SourceUri) of the
	// document.
	DocumentAttributes []DocumentAttribute

	// An extract of the text in the document. Contains information about highlighting
	// the relevant terms in the excerpt.
	DocumentExcerpt *TextWithHighlights

	// The unique identifier for the document.
	DocumentId *string

	// The title of the document. Contains the text of the title and information for
	// highlighting the relevant terms in the title.
	DocumentTitle *TextWithHighlights

	// The URI of the original location of the document.
	DocumentURI *string

	// A token that identifies a particular result from a particular query. Use this
	// token to provide click-through feedback for the result. For more information,
	// see  Submitting feedback
	// (https://docs.aws.amazon.com/kendra/latest/dg/submitting-feedback.html).
	FeedbackToken *string

	// The unique identifier for the query result.
	Id *string

	// Indicates the confidence that Amazon Kendra has that a result matches the query
	// that you provided. Each result is placed into a bin that indicates the
	// confidence, VERY_HIGH, HIGH, MEDIUM and LOW. You can use the score to determine
	// if a response meets the confidence needed for your application. The field is
	// only set to LOW when the Type field is set to DOCUMENT and Amazon Kendra is not
	// confident that the result matches the query.
	ScoreAttributes *ScoreAttributes

	// The type of document.
	Type QueryResultType

	noSmithyDocumentSerde
}

// Summary information on a query suggestions block list. This includes information
// on the block list ID, block list name, when the block list was created, when the
// block list was last updated, and the count of block words/phrases in the block
// list. For information on the current quota limits for block lists, see Quotas
// for Amazon Kendra (https://docs.aws.amazon.com/kendra/latest/dg/quotas.html).
type QuerySuggestionsBlockListSummary struct {

	// The date-time summary information for a query suggestions block list was last
	// created.
	CreatedAt *time.Time

	// The identifier of a block list.
	Id *string

	// The number of items in the block list file.
	ItemCount *int32

	// The name of the block list.
	Name *string

	// The status of the block list.
	Status QuerySuggestionsBlockListStatus

	// The date-time the block list was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Provides information for manually tuning the relevance of a field in a search.
// When a query includes terms that match the field, the results are given a boost
// in the response based on these tuning parameters.
type Relevance struct {

	// Specifies the time period that the boost applies to. For example, to make the
	// boost apply to documents with the field value within the last month, you would
	// use "2628000s". Once the field value is beyond the specified range, the effect
	// of the boost drops off. The higher the importance, the faster the effect drops
	// off. If you don't specify a value, the default is 3 months. The value of the
	// field is a numeric string followed by the character "s", for example "86400s"
	// for one day, or "604800s" for one week. Only applies to DATE fields.
	Duration *string

	// Indicates that this field determines how "fresh" a document is. For example, if
	// document 1 was created on November 5, and document 2 was created on October 31,
	// document 1 is "fresher" than document 2. You can only set the Freshness field on
	// one DATE type field. Only applies to DATE fields.
	Freshness *bool

	// The relative importance of the field in the search. Larger numbers provide more
	// of a boost than smaller numbers.
	Importance *int32

	// Determines how values should be interpreted. When the RankOrder field is
	// ASCENDING, higher numbers are better. For example, a document with a rating
	// score of 10 is higher ranking than a document with a rating score of 1. When the
	// RankOrder field is DESCENDING, lower numbers are better. For example, in a task
	// tracking application, a priority 1 task is more important than a priority 5
	// task. Only applies to LONG and DOUBLE fields.
	RankOrder Order

	// A list of values that should be given a different boost when they appear in the
	// result list. For example, if you are boosting a field called "department," query
	// terms that match the department field are boosted in the result. However, you
	// can add entries from the department field to boost documents with those values
	// higher. For example, you can add entries to the map with names of departments.
	// If you add "HR",5 and "Legal",3 those departments are given special attention
	// when they appear in the metadata of a document. When those terms appear they are
	// given the specified importance instead of the regular importance for the boost.
	ValueImportanceMap map[string]int32

	noSmithyDocumentSerde
}

// Provides feedback on how relevant a document is to a search. Your application
// uses the SubmitFeedback operation to provide relevance information.
type RelevanceFeedback struct {

	// Whether to document was relevant or not relevant to the search.
	//
	// This member is required.
	RelevanceValue RelevanceType

	// The unique identifier of the search result that the user provided relevance
	// feedback for.
	//
	// This member is required.
	ResultId *string

	noSmithyDocumentSerde
}

// Provides configuration information for a data source to index documents in an
// Amazon S3 bucket.
type S3DataSourceConfiguration struct {

	// The name of the bucket that contains the documents.
	//
	// This member is required.
	BucketName *string

	// Provides the path to the S3 bucket that contains the user context filtering
	// files for the data source. For the format of the file, see Access control for S3
	// data sources (https://docs.aws.amazon.com/kendra/latest/dg/s3-acl.html).
	AccessControlListConfiguration *AccessControlListConfiguration

	// Document metadata files that contain information such as the document access
	// control information, source URI, document author, and custom attributes. Each
	// metadata file contains metadata about a single document.
	DocumentsMetadataConfiguration *DocumentsMetadataConfiguration

	// A list of glob patterns for documents that should not be indexed. If a document
	// that matches an inclusion prefix or inclusion pattern also matches an exclusion
	// pattern, the document is not indexed. Some examples
	// (https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters)
	// are:
	//
	// * *.png , *.jpg will exclude all PNG and JPEG image files in a directory
	// (files with the extensions .png and .jpg).
	//
	// * *internal* will exclude all files
	// in a directory that contain 'internal' in the file name, such as 'internal',
	// 'internal_only', 'company_internal'.
	//
	// * **/*internal* will exclude all
	// internal-related files in a directory and its subdirectories.
	ExclusionPatterns []string

	// A list of glob patterns for documents that should be indexed. If a document that
	// matches an inclusion pattern also matches an exclusion pattern, the document is
	// not indexed. Some examples
	// (https://docs.aws.amazon.com/cli/latest/reference/s3/#use-of-exclude-and-include-filters)
	// are:
	//
	// * *.txt will include all text files in a directory (files with the
	// extension .txt).
	//
	// * **/*.txt will include all text files in a directory and its
	// subdirectories.
	//
	// * *tax* will include all files in a directory that contain
	// 'tax' in the file name, such as 'tax', 'taxes', 'income_tax'.
	InclusionPatterns []string

	// A list of S3 prefixes for the documents that should be included in the index.
	InclusionPrefixes []string

	noSmithyDocumentSerde
}

// Information required to find a specific file in an Amazon S3 bucket.
type S3Path struct {

	// The name of the S3 bucket that contains the file.
	//
	// This member is required.
	Bucket *string

	// The name of the file.
	//
	// This member is required.
	Key *string

	noSmithyDocumentSerde
}

// Defines configuration for syncing a Salesforce chatter feed. The contents of the
// object comes from the Salesforce FeedItem table.
type SalesforceChatterFeedConfiguration struct {

	// The name of the column in the Salesforce FeedItem table that contains the
	// content to index. Typically this is the Body column.
	//
	// This member is required.
	DocumentDataFieldName *string

	// The name of the column in the Salesforce FeedItem table that contains the title
	// of the document. This is typically the Title column.
	DocumentTitleFieldName *string

	// Maps fields from a Salesforce chatter feed into Amazon Kendra index fields.
	FieldMappings []DataSourceToIndexFieldMapping

	// Filters the documents in the feed based on status of the user. When you specify
	// ACTIVE_USERS only documents from users who have an active account are indexed.
	// When you specify STANDARD_USER only documents for Salesforce standard users are
	// documented. You can specify both.
	IncludeFilterTypes []SalesforceChatterFeedIncludeFilterType

	noSmithyDocumentSerde
}

// Provides configuration information for connecting to a Salesforce data source.
type SalesforceConfiguration struct {

	// The Amazon Resource Name (ARN) of an Secrets Managersecret that contains the
	// key/value pairs required to connect to your Salesforce instance. The secret must
	// contain a JSON structure with the following keys:
	//
	// * authenticationUrl - The
	// OAUTH endpoint that Amazon Kendra connects to get an OAUTH token.
	//
	// * consumerKey
	// - The application public key generated when you created your Salesforce
	// application.
	//
	// * consumerSecret - The application private key generated when you
	// created your Salesforce application.
	//
	// * password - The password associated with
	// the user logging in to the Salesforce instance.
	//
	// * securityToken - The token
	// associated with the user account logging in to the Salesforce instance.
	//
	// *
	// username - The user name of the user logging in to the Salesforce instance.
	//
	// This member is required.
	SecretArn *string

	// The instance URL for the Salesforce site that you want to index.
	//
	// This member is required.
	ServerUrl *string

	// Specifies configuration information for Salesforce chatter feeds.
	ChatterFeedConfiguration *SalesforceChatterFeedConfiguration

	// Indicates whether Amazon Kendra should index attachments to Salesforce objects.
	CrawlAttachments bool

	// A list of regular expression patterns. Documents that match the patterns are
	// excluded from the index. Documents that don't match the patterns are included in
	// the index. If a document matches both an exclusion pattern and an inclusion
	// pattern, the document is not included in the index. The regex is applied to the
	// name of the attached file.
	ExcludeAttachmentFilePatterns []string

	// A list of regular expression patterns. Documents that match the patterns are
	// included in the index. Documents that don't match the patterns are excluded from
	// the index. If a document matches both an inclusion pattern and an exclusion
	// pattern, the document is not included in the index. The regex is applied to the
	// name of the attached file.
	IncludeAttachmentFilePatterns []string

	// Specifies configuration information for the knowledge article types that Amazon
	// Kendra indexes. Amazon Kendra indexes standard knowledge articles and the
	// standard fields of knowledge articles, or the custom fields of custom knowledge
	// articles, but not both.
	KnowledgeArticleConfiguration *SalesforceKnowledgeArticleConfiguration

	// Provides configuration information for processing attachments to Salesforce
	// standard objects.
	StandardObjectAttachmentConfiguration *SalesforceStandardObjectAttachmentConfiguration

	// Specifies the Salesforce standard objects that Amazon Kendra indexes.
	StandardObjectConfigurations []SalesforceStandardObjectConfiguration

	noSmithyDocumentSerde
}

// Provides configuration information for indexing Salesforce custom articles.
type SalesforceCustomKnowledgeArticleTypeConfiguration struct {

	// The name of the field in the custom knowledge article that contains the document
	// data to index.
	//
	// This member is required.
	DocumentDataFieldName *string

	// The name of the configuration.
	//
	// This member is required.
	Name *string

	// The name of the field in the custom knowledge article that contains the document
	// title.
	DocumentTitleFieldName *string

	// One or more objects that map fields in the custom knowledge article to fields in
	// the Amazon Kendra index.
	FieldMappings []DataSourceToIndexFieldMapping

	noSmithyDocumentSerde
}

// Specifies configuration information for the knowledge article types that Amazon
// Kendra indexes. Amazon Kendra indexes standard knowledge articles and the
// standard fields of knowledge articles, or the custom fields of custom knowledge
// articles, but not both
type SalesforceKnowledgeArticleConfiguration struct {

	// Specifies the document states that should be included when Amazon Kendra indexes
	// knowledge articles. You must specify at least one state.
	//
	// This member is required.
	IncludedStates []SalesforceKnowledgeArticleState

	// Provides configuration information for custom Salesforce knowledge articles.
	CustomKnowledgeArticleTypeConfigurations []SalesforceCustomKnowledgeArticleTypeConfiguration

	// Provides configuration information for standard Salesforce knowledge articles.
	StandardKnowledgeArticleTypeConfiguration *SalesforceStandardKnowledgeArticleTypeConfiguration

	noSmithyDocumentSerde
}

// Provides configuration information for standard Salesforce knowledge articles.
type SalesforceStandardKnowledgeArticleTypeConfiguration struct {

	// The name of the field that contains the document data to index.
	//
	// This member is required.
	DocumentDataFieldName *string

	// The name of the field that contains the document title.
	DocumentTitleFieldName *string

	// One or more objects that map fields in the knowledge article to Amazon Kendra
	// index fields. The index field must exist before you can map a Salesforce field
	// to it.
	FieldMappings []DataSourceToIndexFieldMapping

	noSmithyDocumentSerde
}

// Provides configuration information for processing attachments to Salesforce
// standard objects.
type SalesforceStandardObjectAttachmentConfiguration struct {

	// The name of the field used for the document title.
	DocumentTitleFieldName *string

	// One or more objects that map fields in attachments to Amazon Kendra index
	// fields.
	FieldMappings []DataSourceToIndexFieldMapping

	noSmithyDocumentSerde
}

// Specifies configuration information for indexing a single standard object.
type SalesforceStandardObjectConfiguration struct {

	// The name of the field in the standard object table that contains the document
	// contents.
	//
	// This member is required.
	DocumentDataFieldName *string

	// The name of the standard object.
	//
	// This member is required.
	Name SalesforceStandardObjectName

	// The name of the field in the standard object table that contains the document
	// title.
	DocumentTitleFieldName *string

	// One or more objects that map fields in the standard object to Amazon Kendra
	// index fields. The index field must exist before you can map a Salesforce field
	// to it.
	FieldMappings []DataSourceToIndexFieldMapping

	noSmithyDocumentSerde
}

// Provides a relative ranking that indicates how confident Amazon Kendra is that
// the response matches the query.
type ScoreAttributes struct {

	// A relative ranking for how well the response matches the query.
	ScoreConfidence ScoreConfidence

	noSmithyDocumentSerde
}

// Provides information about how a custom index field is used during a search.
type Search struct {

	// Determines whether the field is returned in the query response. The default is
	// true.
	Displayable bool

	// Indicates that the field can be used to create search facets, a count of results
	// for each value in the field. The default is false .
	Facetable bool

	// Determines whether the field is used in the search. If the Searchable field is
	// true, you can use relevance tuning to manually tune how Amazon Kendra weights
	// the field in the search. The default is true for string fields and false for
	// number and date fields.
	Searchable bool

	// Determines whether the field can be used to sort the results of a query. If you
	// specify sorting on a field that does not have Sortable set to true, Amazon
	// Kendra returns an exception. The default is false.
	Sortable bool

	noSmithyDocumentSerde
}

// Provides the configuration information of the seed or starting point URLs to
// crawl. When selecting websites to index, you must adhere to the Amazon
// Acceptable Use Policy (https://aws.amazon.com/aup/) and all other Amazon terms.
// Remember that you must only use Amazon Kendra Web Crawler to index your own
// webpages, or webpages that you have authorization to index.
type SeedUrlConfiguration struct {

	// The list of seed or starting point URLs of the websites you want to crawl. The
	// list can include a maximum of 100 seed URLs.
	//
	// This member is required.
	SeedUrls []string

	// You can choose one of the following modes:
	//
	// * HOST_ONLY – crawl only the website
	// host names. For example, if the seed URL is "abc.example.com", then only URLs
	// with host name "abc.example.com" are crawled.
	//
	// * SUBDOMAINS – crawl the website
	// host names with subdomains. For example, if the seed URL is "abc.example.com",
	// then "a.abc.example.com" and "b.abc.example.com" are also crawled.
	//
	// * EVERYTHING
	// – crawl the website host names with subdomains and other domains that the
	// webpages link to.
	//
	// The default mode is set to HOST_ONLY.
	WebCrawlerMode WebCrawlerMode

	noSmithyDocumentSerde
}

// Provides the identifier of the KMScustomer master key (CMK) used to encrypt data
// indexed by Amazon Kendra. Amazon Kendra doesn't support asymmetric CMKs.
type ServerSideEncryptionConfiguration struct {

	// The identifier of the KMScustomer master key (CMK). Amazon Kendra doesn't
	// support asymmetric CMKs.
	KmsKeyId *string

	noSmithyDocumentSerde
}

// Provides configuration information required to connect to a ServiceNow data
// source.
type ServiceNowConfiguration struct {

	// The ServiceNow instance that the data source connects to. The host endpoint
	// should look like the following: {instance}.service-now.com.
	//
	// This member is required.
	HostUrl *string

	// The Amazon Resource Name (ARN) of the Secrets Manager secret that contains the
	// user name and password required to connect to the ServiceNow instance.
	//
	// This member is required.
	SecretArn *string

	// The identifier of the release that the ServiceNow host is running. If the host
	// is not running the LONDON release, use OTHERS.
	//
	// This member is required.
	ServiceNowBuildVersion ServiceNowBuildVersionType

	// Determines the type of authentication used to connect to the ServiceNow
	// instance. If you choose HTTP_BASIC, Amazon Kendra is authenticated using the
	// user name and password provided in the Secrets Manager secret in the SecretArn
	// field. When you choose OAUTH2, Amazon Kendra is authenticated using the OAuth
	// token and secret provided in the Secrets Manager secret, and the user name and
	// password are used to determine which information Amazon Kendra has access to.
	// When you use OAUTH2 authentication, you must generate a token and a client
	// secret using the ServiceNow console. For more information, see Using a
	// ServiceNow data source
	// (https://docs.aws.amazon.com/kendra/latest/dg/data-source-servicenow.html).
	AuthenticationType ServiceNowAuthenticationType

	// Provides configuration information for crawling knowledge articles in the
	// ServiceNow site.
	KnowledgeArticleConfiguration *ServiceNowKnowledgeArticleConfiguration

	// Provides configuration information for crawling service catalogs in the
	// ServiceNow site.
	ServiceCatalogConfiguration *ServiceNowServiceCatalogConfiguration

	noSmithyDocumentSerde
}

// Provides configuration information for crawling knowledge articles in the
// ServiceNow site.
type ServiceNowKnowledgeArticleConfiguration struct {

	// The name of the ServiceNow field that is mapped to the index document contents
	// field in the Amazon Kendra index.
	//
	// This member is required.
	DocumentDataFieldName *string

	// Indicates whether Amazon Kendra should index attachments to knowledge articles.
	CrawlAttachments bool

	// The name of the ServiceNow field that is mapped to the index document title
	// field.
	DocumentTitleFieldName *string

	// List of regular expressions applied to knowledge articles. Items that don't
	// match the inclusion pattern are not indexed. The regex is applied to the field
	// specified in the PatternTargetField
	ExcludeAttachmentFilePatterns []string

	// Mapping between ServiceNow fields and Amazon Kendra index fields. You must
	// create the index field before you map the field.
	FieldMappings []DataSourceToIndexFieldMapping

	// A query that selects the knowledge articles to index. The query can return
	// articles from multiple knowledge bases, and the knowledge bases can be public or
	// private. The query string must be one generated by the ServiceNow console. For
	// more information, see Specifying documents to index with a query
	// (https://docs.aws.amazon.com/kendra/latest/dg/servicenow-query.html).
	FilterQuery *string

	// List of regular expressions applied to knowledge articles. Items that don't
	// match the inclusion pattern are not indexed. The regex is applied to the field
	// specified in the PatternTargetField.
	IncludeAttachmentFilePatterns []string

	noSmithyDocumentSerde
}

// Provides configuration information for crawling service catalog items in the
// ServiceNow site
type ServiceNowServiceCatalogConfiguration struct {

	// The name of the ServiceNow field that is mapped to the index document contents
	// field in the Amazon Kendra index.
	//
	// This member is required.
	DocumentDataFieldName *string

	// Indicates whether Amazon Kendra should crawl attachments to the service catalog
	// items.
	CrawlAttachments bool

	// The name of the ServiceNow field that is mapped to the index document title
	// field.
	DocumentTitleFieldName *string

	// A list of regular expression patterns. Documents that match the patterns are
	// excluded from the index. Documents that don't match the patterns are included in
	// the index. If a document matches both an exclusion pattern and an inclusion
	// pattern, the document is not included in the index. The regex is applied to the
	// file name of the attachment.
	ExcludeAttachmentFilePatterns []string

	// Mapping between ServiceNow fields and Amazon Kendra index fields. You must
	// create the index field before you map the field.
	FieldMappings []DataSourceToIndexFieldMapping

	// A list of regular expression patterns. Documents that match the patterns are
	// included in the index. Documents that don't match the patterns are excluded from
	// the index. If a document matches both an exclusion pattern and an inclusion
	// pattern, the document is not included in the index. The regex is applied to the
	// file name of the attachment.
	IncludeAttachmentFilePatterns []string

	noSmithyDocumentSerde
}

// Provides configuration information for connecting to a Microsoft SharePoint data
// source.
type SharePointConfiguration struct {

	// The Amazon Resource Name (ARN) of credentials stored in Secrets Manager. The
	// credentials should be a user/password pair. If you use SharePoint Server, you
	// also need to provide the sever domain name as part of the credentials. For more
	// information, see Using a Microsoft SharePoint Data Source
	// (https://docs.aws.amazon.com/kendra/latest/dg/data-source-sharepoint.html). For
	// more information about Secrets Manager see  What Is Secrets Manager
	// (https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html) in the
	// Secrets Manager user guide.
	//
	// This member is required.
	SecretArn *string

	// The version of Microsoft SharePoint that you are using as a data source.
	//
	// This member is required.
	SharePointVersion SharePointVersion

	// The URLs of the Microsoft SharePoint site that contains the documents that
	// should be indexed.
	//
	// This member is required.
	Urls []string

	// TRUE to include attachments to documents stored in your Microsoft SharePoint
	// site in the index; otherwise, FALSE.
	CrawlAttachments bool

	// A Boolean value that specifies whether local groups are disabled (True) or
	// enabled (False).
	DisableLocalGroups bool

	// The Microsoft SharePoint attribute field that contains the title of the
	// document.
	DocumentTitleFieldName *string

	// A list of regular expression patterns. Documents that match the patterns are
	// excluded from the index. Documents that don't match the patterns are included in
	// the index. If a document matches both an exclusion pattern and an inclusion
	// pattern, the document is not included in the index. The regex is applied to the
	// display URL of the SharePoint document.
	ExclusionPatterns []string

	// A list of DataSourceToIndexFieldMapping objects that map Microsoft SharePoint
	// attributes to custom fields in the Amazon Kendra index. You must first create
	// the index fields using the UpdateIndex operation before you map SharePoint
	// attributes. For more information, see Mapping Data Source Fields
	// (https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html).
	FieldMappings []DataSourceToIndexFieldMapping

	// A list of regular expression patterns. Documents that match the patterns are
	// included in the index. Documents that don't match the patterns are excluded from
	// the index. If a document matches both an inclusion pattern and an exclusion
	// pattern, the document is not included in the index. The regex is applied to the
	// display URL of the SharePoint document.
	InclusionPatterns []string

	// Information required to find a specific file in an Amazon S3 bucket.
	SslCertificateS3Path *S3Path

	// Set to TRUE to use the Microsoft SharePoint change log to determine the
	// documents that need to be updated in the index. Depending on the size of the
	// SharePoint change log, it may take longer for Amazon Kendra to use the change
	// log than it takes it to determine the changed documents using the Amazon Kendra
	// document crawler.
	UseChangeLog bool

	// Provides information for connecting to an Amazon VPC.
	VpcConfiguration *DataSourceVpcConfiguration

	noSmithyDocumentSerde
}

// Provides the configuration information of the sitemap URLs to crawl. When
// selecting websites to index, you must adhere to the Amazon Acceptable Use Policy
// (https://aws.amazon.com/aup/) and all other Amazon terms. Remember that you must
// only use Amazon Kendra Web Crawler to index your own webpages, or webpages that
// you have authorization to index.
type SiteMapsConfiguration struct {

	// The list of sitemap URLs of the websites you want to crawl. The list can include
	// a maximum of three sitemap URLs.
	//
	// This member is required.
	SiteMaps []string

	noSmithyDocumentSerde
}

// Specifies the document attribute to use to sort the response to a Amazon Kendra
// query. You can specify a single attribute for sorting. The attribute must have
// the Sortable flag set to true, otherwise Amazon Kendra returns an exception. You
// can sort attributes of the following types.
//
// * Date value
//
// * Long value
//
// *
// String value
//
// You can't sort attributes of the following type.
//
// * String list
// value
type SortingConfiguration struct {

	// The name of the document attribute used to sort the response. You can use any
	// field that has the Sortable flag set to true. You can also sort by any of the
	// following built-in attributes:
	//
	// * _category
	//
	// * _created_at
	//
	// *
	// _last_updated_at
	//
	// * _version
	//
	// * _view_count
	//
	// This member is required.
	DocumentAttributeKey *string

	// The order that the results should be returned in. In case of ties, the relevance
	// assigned to the result by Amazon Kendra is used as the tie-breaker.
	//
	// This member is required.
	SortOrder SortOrder

	noSmithyDocumentSerde
}

// Provides information that configures Amazon Kendra to use a SQL database.
type SqlConfiguration struct {

	// Determines whether Amazon Kendra encloses SQL identifiers for tables and column
	// names in double quotes (") when making a database query. By default, Amazon
	// Kendra passes SQL identifiers the way that they are entered into the data source
	// configuration. It does not change the case of identifiers or enclose them in
	// quotes. PostgreSQL internally converts uppercase characters to lower case
	// characters in identifiers unless they are quoted. Choosing this option encloses
	// identifiers in quotes so that PostgreSQL does not convert the character's case.
	// For MySQL databases, you must enable the ansi_quotes option when you set this
	// field to DOUBLE_QUOTES.
	QueryIdentifiersEnclosingOption QueryIdentifiersEnclosingOption

	noSmithyDocumentSerde
}

// Provides information about the status of documents submitted for indexing.
type Status struct {

	// The unique identifier of the document.
	DocumentId *string

	// The current status of a document. If the document was submitted for deletion,
	// the status is NOT_FOUND after the document is deleted.
	DocumentStatus DocumentStatus

	// Indicates the source of the error.
	FailureCode *string

	// Provides detailed information about why the document couldn't be indexed. Use
	// this information to correct the error before you resubmit the document for
	// indexing.
	FailureReason *string

	noSmithyDocumentSerde
}

// A single query suggestion.
type Suggestion struct {

	// The unique UUID (universally unique identifier) of a single query suggestion.
	Id *string

	// The value for the unique UUID (universally unique identifier) of a single query
	// suggestion. The value is the text string of a suggestion.
	Value *SuggestionValue

	noSmithyDocumentSerde
}

// The text highlights for a single query suggestion.
type SuggestionHighlight struct {

	// The zero-based location in the response string where the highlight starts.
	BeginOffset *int32

	// The zero-based location in the response string where the highlight ends.
	EndOffset *int32

	noSmithyDocumentSerde
}

// Provides text and information about where to highlight the query suggestion
// text.
type SuggestionTextWithHighlights struct {

	// The beginning and end of the query suggestion text that should be highlighted.
	Highlights []SuggestionHighlight

	// The query suggestion text to display to the user.
	Text *string

	noSmithyDocumentSerde
}

// The SuggestionTextWithHighlights structure information.
type SuggestionValue struct {

	// The SuggestionTextWithHighlights structure that contains the query suggestion
	// text and highlights.
	Text *SuggestionTextWithHighlights

	noSmithyDocumentSerde
}

// A list of key/value pairs that identify an index, FAQ, or data source. Tag keys
// and values can consist of Unicode letters, digits, white space, and any of the
// following symbols: _ . : / = + - @.
type Tag struct {

	// The key for the tag. Keys are not case sensitive and must be unique for the
	// index, FAQ, or data source.
	//
	// This member is required.
	Key *string

	// The value associated with the tag. The value may be an empty string but it can't
	// be null.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Provides information about text documents indexed in an index.
type TextDocumentStatistics struct {

	// The total size, in bytes, of the indexed documents.
	//
	// This member is required.
	IndexedTextBytes int64

	// The number of text documents indexed.
	//
	// This member is required.
	IndexedTextDocumentsCount int32

	noSmithyDocumentSerde
}

// Provides text and information about where to highlight the text.
type TextWithHighlights struct {

	// The beginning and end of the text that should be highlighted.
	Highlights []Highlight

	// The text to display to the user.
	Text *string

	noSmithyDocumentSerde
}

// An array of summary information for a thesaurus or multiple thesauri.
type ThesaurusSummary struct {

	// The Unix datetime that the thesaurus was created.
	CreatedAt *time.Time

	// The identifier of the thesaurus.
	Id *string

	// The name of the thesaurus.
	Name *string

	// The status of the thesaurus.
	Status ThesaurusStatus

	// The Unix datetime that the thesaurus was last updated.
	UpdatedAt *time.Time

	noSmithyDocumentSerde
}

// Provides a range of time.
type TimeRange struct {

	// The UNIX datetime of the end of the time range.
	EndTime *time.Time

	// The UNIX datetime of the beginning of the time range.
	StartTime *time.Time

	noSmithyDocumentSerde
}

// Provides the configuration information of the URLs to crawl. You can only crawl
// websites that use the secure communication protocol, Hypertext Transfer Protocol
// Secure (HTTPS). If you receive an error when crawling a website, it could be
// that the website is blocked from crawling. When selecting websites to index, you
// must adhere to the Amazon Acceptable Use Policy (https://aws.amazon.com/aup/)
// and all other Amazon terms. Remember that you must only use Amazon Kendra Web
// Crawler to index your own webpages, or webpages that you have authorization to
// index.
type Urls struct {

	// Provides the configuration of the seed or starting point URLs of the websites
	// you want to crawl. You can choose to crawl only the website host names, or the
	// website host names with subdomains, or the website host names with subdomains
	// and other domains that the webpages link to. You can list up to 100 seed URLs.
	SeedUrlConfiguration *SeedUrlConfiguration

	// Provides the configuration of the sitemap URLs of the websites you want to
	// crawl. Only URLs belonging to the same website host names are crawled. You can
	// list up to three sitemap URLs.
	SiteMapsConfiguration *SiteMapsConfiguration

	noSmithyDocumentSerde
}

// Provides information about the user context for an Amazon Kendra index. This is
// used for filtering search results for different users based on their access to
// documents. You provide one of the following:
//
// * User token
//
// * User ID, the
// groups the user belongs to, and any data sources the groups can access.
//
// If you
// provide both, an exception is thrown.
type UserContext struct {

	// The list of data source groups you want to filter search results based on
	// groups' access to documents in that data source.
	DataSourceGroups []DataSourceGroup

	// The list of groups you want to filter search results based on the groups' access
	// to documents.
	Groups []string

	// The user context token for filtering search results for a user. It must be a JWT
	// or a JSON token.
	Token *string

	// The identifier of the user you want to filter search results based on their
	// access to documents.
	UserId *string

	noSmithyDocumentSerde
}

// Provides the configuration information to fetch access levels of groups and
// users from an Amazon Web Services Single Sign On identity source. This is useful
// for setting up user context filtering, where Amazon Kendra filters search
// results for different users based on their group's access to documents. You can
// also map your users to their groups for user context filtering using the
// PutPrincipalMapping operation
// (https://docs.aws.amazon.com/kendra/latest/dg/API_PutPrincipalMapping.html). To
// set up an Amazon Web Services SSO identity source in the console to use with
// Amazon Kendra, see Getting started with an Amazon Web Services SSO identity
// source
// (https://docs.aws.amazon.com/kendra/latest/dg/getting-started-aws-sso.html). You
// must also grant the required permissions to use Amazon Web Services SSO with
// Amazon Kendra. For more information, see IAM roles for Amazon Web Services SSO
// (https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html#iam-roles-aws-sso).
// Amazon Kendra currently does not support using UserGroupResolutionConfiguration
// with an Amazon Web Services organization member account for your Amazon Web
// Services SSO identify source. You must create your index in the parent account
// for the organization in order to use UserGroupResolutionConfiguration.
type UserGroupResolutionConfiguration struct {

	// The identity store provider (mode) you want to use to fetch access levels of
	// groups and users. Amazon Web Services Single Sign On is currently the only
	// available mode. Your users and groups must exist in an Amazon Web Services SSO
	// identity source in order to use this mode.
	//
	// This member is required.
	UserGroupResolutionMode UserGroupResolutionMode

	noSmithyDocumentSerde
}

// Configuration information for the identifiers of your users.
type UserIdentityConfiguration struct {

	// The Amazon Web Services SSO field name that contains the identifiers of your
	// users, such as their emails. This is used for user context filtering
	// (https://docs.aws.amazon.com/kendra/latest/dg/user-context-filter.html) and for
	// granting access to your Amazon Kendra experience. You must set up Amazon Web
	// Services SSO with Amazon Kendra. You must include your users and groups in your
	// Access Control List when you ingest documents into your index. For more
	// information, see Getting started with an Amazon Web Services SSO identity source
	// (https://docs.aws.amazon.com/kendra/latest/dg/getting-started-aws-sso.html).
	IdentityAttributeName *string

	noSmithyDocumentSerde
}

// Provides configuration information for a token configuration.
type UserTokenConfiguration struct {

	// Information about the JSON token type configuration.
	JsonTokenTypeConfiguration *JsonTokenTypeConfiguration

	// Information about the JWT token type configuration.
	JwtTokenTypeConfiguration *JwtTokenTypeConfiguration

	noSmithyDocumentSerde
}

// The warning code and message that explains a problem with a query.
type Warning struct {

	// The code used to show the type of warning for the query.
	Code WarningCode

	// The message that explains the problem with the query.
	Message *string

	noSmithyDocumentSerde
}

// Provides the configuration information required for Amazon Kendra Web Crawler.
type WebCrawlerConfiguration struct {

	// Specifies the seed or starting point URLs of the websites or the sitemap URLs of
	// the websites you want to crawl. You can include website subdomains. You can list
	// up to 100 seed URLs and up to three sitemap URLs. You can only crawl websites
	// that use the secure communication protocol, Hypertext Transfer Protocol Secure
	// (HTTPS). If you receive an error when crawling a website, it could be that the
	// website is blocked from crawling. When selecting websites to index, you must
	// adhere to the Amazon Acceptable Use Policy (https://aws.amazon.com/aup/) and all
	// other Amazon terms. Remember that you must only use Amazon Kendra Web Crawler to
	// index your own webpages, or webpages that you have authorization to index.
	//
	// This member is required.
	Urls *Urls

	// Provides configuration information required to connect to websites using
	// authentication. You can connect to websites using basic authentication of user
	// name and password. You must provide the website host name and port number. For
	// example, the host name of https://a.example.com/page1.html is "a.example.com"
	// and the port is 443, the standard port for HTTPS. You use a secret in Secrets
	// Manager (https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html)
	// to store your authentication credentials.
	AuthenticationConfiguration *AuthenticationConfiguration

	// Specifies the number of levels in a website that you want to crawl. The first
	// level begins from the website seed or starting point URL. For example, if a
	// website has 3 levels – index level (i.e. seed in this example), sections level,
	// and subsections level – and you are only interested in crawling information up
	// to the sections level (i.e. levels 0-1), you can set your depth to 1. The
	// default crawl depth is set to 2.
	CrawlDepth *int32

	// The maximum size (in MB) of a webpage or attachment to crawl. Files larger than
	// this size (in MB) are skipped/not crawled. The default maximum size of a webpage
	// or attachment is set to 50 MB.
	MaxContentSizePerPageInMegaBytes *float32

	// The maximum number of URLs on a webpage to include when crawling a website. This
	// number is per webpage. As a website’s webpages are crawled, any URLs the
	// webpages link to are also crawled. URLs on a webpage are crawled in order of
	// appearance. The default maximum links per page is 100.
	MaxLinksPerPage *int32

	// The maximum number of URLs crawled per website host per minute. A minimum of one
	// URL is required. The default maximum number of URLs crawled per website host per
	// minute is 300.
	MaxUrlsPerMinuteCrawlRate *int32

	// Provides configuration information required to connect to your internal websites
	// via a web proxy. You must provide the website host name and port number. For
	// example, the host name of https://a.example.com/page1.html is "a.example.com"
	// and the port is 443, the standard port for HTTPS. Web proxy credentials are
	// optional and you can use them to connect to a web proxy server that requires
	// basic authentication. To store web proxy credentials, you use a secret in
	// Secrets Manager
	// (https://docs.aws.amazon.com/secretsmanager/latest/userguide/intro.html).
	ProxyConfiguration *ProxyConfiguration

	// The regular expression pattern to exclude certain URLs to crawl. If there is a
	// regular expression pattern to include certain URLs that conflicts with the
	// exclude pattern, the exclude pattern takes precedence.
	UrlExclusionPatterns []string

	// The regular expression pattern to include certain URLs to crawl. If there is a
	// regular expression pattern to exclude certain URLs that conflicts with the
	// include pattern, the exclude pattern takes precedence.
	UrlInclusionPatterns []string

	noSmithyDocumentSerde
}

// Provides the configuration information to connect to Amazon WorkDocs as your
// data source. Amazon WorkDocs connector is available in Oregon, North Virginia,
// Sydney, Singapore and Ireland regions.
type WorkDocsConfiguration struct {

	// The identifier of the directory corresponding to your Amazon WorkDocs site
	// repository. You can find the organization ID in the Directory Service
	// (https://console.aws.amazon.com/directoryservicev2/) by going to Active
	// Directory, then Directories. Your Amazon WorkDocs site directory has an ID,
	// which is the organization ID. You can also set up a new Amazon WorkDocs
	// directory in the Directory Service console and enable a Amazon WorkDocs site for
	// the directory in the Amazon WorkDocs console.
	//
	// This member is required.
	OrganizationId *string

	// TRUE to include comments on documents in your index. Including comments in your
	// index means each comment is a document that can be searched on. The default is
	// set to FALSE.
	CrawlComments bool

	// A list of regular expression patterns to exclude certain files in your Amazon
	// WorkDocs site repository. Files that match the patterns are excluded from the
	// index. Files that don’t match the patterns are included in the index. If a file
	// matches both an inclusion pattern and an exclusion pattern, the exclusion
	// pattern takes precedence and the file isn’t included in the index.
	ExclusionPatterns []string

	// A list of DataSourceToIndexFieldMapping objects that map Amazon WorkDocs field
	// names to custom index field names in Amazon Kendra. You must first create the
	// custom index fields using the UpdateIndex operation before you map to Amazon
	// WorkDocs fields. For more information, see Mapping Data Source Fields
	// (https://docs.aws.amazon.com/kendra/latest/dg/field-mapping.html). The Amazon
	// WorkDocs data source field names need to exist in your Amazon WorkDocs custom
	// metadata.
	FieldMappings []DataSourceToIndexFieldMapping

	// A list of regular expression patterns to include certain files in your Amazon
	// WorkDocs site repository. Files that match the patterns are included in the
	// index. Files that don't match the patterns are excluded from the index. If a
	// file matches both an inclusion pattern and an exclusion pattern, the exclusion
	// pattern takes precedence and the file isn’t included in the index.
	InclusionPatterns []string

	// TRUE to use the change logs to update documents in your index instead of
	// scanning all documents. If you are syncing your Amazon WorkDocs data source with
	// your index for the first time, all documents are scanned. After your first sync,
	// you can use the change logs to update your documents in your index for future
	// syncs. The default is set to FALSE.
	UseChangeLog bool

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
