// Code generated by smithy-go-codegen DO NOT EDIT.

package kafka

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/kafka/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

type awsRestjson1_serializeOpBatchAssociateScramSecret struct {
}

func (*awsRestjson1_serializeOpBatchAssociateScramSecret) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchAssociateScramSecret) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchAssociateScramSecretInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/clusters/{ClusterArn}/scram-secrets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchAssociateScramSecretInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchAssociateScramSecretInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchAssociateScramSecretInput(v *BatchAssociateScramSecretInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClusterArn == nil || len(*v.ClusterArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ClusterArn must not be empty")}
	}
	if v.ClusterArn != nil {
		if err := encoder.SetURI("ClusterArn").String(*v.ClusterArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchAssociateScramSecretInput(v *BatchAssociateScramSecretInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SecretArnList != nil {
		ok := object.Key("secretArnList")
		if err := awsRestjson1_serializeDocument__listOf__string(v.SecretArnList, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpBatchDisassociateScramSecret struct {
}

func (*awsRestjson1_serializeOpBatchDisassociateScramSecret) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpBatchDisassociateScramSecret) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*BatchDisassociateScramSecretInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/clusters/{ClusterArn}/scram-secrets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsBatchDisassociateScramSecretInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentBatchDisassociateScramSecretInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsBatchDisassociateScramSecretInput(v *BatchDisassociateScramSecretInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClusterArn == nil || len(*v.ClusterArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ClusterArn must not be empty")}
	}
	if v.ClusterArn != nil {
		if err := encoder.SetURI("ClusterArn").String(*v.ClusterArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentBatchDisassociateScramSecretInput(v *BatchDisassociateScramSecretInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SecretArnList != nil {
		ok := object.Key("secretArnList")
		if err := awsRestjson1_serializeDocument__listOf__string(v.SecretArnList, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateCluster struct {
}

func (*awsRestjson1_serializeOpCreateCluster) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateCluster) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateClusterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/clusters")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateClusterInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateClusterInput(v *CreateClusterInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateClusterInput(v *CreateClusterInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BrokerNodeGroupInfo != nil {
		ok := object.Key("brokerNodeGroupInfo")
		if err := awsRestjson1_serializeDocumentBrokerNodeGroupInfo(v.BrokerNodeGroupInfo, ok); err != nil {
			return err
		}
	}

	if v.ClientAuthentication != nil {
		ok := object.Key("clientAuthentication")
		if err := awsRestjson1_serializeDocumentClientAuthentication(v.ClientAuthentication, ok); err != nil {
			return err
		}
	}

	if v.ClusterName != nil {
		ok := object.Key("clusterName")
		ok.String(*v.ClusterName)
	}

	if v.ConfigurationInfo != nil {
		ok := object.Key("configurationInfo")
		if err := awsRestjson1_serializeDocumentConfigurationInfo(v.ConfigurationInfo, ok); err != nil {
			return err
		}
	}

	if v.EncryptionInfo != nil {
		ok := object.Key("encryptionInfo")
		if err := awsRestjson1_serializeDocumentEncryptionInfo(v.EncryptionInfo, ok); err != nil {
			return err
		}
	}

	if len(v.EnhancedMonitoring) > 0 {
		ok := object.Key("enhancedMonitoring")
		ok.String(string(v.EnhancedMonitoring))
	}

	if v.KafkaVersion != nil {
		ok := object.Key("kafkaVersion")
		ok.String(*v.KafkaVersion)
	}

	if v.LoggingInfo != nil {
		ok := object.Key("loggingInfo")
		if err := awsRestjson1_serializeDocumentLoggingInfo(v.LoggingInfo, ok); err != nil {
			return err
		}
	}

	{
		ok := object.Key("numberOfBrokerNodes")
		ok.Integer(v.NumberOfBrokerNodes)
	}

	if v.OpenMonitoring != nil {
		ok := object.Key("openMonitoring")
		if err := awsRestjson1_serializeDocumentOpenMonitoringInfo(v.OpenMonitoring, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocument__mapOf__string(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateClusterV2 struct {
}

func (*awsRestjson1_serializeOpCreateClusterV2) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateClusterV2) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateClusterV2Input)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/api/v2/clusters")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateClusterV2Input(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateClusterV2Input(v *CreateClusterV2Input, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateClusterV2Input(v *CreateClusterV2Input, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClusterName != nil {
		ok := object.Key("clusterName")
		ok.String(*v.ClusterName)
	}

	if v.Provisioned != nil {
		ok := object.Key("provisioned")
		if err := awsRestjson1_serializeDocumentProvisionedRequest(v.Provisioned, ok); err != nil {
			return err
		}
	}

	if v.Serverless != nil {
		ok := object.Key("serverless")
		if err := awsRestjson1_serializeDocumentServerlessRequest(v.Serverless, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocument__mapOf__string(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpCreateConfiguration struct {
}

func (*awsRestjson1_serializeOpCreateConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpCreateConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/configurations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentCreateConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsCreateConfigurationInput(v *CreateConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	return nil
}

func awsRestjson1_serializeOpDocumentCreateConfigurationInput(v *CreateConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.KafkaVersions != nil {
		ok := object.Key("kafkaVersions")
		if err := awsRestjson1_serializeDocument__listOf__string(v.KafkaVersions, ok); err != nil {
			return err
		}
	}

	if v.Name != nil {
		ok := object.Key("name")
		ok.String(*v.Name)
	}

	if v.ServerProperties != nil {
		ok := object.Key("serverProperties")
		ok.Base64EncodeBytes(v.ServerProperties)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteCluster struct {
}

func (*awsRestjson1_serializeOpDeleteCluster) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteCluster) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteClusterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/clusters/{ClusterArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteClusterInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteClusterInput(v *DeleteClusterInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClusterArn == nil || len(*v.ClusterArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ClusterArn must not be empty")}
	}
	if v.ClusterArn != nil {
		if err := encoder.SetURI("ClusterArn").String(*v.ClusterArn); err != nil {
			return err
		}
	}

	if v.CurrentVersion != nil {
		encoder.SetQuery("currentVersion").String(*v.CurrentVersion)
	}

	return nil
}

type awsRestjson1_serializeOpDeleteConfiguration struct {
}

func (*awsRestjson1_serializeOpDeleteConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDeleteConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/configurations/{Arn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDeleteConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDeleteConfigurationInput(v *DeleteConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("Arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeCluster struct {
}

func (*awsRestjson1_serializeOpDescribeCluster) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeCluster) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeClusterInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/clusters/{ClusterArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeClusterInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeClusterInput(v *DescribeClusterInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClusterArn == nil || len(*v.ClusterArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ClusterArn must not be empty")}
	}
	if v.ClusterArn != nil {
		if err := encoder.SetURI("ClusterArn").String(*v.ClusterArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeClusterOperation struct {
}

func (*awsRestjson1_serializeOpDescribeClusterOperation) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeClusterOperation) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeClusterOperationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/operations/{ClusterOperationArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeClusterOperationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeClusterOperationInput(v *DescribeClusterOperationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClusterOperationArn == nil || len(*v.ClusterOperationArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ClusterOperationArn must not be empty")}
	}
	if v.ClusterOperationArn != nil {
		if err := encoder.SetURI("ClusterOperationArn").String(*v.ClusterOperationArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeClusterV2 struct {
}

func (*awsRestjson1_serializeOpDescribeClusterV2) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeClusterV2) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeClusterV2Input)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/api/v2/clusters/{ClusterArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeClusterV2Input(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeClusterV2Input(v *DescribeClusterV2Input, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClusterArn == nil || len(*v.ClusterArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ClusterArn must not be empty")}
	}
	if v.ClusterArn != nil {
		if err := encoder.SetURI("ClusterArn").String(*v.ClusterArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeConfiguration struct {
}

func (*awsRestjson1_serializeOpDescribeConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/configurations/{Arn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeConfigurationInput(v *DescribeConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("Arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpDescribeConfigurationRevision struct {
}

func (*awsRestjson1_serializeOpDescribeConfigurationRevision) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpDescribeConfigurationRevision) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeConfigurationRevisionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/configurations/{Arn}/revisions/{Revision}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsDescribeConfigurationRevisionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsDescribeConfigurationRevisionInput(v *DescribeConfigurationRevisionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("Arn").String(*v.Arn); err != nil {
			return err
		}
	}

	{
		if err := encoder.SetURI("Revision").Long(v.Revision); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetBootstrapBrokers struct {
}

func (*awsRestjson1_serializeOpGetBootstrapBrokers) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetBootstrapBrokers) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetBootstrapBrokersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/clusters/{ClusterArn}/bootstrap-brokers")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetBootstrapBrokersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetBootstrapBrokersInput(v *GetBootstrapBrokersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClusterArn == nil || len(*v.ClusterArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ClusterArn must not be empty")}
	}
	if v.ClusterArn != nil {
		if err := encoder.SetURI("ClusterArn").String(*v.ClusterArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpGetCompatibleKafkaVersions struct {
}

func (*awsRestjson1_serializeOpGetCompatibleKafkaVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpGetCompatibleKafkaVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*GetCompatibleKafkaVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/compatible-kafka-versions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsGetCompatibleKafkaVersionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsGetCompatibleKafkaVersionsInput(v *GetCompatibleKafkaVersionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClusterArn != nil {
		encoder.SetQuery("clusterArn").String(*v.ClusterArn)
	}

	return nil
}

type awsRestjson1_serializeOpListClusterOperations struct {
}

func (*awsRestjson1_serializeOpListClusterOperations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListClusterOperations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListClusterOperationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/clusters/{ClusterArn}/operations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListClusterOperationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListClusterOperationsInput(v *ListClusterOperationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClusterArn == nil || len(*v.ClusterArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ClusterArn must not be empty")}
	}
	if v.ClusterArn != nil {
		if err := encoder.SetURI("ClusterArn").String(*v.ClusterArn); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListClusters struct {
}

func (*awsRestjson1_serializeOpListClusters) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListClusters) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListClustersInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/clusters")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListClustersInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListClustersInput(v *ListClustersInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClusterNameFilter != nil {
		encoder.SetQuery("clusterNameFilter").String(*v.ClusterNameFilter)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListClustersV2 struct {
}

func (*awsRestjson1_serializeOpListClustersV2) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListClustersV2) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListClustersV2Input)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/api/v2/clusters")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListClustersV2Input(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListClustersV2Input(v *ListClustersV2Input, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClusterNameFilter != nil {
		encoder.SetQuery("clusterNameFilter").String(*v.ClusterNameFilter)
	}

	if v.ClusterTypeFilter != nil {
		encoder.SetQuery("clusterTypeFilter").String(*v.ClusterTypeFilter)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListConfigurationRevisions struct {
}

func (*awsRestjson1_serializeOpListConfigurationRevisions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListConfigurationRevisions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListConfigurationRevisionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/configurations/{Arn}/revisions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListConfigurationRevisionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListConfigurationRevisionsInput(v *ListConfigurationRevisionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("Arn").String(*v.Arn); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListConfigurations struct {
}

func (*awsRestjson1_serializeOpListConfigurations) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListConfigurations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListConfigurationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/configurations")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListConfigurationsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListConfigurationsInput(v *ListConfigurationsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListKafkaVersions struct {
}

func (*awsRestjson1_serializeOpListKafkaVersions) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListKafkaVersions) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListKafkaVersionsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/kafka-versions")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListKafkaVersionsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListKafkaVersionsInput(v *ListKafkaVersionsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListNodes struct {
}

func (*awsRestjson1_serializeOpListNodes) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListNodes) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListNodesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/clusters/{ClusterArn}/nodes")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListNodesInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListNodesInput(v *ListNodesInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClusterArn == nil || len(*v.ClusterArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ClusterArn must not be empty")}
	}
	if v.ClusterArn != nil {
		if err := encoder.SetURI("ClusterArn").String(*v.ClusterArn); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListScramSecrets struct {
}

func (*awsRestjson1_serializeOpListScramSecrets) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListScramSecrets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListScramSecretsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/clusters/{ClusterArn}/scram-secrets")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListScramSecretsInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListScramSecretsInput(v *ListScramSecretsInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClusterArn == nil || len(*v.ClusterArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ClusterArn must not be empty")}
	}
	if v.ClusterArn != nil {
		if err := encoder.SetURI("ClusterArn").String(*v.ClusterArn); err != nil {
			return err
		}
	}

	if v.MaxResults != 0 {
		encoder.SetQuery("maxResults").Integer(v.MaxResults)
	}

	if v.NextToken != nil {
		encoder.SetQuery("nextToken").String(*v.NextToken)
	}

	return nil
}

type awsRestjson1_serializeOpListTagsForResource struct {
}

func (*awsRestjson1_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "GET"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsListTagsForResourceInput(v *ListTagsForResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpRebootBroker struct {
}

func (*awsRestjson1_serializeOpRebootBroker) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpRebootBroker) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*RebootBrokerInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/clusters/{ClusterArn}/reboot-broker")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsRebootBrokerInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentRebootBrokerInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsRebootBrokerInput(v *RebootBrokerInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClusterArn == nil || len(*v.ClusterArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ClusterArn must not be empty")}
	}
	if v.ClusterArn != nil {
		if err := encoder.SetURI("ClusterArn").String(*v.ClusterArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentRebootBrokerInput(v *RebootBrokerInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BrokerIds != nil {
		ok := object.Key("brokerIds")
		if err := awsRestjson1_serializeDocument__listOf__string(v.BrokerIds, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpTagResource struct {
}

func (*awsRestjson1_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "POST"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsTagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsTagResourceInput(v *TagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Tags != nil {
		ok := object.Key("tags")
		if err := awsRestjson1_serializeDocument__mapOf__string(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUntagResource struct {
}

func (*awsRestjson1_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/tags/{ResourceArn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "DELETE"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUntagResourceInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUntagResourceInput(v *UntagResourceInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ResourceArn == nil || len(*v.ResourceArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ResourceArn must not be empty")}
	}
	if v.ResourceArn != nil {
		if err := encoder.SetURI("ResourceArn").String(*v.ResourceArn); err != nil {
			return err
		}
	}

	if v.TagKeys != nil {
		for i := range v.TagKeys {
			encoder.AddQuery("tagKeys").String(v.TagKeys[i])
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateBrokerCount struct {
}

func (*awsRestjson1_serializeOpUpdateBrokerCount) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateBrokerCount) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateBrokerCountInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/clusters/{ClusterArn}/nodes/count")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateBrokerCountInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateBrokerCountInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateBrokerCountInput(v *UpdateBrokerCountInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClusterArn == nil || len(*v.ClusterArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ClusterArn must not be empty")}
	}
	if v.ClusterArn != nil {
		if err := encoder.SetURI("ClusterArn").String(*v.ClusterArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateBrokerCountInput(v *UpdateBrokerCountInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CurrentVersion != nil {
		ok := object.Key("currentVersion")
		ok.String(*v.CurrentVersion)
	}

	{
		ok := object.Key("targetNumberOfBrokerNodes")
		ok.Integer(v.TargetNumberOfBrokerNodes)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateBrokerStorage struct {
}

func (*awsRestjson1_serializeOpUpdateBrokerStorage) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateBrokerStorage) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateBrokerStorageInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/clusters/{ClusterArn}/nodes/storage")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateBrokerStorageInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateBrokerStorageInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateBrokerStorageInput(v *UpdateBrokerStorageInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClusterArn == nil || len(*v.ClusterArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ClusterArn must not be empty")}
	}
	if v.ClusterArn != nil {
		if err := encoder.SetURI("ClusterArn").String(*v.ClusterArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateBrokerStorageInput(v *UpdateBrokerStorageInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CurrentVersion != nil {
		ok := object.Key("currentVersion")
		ok.String(*v.CurrentVersion)
	}

	if v.TargetBrokerEBSVolumeInfo != nil {
		ok := object.Key("targetBrokerEBSVolumeInfo")
		if err := awsRestjson1_serializeDocument__listOfBrokerEBSVolumeInfo(v.TargetBrokerEBSVolumeInfo, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateBrokerType struct {
}

func (*awsRestjson1_serializeOpUpdateBrokerType) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateBrokerType) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateBrokerTypeInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/clusters/{ClusterArn}/nodes/type")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateBrokerTypeInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateBrokerTypeInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateBrokerTypeInput(v *UpdateBrokerTypeInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClusterArn == nil || len(*v.ClusterArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ClusterArn must not be empty")}
	}
	if v.ClusterArn != nil {
		if err := encoder.SetURI("ClusterArn").String(*v.ClusterArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateBrokerTypeInput(v *UpdateBrokerTypeInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CurrentVersion != nil {
		ok := object.Key("currentVersion")
		ok.String(*v.CurrentVersion)
	}

	if v.TargetInstanceType != nil {
		ok := object.Key("targetInstanceType")
		ok.String(*v.TargetInstanceType)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateClusterConfiguration struct {
}

func (*awsRestjson1_serializeOpUpdateClusterConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateClusterConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateClusterConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/clusters/{ClusterArn}/configuration")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateClusterConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateClusterConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateClusterConfigurationInput(v *UpdateClusterConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClusterArn == nil || len(*v.ClusterArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ClusterArn must not be empty")}
	}
	if v.ClusterArn != nil {
		if err := encoder.SetURI("ClusterArn").String(*v.ClusterArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateClusterConfigurationInput(v *UpdateClusterConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConfigurationInfo != nil {
		ok := object.Key("configurationInfo")
		if err := awsRestjson1_serializeDocumentConfigurationInfo(v.ConfigurationInfo, ok); err != nil {
			return err
		}
	}

	if v.CurrentVersion != nil {
		ok := object.Key("currentVersion")
		ok.String(*v.CurrentVersion)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateClusterKafkaVersion struct {
}

func (*awsRestjson1_serializeOpUpdateClusterKafkaVersion) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateClusterKafkaVersion) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateClusterKafkaVersionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/clusters/{ClusterArn}/version")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateClusterKafkaVersionInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateClusterKafkaVersionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateClusterKafkaVersionInput(v *UpdateClusterKafkaVersionInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClusterArn == nil || len(*v.ClusterArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ClusterArn must not be empty")}
	}
	if v.ClusterArn != nil {
		if err := encoder.SetURI("ClusterArn").String(*v.ClusterArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateClusterKafkaVersionInput(v *UpdateClusterKafkaVersionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConfigurationInfo != nil {
		ok := object.Key("configurationInfo")
		if err := awsRestjson1_serializeDocumentConfigurationInfo(v.ConfigurationInfo, ok); err != nil {
			return err
		}
	}

	if v.CurrentVersion != nil {
		ok := object.Key("currentVersion")
		ok.String(*v.CurrentVersion)
	}

	if v.TargetKafkaVersion != nil {
		ok := object.Key("targetKafkaVersion")
		ok.String(*v.TargetKafkaVersion)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateConfiguration struct {
}

func (*awsRestjson1_serializeOpUpdateConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/configurations/{Arn}")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateConfigurationInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateConfigurationInput(v *UpdateConfigurationInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.Arn == nil || len(*v.Arn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member Arn must not be empty")}
	}
	if v.Arn != nil {
		if err := encoder.SetURI("Arn").String(*v.Arn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateConfigurationInput(v *UpdateConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("description")
		ok.String(*v.Description)
	}

	if v.ServerProperties != nil {
		ok := object.Key("serverProperties")
		ok.Base64EncodeBytes(v.ServerProperties)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateConnectivity struct {
}

func (*awsRestjson1_serializeOpUpdateConnectivity) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateConnectivity) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateConnectivityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/clusters/{ClusterArn}/connectivity")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateConnectivityInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateConnectivityInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateConnectivityInput(v *UpdateConnectivityInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClusterArn == nil || len(*v.ClusterArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ClusterArn must not be empty")}
	}
	if v.ClusterArn != nil {
		if err := encoder.SetURI("ClusterArn").String(*v.ClusterArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateConnectivityInput(v *UpdateConnectivityInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ConnectivityInfo != nil {
		ok := object.Key("connectivityInfo")
		if err := awsRestjson1_serializeDocumentConnectivityInfo(v.ConnectivityInfo, ok); err != nil {
			return err
		}
	}

	if v.CurrentVersion != nil {
		ok := object.Key("currentVersion")
		ok.String(*v.CurrentVersion)
	}

	return nil
}

type awsRestjson1_serializeOpUpdateMonitoring struct {
}

func (*awsRestjson1_serializeOpUpdateMonitoring) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateMonitoring) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateMonitoringInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/clusters/{ClusterArn}/monitoring")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PUT"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateMonitoringInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateMonitoringInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateMonitoringInput(v *UpdateMonitoringInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClusterArn == nil || len(*v.ClusterArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ClusterArn must not be empty")}
	}
	if v.ClusterArn != nil {
		if err := encoder.SetURI("ClusterArn").String(*v.ClusterArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateMonitoringInput(v *UpdateMonitoringInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CurrentVersion != nil {
		ok := object.Key("currentVersion")
		ok.String(*v.CurrentVersion)
	}

	if len(v.EnhancedMonitoring) > 0 {
		ok := object.Key("enhancedMonitoring")
		ok.String(string(v.EnhancedMonitoring))
	}

	if v.LoggingInfo != nil {
		ok := object.Key("loggingInfo")
		if err := awsRestjson1_serializeDocumentLoggingInfo(v.LoggingInfo, ok); err != nil {
			return err
		}
	}

	if v.OpenMonitoring != nil {
		ok := object.Key("openMonitoring")
		if err := awsRestjson1_serializeDocumentOpenMonitoringInfo(v.OpenMonitoring, ok); err != nil {
			return err
		}
	}

	return nil
}

type awsRestjson1_serializeOpUpdateSecurity struct {
}

func (*awsRestjson1_serializeOpUpdateSecurity) ID() string {
	return "OperationSerializer"
}

func (m *awsRestjson1_serializeOpUpdateSecurity) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateSecurityInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	opPath, opQuery := httpbinding.SplitURI("/v1/clusters/{ClusterArn}/security")
	request.URL.Path = smithyhttp.JoinPath(request.URL.Path, opPath)
	request.URL.RawQuery = smithyhttp.JoinRawQuery(request.URL.RawQuery, opQuery)
	request.Method = "PATCH"
	restEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if err := awsRestjson1_serializeOpHttpBindingsUpdateSecurityInput(input, restEncoder); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	restEncoder.SetHeader("Content-Type").String("application/json")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsRestjson1_serializeOpDocumentUpdateSecurityInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = restEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsRestjson1_serializeOpHttpBindingsUpdateSecurityInput(v *UpdateSecurityInput, encoder *httpbinding.Encoder) error {
	if v == nil {
		return fmt.Errorf("unsupported serialization of nil %T", v)
	}

	if v.ClusterArn == nil || len(*v.ClusterArn) == 0 {
		return &smithy.SerializationError{Err: fmt.Errorf("input member ClusterArn must not be empty")}
	}
	if v.ClusterArn != nil {
		if err := encoder.SetURI("ClusterArn").String(*v.ClusterArn); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeOpDocumentUpdateSecurityInput(v *UpdateSecurityInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientAuthentication != nil {
		ok := object.Key("clientAuthentication")
		if err := awsRestjson1_serializeDocumentClientAuthentication(v.ClientAuthentication, ok); err != nil {
			return err
		}
	}

	if v.CurrentVersion != nil {
		ok := object.Key("currentVersion")
		ok.String(*v.CurrentVersion)
	}

	if v.EncryptionInfo != nil {
		ok := object.Key("encryptionInfo")
		if err := awsRestjson1_serializeDocumentEncryptionInfo(v.EncryptionInfo, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocument__listOf__string(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfBrokerEBSVolumeInfo(v []types.BrokerEBSVolumeInfo, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentBrokerEBSVolumeInfo(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__listOfVpcConfig(v []types.VpcConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsRestjson1_serializeDocumentVpcConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsRestjson1_serializeDocument__mapOf__string(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsRestjson1_serializeDocumentBrokerEBSVolumeInfo(v *types.BrokerEBSVolumeInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KafkaBrokerNodeId != nil {
		ok := object.Key("kafkaBrokerNodeId")
		ok.String(*v.KafkaBrokerNodeId)
	}

	{
		ok := object.Key("volumeSizeGB")
		ok.Integer(v.VolumeSizeGB)
	}

	return nil
}

func awsRestjson1_serializeDocumentBrokerLogs(v *types.BrokerLogs, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CloudWatchLogs != nil {
		ok := object.Key("cloudWatchLogs")
		if err := awsRestjson1_serializeDocumentCloudWatchLogs(v.CloudWatchLogs, ok); err != nil {
			return err
		}
	}

	if v.Firehose != nil {
		ok := object.Key("firehose")
		if err := awsRestjson1_serializeDocumentFirehose(v.Firehose, ok); err != nil {
			return err
		}
	}

	if v.S3 != nil {
		ok := object.Key("s3")
		if err := awsRestjson1_serializeDocumentS3(v.S3, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentBrokerNodeGroupInfo(v *types.BrokerNodeGroupInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.BrokerAZDistribution) > 0 {
		ok := object.Key("brokerAZDistribution")
		ok.String(string(v.BrokerAZDistribution))
	}

	if v.ClientSubnets != nil {
		ok := object.Key("clientSubnets")
		if err := awsRestjson1_serializeDocument__listOf__string(v.ClientSubnets, ok); err != nil {
			return err
		}
	}

	if v.ConnectivityInfo != nil {
		ok := object.Key("connectivityInfo")
		if err := awsRestjson1_serializeDocumentConnectivityInfo(v.ConnectivityInfo, ok); err != nil {
			return err
		}
	}

	if v.InstanceType != nil {
		ok := object.Key("instanceType")
		ok.String(*v.InstanceType)
	}

	if v.SecurityGroups != nil {
		ok := object.Key("securityGroups")
		if err := awsRestjson1_serializeDocument__listOf__string(v.SecurityGroups, ok); err != nil {
			return err
		}
	}

	if v.StorageInfo != nil {
		ok := object.Key("storageInfo")
		if err := awsRestjson1_serializeDocumentStorageInfo(v.StorageInfo, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentClientAuthentication(v *types.ClientAuthentication, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Sasl != nil {
		ok := object.Key("sasl")
		if err := awsRestjson1_serializeDocumentSasl(v.Sasl, ok); err != nil {
			return err
		}
	}

	if v.Tls != nil {
		ok := object.Key("tls")
		if err := awsRestjson1_serializeDocumentTls(v.Tls, ok); err != nil {
			return err
		}
	}

	if v.Unauthenticated != nil {
		ok := object.Key("unauthenticated")
		if err := awsRestjson1_serializeDocumentUnauthenticated(v.Unauthenticated, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentCloudWatchLogs(v *types.CloudWatchLogs, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("enabled")
		ok.Boolean(v.Enabled)
	}

	if v.LogGroup != nil {
		ok := object.Key("logGroup")
		ok.String(*v.LogGroup)
	}

	return nil
}

func awsRestjson1_serializeDocumentConfigurationInfo(v *types.ConfigurationInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Arn != nil {
		ok := object.Key("arn")
		ok.String(*v.Arn)
	}

	{
		ok := object.Key("revision")
		ok.Long(v.Revision)
	}

	return nil
}

func awsRestjson1_serializeDocumentConnectivityInfo(v *types.ConnectivityInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PublicAccess != nil {
		ok := object.Key("publicAccess")
		if err := awsRestjson1_serializeDocumentPublicAccess(v.PublicAccess, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEBSStorageInfo(v *types.EBSStorageInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.VolumeSize != 0 {
		ok := object.Key("volumeSize")
		ok.Integer(v.VolumeSize)
	}

	return nil
}

func awsRestjson1_serializeDocumentEncryptionAtRest(v *types.EncryptionAtRest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DataVolumeKMSKeyId != nil {
		ok := object.Key("dataVolumeKMSKeyId")
		ok.String(*v.DataVolumeKMSKeyId)
	}

	return nil
}

func awsRestjson1_serializeDocumentEncryptionInfo(v *types.EncryptionInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EncryptionAtRest != nil {
		ok := object.Key("encryptionAtRest")
		if err := awsRestjson1_serializeDocumentEncryptionAtRest(v.EncryptionAtRest, ok); err != nil {
			return err
		}
	}

	if v.EncryptionInTransit != nil {
		ok := object.Key("encryptionInTransit")
		if err := awsRestjson1_serializeDocumentEncryptionInTransit(v.EncryptionInTransit, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentEncryptionInTransit(v *types.EncryptionInTransit, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ClientBroker) > 0 {
		ok := object.Key("clientBroker")
		ok.String(string(v.ClientBroker))
	}

	if v.InCluster {
		ok := object.Key("inCluster")
		ok.Boolean(v.InCluster)
	}

	return nil
}

func awsRestjson1_serializeDocumentFirehose(v *types.Firehose, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeliveryStream != nil {
		ok := object.Key("deliveryStream")
		ok.String(*v.DeliveryStream)
	}

	{
		ok := object.Key("enabled")
		ok.Boolean(v.Enabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentIam(v *types.Iam, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled {
		ok := object.Key("enabled")
		ok.Boolean(v.Enabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentJmxExporterInfo(v *types.JmxExporterInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("enabledInBroker")
		ok.Boolean(v.EnabledInBroker)
	}

	return nil
}

func awsRestjson1_serializeDocumentLoggingInfo(v *types.LoggingInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BrokerLogs != nil {
		ok := object.Key("brokerLogs")
		if err := awsRestjson1_serializeDocumentBrokerLogs(v.BrokerLogs, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentNodeExporterInfo(v *types.NodeExporterInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("enabledInBroker")
		ok.Boolean(v.EnabledInBroker)
	}

	return nil
}

func awsRestjson1_serializeDocumentOpenMonitoringInfo(v *types.OpenMonitoringInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Prometheus != nil {
		ok := object.Key("prometheus")
		if err := awsRestjson1_serializeDocumentPrometheusInfo(v.Prometheus, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPrometheusInfo(v *types.PrometheusInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.JmxExporter != nil {
		ok := object.Key("jmxExporter")
		if err := awsRestjson1_serializeDocumentJmxExporterInfo(v.JmxExporter, ok); err != nil {
			return err
		}
	}

	if v.NodeExporter != nil {
		ok := object.Key("nodeExporter")
		if err := awsRestjson1_serializeDocumentNodeExporterInfo(v.NodeExporter, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentProvisionedRequest(v *types.ProvisionedRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.BrokerNodeGroupInfo != nil {
		ok := object.Key("brokerNodeGroupInfo")
		if err := awsRestjson1_serializeDocumentBrokerNodeGroupInfo(v.BrokerNodeGroupInfo, ok); err != nil {
			return err
		}
	}

	if v.ClientAuthentication != nil {
		ok := object.Key("clientAuthentication")
		if err := awsRestjson1_serializeDocumentClientAuthentication(v.ClientAuthentication, ok); err != nil {
			return err
		}
	}

	if v.ConfigurationInfo != nil {
		ok := object.Key("configurationInfo")
		if err := awsRestjson1_serializeDocumentConfigurationInfo(v.ConfigurationInfo, ok); err != nil {
			return err
		}
	}

	if v.EncryptionInfo != nil {
		ok := object.Key("encryptionInfo")
		if err := awsRestjson1_serializeDocumentEncryptionInfo(v.EncryptionInfo, ok); err != nil {
			return err
		}
	}

	if len(v.EnhancedMonitoring) > 0 {
		ok := object.Key("enhancedMonitoring")
		ok.String(string(v.EnhancedMonitoring))
	}

	if v.KafkaVersion != nil {
		ok := object.Key("kafkaVersion")
		ok.String(*v.KafkaVersion)
	}

	if v.LoggingInfo != nil {
		ok := object.Key("loggingInfo")
		if err := awsRestjson1_serializeDocumentLoggingInfo(v.LoggingInfo, ok); err != nil {
			return err
		}
	}

	{
		ok := object.Key("numberOfBrokerNodes")
		ok.Integer(v.NumberOfBrokerNodes)
	}

	if v.OpenMonitoring != nil {
		ok := object.Key("openMonitoring")
		if err := awsRestjson1_serializeDocumentOpenMonitoringInfo(v.OpenMonitoring, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentPublicAccess(v *types.PublicAccess, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Type != nil {
		ok := object.Key("type")
		ok.String(*v.Type)
	}

	return nil
}

func awsRestjson1_serializeDocumentS3(v *types.S3, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Bucket != nil {
		ok := object.Key("bucket")
		ok.String(*v.Bucket)
	}

	{
		ok := object.Key("enabled")
		ok.Boolean(v.Enabled)
	}

	if v.Prefix != nil {
		ok := object.Key("prefix")
		ok.String(*v.Prefix)
	}

	return nil
}

func awsRestjson1_serializeDocumentSasl(v *types.Sasl, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Iam != nil {
		ok := object.Key("iam")
		if err := awsRestjson1_serializeDocumentIam(v.Iam, ok); err != nil {
			return err
		}
	}

	if v.Scram != nil {
		ok := object.Key("scram")
		if err := awsRestjson1_serializeDocumentScram(v.Scram, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentScram(v *types.Scram, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled {
		ok := object.Key("enabled")
		ok.Boolean(v.Enabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentServerlessClientAuthentication(v *types.ServerlessClientAuthentication, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Sasl != nil {
		ok := object.Key("sasl")
		if err := awsRestjson1_serializeDocumentServerlessSasl(v.Sasl, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentServerlessRequest(v *types.ServerlessRequest, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ClientAuthentication != nil {
		ok := object.Key("clientAuthentication")
		if err := awsRestjson1_serializeDocumentServerlessClientAuthentication(v.ClientAuthentication, ok); err != nil {
			return err
		}
	}

	if v.VpcConfigs != nil {
		ok := object.Key("vpcConfigs")
		if err := awsRestjson1_serializeDocument__listOfVpcConfig(v.VpcConfigs, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentServerlessSasl(v *types.ServerlessSasl, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Iam != nil {
		ok := object.Key("iam")
		if err := awsRestjson1_serializeDocumentIam(v.Iam, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentStorageInfo(v *types.StorageInfo, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EbsStorageInfo != nil {
		ok := object.Key("ebsStorageInfo")
		if err := awsRestjson1_serializeDocumentEBSStorageInfo(v.EbsStorageInfo, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsRestjson1_serializeDocumentTls(v *types.Tls, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateAuthorityArnList != nil {
		ok := object.Key("certificateAuthorityArnList")
		if err := awsRestjson1_serializeDocument__listOf__string(v.CertificateAuthorityArnList, ok); err != nil {
			return err
		}
	}

	if v.Enabled {
		ok := object.Key("enabled")
		ok.Boolean(v.Enabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentUnauthenticated(v *types.Unauthenticated, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Enabled {
		ok := object.Key("enabled")
		ok.Boolean(v.Enabled)
	}

	return nil
}

func awsRestjson1_serializeDocumentVpcConfig(v *types.VpcConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SecurityGroupIds != nil {
		ok := object.Key("securityGroupIds")
		if err := awsRestjson1_serializeDocument__listOf__string(v.SecurityGroupIds, ok); err != nil {
			return err
		}
	}

	if v.SubnetIds != nil {
		ok := object.Key("subnetIds")
		if err := awsRestjson1_serializeDocument__listOf__string(v.SubnetIds, ok); err != nil {
			return err
		}
	}

	return nil
}
