// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Object specifying a stream’s audio configuration.
type AudioConfiguration struct {

	// Number of audio channels.
	Channels int64

	// Codec used for the audio encoding.
	Codec *string

	// Number of audio samples recorded per second.
	SampleRate int64

	// The expected ingest bitrate (bits per second). This is configured in the
	// encoder.
	TargetBitrate int64

	noSmithyDocumentSerde
}

// Error related to a specific channel, specified by its ARN.
type BatchError struct {

	// Channel ARN.
	Arn *string

	// Error code.
	Code *string

	// Error message, determined by the application.
	Message *string

	noSmithyDocumentSerde
}

// Object specifying a channel.
type Channel struct {

	// Channel ARN.
	Arn *string

	// Whether the channel is private (enabled for playback authorization). Default:
	// false.
	Authorized bool

	// Channel ingest endpoint, part of the definition of an ingest server, used when
	// you set up streaming software.
	IngestEndpoint *string

	// Channel latency mode. Use NORMAL to broadcast and deliver live video up to Full
	// HD. Use LOW for near-real-time interaction with viewers. Default: LOW. (Note: In
	// the Amazon IVS console, LOW and NORMAL correspond to Ultra-low and Standard,
	// respectively.)
	LatencyMode ChannelLatencyMode

	// Channel name.
	Name *string

	// Channel playback URL.
	PlaybackUrl *string

	// Recording-configuration ARN. A value other than an empty string indicates that
	// recording is enabled. Default: "" (empty string, recording is disabled).
	RecordingConfigurationArn *string

	// Array of 1-50 maps, each of the form string:string (key:value).
	Tags map[string]string

	// Channel type, which determines the allowable resolution and bitrate. If you
	// exceed the allowable resolution or bitrate, the stream probably will disconnect
	// immediately. Default: STANDARD. Valid values:
	//
	// * STANDARD: Multiple qualities
	// are generated from the original input, to automatically give viewers the best
	// experience for their devices and network conditions. Resolution can be up to
	// 1080p and bitrate can be up to 8.5 Mbps. Audio is transcoded only for renditions
	// 360p and below; above that, audio is passed through.
	//
	// * BASIC: Amazon IVS
	// delivers the original input to viewers. The viewer’s video-quality choice is
	// limited to the original input. Resolution can be up to 480p and bitrate can be
	// up to 1.5 Mbps.
	Type ChannelType

	noSmithyDocumentSerde
}

// Summary information about a channel.
type ChannelSummary struct {

	// Channel ARN.
	Arn *string

	// Whether the channel is private (enabled for playback authorization). Default:
	// false.
	Authorized bool

	// Channel latency mode. Use NORMAL to broadcast and deliver live video up to Full
	// HD. Use LOW for near-real-time interaction with viewers. Default: LOW. (Note: In
	// the Amazon IVS console, LOW and NORMAL correspond to Ultra-low and Standard,
	// respectively.)
	LatencyMode ChannelLatencyMode

	// Channel name.
	Name *string

	// Recording-configuration ARN. A value other than an empty string indicates that
	// recording is enabled. Default: "" (empty string, recording is disabled).
	RecordingConfigurationArn *string

	// Array of 1-50 maps, each of the form string:string (key:value).
	Tags map[string]string

	noSmithyDocumentSerde
}

// A complex type that describes a location where recorded videos will be stored.
// Each member represents a type of destination configuration. For recording, you
// define one and only one type of destination configuration.
type DestinationConfiguration struct {

	// An S3 destination configuration where recorded videos will be stored.
	S3 *S3DestinationConfiguration

	noSmithyDocumentSerde
}

// Object specifying the ingest configuration set up by the broadcaster, usually in
// an encoder.
type IngestConfiguration struct {

	// Encoder settings for audio.
	Audio *AudioConfiguration

	// Encoder settings for video.
	Video *VideoConfiguration

	noSmithyDocumentSerde
}

// A key pair used to sign and validate a playback authorization token.
type PlaybackKeyPair struct {

	// Key-pair ARN.
	Arn *string

	// Key-pair identifier.
	Fingerprint *string

	// Playback-key-pair name. The value does not need to be unique.
	Name *string

	// Array of 1-50 maps, each of the form string:string (key:value).
	Tags map[string]string

	noSmithyDocumentSerde
}

// Summary information about a playback key pair.
type PlaybackKeyPairSummary struct {

	// Key-pair ARN.
	Arn *string

	// Playback-key-pair name. The value does not need to be unique.
	Name *string

	// Array of 1-50 maps, each of the form string:string (key:value).
	Tags map[string]string

	noSmithyDocumentSerde
}

// An object representing a configuration to record a channel stream.
type RecordingConfiguration struct {

	// Recording-configuration ARN.
	//
	// This member is required.
	Arn *string

	// A complex type that contains information about where recorded video will be
	// stored.
	//
	// This member is required.
	DestinationConfiguration *DestinationConfiguration

	// Indicates the current state of the recording configuration. When the state is
	// ACTIVE, the configuration is ready for recording a channel stream.
	//
	// This member is required.
	State RecordingConfigurationState

	// Recording-configuration name. The value does not need to be unique.
	Name *string

	// Array of 1-50 maps, each of the form string:string (key:value).
	Tags map[string]string

	noSmithyDocumentSerde
}

// Summary information about a RecordingConfiguration.
type RecordingConfigurationSummary struct {

	// Recording-configuration ARN.
	//
	// This member is required.
	Arn *string

	// A complex type that contains information about where recorded video will be
	// stored.
	//
	// This member is required.
	DestinationConfiguration *DestinationConfiguration

	// Indicates the current state of the recording configuration. When the state is
	// ACTIVE, the configuration is ready for recording a channel stream.
	//
	// This member is required.
	State RecordingConfigurationState

	// Recording-configuration name. The value does not need to be unique.
	Name *string

	// Array of 1-50 maps, each of the form string:string (key:value).
	Tags map[string]string

	noSmithyDocumentSerde
}

// A complex type that describes an S3 location where recorded videos will be
// stored.
type S3DestinationConfiguration struct {

	// Location (S3 bucket name) where recorded videos will be stored.
	//
	// This member is required.
	BucketName *string

	noSmithyDocumentSerde
}

// Specifies a live video stream that has been ingested and distributed.
type Stream struct {

	// Channel ARN for the stream.
	ChannelArn *string

	// The stream’s health.
	Health StreamHealth

	// URL of the master playlist, required by the video player to play the HLS stream.
	PlaybackUrl *string

	// Time of the stream’s start. This is an ISO 8601 timestamp returned as a string.
	StartTime *time.Time

	// The stream’s state.
	State StreamState

	// Unique identifier for a live or previously live stream in the specified channel.
	StreamId *string

	// A count of concurrent views of the stream. Typically, a new view appears in
	// viewerCount within 15 seconds of when video playback starts and a view is
	// removed from viewerCount within 1 minute of when video playback ends. A value of
	// -1 indicates that the request timed out; in this case, retry.
	ViewerCount int64

	noSmithyDocumentSerde
}

// Object specifying a stream’s events. For a list of events, see Using Amazon
// EventBridge with Amazon IVS
// (https://docs.aws.amazon.com/ivs/latest/userguide/eventbridge.html).
type StreamEvent struct {

	// UTC ISO-8601 formatted timestamp of when the event occurred.
	EventTime *time.Time

	// Name that identifies the stream event within a type.
	Name *string

	// Logical group for certain events.
	Type *string

	noSmithyDocumentSerde
}

// Object specifying the stream attribute on which to filter.
type StreamFilters struct {

	// The stream’s health.
	Health StreamHealth

	noSmithyDocumentSerde
}

// Object specifying a stream key.
type StreamKey struct {

	// Stream-key ARN.
	Arn *string

	// Channel ARN for the stream.
	ChannelArn *string

	// Array of 1-50 maps, each of the form string:string (key:value).
	Tags map[string]string

	// Stream-key value.
	Value *string

	noSmithyDocumentSerde
}

// Summary information about a stream key.
type StreamKeySummary struct {

	// Stream-key ARN.
	Arn *string

	// Channel ARN for the stream.
	ChannelArn *string

	// Array of 1-50 maps, each of the form string:string (key:value).
	Tags map[string]string

	noSmithyDocumentSerde
}

// Object that captures the Amazon IVS configuration that the customer provisioned,
// the ingest configurations that the broadcaster used, and the most recent Amazon
// IVS stream events it encountered.
type StreamSession struct {

	// The properties of the channel at the time of going live.
	Channel *Channel

	// UTC ISO-8601 formatted timestamp of when the channel went offline. For live
	// streams, this is NULL.
	EndTime *time.Time

	// The properties of the incoming RTMP stream for the stream.
	IngestConfiguration *IngestConfiguration

	// The properties of recording the live stream.
	RecordingConfiguration *RecordingConfiguration

	// UTC ISO-8601 formatted timestamp of when the channel went live.
	StartTime *time.Time

	// Unique identifier for a live or previously live stream in the specified channel.
	StreamId *string

	// List of Amazon IVS events that the stream encountered. The list is sorted by
	// most recent events and contains up to 500 events. For Amazon IVS events, see
	// Using Amazon EventBridge with Amazon IVS
	// (https://docs.aws.amazon.com/ivs/latest/userguide/eventbridge.html).
	TruncatedEvents []StreamEvent

	noSmithyDocumentSerde
}

// Summary information about a stream session.
type StreamSessionSummary struct {

	// UTC ISO-8601 formatted timestamp of when the channel went offline. For live
	// streams, this is NULL.
	EndTime *time.Time

	// If true, this stream encountered a quota breach or failure.
	HasErrorEvent bool

	// UTC ISO-8601 formatted timestamp of when the channel went live.
	StartTime *time.Time

	// Unique identifier for a live or previously live stream in the specified channel.
	StreamId *string

	noSmithyDocumentSerde
}

// Summary information about a stream.
type StreamSummary struct {

	// Channel ARN for the stream.
	ChannelArn *string

	// The stream’s health.
	Health StreamHealth

	// Time of the stream’s start. This is an ISO 8601 timestamp returned as a string.
	StartTime *time.Time

	// The stream’s state.
	State StreamState

	// Unique identifier for a live or previously live stream in the specified channel.
	StreamId *string

	// A count of concurrent views of the stream. Typically, a new view appears in
	// viewerCount within 15 seconds of when video playback starts and a view is
	// removed from viewerCount within 1 minute of when video playback ends. A value of
	// -1 indicates that the request timed out; in this case, retry.
	ViewerCount int64

	noSmithyDocumentSerde
}

// Object specifying a stream’s video configuration.
type VideoConfiguration struct {

	// Indicates the degree of required decoder performance for a profile. Normally
	// this is set automatically by the encoder. For details, see the H.264
	// specification.
	AvcLevel *string

	// Indicates to the decoder the requirements for decoding the stream. For
	// definitions of the valid values, see the H.264 specification.
	AvcProfile *string

	// Codec used for the video encoding.
	Codec *string

	// Software or hardware used to encode the video.
	Encoder *string

	// The expected ingest bitrate (bits per second). This is configured in the
	// encoder.
	TargetBitrate int64

	// The expected ingest framerate. This is configured in the encoder.
	TargetFramerate int64

	// Video-resolution height in pixels.
	VideoHeight int64

	// Video-resolution width in pixels.
	VideoWidth int64

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
