// Code generated by smithy-go-codegen DO NOT EDIT.

package imagebuilder

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/imagebuilder/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns a list of distribution configurations.
func (c *Client) ListDistributionConfigurations(ctx context.Context, params *ListDistributionConfigurationsInput, optFns ...func(*Options)) (*ListDistributionConfigurationsOutput, error) {
	if params == nil {
		params = &ListDistributionConfigurationsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDistributionConfigurations", params, optFns, c.addOperationListDistributionConfigurationsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDistributionConfigurationsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListDistributionConfigurationsInput struct {

	// You can filter on name to streamline results.
	Filters []types.Filter

	// The maximum items to return in a request.
	MaxResults int32

	// A token to specify where to start paginating. This is the NextToken from a
	// previously truncated response.
	NextToken *string

	noSmithyDocumentSerde
}

type ListDistributionConfigurationsOutput struct {

	// The list of distributions.
	DistributionConfigurationSummaryList []types.DistributionConfigurationSummary

	// The next token used for paginated responses. When this is not empty, there are
	// additional elements that the service has not included in this request. Use this
	// token with the next request to retrieve additional objects.
	NextToken *string

	// The request ID that uniquely identifies this request.
	RequestId *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDistributionConfigurationsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListDistributionConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListDistributionConfigurations{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDistributionConfigurations(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListDistributionConfigurationsAPIClient is a client that implements the
// ListDistributionConfigurations operation.
type ListDistributionConfigurationsAPIClient interface {
	ListDistributionConfigurations(context.Context, *ListDistributionConfigurationsInput, ...func(*Options)) (*ListDistributionConfigurationsOutput, error)
}

var _ ListDistributionConfigurationsAPIClient = (*Client)(nil)

// ListDistributionConfigurationsPaginatorOptions is the paginator options for
// ListDistributionConfigurations
type ListDistributionConfigurationsPaginatorOptions struct {
	// The maximum items to return in a request.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDistributionConfigurationsPaginator is a paginator for
// ListDistributionConfigurations
type ListDistributionConfigurationsPaginator struct {
	options   ListDistributionConfigurationsPaginatorOptions
	client    ListDistributionConfigurationsAPIClient
	params    *ListDistributionConfigurationsInput
	nextToken *string
	firstPage bool
}

// NewListDistributionConfigurationsPaginator returns a new
// ListDistributionConfigurationsPaginator
func NewListDistributionConfigurationsPaginator(client ListDistributionConfigurationsAPIClient, params *ListDistributionConfigurationsInput, optFns ...func(*ListDistributionConfigurationsPaginatorOptions)) *ListDistributionConfigurationsPaginator {
	if params == nil {
		params = &ListDistributionConfigurationsInput{}
	}

	options := ListDistributionConfigurationsPaginatorOptions{}
	if params.MaxResults != 0 {
		options.Limit = params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDistributionConfigurationsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDistributionConfigurationsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDistributionConfigurations page.
func (p *ListDistributionConfigurationsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDistributionConfigurationsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	params.MaxResults = p.options.Limit

	result, err := p.client.ListDistributionConfigurations(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListDistributionConfigurations(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "imagebuilder",
		OperationName: "ListDistributionConfigurations",
	}
}
